/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.core;

import com.hanshow.cdi.core.BatchCreator;
import com.hanshow.cdi.diff.DifferenceHandler;
import com.hanshow.cdi.io.Line;
import com.hanshow.cdi.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifferentRecordHandler
implements DifferenceHandler<Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(DifferentRecordHandler.class);
    private String key;
    private BatchCreator batchCreator;

    public DifferentRecordHandler(String key, BatchCreator batchCreator) {
        this.batchCreator = batchCreator;
        this.key = key;
    }

    @Override
    public Map<String, Object> parse(Line line) {
        try {
            return line == null ? null : Utils.parseToMap(line.getText());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("parse line to JSON failed: " + line, e);
        }
    }

    @Override
    public String getKey(Map<String, Object> record) {
        StringBuilder sb = new StringBuilder();
        if (!record.containsKey(this.key)) {
            throw new IllegalArgumentException("cannot find record key: " + this.key);
        }
        Object keyValue = record.get(this.key);
        if (keyValue == null) {
            throw new IllegalArgumentException("key value cannot be null: " + this.key);
        }
        sb.append(keyValue).append('-');
        return sb.toString();
    }

    @Override
    public String format(Map<String, Object> record) {
        try {
            ArrayList<String> nameList = new ArrayList<String>(record.keySet().size());
            nameList.addAll(record.keySet());
            Collections.sort(nameList);
            LinkedHashMap sorted = new LinkedHashMap();
            nameList.forEach(name -> sorted.put(name, record.get(name)));
            return Utils.toJsonString(sorted);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("format record to JSON failed.", e);
        }
    }

    @Override
    public void update(Map<String, Object> left, Map<String, Object> right) {
        try {
            this.batchCreator.add(right);
        }
        catch (Exception e) {
            throw new RuntimeException("send changed record to server error: " + right, e);
        }
    }

    @Override
    public void insert(Map<String, Object> line) {
        try {
            this.batchCreator.add(line);
        }
        catch (Exception e) {
            throw new RuntimeException("send new record to server error: " + line, e);
        }
    }

    @Override
    public void delete(Map<String, Object> line) {
        try {
            logger.debug("find deleted record: " + Utils.toJsonString(line));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

