/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.core;

import com.hanshow.cdi.io.KeyedLine;
import com.hanshow.cdi.io.Line;
import com.hanshow.cdi.io.LineReader;
import com.hanshow.cdi.util.FileUtils;
import com.hanshow.cdi.util.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class FileLineSorter {
    private static final Logger log = LogManager.getLogger(FileLineSorter.class);
    public static int FRAGMENT_LINES;
    public static ThreadPoolTaskExecutor softFilePoolTaskExecutor;
    public static long sortInterval;
    public static int sortThreadNum;

    public static <T> File sort(File src, File target, File tmpDir, KeyedLine<T> keyedLine) throws Exception {
        tmpDir.mkdirs();
        LinkedList<File> files = FileLineSorter.splitFile(src, tmpDir, keyedLine);
        if (files.size() > 50) {
            LinkedList newFiles = new LinkedList();
            List<List<File>> filesList = FileLineSorter.splitList(files, sortThreadNum);
            CountDownLatch threadsSignal = new CountDownLatch(filesList.size());
            for (List<File> fileList : filesList) {
                softFilePoolTaskExecutor.submit(() -> {
                    block9: {
                        try {
                            LinkedList<File> temp = new LinkedList<File>(fileList);
                            FileLineSorter.begin(temp, tmpDir, keyedLine);
                            if (temp.size() == 1) {
                                LinkedList linkedList = newFiles;
                                synchronized (linkedList) {
                                    newFiles.addAll(temp);
                                    break block9;
                                }
                            }
                            throw new Exception("the list size not 1");
                        }
                        catch (Exception e) {
                            log.error("{}", (Object)e.getMessage());
                        }
                        finally {
                            threadsSignal.countDown();
                        }
                    }
                });
            }
            threadsSignal.await();
            files.clear();
            filesList.clear();
            files.addAll(newFiles);
            newFiles.clear();
        }
        FileLineSorter.begin(files, tmpDir, keyedLine);
        File result = files.poll();
        Utils.copyFile(result, target);
        result.delete();
        return target;
    }

    private static <T> void begin(LinkedList<File> files, File tmpDir, KeyedLine<T> keyedLine) throws Exception {
        while (files.size() > 1) {
            File f1 = files.poll();
            File f2 = files.poll();
            files.addFirst(FileLineSorter.mergeSort(f1, f2, tmpDir, keyedLine));
            f1.delete();
            f2.delete();
            Utils.sleep(sortInterval);
        }
    }

    private static List<List<File>> splitList(List<File> list, int groupSize) {
        int length = list.size();
        int num = (length + groupSize - 1) / groupSize;
        ArrayList<List<File>> newList = new ArrayList<List<File>>(groupSize);
        for (int i = 0; i < groupSize; ++i) {
            int fromIndex = i * num;
            int toIndex = Math.min((i + 1) * num, length);
            newList.add(list.subList(fromIndex, toIndex));
        }
        return newList;
    }

    private static <T> File mergeSort(File f1, File f2, File tmpDir, KeyedLine<T> keyedLine) throws Exception {
        Object left = null;
        Object right = null;
        Line leftLine = null;
        Line rightLine = null;
        File result = new File(tmpDir, Long.toString(Utils.createId()));
        try (LineReader leftReader = new LineReader(f1);
             LineReader rightReader = new LineReader(f2);
             PrintWriter writer = new PrintWriter(new FileWriter(result));){
            boolean forward1 = true;
            boolean forward2 = true;
            while (true) {
                if (forward1) {
                    leftLine = leftReader.readLine();
                    left = keyedLine.parse(leftLine);
                }
                if (forward2) {
                    rightLine = rightReader.readLine();
                    right = keyedLine.parse(rightLine);
                }
                if (left == null && right == null) {
                    break;
                }
                int diff = keyedLine.compareKey(left, right);
                if (diff < 0) {
                    writer.println(keyedLine.format(left));
                    forward1 = true;
                    forward2 = false;
                } else if (diff > 0) {
                    writer.println(keyedLine.format(right));
                    forward1 = false;
                    forward2 = true;
                } else {
                    writer.println(keyedLine.format(right));
                    forward2 = true;
                    forward1 = true;
                    log.warn("two lines' key is duplicated." + keyedLine.format(right));
                }
                writer.flush();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("sort file error, left=" + leftLine + " right=" + rightLine);
        }
        return result;
    }

    private static <T> LinkedList<File> splitFile(File src, File tmpDir, KeyedLine<T> keyedLine) throws Exception {
        LinkedList<File> files = new LinkedList<File>();
        try (LineReader reader = new LineReader(src);){
            List<Object> lines;
            while ((lines = FileLineSorter.readLines(reader, FRAGMENT_LINES, keyedLine)) != null) {
                Collections.sort(lines, keyedLine::compareKey);
                File fragment = new File(tmpDir, Long.toString(Utils.createId()));
                try (PrintWriter writer = new PrintWriter(new FileWriter(fragment));){
                    lines.forEach(l -> writer.println(keyedLine.format(l)));
                    writer.flush();
                }
                files.add(fragment);
            }
        }
        return files;
    }

    private static <T> List<T> readLines(LineReader reader, int maxLines, KeyedLine<T> keyedLine) {
        Line line;
        ArrayList<T> lines = null;
        for (int num = 0; num < maxLines && (line = reader.readLine()) != null; ++num) {
            if (lines == null) {
                lines = new ArrayList<T>();
            }
            lines.add(keyedLine.parse(line));
        }
        return lines;
    }

    public static void kunSort(File src, File target, File tmpDir, String recordKey) throws Exception {
        if (!tmpDir.exists() || !tmpDir.isDirectory()) {
            tmpDir.mkdirs();
        }
        long begin = System.currentTimeMillis();
        List<File> files = FileUtils.createChunkFiles(src, tmpDir, FRAGMENT_LINES);
        long split = System.currentTimeMillis();
        for (File file : files) {
            FileUtils.sortChunkFile(file, recordKey);
        }
        long sort = System.currentTimeMillis();
        FileLineSorter.mergeSortedChunkFiles(files, target.getAbsolutePath(), recordKey);
        long merge = System.currentTimeMillis();
        log.info("file={}, chunk={}, sort={}, merge={}, total={}", (Object)src.getName(), (Object)(split - begin), (Object)(sort - split), (Object)(merge - sort), (Object)(merge - begin));
    }

    public static void mergeSortedChunkFiles(List<File> chunkFiles, String outputFilePath, String recordKey) throws IOException {
        PriorityQueue<FileUtils.ChunkReader> minHeap = new PriorityQueue<FileUtils.ChunkReader>(Comparator.comparing(s -> s.getCurrentLineWithKey()));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(outputFilePath, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
            for (File chunkFile : chunkFiles) {
                FileUtils.ChunkReader reader = new FileUtils.ChunkReader(chunkFile, recordKey);
                if (reader.existNext()) {
                    minHeap.offer(reader);
                    continue;
                }
                reader.close();
            }
            while (!minHeap.isEmpty()) {
                FileUtils.ChunkReader reader = minHeap.poll();
                String line = reader.getCurrentLine();
                writer.write(line);
                writer.newLine();
                if (reader.hasNext()) {
                    minHeap.offer(reader);
                    continue;
                }
                reader.close();
            }
        }
    }
}

