/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.hanshow.cdi.core.BatchRecord;
import com.hanshow.cdi.core.ServerMode;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.cdi.service.CdiService;
import com.hanshow.cdi.service.StoreService;
import com.hanshow.cdi.util.OkHttpClientWrap;
import com.hanshow.cdi.util.OkHttpsCertClientWrap;
import com.hanshow.cdi.util.OkHttpsClientWrap;
import com.hanshow.cdi.util.Utils;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerSender
implements Runnable {
    private static final Logger log = LogManager.getLogger(ServerSender.class);
    private Map<String, OkHttpsCertClientWrap> okHttpsCertClientWrapMap;
    private OkHttpsClientWrap okHttpsClientWrap;
    private OkHttpClientWrap okHttpClientWrap;
    private static final long RETRY_INTERVAL = 60000L;
    private Lock lock;
    private CdiProperties cdiProperties;
    private int workers;
    private Thread integratorThread;
    private Processor[] processors;
    private Map<Integer, LinkedBlockingDeque<String>> processorQueue = new HashMap<Integer, LinkedBlockingDeque<String>>();
    private CdiService cdiService;
    private StoreService storeService;
    private Map<String, Map<String, Boolean>> useCertificateUrlMap;

    public ServerSender(CdiProperties cdiProperties, CdiService cdiService, StoreService storeService, OkHttpClientWrap okHttpClientWrap, OkHttpsClientWrap okHttpsClientWrap, Map<String, OkHttpsCertClientWrap> okHttpsCertClientWrap, Map<String, Map<String, Boolean>> useCertificateUrlMap) {
        int i;
        this.cdiService = cdiService;
        this.storeService = storeService;
        this.cdiProperties = cdiProperties;
        this.useCertificateUrlMap = useCertificateUrlMap;
        this.workers = cdiProperties.getCdiSystem().getSenderWorkerNum();
        this.lock = new ReentrantLock();
        for (i = 0; i < this.workers; ++i) {
            this.processorQueue.put(i, new LinkedBlockingDeque());
        }
        this.processors = new Processor[this.workers];
        for (i = 0; i < this.workers; ++i) {
            this.processors[i] = new Processor(i);
        }
        this.okHttpClientWrap = okHttpClientWrap;
        this.okHttpsClientWrap = okHttpsClientWrap;
        this.okHttpsCertClientWrapMap = okHttpsCertClientWrap;
    }

    public void start() {
        this.integratorThread = new Thread((Runnable)this, "ServerReSender");
        this.integratorThread.start();
    }

    public void stop() {
        if (this.integratorThread != null) {
            this.integratorThread = null;
        }
    }

    public void touch(String storeCode) {
        this.submit(storeCode);
    }

    @Override
    public void run() {
        List<Map<String, Object>> storeList = this.cdiService.getStoreCodeList();
        storeList.forEach(store -> this.submit(store.get("store_code").toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkKeyFromQueue(LinkedBlockingDeque<String> queue, String key) {
        this.lock.lock();
        try {
            boolean bl = queue.contains(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void submit(String storeCode) {
        Integer workerNum = Math.abs(storeCode.hashCode() % this.workers);
        if (!this.checkKeyFromQueue(this.processorQueue.get(workerNum), storeCode)) {
            this.processorQueue.get(workerNum).add(storeCode);
        }
    }

    private boolean processBatchRecord(BatchRecord record, int i) {
        record.setAmount(JSON.parseObject((String)record.getData()).get((Object)"batchSize").toString());
        String response = "";
        int loop = i + 1;
        if (loop > 3) {
            return false;
        }
        boolean flag = true;
        boolean useCertificate = false;
        String originalUrl = record.getServerUrl();
        if (!record.getServerUrl().contains("shopweb")) {
            originalUrl = record.getServerUrl().substring(0, record.getServerUrl().lastIndexOf("/", record.getServerUrl().lastIndexOf("/") - 1));
        }
        log.info("sending batch data to {} server url : [{}], batchId : [{}]", (Object)record.getStoreCode(), (Object)record.getServerUrl(), (Object)record.getBatchId());
        try {
            log.debug("request Body : {}", (Object)record.getData());
            if (record.getServerUrl().toUpperCase().startsWith("HTTPS")) {
                useCertificate = this.useCertificateUrlMap.get(record.getTaskName()).get(originalUrl) == null ? false : this.useCertificateUrlMap.get(record.getTaskName()).get(originalUrl);
                response = this.okHttpsCertClientWrapMap.containsKey(record.getCustomerStoreCode()) && useCertificate ? this.okHttpsCertClientWrapMap.get(record.getCustomerStoreCode()).postJsonToURLByAkSk(record.getServerUrl(), record.getData(), this.cdiProperties.getCdiSystem().getCharset(), record.getCustomerStoreCode(), record.getStoreCode()) : this.okHttpsClientWrap.postJsonToURLByAkSk(record.getServerUrl(), record.getData(), this.cdiProperties.getCdiSystem().getCharset(), record.getCustomerStoreCode(), record.getStoreCode());
                log.info("response body : {}", (Object)response);
            } else if (record.getServerUrl().toUpperCase().startsWith("HTTP")) {
                response = this.okHttpClientWrap.postJsonToURLByAkSk(record.getServerUrl(), record.getData(), this.cdiProperties.getCdiSystem().getCharset(), record.getCustomerStoreCode(), record.getStoreCode());
                log.info("response body : {}", (Object)response);
            }
        }
        catch (ConnectException ce) {
            flag = false;
            log.warn("send batch data to {} server failed due to cannot connect server.", (Object)record.getStoreCode());
        }
        catch (InvalidKeyException e) {
            flag = false;
            log.warn("send batch data to {} server failed due to invalid Ak/Sk.", (Object)record.getStoreCode(), (Object)e);
        }
        catch (Exception e) {
            flag = false;
            log.warn("send batch data to {} server failed, error msg : {}", (Object)record.getStoreCode(), (Object)e);
        }
        if (flag) {
            try {
                Map<String, Object> map = Utils.parseToMap(response);
                Integer resultCode = (Integer)map.get("resultCode");
                if (!resultCode.equals(ServerMode.PRISMART.getNum()) && !resultCode.equals(ServerMode.SHOPWEB.getNum())) {
                    if (resultCode.equals(1010)) {
                        log.warn("send batch {} to {} failed, reason: internal error", (Object)record.getBatchId(), (Object)record.getStoreCode());
                        flag = this.processBatchRecord(record, loop);
                    } else if (resultCode.equals(1012)) {
                        JSONObject jsonObject = JSON.parseObject((String)response);
                        JSONArray failedList = jsonObject.getJSONArray("message");
                        String success = Integer.parseInt(record.getAmount()) - failedList.size() + "";
                        this.storeService.updateAfterSend(record.getBatchId(), success, failedList.size() + "", record.getTaskName());
                        log.error("send batch data to {} server partial success, success num : {}; failed num : {}; failed list is : {}", (Object)record.getStoreCode(), (Object)success, (Object)failedList.size(), (Object)failedList);
                    } else if (resultCode.equals(ServerMode.TOO_MANY_REQUEST.getNum())) {
                        log.warn("too many request, retry after 1 minute");
                        Utils.sleep(60000L);
                        flag = this.processBatchRecord(record, loop - 1);
                    } else if (map.get("message").toString().equals("no permission") || map.get("message").toString().contains("Nonexistent store")) {
                        log.error("{} server reject to receive batch data, reason: {}", (Object)record.getStoreCode(), (Object)response);
                        this.storeService.updateAfterSend(record.getBatchId(), "0", record.getAmount(), record.getTaskName());
                    } else {
                        log.error("{} server reject to receive batch data, reason: {}, \r\n data : {}", (Object)record.getStoreCode(), (Object)response, (Object)record.getData());
                        this.storeService.updateAfterSend(record.getBatchId(), "0", record.getAmount(), record.getTaskName());
                    }
                } else {
                    this.storeService.updateAfterSend(record.getBatchId(), record.getAmount(), "0", record.getTaskName());
                    log.info("send batch data to {} server succeed, batchId: {}", (Object)record.getStoreCode(), (Object)record.getBatchId());
                }
            }
            catch (Exception e) {
                log.error("response returned by {} server is exceptional: {}", (Object)record.getStoreCode(), (Object)(response + e.getMessage() + e));
            }
        }
        return flag;
    }

    public Map<String, OkHttpsCertClientWrap> getOkHttpsCertClientWrapMap() {
        return this.okHttpsCertClientWrapMap;
    }

    public OkHttpsClientWrap getOkHttpsClientWrap() {
        return this.okHttpsClientWrap;
    }

    public OkHttpClientWrap getOkHttpClientWrap() {
        return this.okHttpClientWrap;
    }

    public Lock getLock() {
        return this.lock;
    }

    public CdiProperties getCdiProperties() {
        return this.cdiProperties;
    }

    public int getWorkers() {
        return this.workers;
    }

    public Thread getIntegratorThread() {
        return this.integratorThread;
    }

    public Processor[] getProcessors() {
        return this.processors;
    }

    public Map<Integer, LinkedBlockingDeque<String>> getProcessorQueue() {
        return this.processorQueue;
    }

    public CdiService getCdiService() {
        return this.cdiService;
    }

    public StoreService getStoreService() {
        return this.storeService;
    }

    public Map<String, Map<String, Boolean>> getUseCertificateUrlMap() {
        return this.useCertificateUrlMap;
    }

    public void setOkHttpsCertClientWrapMap(Map<String, OkHttpsCertClientWrap> okHttpsCertClientWrapMap) {
        this.okHttpsCertClientWrapMap = okHttpsCertClientWrapMap;
    }

    public void setOkHttpsClientWrap(OkHttpsClientWrap okHttpsClientWrap) {
        this.okHttpsClientWrap = okHttpsClientWrap;
    }

    public void setOkHttpClientWrap(OkHttpClientWrap okHttpClientWrap) {
        this.okHttpClientWrap = okHttpClientWrap;
    }

    public void setLock(Lock lock) {
        this.lock = lock;
    }

    public void setCdiProperties(CdiProperties cdiProperties) {
        this.cdiProperties = cdiProperties;
    }

    public void setWorkers(int workers) {
        this.workers = workers;
    }

    public void setIntegratorThread(Thread integratorThread) {
        this.integratorThread = integratorThread;
    }

    public void setProcessors(Processor[] processors) {
        this.processors = processors;
    }

    public void setProcessorQueue(Map<Integer, LinkedBlockingDeque<String>> processorQueue) {
        this.processorQueue = processorQueue;
    }

    public void setCdiService(CdiService cdiService) {
        this.cdiService = cdiService;
    }

    public void setStoreService(StoreService storeService) {
        this.storeService = storeService;
    }

    public void setUseCertificateUrlMap(Map<String, Map<String, Boolean>> useCertificateUrlMap) {
        this.useCertificateUrlMap = useCertificateUrlMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerSender)) {
            return false;
        }
        ServerSender other = (ServerSender)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorkers() != other.getWorkers()) {
            return false;
        }
        Map<String, OkHttpsCertClientWrap> this$okHttpsCertClientWrapMap = this.getOkHttpsCertClientWrapMap();
        Map<String, OkHttpsCertClientWrap> other$okHttpsCertClientWrapMap = other.getOkHttpsCertClientWrapMap();
        if (this$okHttpsCertClientWrapMap == null ? other$okHttpsCertClientWrapMap != null : !((Object)this$okHttpsCertClientWrapMap).equals(other$okHttpsCertClientWrapMap)) {
            return false;
        }
        OkHttpsClientWrap this$okHttpsClientWrap = this.getOkHttpsClientWrap();
        OkHttpsClientWrap other$okHttpsClientWrap = other.getOkHttpsClientWrap();
        if (this$okHttpsClientWrap == null ? other$okHttpsClientWrap != null : !this$okHttpsClientWrap.equals(other$okHttpsClientWrap)) {
            return false;
        }
        OkHttpClientWrap this$okHttpClientWrap = this.getOkHttpClientWrap();
        OkHttpClientWrap other$okHttpClientWrap = other.getOkHttpClientWrap();
        if (this$okHttpClientWrap == null ? other$okHttpClientWrap != null : !this$okHttpClientWrap.equals(other$okHttpClientWrap)) {
            return false;
        }
        Lock this$lock = this.getLock();
        Lock other$lock = other.getLock();
        if (this$lock == null ? other$lock != null : !this$lock.equals(other$lock)) {
            return false;
        }
        CdiProperties this$cdiProperties = this.getCdiProperties();
        CdiProperties other$cdiProperties = other.getCdiProperties();
        if (this$cdiProperties == null ? other$cdiProperties != null : !((Object)this$cdiProperties).equals(other$cdiProperties)) {
            return false;
        }
        Thread this$integratorThread = this.getIntegratorThread();
        Thread other$integratorThread = other.getIntegratorThread();
        if (this$integratorThread == null ? other$integratorThread != null : !this$integratorThread.equals(other$integratorThread)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getProcessors(), other.getProcessors())) {
            return false;
        }
        Map<Integer, LinkedBlockingDeque<String>> this$processorQueue = this.getProcessorQueue();
        Map<Integer, LinkedBlockingDeque<String>> other$processorQueue = other.getProcessorQueue();
        if (this$processorQueue == null ? other$processorQueue != null : !((Object)this$processorQueue).equals(other$processorQueue)) {
            return false;
        }
        CdiService this$cdiService = this.getCdiService();
        CdiService other$cdiService = other.getCdiService();
        if (this$cdiService == null ? other$cdiService != null : !this$cdiService.equals(other$cdiService)) {
            return false;
        }
        StoreService this$storeService = this.getStoreService();
        StoreService other$storeService = other.getStoreService();
        if (this$storeService == null ? other$storeService != null : !this$storeService.equals(other$storeService)) {
            return false;
        }
        Map<String, Map<String, Boolean>> this$useCertificateUrlMap = this.getUseCertificateUrlMap();
        Map<String, Map<String, Boolean>> other$useCertificateUrlMap = other.getUseCertificateUrlMap();
        return !(this$useCertificateUrlMap == null ? other$useCertificateUrlMap != null : !((Object)this$useCertificateUrlMap).equals(other$useCertificateUrlMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerSender;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWorkers();
        Map<String, OkHttpsCertClientWrap> $okHttpsCertClientWrapMap = this.getOkHttpsCertClientWrapMap();
        result = result * 59 + ($okHttpsCertClientWrapMap == null ? 43 : ((Object)$okHttpsCertClientWrapMap).hashCode());
        OkHttpsClientWrap $okHttpsClientWrap = this.getOkHttpsClientWrap();
        result = result * 59 + ($okHttpsClientWrap == null ? 43 : $okHttpsClientWrap.hashCode());
        OkHttpClientWrap $okHttpClientWrap = this.getOkHttpClientWrap();
        result = result * 59 + ($okHttpClientWrap == null ? 43 : $okHttpClientWrap.hashCode());
        Lock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        CdiProperties $cdiProperties = this.getCdiProperties();
        result = result * 59 + ($cdiProperties == null ? 43 : ((Object)$cdiProperties).hashCode());
        Thread $integratorThread = this.getIntegratorThread();
        result = result * 59 + ($integratorThread == null ? 43 : $integratorThread.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getProcessors());
        Map<Integer, LinkedBlockingDeque<String>> $processorQueue = this.getProcessorQueue();
        result = result * 59 + ($processorQueue == null ? 43 : ((Object)$processorQueue).hashCode());
        CdiService $cdiService = this.getCdiService();
        result = result * 59 + ($cdiService == null ? 43 : $cdiService.hashCode());
        StoreService $storeService = this.getStoreService();
        result = result * 59 + ($storeService == null ? 43 : $storeService.hashCode());
        Map<String, Map<String, Boolean>> $useCertificateUrlMap = this.getUseCertificateUrlMap();
        result = result * 59 + ($useCertificateUrlMap == null ? 43 : ((Object)$useCertificateUrlMap).hashCode());
        return result;
    }

    public String toString() {
        return "ServerSender(okHttpsCertClientWrapMap=" + this.getOkHttpsCertClientWrapMap() + ", okHttpsClientWrap=" + this.getOkHttpsClientWrap() + ", okHttpClientWrap=" + this.getOkHttpClientWrap() + ", lock=" + this.getLock() + ", cdiProperties=" + this.getCdiProperties() + ", workers=" + this.getWorkers() + ", integratorThread=" + this.getIntegratorThread() + ", processors=" + Arrays.deepToString(this.getProcessors()) + ", processorQueue=" + this.getProcessorQueue() + ", cdiService=" + this.getCdiService() + ", storeService=" + this.getStoreService() + ", useCertificateUrlMap=" + this.getUseCertificateUrlMap() + ")";
    }

    private class Processor
    implements Runnable {
        private Thread thread;

        private Processor(int num) {
            this.thread = new Thread((Runnable)this, "ServerSender-" + num);
            this.thread.start();
        }

        @Override
        public void run() {
            boolean isContinue = true;
            Integer workerNum = Thread.currentThread().getName().split("-")[1] == null ? 0 : Integer.valueOf(Thread.currentThread().getName().split("-")[1]);
            while (true) {
                try {
                    block4: while (true) {
                        String storeCode = (String)((LinkedBlockingDeque)ServerSender.this.processorQueue.get(workerNum)).take();
                        block5: while (isContinue) {
                            List<BatchRecord> batchList = ServerSender.this.cdiService.getOldestUnsendBatchByStore(storeCode);
                            if (batchList == null || batchList.size() <= 0) continue block4;
                            for (BatchRecord record : batchList) {
                                if (ServerSender.this.processBatchRecord(record, 0)) {
                                    ServerSender.this.cdiService.deleteBatchRecord(record);
                                    continue;
                                }
                                Utils.sleep(60000L);
                                ((LinkedBlockingDeque)ServerSender.this.processorQueue.get(workerNum)).add(storeCode);
                                isContinue = false;
                                continue block5;
                            }
                        }
                        isContinue = true;
                    }
                }
                catch (InterruptedException e) {
                    log.warn(String.format("Server sender processor %s error.", workerNum) + e);
                    continue;
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                    continue;
                }
                break;
            }
        }
    }
}

