/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.core;

import com.hanshow.cdi.core.BatchCreator;
import com.hanshow.cdi.core.CdiMode;
import com.hanshow.cdi.core.DifferentRecordHandler;
import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.core.UploadedFile;
import com.hanshow.cdi.diff.FileDifferenceComparator;
import com.hanshow.cdi.io.LineReader;
import com.hanshow.cdi.service.CdiService;
import com.hanshow.cdi.service.StoreService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UploadedFileProcessor {
    private static final Logger log = LogManager.getLogger(UploadedFileProcessor.class);
    GenericCdiServerContext serverContext;
    private static Processor[] processors;
    private static Lock lock;
    static FileDifferenceComparator fileComparator;
    private static Map<String, Integer> processorSelector;
    private static Map<Integer, Integer> processorLoad;
    private final CdiService cdiService;
    private final StoreService storeService;

    public UploadedFileProcessor(int threadsNum, GenericCdiServerContext serverContext, CdiService cdiService, StoreService storeService) {
        this.serverContext = serverContext;
        this.cdiService = cdiService;
        this.storeService = storeService;
        lock = new ReentrantLock();
        fileComparator = new FileDifferenceComparator();
        processorSelector = new HashMap<String, Integer>();
        processorLoad = new HashMap<Integer, Integer>();
        processors = new Processor[threadsNum];
        for (int i = 0; i < threadsNum; ++i) {
            UploadedFileProcessor.processors[i] = new Processor(i);
            processorLoad.put(i, 0);
        }
    }

    public void submit(UploadedFile uploadedFile) {
        int num = this.selectProcessor(uploadedFile);
        processors[num].submit(uploadedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int selectProcessor(UploadedFile uploadedFile) {
        lock.lock();
        try {
            Integer num = processorSelector.get(uploadedFile.getAbsoluteFile().getParentFile().getAbsolutePath());
            if (num == null) {
                int minLoad = Integer.MAX_VALUE;
                for (Map.Entry<Integer, Integer> e : processorLoad.entrySet()) {
                    if (e.getValue() >= minLoad) continue;
                    num = e.getKey();
                    minLoad = e.getValue();
                }
                processorSelector.put(uploadedFile.getAbsoluteFile().getParentFile().getAbsolutePath(), num);
                processorLoad.put(num, minLoad + 1);
            }
            int n = num;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    private class Processor
    implements Runnable {
        private LinkedBlockingDeque<UploadedFile> queue = new LinkedBlockingDeque();
        private Thread thread;

        Processor(int num) {
            this.thread = new Thread((Runnable)this, "uploadedFileProcessor-" + num);
            this.thread.start();
        }

        void submit(UploadedFile uploadFile) {
            this.queue.add(uploadFile);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        UploadedFile uploadedFile = this.queue.take();
                        if (UploadedFileProcessor.this.serverContext.getTaskMap().get(uploadedFile.getTaskName()).getCdiMode().equals(CdiMode.FULL.getName())) {
                            this.fullProcess(uploadedFile);
                            continue;
                        }
                        this.incrementProcess(uploadedFile);
                    }
                }
                catch (Throwable e) {
                    log.error("Process uploaded file error.", e);
                    continue;
                }
                break;
            }
        }

        private void fullProcess(UploadedFile uploadedFile) {
            BatchCreator batchCreator = new BatchCreator(uploadedFile, UploadedFileProcessor.this.cdiService, UploadedFileProcessor.this.serverContext.getCdiSystem().getMaxNumPerPost(), UploadedFileProcessor.this.serverContext.getTaskServerFieldsNameMap(), UploadedFileProcessor.this.serverContext.getTaskServerStoreCodeMap(), UploadedFileProcessor.this.serverContext.getTaskServerUrlMap(), UploadedFileProcessor.this.storeService);
            log.info("creating processing file: " + uploadedFile);
            try {
                uploadedFile.createProcessingFile();
            }
            catch (Exception e) {
                throw new RuntimeException("creating processing file error: " + uploadedFile);
            }
            DifferentRecordHandler handler = new DifferentRecordHandler(UploadedFileProcessor.this.serverContext.getTaskJsonRecordKeys().get(uploadedFile.getTaskName()), batchCreator);
            try (LineReader reader = new LineReader(uploadedFile.getProcessingFile());){
                Map record;
                while ((record = (Map)handler.parse(reader.readLine())) != null) {
                    handler.insert(record);
                }
                batchCreator.flush();
                log.info(String.format("uploaded file %s created %d batch includes %d items", uploadedFile.getFileName(), batchCreator.getBatchNum(), batchCreator.getItemsNum()));
                for (int i = 0; i < uploadedFile.getServerUrl().size(); ++i) {
                    UploadedFileProcessor.this.serverContext.getServerSender().touch(uploadedFile.getStoreCode() + "-" + i);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("flush uploaded file and send data to server error.", e);
            }
            finally {
                uploadedFile.getProcessingFile().delete();
            }
        }

        private void incrementProcess(UploadedFile uploadedFile) {
            BatchCreator batchCreator = new BatchCreator(uploadedFile, UploadedFileProcessor.this.cdiService, UploadedFileProcessor.this.serverContext.getCdiSystem().getMaxNumPerPost(), UploadedFileProcessor.this.serverContext.getTaskServerFieldsNameMap(), UploadedFileProcessor.this.serverContext.getTaskServerStoreCodeMap(), UploadedFileProcessor.this.serverContext.getTaskServerUrlMap(), UploadedFileProcessor.this.storeService);
            DifferentRecordHandler handler = new DifferentRecordHandler(UploadedFileProcessor.this.serverContext.getTaskJsonRecordKeys().get(uploadedFile.getTaskName()), batchCreator);
            log.info("sorting uploaded file: " + uploadedFile);
            try {
                if (UploadedFileProcessor.this.serverContext.isQuickSort()) {
                    uploadedFile.quickSort(UploadedFileProcessor.this.serverContext.getTaskJsonRecordKeys().get(uploadedFile.getTaskName()));
                } else {
                    uploadedFile.sort(handler);
                }
            }
            catch (Exception e) {
                log.error("sort file {} error, {}", (Object)uploadedFile.getFileName(), (Object)(e + e.getMessage()));
                throw new RuntimeException("sort uploaded file error: " + uploadedFile);
            }
            log.info("diff uploaded file with history backup: " + uploadedFile);
            try {
                if (uploadedFile.validateBackup()) {
                    fileComparator.diff(uploadedFile.getBackupFile(), uploadedFile.getSortedFile(), handler);
                } else {
                    try (LineReader reader = new LineReader(uploadedFile.getSortedFile());){
                        Map record;
                        while ((record = (Map)handler.parse(reader.readLine())) != null) {
                            handler.insert(record);
                        }
                    }
                    catch (Exception e) {
                        log.error("read sorted file failed, error msg : {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                batchCreator.flush();
                log.info(String.format("uploaded file %s created %d batch includes %d items", uploadedFile.getFileName(), batchCreator.getBatchNum(), batchCreator.getItemsNum()));
                for (int i = 0; i < uploadedFile.getServerUrl().size(); ++i) {
                    UploadedFileProcessor.this.serverContext.getServerSender().touch(uploadedFile.getStoreCode() + "-" + i);
                }
            }
            catch (Exception e) {
                log.error("diff uploaded file and send difference to server error.");
                log.info("delete this tmp file : {}", (Object)uploadedFile.getSortedFile().getAbsolutePath());
                uploadedFile.getSortedFile().delete();
                throw new RuntimeException("diff uploaded file and send difference to server error.", e);
            }
            log.info("backup uploaded file: " + uploadedFile);
            try {
                uploadedFile.backup();
            }
            catch (Exception e) {
                throw new RuntimeException("backup uploaded file error: " + uploadedFile);
            }
        }
    }
}

