/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.diff;

import com.hanshow.cdi.diff.DifferenceHandler;
import com.hanshow.cdi.diff.Segment;
import com.hanshow.cdi.io.LineReader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;

public class FileDifferenceComparator {
    private DiffAlgorithm diffAlgorithm = new HistogramDiff();

    public <T> EditList diff(File f1, File f2, DifferenceHandler<T> handler) throws Exception {
        RawText rt1 = new RawText(f1);
        RawText rt2 = new RawText(f2);
        EditList diffList = new EditList();
        diffList.addAll((Collection)this.diffAlgorithm.diff((SequenceComparator)RawTextComparator.WS_IGNORE_ALL, (Sequence)rt1, (Sequence)rt2));
        try (LineReader leftReader = new LineReader(f1);
             LineReader rightReader = new LineReader(f2);){
            this.travelDifference(leftReader, rightReader, diffList, handler);
        }
        return diffList;
    }

    public <T> EditList diff(String f1, String f2, DifferenceHandler<T> handler) throws Exception {
        return this.diff(new File(f1), new File(f2), handler);
    }

    private <T> void travelDifference(LineReader leftReader, LineReader rightReader, EditList diffList, DifferenceHandler<T> handler) throws IOException {
        if (diffList == null || diffList.size() == 0) {
            return;
        }
        diffList.forEach(edit -> {
            Segment left = new Segment(edit.getBeginA(), edit.getEndA(), edit.getLengthA(), leftReader);
            Segment right = new Segment(edit.getBeginB(), edit.getEndB(), edit.getLengthB(), rightReader);
            switch (edit.getType()) {
                case REPLACE: {
                    this.onReplace(left, right, handler);
                    break;
                }
                case DELETE: {
                    this.onDelete(left, right, handler);
                    break;
                }
                case INSERT: {
                    this.onInsert(left, right, handler);
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported Edit.Type " + edit.getType().name());
                }
            }
        });
    }

    private <T> void onReplace(Segment left, Segment right, DifferenceHandler<T> handler) {
        Object currentLeft = handler.parse(left.nextLine());
        Object currentRight = handler.parse(right.nextLine());
        while (true) {
            if (currentLeft != null && currentRight != null) {
                int keyDiff = handler.compareKey(currentLeft, currentRight);
                if (keyDiff == 0) {
                    handler.update(currentLeft, currentRight);
                    currentLeft = handler.parse(left.nextLine());
                    currentRight = handler.parse(right.nextLine());
                    continue;
                }
                if (keyDiff < 0) {
                    handler.delete(currentLeft);
                    currentLeft = handler.parse(left.nextLine());
                    continue;
                }
                handler.insert(currentRight);
                currentRight = handler.parse(right.nextLine());
                continue;
            }
            if (currentLeft == null && currentRight == null) break;
            if (currentLeft == null) {
                handler.insert(currentRight);
                currentRight = handler.parse(right.nextLine());
                continue;
            }
            handler.delete(currentLeft);
            currentLeft = handler.parse(left.nextLine());
        }
    }

    private <T> void onInsert(Segment left, Segment right, DifferenceHandler<T> handler) {
        for (int i = 0; i < right.getLength(); ++i) {
            handler.insert(handler.parse(right.nextLine()));
        }
    }

    private <T> void onDelete(Segment left, Segment right, DifferenceHandler<T> handler) {
        for (int i = 0; i < left.getLength(); ++i) {
            handler.delete(handler.parse(left.nextLine()));
        }
    }
}

