/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.ftp;

import com.hanshow.cdi.ftp.FtpEventListener;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.ftpserver.ConnectionConfigFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.ClearTextPasswordEncryptor;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;

public class FtpServerWrap {
    private InetSocketAddress address;
    private FtpServer server;

    public FtpServerWrap(InetSocketAddress address) {
        this.address = address;
        this.server = null;
    }

    private void prepareUserHome(UserManager userManager) throws FtpException {
        String[] users;
        for (String username : users = userManager.getAllUserNames()) {
            User user = userManager.getUserByName(username);
            File home = new File(user.getHomeDirectory());
            if (home.exists()) {
                if (!home.isDirectory()) {
                    throw new FtpException(String.format("home directory %s of user %s exists, but not a directory.", home, username));
                }
                if (home.canWrite()) continue;
                throw new FtpException(String.format("home directory %s of user %s exists, but hasn't write permission.", home, username));
            }
            if (home.mkdirs()) continue;
            throw new FtpException(String.format("home directory %s of user %s isn't exists, but no permission to create it.", home, username));
        }
    }

    public synchronized void start(File propsFile, FtpEventListener eventListener, int ftpMaxLogins) throws FtpException {
        if (this.server != null && !this.server.isStopped()) {
            throw new IllegalStateException("FtpServer is still running.");
        }
        FtpServerFactory serverFactory = new FtpServerFactory();
        PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
        userManagerFactory.setPasswordEncryptor((PasswordEncryptor)new ClearTextPasswordEncryptor());
        userManagerFactory.setFile(propsFile);
        UserManager userManager = userManagerFactory.createUserManager();
        this.prepareUserHome(userManager);
        serverFactory.setUserManager(userManager);
        ConnectionConfigFactory ccf = new ConnectionConfigFactory();
        ccf.setMaxLogins(ftpMaxLogins);
        ccf.setAnonymousLoginEnabled(false);
        ccf.setMaxAnonymousLogins(0);
        ccf.setMaxLoginFailures(3);
        ccf.setLoginFailureDelay(500);
        ccf.setMaxThreads(0);
        serverFactory.setConnectionConfig(ccf.createConnectionConfig());
        ListenerFactory listenerFactory = new ListenerFactory();
        String addr = this.address.getAddress().getHostAddress();
        listenerFactory.setServerAddress(addr);
        listenerFactory.setPort(this.address.getPort());
        serverFactory.addListener("default", listenerFactory.createListener());
        HashMap<String, FtpEventListener> ftplets = new HashMap<String, FtpEventListener>();
        if (eventListener == null) {
            eventListener = new FtpEventListener();
        }
        ftplets.put("ftpEventListener", eventListener);
        serverFactory.setFtplets(ftplets);
        this.server = serverFactory.createServer();
        this.server.start();
    }

    public synchronized void stop() throws FtpException {
        if (this.server != null && !this.server.isStopped()) {
            this.server.stop();
        }
        this.server = null;
    }
}

