/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.listener;

import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.core.IntegrationMode;
import com.hanshow.cdi.core.UploadedFile;
import com.hanshow.cdi.core.UploadedFileProcessor;
import com.hanshow.cdi.ftp.FtpEventListener;
import java.io.IOException;
import java.util.Set;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.FtpletResult;
import org.apache.ftpserver.ftplet.User;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUploadedListener
extends FtpEventListener {
    private static final Logger log = LogManager.getLogger(FileUploadedListener.class);
    private UploadedFileProcessor processor;
    private GenericCdiServerContext serverContext;

    public FileUploadedListener(GenericCdiServerContext serverContext, UploadedFileProcessor processor) {
        this.serverContext = serverContext;
        this.processor = processor;
    }

    @Override
    public FtpletResult onUploadEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        if (!"STOR".equalsIgnoreCase(request.getCommand())) {
            log.warn("-- On Upload End received non-STOR event.");
            return null;
        }
        User user = session.getUser();
        try {
            String workingDir = session.getFileSystemView().getWorkingDirectory().getAbsolutePath();
            String fileName = request.getArgument();
            String taskName = workingDir.split("/")[1];
            this.modeSelector(user, taskName, workingDir, fileName);
        }
        catch (Exception e) {
            log.error(String.format("process user %s uploaded file error.", user.getName()), (Throwable)e);
        }
        return FtpletResult.DEFAULT;
    }

    private void modeSelector(User user, String taskName, String workingDir, String fileName) {
        Set<String> serverUrl = this.serverContext.getTaskServerUrlMap().get(taskName).keySet();
        IntegrationMode im = IntegrationMode.getIntegrationMode(this.serverContext.getTaskMap().get(taskName).getIntegrationMode());
        switch (im) {
            case SERVER_FTP: {
                this.processorTriggerSelector(user, taskName, workingDir, fileName, serverUrl);
                break;
            }
            case CUSTOM_SERVER: {
                this.processorTriggerSelector(user, taskName, workingDir, fileName, serverUrl);
                break;
            }
            case CUSTOM_ALL: {
                this.processorTriggerSelector(user, taskName, workingDir, fileName, serverUrl);
                break;
            }
            default: {
                this.standardProcessorTrigger(user, taskName, workingDir, fileName, serverUrl);
            }
        }
    }

    private void processorTriggerSelector(User user, String taskName, String workingDir, String fileName, Set<String> serverUrl) {
        this.standardProcessorTrigger(user, taskName, workingDir, fileName, serverUrl);
    }

    private void standardProcessorTrigger(User user, String taskName, String workingDir, String fileName, Set<String> serverUrl) {
        UploadedFile uploadedFile = new UploadedFile(user.getName(), taskName, workingDir, fileName, this.serverContext.getRootDir(), this.serverContext.getTemporaryDir(), serverUrl, this.serverContext.getTaskServerFieldsNameMap().get(taskName).get("sku").getHanshow());
        log.info("received uploaded file: " + uploadedFile.getAbsoluteFile().getAbsolutePath());
        this.processor.submit(uploadedFile);
    }
}

