/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.listener;

import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.core.IntegrationMode;
import com.hanshow.cdi.core.UploadedFile;
import com.hanshow.cdi.core.UploadedFileProcessor;
import java.io.File;
import java.util.Set;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MsgFileListener
extends FileAlterationListenerAdaptor {
    private static final Logger log = LogManager.getLogger(MsgFileListener.class);
    private UploadedFileProcessor processor;
    private GenericCdiServerContext serverContext;

    public MsgFileListener(GenericCdiServerContext serverContext, UploadedFileProcessor processor) {
        this.serverContext = serverContext;
        this.processor = processor;
    }

    public void onStart(FileAlterationObserver observer) {
        super.onStart(observer);
    }

    public void onDirectoryCreate(File directory) {
        log.info("[Deleted Directory] : {}", (Object)directory.getAbsolutePath());
    }

    public void onDirectoryChange(File directory) {
        log.info("[Changed Directory] : {}", (Object)directory.getAbsolutePath());
    }

    public void onDirectoryDelete(File directory) {
        log.info("[Created Directory] : {}", (Object)directory.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFileCreate(File file) {
        log.info("[Created File] : {}", (Object)file.getAbsolutePath());
        try {
            String fileName = file.getName();
            String[] group = fileName.split("-");
            this.modeSelector(group[0], File.separator + group[1] + File.separator + group[2], fileName);
        }
        catch (Exception e) {
            log.error(String.format("process user %s uploaded file error.", file.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (file.exists()) {
                file.delete();
            }
        }
    }

    public void onFileChange(File file) {
        log.info("[Amended File] : {}", (Object)file.getAbsolutePath());
    }

    public void onFileDelete(File file) {
        log.info("[Deleted File] : {}", (Object)file.getAbsolutePath());
    }

    public void onStop(FileAlterationObserver observer) {
        super.onStop(observer);
    }

    private void modeSelector(String taskName, String workingDir, String fileName) {
        Set<String> serverUrl = this.serverContext.getTaskServerUrlMap().get(taskName).keySet();
        IntegrationMode im = IntegrationMode.getIntegrationMode(this.serverContext.getTaskMap().get(taskName).getIntegrationMode());
        switch (im) {
            case SERVER_FTP: {
                this.processorTriggerSelector(taskName, workingDir, fileName, serverUrl);
                break;
            }
            case CUSTOM_SERVER: {
                this.processorTriggerSelector(taskName, workingDir, fileName, serverUrl);
                break;
            }
            case CUSTOM_ALL: {
                this.processorTriggerSelector(taskName, workingDir, fileName, serverUrl);
                break;
            }
            default: {
                this.standardProcessorTrigger(taskName, workingDir, fileName, serverUrl);
            }
        }
    }

    private void processorTriggerSelector(String taskName, String workingDir, String fileName, Set<String> serverUrl) {
        this.standardProcessorTrigger(taskName, workingDir, fileName, serverUrl);
    }

    private void standardProcessorTrigger(String taskName, String workingDir, String fileName, Set<String> serverUrl) {
        UploadedFile uploadedFile = new UploadedFile(taskName, workingDir, fileName, this.serverContext.getRootDir(), this.serverContext.getTemporaryDir(), serverUrl, this.serverContext.getTaskServerFieldsNameMap().get(taskName).get("sku").getHanshow());
        log.info("received uploaded file: " + uploadedFile.getAbsoluteFile().getAbsolutePath());
        this.processor.submit(uploadedFile);
    }
}

