/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.service.impl;

import com.hanshow.cdi.core.BatchRecord;
import com.hanshow.cdi.dao.CdiMapper;
import com.hanshow.cdi.entity.StoreInfo;
import com.hanshow.cdi.service.CdiService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CdiServiceImpl
implements CdiService {
    @Autowired
    private CdiMapper dao;

    @Override
    public void insertBatch(BatchRecord record) {
        this.dao.insertBatch(record.getBatchId(), record.getData(), record.getTaskName(), record.getServerUrl(), record.getStoreCode(), record.getCustomerStoreCode());
    }

    @Override
    public List<StoreInfo> getStoreList() {
        LinkedList<StoreInfo> result = new LinkedList<StoreInfo>();
        List<Map<String, Object>> list = this.dao.queryStoreList();
        if (list == null || list.size() == 0) {
            return null;
        }
        list.forEach(r -> {
            StoreInfo storeSign = new StoreInfo();
            storeSign.setStoreCode(r.get("store_code").toString());
            storeSign.setStatus(Integer.valueOf(((Map)list.get(0)).get("status").toString()));
            result.add(storeSign);
        });
        return result;
    }

    @Override
    public void insertStore(String storeCode, int status) {
        this.dao.insertStore(storeCode, status);
    }

    @Override
    public List<BatchRecord> getOldestUnsendBatchByStore(String storeCode) {
        LinkedList<BatchRecord> result = new LinkedList<BatchRecord>();
        List<Map<String, Object>> list = this.dao.queryOldestUnsendBatchByStore(storeCode);
        if (list == null || list.isEmpty()) {
            return result;
        }
        list.forEach(r -> {
            BatchRecord record = new BatchRecord();
            record.setBatchId(r.get("batch_id").toString());
            record.setData(r.get("data").toString());
            record.setServerUrl(r.get("server_url").toString());
            record.setStoreCode(r.get("store_code").toString());
            record.setCustomerStoreCode(r.get("customer_store_code").toString());
            record.setTaskName(r.get("task_name").toString());
            result.add(record);
        });
        return result;
    }

    @Override
    public List<BatchRecord> getOldestUnsendBatch() {
        LinkedList<BatchRecord> result = new LinkedList<BatchRecord>();
        List<Map<String, Object>> list = this.dao.queryOldestUnsendBatch();
        if (list == null || list.size() == 0) {
            return result;
        }
        list.forEach(r -> {
            BatchRecord record = new BatchRecord();
            record.setBatchId(r.get("batch_id").toString());
            record.setData(r.get("data").toString());
            record.setServerUrl(r.get("server_url").toString());
            record.setStoreCode(r.get("store_code").toString());
            result.add(record);
        });
        return result;
    }

    @Override
    public int getCountOfRecord() {
        Integer count = 0;
        count = this.dao.queryCountOfRecord();
        if (count == null || count == 0) {
            return count;
        }
        return count;
    }

    @Override
    public StoreInfo getStoreByCode(String storeCode) {
        List<Map<String, Object>> list = this.dao.queryStoreByCode(storeCode);
        if (list == null || list.size() == 0) {
            return null;
        }
        StoreInfo store = new StoreInfo();
        store.setStoreCode(list.get(0).get("status").toString());
        store.setStatus(Integer.valueOf(list.get(0).get("status").toString()));
        return store;
    }

    @Override
    public int deleteBatchRecord(BatchRecord record) {
        return this.dao.deleteBatchRecord(record.getBatchId());
    }

    @Override
    public List<Map<String, Object>> getStoreCodeList() {
        return this.dao.queryStoreCode();
    }

    @Override
    public void createTable() {
        this.dao.createTable();
    }
}

