/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SftpClientWrap {
    private static final Logger log = LogManager.getLogger(SftpClientWrap.class);
    private String host;
    private String username;
    private String password;
    private int port = 22;
    private ChannelSftp sftp = null;
    private Session sshSession = null;

    public SftpClientWrap() {
    }

    public SftpClientWrap(String host, int port, String username, String password) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.port = port;
    }

    public SftpClientWrap(String host, String username, String password) {
        this.host = host;
        this.username = username;
        this.password = password;
    }

    public void connect() {
        try {
            JSch jsch = new JSch();
            jsch.getSession(this.username, this.host, this.port);
            this.sshSession = jsch.getSession(this.username, this.host, this.port);
            if (log.isInfoEnabled()) {
                log.info("Session created.");
            }
            this.sshSession.setPassword(this.password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            this.sshSession.setConfig(sshConfig);
            this.sshSession.connect();
            if (log.isInfoEnabled()) {
                log.info("Session connected.");
            }
            Channel channel = this.sshSession.openChannel("sftp");
            channel.connect();
            if (log.isInfoEnabled()) {
                log.info("Opening Channel.");
            }
            this.sftp = (ChannelSftp)channel;
            if (log.isInfoEnabled()) {
                log.info("Connected to " + this.host + ".");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.sftp != null && this.sftp.isConnected()) {
            this.sftp.disconnect();
            if (log.isInfoEnabled()) {
                log.info("sftp is closed already");
            }
        }
        if (this.sshSession != null && this.sshSession.isConnected()) {
            this.sshSession.disconnect();
            if (log.isInfoEnabled()) {
                log.info("sshSession is closed already");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> batchDownLoadFile(String remotePath, String localPath, String fileFormat, String fileEndFormat, boolean del) {
        ArrayList<String> filenames = new ArrayList<String>();
        int dowmloadSize = 0;
        try {
            Vector v = this.listFiles(remotePath);
            if (v.size() > 0) {
                for (ChannelSftp.LsEntry entry : v) {
                    String filename = entry.getFilename().toLowerCase();
                    SftpATTRS attrs = entry.getAttrs();
                    if (attrs.isDir()) continue;
                    boolean flag = false;
                    fileFormat = fileFormat == null ? "" : fileFormat.trim().toLowerCase();
                    String string = fileEndFormat = fileEndFormat == null ? "" : fileEndFormat.trim().toLowerCase();
                    if (fileFormat.length() > 0 && fileEndFormat.length() > 0) {
                        if (!filename.startsWith(fileFormat) || !filename.endsWith(fileEndFormat) || !(flag = this.downloadFile(remotePath, filename, localPath, filename))) continue;
                        filenames.add(filename);
                        ++dowmloadSize;
                        if (!flag || !del) continue;
                        this.deleteSFTP(remotePath, filename);
                        continue;
                    }
                    if (fileFormat.length() > 0 && "".equals(fileEndFormat)) {
                        if (!filename.startsWith(fileFormat) || !(flag = this.downloadFile(remotePath, filename, localPath, filename))) continue;
                        filenames.add(filename);
                        ++dowmloadSize;
                        if (!flag || !del) continue;
                        this.deleteSFTP(remotePath, filename);
                        continue;
                    }
                    if (fileEndFormat.length() > 0 && "".equals(fileFormat)) {
                        if (!filename.endsWith(fileEndFormat) || !(flag = this.downloadFile(remotePath, filename, localPath, filename))) continue;
                        filenames.add(filename);
                        ++dowmloadSize;
                        if (!flag || !del) continue;
                        this.deleteSFTP(remotePath, filename);
                        continue;
                    }
                    flag = this.downloadFile(remotePath, filename, localPath, filename);
                    if (!flag) continue;
                    filenames.add(filename);
                    ++dowmloadSize;
                    if (!flag || !del) continue;
                    this.deleteSFTP(remotePath, filename);
                }
            }
            if (log.isInfoEnabled()) {
                log.info("download file is success:remotePath=" + remotePath + "and localPath=" + localPath + ",file size is" + dowmloadSize);
            }
        }
        catch (SftpException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return filenames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String remotePath, String remoteFileName, String localPath, String localFileName) {
        FileOutputStream fieloutput = null;
        try {
            File file = new File(localPath + File.separator + localFileName);
            fieloutput = new FileOutputStream(file);
            if (remotePath.contains("/")) {
                this.sftp.get(remotePath + "/" + remoteFileName, (OutputStream)fieloutput);
            } else {
                this.sftp.get(remotePath + File.separator + remoteFileName, (OutputStream)fieloutput);
            }
            if (log.isInfoEnabled()) {
                log.info("===DownloadFile:" + remoteFileName + " success from sftp.");
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (SftpException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != fieloutput) {
                try {
                    fieloutput.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(String remotePath, String remoteFileName, String localPath) throws SftpException, IOException {
        try (FileInputStream in = null;){
            this.createDir(remotePath);
            File file = new File(localPath);
            in = new FileInputStream(file);
            this.sftp.put((InputStream)in, remotePath + remoteFileName);
        }
    }

    public boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        boolean rs = file.delete();
        if (rs && log.isInfoEnabled()) {
            log.info("delete file success from local.");
        }
        return rs;
    }

    public boolean createDir(String createpath) {
        try {
            if (this.isDirExist(createpath)) {
                this.sftp.cd(createpath);
                return true;
            }
            String[] pathArry = createpath.split("/");
            StringBuffer filePath = new StringBuffer("/");
            for (String path : pathArry) {
                if (path.equals("")) continue;
                filePath.append(path + "/");
                if (this.isDirExist(filePath.toString())) {
                    this.sftp.cd(filePath.toString());
                    continue;
                }
                this.sftp.mkdir(filePath.toString());
                this.sftp.cd(filePath.toString());
            }
            this.sftp.cd(createpath);
            return true;
        }
        catch (SftpException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isDirExist(String directory) {
        boolean isDirExistFlag = false;
        try {
            SftpATTRS sftpATTRS = this.sftp.lstat(directory);
            isDirExistFlag = true;
            return sftpATTRS.isDir();
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().equals("no such file")) {
                isDirExistFlag = false;
            }
            return isDirExistFlag;
        }
    }

    public void deleteSFTP(String directory, String deleteFile) {
        try {
            this.sftp.rm(directory + "/" + deleteFile);
            if (log.isInfoEnabled()) {
                log.info("delete file success from sftp.");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void mkdirs(String path) {
        File f = new File(path);
        String fs = f.getParent();
        if (!(f = new File(fs)).exists()) {
            f.mkdirs();
        }
    }

    public Vector listFiles(String directory) throws SftpException {
        return this.sftp.ls(directory);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ChannelSftp getSftp() {
        return this.sftp;
    }

    public void setSftp(ChannelSftp sftp) {
        this.sftp = sftp;
    }
}

