/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HSIAM1TokenGenerator {
    private static final String HEAD = "{\"alg\":\"HS256\",\"typ\":\"JWT\"}";
    private static final String PAYLOAD_FORMAT = "{\"method\":\"%s\",\"customer\":\"%s\",\"store\":\"%s\",\"date\":\"%s\",\"access_key\":\"%s\"}";
    private static final String CREDENTIAL_TYPE = "HSIAM1";
    private String method = "POST";
    private String customer = "customer01";
    private String store = "50001";

    public HSIAM1TokenGenerator(String method, String customer, String store) {
        this.method = method;
        this.customer = customer;
        this.store = store;
    }

    public String generate(String accessKey, String secretKey) throws InvalidKeyException {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        Base64.Encoder base64Encoder = Base64.getUrlEncoder().withoutPadding();
        String headBase64 = base64Encoder.encodeToString(HEAD.getBytes(StandardCharsets.UTF_8));
        String payload = String.format(PAYLOAD_FORMAT, this.method, this.customer, this.store, ZonedDateTime.now(ZoneId.of("GMT")).toLocalDateTime().format(dtf), accessKey);
        String payloadBase64 = base64Encoder.encodeToString(payload.getBytes(StandardCharsets.UTF_8));
        String jwtContent = headBase64 + "." + payloadBase64;
        String signature = base64Encoder.encodeToString(HSIAM1TokenGenerator.hmacSha256(jwtContent, secretKey));
        String credential = jwtContent + "." + signature;
        return "HSIAM1 " + credential;
    }

    private static byte[] hmacSha256(String payload, String secret) throws InvalidKeyException {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            return mac.doFinal(payload.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

