/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.util;

import com.hanshow.cdi.config.AkSkConfig;
import com.hanshow.cdi.util.HSIAM1TokenGenerator;
import com.hanshow.cdi.util.SpringApplicationContextProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OkHttpClientWrap {
    private static final Logger log = LogManager.getLogger(OkHttpClientWrap.class);
    private OkHttpClient httpClient = null;
    private static final String JSON_MEDIA_TYPE_PATTERN = "application/json; charset=%s";

    public OkHttpClientWrap(int timeout) {
        try {
            this.httpClient = this.setSSL(timeout);
        }
        catch (Exception e) {
            log.error("Create https sender error ", (Throwable)e);
        }
    }

    private OkHttpClient setSSL(int timeout) throws KeyManagementException, NoSuchAlgorithmException {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        return new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, trustManager).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).readTimeout((long)timeout, TimeUnit.SECONDS).connectTimeout((long)timeout, TimeUnit.SECONDS).writeTimeout((long)timeout, TimeUnit.SECONDS).build();
    }

    public String postJsonToURLByAkSk(String url, String string, String charset, String customer, String store) throws IOException, InvalidKeyException {
        return this.postJsonToURLByAkSk(url, string, charset, customer, store, false);
    }

    public String postJsonToURLByAkSk(String url, String string, String charset, String customer, String store, boolean gzip) throws IOException, InvalidKeyException {
        Request request;
        byte[] bytes;
        if (gzip) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(baos);
            ((OutputStream)zipper).write(string.getBytes(charset));
            ((OutputStream)zipper).close();
            bytes = baos.toByteArray();
        } else {
            bytes = string.getBytes(charset);
        }
        MediaType JSON2 = MediaType.parse((String)String.format(JSON_MEDIA_TYPE_PATTERN, charset));
        RequestBody body = RequestBody.create((MediaType)JSON2, (byte[])bytes);
        String realStore = store.split("-")[0];
        AkSkConfig akSkConfig = SpringApplicationContextProvider.getBean(AkSkConfig.class);
        if (gzip) {
            if (akSkConfig.getSwitcher().booleanValue()) {
                String token = new HSIAM1TokenGenerator("POST", customer, realStore).generate(akSkConfig.getAccessKey(), akSkConfig.getSecretKey());
                request = new Request.Builder().url(url).post(body).header("Content-Encoding", "gzip").header("Authorization", token).build();
            } else {
                request = new Request.Builder().url(url).post(body).header("Content-Encoding", "gzip").build();
            }
        } else if (akSkConfig.getSwitcher().booleanValue()) {
            String token = new HSIAM1TokenGenerator("POST", customer, realStore).generate(akSkConfig.getAccessKey(), akSkConfig.getSecretKey());
            request = new Request.Builder().url(url).post(body).header("Authorization", token).build();
        } else {
            request = new Request.Builder().url(url).post(body).build();
        }
        Response response = this.httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        if (response.code() == 401) {
            response.close();
            throw new InvalidKeyException(String.format("Unauthorized: %s, Valid Ak/Sk Required.", response.code()));
        }
        response.close();
        throw new IOException(String.format("Post JSON to url %s got unexpected code %d DATA %s", url, response.code(), string));
    }

    public String postJsonToURL(String url, String string, String charset) throws IOException {
        return this.postJsonToURL(url, string, charset, false);
    }

    public String postJsonToURL(String url, String string, String charset, boolean gzip) throws IOException {
        byte[] bytes;
        if (gzip) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(baos);
            ((OutputStream)zipper).write(string.getBytes(charset));
            ((OutputStream)zipper).close();
            bytes = baos.toByteArray();
        } else {
            bytes = string.getBytes(charset);
        }
        MediaType JSON2 = MediaType.parse((String)String.format(JSON_MEDIA_TYPE_PATTERN, charset));
        RequestBody body = RequestBody.create((MediaType)JSON2, (byte[])bytes);
        Request request = gzip ? new Request.Builder().url(url).post(body).header("Content-Encoding", "gzip").build() : new Request.Builder().url(url).post(body).build();
        Response response = this.httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        response.close();
        throw new IOException(String.format("Post JSON to url %s got unexpected code %d DATA %s", url, response.code(), string));
    }

    public String postJsonToURL(String url, String string, String charset, boolean gzip, String headerName, String headerValue) throws IOException {
        byte[] bytes;
        if (gzip) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(baos);
            ((OutputStream)zipper).write(string.getBytes(charset));
            ((OutputStream)zipper).close();
            bytes = baos.toByteArray();
        } else {
            bytes = string.getBytes(charset);
        }
        MediaType JSON2 = MediaType.parse((String)String.format(JSON_MEDIA_TYPE_PATTERN, charset));
        RequestBody body = RequestBody.create((MediaType)JSON2, (byte[])bytes);
        Request request = gzip ? new Request.Builder().url(url).post(body).header("Content-Encoding", "gzip").build() : new Request.Builder().url(url).header(headerName, headerValue).post(body).build();
        Response response = this.httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        response.close();
        throw new IOException(String.format("Post JSON to url %s got unexpected code %d DATA %s", url, response.code(), string));
    }

    public List<File> getFileToURL(List<File> fileList, String url, String savePath) throws IOException {
        String fileName = url.substring(url.lastIndexOf("/") + 1).trim();
        Request request = new Request.Builder().url(url).addHeader("Connection", "close").build();
        Response response = this.httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            InputStream is = null;
            byte[] buf = new byte[2048];
            int len = 0;
            FileOutputStream fos = null;
            try {
                is = response.body().byteStream();
                File file = new File(savePath, fileName);
                fos = new FileOutputStream(file);
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.flush();
                fileList.add(file);
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IOException(String.format("%s get File to %s FAILED", response.code(), url));
        }
        return fileList;
    }

    public String putJsonToURL(String url, String string, String charset) throws IOException {
        return this.putJsonToURL(url, string, charset, false);
    }

    public String putJsonToURL(String url, String string, String charset, boolean gzip) throws IOException {
        byte[] bytes;
        if (gzip) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(baos);
            ((OutputStream)zipper).write(string.getBytes(charset));
            ((OutputStream)zipper).close();
            bytes = baos.toByteArray();
        } else {
            bytes = string.getBytes(charset);
        }
        MediaType JSON2 = MediaType.parse((String)String.format(JSON_MEDIA_TYPE_PATTERN, charset));
        RequestBody body = RequestBody.create((MediaType)JSON2, (byte[])bytes);
        Request request = gzip ? new Request.Builder().url(url).put(body).header("Content-Encoding", "gzip").build() : new Request.Builder().url(url).put(body).build();
        Response response = this.httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        response.close();
        throw new IOException(String.format("Post JSON to url %s got unexpected code %d DATA %s", url, response.code(), string));
    }

    public String deleteJsonToURL(String url, String string, String charset) throws IOException {
        return this.deleteJsonToURL(url, string, charset, false);
    }

    public String deleteJsonToURL(String url, String string, String charset, boolean gzip) throws IOException {
        byte[] bytes;
        if (gzip) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(baos);
            ((OutputStream)zipper).write(string.getBytes(charset));
            ((OutputStream)zipper).close();
            bytes = baos.toByteArray();
        } else {
            bytes = null != string ? string.getBytes(charset) : null;
        }
        MediaType JSON2 = MediaType.parse((String)String.format(JSON_MEDIA_TYPE_PATTERN, charset));
        RequestBody body = null != string ? RequestBody.create((MediaType)JSON2, (byte[])bytes) : null;
        Request request = gzip ? new Request.Builder().url(url).delete(body).header("Content-Encoding", "gzip").build() : new Request.Builder().url(url).delete(body).build();
        Response response = this.httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        response.close();
        throw new IOException(String.format("Post JSON to url %s got unexpected code %d DATA %s", url, response.code(), string));
    }

    public String getUrl(String url, String charset) throws IOException {
        return this.getUrl(url, charset, false);
    }

    public String getUrl(String url, String charset, boolean gzip) throws IOException {
        Request request = gzip ? new Request.Builder().url(url).get().header("Content-Encoding", "gzip").build() : new Request.Builder().url(url).get().build();
        Response response = this.httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        response.close();
        throw new IOException(String.format("get JSON to url %s got unexpected code %d", url, response.code()));
    }
}

