/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicodeFilterUtils {
    private static final Logger logger = LoggerFactory.getLogger(UnicodeFilterUtils.class);

    public static String removeAsciiControl(String sourceStr) {
        if (sourceStr != null && sourceStr.length() > 0) {
            char[] contentCharArr = sourceStr.toCharArray();
            for (int i = 0; i < contentCharArr.length; ++i) {
                if (contentCharArr[i] >= ' ' && contentCharArr[i] != '\u007f') continue;
                logger.warn("discovery of abnormal characters, data: " + sourceStr);
                return "{}";
            }
            return sourceStr;
        }
        return null;
    }

    public static String replaceAsciiControl(String sourceStr) {
        if (sourceStr != null && sourceStr.length() > 0) {
            char[] contentCharArr = sourceStr.toCharArray();
            for (int i = 0; i < contentCharArr.length; ++i) {
                if (contentCharArr[i] >= ' ' && contentCharArr[i] != '\u007f') continue;
                logger.warn("discovery of abnormal characters, data: " + sourceStr);
                contentCharArr[i] = 32;
            }
            return new String(contentCharArr);
        }
        return null;
    }

    public static String replaceUnicode(String sourceStr) {
        String regEx = "[\u4e00-\u9fbf\u4dc0-\u4dff\u0000-\u007f\u0080-\u00ff\u0100-\u017f\u0180-\u024f\u0250-\u02af\u02b0-\u02ff\u0300-\u036f\u0370-\u03ff\u0400-\u04ff\u0500-\u052f\u0530-\u058f\u0590-\u05ff\u0600-\u06ff\u0700-\u074f\u0750-\u077f\u0780-\u07bf\u0860-\u087f\u0880-\u08af\u0900-\u097f\u0980-\u09ff\u0a00-\u0a7f\u0a80-\u0aff\u0b00-\u0b7f\u0b80-\u0bff\u0c00-\u0c7f\u0c80-\u0cff\u0d00-\u0d7f\u0d80-\u0dff\u0e00-\u0e7f\u0e80-\u0eff\u0f00-\u0fff\u1000-\u109f\u10a0-\u10ff\u1100-\u11ff\u1200-\u137f\u1380-\u139f\u13a0-\u13ff\u1400-\u167f\u1680-\u169f\u16a0-\u16ff\u1700-\u171f\u1720-\u173f\u1740-\u175f\u1760-\u177f\u1780-\u17ff\u1800-\u18af\u18b0-\u18ff\u1900-\u194f\u1950-\u197f\u1980-\u19df\u19e0-\u19ff\u1a00-\u1a1f\u1a20-\u1a5f\u1a80-\u1aef\u1b00-\u1b7f\u1b80-\u1bb0\u1bc0-\u1bff\u1c00-\u1c4f\u1c50-\u1c7f\u1c80-\u1cdf\u1d00-\u1d7f\u1d80-\u1dbf\u1dc0-\u1dff\u1e00-\u1eff\u1f00-\u1fff\u2000-\u206f\u2070-\u209f\u20a0-\u20cf\u20d0-\u20ff\u2100-\u214f\u2150-\u218f\u2190-\u21ff\u2200-\u22ff\u2300-\u23ff\u2400-\u243f\u2440-\u245f\u2460-\u24ff\u2500-\u257f\u2580-\u259f\u25a0-\u25ff\u2600-\u26ff\u2700-\u27bf\u27c0-\u27ef\u27f0-\u27ff\u2800-\u28ff\u2900-\u297f\u2980-\u29ff\u2a00-\u2aff\u2b00-\u2bff\u2c00-\u2c5f\u2c60-\u2c7f\u2c80-\u2cff\u2d00-\u2d2f\u2d30-\u2d7f\u2d80-\u2ddf\u2e00-\u2e7f\u2e80-\u2eff\u2f00-\u2fdf\u2ff0-\u2fff\u3000-\u303f\u3040-\u309f\u30a0-\u30ff\u3100-\u312f\u3130-\u318f\u3190-\u319f\u31a0-\u31bf\u31c0-\u31ef\u31f0-\u31ff\u3200-\u32ff\u3300-\u33ff\u3400-\u4dbf\u4dc0-\u4dff\u4e00-\u9fbf\ua000-\ua48f\ua490-\ua4cf\ua500-\ua61f\ua660-\ua6ff\ua700-\ua71f\ua720-\ua7ff\ua800-\ua82f\ua840-\ua87f\ua880-\ua8df\ua900-\ua97f\ua980-\ua9df\uaa00-\uaa3f\uaa40-\uaa6f\uaa80-\uaadf\uab00-\uab5f\uab80-\uaba0\uac00-\ud7af\uf900-\ufaff\ufb00-\ufb4f\ufb50-\ufdff\ufe00-\ufe0f\ufe10-\ufe1f\ufe20-\ufe2f\ufe30-\ufe4f\ufe50-\ufe6f\ufe70-\ufeff\uff00-\uffef\ufff0-\uffff]";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(sourceStr);
        return matcher.replaceAll("");
    }
}

