/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hanshow.intsmart.api.ShopWebApiResponse;
import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import com.hanshow.intsmart.exception.ApiException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintViolationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice(basePackages={"com.hanshow.intsmart"})
public class ResponseControllerAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LogManager.getLogger(ResponseControllerAdvice.class);

    @ExceptionHandler(value={ApiException.class})
    public ShopWebApiResponse apiExceptionHandler(HttpServletRequest request, ApiException e) {
        return this.processExceptionMessage(request, e);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ShopWebApiResponse illegalArgumentExceptionHandler(HttpServletRequest request, IllegalArgumentException e) {
        return this.processExceptionMessage(request, e);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ShopWebApiResponse methodArgumentTypeMismatchExceptionHandler(HttpServletRequest request, MethodArgumentTypeMismatchException e) {
        return this.processExceptionMessage(request, e);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ShopWebApiResponse constraintViolationExceptionHandler(HttpServletRequest request, ConstraintViolationException e) {
        return this.processExceptionMessage(request, e);
    }

    @ExceptionHandler(value={ConstraintDeclarationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ShopWebApiResponse validationExceptionHandler(HttpServletRequest request, ConstraintDeclarationException e) {
        return this.processExceptionMessage(request, e);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ShopWebApiResponse illegalStateExceptionHandler(HttpServletRequest request, IllegalStateException e) {
        return this.processExceptionMessage(request, e);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ShopWebApiResponse exceptionHandler(HttpServletRequest request, Exception e) {
        return this.processExceptionMessage(request, e);
    }

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> aClass) {
        return !returnType.getGenericParameterType().equals(ShopWebApiResponse.class);
    }

    @Override
    public Object beforeBodyWrite(Object data, MethodParameter returnType, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (returnType.getGenericParameterType().equals(String.class)) {
            if (!serverHttpRequest.getURI().getPath().contains("/ogi/") || !serverHttpRequest.getURI().getPath().contains("/proxy/")) {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return objectMapper.writeValueAsString(new ShopWebApiResponse(data));
                }
                catch (JsonProcessingException e) {
                    throw new ApiException(ShopWebApiResultCodeEnum.FAILED);
                }
            }
            return data;
        }
        if (returnType.getGenericParameterType().equals(ShopWebApiResponse.class)) {
            return data;
        }
        return new ShopWebApiResponse(data);
    }

    private ShopWebApiResponse processExceptionMessage(HttpServletRequest request, Exception e) {
        ShopWebApiResponse allStarApiResponse;
        log.debug(request.getMethod() + " " + request.getRequestURI() + " " + e);
        if (e.getClass().equals(Exception.class)) {
            allStarApiResponse = new ShopWebApiResponse(ShopWebApiResultCodeEnum.FAILED, e.getMessage());
        } else if (e.getClass().equals(ApiException.class)) {
            allStarApiResponse = new ShopWebApiResponse(ShopWebApiResultCodeEnum.I_UPDATE_TASK_FAILED, ((ApiException)e).getResponse().getData());
        } else if (e.getClass().equals(IllegalArgumentException.class)) {
            allStarApiResponse = new ShopWebApiResponse(ShopWebApiResultCodeEnum.I_ILLEGAL_ARGUMENTS, e.getMessage());
        } else {
            allStarApiResponse = new ShopWebApiResponse(ShopWebApiResultCodeEnum.FAILED, e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return allStarApiResponse;
    }
}

