/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.api.aop;

import com.hanshow.cdi.util.Utils;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ControllerInterceptor {
    private static final Logger log = LogManager.getLogger(ControllerInterceptor.class);
    ThreadLocal<Long> startTime = new ThreadLocal();

    @Pointcut(value="execution(* com.hanshow.intsmart.api.v1..*(..)) execution(* com.hanshow.intsmart.api.v2..*(..)) && @annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void controllerMethodPointcut() {
    }

    @Before(value="controllerMethodPointcut()")
    public void interceptor(JoinPoint joinPoint) throws Exception {
        this.startTime.set(System.currentTimeMillis());
        log.info("================================ [ REVICED REQUEST ] =====================================");
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        log.info("REQUEST URL : " + request.getRequestURL().toString());
        log.info("HTTP METHOD : " + request.getMethod());
        log.info("SOURCE ADDR : " + request.getRemoteAddr());
        log.debug("CLASS METHOD : " + joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName());
        log.debug("REQUEST BODY : " + Utils.toJson(joinPoint.getArgs()));
    }

    @AfterReturning(returning="response", pointcut="controllerMethodPointcut()")
    public void doAfterReturning(Object response) throws Exception {
        log.info("==================================== [ RESPONSE ] ========================================");
        log.info("RESPONSE BODY : " + Utils.toJson(response));
        log.info("TIME CONSUMING(Millis) : " + (System.currentTimeMillis() - this.startTime.get()) + "ms");
        this.startTime.remove();
    }
}

