/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.api.aop;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class HttpAspect {
    private static final Logger log = LogManager.getLogger(HttpAspect.class);

    @Pointcut(value="execution(* com.hanshow.intsmart.*..*.*(..))&& !execution(public * com.hanshow.intsmart.api.webui.*.*(..))")
    public void aopPointCut() {
    }

    @Around(value="aopPointCut()")
    public Object timeAround(ProceedingJoinPoint joinPoint) {
        long E_time = 0L;
        Object obj = null;
        try {
            long startTime = System.currentTimeMillis();
            obj = joinPoint.proceed(joinPoint.getArgs());
            E_time = System.currentTimeMillis() - startTime;
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        String classAndMethod = joinPoint.getSignature().getDeclaringTypeName() + " [" + joinPoint.getSignature().getName() + "]";
        log.debug("EXECUTE " + classAndMethod + " Time consuming:" + E_time + "ms");
        return obj;
    }
}

