/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.api.aop;

import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import com.hanshow.intsmart.exception.ApiException;
import com.hanshow.intsmart.util.CookieUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class UserAuthorizeAspect {
    private static final Logger log = LogManager.getLogger(UserAuthorizeAspect.class);

    @Pointcut(value="execution(public * com.hanshow.intsmart.api.webui.*Controller.*(..))&& !execution(public * com.hanshow.intsmart.api.webui.LoginController.*(..))&& !execution(public * com.hanshow.intsmart.api.webui.VersionController.*(..))&& !execution(public * com.hanshow.intsmart.api.webui.LoginController.*(..))")
    public void verify() {
    }

    @Before(value="verify()")
    public void doVerify() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        if (!CookieUtil.getContain(request)) {
            log.warn("[ login check ] : Cookie not in token");
            throw new ApiException(ShopWebApiResultCodeEnum.I_AUTHENTICATION_INVALID);
        }
    }
}

