/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.api.webui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.hanshow.cdi.common.ReloadTypeEnum;
import com.hanshow.cdi.config.SpringBeanConfig;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.cdi.service.StoreService;
import com.hanshow.cdi.util.ReadConfig;
import com.hanshow.cdi.util.Utils;
import com.hanshow.intsmart.api.ShopWebApiResponse;
import com.hanshow.intsmart.api.vo.CdiSystemVo;
import com.hanshow.intsmart.api.vo.CertificateVo;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.configuration.IntegrationUrlProperties;
import com.hanshow.intsmart.configuration.LoginProperties;
import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import com.hanshow.intsmart.enums.TaskStatusEnum;
import com.hanshow.intsmart.exception.ApiException;
import com.hanshow.intsmart.executor.ClientHandlerExecutor;
import com.hanshow.intsmart.scheduler.JobExcuteScheduler;
import com.hanshow.intsmart.service.DatabaseLinkService;
import com.hanshow.intsmart.service.FieldService;
import com.hanshow.intsmart.service.PropertiesService;
import com.hanshow.intsmart.util.DBUtil;
import com.hanshow.intsmart.util.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;

public abstract class AbstractController {
    private static final Logger log = LogManager.getLogger(AbstractController.class);
    @Autowired
    protected LoginProperties loginProperties;
    @Autowired
    protected InitializeContext initializeContext;
    @Autowired
    protected HttpServletRequest httpRequest;
    @Autowired
    protected HttpServletResponse httpResponse;
    @Autowired
    protected IntegrationUrlProperties integrationUrlProperties;
    @Value(value="${cdi.workerNum}")
    protected int senderWorkerNum;
    @Autowired
    protected DatabaseLinkService databaseLinkService;
    @Autowired
    protected PropertiesService propertiesService;
    @Autowired
    protected FieldService fieldService;
    @Autowired
    StoreService storeService;
    @Autowired
    protected SpringBeanConfig springBeanConfig;
    @Autowired
    protected DBUtil dbUtil;

    protected Object handle(ArgumentsValidator validator, APIRoutine routine) throws Exception {
        return this.validatorAndRoutine(validator, routine);
    }

    protected Object handle(ArgumentsValidator validator, APIRoutine routine, PropertiesReload reload) throws Exception {
        Object result = this.validatorAndRoutine(validator, routine);
        try {
            reload.reload();
            this.writeProperties();
        }
        catch (IOException | FtpServerConfigurationException | FtpException e) {
            log.error("ftp/sftp server create failed : {}", (Object)e.getMessage(), (Object)e);
            return new ApiException(ShopWebApiResultCodeEnum.I_FTP_PORT_IS_BIND);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.error("Field mapping configuration failed: {}", (Object)e.getMessage(), (Object)e);
            CdiProperties cdiPropertiesCopy = Utils.stringToItem(ReadConfig.read(new File(new PropertiesConfiguration("length.properties").getFile().getParent(), "cdi")), CdiProperties.class);
            this.initializeContext.getServerContext().setCdiProperties(cdiPropertiesCopy);
            reload.reload();
            throw new ApiException(ShopWebApiResultCodeEnum.I_UPDATE_TASK_FAILED, e.getMessage());
        }
        return result;
    }

    private Object validatorAndRoutine(ArgumentsValidator validator, APIRoutine routine) throws Exception {
        validator.validator();
        return routine.execute();
    }

    protected Object SaveCertificateProperties(SavePropertiesHandler handler) throws Exception {
        File cert;
        SaveProperties saveProperties = handler.handle();
        ClassPathResource tempResource = new ClassPathResource("cdi");
        if ("ADD".equals(saveProperties.certificateVo.getType())) {
            try {
                String path = tempResource.getFile().getParentFile().getAbsolutePath();
                File cert2 = new File(path, saveProperties.certificateVo.getCustomerCode() + "-" + saveProperties.certificateVo.getCertificate().getOriginalFilename());
                saveProperties.certificateVo.getCertificate().transferTo(cert2);
                try {
                    PropertiesUtil.setPropertiesMap(saveProperties.certificateVo, this.initializeContext.getServerContext().getCdiProperties());
                }
                catch (JsonProcessingException e) {
                    log.error("parse cdiSystem data error \uff1a {}", (Object)e.getMessage(), (Object)e);
                    throw new ApiException(ShopWebApiResultCodeEnum.I_UPLOAD_CERTIFICATE_FAILED);
                }
                return new ShopWebApiResponse(ShopWebApiResultCodeEnum.SUCCEED);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ApiException(ShopWebApiResultCodeEnum.I_UPLOAD_CERTIFICATE_FAILED);
            }
        }
        if ("UPDATE".equals(saveProperties.certificateVo.getType())) {
            try {
                PropertiesUtil.setPropertiesMap(saveProperties.certificateVo, this.initializeContext.getServerContext().getCdiProperties());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ApiException(ShopWebApiResultCodeEnum.I_UPDATE_CERTIFICATE_FAILED);
            }
            return new ShopWebApiResponse(ShopWebApiResultCodeEnum.SUCCEED);
        }
        try {
            String path = tempResource.getFile().getParentFile().getAbsolutePath();
            cert = new File(path, saveProperties.certificateVo.getCustomerCode() + "-" + saveProperties.certificateVo.getCertificateName());
            this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getCertificateMap().remove(saveProperties.getCertificateVo().getCustomerCode());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ShopWebApiResultCodeEnum.I_DELETE_CERTIFICATE_FAILED);
        }
        if (!cert.exists() || cert.delete()) {
            return new ShopWebApiResponse(ShopWebApiResultCodeEnum.SUCCEED);
        }
        throw new ApiException(ShopWebApiResultCodeEnum.I_DELETE_CERTIFICATE_FAILED);
    }

    protected Object SaveCdiSystemProperties(SavePropertiesHandler handler) throws Exception {
        SaveProperties saveProperties = handler.handle();
        LinkedHashMap<String, Object> map = PropertiesUtil.setPropertiesMap(saveProperties.cdiSystemForm, this.initializeContext.getServerContext().getCdiProperties());
        try {
            for (CdiProperties.Task task : this.initializeContext.getServerContext().getCdiProperties().getTask()) {
                if (!TaskStatusEnum.STATE_NORMAL.getName().equalsIgnoreCase(JobExcuteScheduler.getClientIntegrationJobStatus(task.getTaskName())) || !JobExcuteScheduler.stopClientIntegrationJob(task.getTaskName())) continue;
                PropertiesUtil.stopTask(task.getTaskName(), this.initializeContext.getServerContext());
            }
            this.writeProperties();
        }
        catch (Exception e) {
            log.error("The integration is running, stop failed by change integration : {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(ShopWebApiResultCodeEnum.I_CHANGE_INTEGRATION_FAILED);
        }
        return map;
    }

    protected Object SaveTaskProperties(SavePropertiesHandler handler) throws Exception {
        SaveProperties saveProperties = handler.handle();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        switch (saveProperties.type) {
            case "add": {
                try {
                    map = PropertiesUtil.setPropertiesMap(saveProperties.taskForm, this.initializeContext.getServerContext().getCdiProperties());
                    this.addTask(saveProperties.taskForm);
                    break;
                }
                catch (JsonProcessingException e) {
                    log.error("parse cdiSystem data error \uff1a {}", (Object)e.getMessage(), (Object)e);
                    throw new ApiException(ShopWebApiResultCodeEnum.I_ADD_INTEGRATION_FAILED);
                }
            }
            case "delete": {
                this.deleteTask(map, saveProperties.taskName);
            }
        }
        return map;
    }

    private void addTask(CdiProperties.Task taskForm) throws SchedulerException {
        List<CdiProperties.Task> task;
        if (TaskStatusEnum.STATE_NORMAL.getName().equalsIgnoreCase(JobExcuteScheduler.getClientIntegrationJobStatus(taskForm.getTaskName()))) {
            if (JobExcuteScheduler.stopClientIntegrationJob(taskForm.getTaskName())) {
                task = this.initializeContext.getServerContext().getCdiProperties().getTask();
                for (CdiProperties.Task cdiTask : task) {
                    if (!cdiTask.getTaskName().equals(taskForm.getTaskName())) continue;
                    cdiTask.setIntegrationStatus(false);
                }
            } else {
                task = this.initializeContext.getServerContext().getCdiProperties().getTask();
                for (CdiProperties.Task cdiTask : task) {
                    if (!cdiTask.getTaskName().equals(taskForm.getTaskName())) continue;
                    cdiTask.setIntegrationStatus(false);
                }
            }
        }
        if (TaskStatusEnum.STATE_NONE.getName().equalsIgnoreCase(JobExcuteScheduler.getClientIntegrationJobStatus(taskForm.getTaskName()))) {
            task = this.initializeContext.getServerContext().getCdiProperties().getTask();
            for (CdiProperties.Task cdiTask : task) {
                if (!cdiTask.getTaskName().equals(taskForm.getTaskName())) continue;
                cdiTask.setIntegrationStatus(false);
            }
        }
    }

    private void deleteTask(Map<String, Object> map, String taskName) {
        block8: {
            try {
                if (this.initializeContext.getServerContext().getTaskMap().containsKey(taskName)) {
                    if (TaskStatusEnum.STATE_NORMAL.getName().equalsIgnoreCase(JobExcuteScheduler.getClientIntegrationJobStatus(taskName))) {
                        if (JobExcuteScheduler.stopClientIntegrationJob(taskName)) {
                            this.initializeContext.getServerContext().getTaskMap().get(taskName).setIntegrationStatus(false);
                            map = PropertiesUtil.deletedPropertiesTask(taskName, this.initializeContext.getServerContext().getCdiProperties());
                        }
                    } else if (TaskStatusEnum.STATE_NONE.getName().equalsIgnoreCase(JobExcuteScheduler.getClientIntegrationJobStatus(taskName))) {
                        this.initializeContext.getServerContext().getTaskMap().get(taskName).setIntegrationStatus(false);
                        map.putAll(PropertiesUtil.deletedPropertiesTask(taskName, this.initializeContext.getServerContext().getCdiProperties()));
                    }
                    break block8;
                }
                log.warn("taskName : {} job is not exist", (Object)taskName);
                throw new ApiException(ShopWebApiResultCodeEnum.I_DELETE_INTEGRATION_TASK_FAILED);
            }
            catch (SchedulerException e) {
                log.error("The taskName {} job is running, stop failed ", (Object)taskName, (Object)e);
                throw new ApiException(ShopWebApiResultCodeEnum.I_DELETE_INTEGRATION_TASK_FAILED);
            }
            catch (JsonProcessingException e) {
                log.error("parse task data error : {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException(ShopWebApiResultCodeEnum.I_CHANGE_INTEGRATION_FAILED);
            }
        }
    }

    protected void structureTask(CdiProperties.Task taskForm) throws Exception {
        this.propertiesService.structureTaskDatasource(taskForm);
    }

    protected void writeProperties() throws Exception {
        try {
            ReadConfig.write(Utils.toJson(this.initializeContext.getServerContext().getCdiProperties(), true));
        }
        catch (IOException | ConfigurationException e) {
            log.error("cdiSystem data write cdi file error : {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(ShopWebApiResultCodeEnum.I_CHANGE_INTEGRATION_FAILED);
        }
    }

    protected void reload(ReloadTypeEnum reloadTypeEnum, String taskName) throws Exception {
        this.initializeContext.getServerContext().reload(this.initializeContext.getServerContext().getCdiProperties(), reloadTypeEnum, taskName);
        if (this.initializeContext.getServerContext().isCdiSwitch()) {
            this.initializeContext.getInitializeCDIServer().getCdiServer().stop();
        }
        ClientHandlerExecutor.reloadClientHandlerExecutor(this.initializeContext);
        if (this.initializeContext.getServerContext().isCdiSwitch()) {
            this.initializeContext.getInitializeCDIServer().start();
        }
    }

    protected void reloadBean(String customerCode, String type) throws Exception {
        this.initializeContext.getServerContext().reload(this.initializeContext.getServerContext().getCdiProperties(), ReloadTypeEnum.SYSTEM, null);
        if ("ADD".equals(type)) {
            this.initializeContext.getServerContext().reloadCerClientWrapMap(customerCode);
        } else if ("DELETE".equals(type)) {
            this.initializeContext.getServerContext().getOkHttpsCertClientWrapMap().remove(customerCode);
        }
        this.initializeContext.getInitializeCDIServer().getCdiServer().stop();
        ClientHandlerExecutor.reloadClientHandlerExecutor(this.initializeContext);
        this.initializeContext.getInitializeCDIServer().start();
    }

    public static interface ArgumentsValidator {
        public void validator() throws Exception;
    }

    public static interface APIRoutine {
        public Object execute() throws Exception;
    }

    public static interface PropertiesReload {
        public void reload() throws Exception;
    }

    public static interface SavePropertiesHandler {
        public SaveProperties handle() throws Exception;
    }

    public class SaveProperties {
        private CdiSystemVo cdiSystemForm;
        private CertificateVo certificateVo;
        private CdiProperties.Task taskForm;
        private String taskName;
        private String type;

        public SaveProperties(CertificateVo certificateVo) {
            this.certificateVo = certificateVo;
        }

        public SaveProperties(CdiSystemVo cdiSystemForm) {
            this.cdiSystemForm = cdiSystemForm;
        }

        public SaveProperties(CdiProperties.Task taskForm, String type) {
            this.taskForm = taskForm;
            this.type = type;
        }

        public SaveProperties(String taskName, String type) {
            this.taskName = taskName;
            this.type = type;
        }

        public SaveProperties(CdiSystemVo cdiSystemForm, CertificateVo certificateVo, CdiProperties.Task taskForm, String taskName, String type) {
            this.cdiSystemForm = cdiSystemForm;
            this.certificateVo = certificateVo;
            this.taskForm = taskForm;
            this.taskName = taskName;
            this.type = type;
        }

        public CdiSystemVo getCdiSystemForm() {
            return this.cdiSystemForm;
        }

        public CertificateVo getCertificateVo() {
            return this.certificateVo;
        }

        public CdiProperties.Task getTaskForm() {
            return this.taskForm;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public String getType() {
            return this.type;
        }
    }
}

