/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.api.webui;

import com.alibaba.fastjson.JSONObject;
import com.hanshow.cdi.util.AESUtils;
import com.hanshow.intsmart.api.webui.AbstractController;
import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import com.hanshow.intsmart.exception.ApiException;
import com.hanshow.intsmart.model.common.CookieConstant;
import com.hanshow.intsmart.util.CookieUtil;
import java.util.UUID;
import javax.servlet.http.Cookie;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/intsmart"})
public class LoginController
extends AbstractController {
    private static final Logger log = LogManager.getLogger(LoginController.class);

    @PostMapping(value={"/login"})
    public Object login(@RequestBody String json) throws Exception {
        AbstractController.ArgumentsValidator validator = () -> {
            log.info("request={}", (Object)json);
            JSONObject paramMap = JSONObject.parseObject(json);
            if (paramMap.get("username") == null) {
                throw new IllegalArgumentException("username cannot be null");
            }
        };
        AbstractController.APIRoutine routine = () -> {
            JSONObject paramMap = JSONObject.parseObject(json);
            if (paramMap.get("username").equals(this.loginProperties.getUserName()) && AESUtils.decrypt(paramMap.get("password").toString()).equals(this.loginProperties.getPassword())) {
                String token = UUID.randomUUID().toString();
                CookieUtil.set(this.httpResponse, "token", token, CookieConstant.EXPIRE);
                return ShopWebApiResultCodeEnum.SUCCEED;
            }
            throw new ApiException(ShopWebApiResultCodeEnum.I_PASSWORD_MISMATCH);
        };
        return this.handle(validator, routine);
    }

    @GetMapping(value={"/logout"})
    public Object logout() {
        Cookie cookie = CookieUtil.get(this.httpRequest, "token");
        if (cookie != null) {
            CookieUtil.set(this.httpResponse, "token", null, 0);
            return ShopWebApiResultCodeEnum.SUCCEED;
        }
        throw new ApiException(ShopWebApiResultCodeEnum.I_AUTHENTICATION_INVALID);
    }
}

