/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.centre;

import com.hanshow.cdi.core.FileLineSorter;
import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.core.InitializeCdiServer;
import com.hanshow.cdi.core.IntegrateTask;
import com.hanshow.cdi.service.StoreService;
import com.hanshow.cdi.sftp.SftpServerWrap;
import com.hanshow.cdi.util.ReadConfig;
import com.hanshow.intsmart.configuration.DbProperties;
import com.hanshow.intsmart.exception.GlobalExceptionHandler;
import com.hanshow.intsmart.handler.ServerHandler;
import com.hanshow.intsmart.mapper.IntSmartMapper;
import com.hanshow.intsmart.model.database.SqlProvider;
import com.hanshow.intsmart.model.entity.FtpServerWrap;
import com.hanshow.intsmart.tray.IntegrationFrame;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.File;
import javax.annotation.Resource;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class InitializeContext {
    private static final Logger log = LogManager.getLogger(InitializeContext.class);
    private GenericCdiServerContext serverContext;
    private ServerHandler serverHandler;
    private FtpServerWrap ftpServer;
    private SftpServerWrap sftpServer;
    private InitializeCdiServer initializeCDIServer;
    private IntSmartMapper intSmartMapper;
    private IntegrateTask integrateTask;
    private DbProperties dbProperties;
    JsonSchema prismartschema;
    private StoreService storeService;
    private boolean cdiSwitch;
    private int handlerThreadNum;
    @Value(value="${cdi.sync}")
    private Boolean integrationSync;
    @Resource(name="databasePoolExecutor")
    private ThreadPoolTaskExecutor databasePoolExecutor;

    @Autowired
    InitializeContext(InitializeCdiServer initializeCDIServer, IntSmartMapper intSmartMapper, IntegrateTask integrateTask, Environment environment, DbProperties dbProperties) throws Exception {
        GlobalExceptionHandler.register();
        this.initializeCDIServer = initializeCDIServer;
        this.storeService = initializeCDIServer.getStoreService();
        this.intSmartMapper = intSmartMapper;
        this.integrateTask = integrateTask;
        this.dbProperties = dbProperties;
        this.handlerThreadNum = environment.getProperty("handler.ThreadNum", Integer.class, 8);
        try {
            this.cdiSwitch = Boolean.parseBoolean(environment.getProperty("cdi.switch"));
            if (this.cdiSwitch) {
                this.initializeCDIServer.setFtpMaxLogin(environment.getProperty("cdi.ftpMaxLogin", Integer.class, 10));
                FileLineSorter.sortThreadNum = environment.getProperty("cdi.sortThreadNum", Integer.class, 5);
                FileLineSorter.sortInterval = environment.getProperty("cdi.sortInterval", Long.class, 500L);
                FileLineSorter.FRAGMENT_LINES = environment.getProperty("cdi.fragmentLines", Integer.class, 1000);
                this.initializeCDIServer.start();
            }
            PropertiesConfiguration p = new PropertiesConfiguration("length.properties");
            this.prismartschema = JsonSchemaFactory.getInstance(SpecVersion.VersionFlag.V4).getSchema(ReadConfig.read(new File(p.getFile().getParent(), "jsonschema.json")));
        }
        catch (Exception e) {
            log.error("start cdi ftp failed : {}", (Object)e.getMessage(), (Object)e);
        }
        this.serverContext = this.initializeCDIServer.getServerContext();
        new SqlProvider(this);
        if (Boolean.parseBoolean(environment.getProperty("tray.switch")) && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            try {
                System.setProperty("java.awt.headless", "false");
                IntegrationFrame e = new IntegrationFrame();
            }
            catch (Exception e) {
                log.error("logo init error with message {}", (Object)(e + e.getMessage()));
            }
        }
    }

    public GenericCdiServerContext getServerContext() {
        return this.serverContext;
    }

    public ServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public FtpServerWrap getFtpServer() {
        return this.ftpServer;
    }

    public SftpServerWrap getSftpServer() {
        return this.sftpServer;
    }

    public InitializeCdiServer getInitializeCDIServer() {
        return this.initializeCDIServer;
    }

    public IntSmartMapper getIntSmartMapper() {
        return this.intSmartMapper;
    }

    public IntegrateTask getIntegrateTask() {
        return this.integrateTask;
    }

    public DbProperties getDbProperties() {
        return this.dbProperties;
    }

    public JsonSchema getPrismartschema() {
        return this.prismartschema;
    }

    public StoreService getStoreService() {
        return this.storeService;
    }

    public boolean isCdiSwitch() {
        return this.cdiSwitch;
    }

    public int getHandlerThreadNum() {
        return this.handlerThreadNum;
    }

    public Boolean getIntegrationSync() {
        return this.integrationSync;
    }

    public ThreadPoolTaskExecutor getDatabasePoolExecutor() {
        return this.databasePoolExecutor;
    }

    public void setServerContext(GenericCdiServerContext serverContext) {
        this.serverContext = serverContext;
    }

    public void setServerHandler(ServerHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    public void setFtpServer(FtpServerWrap ftpServer) {
        this.ftpServer = ftpServer;
    }

    public void setSftpServer(SftpServerWrap sftpServer) {
        this.sftpServer = sftpServer;
    }

    public void setInitializeCDIServer(InitializeCdiServer initializeCDIServer) {
        this.initializeCDIServer = initializeCDIServer;
    }

    public void setIntSmartMapper(IntSmartMapper intSmartMapper) {
        this.intSmartMapper = intSmartMapper;
    }

    public void setIntegrateTask(IntegrateTask integrateTask) {
        this.integrateTask = integrateTask;
    }

    public void setDbProperties(DbProperties dbProperties) {
        this.dbProperties = dbProperties;
    }

    public void setPrismartschema(JsonSchema prismartschema) {
        this.prismartschema = prismartschema;
    }

    public void setStoreService(StoreService storeService) {
        this.storeService = storeService;
    }

    public void setCdiSwitch(boolean cdiSwitch) {
        this.cdiSwitch = cdiSwitch;
    }

    public void setHandlerThreadNum(int handlerThreadNum) {
        this.handlerThreadNum = handlerThreadNum;
    }

    public void setIntegrationSync(Boolean integrationSync) {
        this.integrationSync = integrationSync;
    }

    public void setDatabasePoolExecutor(ThreadPoolTaskExecutor databasePoolExecutor) {
        this.databasePoolExecutor = databasePoolExecutor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InitializeContext)) {
            return false;
        }
        InitializeContext other = (InitializeContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCdiSwitch() != other.isCdiSwitch()) {
            return false;
        }
        if (this.getHandlerThreadNum() != other.getHandlerThreadNum()) {
            return false;
        }
        Boolean this$integrationSync = this.getIntegrationSync();
        Boolean other$integrationSync = other.getIntegrationSync();
        if (this$integrationSync == null ? other$integrationSync != null : !((Object)this$integrationSync).equals(other$integrationSync)) {
            return false;
        }
        GenericCdiServerContext this$serverContext = this.getServerContext();
        GenericCdiServerContext other$serverContext = other.getServerContext();
        if (this$serverContext == null ? other$serverContext != null : !((Object)this$serverContext).equals(other$serverContext)) {
            return false;
        }
        ServerHandler this$serverHandler = this.getServerHandler();
        ServerHandler other$serverHandler = other.getServerHandler();
        if (this$serverHandler == null ? other$serverHandler != null : !this$serverHandler.equals(other$serverHandler)) {
            return false;
        }
        FtpServerWrap this$ftpServer = this.getFtpServer();
        FtpServerWrap other$ftpServer = other.getFtpServer();
        if (this$ftpServer == null ? other$ftpServer != null : !this$ftpServer.equals(other$ftpServer)) {
            return false;
        }
        SftpServerWrap this$sftpServer = this.getSftpServer();
        SftpServerWrap other$sftpServer = other.getSftpServer();
        if (this$sftpServer == null ? other$sftpServer != null : !this$sftpServer.equals(other$sftpServer)) {
            return false;
        }
        InitializeCdiServer this$initializeCDIServer = this.getInitializeCDIServer();
        InitializeCdiServer other$initializeCDIServer = other.getInitializeCDIServer();
        if (this$initializeCDIServer == null ? other$initializeCDIServer != null : !((Object)this$initializeCDIServer).equals(other$initializeCDIServer)) {
            return false;
        }
        IntSmartMapper this$intSmartMapper = this.getIntSmartMapper();
        IntSmartMapper other$intSmartMapper = other.getIntSmartMapper();
        if (this$intSmartMapper == null ? other$intSmartMapper != null : !this$intSmartMapper.equals(other$intSmartMapper)) {
            return false;
        }
        IntegrateTask this$integrateTask = this.getIntegrateTask();
        IntegrateTask other$integrateTask = other.getIntegrateTask();
        if (this$integrateTask == null ? other$integrateTask != null : !((Object)this$integrateTask).equals(other$integrateTask)) {
            return false;
        }
        DbProperties this$dbProperties = this.getDbProperties();
        DbProperties other$dbProperties = other.getDbProperties();
        if (this$dbProperties == null ? other$dbProperties != null : !((Object)this$dbProperties).equals(other$dbProperties)) {
            return false;
        }
        JsonSchema this$prismartschema = this.getPrismartschema();
        JsonSchema other$prismartschema = other.getPrismartschema();
        if (this$prismartschema == null ? other$prismartschema != null : !this$prismartschema.equals(other$prismartschema)) {
            return false;
        }
        StoreService this$storeService = this.getStoreService();
        StoreService other$storeService = other.getStoreService();
        if (this$storeService == null ? other$storeService != null : !this$storeService.equals(other$storeService)) {
            return false;
        }
        ThreadPoolTaskExecutor this$databasePoolExecutor = this.getDatabasePoolExecutor();
        ThreadPoolTaskExecutor other$databasePoolExecutor = other.getDatabasePoolExecutor();
        return !(this$databasePoolExecutor == null ? other$databasePoolExecutor != null : !this$databasePoolExecutor.equals(other$databasePoolExecutor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InitializeContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCdiSwitch() ? 79 : 97);
        result = result * 59 + this.getHandlerThreadNum();
        Boolean $integrationSync = this.getIntegrationSync();
        result = result * 59 + ($integrationSync == null ? 43 : ((Object)$integrationSync).hashCode());
        GenericCdiServerContext $serverContext = this.getServerContext();
        result = result * 59 + ($serverContext == null ? 43 : ((Object)$serverContext).hashCode());
        ServerHandler $serverHandler = this.getServerHandler();
        result = result * 59 + ($serverHandler == null ? 43 : $serverHandler.hashCode());
        FtpServerWrap $ftpServer = this.getFtpServer();
        result = result * 59 + ($ftpServer == null ? 43 : $ftpServer.hashCode());
        SftpServerWrap $sftpServer = this.getSftpServer();
        result = result * 59 + ($sftpServer == null ? 43 : $sftpServer.hashCode());
        InitializeCdiServer $initializeCDIServer = this.getInitializeCDIServer();
        result = result * 59 + ($initializeCDIServer == null ? 43 : ((Object)$initializeCDIServer).hashCode());
        IntSmartMapper $intSmartMapper = this.getIntSmartMapper();
        result = result * 59 + ($intSmartMapper == null ? 43 : $intSmartMapper.hashCode());
        IntegrateTask $integrateTask = this.getIntegrateTask();
        result = result * 59 + ($integrateTask == null ? 43 : ((Object)$integrateTask).hashCode());
        DbProperties $dbProperties = this.getDbProperties();
        result = result * 59 + ($dbProperties == null ? 43 : ((Object)$dbProperties).hashCode());
        JsonSchema $prismartschema = this.getPrismartschema();
        result = result * 59 + ($prismartschema == null ? 43 : $prismartschema.hashCode());
        StoreService $storeService = this.getStoreService();
        result = result * 59 + ($storeService == null ? 43 : $storeService.hashCode());
        ThreadPoolTaskExecutor $databasePoolExecutor = this.getDatabasePoolExecutor();
        result = result * 59 + ($databasePoolExecutor == null ? 43 : $databasePoolExecutor.hashCode());
        return result;
    }

    public String toString() {
        return "InitializeContext(serverContext=" + this.getServerContext() + ", serverHandler=" + this.getServerHandler() + ", ftpServer=" + this.getFtpServer() + ", sftpServer=" + this.getSftpServer() + ", initializeCDIServer=" + this.getInitializeCDIServer() + ", intSmartMapper=" + this.getIntSmartMapper() + ", integrateTask=" + this.getIntegrateTask() + ", dbProperties=" + this.getDbProperties() + ", prismartschema=" + this.getPrismartschema() + ", storeService=" + this.getStoreService() + ", cdiSwitch=" + this.isCdiSwitch() + ", handlerThreadNum=" + this.getHandlerThreadNum() + ", integrationSync=" + this.getIntegrationSync() + ", databasePoolExecutor=" + this.getDatabasePoolExecutor() + ")";
    }
}

