/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.config;

import com.hanshow.intsmart.centre.InitializeContext;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ExecutorConfig {
    @Autowired
    InitializeContext initializeContext;

    @Bean(name={"databasePoolExecutor"})
    public Executor databasePoolExecutor() {
        AtomicInteger SEQUENCE = new AtomicInteger(0);
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.initializeContext.getHandlerThreadNum());
        executor.setMaxPoolSize(this.initializeContext.getHandlerThreadNum());
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("database-worker-" + SEQUENCE.getAndIncrement());
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        executor.initialize();
        return executor;
    }

    public InitializeContext getInitializeContext() {
        return this.initializeContext;
    }

    public void setInitializeContext(InitializeContext initializeContext) {
        this.initializeContext = initializeContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutorConfig)) {
            return false;
        }
        ExecutorConfig other = (ExecutorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InitializeContext this$initializeContext = this.getInitializeContext();
        InitializeContext other$initializeContext = other.getInitializeContext();
        return !(this$initializeContext == null ? other$initializeContext != null : !((Object)this$initializeContext).equals(other$initializeContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InitializeContext $initializeContext = this.getInitializeContext();
        result = result * 59 + ($initializeContext == null ? 43 : ((Object)$initializeContext).hashCode());
        return result;
    }

    public String toString() {
        return "ExecutorConfig(initializeContext=" + this.getInitializeContext() + ")";
    }
}

