/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.executor;

import com.hanshow.cdi.ftp.FtpEventListener;
import com.hanshow.cdi.listener.SftpFileUploadedListener;
import com.hanshow.cdi.sftp.SftpServerWrap;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.factory.IntegrationHandlerFactory;
import com.hanshow.intsmart.handler.IntegrationHandler;
import com.hanshow.intsmart.handler.ServerHandler;
import com.hanshow.intsmart.listener.FileUploadedListener;
import com.hanshow.intsmart.listener.SftpUploadedListener;
import com.hanshow.intsmart.model.entity.FtpServerWrap;
import java.io.IOException;
import java.util.Map;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClientHandlerExecutor {
    private static final Logger log = LogManager.getLogger(ClientHandlerExecutor.class);
    private static Map<String, IntegrationHandler> integrationHandlerMap;
    private static FtpServerWrap ftpServer;
    private static SftpServerWrap sftpServer;
    private InitializeContext initializeContext;

    @Autowired
    public ClientHandlerExecutor(InitializeContext initializeContext) throws FtpException, IOException {
        this.initializeContext = initializeContext;
        ClientHandlerExecutor.createServer(initializeContext);
        integrationHandlerMap = IntegrationHandlerFactory.createHandler(initializeContext);
    }

    public static void reloadClientHandlerExecutor(InitializeContext initializeContext) throws FtpException, IOException {
        if (ftpServer != null) {
            ftpServer.stop();
        }
        if (sftpServer != null) {
            sftpServer.stop();
        }
        ClientHandlerExecutor.createServer(initializeContext);
        integrationHandlerMap = IntegrationHandlerFactory.createHandler(initializeContext);
    }

    private static void createServer(InitializeContext initializeContext) throws FtpException, IOException {
        if (initializeContext.getServerContext().getServerNum() > 0) {
            Object listener;
            int threadsNum = Math.min(initializeContext.getServerContext().getServerNum(), 4);
            ServerHandler serverHandler = new ServerHandler(threadsNum, initializeContext);
            if (initializeContext.getServerContext().isFtpServer()) {
                listener = new FileUploadedListener(initializeContext.getServerContext(), serverHandler);
                ftpServer = new FtpServerWrap(initializeContext.getServerContext().getFtpCustomerServerAddress());
                ftpServer.start(initializeContext.getServerContext().getFtpCustomerUsersPropertiesFile(), (FtpEventListener)listener);
            }
            if (initializeContext.getServerContext().isSftpServer()) {
                listener = new SftpUploadedListener(initializeContext.getServerContext(), serverHandler);
                sftpServer = new SftpServerWrap(initializeContext.getServerContext().getSftpCustomerServerAddress());
                sftpServer.start(initializeContext.getServerContext().getUserManager().getUserProperties(), (SftpFileUploadedListener)listener, initializeContext.getServerContext().getUserManager().getSftpUsers());
            }
        }
    }

    public void pushAll(String taskName) {
        log.info("================================PROCESSING TASK : {}=====================================", (Object)taskName);
        if (integrationHandlerMap.containsKey(taskName)) {
            integrationHandlerMap.get(taskName).process();
        }
        log.info("================================PROCESS TASK : {} END=====================================", (Object)taskName);
    }
}

