/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.factory;

import com.hanshow.cdi.core.IntegrationMode;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.handler.IntegrationHandler;
import com.hanshow.intsmart.handler.impl.ClientApiHandlerImpl;
import com.hanshow.intsmart.handler.impl.ClientDatabaseHandlerImpl;
import com.hanshow.intsmart.handler.impl.ClientFtpHandlerImpl;
import com.hanshow.intsmart.handler.impl.ClientLocalHandlerImpl;
import com.hanshow.intsmart.handler.impl.ClientSftpHandlerImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegrationHandlerFactory {
    private static final Logger log = LogManager.getLogger(IntegrationHandlerFactory.class);

    public static Map<String, IntegrationHandler> createHandler(InitializeContext initializeContext) {
        HashMap<String, IntegrationHandler> integrationHandlerMap = new HashMap<String, IntegrationHandler>();
        block9: for (CdiProperties.Task task : initializeContext.getServerContext().getTask()) {
            IntegrationMode im = IntegrationMode.getIntegrationMode(task.getIntegrationMode());
            switch (im) {
                case CLIENT_DATABASE: {
                    integrationHandlerMap.put(task.getTaskName(), IntegrationHandlerFactory.createClientDatabaseHandler(task.getTaskName(), initializeContext));
                    continue block9;
                }
                case CLIENT_FTP: {
                    integrationHandlerMap.put(task.getTaskName(), IntegrationHandlerFactory.createClientFtpHandler(task.getTaskName(), initializeContext));
                    continue block9;
                }
                case CLIENT_SFTP: {
                    integrationHandlerMap.put(task.getTaskName(), IntegrationHandlerFactory.createClientSftpHandler(task.getTaskName(), initializeContext));
                    continue block9;
                }
                case CLIENT_LOCAL: {
                    integrationHandlerMap.put(task.getTaskName(), IntegrationHandlerFactory.createClientLocalHandler(task.getTaskName(), initializeContext));
                    continue block9;
                }
                case SERVER_FTP: {
                    continue block9;
                }
                case SERVER_SFTP: {
                    continue block9;
                }
                case CLIENT_API: {
                    integrationHandlerMap.put(task.getTaskName(), IntegrationHandlerFactory.createClientApiHandler(task.getTaskName(), initializeContext));
                    continue block9;
                }
            }
        }
        return integrationHandlerMap;
    }

    private static IntegrationHandler createClientSftpHandler(String taskName, InitializeContext initializeContext) {
        return new ClientSftpHandlerImpl(taskName, initializeContext);
    }

    public static IntegrationHandler createClientDatabaseHandler(String taskName, InitializeContext initializeContext) {
        return new ClientDatabaseHandlerImpl(taskName, initializeContext);
    }

    public static IntegrationHandler createClientFtpHandler(String taskName, InitializeContext initializeContext) {
        return new ClientFtpHandlerImpl(taskName, initializeContext);
    }

    public static IntegrationHandler createClientLocalHandler(String taskName, InitializeContext initializeContext) {
        return new ClientLocalHandlerImpl(taskName, initializeContext);
    }

    public static IntegrationHandler createClientApiHandler(String taskName, InitializeContext initializeContext) {
        return new ClientApiHandlerImpl(initializeContext);
    }
}

