/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.handler.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.pagehelper.PageHelper;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.cdi.util.AESUtils;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.handler.IntegrationHandler;
import com.hanshow.intsmart.model.database.DynamicDataSource;
import com.hanshow.intsmart.util.PropertiesUtil;
import com.hanshow.intsmart.util.SpringUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientDatabaseHandlerImpl
extends IntegrationHandler {
    private static final Logger log = LogManager.getLogger(ClientDatabaseHandlerImpl.class);
    private InitializeContext initializeContext;
    private String taskName;

    public ClientDatabaseHandlerImpl(String taskName, InitializeContext initializeContext) {
        this.taskName = taskName;
        this.initializeContext = initializeContext;
    }

    @Override
    public List<File> process(String storeCode) {
        return null;
    }

    @Override
    public synchronized List<File> process() {
        if (!DynamicDataSource.dataSourcesMap.containsKey(this.taskName) || !this.compareDbUrl()) {
            DruidDataSource druidDataSource = new DruidDataSource();
            druidDataSource.setDriverClassName(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabaseDriver());
            druidDataSource.setUrl(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabaseUrl());
            druidDataSource.setUsername(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabaseUsername());
            druidDataSource.setPassword(AESUtils.decrypt(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabasePassword()));
            DynamicDataSource.setProperties(druidDataSource, this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabaseType(), this.initializeContext.getDbProperties());
            DynamicDataSource.dataSourcesMap.put(this.taskName, druidDataSource);
            DynamicDataSource dynamicDataSource = (DynamicDataSource)SpringUtils.getBean("dataSource");
            dynamicDataSource.setTargetDataSources(DynamicDataSource.dataSourcesMap);
            dynamicDataSource.afterPropertiesSet();
        }
        log.info("========================== [Task {}] begin query data ===============================", (Object)this.taskName);
        Map<String, CdiProperties.Store> storeCodeMap = this.initializeContext.getServerContext().getTaskServerStoreCodeMap().get(this.taskName);
        try {
            ArrayList<Future<String>> results = new ArrayList<Future<String>>();
            for (Map.Entry<String, CdiProperties.Store> entry : storeCodeMap.entrySet()) {
                String string = entry.getValue().getCustomerCode();
                results.add(this.initializeContext.getDatabasePoolExecutor().submit(() -> {
                    log.info("[Task {}] prepare to connect database... ", (Object)this.taskName);
                    try {
                        this.selectData(this.taskName, (String)entry.getKey(), customerStoreCode, !this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get(this.taskName).containsKey("storeCode"));
                        log.info("[Task {}] query database complete ", (Object)this.taskName);
                    }
                    catch (Exception e) {
                        log.error("[Task {}] query database failed, error msg : {} ", (Object)this.taskName, (Object)e.getMessage(), (Object)e);
                    }
                    return "";
                }));
            }
            ArrayList<String> finishList = new ArrayList<String>();
            for (Future future : results) {
                finishList.add((String)future.get(120L, TimeUnit.MINUTES));
            }
        }
        catch (Throwable e) {
            log.error("database integration error, error msg : {}", (Object)e.getMessage(), (Object)e);
        }
        DynamicDataSource.clear();
        return null;
    }

    private void sendData(List<Map<String, Object>> dataMap, String storeCode, String customerStoreCode) {
        log.info("[Task {} storeCode : {} ] Total {} items Sending CDI ", (Object)this.taskName, (Object)storeCode, (Object)dataMap.size());
        SimpleDateFormat batchDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String batchId = this.taskName + "-%s-%s-" + batchDateFormat.format(new Date());
        if (this.initializeContext.isCdiSwitch()) {
            DynamicDataSource.setDataSource("defaultDataSource");
            if (this.initializeContext.getIntegrationSync().booleanValue()) {
                this.initializeContext.getIntegrateTask().integrateListSync(dataMap, this.taskName, storeCode, customerStoreCode, null, String.format(batchId, customerStoreCode, storeCode), true);
            } else {
                this.initializeContext.getIntegrateTask().integrateList(dataMap, this.taskName, storeCode, customerStoreCode, null);
            }
            log.info("[Task {} storeCode : {} ] Sending data to Generic CDI complete ", (Object)this.taskName, (Object)storeCode);
        }
    }

    private void selectData(String taskName, String storeCode, String customerStoreCode, boolean single) {
        DynamicDataSource.setDataSource(taskName);
        List<Object> totalList = new ArrayList();
        if (StringUtils.isBlank(this.initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getDatabaseLimit())) {
            totalList = single ? this.initializeContext.getIntSmartMapper().selectAllData(taskName) : this.initializeContext.getIntSmartMapper().selectDataByCondition(taskName, storeCode);
            log.info("[Task {}] query from database finished, total {} goods.", (Object)taskName, (Object)totalList.size());
        } else {
            String limit = this.initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getDatabaseLimit();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            boolean foot = true;
            int begin = 1;
            log.info("[Task {}] begin paging query from database...", (Object)taskName);
            while (foot) {
                PageHelper.startPage(begin, Integer.parseInt(limit));
                List<Map<String, Object>> limitList = single ? this.initializeContext.getIntSmartMapper().selectAllData(taskName) : this.initializeContext.getIntSmartMapper().selectDataByCondition(taskName, storeCode);
                if (limitList.size() < Integer.parseInt(limit)) {
                    foot = false;
                }
                log.info("[Task {}] paging query [{}], goods num {} ", (Object)taskName, (Object)(++begin), (Object)limitList.size());
                list.addAll(limitList);
            }
            totalList = list;
            log.info("[Task {}] query from database finished, total {} goods.", (Object)taskName, (Object)totalList.size());
        }
        boolean distinguishStoreFlag = this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get(taskName).containsKey("storeCode");
        log.info("[Task {}] begin to process {} items... ", (Object)taskName, (Object)totalList.size());
        LinkedHashMap<String, List<Map<String, Object>>> storeItemsList = new LinkedHashMap<String, List<Map<String, Object>>>();
        try {
            Iterator<Object> it = totalList.iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                if (map.get(this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get(taskName).get("sku").getCustomer()) != null) {
                    this.formatItem(map, storeItemsList, distinguishStoreFlag);
                    continue;
                }
                log.warn("This data has no sku, data is {}", (Object)map);
                it.remove();
            }
        }
        catch (Exception e) {
            log.error("[Task {}] process items failed, error msg : {} ", (Object)taskName, (Object)(e.getMessage() + e));
        }
        if (distinguishStoreFlag) {
            log.info("[Task {}] begin send items to store {}", (Object)taskName, (Object)storeItemsList.keySet());
            storeItemsList.forEach((hanshowStoreCode, itemsList) -> this.sendData((List<Map<String, Object>>)itemsList, (String)hanshowStoreCode, this.initializeContext.getServerContext().getTaskServerStoreCodeMap().get(taskName).get(hanshowStoreCode).getCustomerCode()));
        } else {
            log.info("[Task {}] begin send {} items to all store", (Object)taskName, (Object)totalList.size());
            if (!totalList.isEmpty()) {
                Map<String, CdiProperties.Store> storeCodeMap = this.initializeContext.getServerContext().getTaskServerStoreCodeMap().get(taskName);
                List<Object> finalTotalList = totalList;
                storeCodeMap.forEach((hanshowStoreCode, store) -> {
                    finalTotalList.forEach(item -> {
                        item.put("storeCode", hanshowStoreCode);
                        item.put("customerStoreCode", store.getCustomerCode());
                    });
                    this.sendData((List<Map<String, Object>>)finalTotalList, (String)hanshowStoreCode, store.getCustomerCode());
                });
            }
        }
    }

    private void formatItem(Map<String, Object> map, Map<String, List<Map<String, Object>>> storeItemsList, boolean distinguishStoreFlag) {
        map.remove("PAGE_ROW_NUMBER");
        map.remove("ROW_ID");
        if (StringUtils.isNotBlank(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getMvel())) {
            PropertiesUtil.mvelProcess(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getMvel(), map);
        }
        for (String key : map.keySet()) {
            if (!this.initializeContext.getServerContext().getTaskFieldsDateFormat().get(this.taskName).containsKey(key)) continue;
            this.dateConvert(map, key, this.initializeContext.getServerContext().getTaskFieldsDateFormat().get(this.taskName).get(key));
        }
        if (this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getConvert().isConvertSwitch()) {
            map.put(this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get(this.taskName).get(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getConvert().getUnitField()).getCustomer(), "500g");
            for (String convertFieldName : this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getConvert().getConvertFields()) {
                if (map.get(this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get(this.taskName).get(convertFieldName).getCustomer()) == null) continue;
                String convertFieldValue = map.get(this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get(this.taskName).get(convertFieldName).getCustomer()).toString();
                try {
                    double value = Double.parseDouble(convertFieldValue) / 2.0;
                    map.put(this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get(this.taskName).get(convertFieldName).getCustomer(), String.format("%.2f", value));
                }
                catch (Exception e) {
                    log.error("unit format error ,{} : {}, with message {}", (Object)convertFieldName, (Object)convertFieldValue, (Object)(e + e.getMessage()));
                }
            }
        }
        if (distinguishStoreFlag) {
            if (map.get(this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get(this.taskName).get("storeCode").getCustomer()) != null) {
                String storeCode = map.get(this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get(this.taskName).get("storeCode").getCustomer()).toString();
                if (this.initializeContext.getServerContext().getTaskServerTransformStoreCodeMap().get(this.taskName).containsKey(storeCode)) {
                    if (StringUtils.isNotBlank(this.initializeContext.getServerContext().getTaskServerTransformStoreCodeMap().get(this.taskName).get(storeCode))) {
                        storeCode = this.initializeContext.getServerContext().getTaskServerTransformStoreCodeMap().get(this.taskName).get(storeCode);
                    }
                    String customerStoreCode = this.initializeContext.getServerContext().getTaskServerStoreCodeMap().get(this.taskName).get(storeCode).getCustomerCode();
                    map.put("customerStoreCode", customerStoreCode);
                    map.put("storeCode", storeCode);
                    if (!storeItemsList.containsKey(storeCode)) {
                        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                        list.add(map);
                        storeItemsList.put(storeCode, list);
                    } else {
                        storeItemsList.get(storeCode).add(map);
                    }
                } else {
                    log.warn("[Task {}] storeCode {} not config in integration", (Object)this.taskName, (Object)storeCode);
                }
            } else {
                log.warn("[Task {}] storeCode is null for sku {}", (Object)this.taskName, map.get(this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get(this.taskName).get("sku").getCustomer()));
            }
        }
    }

    private void dateConvert(Map<String, Object> map, String key, SimpleDateFormat dateFormat) {
        try {
            if (StringUtils.isNotBlank((String)map.get(key))) {
                map.put(key, dateFormat.parse(map.get(key).toString()).getTime());
            } else {
                map.put(key, null);
            }
        }
        catch (Exception e) {
            map.put(key, null);
            log.error("dateFormat parse {} failed : {}", (Object)key, (Object)e);
        }
    }

    private boolean compareDbUrl() {
        if (StringUtils.isNotBlank(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabaseUsername()) && StringUtils.isNotBlank(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabasePassword())) {
            return this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabaseUrl().trim().equals(((DruidDataSource)DynamicDataSource.dataSourcesMap.get(this.taskName)).getUrl()) && this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabaseUsername().equals(((DruidDataSource)DynamicDataSource.dataSourcesMap.get(this.taskName)).getUsername()) && AESUtils.decrypt(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabasePassword()).equals(((DruidDataSource)DynamicDataSource.dataSourcesMap.get(this.taskName)).getPassword());
        }
        return this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getDatabaseUrl().trim().equals(((DruidDataSource)DynamicDataSource.dataSourcesMap.get(this.taskName)).getUrl());
    }
}

