/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.handler.impl;

import com.hanshow.cdi.common.GetStoreCodeTypeEnum;
import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.handler.IntegrationHandler;
import com.hanshow.intsmart.service.ProcessFileService;
import com.hanshow.intsmart.service.impl.ProcessFileServiceImpl;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientLocalHandlerImpl
extends IntegrationHandler {
    private static final Logger log = LogManager.getLogger(ClientLocalHandlerImpl.class);
    private final ExecutorService executorService;
    private static final AtomicInteger SEQUENCE = new AtomicInteger(0);
    private final GenericCdiServerContext serverContext;
    private final ProcessFileService processFileService;
    private InitializeContext initializeContext;
    private String taskName;

    public ClientLocalHandlerImpl(String taskName, InitializeContext initializeContext) {
        this.initializeContext = initializeContext;
        this.taskName = taskName;
        this.serverContext = initializeContext.getServerContext();
        this.processFileService = new ProcessFileServiceImpl(initializeContext);
        this.executorService = Executors.newFixedThreadPool(initializeContext.getHandlerThreadNum(), r -> new Thread(r, "ClientLocalHandlerImpl-" + SEQUENCE.getAndIncrement()));
    }

    @Override
    public List<File> process(String storeCode) {
        this.processFileByDir(storeCode);
        return null;
    }

    @Override
    public List<File> process() {
        if (this.serverContext.getTaskMap().get(this.taskName).getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.FromFile.getType()) {
            this.processFile();
        } else if (this.serverContext.getTaskMap().get(this.taskName).getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.ByDir.getType()) {
            this.serverContext.getTaskServerStoreCodeMap().get(this.taskName).values().forEach(store -> this.executorService.execute(() -> this.processFileByDir(store.getStoreCode())));
        } else if (this.serverContext.getTaskMap().get(this.taskName).getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.ByFileName.getType()) {
            this.processFileByFileName();
        } else if (this.serverContext.getTaskMap().get(this.taskName).getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.ToAllStores.getType()) {
            this.processFileToAllStores();
        } else {
            log.warn("FileGetType is error:{}", (Object)this.serverContext.getTaskMap().get(this.taskName).getDatasource().getFileGetType());
        }
        return null;
    }

    public void processFile() {
        List fileList = Arrays.stream(this.serverContext.getTaskLocalDirMap().get(this.taskName).listFiles()).filter(file -> {
            if (file.isDirectory()) {
                return false;
            }
            if (StringUtils.isNotBlank(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getFilePrefix())) {
                return file.getName().startsWith(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getFilePrefix());
            }
            return true;
        }).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList());
        log.info(String.format("[Task %s] Total %s files have been downloaded from the LocalDir! ", this.taskName, fileList.size()));
        for (File file2 : fileList) {
            super.processFile(this.processFileService, file2, this.serverContext, this.taskName);
        }
    }

    public void processFileByDir(String storeCode) {
        File fileDir = new File(this.serverContext.getTaskLocalDirMap().get(this.taskName) + File.separator + storeCode);
        List fileList = Arrays.stream(fileDir.listFiles()).filter(file -> {
            if (file.isDirectory()) {
                return false;
            }
            if (StringUtils.isNotBlank(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getFilePrefix())) {
                return file.getName().startsWith(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getFilePrefix());
            }
            return true;
        }).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList());
        log.info("[Task {} storeCode : {} ] Total {} files have been downloaded from the localDir! ", (Object)this.taskName, (Object)storeCode, (Object)fileList.size());
        for (File file2 : fileList) {
            super.processFileByDir(this.processFileService, file2, this.serverContext, storeCode, this.taskName);
        }
    }

    public void processFileByFileName() {
        List fileList = Arrays.stream(this.serverContext.getTaskLocalDirMap().get(this.taskName).listFiles()).filter(file -> {
            if (file.isDirectory()) {
                return false;
            }
            if (StringUtils.isNotBlank(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getFilePrefix())) {
                return file.getName().startsWith(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getFilePrefix());
            }
            return true;
        }).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList());
        log.info(String.format("[Task %s] Total %s files have been downloaded from the LocalDir! ", this.taskName, fileList.size()));
        for (File file2 : fileList) {
            super.processFileByFileName(this.processFileService, file2, this.serverContext, this.taskName);
        }
    }

    public void processFileToAllStores() {
        List fileList = Arrays.stream(this.serverContext.getTaskLocalDirMap().get(this.taskName).listFiles()).filter(file -> {
            if (file.isDirectory()) {
                return false;
            }
            if (StringUtils.isNotBlank(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getFilePrefix())) {
                return file.getName().startsWith(this.initializeContext.getServerContext().getTaskMap().get(this.taskName).getDatasource().getFilePrefix());
            }
            return true;
        }).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList());
        log.info(String.format("[Task %s] Total %s files have been downloaded from the LocalDir! ", this.taskName, fileList.size()));
        for (File file2 : fileList) {
            super.processFileToAllStores(this.processFileService, file2, this.serverContext, this.taskName);
        }
    }
}

