/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.handler.impl;

import com.hanshow.cdi.common.GetStoreCodeTypeEnum;
import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.handler.IntegrationHandler;
import com.hanshow.intsmart.service.ProcessFileService;
import com.hanshow.intsmart.service.impl.ProcessFileServiceImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientSftpHandlerImpl
extends IntegrationHandler {
    private static final Logger log = LogManager.getLogger(ClientSftpHandlerImpl.class);
    private ProcessFileService processFileService;
    private GenericCdiServerContext serverContext;
    private static AtomicInteger SEQUENCE = new AtomicInteger(0);
    private ExecutorService executorService;
    private InitializeContext initializeContext;
    private String taskName;

    public ClientSftpHandlerImpl(String taskName, InitializeContext initializeContext) {
        this.initializeContext = initializeContext;
        this.taskName = taskName;
        this.processFileService = new ProcessFileServiceImpl(initializeContext);
        this.serverContext = initializeContext.getServerContext();
        this.executorService = Executors.newFixedThreadPool(initializeContext.getHandlerThreadNum(), r -> new Thread(r, "ClientSftpHandlerImpl-" + SEQUENCE.getAndIncrement()));
    }

    @Override
    public List<File> process(String storeCode) {
        return null;
    }

    @Override
    public List<File> process() {
        ArrayList futures = new ArrayList();
        if (this.serverContext.getTaskMap().get(this.taskName).getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.FromFile.getType()) {
            this.processFile();
        } else if (this.serverContext.getTaskMap().get(this.taskName).getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.ByDir.getType()) {
            this.serverContext.getTaskServerStoreCodeMap().get(this.taskName).values().forEach(store -> {
                Future<?> future = this.executorService.submit(() -> this.processFileByDir(store.getStoreCode()));
                futures.add(future);
            });
        } else if (this.serverContext.getTaskMap().get(this.taskName).getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.ByFileName.getType()) {
            this.processFileByFileName();
        } else if (this.serverContext.getTaskMap().get(this.taskName).getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.ToAllStores.getType()) {
            this.processFileToAllStores();
        } else {
            log.warn("FileGetType is error:{}", (Object)this.serverContext.getTaskMap().get(this.taskName).getDatasource().getFileGetType());
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.currentThread().interrupt();
                log.error("Task execution interrupted or failed {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return null;
    }

    private void processFileByFileName() {
        List<File> fileList = this.downloadSftpFiles(this.initializeContext, null, this.taskName);
        log.info(String.format("Total %s files have been downloaded from the target SFTP! ", fileList.size()));
        fileList.sort(Comparator.comparingLong(File::lastModified));
        for (File file : fileList) {
            this.executorService.execute(() -> this.processFileByFileName(this.processFileService, file, this.serverContext, this.taskName));
        }
    }

    private void processFileByDir(String storeCode) {
        List<File> fileList = this.downloadSftpFiles(this.initializeContext, storeCode, this.taskName);
        log.info("[ {} ] Total {} files have been downloaded from the target SFTP! ", (Object)storeCode, (Object)fileList.size());
        fileList.sort(Comparator.comparingLong(File::lastModified));
        for (File file : fileList) {
            super.processFileByDir(this.processFileService, file, this.serverContext, storeCode, this.taskName);
        }
    }

    private void processFile() {
        List<File> fileList = this.downloadSftpFiles(this.initializeContext, null, this.taskName);
        log.info(String.format("Total %s files have been downloaded from the target SFTP! ", fileList.size()));
        fileList.sort(Comparator.comparingLong(File::lastModified));
        fileList.forEach(file -> super.processFile(this.processFileService, (File)file, this.serverContext, this.taskName));
    }

    public void processFileToAllStores() {
        List<File> fileList = this.downloadSftpFiles(this.initializeContext, null, this.taskName);
        log.info(String.format("Total %s files have been downloaded from the target FTP! ", fileList.size()));
        fileList.sort(Comparator.comparingLong(File::lastModified));
        for (File file : fileList) {
            super.processFileToAllStores(this.processFileService, file, this.serverContext, this.taskName);
        }
    }
}

