/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.listener;

import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.listener.SftpFileUploadedListener;
import com.hanshow.cdi.util.Utils;
import com.hanshow.intsmart.enums.ServerTypeEnum;
import com.hanshow.intsmart.handler.ServerHandler;
import com.hanshow.intsmart.model.entity.CustomerUploadFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.Handle;

public class SftpUploadedListener
extends SftpFileUploadedListener {
    private static final Logger log = LogManager.getLogger(SftpUploadedListener.class);
    private ServerHandler processor;
    private GenericCdiServerContext serverContext;
    private static SimpleDateFormat bakDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public SftpUploadedListener(GenericCdiServerContext serverContext, ServerHandler processor) {
        this.serverContext = serverContext;
        this.processor = processor;
    }

    @Override
    public void close(ServerSession session, String remoteHandle, Handle localHandle) {
        block8: {
            Path obj = localHandle.getFile().getFileName();
            String userName = session.getUsername();
            try {
                String storeCode;
                if (obj == null) break block8;
                String fileName = ((Object)obj).toString();
                Integer fileType = this.serverContext.getTaskMap().get(userName).getDatasource().getFileGetType();
                if (fileType == 3) {
                    storeCode = this.processor.getStoreCodeByPattern(fileName, this.serverContext.getTaskMap().get(userName).getDatasource().getFilePattern());
                    if (!this.serverContext.getTaskServerTransformStoreCodeMap().get(userName).containsKey(storeCode)) {
                        log.info("Store {} is not configured", (Object)storeCode);
                        if (!localHandle.getFile().toFile().delete()) {
                            log.info("Task [{}] delete file [{}] error", (Object)userName, (Object)fileName);
                        }
                        return;
                    }
                } else {
                    storeCode = null;
                }
                CustomerUploadFile customerUploadFile = new CustomerUploadFile(userName, localHandle.getFile().getParent().toString(), fileName, this.serverContext.getRootDir(), userName, storeCode, ServerTypeEnum.SFTP);
                File target = new File(this.serverContext.getBackupDir() + File.separator + userName + File.separator + bakDateFormat.format(new Date()) + "-" + fileName);
                try {
                    Utils.copyFile(customerUploadFile.getAbsoluteFile(), target);
                }
                catch (IOException e) {
                    log.warn("backup file failed with IOException: " + target);
                }
                log.info(String.format("Task %s received customer uploaded file: " + customerUploadFile.getAbsoluteFile().getAbsolutePath(), userName));
                this.processor.submit(customerUploadFile);
            }
            catch (Exception e) {
                log.info(e.getMessage(), (Throwable)e);
            }
        }
    }
}

