/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.model.database;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.hanshow.intsmart.configuration.DbProperties;
import com.hanshow.intsmart.model.database.DynamicDataSource;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
public class DataSourceConfig {
    @Autowired
    private Environment environment;
    @Autowired
    private DbProperties dbProperties;
    @Value(value="${cdi.switch}")
    private boolean cdiSwitch;

    @PostConstruct
    public void init() {
        System.setProperty("druid.mysql.usePingMethod", "false");
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid")
    public DataSource defaultDataSource() {
        return DruidDataSourceBuilder.create().build();
    }

    @Bean
    @DependsOn(value={"springUtils", "defaultDataSource"})
    public DynamicDataSource dataSource() {
        String url = this.environment.getProperty("spring.datasource.defaultDataSource.url");
        String username = this.environment.getProperty("spring.datasource.defaultDataSource.username");
        String password = this.environment.getProperty("spring.datasource.defaultDataSource.password");
        DynamicDataSource dynamicDataSource = new DynamicDataSource("MYSQL", url, username, password, this.dbProperties, this.cdiSwitch);
        dynamicDataSource.setTargetDataSources(DynamicDataSource.dataSourcesMap);
        return dynamicDataSource;
    }
}

