/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.scheduler;

import com.hanshow.cdi.core.CdiMode;
import com.hanshow.cdi.core.IntegrationMode;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.enums.TaskStatusEnum;
import com.hanshow.intsmart.job.ClientIntegrationJob;
import com.hanshow.intsmart.job.DataBaseCleanJob;
import com.hanshow.intsmart.job.DataCleanerJob;
import com.hanshow.intsmart.job.HeartbeatSendJob;
import com.hanshow.intsmart.util.CleanUtil;
import com.hanshow.intsmart.util.CronUtil;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class JobExcuteScheduler {
    private static final Logger log = LogManager.getLogger(JobExcuteScheduler.class);
    @Autowired
    SchedulerFactoryBean schedulerFactoryBean;
    @Autowired
    InitializeContext initializeContext;
    static Scheduler scheduler;

    public void scheduleJobs() throws SchedulerException {
        scheduler = this.schedulerFactoryBean.getScheduler();
        for (CdiProperties.Task task : this.initializeContext.getServerContext().getTask()) {
            if (task.getHeartBeatSendTime().equals("0")) continue;
            JobExcuteScheduler.runHeartbeatSendJobForOnce(task.getTaskName());
            JobExcuteScheduler.initHeartbeatSendJob(task.getTaskName(), CronUtil.getCron(task.getHeartBeatSendTime(), null, null));
        }
        JobExcuteScheduler.startCacheCleanerJob();
        String rootDir = this.initializeContext.getServerContext().getRootDir().getAbsolutePath();
        JobExcuteScheduler.startDataBaseCleanJob();
        for (CdiProperties.Task task : this.initializeContext.getServerContext().getTask()) {
            if (!TaskStatusEnum.STATE_NONE.getName().equalsIgnoreCase(JobExcuteScheduler.getClientIntegrationJobStatus(task.getTaskName())) || !task.isIntegrationStatus() || IntegrationMode.SERVER_HTTP.getName().equals(task.getIntegrationMode())) continue;
            if (task.getDayOrCycle().equals("day")) {
                log.info("-------------------[Task {} auto start integration , the cron is {} ]", (Object)task.getTaskName(), (Object)task.getStartIntegrationTime());
                JobExcuteScheduler.initClientIntegrationJob(task.getTaskName(), task.getDayOrCycle(), CronUtil.getCron(task.getExecuteCycle(), null, null), task.getCdiMode(), task.getStores(), rootDir);
                continue;
            }
            JobExcuteScheduler.initClientIntegrationJob(task.getTaskName(), task.getDayOrCycle(), CronUtil.getCron(task.getExecuteCycle(), task.getStartIntegrationTime(), task.getEndIntegrationTime()), task.getCdiMode(), task.getStores(), rootDir);
        }
    }

    public static void initClientIntegrationJob(String taskName, String dayOrCycle, String time, String cdiMode, List<CdiProperties.Store> stores, String rootDir) throws SchedulerException {
        if (cdiMode.equals(CdiMode.FIRSTFULL.getName())) {
            CleanUtil.cleanDir(taskName, stores, rootDir);
        }
        TriggerKey triggerKey = TriggerKey.triggerKey("initClientIntegrationJobTrigger-" + taskName, "integrationGroup");
        if ("day".equals(dayOrCycle)) {
            CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
            if (null == trigger) {
                JobDetail jobDetail = JobBuilder.newJob(ClientIntegrationJob.class).withIdentity("initClientIntegrationJob-" + taskName, "integrationGroup").build();
                jobDetail.getJobDataMap().put("taskName", taskName);
                CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule(time);
                CronTrigger cronTrigger = TriggerBuilder.newTrigger().withIdentity("initClientIntegrationJobTrigger-" + taskName, "integrationGroup").withSchedule(scheduleBuilder).build();
                scheduler.scheduleJob(jobDetail, cronTrigger);
            } else {
                CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule(time);
                trigger = trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule(scheduleBuilder).build();
                scheduler.rescheduleJob(triggerKey, trigger);
            }
        } else {
            CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
            if (null == trigger) {
                CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule(time);
                JobDetail jobDetail = JobBuilder.newJob(ClientIntegrationJob.class).withIdentity("initClientIntegrationJob-" + taskName, "integrationGroup").build();
                jobDetail.getJobDataMap().put("taskName", taskName);
                CronTrigger cronTrigger = TriggerBuilder.newTrigger().withIdentity("initClientIntegrationJobTrigger-" + taskName, "integrationGroup").withSchedule(scheduleBuilder).build();
                scheduler.scheduleJob(jobDetail, cronTrigger);
            } else {
                CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule(time);
                trigger = trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule(scheduleBuilder).build();
                scheduler.rescheduleJob(triggerKey, trigger);
            }
        }
        log.info("-------------------[Task {} Integration is Start]-------------------", (Object)taskName);
    }

    public static String getClientIntegrationJobStatus(String taskName) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey("initClientIntegrationJobTrigger-" + taskName, "integrationGroup");
        return scheduler.getTriggerState(triggerKey).name();
    }

    public static void pauseClientIntegrationJob() throws SchedulerException {
        scheduler.pauseJob(JobKey.jobKey("initClientIntegrationJob", "integrationGroup"));
    }

    public static void resumeClientIntegrationJob() throws SchedulerException {
        scheduler.resumeJob(JobKey.jobKey("initClientIntegrationJob", "integrationGroup"));
    }

    public static boolean stopClientIntegrationJob(String taskName) throws SchedulerException {
        log.info("------------------- [ Stop Integration ] -------------------");
        return scheduler.deleteJob(JobKey.jobKey("initClientIntegrationJob-" + taskName, "integrationGroup"));
    }

    public static void startCacheCleanerJob() throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(DataCleanerJob.class).withIdentity("dataCleanerJob", "cleanerGroup").build();
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule("0 0 0,6,12,18 * * ? ");
        CronTrigger cronTrigger = TriggerBuilder.newTrigger().withIdentity("dataCleanerJobTrigger", "cleanerGroup").withSchedule(scheduleBuilder).build();
        scheduler.scheduleJob(jobDetail, cronTrigger);
    }

    public static void startDataBaseCleanJob() throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(DataBaseCleanJob.class).withIdentity("databaseCleanJob", "databaseCleanerGroup").build();
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule("0 0 0,6,12,18 * * ? ");
        CronTrigger cronTrigger = TriggerBuilder.newTrigger().withIdentity("databaseCleanJob", "databaseCleanerGroup").withSchedule(scheduleBuilder).build();
        scheduler.scheduleJob(jobDetail, cronTrigger);
    }

    public static void runHeartbeatSendJobForOnce(String taskName) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(HeartbeatSendJob.class).withIdentity("runHeartbeatSendJobForOnce-" + taskName, "heartbeatGroup").build();
        SimpleTrigger simpleTrigger = TriggerBuilder.newTrigger().withIdentity("runHeartbeatSendJobForOnceTrigger-" + taskName, "heartbeatGroup").startAt(new Date(System.currentTimeMillis() + 15000L)).withSchedule(SimpleScheduleBuilder.simpleSchedule().withRepeatCount(0)).build();
        scheduler.scheduleJob(jobDetail, simpleTrigger);
    }

    public static void initHeartbeatSendJob(String taskName, String cron) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(HeartbeatSendJob.class).withIdentity("heartbeatSendJob-" + taskName, "heartbeatGroup").build();
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule(cron);
        CronTrigger cronTrigger = TriggerBuilder.newTrigger().withIdentity("heartbeatSendJobTrigger-" + taskName, "heartbeatGroup").withSchedule(scheduleBuilder).build();
        scheduler.scheduleJob(jobDetail, cronTrigger);
    }

    public static void modifyHeartbeatSendJob(String cron) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey("heartbeatSendJobTrigger", "heartbeatGroup");
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule(cron);
        CronTrigger newTrigger = TriggerBuilder.newTrigger().withIdentity("heartbeatSendJobTrigger", "heartbeatGroup").withSchedule(scheduleBuilder).build();
        scheduler.rescheduleJob(triggerKey, newTrigger);
    }

    public static String getHeartbeatSendJobStatus() throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey("heartbeatSendJobTrigger", "heartbeatGroup");
        return scheduler.getTriggerState(triggerKey).name();
    }

    public static void pauseHeartbeatSendJob() throws SchedulerException {
        scheduler.pauseJob(JobKey.jobKey("heartbeatSendJob", "heartbeatGroup"));
    }

    public static void resumeHeartbeatSendJob() throws SchedulerException {
        scheduler.resumeJob(JobKey.jobKey("heartbeatSendJob", "heartbeatGroup"));
    }

    public static boolean stopHeartbeatSendJob() throws SchedulerException {
        return scheduler.deleteJob(JobKey.jobKey("heartbeatSendJob", "heartbeatGroup"));
    }

    public static void startHeartbeatSendJob() throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(HeartbeatSendJob.class).withIdentity("heartbeatSendJob", "heartbeatGroup").build();
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule("0 0/30 * * * ? *");
        CronTrigger cronTrigger = TriggerBuilder.newTrigger().withIdentity("heartbeatSendJobTrigger", "heartbeatGroup").withSchedule(scheduleBuilder).build();
        scheduler.scheduleJob(jobDetail, cronTrigger);
    }
}

