/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hanshow.cdi.core.IntegrateTask;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.intsmart.api.ShopWebApiResponse;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import com.hanshow.intsmart.service.CustomerDataService;
import com.hanshow.intsmart.util.CommandUtil;
import com.hanshow.intsmart.util.JsonSchemaUtil;
import com.hanshow.intsmart.util.PrismartSender;
import java.net.ConnectException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerDataServiceImpl
implements CustomerDataService {
    private static final Logger log = LogManager.getLogger(CustomerDataServiceImpl.class);
    private static Pattern pattern = Pattern.compile("[0-9]*");
    @Autowired
    IntegrateTask integrateTask;
    @Autowired
    InitializeContext initializeContext;
    @Value(value="${cdi.switch}")
    boolean cdiSwitch;
    @Autowired
    PrismartSender prismartSender;

    @Override
    public void processData(Map<String, Object> data) {
        ArrayList<Map<String, Object>> goodsList = new ArrayList();
        String storeCode = (String)data.get("storeCode");
        String customerStoreCode = (String)data.get("customerStoreCode");
        goodsList = (List)data.get("items");
        log.info("send prismart");
        this.integrateTask.integrateList(goodsList, "api", storeCode, customerStoreCode, null);
    }

    @Override
    public Object processData(String request, String taskName) throws Exception {
        JSONObject requestMap = JSONObject.parseObject(request);
        String customerStoreCode = (String)requestMap.get("customerStoreCode");
        String storeCode = (String)requestMap.get("storeCode");
        String batchNo = (String)requestMap.get("batchNo");
        String backUrl = (String)requestMap.get("callbackUrl");
        if (batchNo == null) {
            return CustomerDataServiceImpl.fail(ShopWebApiResultCodeEnum.cdi_illegal_arguments);
        }
        if (StringUtils.isBlank(customerStoreCode) || StringUtils.isBlank(storeCode)) {
            return CustomerDataServiceImpl.fail(ShopWebApiResultCodeEnum.cdi_store_not_null);
        }
        if (!requestMap.containsKey("items")) {
            return CustomerDataServiceImpl.fail(ShopWebApiResultCodeEnum.cdi_illegal_arguments);
        }
        List<Map<String, Object>> items = null;
        try {
            items = (List<Map<String, Object>>)requestMap.get("items");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return CustomerDataServiceImpl.fail(ShopWebApiResultCodeEnum.cdi_illegal_arguments);
        }
        int requestSize = items.size();
        int max = this.initializeContext.getPrismartschema().getSchemaNode().get("properties").get("items").get("maxItems").asInt();
        if (requestSize > max) {
            return CustomerDataServiceImpl.fail(ShopWebApiResultCodeEnum.cdi_illegal_integration_data, "The number of batches cannot exceed %s", max);
        }
        long begin = System.currentTimeMillis();
        boolean successAll = true;
        ArrayList<Map<String, Object>> failedDataList = new ArrayList<Map<String, Object>>();
        items = this.convertFieldsAndDateTime(items, this.initializeContext.getServerContext().getTaskCustomerPrismartFieldsMap().get(taskName));
        requestMap.put("items", items);
        if (requestSize > 0) {
            Map<Integer, Map<String, Object>> map = JsonSchemaUtil.getPrismartProcessingReport(JsonSchemaUtil.strToJsonNode(JSONObject.toJSONString(requestMap)), this.initializeContext.getPrismartschema());
            log.info("jsonSchema validate expend time : {}", (Object)(System.currentTimeMillis() - begin));
            if (map.size() > 0) {
                log.warn("org : {} has {} article validate failed, request : {}, errorTxt : {}", (Object)customerStoreCode, (Object)map.size(), (Object)request, (Object)map);
                Iterator<Map<String, Object>> iterator = items.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    Map<String, Object> tmp = iterator.next();
                    if (map.containsKey(i)) {
                        map.get(i).put("sku", tmp.get("sku"));
                        CommandUtil.command(i, tmp, map.get(i));
                        iterator.remove();
                    }
                    ++i;
                }
            }
            if (map.size() > 0) {
                failedDataList.addAll(map.values());
                if (map.size() == requestSize) {
                    LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
                    resultMap.put("resultCode", ShopWebApiResultCodeEnum.cdi_data_verification_failed.getCode());
                    resultMap.put("message", ShopWebApiResultCodeEnum.cdi_data_verification_failed.getMessage());
                    resultMap.put("data", failedDataList);
                    log.warn("All Data verification failed, org : {}, terminal is {}, request : {}", (Object)customerStoreCode, (Object)storeCode, (Object)request);
                    return resultMap;
                }
                successAll = false;
            }
        }
        log.info("org : {} terminal : {}, batchNo : {}, batchSize : {} validate complete expend time : {}ms", (Object)customerStoreCode, (Object)storeCode, (Object)batchNo, (Object)items.size(), (Object)(System.currentTimeMillis() - begin));
        CdiProperties.Task task = this.initializeContext.getServerContext().getTaskMap().get(taskName);
        if (task.getServerUrls().size() == 1) {
            String url = task.getServerUrls().get(0).getIntegrationUrl();
            String prismartResponse = "";
            String data = JSON.toJSONString(requestMap);
            try {
                log.debug("customerCode : {}, storeCode : {}, data : {}", (Object)customerStoreCode, (Object)storeCode, (Object)data);
                prismartResponse = this.prismartSender.sendPrismart(url, customerStoreCode, data);
            }
            catch (ConnectException ce) {
                log.warn(String.format("send batch data to %s server failed due to cannot connect server.", storeCode), (Throwable)ce);
                return prismartResponse;
            }
            catch (Exception e) {
                log.warn(String.format("send batch data to %s server failed.", storeCode), (Throwable)e);
                return prismartResponse;
            }
            try {
                JSONObject responseMap = JSONObject.parseObject(prismartResponse);
                Integer resultCode = (Integer)responseMap.get("resultCode");
                if (!resultCode.equals(1001) && !resultCode.equals(0)) {
                    if (resultCode.equals(3)) {
                        log.error("{}.{} : {}", (Object)customerStoreCode, (Object)storeCode, (Object)prismartResponse);
                        return prismartResponse;
                    }
                    if (resultCode.equals(1003)) {
                        log.error(storeCode + " server reject to receive batch data, reason: " + prismartResponse + " data: " + data);
                        return prismartResponse;
                    }
                    if (responseMap.get("message").toString().contains("Nonexistent store")) {
                        log.error("{} server reject to receive batch data, reason: {}", (Object)storeCode, (Object)prismartResponse);
                    } else {
                        log.error("{} server reject to receive batch data, reason: {}, data: {}", (Object)storeCode, (Object)prismartResponse, (Object)data);
                    }
                    return prismartResponse;
                }
                log.info("send batch data to " + storeCode + " server succeed, batchId=" + batchNo);
                return prismartResponse;
            }
            catch (Exception e) {
                log.error("response returned by " + storeCode + " server is exceptional: " + prismartResponse, (Throwable)e);
                return JSON.toJSONString(CustomerDataServiceImpl.fail(ShopWebApiResultCodeEnum.CDI_FAILED));
            }
        }
        if (task.getServerUrls().size() > 1) {
            ArrayList responseList = new ArrayList();
            for (CdiProperties.ServerUrl serverUrl : task.getServerUrls()) {
                Object url = serverUrl.getIntegrationUrl();
                LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
                response.put("url", url);
                url = (String)url + "/" + customerStoreCode + "/" + storeCode;
                String prismartResponse = "";
                String data = JSON.toJSONString(requestMap);
                try {
                    log.debug("customerCode : {}, storeCode : {}, data : {}", (Object)customerStoreCode, (Object)storeCode, (Object)data);
                    prismartResponse = this.prismartSender.sendPrismart((String)url, customerStoreCode, data);
                }
                catch (ConnectException ce) {
                    log.warn(String.format("send batch data to %s server failed due to cannot connect server.", storeCode), (Throwable)ce);
                }
                catch (Exception e) {
                    log.warn(String.format("send batch data to %s server failed.", storeCode), (Throwable)e);
                }
                response.put("result", prismartResponse);
                try {
                    JSONObject responseMap = JSONObject.parseObject(prismartResponse);
                    Integer resultCode = (Integer)responseMap.get("resultCode");
                    if (!resultCode.equals(1001) && !resultCode.equals(0)) {
                        if (resultCode.equals(3)) {
                            log.error("{}.{} : {}", (Object)customerStoreCode, (Object)storeCode, (Object)prismartResponse);
                        } else if (resultCode.equals(1003)) {
                            log.error(storeCode + " server reject to receive batch data, reason: " + prismartResponse + " data: " + data);
                        } else if (responseMap.get("message").toString().contains("Nonexistent store")) {
                            log.error(storeCode + " server reject to receive batch data, reason: " + prismartResponse);
                        } else {
                            log.error(storeCode + " server reject to receive batch data, reason: " + prismartResponse + " data: " + data);
                        }
                    } else {
                        log.info("send batch data to " + storeCode + " server succeed, batchId=" + batchNo);
                    }
                    response.put("result", responseMap);
                }
                catch (Exception e) {
                    log.error("response returned by " + storeCode + " server is exceptional: " + prismartResponse, (Throwable)e);
                    response.put("message", CustomerDataServiceImpl.fail(ShopWebApiResultCodeEnum.CDI_FAILED));
                }
                responseList.add(response);
            }
            return responseList;
        }
        return CustomerDataServiceImpl.fail(ShopWebApiResultCodeEnum.cdi_api_does_not_exist);
    }

    private List<Map<String, Object>> convertFieldsNames(List<Map<String, Object>> goodList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> src : goodList) {
            LinkedHashMap dst = new LinkedHashMap();
            this.initializeContext.getServerContext().getTaskServerFieldsNameMap().get("").forEach((key, value) -> dst.put(key, src.get(value)));
            list.add(dst);
        }
        return list;
    }

    public static ShopWebApiResponse fail(ShopWebApiResultCodeEnum resultCode, String format, Object ... args) {
        ShopWebApiResponse response = CustomerDataServiceImpl.fail(resultCode);
        response.setMessage(String.format(format, args));
        return response;
    }

    public static ShopWebApiResponse fail(ShopWebApiResultCodeEnum resultCode) {
        return new ShopWebApiResponse(resultCode);
    }

    public static ShopWebApiResponse success(ShopWebApiResultCodeEnum resultCode) {
        return new ShopWebApiResponse(resultCode);
    }

    public static ShopWebApiResponse success(ShopWebApiResultCodeEnum resultCode, String format, Object ... args) {
        ShopWebApiResponse response = CustomerDataServiceImpl.success(resultCode);
        response.setData(String.format(format, args));
        return response;
    }

    private void convertDateTime(List<Map<String, Object>> items) {
        long begin = System.currentTimeMillis();
        for (Map<String, Object> item : items) {
            for (Map.Entry<String, Object> entry : item.entrySet()) {
                if (entry.getValue() == null) continue;
                if (entry.getKey().contains("Date")) {
                    if (!entry.getValue().toString().contains("T")) continue;
                    try {
                        long convertDate = DateUtils.parseDate(entry.getValue().toString().trim(), "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS").getTime();
                        entry.setValue(convertDate);
                    }
                    catch (ParseException e) {
                        log.error("parse the date error, the data is : {}, {}", (Object)item, (Object)e.getMessage(), (Object)e);
                    }
                    continue;
                }
                if (entry.getKey().contains("Time")) {
                    if (!entry.getValue().toString().contains(":")) continue;
                    try {
                        long convertDate = DateUtils.parseDate("1970-01-01 " + entry.getValue().toString().trim(), "yyyy-MM-dd HH:mm:ss").getTime();
                        entry.setValue(convertDate);
                    }
                    catch (ParseException e) {
                        log.error("parse the time error, the data is : {}, {}", (Object)item, (Object)e.getMessage(), (Object)e);
                    }
                    continue;
                }
                try {
                    entry.setValue(String.valueOf(entry.getValue()));
                }
                catch (Exception e) {
                    log.error("parse other value error, the data is : {}, {}", (Object)item, (Object)e.getMessage(), (Object)e);
                }
            }
        }
        log.info("convert date and time coast {}ms time", (Object)(System.currentTimeMillis() - begin));
    }

    private List<Map<String, Object>> convertFieldsAndDateTime(List<Map<String, Object>> items, Map<String, CdiProperties.Field> mapping) {
        long begin = System.currentTimeMillis();
        ArrayList<Map<String, Object>> convertList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> item : items) {
            HashMap<String, Object> tmpMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : item.entrySet()) {
                if (entry.getValue() == null) continue;
                if (mapping.containsKey(entry.getKey())) {
                    if (mapping.get(entry.getKey()).getHanshow().contains("Date")) {
                        if (!entry.getValue().toString().contains("T")) continue;
                        try {
                            long convertDate = DateUtils.parseDate(entry.getValue().toString().trim(), "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS").getTime();
                            tmpMap.put(mapping.get(entry.getKey()).getHanshow(), convertDate);
                        }
                        catch (ParseException e) {
                            log.error("parse the date error, the data is : {}, {}", (Object)item, (Object)e.getMessage(), (Object)e);
                        }
                        continue;
                    }
                    if (mapping.get(entry.getKey()).getHanshow().contains("Time")) {
                        if (!entry.getValue().toString().contains(":")) continue;
                        try {
                            tmpMap.put(mapping.get(entry.getKey()).getHanshow(), DateUtils.parseDate("1970-01-01 " + entry.getValue().toString().trim(), "yyyy-MM-dd HH:mm:ss").getTime());
                        }
                        catch (ParseException e) {
                            log.error("parse the time error, the data is : {}, {}", (Object)item, (Object)e.getMessage(), (Object)e);
                        }
                        continue;
                    }
                    try {
                        tmpMap.put(mapping.get(entry.getKey()).getHanshow(), String.valueOf(entry.getValue()));
                    }
                    catch (Exception e) {
                        log.error("parse other value error, the data is : {}, {}", (Object)item, (Object)e.getMessage(), (Object)e);
                    }
                    continue;
                }
                if ((entry.getKey().contains("Date") || entry.getKey().contains("Time")) && CustomerDataServiceImpl.isNum(entry.getValue().toString())) {
                    tmpMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                tmpMap.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
            convertList.add(tmpMap);
        }
        log.info("convert date and time coast {}ms time", (Object)(System.currentTimeMillis() - begin));
        return convertList;
    }

    public static boolean isNum(String str) {
        return pattern.matcher(str).matches();
    }
}

