/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.service.impl;

import com.alibaba.fastjson.JSON;
import com.hanshow.intsmart.configuration.IntsmartProperties;
import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import com.hanshow.intsmart.exception.ApiException;
import com.hanshow.intsmart.service.PrismartAgentService;
import com.hanshow.intsmart.util.PrismartSender;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrismartAgentServiceImpl
implements PrismartAgentService {
    private static final Logger log = LogManager.getLogger(PrismartAgentServiceImpl.class);
    @Autowired
    IntsmartProperties intsmartProperties;
    @Autowired
    PrismartSender prismartSender;

    @Override
    public String forwarding(String requestAddress) {
        String url = this.intsmartProperties.getPrismartAgentUrl() + requestAddress.substring(requestAddress.indexOf("ogi/"));
        String prismartApiResponse = this.prismartSender.getPrismartApi(url);
        if ("".equals(prismartApiResponse)) {
            throw new ApiException(ShopWebApiResultCodeEnum.FAILED);
        }
        return prismartApiResponse;
    }

    @Override
    public String getApsStatus(String storeCode) {
        String store = this.intsmartProperties.getCustomerStoreCode() + "." + storeCode;
        String url = this.intsmartProperties.getPrismartAgentUrl() + "/ogi/stores/" + store + "/aps";
        log.info("url:" + url);
        log.info("store\uff1a" + store);
        String request = "";
        return request;
    }

    private String analyzeApStatusRes(PrismartApsPojo message) {
        Boolean apStatus = true;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (message.getData().size() != 0) {
            for (Map<String, Object> data : message.getData()) {
                if (!"offline".equals(data.get("status").toString())) continue;
                apStatus = false;
                break;
            }
        } else {
            apStatus = false;
        }
        map.put("sid", "");
        map.put("resultCode", message.getCode());
        map.put("message", message.getMsg());
        map.put("result", message.getMsg());
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("apStatus", apStatus);
        map.put("data", data);
        return JSON.toJSONString(map);
    }

    private static class PrismartApsPojo {
        private int code;
        private String msg;
        private List<Map<String, Object>> data;

        public int getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public List<Map<String, Object>> getData() {
            return this.data;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setData(List<Map<String, Object>> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrismartApsPojo)) {
                return false;
            }
            PrismartApsPojo other = (PrismartApsPojo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            List<Map<String, Object>> this$data = this.getData();
            List<Map<String, Object>> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PrismartApsPojo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            List<Map<String, Object>> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "PrismartAgentServiceImpl.PrismartApsPojo(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
        }
    }
}

