/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.service.impl;

import com.hanshow.cdi.common.GetStoreCodeTypeEnum;
import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.enums.FileTypeEnum;
import com.hanshow.intsmart.model.common.RegexDictionary;
import com.hanshow.intsmart.model.database.DynamicDataSource;
import com.hanshow.intsmart.service.ProcessFileService;
import com.hanshow.intsmart.util.PropertiesUtil;
import com.hanshow.intsmart.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Value;
import resolve.main.ResolveFile;

public class ProcessFileServiceImpl
implements ProcessFileService {
    private static final Logger log = LogManager.getLogger(ProcessFileServiceImpl.class);
    @Value(value="${filterChar:false}")
    private boolean filterChar;
    static SimpleDateFormat batchDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private final GenericCdiServerContext cdiServerContext;
    private final InitializeContext initializeContext;
    Map<String, String> fieldsMap = null;

    public ProcessFileServiceImpl(InitializeContext initializeContext) {
        this.cdiServerContext = initializeContext.getServerContext();
        this.initializeContext = initializeContext;
    }

    @Override
    public void formatFile(File file, String fileType, String storeCode, String taskName, GetStoreCodeTypeEnum getStoreType) {
        boolean flag = this.cdiServerContext.getTaskMap().get(taskName).getDatasource().getSkipFirstLine() != 0;
        String charset = this.initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFileCharset();
        String batchId = taskName + "-%s-%s-" + batchDateFormat.format(new Date());
        String fileNameUpper = file.getName().toUpperCase();
        FileTypeEnum fileTypeEnum = FileTypeEnum.fromType(fileType.toUpperCase());
        if (fileTypeEnum.matchesFileName(fileNameUpper)) {
            switch (fileTypeEnum) {
                case XLSX: 
                case XLS: {
                    log.info("Task {} starts to process file `{}` for store `{}` in XLS/XLSX file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                    this.processExcelFile(file, taskName, flag, batchId, storeCode, getStoreType);
                    log.info("Task {} finishes processing file `{}` for store `{}` in XLS/XLSX file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                    break;
                }
                case XML: {
                    log.info("Task {} starts to process file `{}` for store `{}` in XML file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                    this.processXmlFile(file, taskName, batchId, storeCode, getStoreType);
                    log.info("Task {} finishes processing file `{}` for store `{}` in XML file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                    break;
                }
                default: {
                    log.info("Task {} starts to process file `{}` for store `{}` in default txt file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                    this.processTxtFile(file, charset, taskName, flag, batchId, storeCode, this.cdiServerContext.getTaskMap().get(taskName).getDatasource().getCustomFileSplit(), getStoreType);
                    log.info("Task {} finishes processing file `{}` for store `{}` in default txt file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                    break;
                }
            }
        } else {
            switch (fileTypeEnum) {
                case FIXED: {
                    if (!(fileNameUpper.endsWith(FileTypeEnum.XLSX.getType()) || fileNameUpper.endsWith(FileTypeEnum.XLS.getType()) || fileNameUpper.endsWith(FileTypeEnum.XML.getType()))) {
                        log.info("Task {} starts to process file `{}` for store `{}` in FIXED LENGTH file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                        this.processFixedLengthFile(file, charset, this.initializeContext.getServerContext().getTaskMap().get(taskName).getFields(), this.initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFileColumnNum(), taskName, batchId, storeCode, getStoreType);
                        log.info("Task {} finishes processing file `{}` for store `{}` in FIXED LENGTH file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                        break;
                    }
                    log.warn("Task {} failed to execute: select file type {} cannot support input file type such as XML/XLS/XLSX", (Object)taskName, (Object)fileType);
                    break;
                }
                case TXT: 
                case CSV: {
                    if (!(fileNameUpper.endsWith(FileTypeEnum.XLSX.getType()) || fileNameUpper.endsWith(FileTypeEnum.XLS.getType()) || fileNameUpper.endsWith(FileTypeEnum.XML.getType()))) {
                        log.info("Task {} starts to process file `{}` for store `{}` in default txt file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                        this.processTxtFile(file, charset, taskName, flag, batchId, storeCode, this.cdiServerContext.getTaskMap().get(taskName).getDatasource().getCustomFileSplit(), getStoreType);
                        log.info("Task {} finishes processing file `{}` for store `{}` in default txt file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                        break;
                    }
                    log.warn("Task {} failed to execute: select file type {} cannot support input file type such as XML/XLS/XLSX", (Object)taskName, (Object)fileType);
                    break;
                }
                default: {
                    log.info("No matched selected file mode: task {} starts to process file `{}` for store `{}` in default txt file processing mode", (Object)taskName, (Object)file.getName(), (Object)storeCode);
                }
            }
        }
    }

    private int processLines(List<String[]> fileLines, String taskName, String fileName, int lineNum, String batchId, String storeCode, boolean end, Map<String, List<Map<String, Object>>> storeDataMap, GetStoreCodeTypeEnum storeType) {
        ArrayList<Map<String, Object>> totalList = new ArrayList<Map<String, Object>>();
        int errorNum = 0;
        if (fileLines == null) {
            log.error("Task {} the file : [ {} ] read error", (Object)taskName, (Object)fileName);
            return 0;
        }
        try {
            String[] elements = this.cdiServerContext.getTaskMap().get(taskName).getFieldMap().split(",");
            this.fieldsMap = PropertiesUtil.parseStringMap(elements);
        }
        catch (Exception e) {
            log.error("Task {} get configure file error\uff1a{}", (Object)taskName, (Object)(e.getMessage() + e));
        }
        for (String[] stringArray : fileLines) {
            if (stringArray.length != this.fieldsMap.size()) {
                log.warn("Task {} find an illegal line, the line number is : {}", (Object)taskName, (Object)lineNum);
                ++errorNum;
                ++lineNum;
                continue;
            }
            Map<String, Object> map2 = this.formatItem(stringArray, lineNum, storeCode, taskName, storeType);
            if (map2 != null) {
                if (storeType.equals((Object)GetStoreCodeTypeEnum.FromFile)) {
                    String hanshowStoreCode = map2.get("storeCode").toString();
                    if (!storeDataMap.containsKey(hanshowStoreCode)) {
                        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
                        listMap.add(map2);
                        storeDataMap.put(hanshowStoreCode, listMap);
                    } else {
                        storeDataMap.get(hanshowStoreCode).add(map2);
                    }
                } else {
                    totalList.add(map2);
                }
            } else {
                ++errorNum;
            }
            ++lineNum;
        }
        DynamicDataSource.setDataSource("defaultDataSource");
        if (GetStoreCodeTypeEnum.ToAllStores.equals((Object)storeType)) {
            for (Map.Entry entry : this.initializeContext.getServerContext().getTaskServerStoreCodeMap().get(taskName).entrySet()) {
                String currentStoreCode = StringUtils.isNotBlank(((CdiProperties.Store)entry.getValue()).getHanshowStoreCode()) ? ((CdiProperties.Store)entry.getValue()).getHanshowStoreCode() : ((CdiProperties.Store)entry.getValue()).getStoreCode();
                String customerStoreCode = ((CdiProperties.Store)entry.getValue()).getCustomerCode();
                totalList.forEach(map -> {
                    map.put("customerStoreCode", customerStoreCode);
                    map.put("storeCode", currentStoreCode);
                });
                log.info("Task {} storeCode {} write {} items to data file {}", (Object)taskName, (Object)currentStoreCode, (Object)totalList.size(), (Object)String.format(batchId, customerStoreCode, currentStoreCode));
                if (this.initializeContext.getIntegrationSync().booleanValue()) {
                    this.initializeContext.getIntegrateTask().integrateListSync(totalList, taskName, currentStoreCode, customerStoreCode, null, String.format(batchId, customerStoreCode, currentStoreCode), end);
                    continue;
                }
                this.initializeContext.getIntegrateTask().integrateMultiList(totalList, taskName, currentStoreCode, customerStoreCode, String.format(batchId, customerStoreCode, currentStoreCode), end);
            }
        } else if (GetStoreCodeTypeEnum.FromFile.equals((Object)storeType)) {
            if (!storeDataMap.isEmpty()) {
                for (Map.Entry entry : storeDataMap.entrySet()) {
                    String customerStoreCode = ((Map)((List)entry.getValue()).get(0)).get("customerStoreCode").toString();
                    log.info("Task {} storeCode {} write {} items to data file {}", (Object)taskName, entry.getKey(), (Object)((List)entry.getValue()).size(), (Object)String.format(batchId, customerStoreCode, entry.getKey()));
                    if (this.initializeContext.getIntegrationSync().booleanValue()) {
                        this.initializeContext.getIntegrateTask().integrateListSync((List)entry.getValue(), taskName, (String)entry.getKey(), customerStoreCode, null, String.format(batchId, customerStoreCode, entry.getKey()), end);
                        continue;
                    }
                    this.initializeContext.getIntegrateTask().integrateMultiList((List)entry.getValue(), taskName, (String)entry.getKey(), customerStoreCode, String.format(batchId, customerStoreCode, entry.getKey()), end);
                }
            }
        } else {
            String hanshowStoreCode = storeCode;
            if (this.cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).containsKey(storeCode) && StringUtils.isNotBlank(this.cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).get(storeCode))) {
                hanshowStoreCode = this.cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).get(storeCode);
            }
            String string = this.initializeContext.getServerContext().getTaskServerStoreCodeMap().get(taskName).get(hanshowStoreCode).getCustomerCode();
            log.info("Task {} storeCode {} write {} items to data file {}", (Object)taskName, (Object)storeCode, (Object)totalList.size(), (Object)String.format(batchId, string, hanshowStoreCode));
            if (this.initializeContext.getIntegrationSync().booleanValue()) {
                this.initializeContext.getIntegrateTask().integrateListSync(totalList, taskName, storeCode, string, null, String.format(batchId, string, hanshowStoreCode), end);
            } else {
                this.initializeContext.getIntegrateTask().integrateMultiList(totalList, taskName, storeCode, string, String.format(batchId, string, hanshowStoreCode), end);
            }
        }
        storeDataMap.forEach((k, v) -> v.clear());
        totalList.clear();
        return errorNum;
    }

    @Override
    public Map<String, Object> formatItem(String[] line, int lineNum, String storeCode, String taskName, GetStoreCodeTypeEnum storeType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String storeCodeField = "";
        String skuField = "";
        for (CdiProperties.Field field : this.cdiServerContext.getTaskServerFieldsNameMap().get(taskName).values()) {
            String customFieldName = field.getCustomer();
            if (this.fieldsMap.containsKey(customFieldName)) {
                int i = Integer.parseInt(this.fieldsMap.get(customFieldName)) - 1;
                String value = line[i] == null ? "" : line[i].trim();
                map.put(customFieldName, value);
                if (field.getHanshow().equals("storeCode")) {
                    storeCodeField = customFieldName;
                }
                if (field.getHanshow().equals("sku")) {
                    skuField = customFieldName;
                }
                if (field.getHanshow().matches(RegexDictionary.priceFieldsKey)) {
                    if (value.isEmpty() || value.matches(RegexDictionary.priceFieldsValue)) {
                        if (!value.isEmpty()) {
                            map.put(customFieldName, new BigDecimal(value));
                        } else {
                            map.put(customFieldName, value);
                        }
                    } else {
                        map.remove(customFieldName);
                        log.info("[Task {}] find an illegal {} field , the line number is {}", (Object)taskName, (Object)customFieldName, (Object)lineNum);
                    }
                }
                if (!this.initializeContext.getServerContext().getTaskFieldsDateFormat().get(taskName).containsKey(customFieldName)) continue;
                this.dateConvert(map, customFieldName, this.initializeContext.getServerContext().getTaskFieldsDateFormat().get(taskName).get(customFieldName));
                continue;
            }
            map.put(customFieldName, "");
        }
        if (map.get(skuField) == null) {
            log.warn("[Task {}] this data has no sku, the line number is {}", (Object)taskName, (Object)lineNum);
            return null;
        }
        if (storeCode == null && storeType.equals((Object)GetStoreCodeTypeEnum.FromFile)) {
            storeCode = map.get(storeCodeField).toString();
            if (!this.cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).containsKey(storeCode)) {
                log.warn("[Task {}] this storeCode of data is not configured, the line number is {}", (Object)taskName, (Object)lineNum);
                return null;
            }
        }
        if (!GetStoreCodeTypeEnum.ToAllStores.equals((Object)storeType)) {
            String customerStoreCode;
            String hanshowStoreCode = storeCode;
            if (this.cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).containsKey(storeCode) && StringUtils.isNotBlank(this.cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).get(storeCode))) {
                hanshowStoreCode = this.cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).get(storeCode);
            }
            if (StringUtils.isBlank(customerStoreCode = this.cdiServerContext.getTaskServerStoreCodeMap().get(taskName).get(hanshowStoreCode).getCustomerCode())) {
                log.info(String.format("[Task %s] this data has no storeCode, the line number is %s", taskName, lineNum));
                return null;
            }
            map.put("customerStoreCode", customerStoreCode);
            map.put("storeCode", hanshowStoreCode);
        }
        if (this.cdiServerContext.getTaskMap().get(taskName).getMvel() != null && !"".equals(this.cdiServerContext.getTaskMap().get(taskName).getMvel())) {
            PropertiesUtil.mvelProcess(this.cdiServerContext.getTaskMap().get(taskName).getMvel(), map);
        }
        if (this.cdiServerContext.getTaskMap().get(taskName).getConvert().isConvertSwitch()) {
            map.put(this.cdiServerContext.getTaskServerFieldsNameMap().get(taskName).get(this.cdiServerContext.getTaskMap().get(taskName).getConvert().getUnitField()).getCustomer(), "500g");
            for (String convertFieldName : this.cdiServerContext.getTaskMap().get(taskName).getConvert().getConvertFields()) {
                String convertFieldValue = map.get(this.cdiServerContext.getTaskServerFieldsNameMap().get(taskName).get(convertFieldName).getCustomer()).toString();
                try {
                    double value = Double.parseDouble(convertFieldValue) / 2.0;
                    map.put(this.cdiServerContext.getTaskServerFieldsNameMap().get(taskName).get(convertFieldName).getCustomer(), String.format("%.2f", value));
                }
                catch (Exception e) {
                    log.error("unit format error ,{} : {}, with message {}", (Object)convertFieldName, (Object)convertFieldValue, (Object)(e + e.getMessage()));
                }
            }
        }
        return map;
    }

    private void dateConvert(Map<String, Object> map, String key, SimpleDateFormat dateFormat) {
        try {
            if (StringUtils.isNotBlank((String)map.get(key))) {
                map.put(key, dateFormat.parse(map.get(key).toString()).getTime());
            } else {
                map.put(key, null);
            }
        }
        catch (Exception e) {
            map.put(key, null);
            log.error("dateFormat parse {} failed : {}", (Object)key, (Object)e);
        }
    }

    private void processFixedLengthFile(File file, String charset, List<CdiProperties.Field> fields, Integer length, String taskName, String batchId, String storeCode, GetStoreCodeTypeEnum storeType) {
        HashMap<String, List<Map<String, Object>>> storeDataMap = new HashMap<String, List<Map<String, Object>>>();
        int illegalCount = 0;
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        FileInputStream fileIs = null;
        BOMInputStream bomIs = null;
        try {
            fileIs = new FileInputStream(file);
            bomIs = new BOMInputStream(fileIs);
        }
        catch (FileNotFoundException e) {
            log.warn(String.format("can't find this file: %s", file.getAbsoluteFile()) + e);
        }
        String line = "";
        int lineNum = 1;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)bomIs, charset), 0x3200000);){
            while ((line = reader.readLine()) != null) {
                ArrayList<String> currentList = new ArrayList<String>();
                if (line.length() == length.intValue()) {
                    for (CdiProperties.Field field : fields) {
                        currentList.add(line.substring(field.getStartPosition() - 1, field.getEndPosition()));
                    }
                }
                resultList.add(currentList.toArray(new String[0]));
                if (resultList.size() == 100000) {
                    illegalCount += this.processLines(resultList, taskName, file.getName(), lineNum - resultList.size(), batchId, storeCode, false, storeDataMap, storeType);
                    resultList.clear();
                }
                ++lineNum;
            }
            illegalCount += this.processLines(resultList, taskName, file.getName(), lineNum - resultList.size(), batchId, storeCode, true, storeDataMap, storeType);
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncodingException" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error("IOException" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error("Exception" + e.getMessage(), (Throwable)e);
        }
        log.info("[Task {}] file {} process finished, total {} lines, {} illegal lines", (Object)taskName, (Object)file.getName(), (Object)lineNum, (Object)illegalCount);
    }

    private void processTxtFile(File file, String charset, String taskName, boolean flag, String batchId, String storeCode, String split, GetStoreCodeTypeEnum storeType) {
        HashMap<String, List<Map<String, Object>>> storeDataMap = new HashMap<String, List<Map<String, Object>>>();
        int lineNum = 0;
        int illegalCount = 0;
        ArrayList<String[]> fileLines = new ArrayList<String[]>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
            String line = null;
            if (flag) {
                bufferedReader.readLine();
                ++lineNum;
            }
            if (this.filterChar) {
                while ((line = bufferedReader.readLine()) != null) {
                    line = StringUtil.filter(line);
                    fileLines.add(line.split(Pattern.quote(split), -1));
                    if (fileLines.size() == 100000) {
                        illegalCount += this.processLines(fileLines, taskName, file.getName(), lineNum - fileLines.size(), batchId, storeCode, false, storeDataMap, storeType);
                        fileLines.clear();
                    }
                    ++lineNum;
                }
            } else {
                while ((line = bufferedReader.readLine()) != null) {
                    fileLines.add(line.split(Pattern.quote(split), -1));
                    if (fileLines.size() == 100000) {
                        illegalCount += this.processLines(fileLines, taskName, file.getName(), lineNum - fileLines.size(), batchId, storeCode, false, storeDataMap, storeType);
                        fileLines.clear();
                    }
                    ++lineNum;
                }
            }
            illegalCount += this.processLines(fileLines, taskName, file.getName(), lineNum - fileLines.size(), batchId, storeCode, true, storeDataMap, storeType);
        }
        catch (Exception e) {
            log.error("Task {} read file {} error, with message {}", (Object)taskName, (Object)file.getName(), (Object)(e + e.getMessage()));
        }
        log.info("Task {} process file {} finished, total {} lines, {} illegal lines", (Object)taskName, (Object)file.getName(), (Object)lineNum, (Object)illegalCount);
    }

    private void processExcelFile(File file, String taskName, boolean skip, String batchId, String storeCode, GetStoreCodeTypeEnum storeType) {
        int lineNum;
        HashMap<String, List<Map<String, Object>>> storeDataMap = new HashMap<String, List<Map<String, Object>>>();
        int illegalCount = 0;
        ArrayList resultList = new ArrayList();
        boolean flag = true;
        int n = lineNum = skip ? 1 : 0;
        while (flag) {
            try {
                List<String[]> fileLines = ResolveFile.ReadExcel(file.getPath(), 0, lineNum, 100000);
                if (fileLines.size() < 100000) {
                    flag = false;
                }
                illegalCount += this.processLines(fileLines, taskName, file.getName(), lineNum, batchId, storeCode, !flag, storeDataMap, storeType);
                lineNum += fileLines.size();
            }
            catch (IOException e) {
                log.error("read Excel [{}] failed, error msg : {}", (Object)file.getName(), (Object)e.getMessage(), (Object)e);
                flag = false;
            }
        }
        log.info("[Task {}] file {} process finished, total {} lines, {} illegal lines", (Object)taskName, (Object)file.getName(), (Object)lineNum, (Object)illegalCount);
    }

    private void processXmlFile(File file, String taskName, String batchId, String storeCode, GetStoreCodeTypeEnum storeType) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        this.processAndUploadXmlFile(items, file, this.cdiServerContext.getTaskMap().get(taskName).getItemLevel(), taskName, storeCode, batchId, storeType, this.cdiServerContext);
    }

    public void processAndUploadXmlFile(final List<Map<String, Object>> items, File file, String elementPath, final String taskName, final String storeCode, final String batchId, final GetStoreCodeTypeEnum storeType, final GenericCdiServerContext cdiServerContext) {
        log.info("[Task {}] storeCode {} file {} process initiates", (Object)taskName, (Object)storeCode, (Object)file.getName());
        long start = System.currentTimeMillis();
        SAXReader reader = new SAXReader();
        final AtomicInteger currentCount = new AtomicInteger(0);
        final HashMap<String, List<Map<String, Object>>> storeDataMap = new HashMap<String, List<Map<String, Object>>>();
        reader.addHandler(elementPath, new ElementHandler(){

            @Override
            public void onStart(ElementPath path) {
            }

            @Override
            public void onEnd(ElementPath path) {
                Element martElement = path.getCurrent();
                Map<String, Object> martMap = ProcessFileServiceImpl.this.processElement(martElement);
                Map<String, Object> item = ProcessFileServiceImpl.this.createItemFromElement(martMap, taskName, storeCode, storeType, cdiServerContext, currentCount);
                if (item != null) {
                    if (storeType.equals((Object)GetStoreCodeTypeEnum.FromFile)) {
                        String hanshowStoreCode = item.get("storeCode").toString();
                        if (!storeDataMap.containsKey(hanshowStoreCode)) {
                            ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
                            listMap.add(item);
                            storeDataMap.put(hanshowStoreCode, listMap);
                        } else {
                            ((List)storeDataMap.get(hanshowStoreCode)).add(item);
                        }
                    } else {
                        items.add(item);
                    }
                }
                martElement.detach();
                currentCount.getAndIncrement();
                if (currentCount.get() % 100000 == 0) {
                    ProcessFileServiceImpl.this.flushItemsIfNeeded(items, taskName, storeCode, batchId, false, storeType, storeDataMap, cdiServerContext);
                }
            }
        });
        try {
            reader.read(file.getAbsolutePath());
        }
        catch (DocumentException e) {
            log.error("Error processing XML file. Task Name: {}, Store Code: {}, Batch ID: {}, File Name: {}, Error Details: {}", (Object)taskName, (Object)storeCode, (Object)batchId, (Object)file.getName(), (Object)e.getMessage(), (Object)e);
        }
        if (currentCount.get() % 100000 != 0) {
            this.flushItemsIfNeeded(items, taskName, storeCode, batchId, true, storeType, storeDataMap, cdiServerContext);
        }
        long end = System.currentTimeMillis();
        log.info("Task {} storeCode {} processed {} items to data file {} in {} ms", (Object)taskName, (Object)storeCode, (Object)currentCount, (Object)file.getName(), (Object)(end - start));
    }

    public Map<String, Object> processElement(Element element) {
        String textContent;
        LinkedHashMap<String, Object> elementMap = new LinkedHashMap<String, Object>();
        for (Attribute attribute : element.attributes()) {
            elementMap.put(attribute.getName(), attribute.getValue());
        }
        if (!element.elements().isEmpty()) {
            Iterator<Element> it = element.elementIterator();
            while (it.hasNext()) {
                Element childElement = it.next();
                Map<String, Object> childElementMap = this.processElement(childElement);
                if (elementMap.containsKey(childElement.getName())) {
                    Object existingEntry = elementMap.get(childElement.getName());
                    if (existingEntry instanceof List) {
                        ((List)existingEntry).add(childElementMap);
                        continue;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(existingEntry);
                    list.add(childElementMap);
                    elementMap.put(childElement.getName(), list);
                    continue;
                }
                elementMap.put(childElement.getName(), childElementMap);
            }
        } else if (!element.getTextTrim().isEmpty() && !(textContent = element.getTextTrim()).isEmpty()) {
            elementMap.put(element.getName(), textContent);
        }
        return elementMap;
    }

    public Object getValueFromPath(Map<String, Object> elementMap, String elementPath) {
        String[] parts = elementPath.split("/");
        Object currentValue = elementMap;
        for (String part : parts) {
            if (part.startsWith("@")) {
                String attributeName = part.substring(1);
                if (currentValue.containsKey(attributeName)) {
                    currentValue = currentValue.get(attributeName);
                    break;
                }
                currentValue = null;
                break;
            }
            if (!(currentValue instanceof Map)) break;
            if (!currentValue.containsKey(part)) {
                currentValue = null;
                break;
            }
            currentValue = currentValue.get(part);
        }
        return currentValue;
    }

    private Map<String, Object> createItemFromElement(Map<String, Object> martMap, String taskName, String storeCode, GetStoreCodeTypeEnum storeType, GenericCdiServerContext cdiServerContext, AtomicInteger currentCount) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        String storeCodeField = "";
        String skuField = "";
        for (CdiProperties.Field field : cdiServerContext.getTaskServerFieldsNameMap().get(taskName).values()) {
            String customFieldName = field.getCustomer();
            Object valueFromPath = this.getValueFromPath(martMap, customFieldName);
            String value = "";
            if (valueFromPath != null) {
                if (customFieldName.contains("/")) {
                    String afterSlash = customFieldName.substring(customFieldName.lastIndexOf("/") + 1);
                    if (afterSlash.startsWith("@")) {
                        value = valueFromPath.toString();
                    } else {
                        Map chaMap = (Map)valueFromPath;
                        if (chaMap.get(customFieldName) != null && !((String)chaMap.get(customFieldName)).isEmpty()) {
                            value = (String)chaMap.get(customFieldName);
                        }
                    }
                } else if (customFieldName.startsWith("@")) {
                    value = valueFromPath.toString();
                } else {
                    Map chaMap = (Map)valueFromPath;
                    if (chaMap.get(customFieldName) != null && !((String)chaMap.get(customFieldName)).isEmpty()) {
                        value = (String)chaMap.get(customFieldName);
                    }
                }
            }
            item.put(customFieldName, value);
            if (field.getHanshow().equals("storeCode")) {
                storeCodeField = customFieldName;
            }
            if (field.getHanshow().equals("sku")) {
                skuField = customFieldName;
            }
            if (field.getHanshow().matches(RegexDictionary.priceFieldsKey)) {
                if (value.isEmpty() || value.matches(RegexDictionary.priceFieldsValue)) {
                    if (!value.isEmpty()) {
                        item.put(customFieldName, new BigDecimal(value));
                    } else {
                        item.put(customFieldName, value);
                    }
                } else {
                    item.put(customFieldName, null);
                    log.info("[Task {}] find an illegal {} field , the item number is {}", (Object)taskName, (Object)customFieldName, (Object)currentCount);
                }
            }
            if (!this.initializeContext.getServerContext().getTaskFieldsDateFormat().get(taskName).containsKey(customFieldName)) continue;
            this.dateConvert(item, customFieldName, this.initializeContext.getServerContext().getTaskFieldsDateFormat().get(taskName).get(customFieldName));
        }
        if (item.get(skuField) == null) {
            log.warn("[Task {}] this data has no sku, the item number is {}", (Object)taskName, (Object)currentCount);
            return null;
        }
        if (storeCode == null && storeType.equals((Object)GetStoreCodeTypeEnum.FromFile)) {
            storeCode = item.get(storeCodeField).toString();
            if (!cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).containsKey(storeCode)) {
                log.warn("[Task {}] this storeCode of data is not configured, the item number is {}", (Object)taskName, (Object)currentCount);
                return null;
            }
        }
        if (!GetStoreCodeTypeEnum.ToAllStores.equals((Object)storeType)) {
            String customerStoreCode;
            String hanshowStoreCode = storeCode;
            if (cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).containsKey(storeCode) && StringUtils.isNotBlank(cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).get(storeCode))) {
                hanshowStoreCode = cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).get(storeCode);
            }
            if (StringUtils.isBlank(customerStoreCode = cdiServerContext.getTaskServerStoreCodeMap().get(taskName).get(hanshowStoreCode).getCustomerCode())) {
                log.info(String.format("[Task %s] this data has no storeCode, the item number is %s", taskName, currentCount));
                return null;
            }
            item.put("customerStoreCode", customerStoreCode);
            item.put("storeCode", hanshowStoreCode);
        }
        if (cdiServerContext.getTaskMap().get(taskName).getMvel() != null && !"".equals(cdiServerContext.getTaskMap().get(taskName).getMvel())) {
            PropertiesUtil.mvelProcess(cdiServerContext.getTaskMap().get(taskName).getMvel(), item);
        }
        if (cdiServerContext.getTaskMap().get(taskName).getConvert().isConvertSwitch()) {
            item.put(cdiServerContext.getTaskServerFieldsNameMap().get(taskName).get(cdiServerContext.getTaskMap().get(taskName).getConvert().getUnitField()).getCustomer(), "500g");
            for (String convertFieldName : cdiServerContext.getTaskMap().get(taskName).getConvert().getConvertFields()) {
                String convertFieldValue = item.get(cdiServerContext.getTaskServerFieldsNameMap().get(taskName).get(convertFieldName).getCustomer()).toString();
                try {
                    item.put(cdiServerContext.getTaskServerFieldsNameMap().get(taskName).get(convertFieldName).getCustomer(), String.format("%.2f", Double.parseDouble(convertFieldValue) / 2.0));
                }
                catch (Exception e) {
                    log.error("unit format error ,{} : {}, with message {}", (Object)convertFieldName, (Object)convertFieldValue, (Object)(e + e.getMessage()));
                }
            }
        }
        return item;
    }

    private void flushItemsIfNeeded(List<Map<String, Object>> items, String taskName, String storeCode, String batchId, boolean shouldFlush, GetStoreCodeTypeEnum storeType, Map<String, List<Map<String, Object>>> storeDataMap, GenericCdiServerContext cdiServerContext) {
        if (GetStoreCodeTypeEnum.ToAllStores.equals((Object)storeType)) {
            for (Map.Entry<String, CdiProperties.Store> entry : this.initializeContext.getServerContext().getTaskServerStoreCodeMap().get(taskName).entrySet()) {
                String customerStoreCode;
                String currentStoreCode = StringUtils.isNotBlank(entry.getValue().getHanshowStoreCode()) ? entry.getValue().getHanshowStoreCode() : entry.getValue().getStoreCode();
                String finalCustomerStoreCode = customerStoreCode = entry.getValue().getCustomerCode();
                items.forEach(map -> {
                    map.put("customerStoreCode", finalCustomerStoreCode);
                    map.put("storeCode", currentStoreCode);
                });
                String formattedBatchId = String.format(batchId, customerStoreCode, currentStoreCode);
                if (this.initializeContext.getIntegrationSync().booleanValue()) {
                    this.initializeContext.getIntegrateTask().integrateListSync(items, taskName, currentStoreCode, customerStoreCode, null, formattedBatchId, shouldFlush);
                } else {
                    this.initializeContext.getIntegrateTask().integrateMultiList(items, taskName, currentStoreCode, customerStoreCode, formattedBatchId, shouldFlush);
                }
                log.info("Task {} storeCode {} write {} items to data file {}", (Object)taskName, (Object)currentStoreCode, (Object)items.size(), (Object)formattedBatchId);
            }
        } else if (GetStoreCodeTypeEnum.FromFile.equals((Object)storeType)) {
            if (!storeDataMap.isEmpty()) {
                for (Map.Entry<String, List<Map<String, Object>>> entry : storeDataMap.entrySet()) {
                    String customerStoreCode = entry.getValue().get(0).get("customerStoreCode").toString();
                    String formattedBatchId = String.format(batchId, customerStoreCode, entry.getKey());
                    if (this.initializeContext.getIntegrationSync().booleanValue()) {
                        this.initializeContext.getIntegrateTask().integrateListSync(entry.getValue(), taskName, entry.getKey(), customerStoreCode, null, formattedBatchId, shouldFlush);
                    } else {
                        this.initializeContext.getIntegrateTask().integrateMultiList(entry.getValue(), taskName, entry.getKey(), customerStoreCode, formattedBatchId, shouldFlush);
                    }
                    log.info("Task {} storeCode {} write {} items to data file {}", (Object)taskName, (Object)storeCode, (Object)items.size(), (Object)formattedBatchId);
                }
            }
        } else {
            String hanshowStoreCode = storeCode;
            if (cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).containsKey(storeCode) && StringUtils.isNotBlank(cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).get(storeCode))) {
                hanshowStoreCode = cdiServerContext.getTaskServerTransformStoreCodeMap().get(taskName).get(storeCode);
            }
            String customerStoreCode = this.initializeContext.getServerContext().getTaskServerStoreCodeMap().get(taskName).get(hanshowStoreCode).getCustomerCode();
            String formattedBatchId = String.format(batchId, customerStoreCode, hanshowStoreCode);
            if (this.initializeContext.getIntegrationSync().booleanValue()) {
                this.initializeContext.getIntegrateTask().integrateListSync(items, taskName, storeCode, customerStoreCode, null, formattedBatchId, shouldFlush);
            } else {
                this.initializeContext.getIntegrateTask().integrateMultiList(items, taskName, storeCode, customerStoreCode, formattedBatchId, shouldFlush);
            }
            log.info("Task {} storeCode {} write {} items to data file {}", (Object)taskName, (Object)storeCode, (Object)items.size(), (Object)formattedBatchId);
        }
        storeDataMap.forEach((k, v) -> v.clear());
        items.clear();
    }
}

