/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.tray;

import com.hanshow.intsmart.util.Version;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import javax.swing.JFrame;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegrationFrame
extends JFrame {
    private static final Logger log = LogManager.getLogger(IntegrationFrame.class);

    public IntegrationFrame() {
        this.init();
    }

    private void init() {
        this.setSize(300, 200);
        this.setLocationRelativeTo(null);
        this.setTray();
        this.setVisible(false);
    }

    public void setTray() {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows") && SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            Image image = Toolkit.getDefaultToolkit().getImage(IntegrationFrame.class.getResource("/tray/hanshow-logo.gif"));
            String text = new Version().getVersionByCore();
            TrayIcon trayIcon = new TrayIcon(image, text);
            trayIcon.setImageAutoSize(true);
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e1) {
                log.error(e1.getMessage(), (Throwable)e1);
            }
        } else {
            log.warn("the system tray isn't supported on the current platform.");
        }
    }
}

