/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import com.hanshow.cdi.properties.CdiProperties;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CleanUtil {
    private static final Logger log = LogManager.getLogger(CleanUtil.class);

    public static void cleanDir(String taskName, List<CdiProperties.Store> storeList, String rootDir) {
        String localHistoryDir = rootDir + File.separator + "history" + File.separator + "default";
        String localFtpDir = rootDir + File.separator + "ftp" + File.separator + "default";
        for (CdiProperties.Store store : storeList) {
            String storeCode;
            String customerStoreCode = store.getCustomerCode();
            String childrenDir = taskName + File.separator + customerStoreCode + File.separator + (storeCode = store.getHanshowStoreCode());
            File cleanHistoryDir = new File(localHistoryDir, childrenDir);
            if (cleanHistoryDir.exists() && cleanHistoryDir.isDirectory()) {
                File[] files;
                for (File f : files = cleanHistoryDir.listFiles()) {
                    if (f.isDirectory() || f.getName().indexOf(".") != -1) continue;
                    if (!f.delete()) {
                        log.error("Clear history file failed: " + f.getAbsolutePath());
                        continue;
                    }
                    log.info("Clear history file: " + f.getAbsolutePath());
                }
            } else {
                log.info("{} not exists", (Object)cleanHistoryDir.getAbsolutePath());
            }
            File cleanFtpDir = new File(localFtpDir, childrenDir);
            if (cleanFtpDir.exists() && cleanFtpDir.isDirectory()) {
                File[] files;
                for (File f : files = cleanFtpDir.listFiles()) {
                    if (f.isDirectory() || f.getName().indexOf(".") != -1) continue;
                    if (!f.delete()) {
                        log.error("Clear ftp file failed: " + f.getAbsolutePath());
                        continue;
                    }
                    log.info("Clear ftp file: " + f.getAbsolutePath());
                }
                continue;
            }
            log.info("{} not exists", (Object)cleanFtpDir.getAbsolutePath());
        }
    }

    public static void main(String[] args) {
    }
}

