/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import com.hanshow.intsmart.model.common.RegexDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CronUtil {
    private static final Logger log = LogManager.getLogger(CronUtil.class);
    private static final String CRON = "%s %s %s * * ?";
    private static final int HOUR = 60;

    public static void main(String[] args) {
        System.out.println(CronUtil.getCron("30", "23:00", "1:00"));
    }

    public static String getCron(String time, String startHour, String endHour) {
        String newTime = time.trim();
        if (newTime.matches(RegexDictionary.hoursAndMinute)) {
            String[] hm = newTime.split(":");
            return String.format(CRON, "0", hm[1], hm[0]);
        }
        if (newTime.matches(RegexDictionary.hoursAndMinuteAndSecond)) {
            String[] hm = newTime.split(":");
            return String.format(CRON, hm[2], hm[1], hm[0]);
        }
        if (newTime.matches(RegexDictionary.number)) {
            int temp = Integer.parseInt(newTime);
            if (temp >= 60) {
                if (StringUtils.isBlank(startHour) || StringUtils.isBlank(endHour)) {
                    return String.format(CRON, "0", "0", String.format("*/%s", temp / 60));
                }
                int start = Integer.parseInt(startHour.split(":")[0]);
                int end = Integer.parseInt(endHour.split(":")[0]) == 0 ? 23 : Integer.parseInt(endHour.split(":")[0]) - 1;
                return String.format(CRON, "0", "0", String.format("%s-%s/%s", start, end, temp / 60));
            }
            if (StringUtils.isBlank(startHour) || StringUtils.isBlank(endHour)) {
                return String.format(CRON, "0", String.format("*/%s", temp), "*");
            }
            int start = Integer.parseInt(startHour.split(":")[0]);
            int end = Integer.parseInt(endHour.split(":")[0]) == 0 ? 23 : Integer.parseInt(endHour.split(":")[0]) - 1;
            return String.format(CRON, "0", String.format("*/%s", temp), String.format("%s-%s", start, end));
        }
        log.warn("the time is illegal, the time is : {}", (Object)time);
        return "";
    }
}

