/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.apache.tomcat.util.http.fileupload.util.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static Map<String, String> upload(List<MultipartFile> files, String filePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (files != null) {
                DiskFileItemFactory factory = new DiskFileItemFactory();
                factory.setSizeThreshold(1024000);
                ServletFileUpload sfu = new ServletFileUpload(factory);
                sfu.setHeaderEncoding("utf-8");
                sfu.setFileSizeMax(102400000L);
                sfu.setSizeMax(204800000L);
                for (MultipartFile file : files) {
                    String originFileName = file.getOriginalFilename();
                    String fileName = URLDecoder.decode(originFileName = originFileName.substring(originFileName.lastIndexOf(92) + 1), "utf-8");
                    if (fileName.contains("/")) {
                        fileName = file.getName().substring(originFileName.lastIndexOf("/") + 1);
                    }
                    BufferedInputStream in = new BufferedInputStream(file.getInputStream());
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(filePath, fileName)));
                    Streams.copy(in, out, true);
                    map.put(fileName, "SUCCESS");
                }
            }
            return map;
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            return map;
        }
    }

    public static List<File> listFiles(File f) {
        File[] files = f.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                FileUtil.listFiles(file);
            }
        }
        return files != null ? Arrays.asList(files) : null;
    }

    public static void copyFile(String path, String newPath) {
        File file = new File(newPath);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileInputStream fis = new FileInputStream(path);
            FileOutputStream fos = new FileOutputStream(newPath);
            int len = 0;
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile(InputStream inputStream, String encode) {
        if (encode == null) {
            encode = "UTF-8";
        }
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                result.add(tempString);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    log.error(e1.getMessage(), e1);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile(String fileName, String encode) {
        if (encode == null) {
            encode = "UTF-8";
        }
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                result.add(tempString);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    log.error(e1.getMessage(), e1);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String fileName, int line, String encode) {
        if (line < 1) {
            return null;
        }
        if (encode == null) {
            encode = "UTF-8";
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            String tempString = null;
            int i = 1;
            while ((tempString = reader.readLine()) != null) {
                if (i == line) {
                    String string = tempString;
                    return string;
                }
                ++i;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    log.error(e1.getMessage(), e1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overWriteFile(String content, String path) {
        File file = new File(path);
        FileWriter fw = null;
        BufferedWriter writer = null;
        try {
            fw = new FileWriter(file);
            writer = new BufferedWriter(fw);
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        finally {
            try {
                writer.close();
                fw.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public static void writeFileReplace(String content, String path, int line) {
        if (line < 0) {
            return;
        }
        List<String> list = FileUtil.readFile(path, null);
        if (line == 0) {
            list.add(0, content);
        } else if (line <= list.size()) {
            list.remove(line - 1);
            list.add(line - 1, content);
        } else {
            list.add(content);
        }
        FileUtil.overWriteFile(list, path);
    }

    public static void writeFileReplace(String content, String path, int line, String encode) {
        if (line < 0) {
            return;
        }
        List<String> list = FileUtil.readFile(path, encode);
        if (line == 0) {
            list.add(0, content);
        } else if (line <= list.size()) {
            list.remove(line - 1);
            list.add(line - 1, content);
        } else {
            list.add(content);
        }
        FileUtil.overWriteFile(list, path);
    }

    public static void writeFileInsert(String content, String path, int line) {
        if (line < 0) {
            return;
        }
        List<String> list = FileUtil.readFile(path, null);
        if (line == 0) {
            list.add(0, content);
        } else if (line < list.size()) {
            list.add(line - 1, content);
        } else {
            list.add(content);
        }
        FileUtil.overWriteFile(list, path);
    }

    public static void writeFileInsert(String content, String path, int line, String encode) {
        if (line < 0) {
            return;
        }
        List<String> list = FileUtil.readFile(path, encode);
        if (line == 0) {
            list.add(0, content);
        } else if (line < list.size()) {
            list.add(line - 1, content);
        } else {
            list.add(content);
        }
        FileUtil.overWriteFile(list, path);
    }

    public static void writeFileDelete(String path, int line) {
        if (line <= 0) {
            return;
        }
        List<String> list = FileUtil.readFile(path, null);
        if (line <= list.size()) {
            list.remove(line - 1);
        }
        FileUtil.overWriteFile(list, path);
    }

    public static void writeFileDelete(String path, int line, String encode) {
        if (line <= 0) {
            return;
        }
        List<String> list = FileUtil.readFile(path, encode);
        if (line <= list.size()) {
            list.remove(line - 1);
        }
        FileUtil.overWriteFile(list, path);
    }

    public static int writeFileAppend(String content, String path) {
        List<String> list = FileUtil.readFile(path, null);
        list.add(content);
        FileUtil.overWriteFile(list, path);
        return list.size();
    }

    public static int writeFileAppend(String content, String path, String encode) {
        List<String> list = FileUtil.readFile(path, encode);
        list.add(content);
        FileUtil.overWriteFile(list, path);
        return list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overWriteFile(List<String> content, String path) {
        File file = new File(path);
        FileWriter fw = null;
        BufferedWriter writer = null;
        try {
            fw = new FileWriter(file);
            writer = new BufferedWriter(fw);
            Iterator<String> it = content.iterator();
            while (it.hasNext()) {
                writer.write(it.next());
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        finally {
            try {
                writer.close();
                fw.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public static void overWriteFile(String content, String path, String encode) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(file, false);
            StringBuffer sb = new StringBuffer();
            sb.append(content);
            out.write(sb.toString().getBytes(encode));
            out.close();
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean backupFile(File f1, File f2) {
        boolean flag = false;
        FileInputStream fi = null;
        FileOutputStream fo = null;
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            fi = new FileInputStream(f1);
            fo = new FileOutputStream(f2);
            in = fi.getChannel();
            out = fo.getChannel();
            if (((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out)) >= 0L) {
                flag = true;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
                if (in != null) {
                    in.close();
                }
                if (fo != null) {
                    fo.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
        return flag;
    }

    public static void saveFile(String uploadDir, String fileName, MultipartFile multipartFile) throws IOException {
        File directory = new File(uploadDir);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Cannot Create Directory\uff1a" + uploadDir);
        }
        File file = new File(directory, fileName);
        Files.copy(multipartFile.getInputStream(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

