/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class HttpsClientWrap {
    private static final Logger log = LogManager.getLogger(HttpsClientWrap.class);
    private static volatile OkHttpClient httpsClient = null;
    private static final String JSON_MEDIA_TYPE_PATTERN = "application/json; charset=%s";
    private static SSLSocketFactory sslSocketFactory;
    private static String CERTIFICATE_NAME;
    private static String KEYPASS;
    private static String STOREPASS;

    public static void setCertificateName(String certificateName) {
        CERTIFICATE_NAME = certificateName;
    }

    public static void setKEYPASS(String KEYPASS) {
        HttpsClientWrap.KEYPASS = KEYPASS;
    }

    public static void setSTOREPASS(String STOREPASS) {
        HttpsClientWrap.STOREPASS = STOREPASS;
    }

    public static OkHttpClient getInstance() {
        return HttpsClientWrap.getInstance(0);
    }

    public static boolean getStatus() {
        return httpsClient == null;
    }

    public static void destroy() {
        httpsClient = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getInstance(int timeout) {
        if (httpsClient != null) return httpsClient;
        Class<HttpsClientWrap> clazz = HttpsClientWrap.class;
        synchronized (HttpsClientWrap.class) {
            if (httpsClient != null) return httpsClient;
            try {
                HttpsClientWrap.initSSL();
                httpsClient = timeout == 0 ? HttpsClientWrap.setSSL(61) : HttpsClientWrap.setSSL(timeout);
            }
            catch (Exception e) {
                log.error("Create https sender error ", (Throwable)e);
            }
            return httpsClient;
        }
    }

    private static void initSSL() {
        try {
            sslSocketFactory = SSLUtils.createSSLSocketFactory(KEYPASS, STOREPASS);
        }
        catch (Exception e) {
            log.error("initSSL error", (Throwable)e);
        }
    }

    private static OkHttpClient setSSL(int timeout) {
        return new OkHttpClient().newBuilder().sslSocketFactory(sslSocketFactory, new HttpsTrustManager()).hostnameVerifier(new HttpsTrustManager.TrustAllHostnameVerifier()).connectTimeout(timeout, TimeUnit.SECONDS).readTimeout(timeout, TimeUnit.SECONDS).writeTimeout(timeout, TimeUnit.SECONDS).build();
    }

    public static String postJsonToURL(String url, String string, String charset) throws IOException {
        return HttpsClientWrap.postJsonToURL(url, string, charset, false);
    }

    public static String postJsonToURL(String url, String string, String charset, boolean gzip) throws IOException {
        byte[] bytes;
        if (gzip) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(baos);
            ((OutputStream)zipper).write(string.getBytes(charset));
            ((OutputStream)zipper).close();
            bytes = baos.toByteArray();
        } else {
            bytes = string.getBytes(charset);
        }
        MediaType JSON2 = MediaType.parse(String.format(JSON_MEDIA_TYPE_PATTERN, charset));
        RequestBody body = RequestBody.create(JSON2, bytes);
        Request request = gzip ? new Request.Builder().url(url).post(body).header("Content-Encoding", "gzip").build() : new Request.Builder().url(url).post(body).build();
        Response response = httpsClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        log.warn("Post JSON to url [{}] got unexpected code [{}] message [{}] DATA [{}]", (Object)url, (Object)response.code(), (Object)response.message(), (Object)string);
        response.close();
        throw new IOException("Post JSON to url got unexpected");
    }

    public static String getURL(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = httpsClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        response.close();
        throw new IOException(String.format("get to url %s got unexpected code %d message %s", url, response.code(), response.message()));
    }

    static {
        CERTIFICATE_NAME = null;
        KEYPASS = null;
        STOREPASS = null;
    }

    static class SSLUtils {
        SSLUtils() {
        }

        public static KeyStore loadKeyStore(String type, String password) throws Exception {
            try (FileInputStream input = new FileInputStream(new ClassPathResource(CERTIFICATE_NAME).getFile());){
                if (input == null) {
                    throw new FileNotFoundException("cannot find KeyStore file " + CERTIFICATE_NAME);
                }
                KeyStore ks = KeyStore.getInstance(type);
                ks.load(input, password.toCharArray());
                KeyStore keyStore = ks;
                return keyStore;
            }
        }

        public static SSLSocketFactory createSSLSocketFactory(String protocol, String algorithm, String provider, String keyPassword, String keyStoreType, String storePassword) throws Exception {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm, provider);
            KeyStore keyStore = SSLUtils.loadKeyStore(keyStoreType, storePassword);
            keyManagerFactory.init(keyStore, keyPassword.toCharArray());
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagers, new SecureRandom());
            return sslContext.getSocketFactory();
        }

        public static SSLSocketFactory createSSLSocketFactory(String keyPassword, String storePassword) throws Exception {
            return SSLUtils.createSSLSocketFactory("TLS", "SunX509", "SunJSSE", keyPassword, "JKS", storePassword);
        }

        public static HostnameVerifier createHostnameVerifier() {
            return (hostname, session) -> true;
        }
    }

    static class HttpsTrustManager
    implements X509TrustManager {
        HttpsTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public static SSLSocketFactory createSSLSocketFactory() {
            SSLSocketFactory sSLSocketFactory = null;
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, new TrustManager[]{new HttpsTrustManager()}, new SecureRandom());
                sSLSocketFactory = sc.getSocketFactory();
            }
            catch (Exception e) {
                log.error("createSSLSocketFactory error", (Throwable)e);
            }
            return sSLSocketFactory;
        }

        public static class TrustAllHostnameVerifier
        implements HostnameVerifier {
            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        }
    }
}

