/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonUtils {
    private static final Logger log = LogManager.getLogger(JsonUtils.class);
    public static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static ObjectMapper MAPPER = null;
    public static ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true).configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);

    public static <T> T readJson(String args, Class<T> clazz) throws IOException {
        return objectMapper.readValue(args, clazz);
    }

    public static String toJsonString(Object object) throws JsonProcessingException {
        return objectMapper.writeValueAsString(object);
    }

    public static Map<String, Object> parseToMap(String json) throws Exception {
        return objectMapper.readValue(json, new TypeReference<LinkedHashMap<String, Object>>(){});
    }

    public static String getVal(String json, String key) {
        try {
            if (json != null && json.length() > 0) {
                JsonNode node = MAPPER.readTree(json);
                return node.get(key) != null ? node.get(key).toString() : null;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Map<String, Object> silentReadMap(String jsonString) {
        try {
            return JsonUtils.readMap(jsonString);
        }
        catch (Throwable t) {
            log.error("Failed to serialize JSON", t);
            throw new RuntimeException("failed to deserialize JSON", t);
        }
    }

    public static Map<String, Object> readMap(String jsonString) throws JsonProcessingException {
        return JsonUtils.readJson(jsonString, MAP_TYPE_REFERENCE);
    }

    public static <T> T readJson(String jsonString, TypeReference<T> typeReference) throws JsonProcessingException {
        return objectMapper.readValue(jsonString, typeReference);
    }
}

