/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.intsmart.api.vo.CdiSystemVo;
import com.hanshow.intsmart.api.vo.CertificateVo;
import com.hanshow.intsmart.util.JsonUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mvel2.MVEL;
import org.springframework.beans.BeanUtils;

public class PropertiesUtil {
    private static final Logger log = LogManager.getLogger(PropertiesUtil.class);

    public static Object getProperty(String filePath, String key, String defaultValue) {
        String value = null;
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(filePath);
            value = config.getProperty(key).toString();
        }
        catch (ConfigurationException e) {
            value = defaultValue;
        }
        return value;
    }

    public static Object getProperty(String filePath, String key) {
        Object value = null;
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(filePath);
            value = config.getProperty(key);
        }
        catch (ConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public static Map<String, Object> getAllProperties(InputStream inputStream) {
        Properties prop = PropertiesUtil.readFile(inputStream);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            map.put(key, prop.getProperty(key));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readFile(InputStream inputStream) {
        Properties prop = new Properties();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(inputStream);
            prop.load(in);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return prop;
    }

    public static LinkedHashMap<String, Object> setPropertiesMap(CdiSystemVo form, CdiProperties cdiProperties) throws JsonProcessingException {
        Map<String, CdiProperties.Certificate> certificateMap = cdiProperties.getCdiSystem().getCertificateMap();
        BeanUtils.copyProperties(form, cdiProperties.getCdiSystem());
        cdiProperties.getCdiSystem().setCertificateMap(certificateMap);
        return JSONObject.parseObject(JsonUtils.toJsonString(cdiProperties.getCdiSystem()), LinkedHashMap.class, Feature.OrderedField);
    }

    public static LinkedHashMap<String, Object> setPropertiesMap(CertificateVo form, CdiProperties cdiProperties) throws JsonProcessingException {
        if (cdiProperties.getCdiSystem().getCertificateMap() == null) {
            HashMap<String, CdiProperties.Certificate> map = new HashMap<String, CdiProperties.Certificate>();
            CdiProperties.Certificate certificate = new CdiProperties.Certificate();
            BeanUtils.copyProperties(form, certificate);
            map.put(form.getCustomerCode(), certificate);
            cdiProperties.getCdiSystem().setCertificateMap(map);
        } else {
            Map<String, CdiProperties.Certificate> certificateMap = cdiProperties.getCdiSystem().getCertificateMap();
            CdiProperties.Certificate certificate = new CdiProperties.Certificate();
            BeanUtils.copyProperties(form, certificate);
            certificateMap.put(form.getCustomerCode(), certificate);
        }
        return JSONObject.parseObject(JsonUtils.toJsonString(cdiProperties), LinkedHashMap.class, Feature.OrderedField);
    }

    public static LinkedHashMap<String, Object> setPropertiesMap(CdiProperties.Task form, CdiProperties cdiProperties) throws JsonProcessingException {
        AtomicBoolean flag = new AtomicBoolean(true);
        cdiProperties.getTask().forEach(task -> {
            if (task.getTaskName().equals(form.getTaskName())) {
                Map<String, String> map;
                if ("client.database".equals(form.getIntegrationMode()) && (map = form.getFields().stream().collect(Collectors.toMap(CdiProperties.Field::getHanshow, CdiProperties.Field::getCustomer))).containsKey("storeCode")) {
                    String sqlCondition = form.getDatasource().getDatabaseSql().trim().toLowerCase().contains("select") ? (form.getDatasource().getDatabaseSql().trim().toLowerCase().contains("where") ? String.format("%s and %s =", form.getDatasource().getDatabaseSql().trim(), map.get("storeCode")) : String.format("%s where %s =", form.getDatasource().getDatabaseSql().trim(), map.get("storeCode"))) : form.getDatasource().getDatabaseSql().trim();
                    form.getDatasource().setDatabaseSqlCondition(sqlCondition);
                }
                BeanUtils.copyProperties(form, task);
                flag.set(false);
            }
        });
        if (flag.get()) {
            Map<String, String> map;
            CdiProperties.Task task2 = new CdiProperties.Task();
            if ("client.database".equals(form.getIntegrationMode()) && (map = form.getFields().stream().collect(Collectors.toMap(CdiProperties.Field::getHanshow, CdiProperties.Field::getCustomer))).containsKey("storeCode")) {
                String sqlCondition = form.getDatasource().getDatabaseSql().trim().toLowerCase().contains("select") ? (form.getDatasource().getDatabaseSql().trim().toLowerCase().contains("where") ? String.format("%s and %s =", form.getDatasource().getDatabaseSql().trim(), map.get("storeCode")) : String.format("%s where %s =", form.getDatasource().getDatabaseSql().trim(), map.get("storeCode"))) : form.getDatasource().getDatabaseSql().trim();
                form.getDatasource().setDatabaseSqlCondition(sqlCondition);
            }
            BeanUtils.copyProperties(form, task2);
            cdiProperties.getTask().add(task2);
        }
        return JSONObject.parseObject(JsonUtils.toJsonString(cdiProperties), LinkedHashMap.class, Feature.OrderedField);
    }

    public static LinkedHashMap<String, Object> deletedPropertiesTask(String taskName, CdiProperties cdiProperties) throws JsonProcessingException {
        cdiProperties.getTask().removeIf(task -> task.getTaskName().equals(taskName));
        return JSONObject.parseObject(JsonUtils.toJsonString(cdiProperties), LinkedHashMap.class, Feature.OrderedField);
    }

    public static LinkedHashMap<String, Object> startTask(String taskName, GenericCdiServerContext serverContext) throws JsonProcessingException {
        serverContext.getCdiProperties().getTask().forEach(task -> {
            if (task.getTaskName().equals(taskName)) {
                task.setIntegrationStatus(true);
            }
        });
        serverContext.getTaskMap().get(taskName).setIntegrationStatus(true);
        return JSONObject.parseObject(JsonUtils.toJsonString(serverContext.getCdiProperties()), LinkedHashMap.class, Feature.OrderedField);
    }

    public static LinkedHashMap<String, Object> stopTask(String taskName, GenericCdiServerContext serverContext) throws JsonProcessingException {
        serverContext.getCdiProperties().getTask().forEach(task -> {
            if (task.getTaskName().equals(taskName)) {
                task.setIntegrationStatus(false);
            }
        });
        serverContext.getTaskMap().get(taskName).setIntegrationStatus(false);
        return JSONObject.parseObject(JsonUtils.toJsonString(serverContext.getCdiProperties()), LinkedHashMap.class, Feature.OrderedField);
    }

    public static Map<String, String> parseStringMap(String[] elements) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (elements != null && elements.length != 0) {
            for (String e : elements) {
                String[] sps = e.split(":");
                map.put(sps[0], sps[1]);
            }
            return map;
        }
        return map;
    }

    public static List<HashMap<String, Object>> mvelProcessList(String expression, List<HashMap<String, Object>> goodsList) {
        for (HashMap<String, Object> map : goodsList) {
            try {
                Object o = MVEL.eval(expression, map);
                HashMap map1 = (HashMap)o;
                map.putAll(map1);
            }
            catch (Exception e) {
                log.error("oldMap : {}", (Object)map);
                log.error("MVEL process data error\uff1a", (Throwable)e);
            }
        }
        return goodsList;
    }

    public static Map<String, Object> mvelProcess(String expression, Map<String, Object> map) {
        try {
            Object o = MVEL.eval(expression, map);
            HashMap map1 = (HashMap)o;
            if (map1.containsValue(false)) {
                throw new Exception("please judge the price field is or not empty in the mvel");
            }
            map.putAll(map1);
        }
        catch (Exception e) {
            log.error("oldMap : {}", (Object)map);
            log.error("MVEL process data error\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return map;
    }

    public static boolean isKg(Object obj) {
        String unit;
        return obj != null && ((unit = obj.toString().trim()).equalsIgnoreCase("kg") || unit.equalsIgnoreCase("1000g") || unit.equalsIgnoreCase("\u5343\u514b") || unit.equalsIgnoreCase("\u516c\u65a4") || unit.equalsIgnoreCase("1000\u514b"));
    }

    public static void main(String[] args) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap map2 = new HashMap();
        map1.put("p1", "\u5408\u683c");
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        list.add(map1);
        String expression = " p1 = p1.replace(\"1\", \"\");\nprice_1 = p1;\nreturn [\"p1\":p1,\"price_1\":price_1];";
        PropertiesUtil.testMvelProcessList(expression, list);
    }

    public static List<HashMap<String, Object>> testMvelProcessList(String expression, List<HashMap<String, Object>> goodsList) {
        for (HashMap<String, Object> map : goodsList) {
            try {
                log.info("oldMap : {}", (Object)map);
                Object o = MVEL.eval(expression, map);
                HashMap map1 = (HashMap)o;
                map.putAll(map1);
                log.info("newMap : {}", (Object)map);
            }
            catch (Exception e) {
                log.error("newMap : {}", (Object)map);
                log.error("MVEL process data error\uff1a", (Throwable)e);
            }
        }
        return goodsList;
    }
}

