@echo off

setlocal

set "SELF=%~dp0%service.bat"
rem Guess APP_HOME if not defined
set "CURRENT_DIR=%cd%"
rem CD to the upper dir
cd ..
set "APP_HOME=D:\hanshow\Hanshow-IntSmart-3.0-beta07"
set "JAVA_HOME=D:\hanshow\jdk-17.0.2"
rem Make sure prerequisite environment variables are set
if not "%JAVA_HOME%" == "" goto gotJdkHome
echo Neither the JAVA_HOME environment variable is defined
echo Service will try to guess them from the registry.
goto okJavaHome
goto okJavaHome
:gotJdkHome
if not exist "%JAVA_HOME%\bin\java.exe" goto noJavaHome
if not exist "%JAVA_HOME%\bin\javaw.exe" goto noJavaHome
if not exist "%JAVA_HOME%\bin\javac.exe" goto noJavaHome
goto okJavaHome
:noJavaHome
echo The JAVA_HOME environment variable is not defined correctly
echo This environment variable is needed to run this program
echo NB: JAVA_HOME should point to a JDK not a JRE
goto end
:okJavaHome
if "%PROCESSOR_ARCHITECTURE%"=="x86" goto x86
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" goto x64

:x86
echo 32bit OS found.
set "EXECUTABLE=%APP_HOME%\bin\integration_x86.exe"
goto okExec

:x64
echo 64bit OS found.
set "EXECUTABLE=%APP_HOME%\bin\integration_x64.exe"
goto okExec

:okExec
rem Set default Service name
set SERVICE_NAME=Hanshow-Integration07
set DISPLAYNAME=Hanshow %SERVICE_NAME%

if "x%1x" == "xx" goto displayUsage
set SERVICE_CMD=%1
shift
if "x%1x" == "xx" goto checkServiceCmd
:checkUser
if "x%1x" == "x/userx" goto runAsUser
if "x%1x" == "x--userx" goto runAsUser
set SERVICE_NAME=%1
set DISPLAYNAME=%1
shift
if "x%1x" == "xx" goto checkServiceCmd
goto checkUser
:runAsUser
shift
if "x%1x" == "xx" goto displayUsage
set SERVICE_USER=%1
shift
runas /env /savecred /user:%SERVICE_USER% "%COMSPEC% /K \"%SELF%\" %SERVICE_CMD% %SERVICE_NAME%"
goto end
:checkServiceCmd
if /i %SERVICE_CMD% == install goto doInstall
if /i %SERVICE_CMD% == remove goto doRemove
if /i %SERVICE_CMD% == uninstall goto doRemove
echo Unknown parameter "%SERVICE_CMD%"
:displayUsage
echo.
echo Usage: service.bat install/remove [service_name] [/user username]
goto end

:doRemove
rem Remove the service
echo Removing the service '%SERVICE_NAME%' ...
echo Using APP_HOME:    "%APP_HOME%"
"%EXECUTABLE%" //DS//%SERVICE_NAME% ^
    --LogPath "%APP_HOME%\logs"
if not errorlevel 1 goto removed
echo Failed removing '%SERVICE_NAME%' service
goto end
:removed
echo The service '%SERVICE_NAME%' has been removed.
goto end

:doInstall
rem Install the service
echo Installing the service '%SERVICE_NAME%' ...
echo Using APP_HOME:         "%APP_HOME%"
echo Using JAVA_HOME:        "%JAVA_HOME%"

rem Try to use the server jvm
set "JVM=%JAVA_HOME%\bin\server\jvm.dll"
if exist "%JVM%" goto foundJvm
rem Try to use the client jvm
set "JVM=%JAVA_HOME%\bin\client\jvm.dll"
if exist "%JVM%" goto foundJvm
echo Warning: Neither 'server' nor 'client' jvm.dll was found at JAVA_HOME.
set JVM=auto
:foundJvm
echo Using JVM:              "%JVM%"

set "CLASSPATH=%APP_HOME%\config;%APP_HOME%\lib\*"
echo ClassPath : "%CLASSPATH%"
set DEFAULT_JVM_OPTS="-Xms1024m;-Xmx4096m;-Duser.language=en;-Dfile.encoding=UTF-8;-Dintegration.home="%APP_HOME%";-Djava.security.egd=file:/dev/./urandom;--add-opens=java.base/sun.reflect.annotation=ALL-UNNAMED"

"%EXECUTABLE%" //IS//%SERVICE_NAME% ^
    --Description "Hanshow-Intsmart-3.0-beta07" ^
    --DisplayName "%DISPLAYNAME%" ^
    --Install "%EXECUTABLE%" ^
    --LogPath "%APP_HOME%\logs" ^
    --StdOutput auto ^
    --StdError auto ^
    --Startup auto ^
    --Classpath "%CLASSPATH%" ^
    --Jvm "%JVM%" ^
    --StartMode jvm ^
    --StopMode jvm ^
    --StartPath "%APP_HOME%" ^
    --StopPath "%APP_HOME%" ^
    --StartClass com.hanshow.intsmart.Bootstrap ^
    --StartParams "" ^
    --StopClass com.hanshow.intsmart.Bootstrap ^
    --StartMethod start ^
    --StopMethod stop ^
    --JvmOptions "%DEFAULT_JVM_OPTS%"
if not errorlevel 1 goto installed
echo Failed installing '%SERVICE_NAME%' service
goto end
:installed
echo The service '%SERVICE_NAME%' has been installed.

:end
cd "%CURRENT_DIR%"
