-- Copyright (c) 2003, 2016, Oracle and/or its affiliates. All rights reserved.
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; version 2 of the License.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-- DO NOT EDIT THIS FILE. It is generated automatically by the MySQL docs
-- team. If you require changes to the format of this file, contact the
-- docs team.

-- File generation date: 2016-05-25
-- MySQL series: 5.7
-- Document repository revision: 47824

-- To use this file, load its contents into the mysql database. For example,
-- with the mysql client program, process the file like this, where
-- file_name is the name of this file:

--     mysql -u root -p mysql < file_name

SET sql_log_bin=0;
SET NAMES 'utf8';

TRUNCATE TABLE help_topic;
TRUNCATE TABLE help_category;
TRUNCATE TABLE help_keyword;
TRUNCATE TABLE help_relation;

START TRANSACTION;

INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (1,'Geographic',0,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (2,'Polygon properties',35,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (3,'Numeric Functions',39,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (4,'WKT',35,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (5,'Plugins',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (6,'Control flow functions',39,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (7,'MBR',35,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (8,'Transactions',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (9,'Help Metadata',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (10,'Account Management',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (11,'Point properties',35,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (12,'Encryption Functions',39,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (13,'LineString properties',35,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (14,'Miscellaneous Functions',39,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (15,'Logical operators',39,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (16,'Functions and Modifiers for Use with GROUP BY',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (17,'Information Functions',39,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (18,'Storage Engines',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (19,'Bit Functions',39,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (20,'Comparison operators',39,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (21,'Table Maintenance',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (22,'User-Defined Functions',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (23,'Data Types',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (24,'Compound Statements',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (25,'Geometry constructors',35,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (26,'GeometryCollection properties',1,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (27,'Administration',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (28,'Data Manipulation',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (29,'Utility',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (30,'Language Structure',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (31,'Geometry relations',35,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (32,'Date and Time Functions',39,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (33,'WKB',35,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (34,'Procedures',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (35,'Geographic Features',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (36,'Contents',0,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (37,'Geometry properties',35,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (38,'String Functions',39,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (39,'Functions',36,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (40,'Data Definition',36,'');

INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (0,28,'JOIN','MySQL supports the following JOIN syntaxes for the table_references\npart of SELECT statements and multiple-table DELETE and UPDATE\nstatements:\n\ntable_references:\n    escaped_table_reference [, escaped_table_reference] ...\n\nescaped_table_reference:\n    table_reference\n  | { OJ table_reference }\n\ntable_reference:\n    table_factor\n  | join_table\n\ntable_factor:\n    tbl_name [PARTITION (partition_names)] \n        [[AS] alias] [index_hint_list]\n  | table_subquery [AS] alias\n  | ( table_references )\n\njoin_table:\n    table_reference [INNER | CROSS] JOIN table_factor [join_condition]\n  | table_reference STRAIGHT_JOIN table_factor\n  | table_reference STRAIGHT_JOIN table_factor ON conditional_expr\n  | table_reference {LEFT|RIGHT} [OUTER] JOIN table_reference join_condition\n  | table_reference NATURAL [{LEFT|RIGHT} [OUTER]] JOIN table_factor\n\njoin_condition:\n    ON conditional_expr\n  | USING (column_list)\n\nindex_hint_list:\n    index_hint [, index_hint] ...\n\nindex_hint:\n    USE {INDEX|KEY}\n      [FOR {JOIN|ORDER BY|GROUP BY}] ([index_list])\n  | IGNORE {INDEX|KEY}\n      [FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n  | FORCE {INDEX|KEY}\n      [FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n\nindex_list:\n    index_name [, index_name] ...\n\nA table reference is also known as a join expression.\n\nA table reference (when it refers to a partitioned table) may contain a\nPARTITION option, including a comma-separated list of partitions,\nsubpartitions, or both. This option follows the name of the table and\nprecedes any alias declaration. The effect of this option is that rows\nare selected only from the listed partitions or subpartitions---in\nother words, any partitions or subpartitions not named in the list are\nignored For more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/partitioning-selection.html.\n\nThe syntax of table_factor is extended in comparison with the SQL\nStandard. The latter accepts only table_reference, not a list of them\ninside a pair of parentheses.\n\nThis is a conservative extension if we consider each comma in a list of\ntable_reference items as equivalent to an inner join. For example:\n\nSELECT * FROM t1 LEFT JOIN (t2, t3, t4)\n                 ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n\nis equivalent to:\n\nSELECT * FROM t1 LEFT JOIN (t2 CROSS JOIN t3 CROSS JOIN t4)\n                 ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n\nIn MySQL, JOIN, CROSS JOIN, and INNER JOIN are syntactic equivalents\n(they can replace each other). In standard SQL, they are not\nequivalent. INNER JOIN is used with an ON clause, CROSS JOIN is used\notherwise.\n\nIn general, parentheses can be ignored in join expressions containing\nonly inner join operations. MySQL also supports nested joins (see\nhttp://dev.mysql.com/doc/refman/5.7/en/nested-join-optimization.html).\n\nIndex hints can be specified to affect how the MySQL optimizer makes\nuse of indexes. For more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/index-hints.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/join.html\n\n','SELECT left_tbl.*\n  FROM left_tbl LEFT JOIN right_tbl ON left_tbl.id = right_tbl.id\n  WHERE right_tbl.id IS NULL;\n','http://dev.mysql.com/doc/refman/5.7/en/join.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (1,38,'HEX','Syntax:\nHEX(str), HEX(N)\n\nFor a string argument str, HEX() returns a hexadecimal string\nrepresentation of str where each byte of each character in str is\nconverted to two hexadecimal digits. (Multibyte characters therefore\nbecome more than two digits.) The inverse of this operation is\nperformed by the UNHEX() function.\n\nFor a numeric argument N, HEX() returns a hexadecimal string\nrepresentation of the value of N treated as a longlong (BIGINT) number.\nThis is equivalent to CONV(N,10,16). The inverse of this operation is\nperformed by CONV(HEX(N),16,10).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT X\'616263\', HEX(\'abc\'), UNHEX(HEX(\'abc\'));\n        -> \'abc\', 616263, \'abc\'\nmysql> SELECT HEX(255), CONV(HEX(255),16,10);\n        -> \'FF\', 255\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (2,31,'CONTAINS','Contains(g1,g2)\n\nMBRContains() and Contains() are synonyms. For more information, see\nthe description of MBRContains().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (3,37,'SRID','SRID(g)\n\nST_SRID() and SRID() are synonyms. For more information, see the\ndescription of ST_SRID().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (4,16,'VARIANCE','Syntax:\nVARIANCE(expr)\n\nReturns the population standard variance of expr. This is an extension\nto standard SQL. The standard SQL function VAR_POP() can be used\ninstead.\n\nVARIANCE() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (5,40,'DROP SERVER','Syntax:\nDROP SERVER [ IF EXISTS ] server_name\n\nDrops the server definition for the server named server_name. The\ncorresponding row in the mysql.servers table is deleted. This statement\nrequires the SUPER privilege.\n\nDropping a server for a table does not affect any FEDERATED tables that\nused this connection information when they were created. See [HELP\nCREATE SERVER].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-server.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-server.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (6,26,'ST_GEOMETRYN','ST_GeometryN(gc,N)\n\nReturns the N-th geometry in the GeometryCollection value gc.\nGeometries are numbered beginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-geometrycollection-property-functions.html\n\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT ST_AsText(ST_GeometryN(ST_GeomFromText(@gc),1));\n+-------------------------------------------------+\n| ST_AsText(ST_GeometryN(ST_GeomFromText(@gc),1)) |\n+-------------------------------------------------+\n| POINT(1 1)                                      |\n+-------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-geometrycollection-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (7,33,'ST_GEOMCOLLFROMWKB','ST_GeomCollFromWKB(wkb[,srid]),\nST_GeometryCollectionFromWKB(wkb[,srid])\n\nConstructs a GeometryCollection value using its WKB representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (8,38,'CONCAT','Syntax:\nCONCAT(str1,str2,...)\n\nReturns the string that results from concatenating the arguments. May\nhave one or more arguments. If all arguments are nonbinary strings, the\nresult is a nonbinary string. If the arguments include any binary\nstrings, the result is a binary string. A numeric argument is converted\nto its equivalent nonbinary string form.\n\nCONCAT() returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT CONCAT(\'My\', \'S\', \'QL\');\n        -> \'MySQL\'\nmysql> SELECT CONCAT(\'My\', NULL, \'QL\');\n        -> NULL\nmysql> SELECT CONCAT(14.3);\n        -> \'14.3\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (9,35,'GEOMETRY HIERARCHY','Geometry is the base class. It is an abstract class. The instantiable\nsubclasses of Geometry are restricted to zero-, one-, and\ntwo-dimensional geometric objects that exist in two-dimensional\ncoordinate space. All instantiable geometry classes are defined so that\nvalid instances of a geometry class are topologically closed (that is,\nall defined geometries include their boundary).\n\nThe base Geometry class has subclasses for Point, Curve, Surface, and\nGeometryCollection:\n\no Point represents zero-dimensional objects.\n\no Curve represents one-dimensional objects, and has subclass\n  LineString, with sub-subclasses Line and LinearRing.\n\no Surface is designed for two-dimensional objects and has subclass\n  Polygon.\n\no GeometryCollection has specialized zero-, one-, and two-dimensional\n  collection classes named MultiPoint, MultiLineString, and\n  MultiPolygon for modeling geometries corresponding to collections of\n  Points, LineStrings, and Polygons, respectively. MultiCurve and\n  MultiSurface are introduced as abstract superclasses that generalize\n  the collection interfaces to handle Curves and Surfaces.\n\nGeometry, Curve, Surface, MultiCurve, and MultiSurface are defined as\nnoninstantiable classes. They define a common set of methods for their\nsubclasses and are included for extensibility.\n\nPoint, LineString, Polygon, GeometryCollection, MultiPoint,\nMultiLineString, and MultiPolygon are instantiable classes.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-geometry-class-hierarchy.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-geometry-class-hierarchy.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (10,38,'CHAR FUNCTION','Syntax:\nCHAR(N,... [USING charset_name])\n\nCHAR() interprets each argument N as an integer and returns a string\nconsisting of the characters given by the code values of those\nintegers. NULL values are skipped.\nBy default, CHAR() returns a binary string. To produce a string in a\ngiven character set, use the optional USING clause:\n\nmysql> SELECT CHARSET(CHAR(X\'65\')), CHARSET(CHAR(X\'65\' USING utf8));\n+----------------------+---------------------------------+\n| CHARSET(CHAR(X\'65\')) | CHARSET(CHAR(X\'65\' USING utf8)) |\n+----------------------+---------------------------------+\n| binary               | utf8                            |\n+----------------------+---------------------------------+\n\nIf USING is given and the result string is illegal for the given\ncharacter set, a warning is issued. Also, if strict SQL mode is\nenabled, the result from CHAR() becomes NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT CHAR(77,121,83,81,\'76\');\n        -> \'MySQL\'\nmysql> SELECT CHAR(77,77.3,\'77.3\');\n        -> \'MMM\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (11,7,'ASYMMETRIC_DECRYPT','Syntax:\nASYMMETRIC_DECRYPT(algorithm, crypt_str, key_str)\n\nDecrypts an encrypted string using the given algorithm and key string,\nand returns the resulting cleartext as a binary string. If decryption\nfails, the result is NULL.\n\nkey_str must be a valid key string in PEM format. For successful\ndecryption, it must be the public or private key string corresponding\nto the private or public key string used with ASYMMETRIC_ENCRYPT() to\nproduce the encrypted string. algorithm indicates the encryption\nalgorithm used to create the key.\n\nSupported algorithm values: \'RSA\'\n\nFor a usage example, see the description of ASYMMETRIC_ENCRYPT().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (12,27,'SHOW CREATE TRIGGER','Syntax:\nSHOW CREATE TRIGGER trigger_name\n\nThis statement shows the CREATE TRIGGER statement that creates the\nnamed trigger. This statement requires the TRIGGER privilege for the\ntable associated with the trigger.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-create-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-create-trigger.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (13,27,'SHOW CREATE PROCEDURE','Syntax:\nSHOW CREATE PROCEDURE proc_name\n\nThis statement is a MySQL extension. It returns the exact string that\ncan be used to re-create the named stored procedure. A similar\nstatement, SHOW CREATE FUNCTION, displays information about stored\nfunctions (see [HELP SHOW CREATE FUNCTION]).\n\nTo use either statement, you must be the user named in the routine\nDEFINER clause or have SELECT access to the mysql.proc table. If you do\nnot have privileges for the routine itself, the value displayed for the\nCreate Procedure or Create Function field will be NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-create-procedure.html\n\n','mysql> SHOW CREATE PROCEDURE test.simpleproc\\G\n*************************** 1. row ***************************\n           Procedure: simpleproc\n            sql_mode:\n    Create Procedure: CREATE PROCEDURE `simpleproc`(OUT param1 INT)\n                      BEGIN\n                      SELECT COUNT(*) INTO param1 FROM t;\n                      END\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n\nmysql> SHOW CREATE FUNCTION test.hello\\G\n*************************** 1. row ***************************\n            Function: hello\n            sql_mode:\n     Create Function: CREATE FUNCTION `hello`(s CHAR(20))\n                      RETURNS CHAR(50)\n                      RETURN CONCAT(\'Hello, \',s,\'!\')\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n','http://dev.mysql.com/doc/refman/5.7/en/show-create-procedure.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (14,24,'OPEN','Syntax:\nOPEN cursor_name\n\nThis statement opens a previously declared cursor. For an example, see\nhttp://dev.mysql.com/doc/refman/5.7/en/cursors.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/open.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/open.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (15,31,'ST_INTERSECTS','ST_Intersects(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially intersects g2.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (16,38,'LOWER','Syntax:\nLOWER(str)\n\nReturns the string str with all characters changed to lowercase\naccording to the current character set mapping. The default is latin1\n(cp1252 West European).\n\nmysql> SELECT LOWER(\'QUADRATICALLY\');\n        -> \'quadratically\'\n\nLOWER() (and UPPER()) are ineffective when applied to binary strings\n(BINARY, VARBINARY, BLOB). To perform lettercase conversion, convert\nthe string to a nonbinary string:\n\nmysql> SET @str = BINARY \'New York\';\nmysql> SELECT LOWER(@str), LOWER(CONVERT(@str USING latin1));\n+-------------+-----------------------------------+\n| LOWER(@str) | LOWER(CONVERT(@str USING latin1)) |\n+-------------+-----------------------------------+\n| New York    | new york                          |\n+-------------+-----------------------------------+\n\nFor Unicode character sets, LOWER() and UPPER() work accounting to\nUnicode Collation Algorithm (UCA) 5.2.0 for xxx_unicode_520_ci\ncollations and for language-specific collations that are derived from\nthem. For other Unicode collations, LOWER() and UPPER() work accounting\nto Unicode Collation Algorithm (UCA) 4.0.0. See\nhttp://dev.mysql.com/doc/refman/5.7/en/charset-unicode-sets.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (17,40,'CREATE TRIGGER','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    TRIGGER trigger_name\n    trigger_time trigger_event\n    ON tbl_name FOR EACH ROW\n    [trigger_order]\n    trigger_body\n\ntrigger_time: { BEFORE | AFTER }\n\ntrigger_event: { INSERT | UPDATE | DELETE }\n\ntrigger_order: { FOLLOWS | PRECEDES } other_trigger_name\n\nThis statement creates a new trigger. A trigger is a named database\nobject that is associated with a table, and that activates when a\nparticular event occurs for the table. The trigger becomes associated\nwith the table named tbl_name, which must refer to a permanent table.\nYou cannot associate a trigger with a TEMPORARY table or a view.\n\nTrigger names exist in the schema namespace, meaning that all triggers\nmust have unique names within a schema. Triggers in different schemas\ncan have the same name.\n\nThis section describes CREATE TRIGGER syntax. For additional\ndiscussion, see\nhttp://dev.mysql.com/doc/refman/5.7/en/trigger-syntax.html.\n\nCREATE TRIGGER requires the TRIGGER privilege for the table associated\nwith the trigger. The statement might also require the SUPER privilege,\ndepending on the DEFINER value, as described later in this section. If\nbinary logging is enabled, CREATE TRIGGER might require the SUPER\nprivilege, as described in\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-programs-logging.html.\n\nThe DEFINER clause determines the security context to be used when\nchecking access privileges at trigger activation time, as described\nlater in this section.\n\ntrigger_time is the trigger action time. It can be BEFORE or AFTER to\nindicate that the trigger activates before or after each row to be\nmodified.\n\ntrigger_event indicates the kind of operation that activates the\ntrigger. These trigger_event values are permitted:\n\no INSERT: The trigger activates whenever a new row is inserted into the\n  table; for example, through INSERT, LOAD DATA, and REPLACE\n  statements.\n\no UPDATE: The trigger activates whenever a row is modified; for\n  example, through UPDATE statements.\n\no DELETE: The trigger activates whenever a row is deleted from the\n  table; for example, through DELETE and REPLACE statements. DROP TABLE\n  and TRUNCATE TABLE statements on the table do not activate this\n  trigger, because they do not use DELETE. Dropping a partition does\n  not activate DELETE triggers, either.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-trigger.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (18,32,'MONTH','Syntax:\nMONTH(date)\n\nReturns the month for date, in the range 1 to 12 for January to\nDecember, or 0 for dates such as \'0000-00-00\' or \'2008-00-00\' that have\na zero month part.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT MONTH(\'2008-02-03\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (19,7,'ASYMMETRIC_ENCRYPT','Syntax:\nASYMMETRIC_ENCRYPT(algorithm, str, key_str)\n\nEncrypts a string using the given algorithm and key string, and returns\nthe resulting ciphertext as a binary string. If encryption fails, the\nresult is NULL.\n\nThe str length cannot be greater than the key_str length − 11, in\nbytes\n\nkey_str must be a valid key string in PEM format. algorithm indicates\nthe encryption algorithm used to create the key.\n\nSupported algorithm values: \'RSA\'\n\nTo encrypt a string, pass a private or public key string to\nASYMMETRIC_ENCRYPT(). To recover the original unencrypted string, pass\nthe encrypted string to ASYMMETRIC_DECRYPT(), along with the public or\nprivate key string correponding to the private or public key string\nused for encryption.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html\n\n','-- Generate private/public key pair\nSET @priv = CREATE_ASYMMETRIC_PRIV_KEY(\'RSA\', 1024);\nSET @pub = CREATE_ASYMMETRIC_PUB_KEY(\'RSA\', @priv);\n\n-- Encrypt using private key, decrypt using public key\nSET @ciphertext = ASYMMETRIC_ENCRYPT(\'RSA\', \'The quick brown fox\', @priv);\nSET @cleartext = ASYMMETRIC_DECRYPT(\'RSA\', @ciphertext, @pub);\n\n-- Encrypt using public key, decrypt using private key\nSET @ciphertext = ASYMMETRIC_ENCRYPT(\'RSA\', \'The quick brown fox\', @pub);\nSET @cleartext = ASYMMETRIC_DECRYPT(\'RSA\', @ciphertext, @priv);\n','http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (20,27,'SHOW TRIGGERS','Syntax:\nSHOW TRIGGERS [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TRIGGERS lists the triggers currently defined for tables in a\ndatabase (the default database unless a FROM clause is given). This\nstatement returns results only for databases and tables for which you\nhave the TRIGGER privilege. The LIKE clause, if present, indicates\nwhich table names to match (not trigger names) and causes the statement\nto display triggers for those tables. The WHERE clause can be given to\nselect rows using more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nFor the trigger ins_sum as defined in\nhttp://dev.mysql.com/doc/refman/5.7/en/triggers.html, the output of\nthis statement is as shown here:\n\nmysql> SHOW TRIGGERS LIKE \'acc%\'\\G\n*************************** 1. row ***************************\n             Trigger: ins_sum\n               Event: INSERT\n               Table: account\n           Statement: SET @sum = @sum + NEW.amount\n              Timing: BEFORE\n             Created: 2013-07-09 10:39:34.96\n            sql_mode: NO_ENGINE_SUBSTITUTION\n             Definer: me@localhost\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n  Database Collation: latin1_swedish_ci\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-triggers.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-triggers.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (21,13,'ISCLOSED','IsClosed(ls)\n\nST_IsClosed() and IsClosed() are synonyms. For more information, see\nthe description of ST_IsClosed().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (22,38,'REGEXP','Syntax:\nexpr REGEXP pat, expr RLIKE pat\n\nPerforms a pattern match of a string expression expr against a pattern\npat. The pattern can be an extended regular expression, the syntax for\nwhich is discussed later in this section. Returns 1 if expr matches\npat; otherwise it returns 0. If either expr or pat is NULL, the result\nis NULL. RLIKE is a synonym for REGEXP, provided for mSQL\ncompatibility.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n\n*Note*: Because MySQL uses the C escape syntax in strings (for example,\n"\\n" to represent the newline character), you must double any "\\" that\nyou use in your REGEXP strings.\n\nREGEXP is not case sensitive, except when used with binary strings.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/regexp.html\n\n','mysql> SELECT \'Monty!\' REGEXP \'.*\';\n        -> 1\nmysql> SELECT \'new*\\n*line\' REGEXP \'new\\\\*.\\\\*line\';\n        -> 1\nmysql> SELECT \'a\' REGEXP \'A\', \'a\' REGEXP BINARY \'A\';\n        -> 1  0\nmysql> SELECT \'a\' REGEXP \'^[a-d]\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/regexp.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (23,13,'ST_POINTN','ST_PointN(ls,N)\n\nReturns the N-th Point in the Linestring value ls. Points are numbered\nbeginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_AsText(ST_PointN(ST_GeomFromText(@ls),2));\n+----------------------------------------------+\n| ST_AsText(ST_PointN(ST_GeomFromText(@ls),2)) |\n+----------------------------------------------+\n| POINT(2 2)                                   |\n+----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (24,24,'IF STATEMENT','Syntax:\nIF search_condition THEN statement_list\n    [ELSEIF search_condition THEN statement_list] ...\n    [ELSE statement_list]\nEND IF\n\nThe IF statement for stored programs implements a basic conditional\nconstruct.\n\n*Note*: There is also an IF() function, which differs from the IF\nstatement described here. See\nhttp://dev.mysql.com/doc/refman/5.7/en/control-flow-functions.html. The\nIF statement can have THEN, ELSE, and ELSEIF clauses, and it is\nterminated with END IF.\n\nIf the search_condition evaluates to true, the corresponding THEN or\nELSEIF clause statement_list executes. If no search_condition matches,\nthe ELSE clause statement_list executes.\n\nEach statement_list consists of one or more SQL statements; an empty\nstatement_list is not permitted.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/if.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/if.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (25,12,'VALIDATE_PASSWORD_STRENGTH','Syntax:\nVALIDATE_PASSWORD_STRENGTH(str)\n\nGiven an argument representing a cleartext password, this function\nreturns an integer to indicate how strong the password is. The return\nvalue ranges from 0 (weak) to 100 (strong).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (26,31,'WITHIN','Within(g1,g2)\n\nMBRWithin() and Within() are synonyms. For more information, see the\ndescription of MBRWithin().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (27,27,'SHOW PLUGINS','Syntax:\nSHOW PLUGINS\n\nSHOW PLUGINS displays information about server plugins. Plugin\ninformation is also available in the INFORMATION_SCHEMA.PLUGINS table.\nSee http://dev.mysql.com/doc/refman/5.7/en/plugins-table.html.\n\nExample of SHOW PLUGINS output:\n\nmysql> SHOW PLUGINS\\G\n*************************** 1. row ***************************\n   Name: binlog\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n*************************** 2. row ***************************\n   Name: CSV\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n*************************** 3. row ***************************\n   Name: MEMORY\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n*************************** 4. row ***************************\n   Name: MyISAM\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n...\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-plugins.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-plugins.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (28,8,'PREPARE','Syntax:\nPREPARE stmt_name FROM preparable_stmt\n\nThe PREPARE statement prepares a SQL statement and assigns it a name,\nstmt_name, by which to refer to the statement later. The prepared\nstatement is executed with EXECUTE and released with DEALLOCATE\nPREPARE. For examples, see\nhttp://dev.mysql.com/doc/refman/5.7/en/sql-syntax-prepared-statements.h\ntml.\n\nStatement names are not case sensitive. preparable_stmt is either a\nstring literal or a user variable that contains the text of the SQL\nstatement. The text must represent a single statement, not multiple\nstatements. Within the statement, ? characters can be used as parameter\nmarkers to indicate where data values are to be bound to the query\nlater when you execute it. The ? characters should not be enclosed\nwithin quotation marks, even if you intend to bind them to string\nvalues. Parameter markers can be used only where data values should\nappear, not for SQL keywords, identifiers, and so forth.\n\nIf a prepared statement with the given name already exists, it is\ndeallocated implicitly before the new statement is prepared. This means\nthat if the new statement contains an error and cannot be prepared, an\nerror is returned and no statement with the given name exists.\n\nThe scope of a prepared statement is the session within which it is\ncreated, which as several implications:\n\no A prepared statement created in one session is not available to other\n  sessions.\n\no When a session ends, whether normally or abnormally, its prepared\n  statements no longer exist. If auto-reconnect is enabled, the client\n  is not notified that the connection was lost. For this reason,\n  clients may wish to disable auto-reconnect. See\n  http://dev.mysql.com/doc/refman/5.7/en/auto-reconnect.html.\n\no A prepared statement created within a stored program continues to\n  exist after the program finishes executing and can be executed\n  outside the program later.\n\no A statement prepared in stored program context cannot refer to stored\n  procedure or function parameters or local variables because they go\n  out of scope when the program ends and would be unavailable were the\n  statement to be executed later outside the program. As a workaround,\n  refer instead to user-defined variables, which also have session\n  scope; see\n  http://dev.mysql.com/doc/refman/5.7/en/user-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/prepare.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/prepare.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (29,8,'LOCK','Syntax:\nLOCK TABLES\n    tbl_name [[AS] alias] lock_type\n    [, tbl_name [[AS] alias] lock_type] ...\n\nlock_type:\n    READ [LOCAL]\n  | [LOW_PRIORITY] WRITE\n\nUNLOCK TABLES\n\nMySQL enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to\nprevent other sessions from modifying tables during periods when a\nsession requires exclusive access to them. A session can acquire or\nrelease locks only for itself. One session cannot acquire locks for\nanother session or release locks held by another session.\n\nLocks may be used to emulate transactions or to get more speed when\nupdating tables. This is explained in more detail later in this\nsection.\n\nLOCK TABLES explicitly acquires table locks for the current client\nsession. Table locks can be acquired for base tables or views. You must\nhave the LOCK TABLES privilege, and the SELECT privilege for each\nobject to be locked.\n\nFor view locking, LOCK TABLES adds all base tables used in the view to\nthe set of tables to be locked and locks them automatically. If you\nlock a table explicitly with LOCK TABLES, any tables used in triggers\nare also locked implicitly, as described in\nhttp://dev.mysql.com/doc/refman/5.7/en/lock-tables-and-triggers.html.\n\nUNLOCK TABLES explicitly releases any table locks held by the current\nsession. LOCK TABLES implicitly releases any table locks held by the\ncurrent session before acquiring new locks.\n\nAnother use for UNLOCK TABLES is to release the global read lock\nacquired with the FLUSH TABLES WITH READ LOCK statement, which enables\nyou to lock all tables in all databases. See [HELP FLUSH]. (This is a\nvery convenient way to get backups if you have a file system such as\nVeritas that can take snapshots in time.)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/lock-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/lock-tables.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (30,27,'SHOW BINARY LOGS','Syntax:\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [HELP PURGE BINARY LOGS], that shows\nhow to determine which logs can be purged.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+\n| Log_name      | File_size |\n+---------------+-----------+\n| binlog.000015 |    724935 |\n| binlog.000016 |    733481 |\n+---------------+-----------+\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-binary-logs.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-binary-logs.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (31,25,'POLYGON','Polygon(ls1,ls2,...)\n\nConstructs a Polygon value from a number of LineString or WKB\nLineString arguments. If any argument does not represent a LinearRing\n(that is, not a closed and simple LineString), the return value is\nNULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (32,32,'MINUTE','Syntax:\nMINUTE(time)\n\nReturns the minute for time, in the range 0 to 59.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT MINUTE(\'2008-02-03 10:05:03\');\n        -> 5\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (33,38,'MID','Syntax:\nMID(str,pos,len)\n\nMID(str,pos,len) is a synonym for SUBSTRING(str,pos,len).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (34,17,'CONNECTION_ID','Syntax:\nCONNECTION_ID()\n\nReturns the connection ID (thread ID) for the connection. Every\nconnection has an ID that is unique among the set of currently\nconnected clients.\n\nThe value returned by CONNECTION_ID() is the same type of value as\ndisplayed in the ID column of the INFORMATION_SCHEMA.PROCESSLIST table,\nthe Id column of SHOW PROCESSLIST output, and the PROCESSLIST_ID column\nof the Performance Schema threads table.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> SELECT CONNECTION_ID();\n        -> 23786\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (35,28,'DELETE','Syntax:\nDELETE is a DML statement that removes rows from a table.\n\nSingle-Table Syntax\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE] FROM tbl_name\n    [PARTITION (partition_name,...)]\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nThe DELETE statement deletes rows from tbl_name and returns the number\nof deleted rows. To check the number of deleted rows, call the\nROW_COUNT() function described in\nhttp://dev.mysql.com/doc/refman/5.7/en/information-functions.html.\n\nMain Clauses\n\nThe conditions in the optional WHERE clause identify which rows to\ndelete. With no WHERE clause, all rows are deleted.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe deleted. It is specified as described in\nhttp://dev.mysql.com/doc/refman/5.7/en/select.html.\n\nIf the ORDER BY clause is specified, the rows are deleted in the order\nthat is specified. The LIMIT clause places a limit on the number of\nrows that can be deleted. These clauses apply to single-table deletes,\nbut not multi-table deletes.\n\nMultiple-Table Syntax\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    tbl_name[.*] [, tbl_name[.*]] ...\n    FROM table_references\n    [WHERE where_condition]\n\nOr:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    FROM tbl_name[.*] [, tbl_name[.*]] ...\n    USING table_references\n    [WHERE where_condition]\n\nPrivileges\n\nYou need the DELETE privilege on a table to delete rows from it. You\nneed only the SELECT privilege for any columns that are only read, such\nas those named in the WHERE clause.\n\nPerformance\n\nWhen you do not need to know the number of deleted rows, the TRUNCATE\nTABLE statement is a faster way to empty a table than a DELETE\nstatement with no WHERE clause. Unlike DELETE, TRUNCATE TABLE cannot be\nused within a transaction or if you have a lock on the table. See [HELP\nTRUNCATE TABLE] and [HELP LOCK].\n\nThe speed of delete operations may also be affected by factors\ndiscussed in http://dev.mysql.com/doc/refman/5.7/en/delete-speed.html.\n\nTo ensure that a given DELETE statement does not take too much time,\nthe MySQL-specific LIMIT row_count clause for DELETE specifies the\nmaximum number of rows to be deleted. If the number of rows to delete\nis larger than the limit, repeat the DELETE statement until the number\nof affected rows is less than the LIMIT value.\n\nSubqueries\n\nYou cannot delete from a table and select from the same table in a\nsubquery.\n\nPartitioned Tables\n\nDELETE supports explicit partition selection using the PARTITION\noption, which takes a comma-separated list of the names of one or more\npartitions or subpartitions (or both) from which to select rows to be\ndropped. Partitions not included in the list are ignored. Given a\npartitioned table t with a partition named p0, executing the statement\nDELETE FROM t PARTITION (p0) has the same effect on the table as\nexecuting ALTER TABLE t TRUNCATE PARTITION (p0); in both cases, all\nrows in partition p0 are dropped.\n\nPARTITION can be used along with a WHERE condition, in which case the\ncondition is tested only on rows in the listed partitions. For example,\nDELETE FROM t PARTITION (p0) WHERE c < 5 deletes rows only from\npartition p0 for which the condition c < 5 is true; rows in any other\npartitions are not checked and thus not affected by the DELETE.\n\nThe PARTITION option can also be used in multiple-table DELETE\nstatements. You can use up to one such option per table named in the\nFROM option.\n\nSee http://dev.mysql.com/doc/refman/5.7/en/partitioning-selection.html,\nfor more information and examples.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/delete.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/delete.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (36,7,'JSON_SEARCH','JSON_SEARCH(json_doc, one_or_all, search_str[, escape_char[, path]\n...])\n\nReturns the path to the given string within a JSON document. Returns\nNULL if any of the json_doc, search_str, or path arguments are NULL; no\npath exists within the document; or search_str is not found. An error\noccurs if the json_doc argument is not a valid JSON document, any path\nargument is not a valid path expression, one_or_all is not \'one\' or\n\'all\', or escape_char is not a constant expression.\n\nThe one_or_all argument affects the search as follows:\n\no \'one\': The search terminates after the first match and returns one\n  path string. It is undefined which match is considered first.\n\no \'all\': The search returns all matching path strings such that no\n  duplicate paths are included. If there are multiple strings, they are\n  autowrapped as an array. The order of the array elements is\n  undefined.\n\nWithin the search_str search string argument, the % and _ characters\nwork as for the LIKE operator: % matches any number of characters\n(including zero characters), and _ matches exactly one character.\n\nTo specify a literal % or _ character in the search string, precede it\nby the escape character. The default is \\ if the escape_char argument\nis missing or NULL. Otherwise, escape_char must be a constant that is\nempty or one character.\n\nFor more information about matching and escape character behavior, see\nthe description of LIKE in\nhttp://dev.mysql.com/doc/refman/5.7/en/string-comparison-functions.html\n. For escape character handling, a difference from the LIKE behavior is\nthat the escape character for JSON_SEARCH() must evaluate to a constant\nat compile time, not just at execution time. For example, if\nJSON_SEARCH() is used in a prepared statement and the escape_char\nargument is supplied using a ? parameter, the parameter value might be\nconstant at execution time, but is not at compile time.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html\n\n','mysql> SET @j = \'["abc", [{"k": "10"}, "def"], {"x":"abc"}, {"y":"bcd"}]\';\n\nmysql> SELECT JSON_SEARCH(@j, \'one\', \'abc\');\n+-------------------------------+\n| JSON_SEARCH(@j, \'one\', \'abc\') |\n+-------------------------------+\n| "$[0]"                        |\n+-------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'abc\');\n+-------------------------------+\n| JSON_SEARCH(@j, \'all\', \'abc\') |\n+-------------------------------+\n| ["$[0]", "$[2].x"]            |\n+-------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'ghi\');\n+-------------------------------+\n| JSON_SEARCH(@j, \'all\', \'ghi\') |\n+-------------------------------+\n| NULL                          |\n+-------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\');\n+------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\') |\n+------------------------------+\n| "$[1][0].k"                  |\n+------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$\');\n+-----------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$\') |\n+-----------------------------------------+\n| "$[1][0].k"                             |\n+-----------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[*]\');\n+--------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[*]\') |\n+--------------------------------------------+\n| "$[1][0].k"                                |\n+--------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$**.k\');\n+---------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$**.k\') |\n+---------------------------------------------+\n| "$[1][0].k"                                 |\n+---------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[*][0].k\');\n+-------------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[*][0].k\') |\n+-------------------------------------------------+\n| "$[1][0].k"                                     |\n+-------------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[1]\');\n+--------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[1]\') |\n+--------------------------------------------+\n| "$[1][0].k"                                |\n+--------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[1][0]\');\n+-----------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[1][0]\') |\n+-----------------------------------------------+\n| "$[1][0].k"                                   |\n+-----------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'abc\', NULL, \'$[2]\');\n+---------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'abc\', NULL, \'$[2]\') |\n+---------------------------------------------+\n| "$[2].x"                                    |\n+---------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%a%\');\n+-------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%a%\') |\n+-------------------------------+\n| ["$[0]", "$[2].x"]            |\n+-------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\');\n+-------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\') |\n+-------------------------------+\n| ["$[0]", "$[2].x", "$[3].y"]  |\n+-------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[0]\');\n+---------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[0]\') |\n+---------------------------------------------+\n| "$[0]"                                      |\n+---------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[2]\');\n+---------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[2]\') |\n+---------------------------------------------+\n| "$[2].x"                                    |\n+---------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[1]\');\n+---------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[1]\') |\n+---------------------------------------------+\n| NULL                                        |\n+---------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\', \'\', \'$[1]\');\n+-------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\', \'\', \'$[1]\') |\n+-------------------------------------------+\n| NULL                                      |\n+-------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\', \'\', \'$[3]\');\n+-------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\', \'\', \'$[3]\') |\n+-------------------------------------------+\n| "$[3].y"                                  |\n+-------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (37,24,'CLOSE','Syntax:\nCLOSE cursor_name\n\nThis statement closes a previously opened cursor. For an example, see\nhttp://dev.mysql.com/doc/refman/5.7/en/cursors.html.\n\nAn error occurs if the cursor is not open.\n\nIf not closed explicitly, a cursor is closed at the end of the BEGIN\n... END block in which it was declared.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/close.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/close.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (38,38,'REPLACE FUNCTION','Syntax:\nREPLACE(str,from_str,to_str)\n\nReturns the string str with all occurrences of the string from_str\nreplaced by the string to_str. REPLACE() performs a case-sensitive\nmatch when searching for from_str.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT REPLACE(\'www.mysql.com\', \'w\', \'Ww\');\n        -> \'WwWwWw.mysql.com\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (39,29,'USE','Syntax:\nUSE db_name\n\nThe USE db_name statement tells MySQL to use the db_name database as\nthe default (current) database for subsequent statements. The database\nremains the default until the end of the session or another USE\nstatement is issued:\n\nUSE db1;\nSELECT COUNT(*) FROM mytable;   # selects from db1.mytable\nUSE db2;\nSELECT COUNT(*) FROM mytable;   # selects from db2.mytable\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/use.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/use.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (40,6,'CASE OPERATOR','Syntax:\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nThe first version returns the result where value=compare_value. The\nsecond version returns the result for the first condition that is true.\nIf there was no matching result value, the result after ELSE is\nreturned, or NULL if there is no ELSE part.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/control-flow-functions.html\n\n','mysql> SELECT CASE 1 WHEN 1 THEN \'one\'\n    ->     WHEN 2 THEN \'two\' ELSE \'more\' END;\n        -> \'one\'\nmysql> SELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n        -> \'true\'\nmysql> SELECT CASE BINARY \'B\'\n    ->     WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/control-flow-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (41,27,'SHOW MASTER STATUS','Syntax:\nSHOW MASTER STATUS\n\nThis statement provides status information about the binary log files\nof the master. It requires either the SUPER or REPLICATION CLIENT\nprivilege.\n\nExample:\n\nmysql> SHOW MASTER STATUS\\G\n*************************** 1. row ***************************\n             File: master-bin.000002\n         Position: 1307\n     Binlog_Do_DB: test\n Binlog_Ignore_DB: manual, mysql\nExecuted_Gtid_Set: 3E11FA47-71CA-11E1-9E33-C80AA9429562:1-5\n1 row in set (0.00 sec)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-master-status.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-master-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (42,32,'TO_SECONDS','Syntax:\nTO_SECONDS(expr)\n\nGiven a date or datetime expr, returns the number of seconds since the\nyear 0. If expr is not a valid date or datetime value, returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT TO_SECONDS(950501);\n        -> 62966505600\nmysql> SELECT TO_SECONDS(\'2009-11-29\');\n        -> 63426672000\nmysql> SELECT TO_SECONDS(\'2009-11-29 13:43:32\');\n        -> 63426721412\nmysql> SELECT TO_SECONDS( NOW() );\n        -> 63426721458\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (43,32,'TIMESTAMPDIFF','Syntax:\nTIMESTAMPDIFF(unit,datetime_expr1,datetime_expr2)\n\nReturns datetime_expr2 − datetime_expr1, where datetime_expr1 and\ndatetime_expr2 are date or datetime expressions. One expression may be\na date and the other a datetime; a date value is treated as a datetime\nhaving the time part \'00:00:00\' where necessary. The unit for the\nresult (an integer) is given by the unit argument. The legal values for\nunit are the same as those listed in the description of the\nTIMESTAMPADD() function.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMPDIFF(MONTH,\'2003-02-01\',\'2003-05-01\');\n        -> 3\nmysql> SELECT TIMESTAMPDIFF(YEAR,\'2002-05-01\',\'2001-01-01\');\n        -> -1\nmysql> SELECT TIMESTAMPDIFF(MINUTE,\'2003-02-01\',\'2003-05-01 12:05:55\');\n        -> 128885\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (44,35,'SPATIAL','For MyISAM and (as of MySQL 5.7.5) InnoDB tables, MySQL can create\nspatial indexes using syntax similar to that for creating regular\nindexes, but using the SPATIAL keyword. Columns in spatial indexes must\nbe declared NOT NULL. The following examples demonstrate how to create\nspatial indexes:\n\no With CREATE TABLE:\n\nCREATE TABLE geom (g GEOMETRY NOT NULL, SPATIAL INDEX(g)) ENGINE=MyISAM;\n\no With ALTER TABLE:\n\nALTER TABLE geom ADD SPATIAL INDEX(g);\n\no With CREATE INDEX:\n\nCREATE SPATIAL INDEX sp_index ON geom (g);\n\nSPATIAL INDEX creates an R-tree index. For storage engines that support\nnonspatial indexing of spatial columns, the engine creates a B-tree\nindex. A B-tree index on spatial values is useful for exact-value\nlookups, but not for range scans.\n\nFor more information on indexing spatial columns, see [HELP CREATE\nINDEX].\n\nTo drop spatial indexes, use ALTER TABLE or DROP INDEX:\n\no With ALTER TABLE:\n\nALTER TABLE geom DROP INDEX g;\n\no With DROP INDEX:\n\nDROP INDEX sp_index ON geom;\n\nExample: Suppose that a table geom contains more than 32,000\ngeometries, which are stored in the column g of type GEOMETRY. The\ntable also has an AUTO_INCREMENT column fid for storing object ID\nvalues.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/creating-spatial-indexes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/creating-spatial-indexes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (45,38,'REVERSE','Syntax:\nREVERSE(str)\n\nReturns the string str with the order of the characters reversed.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT REVERSE(\'abc\');\n        -> \'cba\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (46,20,'ISNULL','Syntax:\nISNULL(expr)\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT ISNULL(1+1);\n        -> 0\nmysql> SELECT ISNULL(1/0);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (47,13,'ST_STARTPOINT','ST_StartPoint(ls)\n\nReturns the Point that is the start point of the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_AsText(ST_StartPoint(ST_GeomFromText(@ls)));\n+------------------------------------------------+\n| ST_AsText(ST_StartPoint(ST_GeomFromText(@ls))) |\n+------------------------------------------------+\n| POINT(1 1)                                     |\n+------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (48,23,'BINARY','BINARY(M)\n\nThe BINARY type is similar to the CHAR type, but stores binary byte\nstrings rather than nonbinary character strings. M represents the\ncolumn length in bytes.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (49,23,'BLOB DATA TYPE','A BLOB is a binary large object that can hold a variable amount of\ndata. The four BLOB types are TINYBLOB, BLOB, MEDIUMBLOB, and LONGBLOB.\nThese differ only in the maximum length of the values they can hold.\nThe four TEXT types are TINYTEXT, TEXT, MEDIUMTEXT, and LONGTEXT. These\ncorrespond to the four BLOB types and have the same maximum lengths and\nstorage requirements. See\nhttp://dev.mysql.com/doc/refman/5.7/en/storage-requirements.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/blob.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/blob.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (50,17,'CURRENT_USER','Syntax:\nCURRENT_USER, CURRENT_USER()\n\nReturns the user name and host name combination for the MySQL account\nthat the server used to authenticate the current client. This account\ndetermines your access privileges. The return value is a string in the\nutf8 character set.\n\nThe value of CURRENT_USER() can differ from the value of USER().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\nmysql> SELECT * FROM mysql.user;\nERROR 1044: Access denied for user \'\'@\'localhost\' to\ndatabase \'mysql\'\nmysql> SELECT CURRENT_USER();\n        -> \'@localhost\'\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (51,20,'<=','Syntax:\n<=\n\nLess than or equal:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 0.1 <= 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (52,27,'SHOW PROFILES','Syntax:\nSHOW PROFILES\n\nThe SHOW PROFILES statement, together with SHOW PROFILE, displays\nprofiling information that indicates resource usage for statements\nexecuted during the course of the current session. For more\ninformation, see [HELP SHOW PROFILE].\n\n*Note*: These statements are deprecated and will be removed in a future\nMySQL release. Use the Performance Schema instead; see\nhttp://dev.mysql.com/doc/refman/5.7/en/performance-schema.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-profiles.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-profiles.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (53,28,'UPDATE','Syntax:\nSingle-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_reference\n    SET col_name1={expr1|DEFAULT} [, col_name2={expr2|DEFAULT}] ...\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nMultiple-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_references\n    SET col_name1={expr1|DEFAULT} [, col_name2={expr2|DEFAULT}] ...\n    [WHERE where_condition]\n\nFor the single-table syntax, the UPDATE statement updates columns of\nexisting rows in the named table with new values. The SET clause\nindicates which columns to modify and the values they should be given.\nEach value can be given as an expression, or the keyword DEFAULT to set\na column explicitly to its default value. The WHERE clause, if given,\nspecifies the conditions that identify which rows to update. With no\nWHERE clause, all rows are updated. If the ORDER BY clause is\nspecified, the rows are updated in the order that is specified. The\nLIMIT clause places a limit on the number of rows that can be updated.\n\nFor the multiple-table syntax, UPDATE updates rows in each table named\nin table_references that satisfy the conditions. Each matching row is\nupdated once, even if it matches the conditions multiple times. For\nmultiple-table syntax, ORDER BY and LIMIT cannot be used.\n\nFor partitioned tables, both the single-single and multiple-table forms\nof this statement support the use of a PARTITION option as part of a\ntable reference. This option takes a list of one or more partitions or\nsubpartitions (or both). Only the partitions (or subpartitions) listed\nare checked for matches, and a row that is not in any of these\npartitions or subpartitions is not updated, whether it satisfies the\nwhere_condition or not.\n\n*Note*: Unlike the case when using PARTITION with an INSERT or REPLACE\nstatement, an otherwise valid UPDATE ... PARTITION statement is\nconsidered successful even if no rows in the listed partitions (or\nsubpartitions) match the where_condition.\n\nSee http://dev.mysql.com/doc/refman/5.7/en/partitioning-selection.html,\nfor more information and examples.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe updated. For expression syntax, see\nhttp://dev.mysql.com/doc/refman/5.7/en/expressions.html.\n\ntable_references and where_condition are specified as described in\nhttp://dev.mysql.com/doc/refman/5.7/en/select.html.\n\nYou need the UPDATE privilege only for columns referenced in an UPDATE\nthat are actually updated. You need only the SELECT privilege for any\ncolumns that are read but not modified.\n\nThe UPDATE statement supports the following modifiers:\n\no With the LOW_PRIORITY keyword, execution of the UPDATE is delayed\n  until no other clients are reading from the table. This affects only\n  storage engines that use only table-level locking (such as MyISAM,\n  MEMORY, and MERGE).\n\no With the IGNORE keyword, the update statement does not abort even if\n  errors occur during the update. Rows for which duplicate-key\n  conflicts occur on a unique key value are not updated. Rows updated\n  to values that would cause data conversion errors are updated to the\n  closest valid values instead. For more information, see\n  http://dev.mysql.com/doc/refman/5.7/en/sql-mode.html#ignore-strict-co\n  mparison.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/update.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/update.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (54,24,'CASE STATEMENT','Syntax:\nCASE case_value\n    WHEN when_value THEN statement_list\n    [WHEN when_value THEN statement_list] ...\n    [ELSE statement_list]\nEND CASE\n\nOr:\n\nCASE\n    WHEN search_condition THEN statement_list\n    [WHEN search_condition THEN statement_list] ...\n    [ELSE statement_list]\nEND CASE\n\nThe CASE statement for stored programs implements a complex conditional\nconstruct.\n\n*Note*: There is also a CASE expression, which differs from the CASE\nstatement described here. See\nhttp://dev.mysql.com/doc/refman/5.7/en/control-flow-functions.html. The\nCASE statement cannot have an ELSE NULL clause, and it is terminated\nwith END CASE instead of END.\n\nFor the first syntax, case_value is an expression. This value is\ncompared to the when_value expression in each WHEN clause until one of\nthem is equal. When an equal when_value is found, the corresponding\nTHEN clause statement_list executes. If no when_value is equal, the\nELSE clause statement_list executes, if there is one.\n\nThis syntax cannot be used to test for equality with NULL because NULL\n= NULL is false. See\nhttp://dev.mysql.com/doc/refman/5.7/en/working-with-null.html.\n\nFor the second syntax, each WHEN clause search_condition expression is\nevaluated until one is true, at which point its corresponding THEN\nclause statement_list executes. If no search_condition is equal, the\nELSE clause statement_list executes, if there is one.\n\nIf no when_value or search_condition matches the value tested and the\nCASE statement contains no ELSE clause, a Case not found for CASE\nstatement error results.\n\nEach statement_list consists of one or more SQL statements; an empty\nstatement_list is not permitted.\n\nTo handle situations where no value is matched by any WHEN clause, use\nan ELSE containing an empty BEGIN ... END block, as shown in this\nexample. (The indentation used here in the ELSE clause is for purposes\nof clarity only, and is not otherwise significant.)\n\nDELIMITER |\n\nCREATE PROCEDURE p()\n  BEGIN\n    DECLARE v INT DEFAULT 1;\n\n    CASE v\n      WHEN 2 THEN SELECT v;\n      WHEN 3 THEN SELECT 0;\n      ELSE\n        BEGIN\n        END;\n    END CASE;\n  END;\n  |\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/case.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/case.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (55,7,'ST_SIMPLIFY','ST_Simplify(g, max_distance)\n\nSimplifies a geometry using the Douglas-Peucker algorithm and returns a\nsimplified value of the same type, or NULL if any argument is NULL.\n\nThe geometry may be any geometry type, although the Douglas-Peucker\nalgorithm may not actually process every type. A geometry collection is\nprocessed by giving its components one by one to the simplification\nalgorithm, and the returned geometries are put into a geometry\ncollection as result.\n\nThe max_distance argument is the distance (in units of the input\ncoordinates) of a vertex to other segments to be removed. Vertices\nwithin this distance of the simplified linestring are removed. An\nER_WRONG_ARGUMENTS error occurs if the max_distance argument is not\npositive, or is NaN.\n\nAccording to Boost.Geometry, geometries might become invalid as a\nresult of the simplification process, and the process might create\nself-intersections. If you want to check the validity of the result,\npass it to ST_IsValid().\n\nAn ER_GIS_INVALID_DATA error occurs if the geometry argument is not a\nvalid geometry byte string.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-convenience-functions.html\n\n','mysql> SET @g = ST_GeomFromText(\'LINESTRING(0 0,0 1,1 1,1 2,2 2,2 3,3 3)\');\nmysql> SELECT ST_AsText(ST_Simplify(@g, 0.5));\n+---------------------------------+\n| ST_AsText(ST_Simplify(@g, 0.5)) |\n+---------------------------------+\n| LINESTRING(0 0,0 1,1 1,2 3,3 3) |\n+---------------------------------+\nmysql> SELECT ST_AsText(ST_Simplify(@g, 1.0));\n+---------------------------------+\n| ST_AsText(ST_Simplify(@g, 1.0)) |\n+---------------------------------+\n| LINESTRING(0 0,3 3)             |\n+---------------------------------+\nmysql> SELECT ST_AsText(ST_Simplify(@g));\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-convenience-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (56,8,'EXECUTE STATEMENT','Syntax:\nEXECUTE stmt_name\n    [USING @var_name [, @var_name] ...]\n\nAfter preparing a statement with PREPARE, you execute it with an\nEXECUTE statement that refers to the prepared statement name. If the\nprepared statement contains any parameter markers, you must supply a\nUSING clause that lists user variables containing the values to be\nbound to the parameters. Parameter values can be supplied only by user\nvariables, and the USING clause must name exactly as many variables as\nthe number of parameter markers in the statement.\n\nYou can execute a given prepared statement multiple times, passing\ndifferent variables to it or setting the variables to different values\nbefore each execution.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/execute.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/execute.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (57,40,'DROP INDEX','Syntax:\nDROP INDEX index_name ON tbl_name\n    [algorithm_option | lock_option] ...\n\nalgorithm_option:\n    ALGORITHM [=] {DEFAULT|INPLACE|COPY}\n\nlock_option:\n    LOCK [=] {DEFAULT|NONE|SHARED|EXCLUSIVE}\n\nDROP INDEX drops the index named index_name from the table tbl_name.\nThis statement is mapped to an ALTER TABLE statement to drop the index.\nSee [HELP ALTER TABLE].\n\nTo drop a primary key, the index name is always PRIMARY, which must be\nspecified as a quoted identifier because PRIMARY is a reserved word:\n\nDROP INDEX `PRIMARY` ON t;\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-index.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-index.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (58,3,'ABS','Syntax:\nABS(X)\n\nReturns the absolute value of X.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT ABS(2);\n        -> 2\nmysql> SELECT ABS(-32);\n        -> 32\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (59,14,'IS_IPV4','Syntax:\nIS_IPV4(expr)\n\nReturns 1 if the argument is a valid IPv4 address specified as a\nstring, 0 otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV4(\'10.0.5.9\'), IS_IPV4(\'10.0.5.256\');\n        -> 1, 0\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (60,33,'POLYFROMWKB','PolyFromWKB(wkb[,srid]), PolygonFromWKB(wkb[,srid])\n\nST_PolyFromWKB(), ST_PolygonFromWKB(), PolyFromWKB(), and\nPolygonFromWKB() are synonyms. For more information, see the\ndescription of ST_PolyFromWKB().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (61,38,'NOT LIKE','Syntax:\nexpr NOT LIKE pat [ESCAPE \'escape_char\']\n\nThis is the same as NOT (expr LIKE pat [ESCAPE \'escape_char\']).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-comparison-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-comparison-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (62,38,'SPACE','Syntax:\nSPACE(N)\n\nReturns a string consisting of N space characters.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT SPACE(6);\n        -> \'      \'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (63,16,'MAX','Syntax:\nMAX([DISTINCT] expr)\n\nReturns the maximum value of expr. MAX() may take a string argument; in\nsuch cases, it returns the maximum string value. See\nhttp://dev.mysql.com/doc/refman/5.7/en/mysql-indexes.html. The DISTINCT\nkeyword can be used to find the maximum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nMAX() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (64,22,'CREATE FUNCTION UDF','Syntax:\nCREATE [AGGREGATE] FUNCTION function_name RETURNS {STRING|INTEGER|REAL|DECIMAL}\n    SONAME shared_library_name\n\nA user-defined function (UDF) is a way to extend MySQL with a new\nfunction that works like a native (built-in) MySQL function such as\nABS() or CONCAT().\n\nfunction_name is the name that should be used in SQL statements to\ninvoke the function. The RETURNS clause indicates the type of the\nfunction\'s return value. DECIMAL is a legal value after RETURNS, but\ncurrently DECIMAL functions return string values and should be written\nlike STRING functions.\n\nshared_library_name is the base name of the shared library file that\ncontains the code that implements the function. The file must be\nlocated in the plugin directory. This directory is given by the value\nof the plugin_dir system variable. For more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/udf-compiling.html.\n\nTo create a function, you must have the INSERT privilege for the mysql\ndatabase. This is necessary because CREATE FUNCTION adds a row to the\nmysql.func system table that records the function\'s name, type, and\nshared library name. If you do not have this table, you should run the\nmysql_upgrade command to create it. See\nhttp://dev.mysql.com/doc/refman/5.7/en/mysql-upgrade.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-function-udf.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-function-udf.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (65,23,'TIMESTAMP','TIMESTAMP[(fsp)]\n\nA timestamp. The range is \'1970-01-01 00:00:01.000000\' UTC to\n\'2038-01-19 03:14:07.999999\' UTC. TIMESTAMP values are stored as the\nnumber of seconds since the epoch (\'1970-01-01 00:00:00\' UTC). A\nTIMESTAMP cannot represent the value \'1970-01-01 00:00:00\' because that\nis equivalent to 0 seconds from the epoch and the value 0 is reserved\nfor representing \'0000-00-00 00:00:00\', the "zero" TIMESTAMP value.\n\nAn optional fsp value in the range from 0 to 6 may be given to specify\nfractional seconds precision. A value of 0 signifies that there is no\nfractional part. If omitted, the default precision is 0.\n\nThe way the server handles TIMESTAMP definitions depends on the value\nof the explicit_defaults_for_timestamp system variable (see\nhttp://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html).\nBy default, explicit_defaults_for_timestamp is disabled and the server\nhandles TIMESTAMP as follows:\n\nUnless specified otherwise, the first TIMESTAMP column in a table is\ndefined to be automatically set to the date and time of the most recent\nmodification if not explicitly assigned a value. This makes TIMESTAMP\nuseful for recording the timestamp of an INSERT or UPDATE operation.\nYou can also set any TIMESTAMP column to the current date and time by\nassigning it a NULL value, unless it has been defined with the NULL\nattribute to permit NULL values.\n\nAutomatic initialization and updating to the current date and time can\nbe specified using DEFAULT CURRENT_TIMESTAMP and ON UPDATE\nCURRENT_TIMESTAMP column definition clauses. By default, the first\nTIMESTAMP column has these properties, as previously noted. However,\nany TIMESTAMP column in a table can be defined to have these\nproperties.\n\nIf explicit_defaults_for_timestamp is enabled, there is no automatic\nassignment of the DEFAULT CURRENT_TIMESTAMP or ON UPDATE\nCURRENT_TIMESTAMP attributes to any TIMESTAMP column. They must be\nincluded explicitly in the column definition. Also, any TIMESTAMP not\nexplicitly declared as NOT NULL permits NULL values.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (66,7,'CREATE_ASYMMETRIC_PUB_KEY','Syntax:\nCREATE_ASYMMETRIC_PUB_KEY(algorithm, priv_key_str)\n\nDerives a public key from the given private key using the given\nalgorithm, and returns the key as a binary string in PEM format. If key\nderivation fails, the result is NULL.\n\npriv_key_str must be a valid key string in PEM format. algorithm\nindicates the encryption algorithm used to create the key.\n\nSupported algorithm values: \'RSA\', \'DSA\', \'DH\'\n\nFor a usage example, see the description of\nCREATE_ASYMMETRIC_PRIV_KEY().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (67,27,'CACHE INDEX','Syntax:\nCACHE INDEX\n  tbl_index_list [, tbl_index_list] ...\n  [PARTITION (partition_list | ALL)]\n  IN key_cache_name\n\ntbl_index_list:\n  tbl_name [[INDEX|KEY] (index_name[, index_name] ...)]\n\npartition_list:\n  partition_name[, partition_name][, ...]\n\nThe CACHE INDEX statement assigns table indexes to a specific key\ncache. It is used only for MyISAM tables. After the indexes have been\nassigned, they can be preloaded into the cache if desired with LOAD\nINDEX INTO CACHE.\n\nThe following statement assigns indexes from the tables t1, t2, and t3\nto the key cache named hot_cache:\n\nmysql> CACHE INDEX t1, t2, t3 IN hot_cache;\n+---------+--------------------+----------+----------+\n| Table   | Op                 | Msg_type | Msg_text |\n+---------+--------------------+----------+----------+\n| test.t1 | assign_to_keycache | status   | OK       |\n| test.t2 | assign_to_keycache | status   | OK       |\n| test.t3 | assign_to_keycache | status   | OK       |\n+---------+--------------------+----------+----------+\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/cache-index.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/cache-index.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (68,12,'COMPRESS','Syntax:\nCOMPRESS(string_to_compress)\n\nCompresses a string and returns the result as a binary string. This\nfunction requires MySQL to have been compiled with a compression\nlibrary such as zlib. Otherwise, the return value is always NULL. The\ncompressed string can be uncompressed with UNCOMPRESS().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','mysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n        -> 21\nmysql> SELECT LENGTH(COMPRESS(\'\'));\n        -> 0\nmysql> SELECT LENGTH(COMPRESS(\'a\'));\n        -> 13\nmysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n        -> 15\n','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (69,28,'HANDLER','Syntax:\nHANDLER tbl_name OPEN [ [AS] alias]\n\nHANDLER tbl_name READ index_name { = | <= | >= | < | > } (value1,value2,...)\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ index_name { FIRST | NEXT | PREV | LAST }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ { FIRST | NEXT }\n    [ WHERE where_condition ] [LIMIT ... ]\n\nHANDLER tbl_name CLOSE\n\nThe HANDLER statement provides direct access to table storage engine\ninterfaces. It is available for InnoDB and MyISAM tables.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/handler.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/handler.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (70,9,'HELP_DATE','This help information was generated from the MySQL 5.7 Reference Manual\non: 2016-05-25\n','','');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (71,40,'RENAME TABLE','Syntax:\nRENAME TABLE tbl_name TO new_tbl_name\n    [, tbl_name2 TO new_tbl_name2] ...\n\nThis statement renames one or more tables. The rename operation is done\natomically, which means that no other session can access any of the\ntables while the rename is running.\n\nFor example, a table named old_table can be renamed to new_table as\nshown here:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/rename-table.html\n\n','RENAME TABLE old_table TO new_table;\n','http://dev.mysql.com/doc/refman/5.7/en/rename-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (72,23,'BOOLEAN','BOOL, BOOLEAN\n\nThese types are synonyms for TINYINT(1). A value of zero is considered\nfalse. Nonzero values are considered true:\n\nmysql> SELECT IF(0, \'true\', \'false\');\n+------------------------+\n| IF(0, \'true\', \'false\') |\n+------------------------+\n| false                  |\n+------------------------+\n\nmysql> SELECT IF(1, \'true\', \'false\');\n+------------------------+\n| IF(1, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nmysql> SELECT IF(2, \'true\', \'false\');\n+------------------------+\n| IF(2, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nHowever, the values TRUE and FALSE are merely aliases for 1 and 0,\nrespectively, as shown here:\n\nmysql> SELECT IF(0 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(0 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| true                           |\n+--------------------------------+\n\nmysql> SELECT IF(1 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(1 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| true                          |\n+-------------------------------+\n\nmysql> SELECT IF(2 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(2 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| false                         |\n+-------------------------------+\n\nmysql> SELECT IF(2 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(2 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| false                          |\n+--------------------------------+\n\nThe last two statements display the results shown because 2 is equal to\nneither 1 nor 0.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (73,7,'JSON_EXTRACT','JSON_EXTRACT(json_doc, path[, path] ...)\n\nReturns data from a JSON document, selected from the parts of the\ndocument matched by the path arguments. Returns NULL if any argument is\nNULL or no paths locate a value in the document. An error occurs if the\njson_doc argument is not a valid JSON document or any path argument is\nnot a valid path expression.\n\nThe return value consists of all values matched by the path arguments.\nIf it is possible that those arguments could return multiple values,\nthe matched values are autowrapped as an array, in the order\ncorresponding to the paths that produced them. Otherwise, the return\nvalue is the single matched value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html\n\n','mysql> SELECT JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[1]\');\n+--------------------------------------------+\n| JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[1]\') |\n+--------------------------------------------+\n| 20                                         |\n+--------------------------------------------+\nmysql> SELECT JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[1]\', \'$[0]\');\n+----------------------------------------------------+\n| JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[1]\', \'$[0]\') |\n+----------------------------------------------------+\n| [20, 10]                                           |\n+----------------------------------------------------+\nmysql> SELECT JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[2][*]\');\n+-----------------------------------------------+\n| JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[2][*]\') |\n+-----------------------------------------------+\n| [30, 40]                                      |\n+-----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (74,3,'MOD','Syntax:\nMOD(N,M), N % M, N MOD M\n\nModulo operation. Returns the remainder of N divided by M.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT MOD(234, 10);\n        -> 4\nmysql> SELECT 253 % 7;\n        -> 1\nmysql> SELECT MOD(29,9);\n        -> 2\nmysql> SELECT 29 MOD 9;\n        -> 2\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (75,37,'ST_GEOMETRYTYPE','ST_GeometryType(g)\n\nReturns a binary string indicating the name of the geometry type of\nwhich the geometry instance g is a member. The name corresponds to one\nof the instantiable Geometry subclasses.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','mysql> SELECT ST_GeometryType(ST_GeomFromText(\'POINT(1 1)\'));\n+------------------------------------------------+\n| ST_GeometryType(ST_GeomFromText(\'POINT(1 1)\')) |\n+------------------------------------------------+\n| POINT                                          |\n+------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (76,29,'HELP STATEMENT','Syntax:\nHELP \'search_string\'\n\nThe HELP statement returns online information from the MySQL Reference\nmanual. Its proper operation requires that the help tables in the mysql\ndatabase be initialized with help topic information (see\nhttp://dev.mysql.com/doc/refman/5.7/en/server-side-help-support.html).\n\nThe HELP statement searches the help tables for the given search string\nand displays the result of the search. The search string is not case\nsensitive.\n\nThe search string can contain the wildcard characters "%" and "_".\nThese have the same meaning as for pattern-matching operations\nperformed with the LIKE operator. For example, HELP \'rep%\' returns a\nlist of topics that begin with rep.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/help.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/help.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (77,38,'UCASE','Syntax:\nUCASE(str)\n\nUCASE() is a synonym for UPPER().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (78,27,'SHOW BINLOG EVENTS','Syntax:\nSHOW BINLOG EVENTS\n   [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n\nShows the events in the binary log. If you do not specify \'log_name\',\nthe first binary log is displayed.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-binlog-events.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-binlog-events.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (79,33,'MPOLYFROMWKB','MPolyFromWKB(wkb[,srid]), MultiPolygonFromWKB(wkb[,srid])\n\nST_MPolyFromWKB(), ST_MultiPolygonFromWKB(), MPolyFromWKB(), and\nMultiPolygonFromWKB() are synonyms. For more information, see the\ndescription of ST_MPolyFromWKB().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (80,24,'ITERATE','Syntax:\nITERATE label\n\nITERATE can appear only within LOOP, REPEAT, and WHILE statements.\nITERATE means "start the loop again."\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/iterate.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/iterate.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (81,28,'DO','Syntax:\nDO expr [, expr] ...\n\nDO executes the expressions but does not return any results. In most\nrespects, DO is shorthand for SELECT expr, ..., but has the advantage\nthat it is slightly faster when you do not care about the result.\n\nDO is useful primarily with functions that have side effects, such as\nRELEASE_LOCK().\n\nExample: This SELECT statement pauses, but also produces a result set:\n\nmysql> SELECT SLEEP(5);\n+----------+\n| SLEEP(5) |\n+----------+\n|        0 |\n+----------+\n1 row in set (5.02 sec)\n\nDO, on the other hand, pauses without producing a result set.:\n\nmysql> DO SLEEP(5);\nQuery OK, 0 rows affected (4.99 sec)\n\nThis could be useful, for example in a stored function or trigger,\nwhich prohibit statements that produce result sets.\n\nDO only executes expressions. It cannot be used in all cases where\nSELECT can be used. For example, DO id FROM t1 is invalid because it\nreferences a table.\n\nAs of MySQL 5.7.8, DO statement errors that previously were converted\nto warnings are returned as errors.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/do.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/do.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (82,38,'CHAR_LENGTH','Syntax:\nCHAR_LENGTH(str)\n\nReturns the length of the string str, measured in characters. A\nmultibyte character counts as a single character. This means that for a\nstring containing five 2-byte characters, LENGTH() returns 10, whereas\nCHAR_LENGTH() returns 5.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (83,23,'DATE','DATE\n\nA date. The supported range is \'1000-01-01\' to \'9999-12-31\'. MySQL\ndisplays DATE values in \'YYYY-MM-DD\' format, but permits assignment of\nvalues to DATE columns using either strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (84,33,'ST_ASTEXT','ST_AsText(g), ST_AsWKT(g)\n\nConverts a value in internal geometry format to its WKT representation\nand returns the string result.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-format-conversion-functions.html\n\n','mysql> SET @g = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,2 2,3 3)        |\n+--------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-format-conversion-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (85,7,'JSON_TYPE','JSON_TYPE(json_val)\n\nReturns a utf8mb4 string indicating the type of a JSON value:\n\nmysql> SET @j = \'{"a": [10, true]}\';\nmysql> SELECT JSON_TYPE(@j);\n+---------------+\n| JSON_TYPE(@j) |\n+---------------+\n| OBJECT        |\n+---------------+\nmysql> SELECT JSON_TYPE(JSON_EXTRACT(@j, \'$.a\'));\n+------------------------------------+\n| JSON_TYPE(JSON_EXTRACT(@j, \'$.a\')) |\n+------------------------------------+\n| ARRAY                              |\n+------------------------------------+\nmysql> SELECT JSON_TYPE(JSON_EXTRACT(@j, \'$.a[0]\'));\n+---------------------------------------+\n| JSON_TYPE(JSON_EXTRACT(@j, \'$.a[0]\')) |\n+---------------------------------------+\n| INTEGER                               |\n+---------------------------------------+\nmysql> SELECT JSON_TYPE(JSON_EXTRACT(@j, \'$.a[1]\'));\n+---------------------------------------+\n| JSON_TYPE(JSON_EXTRACT(@j, \'$.a[1]\')) |\n+---------------------------------------+\n| BOOLEAN                               |\n+---------------------------------------+\n\nJSON_TYPE() returns NULL if the argument is NULL:\n\nmysql> SELECT JSON_TYPE(NULL);\n+-----------------+\n| JSON_TYPE(NULL) |\n+-----------------+\n| NULL            |\n+-----------------+\n\nAn error occurs if the argument is not a valid JSON value:\n\nmysql> SELECT JSON_TYPE(1);\nERROR 3146 (22032): Invalid data type for JSON data in argument 1\nto function json_type; a JSON string or JSON type is required.\n\nFor a non-NULL, non-error result, the following list describes the\npossible JSON_TYPE() return values:\n\no Purely JSON types:\n\n  o OBJECT: JSON objects\n\n  o ARRAY: JSON arrays\n\n  o BOOLEAN: The JSON true and false literals\n\n  o NULL: The JSON null literal\n\no Numeric types:\n\n  o INTEGER: MySQL TINYINT, SMALLINT, MEDIUMINT and INT and BIGINT\n    scalars\n\n  o DOUBLE: MySQL DOUBLE FLOAT scalars\n\n  o DECIMAL: MySQL DECIMAL and NUMERIC scalars\n\no Temporal types:\n\n  o DATETIME: MySQL DATETIME and TIMESTAMP scalars\n\n  o DATE: MySQL DATE scalars\n\n  o TIME: MySQL TIME scalars\n\no String types:\n\n  o STRING: MySQL utf8 character type scalars: CHAR, VARCHAR, TEXT,\n    ENUM, and SET\n\no Binary types:\n\n  o BLOB: MySQL binary type scalars: BINARY, VARBINARY, BLOB\n\n  o BIT: MySQL BIT scalars\n\no All other types:\n\n  o OPAQUE (raw bits)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-attribute-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/json-attribute-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (86,38,'EXTRACTVALUE','Syntax:\nExtractValue(xml_frag, xpath_expr)\n\nExtractValue() takes two string arguments, a fragment of XML markup\nxml_frag and an XPath expression xpath_expr (also known as a locator);\nit returns the text (CDATA) of the first text node which is a child of\nthe elements or elements matched by the XPath expression.\n\nUsing this function is the equivalent of performing a match using the\nxpath_expr after appending /text(). In other words,\nExtractValue(\'<a><b>Sakila</b></a>\', \'/a/b\') and\nExtractValue(\'<a><b>Sakila</b></a>\', \'/a/b/text()\') produce the same\nresult.\n\nIf multiple matches are found, the content of the first child text node\nof each matching element is returned (in the order matched) as a\nsingle, space-delimited string.\n\nIf no matching text node is found for the expression (including the\nimplicit /text())---for whatever reason, as long as xpath_expr is\nvalid, and xml_frag consists of elements which are properly nested and\nclosed---an empty string is returned. No distinction is made between a\nmatch on an empty element and no match at all. This is by design.\n\nIf you need to determine whether no matching element was found in\nxml_frag or such an element was found but contained no child text\nnodes, you should test the result of an expression that uses the XPath\ncount() function. For example, both of these statements return an empty\nstring, as shown here:\n\nmysql> SELECT ExtractValue(\'<a><b/></a>\', \'/a/b\');\n+-------------------------------------+\n| ExtractValue(\'<a><b/></a>\', \'/a/b\') |\n+-------------------------------------+\n|                                     |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT ExtractValue(\'<a><c/></a>\', \'/a/b\');\n+-------------------------------------+\n| ExtractValue(\'<a><c/></a>\', \'/a/b\') |\n+-------------------------------------+\n|                                     |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nHowever, you can determine whether there was actually a matching\nelement using the following:\n\nmysql> SELECT ExtractValue(\'<a><b/></a>\', \'count(/a/b)\');\n+-------------------------------------+\n| ExtractValue(\'<a><b/></a>\', \'count(/a/b)\') |\n+-------------------------------------+\n| 1                                   |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT ExtractValue(\'<a><c/></a>\', \'count(/a/b)\');\n+-------------------------------------+\n| ExtractValue(\'<a><c/></a>\', \'count(/a/b)\') |\n+-------------------------------------+\n| 0                                   |\n+-------------------------------------+\n1 row in set (0.01 sec)\n\n*Important*: ExtractValue() returns only CDATA, and does not return any\ntags that might be contained within a matching tag, nor any of their\ncontent (see the result returned as val1 in the following example).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/xml-functions.html\n\n','mysql> SELECT\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/a\') AS val1,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/a/b\') AS val2,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'//b\') AS val3,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/b\') AS val4,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b><b>eee</b></a>\', \'//b\') AS val5;\n\n+------+------+------+------+---------+\n| val1 | val2 | val3 | val4 | val5    |\n+------+------+------+------+---------+\n| ccc  | ddd  | ddd  |      | ddd eee |\n+------+------+------+------+---------+\n','http://dev.mysql.com/doc/refman/5.7/en/xml-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (87,12,'OLD_PASSWORD','Syntax:\nOLD_PASSWORD(str)\n\nOLD_PASSWORD() was added when the implementation of PASSWORD() was\nchanged in MySQL 4.1 to improve security. OLD_PASSWORD() returns the\nvalue of the pre-4.1 implementation of PASSWORD() as a string, and is\nintended to permit you to reset passwords for any pre-4.1 clients that\nneed to connect to your version MySQL 5.7 server without locking them\nout. See http://dev.mysql.com/doc/refman/5.7/en/password-hashing.html.\n\nThe return value is a nonbinary string in the connection character set.\n\n*Note*: Passwords that use the pre-4.1 hashing method are less secure\nthan passwords that use the native password hashing method and should\nbe avoided. Pre-4.1 passwords are deprecated and support for them is\nremoved in MySQL 5.7.5. Consequently, OLD_PASSWORD() is deprecated and\nis removed in MySQL 5.7.5.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (88,38,'FORMAT','Syntax:\nFORMAT(X,D[,locale])\n\nFormats the number X to a format like \'#,###,###.##\', rounded to D\ndecimal places, and returns the result as a string. If D is 0, the\nresult has no decimal point or fractional part.\n\nThe optional third parameter enables a locale to be specified to be\nused for the result number\'s decimal point, thousands separator, and\ngrouping between separators. Permissible locale values are the same as\nthe legal values for the lc_time_names system variable (see\nhttp://dev.mysql.com/doc/refman/5.7/en/locale-support.html). If no\nlocale is specified, the default is \'en_US\'.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT FORMAT(12332.123456, 4);\n        -> \'12,332.1235\'\nmysql> SELECT FORMAT(12332.1,4);\n        -> \'12,332.1000\'\nmysql> SELECT FORMAT(12332.2,0);\n        -> \'12,332\'\nmysql> SELECT FORMAT(12332.2,2,\'de_DE\');\n        -> \'12.332,20\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (89,38,'BIT_LENGTH','Syntax:\nBIT_LENGTH(str)\n\nReturns the length of the string str in bits.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT BIT_LENGTH(\'text\');\n        -> 32\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (90,2,'EXTERIORRING','ExteriorRing(poly)\n\nST_ExteriorRing() and ExteriorRing() are synonyms. For more\ninformation, see the description of ST_ExteriorRing().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (91,33,'GEOMFROMWKB','GeomFromWKB(wkb[,srid]), GeometryFromWKB(wkb[,srid])\n\nST_GeomFromWKB(), ST_GeometryFromWKB(), GeomFromWKB(), and\nGeometryFromWKB() are synonyms. For more information, see the\ndescription of ST_GeomFromWKB().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (92,20,'BETWEEN AND','Syntax:\nexpr BETWEEN min AND max\n\nIf expr is greater than or equal to min and expr is less than or equal\nto max, BETWEEN returns 1, otherwise it returns 0. This is equivalent\nto the expression (min <= expr AND expr <= max) if all the arguments\nare of the same type. Otherwise type conversion takes place according\nto the rules described in\nhttp://dev.mysql.com/doc/refman/5.7/en/type-conversion.html, but\napplied to all the three arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 2 BETWEEN 1 AND 3, 2 BETWEEN 3 and 1;\n        -> 1, 0\nmysql> SELECT 1 BETWEEN 2 AND 3;\n        -> 0\nmysql> SELECT \'b\' BETWEEN \'a\' AND \'c\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'3\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'x-3\';\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (93,25,'MULTIPOLYGON','MultiPolygon(poly1,poly2,...)\n\nConstructs a MultiPolygon value from a set of Polygon or WKB Polygon\narguments.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (94,38,'LEFT','Syntax:\nLEFT(str,len)\n\nReturns the leftmost len characters from the string str, or NULL if any\nargument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT LEFT(\'foobarbar\', 5);\n        -> \'fooba\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (95,13,'ST_ISCLOSED','ST_IsClosed(ls)\n\nFor a LineString value ls, ST_IsClosed() returns 1 if ls is closed\n(that is, its ST_StartPoint() and ST_EndPoint() values are the same).\n\nFor a MultiLineString value ls, ST_IsClosed() returns 1 if ls is closed\n(that is, the ST_StartPoint() and ST_EndPoint() values are the same for\neach LineString in ls).\n\nST_IsClosed() returns 0 if ls is not closed, and NULL if ls is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls1 = \'LineString(1 1,2 2,3 3,2 2)\';\nmysql> SET @ls2 = \'LineString(1 1,2 2,3 3,1 1)\';\n\nmysql> SELECT ST_IsClosed(ST_GeomFromText(@ls1));\n+------------------------------------+\n| ST_IsClosed(ST_GeomFromText(@ls1)) |\n+------------------------------------+\n|                                  0 |\n+------------------------------------+\n\nmysql> SELECT ST_IsClosed(ST_GeomFromText(@ls2));\n+------------------------------------+\n| ST_IsClosed(ST_GeomFromText(@ls2)) |\n+------------------------------------+\n|                                  1 |\n+------------------------------------+\n\nmysql> SET @ls3 = \'MultiLineString((1 1,2 2,3 3),(4 4,5 5))\';\n\nmysql> SELECT ST_IsClosed(ST_GeomFromText(@ls3));\n+------------------------------------+\n| ST_IsClosed(ST_GeomFromText(@ls3)) |\n+------------------------------------+\n|                                  0 |\n+------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (96,27,'FLUSH QUERY CACHE','You can defragment the query cache to better utilize its memory with\nthe FLUSH QUERY CACHE statement. The statement does not remove any\nqueries from the cache.\n\nThe RESET QUERY CACHE statement removes all query results from the\nquery cache. The FLUSH TABLES statement also does this.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/query-cache-status-and-maintenance.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/query-cache-status-and-maintenance.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (97,23,'SET DATA TYPE','SET(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA set. A string object that can have zero or more values, each of which\nmust be chosen from the list of values \'value1\', \'value2\', ... SET\nvalues are represented internally as integers.\n\nA SET column can have a maximum of 64 distinct members. A table can\nhave no more than 255 unique element list definitions among its ENUM\nand SET columns considered as a group. For more information on this\nlimit, see http://dev.mysql.com/doc/refman/5.7/en/limits-frm-file.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (98,3,'RAND','Syntax:\nRAND(), RAND(N)\n\nReturns a random floating-point value v in the range 0 <= v < 1.0. If a\nconstant integer argument N is specified, it is used as the seed value,\nwhich produces a repeatable sequence of column values. In the following\nexample, note that the sequences of values produced by RAND(3) is the\nsame both places where it occurs.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> CREATE TABLE t (i INT);\nQuery OK, 0 rows affected (0.42 sec)\n\nmysql> INSERT INTO t VALUES(1),(2),(3);\nQuery OK, 3 rows affected (0.00 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nmysql> SELECT i, RAND() FROM t;\n+------+------------------+\n| i    | RAND()           |\n+------+------------------+\n|    1 | 0.61914388706828 |\n|    2 | 0.93845168309142 |\n|    3 | 0.83482678498591 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND(3) FROM t;\n+------+------------------+\n| i    | RAND(3)          |\n+------+------------------+\n|    1 | 0.90576975597606 |\n|    2 | 0.37307905813035 |\n|    3 | 0.14808605345719 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND() FROM t;\n+------+------------------+\n| i    | RAND()           |\n+------+------------------+\n|    1 | 0.35877890638893 |\n|    2 | 0.28941420772058 |\n|    3 | 0.37073435016976 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND(3) FROM t;\n+------+------------------+\n| i    | RAND(3)          |\n+------+------------------+\n|    1 | 0.90576975597606 |\n|    2 | 0.37307905813035 |\n|    3 | 0.14808605345719 |\n+------+------------------+\n3 rows in set (0.01 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (99,38,'RPAD','Syntax:\nRPAD(str,len,padstr)\n\nReturns the string str, right-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT RPAD(\'hi\',5,\'?\');\n        -> \'hi???\'\nmysql> SELECT RPAD(\'hi\',1,\'?\');\n        -> \'h\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (100,23,'DEC','DEC[(M[,D])] [UNSIGNED] [ZEROFILL], NUMERIC[(M[,D])] [UNSIGNED]\n[ZEROFILL], FIXED[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nThese types are synonyms for DECIMAL. The FIXED synonym is available\nfor compatibility with other database systems.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (101,38,'ELT','Syntax:\nELT(N,str1,str2,str3,...)\n\nELT() returns the Nth element of the list of strings: str1 if N = 1,\nstr2 if N = 2, and so on. Returns NULL if N is less than 1 or greater\nthan the number of arguments. ELT() is the complement of FIELD().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT ELT(1, \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> \'ej\'\nmysql> SELECT ELT(4, \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> \'foo\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (102,7,'ST_LONGFROMGEOHASH','ST_LongFromGeoHash(geohash_str)\n\nReturns the longitude from a geohash string value, as a DOUBLE value in\nthe range [−180, 180]. The result is NULL if any argument is NULL. An\nerror occurs if the argument is invalid.\n\nThe remarks in the description of ST_LatFromGeoHash() regarding the\nmaximum number of characters processed from the geohash_str argument\nalso apply to ST_LongFromGeoHash().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-geohash-functions.html\n\n','mysql> SELECT ST_LongFromGeoHash(ST_GeoHash(45,-20,10));\n+-------------------------------------------+\n| ST_LongFromGeoHash(ST_GeoHash(45,-20,10)) |\n+-------------------------------------------+\n|                                        45 |\n+-------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-geohash-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (103,40,'ALTER VIEW','Syntax:\nALTER\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n    [DEFINER = { user | CURRENT_USER }]\n    [SQL SECURITY { DEFINER | INVOKER }]\n    VIEW view_name [(column_list)]\n    AS select_statement\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nThis statement changes the definition of a view, which must exist. The\nsyntax is similar to that for CREATE VIEW and the effect is the same as\nfor CREATE OR REPLACE VIEW. See [HELP CREATE VIEW]. This statement\nrequires the CREATE VIEW and DROP privileges for the view, and some\nprivilege for each column referred to in the SELECT statement. ALTER\nVIEW is permitted only to the definer or users with the SUPER\nprivilege.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-view.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/alter-view.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (104,27,'SHOW DATABASES','Syntax:\nSHOW {DATABASES | SCHEMAS}\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW DATABASES lists the databases on the MySQL server host. SHOW\nSCHEMAS is a synonym for SHOW DATABASES. The LIKE clause, if present,\nindicates which database names to match. The WHERE clause can be given\nto select rows using more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nYou see only those databases for which you have some kind of privilege,\nunless you have the global SHOW DATABASES privilege. You can also get\nthis list using the mysqlshow command.\n\nIf the server was started with the --skip-show-database option, you\ncannot use this statement at all unless you have the SHOW DATABASES\nprivilege.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-databases.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-databases.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (105,32,'SEC_TO_TIME','Syntax:\nSEC_TO_TIME(seconds)\n\nReturns the seconds argument, converted to hours, minutes, and seconds,\nas a TIME value. The range of the result is constrained to that of the\nTIME data type. A warning occurs if the argument corresponds to a value\noutside that range.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT SEC_TO_TIME(2378);\n        -> \'00:39:38\'\nmysql> SELECT SEC_TO_TIME(2378) + 0;\n        -> 3938\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (106,38,'LOCATE','Syntax:\nLOCATE(substr,str), LOCATE(substr,str,pos)\n\nThe first syntax returns the position of the first occurrence of\nsubstring substr in string str. The second syntax returns the position\nof the first occurrence of substring substr in string str, starting at\nposition pos. Returns 0 if substr is not in str.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT LOCATE(\'bar\', \'foobarbar\');\n        -> 4\nmysql> SELECT LOCATE(\'xbar\', \'foobar\');\n        -> 0\nmysql> SELECT LOCATE(\'bar\', \'foobarbar\', 5);\n        -> 7\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (107,27,'SHOW EVENTS','Syntax:\nSHOW EVENTS [{FROM | IN} schema_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement displays information about Event Manager events. It\nrequires the EVENT privilege for the database from which the events are\nto be shown.\n\nIn its simplest form, SHOW EVENTS lists all of the events in the\ncurrent schema:\n\nmysql> SELECT CURRENT_USER(), SCHEMA();\n+----------------+----------+\n| CURRENT_USER() | SCHEMA() |\n+----------------+----------+\n| jon@ghidora    | myschema |\n+----------------+----------+\n1 row in set (0.00 sec)\n\nmysql> SHOW EVENTS\\G\n*************************** 1. row ***************************\n                  Db: myschema\n                Name: e_daily\n             Definer: jon@ghidora\n           Time zone: SYSTEM\n                Type: RECURRING\n          Execute at: NULL\n      Interval value: 10\n      Interval field: SECOND\n              Starts: 2006-02-09 10:41:23\n                Ends: NULL\n              Status: ENABLED\n          Originator: 0\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n\nTo see events for a specific schema, use the FROM clause. For example,\nto see events for the test schema, use the following statement:\n\nSHOW EVENTS FROM test;\n\nThe LIKE clause, if present, indicates which event names to match. The\nWHERE clause can be given to select rows using more general conditions,\nas discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-events.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-events.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (108,7,'JSON_INSERT','JSON_INSERT(json_doc, path, val[, path, val] ...)\n\nInserts data into a JSON document and returns the result. Returns NULL\nif any argument is NULL. An error occurs if the json_doc argument is\nnot a valid JSON document or any path argument is not a valid path\nexpression or contains a * or ** wildcard.\n\nThe path/value pairs are evaluated left to right. The document produced\nby evaluating one pair becomes the new value against which the next\npair is evaluated.\n\nA path/value pair for an existing path in the document is ignored and\ndoes not overwrite the existing document value. A path/value pair for a\nnonexisting path in the document adds the value to the document if the\npath identifies one of these types of values:\n\no A member not present in an existing object. The member is added to\n  the object and associated with the new value.\n\no A position past the end of an existing array. The array is extended\n  with the new value. If the existing value is not an array, it is\n  autowrapped as an array, then extended with the new value.\n\nOtherwise, a path/value pair for a nonexisting path in the document is\nignored and has no effect.\n\nFor a comparison of JSON_INSERT(), JSON_REPLACE(), and JSON_SET(), see\nthe discussion of JSON_SET().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html\n\n','mysql> SET @j = \'{ "a": 1, "b": [2, 3]}\';\nmysql> SELECT JSON_INSERT(@j, \'$.a\', 10, \'$.c\', \'[true, false]\');\n+----------------------------------------------------+\n| JSON_INSERT(@j, \'$.a\', 10, \'$.c\', \'[true, false]\') |\n+----------------------------------------------------+\n| {"a": 1, "b": [2, 3], "c": "[true, false]"}        |\n+----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (109,7,'JSON_UNQUOTE','JSON_UNQUOTE(val)\n\nUnquotes JSON value and returns the result as a utf8mb4 string. Returns\nNULL if the argument is NULL. An error occurs if the value starts and\nends with double quotes but is not a valid JSON string literal.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html\n\n','mysql> SET @j = \'"abc"\';\nmysql> SELECT @j, JSON_UNQUOTE(@j);\n+-------+------------------+\n| @j    | JSON_UNQUOTE(@j) |\n+-------+------------------+\n| "abc" | abc              |\n+-------+------------------+\nmysql> SET @j = \'[1, 2, 3]\';\nmysql> SELECT @j, JSON_UNQUOTE(@j);\n+-----------+------------------+\n| @j        | JSON_UNQUOTE(@j) |\n+-----------+------------------+\n| [1, 2, 3] | [1, 2, 3]        |\n+-----------+------------------+\n\nmysql> SELECT @@sql_mode;\n+------------+\n| @@sql_mode |\n+------------+\n|            |\n+------------+\n\nmysql> SELECT JSON_UNQUOTE(\'"\\\\t\\\\u0032"\');\n+------------------------------+\n| JSON_UNQUOTE(\'"\\\\t\\\\u0032"\') |\n+------------------------------+\n|       2                           |\n+------------------------------+\n\nmysql> SET @@sql_mode = \'NO_BACKSLASH_ESCAPES\';\nmysql> SELECT JSON_UNQUOTE(\'"\\\\t\\\\u0032"\');\n+------------------------------+\n| JSON_UNQUOTE(\'"\\\\t\\\\u0032"\') |\n+------------------------------+\n| \\t\\u0032                     |\n+------------------------------+\n\nmysql> SELECT JSON_UNQUOTE(\'"\\t\\u0032"\');\n+----------------------------+\n| JSON_UNQUOTE(\'"\\t\\u0032"\') |\n+----------------------------+\n|       2                         |\n+----------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (110,23,'LONGTEXT','LONGTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 4,294,967,295 or 4GB (232 − 1)\ncharacters. The effective maximum length is less if the value contains\nmultibyte characters. The effective maximum length of LONGTEXT columns\nalso depends on the configured maximum packet size in the client/server\nprotocol and available memory. Each LONGTEXT value is stored using a\n4-byte length prefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (111,27,'KILL','Syntax:\nKILL [CONNECTION | QUERY] processlist_id\n\nEach connection to mysqld runs in a separate thread. You can kill a\nthread with the KILL processlist_id statement.\n\nThread processlist identifiers can be determined from the ID column of\nthe INFORMATION_SCHEMA.PROCESSLIST table, the Id column of SHOW\nPROCESSLIST output, and the PROCESSLIST_ID column of the Performance\nSchema threads table. The value for the current thread is returned by\nthe CONNECTION_ID() function.\n\nKILL permits an optional CONNECTION or QUERY modifier:\n\no KILL CONNECTION is the same as KILL with no modifier: It terminates\n  the connection associated with the given processlist_id, after\n  terminating any statement the connection is executing.\n\no KILL QUERY terminates the statement the connection is currently\n  executing, but leaves the connection itself intact.\n\nIf you have the PROCESS privilege, you can see all threads. If you have\nthe SUPER privilege, you can kill all threads and statements.\nOtherwise, you can see and kill only your own threads and statements.\n\nYou can also use the mysqladmin processlist and mysqladmin kill\ncommands to examine and kill threads.\n\n*Note*: You cannot use KILL with the Embedded MySQL Server library\nbecause the embedded server merely runs inside the threads of the host\napplication. It does not create any connection threads of its own.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/kill.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/kill.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (112,31,'DISJOINT','Disjoint(g1,g2)\n\nMBRDisjoint() and Disjoint() are synonyms. For more information, see\nthe description of MBRDisjoint().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (113,38,'LPAD','Syntax:\nLPAD(str,len,padstr)\n\nReturns the string str, left-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT LPAD(\'hi\',4,\'??\');\n        -> \'??hi\'\nmysql> SELECT LPAD(\'hi\',1,\'??\');\n        -> \'h\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (114,31,'OVERLAPS','Overlaps(g1,g2)\n\nMBROverlaps() and Overlaps() are synonyms. For more information, see\nthe description of MBROverlaps().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (115,8,'SET GLOBAL SQL_SLAVE_SKIP_COUNTER','Syntax:\nSET GLOBAL sql_slave_skip_counter = N\n\nThis statement skips the next N events from the master. This is useful\nfor recovering from replication stops caused by a statement.\n\nThis statement is valid only when the slave threads are not running.\nOtherwise, it produces an error.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/set-global-sql-slave-skip-counter.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/set-global-sql-slave-skip-counter.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (116,7,'MBREQUAL','MBREqual(g1,g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\nthe two geometries g1 and g2 are the same.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (117,34,'PROCEDURE ANALYSE','Syntax:\nANALYSE([max_elements[,max_memory]])\n\nANALYSE() examines the result from a query and returns an analysis of\nthe results that suggests optimal data types for each column that may\nhelp reduce table sizes. To obtain this analysis, append PROCEDURE\nANALYSE to the end of a SELECT statement:\n\nSELECT ... FROM ... WHERE ... PROCEDURE ANALYSE([max_elements,[max_memory]])\n\nFor example:\n\nSELECT col1, col2 FROM table1 PROCEDURE ANALYSE(10, 2000);\n\nThe results show some statistics for the values returned by the query,\nand propose an optimal data type for the columns. This can be helpful\nfor checking your existing tables, or after importing new data. You may\nneed to try different settings for the arguments so that PROCEDURE\nANALYSE() does not suggest the ENUM data type when it is not\nappropriate.\n\nThe arguments are optional and are used as follows:\n\no max_elements (default 256) is the maximum number of distinct values\n  that ANALYSE() notices per column. This is used by ANALYSE() to check\n  whether the optimal data type should be of type ENUM; if there are\n  more than max_elements distinct values, then ENUM is not a suggested\n  type.\n\no max_memory (default 8192) is the maximum amount of memory that\n  ANALYSE() should allocate per column while trying to find all\n  distinct values.\n\nA PROCEDURE clause is not permitted in a UNION statement.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/procedure-analyse.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/procedure-analyse.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (118,9,'HELP_VERSION','This help information was generated from the MySQL 5.7 Reference Manual\non: 2016-05-25 (revision: 47824)\n\nThis information applies to MySQL 5.7 through 5.7.14.\n','','');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (119,38,'CHARACTER_LENGTH','Syntax:\nCHARACTER_LENGTH(str)\n\nCHARACTER_LENGTH() is a synonym for CHAR_LENGTH().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (120,27,'SHOW PRIVILEGES','Syntax:\nSHOW PRIVILEGES\n\nSHOW PRIVILEGES shows the list of system privileges that the MySQL\nserver supports. The exact list of privileges depends on the version of\nyour server.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-privileges.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-privileges.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (121,40,'CREATE TABLESPACE','Syntax:\nCREATE TABLESPACE tablespace_name\n\n  InnoDB and NDB:\n    ADD DATAFILE \'file_name\'\n\n  InnoDB only:\n    [FILE_BLOCK_SIZE = value]\n\n  NDB only:\n    USE LOGFILE GROUP logfile_group\n    [EXTENT_SIZE [=] extent_size]\n    [INITIAL_SIZE [=] initial_size]\n    [AUTOEXTEND_SIZE [=] autoextend_size]\n    [MAX_SIZE [=] max_size]\n    [NODEGROUP [=] nodegroup_id]\n    [WAIT]\n    [COMMENT [=] comment_text]\n\n  InnoDB and NDB:\n    [ENGINE [=] engine_name]\n\nThis statement is used to create a tablespace. The precise syntax and\nsemantics depend on the storage engine used. In standard MySQL 5.7\nreleases, this is always an InnoDB tablespace. MySQL Cluster NDB 7.5\nalso supports tablespaces using the NDB storage engine in addition to\nthose using InnoDB.\n\nConsiderations for InnoDB\n\nAn InnoDB tablespace created using CREATE TABLESPACE is referred to as\na general tablespace. This is a shared tablespace, similar to the\nsystem tablespace. It can hold multiple tables, and supports all table\nrow formats. General tablespaces can be created in a location relative\nto or independent of the MySQL data directory.\n\nAfter creating an InnoDB general tablespace, you can use CREATE TABLE\ntbl_name ... TABLESPACE [=] tablespace_name or ALTER TABLE tbl_name\nTABLESPACE [=] tablespace_name to add tables to the tablespace.\n\nFor more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/general-tablespaces.html.\n\nCREATE TABLESPACE is supported with InnoDB as of MySQL 5.7.6.\n\nConsiderations for MySQL Cluster (NDB)\n\nThis statement is used to create a tablespace, which can contain one or\nmore data files, providing storage space for MySQL Cluster Disk Data\ntables (see\nhttp://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-disk-data.html).\nOne data file is created and added to the tablespace using this\nstatement. Additional data files may be added to the tablespace by\nusing the ALTER TABLESPACE statement (see [HELP ALTER TABLESPACE]).\n\n*Note*: All MySQL Cluster Disk Data objects share the same namespace.\nThis means that each Disk Data object must be uniquely named (and not\nmerely each Disk Data object of a given type). For example, you cannot\nhave a tablespace and a log file group with the same name, or a\ntablespace and a data file with the same name.\n\nA log file group of one or more UNDO log files must be assigned to the\ntablespace to be created with the USE LOGFILE GROUP clause.\nlogfile_group must be an existing log file group created with CREATE\nLOGFILE GROUP (see [HELP CREATE LOGFILE GROUP]). Multiple tablespaces\nmay use the same log file group for UNDO logging.\n\nWhen setting EXTENT_SIZE or INITIAL_SIZE, you may optionally follow the\nnumber with a one-letter abbreviation for an order of magnitude,\nsimilar to those used in my.cnf. Generally, this is one of the letters\nM (for megabytes) or G (for gigabytes).\n\nINITIAL_SIZE and EXTENT_SIZE are subject to rounding as follows:\n\no EXTENT_SIZE is rounded up to the nearest whole multiple of 32K.\n\no INITIAL_SIZE is rounded down to the nearest whole multiple of 32K;\n  this result is rounded up to the nearest whole multiple of\n  EXTENT_SIZE (after any rounding).\n\nThe rounding just described is done explicitly, and a warning is issued\nby the MySQL Server when any such rounding is performed. The rounded\nvalues are also used by the NDB kernel for calculating\nINFORMATION_SCHEMA.FILES column values and other purposes. However, to\navoid an unexpected result, we suggest that you always use whole\nmultiples of 32K in specifying these options.\n\nWhen CREATE TABLESPACE is used with ENGINE [=] NDB, a tablespace and\nassociated data file are created on each Cluster data node. You can\nverify that the data files were created and obtain information about\nthem by querying the INFORMATION_SCHEMA.FILES table. (See the example\nlater in this section.)\n\n(See http://dev.mysql.com/doc/refman/5.7/en/files-table.html.)\n\nOptions\n\no ADD DATAFILE: Defines the name of a tablespace data file; this option\n  is always required. An InnoDB tablespace supports only a single data\n  file, whose name must include a .ibd extension. A MySQL Cluster\n  tablespace supports multiple data files which can have any legal file\n  names; more data files can be added to a MySQL Cluster tablespace\n  following its creation by using an ALTER TABLESPACE statement.\n\n  *Note*: ALTER TABLESPACE is not supported by InnoDB.\n\n  To place the data file in a location outside of the MySQL data\n  directory (datadir), include an absolute directory path or a path\n  relative to the MySQL data directory. If you do not specify a path,\n  the tablespace is created in the MySQL data directory. As of MySQL\n  5.7.8, an isl file is created in the MySQL data directory when an\n  InnoDB tablespace is created outside of the MySQL data directory.\n\n  To avoid conflicts with implicitly created file-per-table\n  tablespaces, creating a general tablespace in a subdirectory under\n  the MySQL data directory is not supported. Also, when creating a\n  general tablespace outside of the MySQL data directory, the directory\n  must exist prior to creating the tablespace.\n\n  The file_name, including the path (optional), must be quoted with\n  single or double quotations marks. File names (not counting any\n  ".ibd" extension for InnoDB files) and directory names must be at\n  least one byte in length. Zero length file names and directory names\n  are not supported.\n\no FILE_BLOCK_SIZE: This option---which is specific to InnoDB, and is\n  ignored by NDB---defines the block size for the tablespace data file.\n  If you do not specify this option, FILE_BLOCK_SIZE defaults to\n  innodb_page_size. FILE_BLOCK_SIZE is required when you intend to use\n  the tablespace for storing compressed InnoDB tables\n  (ROW_FORMAT=COMPRESSED).\n\n  If FILE_BLOCK_SIZE is equal innodb_page_size, the tablespace can\n  contain only tables having an uncompressed row format (COMPACT,\n  REDUNDANT, or DYNAMIC). The physical page size for tables using\n  COMPRESSED differs from that of uncompressed tables; this means that\n  compressed tables and uncompressed tables cannot coexist in the same\n  tablespace.\n\n  For a general tablespace to contain compressed tables,\n  FILE_BLOCK_SIZE must be specified, and the FILE_BLOCK_SIZE value must\n  be a valid compressed page size in relation to the innodb_page_size\n  value. Also, the physical page size of the compressed table\n  (KEY_BLOCK_SIZE) must be equal to FILE_BLOCK_SIZE/1024. For example,\n  if innodb_page_size=16K, and FILE_BLOCK_SIZE=8K, the KEY_BLOCK_SIZE\n  of the table must be 8. For more information, see\n  http://dev.mysql.com/doc/refman/5.7/en/general-tablespaces.html.\n\no USE LOGFILE GROUP: Required for NDB, this is the name of a log file\n  group previously created using CREATE LOGFILE GROUP. Not supported\n  for InnoDB, where it fails with an error.\n\no EXTENT_SIZE: This option is specific to NDB, and is not supported by\n  InnoDB, where it fails with an error. EXTENT_SIZE sets the size, in\n  bytes, of the extents used by any files belonging to the tablespace.\n  The default value is 1M. The minimum size is 32K, and theoretical\n  maximum is 2G, although the practical maximum size depends on a\n  number of factors. In most cases, changing the extent size does not\n  have any measurable effect on performance, and the default value is\n  recommended for all but the most unusual situations.\n\n  An extent is a unit of disk space allocation. One extent is filled\n  with as much data as that extent can contain before another extent is\n  used. In theory, up to 65,535 (64K) extents may used per data file;\n  however, the recommended maximum is 32,768 (32K). The recommended\n  maximum size for a single data file is 32G---that is, 32K extents x 1\n  MB per extent. In addition, once an extent is allocated to a given\n  partition, it cannot be used to store data from a different\n  partition; an extent cannot store data from more than one partition.\n  This means, for example that a tablespace having a single datafile\n  whose INITIAL_SIZE (described in the following item) is 256 MB and\n  whose EXTENT_SIZE is 128M has just two extents, and so can be used to\n  store data from at most two different disk data table partitions.\n\n  You can see how many extents remain free in a given data file by\n  querying the INFORMATION_SCHEMA.FILES table, and so derive an\n  estimate for how much space remains free in the file. For further\n  discussion and examples, see\n  http://dev.mysql.com/doc/refman/5.7/en/files-table.html.\n\no INITIAL_SIZE: This option is specific to NDB, and is not supported by\n  InnoDB, where it fails with an error.\n\n  The INITIAL_SIZE parameter sets the total size in bytes of the data\n  file that was specific using ADD DATATFILE. Once this file has been\n  created, its size cannot be changed; however, you can add more data\n  files to the tablespace using ALTER TABLESPACE ... ADD DATAFILE.\n\n  INITIAL_SIZE is optional; its default value is 134217728 (128 MB).\n\n  On 32-bit systems, the maximum supported value for INITIAL_SIZE is\n  4294967296 (4 GB).\n\no AUTOEXTEND_SIZE: Currently ignored by MySQL; reserved for possible\n  future use. Has no effect in any release of MySQL 5.7 or MySQL\n  Cluster NDB 7.5, regardless of the storage engine used.\n\no MAX_SIZE: Currently ignored by MySQL; reserved for possible future\n  use. Has no effect in any release of MySQL 5.7 or MySQL Cluster NDB\n  7.5, regardless of the storage engine used.\n\no NODEGROUP: Currently ignored by MySQL; reserved for possible future\n  use. Has no effect in any release of MySQL 5.7 or MySQL Cluster NDB\n  7.5, regardless of the storage engine used.\n\no WAIT: Currently ignored by MySQL; reserved for possible future use.\n  Has no effect in any release of MySQL 5.7 or MySQL Cluster NDB 7.5,\n  regardless of the storage engine used.\n\no COMMENT: Currently ignored by MySQL; reserved for possible future\n  use. Has no effect in any release of MySQL 5.7 or MySQL Cluster NDB\n  7.5, regardless of the storage engine used.\n\no ENGINE: Defines the storage engine which uses the tablespace, where\n  engine_name is the name of the storage engine. Currently, only the\n  InnoDB storage engine is supported by standard MySQL 5.7 releases.\n  MySQL Cluster NDB 7.5 supports both NDB and InnoDB tablespaces. The\n  value of the default_storage_engine system variable is used for\n  ENGINE if the option is not specified.\n\nNotes\n\no For the rules covering the naming of MySQL tablespaces, see\n  http://dev.mysql.com/doc/refman/5.7/en/identifiers.html. In addition\n  to these rules, the slash character ("/") is not permitted, nor can\n  you use names beginning with innodb_, as this prefix is reserved for\n  system use.\n\no Tablespaces do not support temporary tables.\n\no As of MySQL 5.7.8, the TABLESPACE option may be used with CREATE\n  TABLE or ALTER TABLE to assign InnoDB table partitions or\n  subpartitions to a general tablespace, a separate file-per-table\n  tablespace, or the system tablespace. TABLESPACE option support for\n  table partitions and subpartitions was added in MySQL 5.7.8. All\n  partitions must belong to the same storage engine. For more\n  information, see\n  http://dev.mysql.com/doc/refman/5.7/en/general-tablespaces.html.\n\no innodb_file_per_table, innodb_file_format, and innodb_file_format_max\n  settings have no influence on CREATE TABLESPACE operations.\n  innodb_file_per_table does not need to be enabled. General\n  tablespaces support all table row formats regardless of file format\n  settings. Likewise, general tablespaces support the addition of\n  tables of any row format using CREATE TABLE ... TABLESPACE,\n  regardless of file format settings.\n\no innodb_strict_mode is not applicable to general tablespaces.\n  Tablespace management rules are strictly enforced independently of\n  innodb_strict_mode. If CREATE TABLESPACE parameters are incorrect or\n  incompatible, the operation fails regardless of the\n  innodb_strict_mode setting. When a table is added to a general\n  tablespace using CREATE TABLE ... TABLESPACE or ALTER TABLE ...\n  TABLESPACE, innodb_strict_mode is ignored but the statement is\n  evaluated as if innodb_strict_mode is enabled.\n\no Use DROP TABLESPACE to remove a tablespace. All tables must be\n  dropped from a tablespace using DROP TABLE prior to dropping the\n  tablespace. Before dropping a MySQL Cluster tablespace you must also\n  remove all its data files using one or more ALTER TABLESPACE ... DROP\n  DATATFILE statements. See\n  http://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-disk-data-object\n  s.html.\n\no All parts of an InnoDB table added to an InnoDB general tablespace\n  reside in the general tablespace, including indexes and BLOB pages.\n\n  For an NDB table assigned to a tablespace, only those columns which\n  are not indexed are stored on disk, and actually use the tablespace\n  data files. Indexes and indexed columns for all NDB tables are always\n  kept in memory.\n\no Similar to the system tablespace, truncating or dropping tables\n  stored in a general tablespace creates free space internally in the\n  general tablespace .ibd data file which can only be used for new\n  InnoDB data. Space is not released back to the operating system as it\n  is for file-per-table tablespaces.\n\no A general tablespace is not associated with any database or schema.\n\no ALTER TABLE ... DISCARD TABLESPACE and ALTER TABLE ...IMPORT\n  TABLESPACE are not supported for tables that belong to a general\n  tablespace.\n\no The server uses tablespace-level metadata locking for DDL that\n  references general tablespaces. By comparison, the server uses\n  table-level metadata locking for DDL that references file-per-table\n  tablespaces.\n\no A generated or existing tablespace cannot be changed to a general\n  tablespace.\n\no Tables stored in a general tablespace can only be opened in MySQL\n  5.7.6 or later due to the addition of new table flags.\n\no There is no conflict between general tablespace names and\n  file-per-table tablespace names. The "/" character, which is present\n  in file-per-table tablespace names, is not permitted in general\n  tablespace names.\n\no General tablespaces created on Windows using a relative data file\n  path cannot be opened on Unix-like systems. This limitation is\n  removed in MySQL 5.7.8 (Bug #20555168).\n\no In MySQL 5.7.6 and MySQL 5.7.7, tables stored in general tablespaces\n  may not open (due to a missing general tablespace file) after moving\n  the MySQL data directory to a new location. This limitation is\n  addressed in MySQL 5.7.8 with the introduction of isl files for\n  general tablespaces created outside of the MySQL data directory (Bug\n  #20563954).\n\nInnoDB Examples\n\nThis example demonstrates creating a general tablespace and adding\nthree uncompressed tables of different row formats.\n\nmysql> CREATE TABLESPACE `ts1` \n    ->     ADD DATAFILE \'ts1.ibd\' \n    ->     ENGINE=INNODB;\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> CREATE TABLE t1 (c1 INT PRIMARY KEY) \n    ->     TABLESPACE ts1 \n    ->     ROW_FORMAT=REDUNDANT;\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CREATE TABLE t2 (c1 INT PRIMARY KEY) \n    ->     TABLESPACE ts1 \n    ->     ROW_FORMAT=COMPACT;\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CREATE TABLE t3 (c1 INT PRIMARY KEY) \n    ->     TABLESPACE ts1 \n    ->     ROW_FORMAT=DYNAMIC;\nQuery OK, 0 rows affected (0.00 sec)\n\nThis example demonstrates creating a general tablespace and adding a\ncompressed table. The example assumes a default innodb_page_size of\n16K. The FILE_BLOCK_SIZE of 8192 requires that the compressed table\nhave a KEY_BLOCK_SIZE of 8.\n\nmysql> CREATE TABLESPACE `ts2` \n    ->   ADD DATAFILE \'ts2.ibd\' \n    ->   FILE_BLOCK_SIZE = 8192 \n    ->   ENGINE=INNODB;\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> CREATE TABLE t4 (c1 INT PRIMARY KEY) \n    ->   TABLESPACE ts2 \n    ->   ROW_FORMAT=COMPRESSED \n    ->   KEY_BLOCK_SIZE=8;\nQuery OK, 0 rows affected (0.00 sec)\n\nNDB Example\n\nSuppose that you wish to create a MySQL Cluster Disk Data tablespace\nnamed myts using a datafile named mydata-1.dat. An NDB tablespace\nalways requires the use of a log file group consisting of one or more\nundo log files. For this example, we first create a log file group\nnamed mylg that contains one undo long file named myundo-1.dat, using\nthe CREATE LOGFILE GROUP statement shown here:\n\nmysql> CREATE LOGFILE GROUP myg1 \n    ->     ADD UNDOFILE \'myundo-1.dat\' \n    ->     ENGINE=NDB;\nQuery OK, 0 rows affected (3.29 sec)\n\nNow you can create the tablespace previously described using the\nfollowing statement:\n\nmysql> CREATE TABLESPACE myts\n    ->     ADD DATAFILE \'mydata-1.dat\'\n    ->     USE LOGFILE GROUP mylg\n    ->     ENGINE=NDB;\nQuery OK, 0 rows affected (2.98 sec)\n\nYou can now create a Disk Data table using a CREATE TABLE statement\nwith the TABLESPACE and STORAGE DISK options, similar to what is shown\nhere:\n\nmysql> CREATE TABLE mytable (\n    ->     id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->     lname VARCHAR(50) NOT NULL,\n    ->     fname VARCHAR(50) NOT NULL,\n    ->     dob DATE NOT NULL,\n    ->     joined DATE NOT NULL,\n    ->     INDEX(last_name, first_name)\n    -> )\n    ->     TABLESPACE myts STORAGE DISK\n    ->     ENGINE=NDB;\nQuery OK, 0 rows affected (1.41 sec)\n\nIt is important to note that only the dob and joined columns from\nmytable are actually stored on disk, due to the fact that the id,\nlname, and fname columns are all indexed.\n\nAs mentioned previously, when CREATE TABLESPACE is used with ENGINE [=]\nNDB, a tablespace and associated data file are created on each MySQL\nCluster data node. You can verify that the data files were created and\nobtain information about them by querying the INFORMATION_SCHEMA.FILES\ntable, as shown here:\n\nmysql> SELECT FILE_NAME, FILE_TYPE, LOGFILE_GROUP_NAME, STATUS, EXTRA\n    ->     FROM INFORMATION_SCHEMA.FILES\n    ->     WHERE TABLESPACE_NAME = \'myts\';\n\n+--------------+------------+--------------------+--------+----------------+\n| file_name    | file_type  | logfile_group_name | status | extra          |\n+--------------+------------+--------------------+--------+----------------+\n| mydata-1.dat | DATAFILE   | mylg               | NORMAL | CLUSTER_NODE=5 |\n| mydata-1.dat | DATAFILE   | mylg               | NORMAL | CLUSTER_NODE=6 |\n| NULL         | TABLESPACE | mylg               | NORMAL | NULL           |\n+--------------+------------+--------------------+--------+----------------+\n3 rows in set (0.01 sec)\n\nFor additional information and examples, see\nhttp://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-disk-data-objects.\nhtml.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-tablespace.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (122,4,'ST_GEOMFROMTEXT','ST_GeomFromText(wkt[,srid]), ST_GeometryFromText(wkt[,srid])\n\nConstructs a geometry value of any type using its WKT representation\nand SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (123,38,'INSERT FUNCTION','Syntax:\nINSERT(str,pos,len,newstr)\n\nReturns the string str, with the substring beginning at position pos\nand len characters long replaced by the string newstr. Returns the\noriginal string if pos is not within the length of the string. Replaces\nthe rest of the string from position pos if len is not within the\nlength of the rest of the string. Returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT INSERT(\'Quadratic\', 3, 4, \'What\');\n        -> \'QuWhattic\'\nmysql> SELECT INSERT(\'Quadratic\', -1, 4, \'What\');\n        -> \'Quadratic\'\nmysql> SELECT INSERT(\'Quadratic\', 3, 100, \'What\');\n        -> \'QuWhat\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (124,15,'XOR','Syntax:\nXOR\n\nLogical XOR. Returns NULL if either operand is NULL. For non-NULL\noperands, evaluates to 1 if an odd number of operands is nonzero,\notherwise 0 is returned.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/logical-operators.html\n\n','mysql> SELECT 1 XOR 1;\n        -> 0\nmysql> SELECT 1 XOR 0;\n        -> 1\nmysql> SELECT 1 XOR NULL;\n        -> NULL\nmysql> SELECT 1 XOR 1 XOR 1;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/logical-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (125,10,'GRANT','Syntax:\nGRANT\n    priv_type [(column_list)]\n      [, priv_type [(column_list)]] ...\n    ON [object_type] priv_level\n    TO user_specification [, user_specification] ...\n    [REQUIRE {NONE | tsl_option [[AND] tsl_option] ...}]\n    [WITH {GRANT OPTION | resource_option} ...]\n\nGRANT PROXY ON user_specification\n    TO user_specification [, user_specification] ...\n    [WITH GRANT OPTION]\n\nobject_type: {\n    TABLE\n  | FUNCTION\n  | PROCEDURE\n}\n\npriv_level: {\n    *\n  | *.*\n  | db_name.*\n  | db_name.tbl_name\n  | tbl_name\n  | db_name.routine_name\n}\n\nuser_specification:\n    user [ auth_option ]\n\nauth_option: {     # Before MySQL 5.7.6\n    IDENTIFIED BY \'auth_string\'\n  | IDENTIFIED BY PASSWORD \'hash_string\'\n  | IDENTIFIED WITH auth_plugin\n  | IDENTIFIED WITH auth_plugin AS \'hash_string\'\n}\n\nauth_option: {     # As of MySQL 5.7.6\n    IDENTIFIED BY \'auth_string\'\n  | IDENTIFIED BY PASSWORD \'hash_string\'\n  | IDENTIFIED WITH auth_plugin\n  | IDENTIFIED WITH auth_plugin BY \'auth_string\'\n  | IDENTIFIED WITH auth_plugin AS \'hash_string\'\n}\n\ntsl_option: {\n    SSL\n  | X509\n  | CIPHER \'cipher\'\n  | ISSUER \'issuer\'\n  | SUBJECT \'subject\'\n}\n\nresource_option: {\n  | MAX_QUERIES_PER_HOUR count\n  | MAX_UPDATES_PER_HOUR count\n  | MAX_CONNECTIONS_PER_HOUR count\n  | MAX_USER_CONNECTIONS count\n}\n\nThe GRANT statement grants privileges to MySQL user accounts.\n\nTo use GRANT, you must have the GRANT OPTION privilege, and you must\nhave the privileges that you are granting. When the read_only system\nvariable is enabled, GRANT additionally requires the SUPER privilege.\n\nThe REVOKE statement is related to GRANT and enables administrators to\nremove account privileges. See [HELP REVOKE].\n\nNormally, a database administrator first uses CREATE USER to create an\naccount and define its nonprivilege characteristics such as its\npassword, whether it uses secure connections, and limits on access to\nserver resources, then uses GRANT to define its privileges. ALTER USER\nmay be used to change the nonprivilege characteristics of existing\naccounts. For example:\n\nCREATE USER \'jeffrey\'@\'localhost\' IDENTIFIED BY \'mypass\';\nGRANT ALL ON db1.* TO \'jeffrey\'@\'localhost\';\nGRANT SELECT ON db2.invoice TO \'jeffrey\'@\'localhost\';\nALTER USER \'jeffrey\'@\'localhost\' WITH MAX_QUERIES_PER_HOUR 90;\n\n*Note*: Examples shown here include no IDENTIFIED clause. It is assumed\nthat you establish passwords with CREATE USER at account-creation time\nto avoid creating insecure accounts.\n\n*Note*: If an account named in a GRANT statement does not already\nexist, GRANT may create it under the conditions described later in the\ndiscussion of the NO_AUTO_CREATE_USER SQL mode. It is also possible to\nuse GRANT to specify nonprivilege account characteristics such as\nwhether it uses secure connections and limits on access to server\nresources. However, use of GRANT to create accounts or define\nnonprivilege characteristics is deprecated as of MySQL 5.7.6. Instead,\nperform these tasks using CREATE USER or ALTER USER.\n\nFrom the mysql program, GRANT responds with Query OK, 0 rows affected\nwhen executed successfully. To determine what privileges result from\nthe operation, use SHOW GRANTS. See [HELP SHOW GRANTS].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/grant.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/grant.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (126,7,'MBRINTERSECTS','MBRIntersects(g1,g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\nthe two geometries g1 and g2 intersect.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (127,20,'IS NOT','Syntax:\nIS NOT boolean_value\n\nTests a value against a boolean value, where boolean_value can be TRUE,\nFALSE, or UNKNOWN.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NOT UNKNOWN, 0 IS NOT UNKNOWN, NULL IS NOT UNKNOWN;\n        -> 1, 1, 0\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (128,3,'SQRT','Syntax:\nSQRT(X)\n\nReturns the square root of a nonnegative number X.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT SQRT(4);\n        -> 2\nmysql> SELECT SQRT(20);\n        -> 4.4721359549996\nmysql> SELECT SQRT(-16);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (129,33,'ST_MPOLYFROMWKB','ST_MPolyFromWKB(wkb[,srid]), ST_MultiPolygonFromWKB(wkb[,srid])\n\nConstructs a MultiPolygon value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (130,40,'CREATE INDEX','Syntax:\nCREATE [UNIQUE|FULLTEXT|SPATIAL] INDEX index_name\n    [index_type]\n    ON tbl_name (index_col_name,...)\n    [index_option] \n    [algorithm_option | lock_option] ...\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n  | COMMENT \'string\'\n\nalgorithm_option:\n    ALGORITHM [=] {DEFAULT|INPLACE|COPY}\n\nlock_option:\n    LOCK [=] {DEFAULT|NONE|SHARED|EXCLUSIVE}\n\nCREATE INDEX is mapped to an ALTER TABLE statement to create indexes.\nSee [HELP ALTER TABLE]. CREATE INDEX cannot be used to create a PRIMARY\nKEY; use ALTER TABLE instead. For more information about indexes, see\nhttp://dev.mysql.com/doc/refman/5.7/en/mysql-indexes.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-index.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-index.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (131,40,'ALTER DATABASE','Syntax:\nALTER {DATABASE | SCHEMA} [db_name]\n    alter_specification ...\nALTER {DATABASE | SCHEMA} db_name\n    UPGRADE DATA DIRECTORY NAME\n\nalter_specification:\n    [DEFAULT] CHARACTER SET [=] charset_name\n  | [DEFAULT] COLLATE [=] collation_name\n\nALTER DATABASE enables you to change the overall characteristics of a\ndatabase. These characteristics are stored in the db.opt file in the\ndatabase directory. To use ALTER DATABASE, you need the ALTER privilege\non the database. ALTER SCHEMA is a synonym for ALTER DATABASE.\n\nThe database name can be omitted from the first syntax, in which case\nthe statement applies to the default database.\n\nNational Language Characteristics\n\nThe CHARACTER SET clause changes the default database character set.\nThe COLLATE clause changes the default database collation.\nhttp://dev.mysql.com/doc/refman/5.7/en/charset.html, discusses\ncharacter set and collation names.\n\nYou can see what character sets and collations are available using,\nrespectively, the SHOW CHARACTER SET and SHOW COLLATION statements. See\n[HELP SHOW CHARACTER SET], and [HELP SHOW COLLATION], for more\ninformation.\n\nIf you change the default character set or collation for a database,\nstored routines that use the database defaults must be dropped and\nrecreated so that they use the new defaults. (In a stored routine,\nvariables with character data types use the database defaults if the\ncharacter set or collation are not specified explicitly. See [HELP\nCREATE PROCEDURE].)\n\nUpgrading from Versions Older than MySQL 5.1\n\nThe syntax that includes the UPGRADE DATA DIRECTORY NAME clause updates\nthe name of the directory associated with the database to use the\nencoding implemented in MySQL 5.1 for mapping database names to\ndatabase directory names (see\nhttp://dev.mysql.com/doc/refman/5.7/en/identifier-mapping.html). This\nclause is for use under these conditions:\n\no It is intended when upgrading MySQL to 5.1 or later from older\n  versions.\n\no It is intended to update a database directory name to the current\n  encoding format if the name contains special characters that need\n  encoding.\n\no The statement is used by mysqlcheck (as invoked by mysql_upgrade).\n\nFor example, if a database in MySQL 5.0 has the name a-b-c, the name\ncontains instances of the - (dash) character. In MySQL 5.0, the\ndatabase directory is also named a-b-c, which is not necessarily safe\nfor all file systems. In MySQL 5.1 and later, the same database name is\nencoded as a@002db@002dc to produce a file system-neutral directory\nname.\n\nWhen a MySQL installation is upgraded to MySQL 5.1 or later from an\nolder version,the server displays a name such as a-b-c (which is in the\nold format) as #mysql50#a-b-c, and you must refer to the name using the\n#mysql50# prefix. Use UPGRADE DATA DIRECTORY NAME in this case to\nexplicitly tell the server to re-encode the database directory name to\nthe current encoding format:\n\nALTER DATABASE `#mysql50#a-b-c` UPGRADE DATA DIRECTORY NAME;\n\nAfter executing this statement, you can refer to the database as a-b-c\nwithout the special #mysql50# prefix.\n\n*Note*: The UPGRADE DATA DIRECTORY NAME clause is deprecated in MySQL\n5.7.6 and will be removed in a future version of MySQL. If it is\nnecessary to convert MySQL 5.0 database or table names, a workaround is\nto upgrade a MySQL 5.0 installation to MySQL 5.1 before upgrading to a\nmore recent release.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-database.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/alter-database.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (132,7,'JSON_ARRAY','JSON_ARRAY([val[, val] ...])\n\nEvaluates a (possibly empty) list of values and returns a JSON array\ncontaining those values.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-creation-functions.html\n\n','mysql> SELECT JSON_ARRAY(1, "abc", NULL, TRUE, CURTIME());\n+---------------------------------------------+\n| JSON_ARRAY(1, "abc", NULL, TRUE, CURTIME()) |\n+---------------------------------------------+\n| [1, "abc", null, true, "11:30:24.000000"]   |\n+---------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-creation-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (133,26,'GEOMETRYN','GeometryN(gc,N)\n\nST_GeometryN() and GeometryN() are synonyms. For more information, see\nthe description of ST_GeometryN().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-geometrycollection-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-geometrycollection-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (134,19,'<<','Syntax:\n<<\n\nShifts a longlong (BIGINT) number to the left.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html\n\n','mysql> SELECT 1 << 2;\n        -> 4\n','http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (135,27,'SHOW TABLE STATUS','Syntax:\nSHOW TABLE STATUS [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TABLE STATUS works likes SHOW TABLES, but provides a lot of\ninformation about each non-TEMPORARY table. You can also get this list\nusing the mysqlshow --status db_name command. The LIKE clause, if\npresent, indicates which table names to match. The WHERE clause can be\ngiven to select rows using more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-table-status.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-table-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (136,38,'ASCII','Syntax:\nASCII(str)\n\nReturns the numeric value of the leftmost character of the string str.\nReturns 0 if str is the empty string. Returns NULL if str is NULL.\nASCII() works for 8-bit characters.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT ASCII(\'2\');\n        -> 50\nmysql> SELECT ASCII(2);\n        -> 50\nmysql> SELECT ASCII(\'dx\');\n        -> 100\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (137,3,'DIV','Syntax:\nDIV\n\nInteger division. Discards from the division result any fractional part\nto the right of the decimal point.\n\nIf either operand has a noninteger type, the operands are converted to\nDECIMAL and divided using DECIMAL arithmetic before converting the\nresult to BIGINT. If the result exceeds BIGINT range, an error occurs.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html\n\n','mysql> SELECT 5 DIV 2, -5 DIV 2, 5 DIV -2, -5 DIV -2;\n        -> 2, -2, -2, 2\n','http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (138,27,'SHOW SLAVE STATUS','Syntax:\nSHOW SLAVE STATUS [NONBLOCKING # Removed in MySQL 5.7.6] \n                  [FOR CHANNEL channel]\n\nThis statement provides status information on essential parameters of\nthe slave threads. It requires either the SUPER or REPLICATION CLIENT\nprivilege.\n\nBetween MySQL 5.7.1 and MySQL 5.7.5, an optional NONBLOCKING clause\ncould be used. The NONBLOCKING clause caused SHOW SLAVE STATUS, when\nrun concurrently with STOP SLAVE, to return without waiting for STOP\nSLAVE to finish shutting down the slave SQL thread or slave I/O thread\n(or both). This option was intended for use in monitoring and other\napplications where getting an immediate response from SHOW SLAVE STATUS\nwas more important than ensuring that it returned the latest data. This\noption was removed in MySQL 5.7.6 due to locking changes in replication\nadministrative statements. As of MySQL 5.7.9 the non-blocking behavior\nof SHOW SLAVE STATUS is fixed and the option became unnecessary.\n\nIf you issue this statement using the mysql client, you can use a \\G\nstatement terminator rather than a semicolon to obtain a more readable\nvertical layout:\n\nmysql> SHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n               Slave_IO_State: Waiting for master to send event\n                  Master_Host: localhost\n                  Master_User: root\n                  Master_Port: 13000\n                Connect_Retry: 60\n              Master_Log_File: master-bin.000002\n          Read_Master_Log_Pos: 1307\n               Relay_Log_File: slave-relay-bin.000003\n                Relay_Log_Pos: 1508\n        Relay_Master_Log_File: master-bin.000002\n             Slave_IO_Running: Yes\n            Slave_SQL_Running: Yes\n              Replicate_Do_DB:\n          Replicate_Ignore_DB:\n           Replicate_Do_Table:\n       Replicate_Ignore_Table:\n      Replicate_Wild_Do_Table:\n  Replicate_Wild_Ignore_Table:\n                   Last_Errno: 0\n                   Last_Error:\n                 Skip_Counter: 0\n          Exec_Master_Log_Pos: 1307\n              Relay_Log_Space: 1858\n              Until_Condition: None\n               Until_Log_File:\n                Until_Log_Pos: 0\n           Master_SSL_Allowed: No\n           Master_SSL_CA_File:\n           Master_SSL_CA_Path:\n              Master_SSL_Cert:\n            Master_SSL_Cipher:\n               Master_SSL_Key:\n        Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n                Last_IO_Errno: 0\n                Last_IO_Error:\n               Last_SQL_Errno: 0\n               Last_SQL_Error:\n  Replicate_Ignore_Server_Ids:\n             Master_Server_Id: 1\n                  Master_UUID: 3e11fa47-71ca-11e1-9e33-c80aa9429562\n             Master_Info_File: /var/mysqld.2/data/master.info\n                    SQL_Delay: 0\n          SQL_Remaining_Delay: NULL\n      Slave_SQL_Running_State: Slave has read all relay log; waiting for the slave I/O thread to update it\n           Master_Retry_Count: 10\n                  Master_Bind:\n      Last_IO_Error_Timestamp:\n     Last_SQL_Error_Timestamp:\n               Master_SSL_Crl:\n           Master_SSL_Crlpath:\n           Retrieved_Gtid_Set: 3e11fa47-71ca-11e1-9e33-c80aa9429562:1-5\n            Executed_Gtid_Set: 3e11fa47-71ca-11e1-9e33-c80aa9429562:1-5\n                Auto_Position: 1\n         Replicate_Rewrite_DB:\n                 Channel_name: \n1 row in set (0.00 sec)\n\nAs of MySQL 5.7.2, the Performance Schema provides tables that expose\nreplication information. This is similar to the information available\nfrom the SHOW SLAVE STATUS statement, but represented in table form.\nFor details, see\nhttp://dev.mysql.com/doc/refman/5.7/en/performance-schema-replication-t\nables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-slave-status.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-slave-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (139,35,'GEOMETRY','MySQL provides a standard way of creating spatial columns for geometry\ntypes, for example, with CREATE TABLE or ALTER TABLE. Spatial columns\nare supported for MyISAM, InnoDB, NDB, and ARCHIVE tables. See also the\nnotes about spatial indexes under [HELP SPATIAL].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/creating-spatial-columns.html\n\n','CREATE TABLE geom (g GEOMETRY);\n','http://dev.mysql.com/doc/refman/5.7/en/creating-spatial-columns.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (140,19,'&','Syntax:\n&\n\nBitwise AND:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html\n\n','mysql> SELECT 29 & 15;\n        -> 13\n','http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (141,15,'ASSIGN-EQUAL','Syntax:\n=\n\nThis operator is used to perform value assignments in two cases,\ndescribed in the next two paragraphs.\n\nWithin a SET statement, = is treated as an assignment operator that\ncauses the user variable on the left hand side of the operator to take\non the value to its right. (In other words, when used in a SET\nstatement, = is treated identically to :=.) The value on the right hand\nside may be a literal value, another variable storing a value, or any\nlegal expression that yields a scalar value, including the result of a\nquery (provided that this value is a scalar value). You can perform\nmultiple assignments in the same SET statement.\n\nIn the SET clause of an UPDATE statement, = also acts as an assignment\noperator; in this case, however, it causes the column named on the left\nhand side of the operator to assume the value given to the right,\nprovided any WHERE conditions that are part of the UPDATE are met. You\ncan make multiple assignments in the same SET clause of an UPDATE\nstatement.\n\nIn any other context, = is treated as a comparison operator.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/assignment-operators.html\n\n','mysql> SELECT @var1, @var2;\n        -> NULL, NULL\nmysql> SELECT @var1 := 1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2 := @var1;\n        -> 1, 1\nmysql> SELECT @var1, @var2;\n        -> 1, 1\n','http://dev.mysql.com/doc/refman/5.7/en/assignment-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (142,38,'CONVERT','Syntax:\nCONVERT(expr,type), CONVERT(expr USING transcoding_name)\n\nThe CONVERT() and CAST() functions take an expression of any type and\nproduce a result value of a specified type.\n\nCAST() and CONVERT(... USING ...) are standard SQL syntax. The\nnon-USING form of CONVERT() is ODBC syntax.\n\nCONVERT() with USING converts data between different character sets. In\nMySQL, transcoding names are the same as the corresponding character\nset names. For example, this statement converts the string \'abc\' in the\ndefault character set to the corresponding string in the utf8 character\nset:\n\nSELECT CONVERT(\'abc\' USING utf8);\n\nThe type for the result can be one of the following values:\n\no BINARY[(N)]\n\no CHAR[(N)]\n\no DATE\n\no DATETIME\n\no DECIMAL[(M[,D])]\n\no JSON (added in MySQL 5.7.8)\n\no SIGNED [INTEGER]\n\no TIME\n\no UNSIGNED [INTEGER]\n\nBINARY produces a string with the BINARY data type. See\nhttp://dev.mysql.com/doc/refman/5.7/en/binary-varbinary.html for a\ndescription of how this affects comparisons. If the optional length N\nis given, BINARY(N) causes the cast to use no more than N bytes of the\nargument. Values shorter than N bytes are padded with 0x00 bytes to a\nlength of N.\n\nCHAR(N) causes the cast to use no more than N characters of the\nargument.\n\nJSON returns a JSON value. For details on the rules for conversion of\nvalues between JSON and other types, see\nhttp://dev.mysql.com/doc/refman/5.7/en/json.html#json-comparison.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/cast-functions.html\n\n','SELECT enum_col FROM tbl_name ORDER BY CAST(enum_col AS CHAR);\n','http://dev.mysql.com/doc/refman/5.7/en/cast-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (143,24,'REPEAT LOOP','Syntax:\n[begin_label:] REPEAT\n    statement_list\nUNTIL search_condition\nEND REPEAT [end_label]\n\nThe statement list within a REPEAT statement is repeated until the\nsearch_condition expression is true. Thus, a REPEAT always enters the\nloop at least once. statement_list consists of one or more statements,\neach terminated by a semicolon (;) statement delimiter.\n\nA REPEAT statement can be labeled. For the rules regarding label use,\nsee [HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/repeat.html\n\n','mysql> delimiter //\n\nmysql> CREATE PROCEDURE dorepeat(p1 INT)\n    -> BEGIN\n    ->   SET @x = 0;\n    ->   REPEAT\n    ->     SET @x = @x + 1;\n    ->   UNTIL @x > p1 END REPEAT;\n    -> END\n    -> //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CALL dorepeat(1000)//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @x//\n+------+\n| @x   |\n+------+\n| 1001 |\n+------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/repeat.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (144,7,'ST_ISVALID','ST_IsValid(g)\n\nChecks whether a geometry is valid, as defined by the OGC\nspecification. ST_IsValid() returns 1 if the argument is a valid\ngeometry byte string and is geometrically valid, 0 if the argument is\nnot a valid geometry byte string or is not geometrically valid, NULL if\nthe argument is NULL.\n\nThe only valid empty geometry is represented in the form of an empty\ngeometry collection value. ST_IsValid() returns 1 in this case.\n\nST_IsValid() works only for the cartesian coordinate system and\nrequires a geometry argument with an SRID of 0. An ER_WRONG_ARGUMENTS\nerror occurs otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-convenience-functions.html\n\n','mysql> SET @ls1 = ST_GeomFromText(\'LINESTRING(0 0)\');\nmysql> SET @ls2 = ST_GeomFromText(\'LINESTRING(0 0, 1 1)\');\nmysql> SELECT ST_IsValid(@ls1);\n+------------------+\n| ST_IsValid(@ls1) |\n+------------------+\n|                0 |\n+------------------+\nmysql> SELECT ST_IsValid(@ls2);\n+------------------+\n| ST_IsValid(@ls2) |\n+------------------+\n|                1 |\n+------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-convenience-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (145,23,'SMALLINT','SMALLINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA small integer. The signed range is -32768 to 32767. The unsigned\nrange is 0 to 65535.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (146,23,'DOUBLE PRECISION','DOUBLE PRECISION[(M,D)] [UNSIGNED] [ZEROFILL], REAL[(M,D)] [UNSIGNED]\n[ZEROFILL]\n\nThese types are synonyms for DOUBLE. Exception: If the REAL_AS_FLOAT\nSQL mode is enabled, REAL is a synonym for FLOAT rather than DOUBLE.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (147,38,'ORD','Syntax:\nORD(str)\n\nIf the leftmost character of the string str is a multibyte character,\nreturns the code for that character, calculated from the numeric values\nof its constituent bytes using this formula:\n\n  (1st byte code)\n+ (2nd byte code * 256)\n+ (3rd byte code * 2562) ...\n\nIf the leftmost character is not a multibyte character, ORD() returns\nthe same value as the ASCII() function.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT ORD(\'2\');\n        -> 50\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (148,37,'ENVELOPE','Envelope(g)\n\nST_Envelope() and Envelope() are synonyms. For more information, see\nthe description of ST_Envelope().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (149,37,'ST_ISEMPTY','ST_IsEmpty(g)\n\nThis function is a placeholder that returns 0 for any valid geometry\nvalue, 1 for any invalid geometry value or NULL.\n\nMySQL does not support GIS EMPTY values such as POINT EMPTY.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (150,14,'INET_ATON','Syntax:\nINET_ATON(expr)\n\nGiven the dotted-quad representation of an IPv4 network address as a\nstring, returns an integer that represents the numeric value of the\naddress in network byte order (big endian). INET_ATON() returns NULL if\nit does not understand its argument.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> SELECT INET_ATON(\'10.0.5.9\');\n        -> 167773449\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (151,37,'ISSIMPLE','IsSimple(g)\n\nST_IsSimple() and IsSimple() are synonyms. For more information, see\nthe description of ST_IsSimple().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (152,3,'- BINARY','Syntax:\n-\n\nSubtraction:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html\n\n','mysql> SELECT 3-5;\n        -> -2\n','http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (153,32,'CURRENT_TIME','Syntax:\nCURRENT_TIME, CURRENT_TIME([fsp])\n\nCURRENT_TIME and CURRENT_TIME() are synonyms for CURTIME().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (154,4,'WKT DEFINITION','The Well-Known Text (WKT) representation of geometry values is designed\nfor exchanging geometry data in ASCII form. The OpenGIS specification\nprovides a Backus-Naur grammar that specifies the formal production\nrules for writing WKT values (see\nhttp://dev.mysql.com/doc/refman/5.7/en/spatial-extensions.html).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-data-formats.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-data-formats.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (155,11,'ST_Y','ST_Y(p)\n\nReturns the Y-coordinate value for the Point object p as a\ndouble-precision number.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-point-property-functions.html\n\n','mysql> SELECT ST_Y(POINT(56.7, 53.34));\n+--------------------------+\n| ST_Y(POINT(56.7, 53.34)) |\n+--------------------------+\n|                    53.34 |\n+--------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-point-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (156,10,'REVOKE','Syntax:\nREVOKE\n    priv_type [(column_list)]\n      [, priv_type [(column_list)]] ...\n    ON [object_type] priv_level\n    FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n    FROM user [, user] ...\n\nREVOKE PROXY ON user\n    FROM user [, user] ...\n\nThe REVOKE statement enables system administrators to revoke privileges\nfrom MySQL accounts.\n\nWhen the read_only system variable is enabled, REVOKE requires the\nSUPER privilege in addition to any other required privileges described\nin the following discussion.\n\nEach account name uses the format described in\nhttp://dev.mysql.com/doc/refman/5.7/en/account-names.html. For example:\n\nREVOKE INSERT ON *.* FROM \'jeffrey\'@\'localhost\';\n\nIf you specify only the user name part of the account name, a host name\npart of \'%\' is used.\n\nFor details on the levels at which privileges exist, the permissible\npriv_type, priv_level, and object_type values, and the syntax for\nspecifying users and passwords, see [HELP GRANT]\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION\nprivilege, and you must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all\nglobal, database, table, column, and routine privileges for the named\nuser or users:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nTo use this REVOKE syntax, you must have the global CREATE USER\nprivilege or the UPDATE privilege for the mysql database.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/revoke.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/revoke.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (157,32,'LAST_DAY','Syntax:\nLAST_DAY(date)\n\nTakes a date or datetime value and returns the corresponding value for\nthe last day of the month. Returns NULL if the argument is invalid.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT LAST_DAY(\'2003-02-05\');\n        -> \'2003-02-28\'\nmysql> SELECT LAST_DAY(\'2004-02-05\');\n        -> \'2004-02-29\'\nmysql> SELECT LAST_DAY(\'2004-01-01 01:01:01\');\n        -> \'2004-01-31\'\nmysql> SELECT LAST_DAY(\'2003-03-32\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (158,23,'MEDIUMINT','MEDIUMINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA medium-sized integer. The signed range is -8388608 to 8388607. The\nunsigned range is 0 to 16777215.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (159,12,'RANDOM_BYTES','Syntax:\nRANDOM_BYTES(len)\n\nThis function returns a binary string of len random bytes generated\nusing the random number generator of the SSL library (OpenSSL or\nyaSSL). Permitted values of len range from 1 to 1024. For values\noutside that range, RANDOM_BYTES() generates a warning and returns\nNULL.\n\nRANDOM_BYTES() can be used to provide the initialization vector for the\nAES_DECRYPT() and AES_ENCRYPT() functions. For use in that context, len\nmust be at least 16. Larger values are permitted, but bytes in excess\nof 16 are ignored.\n\nRANDOM_BYTES() generates a random value, which makes its result\nnondeterministic. Consequently, statements that use this function are\nunsafe for statement-based replication and cannot be stored in the\nquery cache.\n\nThis function is available as of MySQL 5.7.4.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (160,38,'RTRIM','Syntax:\nRTRIM(str)\n\nReturns the string str with trailing space characters removed.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT RTRIM(\'barbar   \');\n        -> \'barbar\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (161,29,'EXPLAIN','Syntax:\n{EXPLAIN | DESCRIBE | DESC}\n    tbl_name [col_name | wild]\n\n{EXPLAIN | DESCRIBE | DESC}\n    [explain_type]\n    {explainable_stmt | FOR CONNECTION connection_id}\n\nexplain_type: {\n    EXTENDED\n  | PARTITIONS\n  | FORMAT = format_name\n}\n\nformat_name: {\n    TRADITIONAL\n  | JSON\n}\n\nexplainable_stmt: {\n    SELECT statement\n  | DELETE statement\n  | INSERT statement\n  | REPLACE statement\n  | UPDATE statement\n}\n\nThe DESCRIBE and EXPLAIN statements are synonyms. In practice, the\nDESCRIBE keyword is more often used to obtain information about table\nstructure, whereas EXPLAIN is used to obtain a query execution plan\n(that is, an explanation of how MySQL would execute a query). The\nfollowing discussion uses the DESCRIBE and EXPLAIN keywords in\naccordance with those uses, but the MySQL parser treats them as\ncompletely synonymous.\n\nObtaining Table Structure Information\n\nDESCRIBE provides information about the columns in a table:\n\nmysql> DESCRIBE City;\n+------------+----------+------+-----+---------+----------------+\n| Field      | Type     | Null | Key | Default | Extra          |\n+------------+----------+------+-----+---------+----------------+\n| Id         | int(11)  | NO   | PRI | NULL    | auto_increment |\n| Name       | char(35) | NO   |     |         |                |\n| Country    | char(3)  | NO   | UNI |         |                |\n| District   | char(20) | YES  | MUL |         |                |\n| Population | int(11)  | NO   |     | 0       |                |\n+------------+----------+------+-----+---------+----------------+\n\nDESCRIBE is a shortcut for SHOW COLUMNS. These statements also display\ninformation for views. The description for SHOW COLUMNS provides more\ninformation about the output columns. See [HELP SHOW COLUMNS].\n\nBy default, DESCRIBE displays information about all columns in the\ntable. col_name, if given, is the name of a column in the table. In\nthis case, the statement displays information only for the named\ncolumn. wild, if given, is a pattern string. It can contain the SQL "%"\nand "_" wildcard characters. In this case, the statement displays\noutput only for the columns with names matching the string. There is no\nneed to enclose the string within quotation marks unless it contains\nspaces or other special characters.\n\nThe DESCRIBE statement is provided for compatibility with Oracle.\n\nThe SHOW CREATE TABLE, SHOW TABLE STATUS, and SHOW INDEX statements\nalso provide information about tables. See [HELP SHOW].\n\nObtaining Execution Plan Information\n\nThe EXPLAIN statement provides information about how MySQL executes\nstatements:\n\no In MySQL 5.7, permitted explainable statements for EXPLAIN are\n  SELECT, DELETE, INSERT, REPLACE, and UPDATE.\n\no When EXPLAIN is used with an explainable statement, MySQL displays\n  information from the optimizer about the statement execution plan.\n  That is, MySQL explains how it would process the statement, including\n  information about how tables are joined and in which order. For\n  information about using EXPLAIN to obtain execution plan information,\n  see http://dev.mysql.com/doc/refman/5.7/en/explain-output.html.\n\no When EXPLAIN is used with FOR CONNECTION connection_id rather than an\n  explainable statement, it displays the execution plan for the\n  statement executing in the named connection. See\n  http://dev.mysql.com/doc/refman/5.7/en/explain-for-connection.html.\n\no EXPLAIN EXTENDED can be used to obtain additional execution plan\n  information. See\n  http://dev.mysql.com/doc/refman/5.7/en/explain-extended.html.\n\n  As of MySQL 5.7.3, the EXPLAIN statement is changed so that the\n  effect of the EXTENDED keyword is always enabled. EXTENDED is still\n  recognized for backward compatibility, but is superfluous and is\n  deprecated; its use results in a warning. It will be removed from\n  EXPLAIN syntax in a future MySQL release.\n\no EXPLAIN PARTITIONS is useful for examining queries involving\n  partitioned tables. See\n  http://dev.mysql.com/doc/refman/5.7/en/partitioning-info.html.\n\n  As of MySQL 5.7.3, the EXPLAIN statement is changed so that the\n  effect of the PARTITIONS keyword is always enabled. PARTITIONS is\n  still recognized for backward compatibility, but is superfluous and\n  is deprecated; its use results in a warning. It will be removed from\n  EXPLAIN syntax in a future MySQL release.\n\no The FORMAT option can be used to select the output format.\n  TRADITIONAL presents the output in tabular format. This is the\n  default if no FORMAT option is present. JSON format displays the\n  information in JSON format. With FORMAT = JSON, the output includes\n  extended and partition information.\n\nWith the help of EXPLAIN, you can see where you should add indexes to\ntables so that the statement executes faster by using indexes to find\nrows. You can also use EXPLAIN to check whether the optimizer joins the\ntables in an optimal order. To give a hint to the optimizer to use a\njoin order corresponding to the order in which the tables are named in\na SELECT statement, begin the statement with SELECT STRAIGHT_JOIN\nrather than just SELECT. (See\nhttp://dev.mysql.com/doc/refman/5.7/en/select.html.)\n\nThe optimizer trace may sometimes provide information complementary to\nthat of EXPLAIN. However, the optimizer trace format and content are\nsubject to change between versions. For details, see MySQL Internals:\nTracing the Optimizer\n(http://dev.mysql.com/doc/internals/en/optimizer-tracing.html).\n\nIf you have a problem with indexes not being used when you believe that\nthey should be, run ANALYZE TABLE to update table statistics, such as\ncardinality of keys, that can affect the choices the optimizer makes.\nSee [HELP ANALYZE TABLE].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/explain.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/explain.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (162,3,'DEGREES','Syntax:\nDEGREES(X)\n\nReturns the argument X, converted from radians to degrees.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT DEGREES(PI());\n        -> 180\nmysql> SELECT DEGREES(PI() / 2);\n        -> 90\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (163,3,'- UNARY','Syntax:\n-\n\nUnary minus. This operator changes the sign of the operand.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html\n\n','mysql> SELECT - 2;\n        -> -2\n','http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (164,23,'VARCHAR','[NATIONAL] VARCHAR(M) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA variable-length string. M represents the maximum column length in\ncharacters. The range of M is 0 to 65,535. The effective maximum length\nof a VARCHAR is subject to the maximum row size (65,535 bytes, which is\nshared among all columns) and the character set used. For example, utf8\ncharacters can require up to three bytes per character, so a VARCHAR\ncolumn that uses the utf8 character set can be declared to be a maximum\nof 21,844 characters. See\nhttp://dev.mysql.com/doc/refman/5.7/en/column-count-limit.html.\n\nMySQL stores VARCHAR values as a 1-byte or 2-byte length prefix plus\ndata. The length prefix indicates the number of bytes in the value. A\nVARCHAR column uses one length byte if values require no more than 255\nbytes, two length bytes if values may require more than 255 bytes.\n\n*Note*: MySQL follows the standard SQL specification, and does not\nremove trailing spaces from VARCHAR values.\n\nVARCHAR is shorthand for CHARACTER VARYING. NATIONAL VARCHAR is the\nstandard SQL way to define that a VARCHAR column should use some\npredefined character set. MySQL uses utf8 as this predefined character\nset. http://dev.mysql.com/doc/refman/5.7/en/charset-national.html.\nNVARCHAR is shorthand for NATIONAL VARCHAR.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (165,38,'UNHEX','Syntax:\n\nUNHEX(str)\n\nFor a string argument str, UNHEX(str) interprets each pair of\ncharacters in the argument as a hexadecimal number and converts it to\nthe byte represented by the number. The return value is a binary\nstring.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT UNHEX(\'4D7953514C\');\n        -> \'MySQL\'\nmysql> SELECT X\'4D7953514C\';\n        -> \'MySQL\'\nmysql> SELECT UNHEX(HEX(\'string\'));\n        -> \'string\'\nmysql> SELECT HEX(UNHEX(\'1267\'));\n        -> \'1267\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (166,40,'DROP TRIGGER','Syntax:\nDROP TRIGGER [IF EXISTS] [schema_name.]trigger_name\n\nThis statement drops a trigger. The schema (database) name is optional.\nIf the schema is omitted, the trigger is dropped from the default\nschema. DROP TRIGGER requires the TRIGGER privilege for the table\nassociated with the trigger.\n\nUse IF EXISTS to prevent an error from occurring for a trigger that\ndoes not exist. A NOTE is generated for a nonexistent trigger when\nusing IF EXISTS. See [HELP SHOW WARNINGS].\n\nTriggers for a table are also dropped if you drop the table.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-trigger.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (167,8,'RESET MASTER','Syntax:\nRESET MASTER\n\nDeletes all binary log files listed in the index file, resets the\nbinary log index file to be empty, and creates a new binary log file.\n\nRESET MASTER also clears the values of the gtid_purged system variable\nas well as the global value of the gtid_executed system variable (but\nnot its session value); that is, executing this statement sets each of\nthese values to an empty string (\'\'). In MySQL 5.7.5 and later, this\nstatement also clears the mysql.gtid_executed table (see\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-gtids-concepts.html#\nreplication-gtids-gtid-executed-table).\n\nThis statement is intended to be used only when the master is started\nfor the first time.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/reset-master.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/reset-master.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (168,3,'PI','Syntax:\nPI()\n\nReturns the value of π (pi). The default number of decimal places\ndisplayed is seven, but MySQL uses the full double-precision value\ninternally.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT PI();\n        -> 3.141593\nmysql> SELECT PI()+0.000000000000000000;\n        -> 3.141592653589793116\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (169,14,'ANY_VALUE','ANY_VALUE(arg)\n\nThis function is useful for GROUP BY queries when the\nONLY_FULL_GROUP_BY SQL mode is enabled, for cases when MySQL rejects a\nquery that you know is valid for reasons that MySQL cannot determine.\nThe function return value and type are the same as the return value and\ntype of its argument, but the function result is not checked for the\nONLY_FULL_GROUP_BY SQL mode.\n\nFor example, if name is a nonindexed column, the following query fails\nwith ONLY_FULL_GROUP_BY enabled:\n\nmysql> SELECT name, address, MAX(age) FROM t GROUP BY name;\nERROR 1055 (42000): Expression #2 of SELECT list is not in GROUP\nBY clause and contains nonaggregated column \'mydb.t.address\' which\nis not functionally dependent on columns in GROUP BY clause; this\nis incompatible with sql_mode=only_full_group_by\n\nThe failure occurs because address is a nonaggregated column that is\nneither named among GROUP BY columns nor functionally dependent on\nthem. As a result, the address value for rows within each name group is\nnondeterministic. There are multiple ways to cause MySQL to accept the\nquery:\n\no Alter the table to make name a primary key or a unique NOT NULL\n  column. This enables MySQL to determine that address is functionally\n  dependent on name; that is, address is uniquely determined by name.\n  (This technique is inapplicable if NULL must be permitted as a valid\n  name value.)\n\no Use ANY_VALUE() to refer to address:\n\nSELECT name, ANY_VALUE(address), MAX(age) FROM t GROUP BY name;\n\n  In this case, MySQL ignores the nondeterminism of address values\n  within each name group and accepts the query. This may be useful if\n  you simply do not care which value of a nonaggregated column is\n  chosen for each group. ANY_VALUE() is not an aggregate function,\n  unlike functions such as SUM() or COUNT(). It simply acts to suppress\n  the test for nondeterminism.\n\no Disable ONLY_FULL_GROUP_BY. This is equivalent to using ANY_VALUE()\n  with ONLY_FULL_GROUP_BY enabled, as described in the previous item.\n\nANY_VALUE() is also useful if functional dependence exists between\ncolumns but MySQL cannot determine it. The following query is valid\nbecause age is functionally dependent on the grouping column age-1, but\nMySQL cannot tell that and rejects the query with ONLY_FULL_GROUP_BY\nenabled:\n\nSELECT age FROM t GROUP BY age-1;\n\nTo cause MySQL to accept the query, use ANY_VALUE():\n\nSELECT ANY_VALUE(age) FROM t GROUP BY age-1;\n\nANY_VALUE() can be used for queries that refer to aggregate functions\nin the absence of a GROUP BY clause:\n\nmysql> SELECT name, MAX(age) FROM t;\nERROR 1140 (42000): In aggregated query without GROUP BY, expression\n#1 of SELECT list contains nonaggregated column \'mydb.t.name\'; this\nis incompatible with sql_mode=only_full_group_by\n\nWithout GROUP BY, there is a single group and it is indeterminate which\nname value to choose for the group. ANY_VALUE() tells MySQL to accept\nthe query:\n\nSELECT ANY_VALUE(name), MAX(age) FROM t;\n\nIt may be that, due to some property of a given data set, you know that\na selected nonaggregated column is effectively functionally dependent\non a GROUP BY column. For example, an application may enforce\nuniqueness of one column with respect to another. In this case, using\nANY_VALUE() for the effectively functionally dependent column may make\nsense.\n\nFor additional discussion, see\nhttp://dev.mysql.com/doc/refman/5.7/en/group-by-handling.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (170,3,'/','Syntax:\n/\n\nDivision:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html\n\n','mysql> SELECT 3/5;\n        -> 0.60\n','http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (171,8,'PURGE BINARY LOGS','Syntax:\nPURGE { BINARY | MASTER } LOGS\n    { TO \'log_name\' | BEFORE datetime_expr }\n\nThe binary log is a set of files that contain information about data\nmodifications made by the MySQL server. The log consists of a set of\nbinary log files, plus an index file (see\nhttp://dev.mysql.com/doc/refman/5.7/en/binary-log.html).\n\nThe PURGE BINARY LOGS statement deletes all the binary log files listed\nin the log index file prior to the specified log file name or date.\nBINARY and MASTER are synonyms. Deleted log files also are removed from\nthe list recorded in the index file, so that the given log file becomes\nthe first in the list.\n\nThis statement has no effect if the server was not started with the\n--log-bin option to enable binary logging.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/purge-binary-logs.html\n\n','PURGE BINARY LOGS TO \'mysql-bin.010\';\nPURGE BINARY LOGS BEFORE \'2008-04-02 22:46:26\';\n','http://dev.mysql.com/doc/refman/5.7/en/purge-binary-logs.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (172,16,'STDDEV_SAMP','Syntax:\nSTDDEV_SAMP(expr)\n\nReturns the sample standard deviation of expr (the square root of\nVAR_SAMP().\n\nSTDDEV_SAMP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (173,31,'ST_TOUCHES','ST_Touches(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially touches g2. Two\ngeometries spatially touch if the interiors of the geometries do not\nintersect, but the boundary of one of the geometries intersects either\nthe boundary or the interior of the other.\n\nAs of MySQL 5.7.5, this function returns 0 if called with an\ninapplicable geometry argument type combination. For example, it\nreturns 0 if either of the arguments is a Point or MultiPoint.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (174,17,'SCHEMA','Syntax:\nSCHEMA()\n\nThis function is a synonym for DATABASE().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (175,7,'MBREQUALS','MBREquals(g1,g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\nthe two geometries g1 and g2 are the same.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (176,33,'MLINEFROMWKB','MLineFromWKB(wkb[,srid]), MultiLineStringFromWKB(wkb[,srid])\n\nST_MLineFromWKB(), ST_MultiLineStringFromWKB(), MLineFromWKB(), and\nMultiLineStringFromWKB() are synonyms. For more information, see the\ndescription of ST_MLineFromWKB().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (177,27,'SHOW CREATE TABLE','Syntax:\nSHOW CREATE TABLE tbl_name\n\nShows the CREATE TABLE statement that creates the named table. To use\nthis statement, you must have some privilege for the table. This\nstatement also works with views.\nSHOW CREATE TABLE quotes table and column names according to the value\nof the sql_quote_show_create option. See\nhttp://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-create-table.html\n\n','mysql> SHOW CREATE TABLE t\\G\n*************************** 1. row ***************************\n       Table: t\nCreate Table: CREATE TABLE `t` (\n  `id` int(11) NOT NULL AUTO_INCREMENT,\n  `s` char(60) DEFAULT NULL,\n  PRIMARY KEY (`id`)\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n','http://dev.mysql.com/doc/refman/5.7/en/show-create-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (178,28,'DUAL','You are permitted to specify DUAL as a dummy table name in situations\nwhere no tables are referenced:\n\nmysql> SELECT 1 + 1 FROM DUAL;\n        -> 2\n\nDUAL is purely for the convenience of people who require that all\nSELECT statements should have FROM and possibly other clauses. MySQL\nmay ignore the clauses. MySQL does not require FROM DUAL if no tables\nare referenced.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/select.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/select.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (179,38,'INSTR','Syntax:\nINSTR(str,substr)\n\nReturns the position of the first occurrence of substring substr in\nstring str. This is the same as the two-argument form of LOCATE(),\nexcept that the order of the arguments is reversed.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT INSTR(\'foobarbar\', \'bar\');\n        -> 4\nmysql> SELECT INSTR(\'xbar\', \'foobar\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (180,20,'>=','Syntax:\n>=\n\nGreater than or equal:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 2 >= 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (181,3,'EXP','Syntax:\nEXP(X)\n\nReturns the value of e (the base of natural logarithms) raised to the\npower of X. The inverse of this function is LOG() (using a single\nargument only) or LN().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT EXP(2);\n        -> 7.3890560989307\nmysql> SELECT EXP(-2);\n        -> 0.13533528323661\nmysql> SELECT EXP(0);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (182,37,'ST_ISSIMPLE','ST_IsSimple(g)\n\nReturns 1 if the geometry value g has no anomalous geometric points,\nsuch as self-intersection or self-tangency. ST_IsSimple() returns 0 if\nthe argument is not simple, and NULL if it is NULL.\n\nThe description of each instantiable geometric class given earlier in\nthe chapter includes the specific conditions that cause an instance of\nthat class to be classified as not simple. (See [HELP Geometry\nhierarchy].)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (183,13,'POINTN','PointN(ls,N)\n\nST_PointN() and PointN() are synonyms. For more information, see the\ndescription of ST_PointN().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (184,38,'OCT','Syntax:\nOCT(N)\n\nReturns a string representation of the octal value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,8). Returns\nNULL if N is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT OCT(12);\n        -> \'14\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (185,32,'SYSDATE','Syntax:\nSYSDATE([fsp])\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context.\n\nIf the fsp argument is given to specify a fractional seconds precision\nfrom 0 to 6, the return value includes a fractional seconds part of\nthat many digits. Before 5.6.4, any argument is ignored.\n\nSYSDATE() returns the time at which it executes. This differs from the\nbehavior for NOW(), which returns a constant time that indicates the\ntime at which the statement began to execute. (Within a stored function\nor trigger, NOW() returns the time at which the function or triggering\nstatement began to execute.)\n\nmysql> SELECT NOW(), SLEEP(2), NOW();\n+---------------------+----------+---------------------+\n| NOW()               | SLEEP(2) | NOW()               |\n+---------------------+----------+---------------------+\n| 2006-04-12 13:47:36 |        0 | 2006-04-12 13:47:36 |\n+---------------------+----------+---------------------+\n\nmysql> SELECT SYSDATE(), SLEEP(2), SYSDATE();\n+---------------------+----------+---------------------+\n| SYSDATE()           | SLEEP(2) | SYSDATE()           |\n+---------------------+----------+---------------------+\n| 2006-04-12 13:47:44 |        0 | 2006-04-12 13:47:46 |\n+---------------------+----------+---------------------+\n\nIn addition, the SET TIMESTAMP statement affects the value returned by\nNOW() but not by SYSDATE(). This means that timestamp settings in the\nbinary log have no effect on invocations of SYSDATE().\n\nBecause SYSDATE() can return different values even within the same\nstatement, and is not affected by SET TIMESTAMP, it is nondeterministic\nand therefore unsafe for replication if statement-based binary logging\nis used. If that is a problem, you can use row-based logging.\n\nAlternatively, you can use the --sysdate-is-now option to cause\nSYSDATE() to be an alias for NOW(). This works if the option is used on\nboth the master and the slave.\n\nThe nondeterministic nature of SYSDATE() also means that indexes cannot\nbe used for evaluating expressions that refer to it.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (186,5,'UNINSTALL PLUGIN','Syntax:\nUNINSTALL PLUGIN plugin_name\n\nThis statement removes an installed server plugin. It requires the\nDELETE privilege for the mysql.plugin table.\n\nplugin_name must be the name of some plugin that is listed in the\nmysql.plugin table. The server executes the plugin\'s deinitialization\nfunction and removes the row for the plugin from the mysql.plugin\ntable, so that subsequent server restarts will not load and initialize\nthe plugin. UNINSTALL PLUGIN does not remove the plugin\'s shared\nlibrary file.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/uninstall-plugin.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/uninstall-plugin.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (187,33,'ASBINARY','AsBinary(g), AsWKB(g)\n\nST_AsBinary(), ST_AsWKB(), AsBinary(), and AsWKB() are synonyms. For\nmore information, see the description of ST_AsBinary().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-format-conversion-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-format-conversion-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (188,33,'ST_MLINEFROMWKB','ST_MLineFromWKB(wkb[,srid]), ST_MultiLineStringFromWKB(wkb[,srid])\n\nConstructs a MultiLineString value using its WKB representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (189,27,'SHOW TABLES','Syntax:\nSHOW [FULL] TABLES [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TABLES lists the non-TEMPORARY tables in a given database. You can\nalso get this list using the mysqlshow db_name command. The LIKE\nclause, if present, indicates which table names to match. The WHERE\nclause can be given to select rows using more general conditions, as\ndiscussed in http://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nMatching performed by the LIKE clause is dependent on the setting of\nthe lower_case_table_names system variable.\n\nThis statement also lists any views in the database. The FULL modifier\nis supported such that SHOW FULL TABLES displays a second output\ncolumn. Values for the second column are BASE TABLE for a table and\nVIEW for a view.\n\nIf you have no privileges for a base table or view, it does not show up\nin the output from SHOW TABLES or mysqlshow db_name.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-tables.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (190,32,'MAKEDATE','Syntax:\nMAKEDATE(year,dayofyear)\n\nReturns a date, given year and day-of-year values. dayofyear must be\ngreater than 0 or the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT MAKEDATE(2011,31), MAKEDATE(2011,32);\n        -> \'2011-01-31\', \'2011-02-01\'\nmysql> SELECT MAKEDATE(2011,365), MAKEDATE(2014,365);\n        -> \'2011-12-31\', \'2014-12-31\'\nmysql> SELECT MAKEDATE(2011,0);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (191,38,'BINARY OPERATOR','Syntax:\nBINARY\n\nThe BINARY operator casts the string following it to a binary string.\nThis is an easy way to force a column comparison to be done byte by\nbyte rather than character by character. This causes the comparison to\nbe case sensitive even if the column is not defined as BINARY or BLOB.\nBINARY also causes trailing spaces to be significant.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/cast-functions.html\n\n','mysql> SELECT \'a\' = \'A\';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'A\';\n        -> 0\nmysql> SELECT \'a\' = \'a \';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'a \';\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/cast-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (192,7,'MBROVERLAPS','MBROverlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\nthe two geometries g1 and g2 overlap. The term spatially overlaps is\nused if two geometries intersect and their intersection results in a\ngeometry of the same dimension but not equal to either of the given\ngeometries.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (193,33,'ST_LINEFROMWKB','ST_LineFromWKB(wkb[,srid]), ST_LineStringFromWKB(wkb[,srid])\n\nConstructs a LineString value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (194,7,'ASYMMETRIC_DERIVE','Syntax:\nASYMMETRIC_DERIVE(pub_key_str, priv_key_str)\n\nDerives a symmetric key using the private key of one party and the\npublic key of another, and returns the resulting key as a binary\nstring. If key derivation fails, the result is NULL.\n\npub_key_str and priv_key_str must be valid key strings in PEM format.\nThey must be created using the DH algorithm.\n\nSuppose that you have two pairs of public and private keys:\n\nSET @dhp = CREATE_DH_PARAMETERS(1024);\nSET @priv1 = CREATE_ASYMMETRIC_PRIV_KEY(\'DH\', @dhp);\nSET @pub1 = CREATE_ASYMMETRIC_PUB_KEY(\'DH\', @priv1);\nSET @priv2 = CREATE_ASYMMETRIC_PRIV_KEY(\'DH\', @dhp);\nSET @pub2 = CREATE_ASYMMETRIC_PUB_KEY(\'DH\', @priv2);\n\nSuppose further that you use the private key from one pair and the\npublic key from the other pair to create a symmetric key string. Then\nthis symmetric key identity relationship holds:\n\nASYMMETRIC_DERIVE(@pub1, @priv2) = ASYMMETRIC_DERIVE(@pub2, @priv1)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (195,28,'INSERT SELECT','Syntax:\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name \n    [PARTITION (partition_name,...)]\n    [(col_name,...)]\n    SELECT ...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nWith INSERT ... SELECT, you can quickly insert many rows into a table\nfrom one or many tables. For example:\n\nINSERT INTO tbl_temp2 (fld_id)\n  SELECT tbl_temp1.fld_order_id\n  FROM tbl_temp1 WHERE tbl_temp1.fld_order_id > 100;\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/insert-select.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/insert-select.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (196,40,'CREATE PROCEDURE','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    PROCEDURE sp_name ([proc_parameter[,...]])\n    [characteristic ...] routine_body\n\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    FUNCTION sp_name ([func_parameter[,...]])\n    RETURNS type\n    [characteristic ...] routine_body\n\nproc_parameter:\n    [ IN | OUT | INOUT ] param_name type\n\nfunc_parameter:\n    param_name type\n\ntype:\n    Any valid MySQL data type\n\ncharacteristic:\n    COMMENT \'string\'\n  | LANGUAGE SQL\n  | [NOT] DETERMINISTIC\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n\nroutine_body:\n    Valid SQL routine statement\n\nThese statements create stored routines. By default, a routine is\nassociated with the default database. To associate the routine\nexplicitly with a given database, specify the name as db_name.sp_name\nwhen you create it.\n\nThe CREATE FUNCTION statement is also used in MySQL to support UDFs\n(user-defined functions). See\nhttp://dev.mysql.com/doc/refman/5.7/en/adding-functions.html. A UDF can\nbe regarded as an external stored function. Stored functions share\ntheir namespace with UDFs. See\nhttp://dev.mysql.com/doc/refman/5.7/en/function-resolution.html, for\nthe rules describing how the server interprets references to different\nkinds of functions.\n\nTo invoke a stored procedure, use the CALL statement (see [HELP CALL]).\nTo invoke a stored function, refer to it in an expression. The function\nreturns a value during expression evaluation.\n\nCREATE PROCEDURE and CREATE FUNCTION require the CREATE ROUTINE\nprivilege. They might also require the SUPER privilege, depending on\nthe DEFINER value, as described later in this section. If binary\nlogging is enabled, CREATE FUNCTION might require the SUPER privilege,\nas described in\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-programs-logging.html.\n\nBy default, MySQL automatically grants the ALTER ROUTINE and EXECUTE\nprivileges to the routine creator. This behavior can be changed by\ndisabling the automatic_sp_privileges system variable. See\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-routines-privileges.html.\n\nThe DEFINER and SQL SECURITY clauses specify the security context to be\nused when checking access privileges at routine execution time, as\ndescribed later in this section.\n\nIf the routine name is the same as the name of a built-in SQL function,\na syntax error occurs unless you use a space between the name and the\nfollowing parenthesis when defining the routine or invoking it later.\nFor this reason, avoid using the names of existing SQL functions for\nyour own stored routines.\n\nThe IGNORE_SPACE SQL mode applies to built-in functions, not to stored\nroutines. It is always permissible to have spaces after a stored\nroutine name, regardless of whether IGNORE_SPACE is enabled.\n\nThe parameter list enclosed within parentheses must always be present.\nIf there are no parameters, an empty parameter list of () should be\nused. Parameter names are not case sensitive.\n\nEach parameter is an IN parameter by default. To specify otherwise for\na parameter, use the keyword OUT or INOUT before the parameter name.\n\n*Note*: Specifying a parameter as IN, OUT, or INOUT is valid only for a\nPROCEDURE. For a FUNCTION, parameters are always regarded as IN\nparameters.\n\nAn IN parameter passes a value into a procedure. The procedure might\nmodify the value, but the modification is not visible to the caller\nwhen the procedure returns. An OUT parameter passes a value from the\nprocedure back to the caller. Its initial value is NULL within the\nprocedure, and its value is visible to the caller when the procedure\nreturns. An INOUT parameter is initialized by the caller, can be\nmodified by the procedure, and any change made by the procedure is\nvisible to the caller when the procedure returns.\n\nFor each OUT or INOUT parameter, pass a user-defined variable in the\nCALL statement that invokes the procedure so that you can obtain its\nvalue when the procedure returns. If you are calling the procedure from\nwithin another stored procedure or function, you can also pass a\nroutine parameter or local routine variable as an IN or INOUT\nparameter.\n\nRoutine parameters cannot be referenced in statements prepared within\nthe routine; see\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-program-restrictions.html\n.\n\nThe following example shows a simple stored procedure that uses an OUT\nparameter:\n\nmysql> delimiter //\n\nmysql> CREATE PROCEDURE simpleproc (OUT param1 INT)\n    -> BEGIN\n    ->   SELECT COUNT(*) INTO param1 FROM t;\n    -> END//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> delimiter ;\n\nmysql> CALL simpleproc(@a);\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @a;\n+------+\n| @a   |\n+------+\n| 3    |\n+------+\n1 row in set (0.00 sec)\n\nThe example uses the mysql client delimiter command to change the\nstatement delimiter from ; to // while the procedure is being defined.\nThis enables the ; delimiter used in the procedure body to be passed\nthrough to the server rather than being interpreted by mysql itself.\nSee\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-programs-defining.html.\n\nThe RETURNS clause may be specified only for a FUNCTION, for which it\nis mandatory. It indicates the return type of the function, and the\nfunction body must contain a RETURN value statement. If the RETURN\nstatement returns a value of a different type, the value is coerced to\nthe proper type. For example, if a function specifies an ENUM or SET\nvalue in the RETURNS clause, but the RETURN statement returns an\ninteger, the value returned from the function is the string for the\ncorresponding ENUM member of set of SET members.\n\nThe following example function takes a parameter, performs an operation\nusing an SQL function, and returns the result. In this case, it is\nunnecessary to use delimiter because the function definition contains\nno internal ; statement delimiters:\n\nmysql> CREATE FUNCTION hello (s CHAR(20))\nmysql> RETURNS CHAR(50) DETERMINISTIC\n    -> RETURN CONCAT(\'Hello, \',s,\'!\');\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT hello(\'world\');\n+----------------+\n| hello(\'world\') |\n+----------------+\n| Hello, world!  |\n+----------------+\n1 row in set (0.00 sec)\n\nParameter types and function return types can be declared to use any\nvalid data type. The COLLATE attribute can be used if preceded by the\nCHARACTER SET attribute.\n\nThe routine_body consists of a valid SQL routine statement. This can be\na simple statement such as SELECT or INSERT, or a compound statement\nwritten using BEGIN and END. Compound statements can contain\ndeclarations, loops, and other control structure statements. The syntax\nfor these statements is described in\nhttp://dev.mysql.com/doc/refman/5.7/en/sql-syntax-compound-statements.h\ntml.\n\nMySQL permits routines to contain DDL statements, such as CREATE and\nDROP. MySQL also permits stored procedures (but not stored functions)\nto contain SQL transaction statements such as COMMIT. Stored functions\nmay not contain statements that perform explicit or implicit commit or\nrollback. Support for these statements is not required by the SQL\nstandard, which states that each DBMS vendor may decide whether to\npermit them.\n\nStatements that return a result set can be used within a stored\nprocedure but not within a stored function. This prohibition includes\nSELECT statements that do not have an INTO var_list clause and other\nstatements such as SHOW, EXPLAIN, and CHECK TABLE. For statements that\ncan be determined at function definition time to return a result set, a\nNot allowed to return a result set from a function error occurs\n(ER_SP_NO_RETSET). For statements that can be determined only at\nruntime to return a result set, a PROCEDURE %s can\'t return a result\nset in the given context error occurs (ER_SP_BADSELECT).\n\nUSE statements within stored routines are not permitted. When a routine\nis invoked, an implicit USE db_name is performed (and undone when the\nroutine terminates). The causes the routine to have the given default\ndatabase while it executes. References to objects in databases other\nthan the routine default database should be qualified with the\nappropriate database name.\n\nFor additional information about statements that are not permitted in\nstored routines, see\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-program-restrictions.html\n.\n\nFor information about invoking stored procedures from within programs\nwritten in a language that has a MySQL interface, see [HELP CALL].\n\nMySQL stores the sql_mode system variable setting in effect when a\nroutine is created or altered, and always executes the routine with\nthis setting in force, regardless of the current server SQL mode when\nthe routine begins executing.\n\nThe switch from the SQL mode of the invoker to that of the routine\noccurs after evaluation of arguments and assignment of the resulting\nvalues to routine parameters. If you define a routine in strict SQL\nmode but invoke it in nonstrict mode, assignment of arguments to\nroutine parameters does not take place in strict mode. If you require\nthat expressions passed to a routine be assigned in strict SQL mode,\nyou should invoke the routine with strict mode in effect.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-procedure.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (197,24,'GET DIAGNOSTICS','Syntax:\nGET [CURRENT | STACKED] DIAGNOSTICS\n{\n    statement_information_item\n    [, statement_information_item] ... \n  | CONDITION condition_number\n    condition_information_item\n    [, condition_information_item] ...\n}\n\nstatement_information_item:\n    target = statement_information_item_name\n\ncondition_information_item:\n    target = condition_information_item_name\n\nstatement_information_item_name:\n    NUMBER\n  | ROW_COUNT\n\ncondition_information_item_name:\n    CLASS_ORIGIN\n  | SUBCLASS_ORIGIN\n  | RETURNED_SQLSTATE\n  | MESSAGE_TEXT\n  | MYSQL_ERRNO\n  | CONSTRAINT_CATALOG\n  | CONSTRAINT_SCHEMA\n  | CONSTRAINT_NAME\n  | CATALOG_NAME\n  | SCHEMA_NAME\n  | TABLE_NAME\n  | COLUMN_NAME\n  | CURSOR_NAME\n\ncondition_number, target:\n    (see following discussion)\n\nSQL statements produce diagnostic information that populates the\ndiagnostics area. The GET DIAGNOSTICS statement enables applications to\ninspect this information. (You can also use SHOW WARNINGS or SHOW\nERRORS to see conditions or errors.)\n\nNo special privileges are required to execute GET DIAGNOSTICS.\n\nThe keyword CURRENT means to retrieve information from the current\ndiagnostics area. The keyword STACKED means to retrieve information\nfrom the second diagnostics area, which is available only if the\ncurrent context is a condition handler. If neither keyword is given,\nthe default is to use the current diagnostics area.\n\nThe GET DIAGNOSTICS statement is typically used in a handler within a\nstored program. It is a MySQL extension that GET [CURRENT] DIAGNOSTICS\nis permitted outside handler context to check the execution of any SQL\nstatement. For example, if you invoke the mysql client program, you can\nenter these statements at the prompt:\n\nmysql> DROP TABLE test.no_such_table;\nERROR 1051 (42S02): Unknown table \'test.no_such_table\'\nmysql> GET DIAGNOSTICS CONDITION 1\n    ->   @p1 = RETURNED_SQLSTATE, @p2 = MESSAGE_TEXT;\nmysql> SELECT @p1, @p2;\n+-------+------------------------------------+\n| @p1   | @p2                                |\n+-------+------------------------------------+\n| 42S02 | Unknown table \'test.no_such_table\' |\n+-------+------------------------------------+\n\nThis extension applies only to the current diagnostics area. It does\nnot apply to the second diagnostics area because GET STACKED\nDIAGNOSTICS is permitted only if the current context is a condition\nhandler. If that is not the case, a GET STACKED DIAGNOSTICS when\nhandler not active error occurs.\n\nFor a description of the diagnostics area, see\nhttp://dev.mysql.com/doc/refman/5.7/en/diagnostics-area.html. Briefly,\nit contains two kinds of information:\n\no Statement information, such as the number of conditions that occurred\n  or the affected-rows count.\n\no Condition information, such as the error code and message. If a\n  statement raises multiple conditions, this part of the diagnostics\n  area has a condition area for each one. If a statement raises no\n  conditions, this part of the diagnostics area is empty.\n\nFor a statement that produces three conditions, the diagnostics area\ncontains statement and condition information like this:\n\nStatement information:\n  row count\n  ... other statement information items ...\nCondition area list:\n  Condition area 1:\n    error code for condition 1\n    error message for condition 1\n    ... other condition information items ...\n  Condition area 2:\n    error code for condition 2:\n    error message for condition 2\n    ... other condition information items ...\n  Condition area 3:\n    error code for condition 3\n    error message for condition 3\n    ... other condition information items ...\n\nGET DIAGNOSTICS can obtain either statement or condition information,\nbut not both in the same statement:\n\no To obtain statement information, retrieve the desired statement items\n  into target variables. This instance of GET DIAGNOSTICS assigns the\n  number of available conditions and the rows-affected count to the\n  user variables @p1 and @p2:\n\nGET DIAGNOSTICS @p1 = NUMBER, @p2 = ROW_COUNT;\n\no To obtain condition information, specify the condition number and\n  retrieve the desired condition items into target variables. This\n  instance of GET DIAGNOSTICS assigns the SQLSTATE value and error\n  message to the user variables @p3 and @p4:\n\nGET DIAGNOSTICS CONDITION 1\n  @p3 = RETURNED_SQLSTATE, @p4 = MESSAGE_TEXT;\n\nThe retrieval list specifies one or more target = item_name\nassignments, separated by commas. Each assignment names a target\nvariable and either a statement_information_item_name or\ncondition_information_item_name designator, depending on whether the\nstatement retrieves statement or condition information.\n\nValid target designators for storing item information can be stored\nprocedure or function parameters, stored program local variables\ndeclared with DECLARE, or user-defined variables.\n\nValid condition_number designators can be stored procedure or function\nparameters, stored program local variables declared with DECLARE,\nuser-defined variables, system variables, or literals. A character\nliteral may include a _charset introducer. A warning occurs if the\ncondition number is not in the range from 1 to the number of condition\nareas that have information. In this case, the warning is added to the\ndiagnostics area without clearing it.\n\nWhen a condition occurs, MySQL does not populate all condition items\nrecognized by GET DIAGNOSTICS. For example:\n\nmysql> GET DIAGNOSTICS CONDITION 1\n    ->   @p5 = SCHEMA_NAME, @p6 = TABLE_NAME;\nmysql> SELECT @p5, @p6;\n+------+------+\n| @p5  | @p6  |\n+------+------+\n|      |      |\n+------+------+\n\nIn standard SQL, if there are multiple conditions, the first condition\nrelates to the SQLSTATE value returned for the previous SQL statement.\nIn MySQL, this is not guaranteed. To get the main error, you cannot do\nthis:\n\nGET DIAGNOSTICS CONDITION 1 @errno = MYSQL_ERRNO;\n\nInstead, retrieve the condition count first, then use it to specify\nwhich condition number to inspect:\n\nGET DIAGNOSTICS @cno = NUMBER;\nGET DIAGNOSTICS CONDITION @cno @errno = MYSQL_ERRNO;\n\nFor information about permissible statement and condition information\nitems, and which ones are populated when a condition occurs, see\nhttp://dev.mysql.com/doc/refman/5.7/en/diagnostics-area.html#diagnostic\ns-area-information-items.\n\nHere is an example that uses GET DIAGNOSTICS and an exception handler\nin stored procedure context to assess the outcome of an insert\noperation. If the insert was successful, the procedure uses GET\nDIAGNOSTICS to get the rows-affected count. This shows that you can use\nGET DIAGNOSTICS multiple times to retrieve information about a\nstatement as long as the current diagnostics area has not been cleared.\n\nCREATE PROCEDURE do_insert(value INT)\nBEGIN\n  -- Declare variables to hold diagnostics area information\n  DECLARE code CHAR(5) DEFAULT \'00000\';\n  DECLARE msg TEXT;\n  DECLARE rows INT;\n  DECLARE result TEXT;\n  -- Declare exception handler for failed insert\n  DECLARE CONTINUE HANDLER FOR SQLEXCEPTION\n    BEGIN\n      GET DIAGNOSTICS CONDITION 1\n        code = RETURNED_SQLSTATE, msg = MESSAGE_TEXT;\n    END;\n\n  -- Perform the insert\n  INSERT INTO t1 (int_col) VALUES(value);\n  -- Check whether the insert was successful\n  IF code = \'00000\' THEN\n    GET DIAGNOSTICS rows = ROW_COUNT;\n    SET result = CONCAT(\'insert succeeded, row count = \',rows);\n  ELSE\n    SET result = CONCAT(\'insert failed, error = \',code,\', message = \',msg);\n  END IF;\n  -- Say what happened\n  SELECT result;\nEND;\n\nSuppose that t1.int_col is an integer column that is declared as NOT\nNULL. The procedure produces these results when invoked to insert\nnon-NULL and NULL values, respectively:\n\nmysql> CALL do_insert(1);\n+---------------------------------+\n| result                          |\n+---------------------------------+\n| insert succeeded, row count = 1 |\n+---------------------------------+\n\nmysql> CALL do_insert(NULL);\n+-------------------------------------------------------------------------+\n| result                                                                  |\n+-------------------------------------------------------------------------+\n| insert failed, error = 23000, message = Column \'int_col\' cannot be null |\n+-------------------------------------------------------------------------+\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/get-diagnostics.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/get-diagnostics.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (198,38,'NOT REGEXP','Syntax:\nexpr NOT REGEXP pat, expr NOT RLIKE pat\n\nThis is the same as NOT (expr REGEXP pat).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/regexp.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/regexp.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (199,24,'LEAVE','Syntax:\nLEAVE label\n\nThis statement is used to exit the flow control construct that has the\ngiven label. If the label is for the outermost stored program block,\nLEAVE exits the program.\n\nLEAVE can be used within BEGIN ... END or loop constructs (LOOP,\nREPEAT, WHILE).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/leave.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/leave.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (200,7,'ST_GEOHASH','ST_GeoHash(longitude, latitude, max_length), ST_GeoHash(point,\nmax_length)\n\nReturns a geohash string in the connection character set and collation.\nThe result is NULL if any argument is NULL. An error occurs if any\nargument is invalid.\n\nFor the first syntax, the longitude must be a number in the range\n[−180, 180], and the latitude must be a number in the range [−90,\n90]. For the second syntax, a POINT value is required, where the X and\nY coordinates are in the valid ranges for longitude and latitude,\nrespectively.\n\nThe resulting string is no longer than max_length characters, which has\nan upper limit of 100. The string might be shorter than max_length\ncharacters because the algorithm that creates the geohash value\ncontinues until it has created a string that is either an exact\nrepresentation of the location or max_length characters, whichever\ncomes first.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-geohash-functions.html\n\n','mysql> SELECT ST_GeoHash(180,0,10), ST_GeoHash(-180,-90,15);\n+----------------------+-------------------------+\n| ST_GeoHash(180,0,10) | ST_GeoHash(-180,-90,15) |\n+----------------------+-------------------------+\n| xbpbpbpbpb           | 000000000000000         |\n+----------------------+-------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-geohash-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (201,20,'NOT IN','Syntax:\nexpr NOT IN (value,...)\n\nThis is the same as NOT (expr IN (value,...)).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (202,11,'X','X(p)\n\nST_X() and X() are synonyms. For more information, see the description\nof ST_X().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-point-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-point-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (203,17,'FOUND_ROWS','Syntax:\nFOUND_ROWS()\n\nA SELECT statement may include a LIMIT clause to restrict the number of\nrows the server returns to the client. In some cases, it is desirable\nto know how many rows the statement would have returned without the\nLIMIT, but without running the statement again. To obtain this row\ncount, include a SQL_CALC_FOUND_ROWS option in the SELECT statement,\nand then invoke FOUND_ROWS() afterward:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> SELECT SQL_CALC_FOUND_ROWS * FROM tbl_name\n    -> WHERE id > 100 LIMIT 10;\nmysql> SELECT FOUND_ROWS();\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (204,31,'CROSSES','Crosses(g1,g2)\n\nST_Crosses() and Crosses() are synonyms. For more information, see the\ndescription of ST_Crosses().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (205,26,'ST_UNION','ST_Union(g1, g2)\n\nReturns a geometry that represents the point set union of the geometry\nvalues g1 and g2.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html\n\n','mysql> SET @g1 = ST_GeomFromText(\'LineString(1 1, 3 3)\');\nmysql> SET @g2 = ST_GeomFromText(\'LineString(1 3, 3 1)\');\nmysql> SELECT ST_AsText(ST_Union(@g1, @g2));\n+--------------------------------------+\n| ST_AsText(ST_Union(@g1, @g2))        |\n+--------------------------------------+\n| MULTILINESTRING((1 1,3 3),(1 3,3 1)) |\n+--------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (206,16,'BIT_XOR','Syntax:\nBIT_XOR(expr)\n\nReturns the bitwise XOR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (207,7,'->>','column->>path\n\nThis is an improved, unquoting extraction operator available in MySQL\n5.7.13 and later. Whereas the -> operator simply extracts a value, the\n->-> operator in addition unquotes the extracted result. In other\nwords, given a JSON column value column and a path expression path, the\nfollowing three expressions return the same value:\n\no JSON_UNQUOTE( JSON_EXTRACT(column, path) )\n\no JSON_UNQUOTE(column -> path)\n\no column->>path\n\nThe ->> operator can be used wherever JSON_UNQUOTE(JSON_EXTRACT())\nwould be allowed. This includes (but is not limited to) SELECT lists,\nWHERE and HAVING clauses, and ORDER BY and GROUP BY clauses.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html\n\n','mysql> SELECT * FROM jemp WHERE g > 2;\n+-------------------------------+------+\n| c                             | g    |\n+-------------------------------+------+\n| {"id": "3", "name": "Barney"} |    3 |\n| {"id": "4", "name": "Betty"}  |    4 |\n+-------------------------------+------+\n2 rows in set (0.01 sec)\n\nmysql> SELECT c->\'$.name\' AS name     \n    ->     FROM jemp WHERE g > 2;\n+----------+\n| name     |\n+----------+\n| "Barney" |\n| "Betty"  |\n+----------+\n2 rows in set (0.00 sec)\n\nmysql> SELECT JSON_UNQUOTE(c->\'$.name\') AS name\n    ->     FROM jemp WHERE g > 2;\n+--------+\n| name   |\n+--------+\n| Barney |\n| Betty  |\n+--------+\n2 rows in set (0.00 sec)\n\nmysql> SELECT c->>\'$.name\' AS name\n    ->     FROM jemp WHERE g > 2;\n+--------+\n| name   |\n+--------+\n| Barney |\n| Betty  |\n+--------+\n2 rows in set (0.00 sec)\n\nmysql> CREATE TABLE tj10 (a JSON, b INT);\nQuery OK, 0 rows affected (0.26 sec)\n\nmysql> INSERT INTO tj10 VALUES \n    ->     (\'[3,10,5,"x",44]\', 33), \n    ->     (\'[3,10,5,17,[22,"y",66]]\', 0);\nQuery OK, 2 rows affected (0.04 sec)\nRecords: 2  Duplicates: 0  Warnings: 0\n\nmysql> SELECT a->"$[3]", a->"$[4][1]" FROM tj10;\n+-----------+--------------+\n| a->"$[3]" | a->"$[4][1]" |\n+-----------+--------------+\n| "x"       | NULL         |\n| 17        | "y"          |\n+-----------+--------------+\n2 rows in set (0.00 sec)\n\nmysql> SELECT a->>"$[3]", a->>"$[4][1]" FROM tj10;\n+------------+---------------+\n| a->>"$[3]" | a->>"$[4][1]" |\n+------------+---------------+\n| x          | NULL          |\n| 17         | y             |\n+------------+---------------+\n2 rows in set (0.00 sec)\n\nmysql> EXPLAIN SELECT c->>\'$.name\' AS name     \n    ->     FROM jemp WHERE g > 2\\G\n*************************** 1. row ***************************\n           id: 1\n  select_type: SIMPLE\n        table: jemp\n   partitions: NULL\n         type: range\npossible_keys: i\n          key: i\n      key_len: 5\n          ref: NULL\n         rows: 2\n     filtered: 100.00\n        Extra: Using where\n1 row in set, 1 warning (0.00 sec)\n\nmysql> SHOW WARNINGS\\G\n*************************** 1. row ***************************\n  Level: Note\n   Code: 1003\nMessage: /* select#1 */ select\njson_unquote(json_extract(`jtest`.`jemp`.`c`,\'$.name\')) AS `name` from\n`jtest`.`jemp` where (`jtest`.`jemp`.`g` > 2)\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (208,27,'FLUSH','Syntax:\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL]\n    flush_option [, flush_option] ...\n\nThe FLUSH statement has several variant forms that clear or reload\nvarious internal caches, flush tables, or acquire locks. To execute\nFLUSH, you must have the RELOAD privilege. Specific flush options might\nrequire additional privileges, as described later.\n\nBy default, the server writes FLUSH statements to the binary log so\nthat they replicate to replication slaves. To suppress logging, specify\nthe optional NO_WRITE_TO_BINLOG keyword or its alias LOCAL.\n\n*Note*: FLUSH LOGS, FLUSH TABLES WITH READ LOCK (with or without a\ntable list), and FLUSH TABLES tbl_name ... FOR EXPORT are not written\nto the binary log in any case because they would cause problems if\nreplicated to a slave.\n\nSending a SIGHUP signal to the server causes several flush operations\nto occur that are similar to various forms of the FLUSH statement. See\nhttp://dev.mysql.com/doc/refman/5.7/en/server-signal-response.html.\n\nThe FLUSH statement causes an implicit commit. See\nhttp://dev.mysql.com/doc/refman/5.7/en/implicit-commit.html.\n\nThe RESET statement is similar to FLUSH. See [HELP RESET], for\ninformation about using the RESET statement with replication.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/flush.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/flush.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (209,24,'BEGIN END','Syntax:\n[begin_label:] BEGIN\n    [statement_list]\nEND [end_label]\n\nBEGIN ... END syntax is used for writing compound statements, which can\nappear within stored programs (stored procedures and functions,\ntriggers, and events). A compound statement can contain multiple\nstatements, enclosed by the BEGIN and END keywords. statement_list\nrepresents a list of one or more statements, each terminated by a\nsemicolon (;) statement delimiter. The statement_list itself is\noptional, so the empty compound statement (BEGIN END) is legal.\n\nBEGIN ... END blocks can be nested.\n\nUse of multiple statements requires that a client is able to send\nstatement strings containing the ; statement delimiter. In the mysql\ncommand-line client, this is handled with the delimiter command.\nChanging the ; end-of-statement delimiter (for example, to //) permit ;\nto be used in a program body. For an example, see\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-programs-defining.html.\n\nA BEGIN ... END block can be labeled. See [HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/begin-end.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/begin-end.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (210,27,'SHOW PROCEDURE STATUS','Syntax:\nSHOW PROCEDURE STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement is a MySQL extension. It returns characteristics of a\nstored procedure, such as the database, name, type, creator, creation\nand modification dates, and character set information. A similar\nstatement, SHOW FUNCTION STATUS, displays information about stored\nfunctions (see [HELP SHOW FUNCTION STATUS]).\n\nThe LIKE clause, if present, indicates which procedure or function\nnames to match. The WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-procedure-status.html\n\n','mysql> SHOW PROCEDURE STATUS LIKE \'sp1\'\\G\n*************************** 1. row ***************************\n                  Db: test\n                Name: sp1\n                Type: PROCEDURE\n             Definer: testuser@localhost\n            Modified: 2004-08-03 15:29:37\n             Created: 2004-08-03 15:29:37\n       Security_type: DEFINER\n             Comment:\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n','http://dev.mysql.com/doc/refman/5.7/en/show-procedure-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (211,16,'STDDEV_POP','Syntax:\nSTDDEV_POP(expr)\n\nReturns the population standard deviation of expr (the square root of\nVAR_POP()). You can also use STD() or STDDEV(), which are equivalent\nbut not standard SQL.\n\nSTDDEV_POP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (212,27,'SHOW CHARACTER SET','Syntax:\nSHOW CHARACTER SET\n    [LIKE \'pattern\' | WHERE expr]\n\nThe SHOW CHARACTER SET statement shows all available character sets.\nThe LIKE clause, if present, indicates which character set names to\nmatch. The WHERE clause can be given to select rows using more general\nconditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html. For example:\n\nmysql> SHOW CHARACTER SET LIKE \'latin%\';\n+---------+-----------------------------+-------------------+--------+\n| Charset | Description                 | Default collation | Maxlen |\n+---------+-----------------------------+-------------------+--------+\n| latin1  | cp1252 West European        | latin1_swedish_ci |      1 |\n| latin2  | ISO 8859-2 Central European | latin2_general_ci |      1 |\n| latin5  | ISO 8859-9 Turkish          | latin5_turkish_ci |      1 |\n| latin7  | ISO 8859-13 Baltic          | latin7_general_ci |      1 |\n+---------+-----------------------------+-------------------+--------+\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-character-set.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-character-set.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (213,31,'INTERSECTS','Intersects(g1,g2)\n\nMBRIntersects() and Intersects() are synonyms. For more information,\nsee the description of MBRIntersects().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (214,24,'LOOP','Syntax:\n[begin_label:] LOOP\n    statement_list\nEND LOOP [end_label]\n\nLOOP implements a simple loop construct, enabling repeated execution of\nthe statement list, which consists of one or more statements, each\nterminated by a semicolon (;) statement delimiter. The statements\nwithin the loop are repeated until the loop is terminated. Usually,\nthis is accomplished with a LEAVE statement. Within a stored function,\nRETURN can also be used, which exits the function entirely.\n\nNeglecting to include a loop-termination statement results in an\ninfinite loop.\n\nA LOOP statement can be labeled. For the rules regarding label use, see\n[HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/loop.html\n\n','CREATE PROCEDURE doiterate(p1 INT)\nBEGIN\n  label1: LOOP\n    SET p1 = p1 + 1;\n    IF p1 < 10 THEN\n      ITERATE label1;\n    END IF;\n    LEAVE label1;\n  END LOOP label1;\n  SET @x = p1;\nEND;\n','http://dev.mysql.com/doc/refman/5.7/en/loop.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (215,20,'GREATEST','Syntax:\nGREATEST(value1,value2,...)\n\nWith two or more arguments, returns the largest (maximum-valued)\nargument. The arguments are compared using the same rules as for\nLEAST().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT GREATEST(2,0);\n        -> 2\nmysql> SELECT GREATEST(34.0,3.0,5.0,767.0);\n        -> 767.0\nmysql> SELECT GREATEST(\'B\',\'A\',\'C\');\n        -> \'C\'\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (216,40,'ALTER INSTANCE','Syntax:\nALTER INSTANCE ROTATE INNODB MASTER KEY\n\nALTER INSTANCE, introduced in MySQL 5.7.11, defines actions applicable\nto a MySQL server instance. Using ALTER INSTANCE requires the SUPER\nprivilege.\n\nThe ALTER INSTANCE ROTATE INNODB MASTER KEY statement is used to rotate\nthe master encryption key used for InnoDB tablespace encryption. A\nkeyring plugin must be loaded to use this statement. For information\nabout keyring plugins, see\nhttp://dev.mysql.com/doc/refman/5.7/en/keyring.html.\n\nALTER INSTANCE ROTATE INNODB MASTER KEY supports concurrent DML.\nHowever, it cannot be run concurrently with CREATE TABLE ... ENCRYPTION\nor ALTER TABLE ... ENCRYPTION operations, and locks are taken to\nprevent conflicts that could arise from concurrent execution of these\nstatements. If one of the conflicting statements is running, it must\ncomplete before another can proceed.\n\nALTER INSTANCE actions are written to the binary log so that they can\nbe executed on replicated servers.\n\nFor additional ALTER INSTANCE ROTATE INNODB MASTER KEY usage\ninformation, see\nhttp://dev.mysql.com/doc/refman/5.7/en/innodb-tablespace-encryption.htm\nl. For information about keyring plugins, see\nhttp://dev.mysql.com/doc/refman/5.7/en/keyring.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-instance.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/alter-instance.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (217,31,'ST_CONTAINS','ST_Contains(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 completely contains g2. This\ntests the opposite relationship as ST_Within().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (218,16,'BIT_AND','Syntax:\nBIT_AND(expr)\n\nReturns the bitwise AND of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (219,32,'SECOND','Syntax:\nSECOND(time)\n\nReturns the second for time, in the range 0 to 59.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT SECOND(\'10:05:03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (220,7,'MBRCONTAINS','MBRContains(g1,g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\ncontains the minimum bounding rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html\n\n','mysql> SET @g1 = ST_GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = ST_GeomFromText(\'Point(1 1)\');\nmysql> SELECT MBRContains(@g1,@g2), MBRWithin(@g2,@g1);\n+----------------------+--------------------+\n| MBRContains(@g1,@g2) | MBRWithin(@g2,@g1) |\n+----------------------+--------------------+\n|                    1 |                  1 |\n+----------------------+--------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (221,14,'RELEASE_ALL_LOCKS','Syntax:\nRELEASE_ALL_LOCKS()\n\nReleases all named locks held by the current session and returns the\nnumber of locks released (0 if there were none)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (222,3,'COT','Syntax:\nCOT(X)\n\nReturns the cotangent of X.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT COT(12);\n        -> -1.5726734063977\nmysql> SELECT COT(0);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (223,27,'SHOW CREATE EVENT','Syntax:\nSHOW CREATE EVENT event_name\n\nThis statement displays the CREATE EVENT statement needed to re-create\na given event. It requires the EVENT privilege for the database from\nwhich the event is to be shown. For example (using the same event\ne_daily defined and then altered in [HELP SHOW EVENTS]):\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-create-event.html\n\n','mysql> SHOW CREATE EVENT test.e_daily\\G\n*************************** 1. row ***************************\n               Event: e_daily\n            sql_mode:\n           time_zone: SYSTEM\n        Create Event: CREATE EVENT `e_daily`\n                        ON SCHEDULE EVERY 1 DAY\n                        STARTS CURRENT_TIMESTAMP + INTERVAL 6 HOUR\n                        ON COMPLETION NOT PRESERVE\n                        ENABLE\n                        COMMENT \'Saves total number of sessions then\n                                clears the table each day\'\n                        DO BEGIN\n                          INSERT INTO site_activity.totals (time, total)\n                            SELECT CURRENT_TIMESTAMP, COUNT(*)\n                            FROM site_activity.sessions;\n                          DELETE FROM site_activity.sessions;\n                        END\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n','http://dev.mysql.com/doc/refman/5.7/en/show-create-event.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (224,15,'OR','Syntax:\nOR, ||\n\nLogical OR. When both operands are non-NULL, the result is 1 if any\noperand is nonzero, and 0 otherwise. With a NULL operand, the result is\n1 if the other operand is nonzero, and NULL otherwise. If both operands\nare NULL, the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/logical-operators.html\n\n','mysql> SELECT 1 OR 1;\n        -> 1\nmysql> SELECT 1 OR 0;\n        -> 1\nmysql> SELECT 0 OR 0;\n        -> 0\nmysql> SELECT 0 OR NULL;\n        -> NULL\nmysql> SELECT 1 OR NULL;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/logical-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (225,38,'LOAD_FILE','Syntax:\nLOAD_FILE(file_name)\n\nReads the file and returns the file contents as a string. To use this\nfunction, the file must be located on the server host, you must specify\nthe full path name to the file, and you must have the FILE privilege.\nThe file must be readable by all and its size less than\nmax_allowed_packet bytes. If the secure_file_priv system variable is\nset to a nonempty directory name, the file to be loaded must be located\nin that directory.\n\nIf the file does not exist or cannot be read because one of the\npreceding conditions is not satisfied, the function returns NULL.\n\nThe character_set_filesystem system variable controls interpretation of\nfile names that are given as literal strings.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> UPDATE t\n            SET blob_col=LOAD_FILE(\'/tmp/picture\')\n            WHERE id=1;\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (226,4,'POINTFROMTEXT','PointFromText(wkt[,srid])\n\nST_PointFromText() and PointFromText() are synonyms. For more\ninformation, see the description of ST_PointFromText().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (227,32,'DATE_FORMAT','Syntax:\nDATE_FORMAT(date,format)\n\nFormats the date value according to the format string.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_FORMAT(\'2009-10-04 22:23:00\', \'%W %M %Y\');\n        -> \'Sunday October 2009\'\nmysql> SELECT DATE_FORMAT(\'2007-10-04 22:23:00\', \'%H:%i:%s\');\n        -> \'22:23:00\'\nmysql> SELECT DATE_FORMAT(\'1900-10-04 22:23:00\',\n    ->                 \'%D %y %a %d %m %b %j\');\n        -> \'4th 00 Thu 04 10 Oct 277\'\nmysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\',\n    ->                 \'%H %k %I %r %T %S %w\');\n        -> \'22 22 10 10:23:00 PM 22:23:00 00 6\'\nmysql> SELECT DATE_FORMAT(\'1999-01-01\', \'%X %V\');\n        -> \'1998 52\'\nmysql> SELECT DATE_FORMAT(\'2006-06-00\', \'%d\');\n        -> \'00\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (228,32,'YEAR','Syntax:\nYEAR(date)\n\nReturns the year for date, in the range 1000 to 9999, or 0 for the\n"zero" date.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT YEAR(\'1987-01-01\');\n        -> 1987\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (229,20,'IS NULL','Syntax:\nIS NULL\n\nTests whether a value is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n        -> 0, 0, 1\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (230,40,'ALTER SERVER','Syntax:\nALTER SERVER  server_name\n    OPTIONS (option [, option] ...)\n\nAlters the server information for server_name, adjusting any of the\noptions permitted in the CREATE SERVER statement. The corresponding\nfields in the mysql.servers table are updated accordingly. This\nstatement requires the SUPER privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-server.html\n\n','ALTER SERVER s OPTIONS (USER \'sally\');\n','http://dev.mysql.com/doc/refman/5.7/en/alter-server.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (231,24,'RESIGNAL','Syntax:\nRESIGNAL [condition_value]\n    [SET signal_information_item\n    [, signal_information_item] ...]\n\ncondition_value:\n    SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n\nsignal_information_item:\n    condition_information_item_name = simple_value_specification\n\ncondition_information_item_name:\n    CLASS_ORIGIN\n  | SUBCLASS_ORIGIN\n  | MESSAGE_TEXT\n  | MYSQL_ERRNO\n  | CONSTRAINT_CATALOG\n  | CONSTRAINT_SCHEMA\n  | CONSTRAINT_NAME\n  | CATALOG_NAME\n  | SCHEMA_NAME\n  | TABLE_NAME\n  | COLUMN_NAME\n  | CURSOR_NAME\n\ncondition_name, simple_value_specification:\n    (see following discussion)\n\nRESIGNAL passes on the error condition information that is available\nduring execution of a condition handler within a compound statement\ninside a stored procedure or function, trigger, or event. RESIGNAL may\nchange some or all information before passing it on. RESIGNAL is\nrelated to SIGNAL, but instead of originating a condition as SIGNAL\ndoes, RESIGNAL relays existing condition information, possibly after\nmodifying it.\n\nRESIGNAL makes it possible to both handle an error and return the error\ninformation. Otherwise, by executing an SQL statement within the\nhandler, information that caused the handler\'s activation is destroyed.\nRESIGNAL also can make some procedures shorter if a given handler can\nhandle part of a situation, then pass the condition "up the line" to\nanother handler.\n\nNo special privileges are required to execute the RESIGNAL statement.\n\nAll forms of RESIGNAL require that the current context be a condition\nhandler. Otherwise, RESIGNAL is illegal and a RESIGNAL when handler not\nactive error occurs.\n\nTo retrieve information from the diagnostics area, use the GET\nDIAGNOSTICS statement (see [HELP GET DIAGNOSTICS]). For information\nabout the diagnostics area, see\nhttp://dev.mysql.com/doc/refman/5.7/en/diagnostics-area.html.\n\nFor condition_value and signal_information_item, the definitions and\nrules are the same for RESIGNAL as for SIGNAL. For example, the\ncondition_value can be an SQLSTATE value, and the value can indicate\nerrors, warnings, or "not found." For additional information, see [HELP\nSIGNAL].\n\nThe RESIGNAL statement takes condition_value and SET clauses, both of\nwhich are optional. This leads to several possible uses:\n\no RESIGNAL alone:\n\nRESIGNAL;\n\no RESIGNAL with new signal information:\n\nRESIGNAL SET signal_information_item [, signal_information_item] ...;\n\no RESIGNAL with a condition value and possibly new signal information:\n\nRESIGNAL condition_value\n    [SET signal_information_item [, signal_information_item] ...];\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/resignal.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/resignal.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (232,7,'MBRCOVERS','MBRCovers(g1,g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\ncovers the minimum bounding rectangle of g2. This tests the opposite\nrelationship as MBRCoveredBy(). See the description of MBRCoveredBy()\nfor examples and information about argument handling.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (233,13,'ST_NUMPOINTS','ST_NumPoints(ls)\n\nReturns the number of Point objects in the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_NumPoints(ST_GeomFromText(@ls));\n+------------------------------------+\n| ST_NumPoints(ST_GeomFromText(@ls)) |\n+------------------------------------+\n|                                  3 |\n+------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (234,32,'TIME FUNCTION','Syntax:\nTIME(expr)\n\nExtracts the time part of the time or datetime expression expr and\nreturns it as a string.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT TIME(\'2003-12-31 01:02:03\');\n        -> \'01:02:03\'\nmysql> SELECT TIME(\'2003-12-31 01:02:03.000123\');\n        -> \'01:02:03.000123\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (235,32,'DATE_ADD','Syntax:\nDATE_ADD(date,INTERVAL expr unit), DATE_SUB(date,INTERVAL expr unit)\n\nThese functions perform date arithmetic. The date argument specifies\nthe starting date or datetime value. expr is an expression specifying\nthe interval value to be added or subtracted from the starting date.\nexpr is a string; it may start with a "-" for negative intervals. unit\nis a keyword indicating the units in which the expression should be\ninterpreted.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT \'2008-12-31 23:59:59\' + INTERVAL 1 SECOND;\n        -> \'2009-01-01 00:00:00\'\nmysql> SELECT INTERVAL 1 DAY + \'2008-12-31\';\n        -> \'2009-01-01\'\nmysql> SELECT \'2005-01-01\' - INTERVAL 1 SECOND;\n        -> \'2004-12-31 23:59:59\'\nmysql> SELECT DATE_ADD(\'2000-12-31 23:59:59\',\n    ->                 INTERVAL 1 SECOND);\n        -> \'2001-01-01 00:00:00\'\nmysql> SELECT DATE_ADD(\'2010-12-31 23:59:59\',\n    ->                 INTERVAL 1 DAY);\n        -> \'2011-01-01 23:59:59\'\nmysql> SELECT DATE_ADD(\'2100-12-31 23:59:59\',\n    ->                 INTERVAL \'1:1\' MINUTE_SECOND);\n        -> \'2101-01-01 00:01:00\'\nmysql> SELECT DATE_SUB(\'2005-01-01 00:00:00\',\n    ->                 INTERVAL \'1 1:1:1\' DAY_SECOND);\n        -> \'2004-12-30 22:58:59\'\nmysql> SELECT DATE_ADD(\'1900-01-01 00:00:00\',\n    ->                 INTERVAL \'-1 10\' DAY_HOUR);\n        -> \'1899-12-30 14:00:00\'\nmysql> SELECT DATE_SUB(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1997-12-02\'\nmysql> SELECT DATE_ADD(\'1992-12-31 23:59:59.000002\',\n    ->            INTERVAL \'1.999999\' SECOND_MICROSECOND);\n        -> \'1993-01-01 00:00:01.000001\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (236,7,'JSON_VALID','JSON_VALID(val)\n\nReturns 0 or 1 to indicate whether a value is a valid JSON document.\nReturns NULL if the argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-attribute-functions.html\n\n','mysql> SELECT JSON_VALID(\'{"a": 1}\');\n+------------------------+\n| JSON_VALID(\'{"a": 1}\') |\n+------------------------+\n|                      1 |\n+------------------------+\nmysql> SELECT JSON_VALID(\'hello\'), JSON_VALID(\'"hello"\');\n+---------------------+-----------------------+\n| JSON_VALID(\'hello\') | JSON_VALID(\'"hello"\') |\n+---------------------+-----------------------+\n|                   0 |                     1 |\n+---------------------+-----------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-attribute-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (237,37,'ST_ENVELOPE','ST_Envelope(g)\n\nReturns the minimum bounding rectangle (MBR) for the geometry value g.\nThe result is returned as a Polygon value that is defined by the corner\npoints of the bounding box:\n\nPOLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nmysql> SELECT ST_AsText(ST_Envelope(ST_GeomFromText(\'LineString(1 1,2 2)\')));\n+----------------------------------------------------------------+\n| ST_AsText(ST_Envelope(ST_GeomFromText(\'LineString(1 1,2 2)\'))) |\n+----------------------------------------------------------------+\n| POLYGON((1 1,2 1,2 2,1 2,1 1))                                 |\n+----------------------------------------------------------------+\n\nAs of MySQL 5.7.6, if the argument is a point or a vertical or\nhorizontal line segment, ST_Envelope() returns the point or the line\nsegment as its MBR rather than returning an invalid polygon:\n\nmysql> SELECT ST_AsText(ST_Envelope(ST_GeomFromText(\'LineString(1 1,1 2)\')));\n+----------------------------------------------------------------+\n| ST_AsText(ST_Envelope(ST_GeomFromText(\'LineString(1 1,1 2)\'))) |\n+----------------------------------------------------------------+\n| LINESTRING(1 1,1 2)                                            |\n+----------------------------------------------------------------+\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (238,38,'LIKE','Syntax:\nexpr LIKE pat [ESCAPE \'escape_char\']\n\nPattern matching using an SQL pattern. Returns 1 (TRUE) or 0 (FALSE).\nIf either expr or pat is NULL, the result is NULL.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-comparison-functions.html\n\n','mysql> SELECT \'David!\' LIKE \'David_\';\n        -> 1\nmysql> SELECT \'David!\' LIKE \'%D%v%\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/string-comparison-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (239,25,'MULTIPOINT','MultiPoint(pt1,pt2,...)\n\nConstructs a MultiPoint value using Point or WKB Point arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (240,19,'>>','Syntax:\n>>\n\nShifts a longlong (BIGINT) number to the right.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html\n\n','mysql> SELECT 4 >> 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (241,24,'FETCH','Syntax:\nFETCH [[NEXT] FROM] cursor_name INTO var_name [, var_name] ...\n\nThis statement fetches the next row for the SELECT statement associated\nwith the specified cursor (which must be open), and advances the cursor\npointer. If a row exists, the fetched columns are stored in the named\nvariables. The number of columns retrieved by the SELECT statement must\nmatch the number of output variables specified in the FETCH statement.\n\nIf no more rows are available, a No Data condition occurs with SQLSTATE\nvalue \'02000\'. To detect this condition, you can set up a handler for\nit (or for a NOT FOUND condition). For an example, see\nhttp://dev.mysql.com/doc/refman/5.7/en/cursors.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/fetch.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/fetch.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (242,30,'TRUE FALSE','The constants TRUE and FALSE evaluate to 1 and 0, respectively. The\nconstant names can be written in any lettercase.\n\nmysql> SELECT TRUE, true, FALSE, false;\n        -> 1, 1, 0, 0\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/boolean-literals.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/boolean-literals.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (243,7,'MBRWITHIN','MBRWithin(g1,g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\nis within the minimum bounding rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html\n\n','mysql> SET @g1 = ST_GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = ST_GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nmysql> SELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (244,17,'SESSION_USER','Syntax:\nSESSION_USER()\n\nSESSION_USER() is a synonym for USER().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (245,27,'SHOW CREATE FUNCTION','Syntax:\nSHOW CREATE FUNCTION func_name\n\nThis statement is similar to SHOW CREATE PROCEDURE but for stored\nfunctions. See [HELP SHOW CREATE PROCEDURE].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-create-function.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-create-function.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (246,31,'DISTANCE','Distance(g1,g2)\n\nST_Distance() and Distance() are synonyms. For more information, see\nthe description of ST_Distance().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (247,32,'STR_TO_DATE','Syntax:\nSTR_TO_DATE(str,format)\n\nThis is the inverse of the DATE_FORMAT() function. It takes a string\nstr and a format string format. STR_TO_DATE() returns a DATETIME value\nif the format string contains both date and time parts, or a DATE or\nTIME value if the string contains only date or time parts. If the date,\ntime, or datetime value extracted from str is illegal, STR_TO_DATE()\nreturns NULL and produces a warning.\n\nThe server scans str attempting to match format to it. The format\nstring can contain literal characters and format specifiers beginning\nwith %. Literal characters in format must match literally in str.\nFormat specifiers in format must match a date or time part in str. For\nthe specifiers that can be used in format, see the DATE_FORMAT()\nfunction description.\n\nmysql> SELECT STR_TO_DATE(\'01,5,2013\',\'%d,%m,%Y\');\n        -> \'2013-05-01\'\nmysql> SELECT STR_TO_DATE(\'May 1, 2013\',\'%M %d,%Y\');\n        -> \'2013-05-01\'\n\nScanning starts at the beginning of str and fails if format is found\nnot to match. Extra characters at the end of str are ignored.\n\nmysql> SELECT STR_TO_DATE(\'a09:30:17\',\'a%h:%i:%s\');\n        -> \'09:30:17\'\nmysql> SELECT STR_TO_DATE(\'a09:30:17\',\'%h:%i:%s\');\n        -> NULL\nmysql> SELECT STR_TO_DATE(\'09:30:17a\',\'%h:%i:%s\');\n        -> \'09:30:17\'\n\nUnspecified date or time parts have a value of 0, so incompletely\nspecified values in str produce a result with some or all parts set to\n0:\n\nmysql> SELECT STR_TO_DATE(\'abc\',\'abc\');\n        -> \'0000-00-00\'\nmysql> SELECT STR_TO_DATE(\'9\',\'%m\');\n        -> \'0000-09-00\'\nmysql> SELECT STR_TO_DATE(\'9\',\'%s\');\n        -> \'00:00:09\'\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (248,11,'Y','Y(p)\n\nST_Y() and Y() are synonyms. For more information, see the description\nof ST_Y().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-point-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-point-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (249,21,'CHECKSUM TABLE','Syntax:\nCHECKSUM TABLE tbl_name [, tbl_name] ... [ QUICK | EXTENDED ]\n\nCHECKSUM TABLE reports a checksum for the contents of a table. During\nthe checksum operation, the table is locked with a read lock for InnoDB\nand MyISAM. You can use this statement to verify that the contents are\nthe same before and after a backup, rollback, or other operation that\nis intended to put the data back to a known state. This statement\nrequires the SELECT privilege for the table.\n\nThis statement is not supported for views. If you run CHECKSUM TABLE\nagainst a view, the Checksum value is always NULL, and a warning is\nreturned.\n\nPerformance Considerations\n\nBy default, the entire table is read row by row and the checksum is\ncalculated. For large tables, this could take a long time, thus you\nwould only perform this operation occasionally. This row-by-row\ncalculation is what you get with the EXTENDED clause, with InnoDB and\nall other storage engines other than MyISAM, and with MyISAM tables not\ncreated with the CHECKSUM=1 clause.\n\nFor MyISAM tables created with the CHECKSUM=1 clause, CHECKSUM TABLE or\nCHECKSUM TABLE ... QUICK returns the "live" table checksum that can be\nreturned very fast. If the table does not meet all these conditions,\nthe QUICK method returns NULL. See [HELP CREATE TABLE] for the syntax\nof the CHECKSUM clause.\n\nFor a nonexistent table, CHECKSUM TABLE returns NULL and generates a\nwarning.\n\nThe checksum value depends on the table row format. If the row format\nchanges, the checksum also changes. For example, the storage format for\ntemporal types such as TIME, DATETIME, and TIMESTAMP changed in MySQL\n5.6 prior to MySQL 5.6.5, so if a 5.5 table is upgraded to MySQL 5.6,\nthe checksum value may change.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/checksum-table.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/checksum-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (250,2,'NUMINTERIORRINGS','NumInteriorRings(poly)\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms. For more\ninformation, see the description of ST_NumInteriorRings().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (251,2,'INTERIORRINGN','InteriorRingN(poly,N)\n\nST_InteriorRingN() and InteriorRingN() are synonyms. For more\ninformation, see the description of ST_InteriorRingN().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (252,32,'UTC_TIME','Syntax:\nUTC_TIME, UTC_TIME([fsp])\n\nReturns the current UTC time as a value in \'HH:MM:SS\' or HHMMSS format,\ndepending on whether the function is used in a string or numeric\ncontext.\n\nIf the fsp argument is given to specify a fractional seconds precision\nfrom 0 to 6, the return value includes a fractional seconds part of\nthat many digits.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_TIME(), UTC_TIME() + 0;\n        -> \'18:07:53\', 180753.000000\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (253,14,'IS_IPV4_COMPAT','Syntax:\nIS_IPV4_COMPAT(expr)\n\nThis function takes an IPv6 address represented in numeric form as a\nbinary string, as returned by INET6_ATON(). It returns 1 if the\nargument is a valid IPv4-compatible IPv6 address, 0 otherwise.\nIPv4-compatible addresses have the form ::ipv4_address.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV4_COMPAT(INET6_ATON(\'::10.0.5.9\'));\n        -> 1\nmysql> SELECT IS_IPV4_COMPAT(INET6_ATON(\'::ffff:10.0.5.9\'));\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (254,40,'DROP FUNCTION','The DROP FUNCTION statement is used to drop stored functions and\nuser-defined functions (UDFs):\n\no For information about dropping stored functions, see [HELP DROP\n  PROCEDURE].\n\no For information about dropping user-defined functions, see [HELP DROP\n  FUNCTION UDF].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-function.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-function.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (255,4,'ST_POLYFROMTEXT','ST_PolyFromText(wkt[,srid]), ST_PolygonFromText(wkt[,srid])\n\nConstructs a Polygon value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (256,16,'STDDEV','Syntax:\nSTDDEV(expr)\n\nReturns the population standard deviation of expr. This function is\nprovided for compatibility with Oracle. The standard SQL function\nSTDDEV_POP() can be used instead.\n\nSTDDEV() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (257,32,'PERIOD_ADD','Syntax:\nPERIOD_ADD(P,N)\n\nAdds N months to period P (in the format YYMM or YYYYMM). Returns a\nvalue in the format YYYYMM. Note that the period argument P is not a\ndate value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT PERIOD_ADD(200801,2);\n        -> 200803\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (258,38,'RIGHT','Syntax:\nRIGHT(str,len)\n\nReturns the rightmost len characters from the string str, or NULL if\nany argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT RIGHT(\'foobarbar\', 4);\n        -> \'rbar\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (259,40,'DROP TABLESPACE','Syntax:\nDROP TABLESPACE tablespace_name\n    [ENGINE [=] engine_name]\n\nThis statement drops a tablespace that was previously created using\nCREATE TABLESPACE. It is supported with all MySQL Cluster NDB 7.5\nreleases, and with InnoDB in the standard MySQL Server as well,\nbeginning with MySQL 5.7.6.\n\nENGINE sets the storage engine that uses the tablespace, where\nengine_name is the name of the storage engine. Currently, the values\nInnoDB and NDB are supported. If not set, the value of\ndefault_storage_engine is used. If it is not the same as the storage\nengine used to create the tablespace, the DROP TABLESPACE statement\nfails.\n\nFor an InnoDB tablespace, all tables must be dropped from the\ntablespace prior to a DROP TABLESPACE operation. If the tablespace is\nnot empty, DROP TABLESPACE returns an error.\n\nAs with the InnoDB system tablespace, truncating or dropping InnoDB\ntables stored in a general tablespace creates free space in the\ntablespace .ibd data file, which can only be used for new InnoDB data.\nSpace is not released back to the operating system by such operations\nas it is for file-per-table tablespaces.\n\nAn NDB tablespace to be dropped must not contain any data files; in\nother words, before you can drop an NDB tablespace, you must first drop\neach of its data files using ALTER TABLESPACE ... DROP DATAFILE.\n\nNotes\n\no Tablespaces are not deleted automatically. A tablespace must be\n  dropped explicitly using DROP TABLESPACE. DROP DATABASE has no effect\n  in this regard, even if the operation drops all tables belonging to\n  the tablespace.\n\no A DROP DATABASE operation can drop tables that belong to a general\n  tablespace but it cannot drop the tablespace, even if the operation\n  drops all tables that belong to the tablespace. The tablespace must\n  be dropped explicitly using DROP TABLESPACE tablespace_name.\n\no Similar to the system tablespace, truncating or dropping tables\n  stored in a general tablespace creates free space internally in the\n  general tablespace .ibd data file which can only be used for new\n  InnoDB data. Space is not released back to the operating system as it\n  is for file-per-table tablespaces.\n\nInnoDB Example\n\nThis example demonstrates how to drop an InnoDB general tablespace. The\ngeneral tablespace ts1 is created with a single table. Before dropping\nthe tablespace, the table must be dropped.\n\nmysql> CREATE TABLESPACE `ts1`\n    ->     ADD DATAFILE \'ts1.ibd\'\n    ->     ENGINE=INNODB;\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> CREATE TABLE t1 (c1 INT PRIMARY KEY)\n    ->     TABLESPACE ts10\n    ->     ENGINE=INNODB;\nQuery OK, 0 rows affected (0.02 sec)\n\nmysql> DROP TABLE t1;\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> DROP TABLESPACE ts1;\nQuery OK, 0 rows affected (0.01 sec)\n\nNDB Example\n\nThis example shows how to drop an NDB tablespace myts having a data\nfile named mydata-1.dat after first creating the tablespace, and\nassumes the existence of a log file group named mylg (see [HELP CREATE\nLOGFILE GROUP]).\n\nmysql> CREATE TABLESPACE myts \n    ->     ADD DATAFILE \'mydata-1.dat\' \n    ->     USE LOGFILE GROUP mylg\n    ->     ENGINE=NDB;\n\nYou must remove all data files from the tablespace using ALTER\nTABLESPACE, as shown here, before it can be dropped:\n\nmysql> ALTER TABLESPACE myts \n    ->     DROP DATAFILE \'mydata-1.dat\' \n    ->     ENGINE=NDB;\n\nmysql> DROP TABLESPACE myts;\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-tablespace.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (260,21,'CHECK TABLE','Syntax:\nCHECK TABLE tbl_name [, tbl_name] ... [option] ...\n\noption = {\n    FOR UPGRADE\n  | QUICK\n  | FAST\n  | MEDIUM\n  | EXTENDED\n  | CHANGED\n}\n\nCHECK TABLE checks a table or tables for errors. CHECK TABLE works for\nInnoDB, MyISAM, ARCHIVE, and CSV tables. For MyISAM tables, the key\nstatistics are updated as well.\n\nTo check a table, you must have some privilege for it.\n\nCHECK TABLE can also check views for problems, such as tables that are\nreferenced in the view definition that no longer exist.\n\nCHECK TABLE is supported for partitioned tables, and you can use ALTER\nTABLE ... CHECK PARTITION to check one or more partitions; for more\ninformation, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/5.7/en/partitioning-maintenance.html.\n\nIn MySQL 5.7.1, gtid_next must be set to AUTOMATIC before issuing this\nstatement. This restriction does not apply in MySQL 5.7.2 or later.\n(Bug #16062608, Bug #16715809, Bug #69045)\n\nCHECK TABLE ignores generated virtual columns that are not indexed.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/check-table.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/check-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (261,38,'BIN','Syntax:\nBIN(N)\n\nReturns a string representation of the binary value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,2). Returns\nNULL if N is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT BIN(12);\n        -> \'1100\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (262,25,'MULTILINESTRING','MultiLineString(ls1,ls2,...)\n\nConstructs a MultiLineString value using LineString or WKB LineString\narguments.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (263,27,'SHOW RELAYLOG EVENTS','Syntax:\nSHOW RELAYLOG EVENTS\n   [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n\nShows the events in the relay log of a replication slave. If you do not\nspecify \'log_name\', the first relay log is displayed. This statement\nhas no effect on the master.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-relaylog-events.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-relaylog-events.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (264,4,'MPOINTFROMTEXT','MPointFromText(wkt[,srid]), MultiPointFromText(wkt[,srid])\n\nST_MPointFromText(), ST_MultiPointFromText(), MPointFromText(), and\nMultiPointFromText() are synonyms. For more information, see the\ndescription of ST_MPointFromText().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (265,38,'SUBSTR','Syntax:\nSUBSTR(str,pos), SUBSTR(str FROM pos), SUBSTR(str,pos,len), SUBSTR(str\nFROM pos FOR len)\n\nSUBSTR() is a synonym for SUBSTRING().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (266,23,'CHAR','[NATIONAL] CHAR[(M)] [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA fixed-length string that is always right-padded with spaces to the\nspecified length when stored. M represents the column length in\ncharacters. The range of M is 0 to 255. If M is omitted, the length is\n1.\n\n*Note*: Trailing spaces are removed when CHAR values are retrieved\nunless the PAD_CHAR_TO_FULL_LENGTH SQL mode is enabled.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (267,16,'COUNT DISTINCT','Syntax:\nCOUNT(DISTINCT expr,[expr...])\n\nReturns a count of the number of rows with different non-NULL expr\nvalues.\n\nCOUNT(DISTINCT) returns 0 if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','mysql> SELECT COUNT(DISTINCT results) FROM student;\n','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (268,27,'SHOW CREATE VIEW','Syntax:\nSHOW CREATE VIEW view_name\n\nThis statement shows the CREATE VIEW statement that creates the named\nview.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-create-view.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-create-view.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (269,20,'INTERVAL','Syntax:\nINTERVAL(N,N1,N2,N3,...)\n\nReturns 0 if N < N1, 1 if N < N2 and so on or -1 if N is NULL. All\narguments are treated as integers. It is required that N1 < N2 < N3 <\n... < Nn for this function to work correctly. This is because a binary\nsearch is used (very fast).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\n        -> 3\nmysql> SELECT INTERVAL(10, 1, 10, 100, 1000);\n        -> 2\nmysql> SELECT INTERVAL(22, 23, 30, 44, 200);\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (270,32,'FROM_DAYS','Syntax:\nFROM_DAYS(N)\n\nGiven a day number N, returns a DATE value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT FROM_DAYS(730669);\n        -> \'2007-07-03\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (271,40,'ALTER PROCEDURE','Syntax:\nALTER PROCEDURE proc_name [characteristic ...]\n\ncharacteristic:\n    COMMENT \'string\'\n  | LANGUAGE SQL\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n\nThis statement can be used to change the characteristics of a stored\nprocedure. More than one change may be specified in an ALTER PROCEDURE\nstatement. However, you cannot change the parameters or body of a\nstored procedure using this statement; to make such changes, you must\ndrop and re-create the procedure using DROP PROCEDURE and CREATE\nPROCEDURE.\n\nYou must have the ALTER ROUTINE privilege for the procedure. By\ndefault, that privilege is granted automatically to the procedure\ncreator. This behavior can be changed by disabling the\nautomatic_sp_privileges system variable. See\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-routines-privileges.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/alter-procedure.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (272,19,'BIT_COUNT','Syntax:\nBIT_COUNT(N)\n\nReturns the number of bits that are set in the argument N.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html\n\n','mysql> SELECT BIT_COUNT(29), BIT_COUNT(b\'101010\');\n        -> 4, 3\n','http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (273,33,'ST_POINTFROMWKB','ST_PointFromWKB(wkb[,srid])\n\nConstructs a Point value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (274,7,'ST_MAKEENVELOPE','ST_MakeEnvelope(pt1, pt2)\n\nReturns the rectangle that forms the envelope around two points. The\nreturned geometry is a Point, LineString, or Polygon, or NULL if any\nargument is NULL.\n\nCalculations are done using the cartesian coordinate system rather than\non a sphere, spheroid, or on earth.\n\nGiven two points pt1 and pt2, ST_MakeEnvelope() creates the result\ngeometry on an abstract plane like this:\n\no If pt1 and pt2 are equal, the result is the point pt1.\n\no Otherwise, if (pt1, pt2) is a vertical or horizontal line segment,\n  the result is the line segment (pt1, pt2).\n\no Otherwise, the result is a polygon using pt1 and pt2 as diagonal\n  points.\n\nThe result geometry has an SRID of 0.\n\nST_MakeEnvelope() requires Point geometry arguments with an SRID of 0.\nAn ER_WRONG_ARGUMENTS error occurs otherwise.\n\nAn ER_GIS_INVALID_DATA occurs if any argument is not a valid geometry\nbyte string, or if any coordinate value of the two points is infinite\n(that is, NaN).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-convenience-functions.html\n\n','mysql> SET @pt1 = ST_GeomFromText(\'POINT(0 0)\');\nmysql> SET @pt2 = ST_GeomFromText(\'POINT(1 1)\');\nmysql> SELECT ST_AsText(ST_MakeEnvelope(@pt1, @pt2));\n+----------------------------------------+\n| ST_AsText(ST_MakeEnvelope(@pt1, @pt2)) |\n+----------------------------------------+\n| POLYGON((0 0,1 0,1 1,0 1,0 0))         |\n+----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-convenience-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (275,31,'ST_WITHIN','ST_Within(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially within g2. This\ntests the opposite relationship as ST_Contains().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (276,3,'ACOS','Syntax:\nACOS(X)\n\nReturns the arc cosine of X, that is, the value whose cosine is X.\nReturns NULL if X is not in the range -1 to 1.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT ACOS(1);\n        -> 0\nmysql> SELECT ACOS(1.0001);\n        -> NULL\nmysql> SELECT ACOS(0);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (277,8,'ISOLATION','Syntax:\nSET [GLOBAL | SESSION] TRANSACTION\n    transaction_characteristic [, transaction_characteristic] ...\n\ntransaction_characteristic:\n    ISOLATION LEVEL level\n  | READ WRITE\n  | READ ONLY\n\nlevel:\n     REPEATABLE READ\n   | READ COMMITTED\n   | READ UNCOMMITTED\n   | SERIALIZABLE\n\nThis statement specifies transaction characteristics. It takes a list\nof one or more characteristic values separated by commas. These\ncharacteristics set the transaction isolation level or access mode. The\nisolation level is used for operations on InnoDB tables. The access\nmode may be specified as to whether transactions operate in read/write\nor read-only mode.\n\nIn addition, SET TRANSACTION can include an optional GLOBAL or SESSION\nkeyword to indicate the scope of the statement.\n\nScope of Transaction Characteristics\n\nYou can set transaction characteristics globally, for the current\nsession, or for the next transaction:\n\no With the GLOBAL keyword, the statement applies globally for all\n  subsequent sessions. Existing sessions are unaffected.\n\no With the SESSION keyword, the statement applies to all subsequent\n  transactions performed within the current session.\n\no Without any SESSION or GLOBAL keyword, the statement applies to the\n  next (not started) transaction performed within the current session.\n  Subsequent transactions revert to using the SESSION isolation level.\n\nA global change to transaction characteristics requires the SUPER\nprivilege. Any session is free to change its session characteristics\n(even in the middle of a transaction), or the characteristics for its\nnext transaction.\n\nSET TRANSACTION without GLOBAL or SESSION is not permitted while there\nis an active transaction:\n\nmysql> START TRANSACTION;\nQuery OK, 0 rows affected (0.02 sec)\n\nmysql> SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed\nwhile a transaction is in progress\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option to mysqld on the command line or\nin an option file. Values of level for this option use dashes rather\nthan spaces, so the permissible values are READ-UNCOMMITTED,\nREAD-COMMITTED, REPEATABLE-READ, or SERIALIZABLE. For example, to set\nthe default isolation level to REPEATABLE READ, use these lines in the\n[mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\n\nIt is possible to check or set the global and session transaction\nisolation levels at runtime by using the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\nSET GLOBAL tx_isolation=\'REPEATABLE-READ\';\nSET SESSION tx_isolation=\'SERIALIZABLE\';\n\nSimilarly, to set the transaction access mode at server startup or at\nruntime, use the --transaction-read-only option or tx_read_only system\nvariable. By default, these are OFF (the mode is read/write) but can be\nset to ON for a default mode of read only.\n\nSetting the global or session value of tx_isolation or tx_read_only is\nequivalent to setting the isolation level or access mode with SET\nGLOBAL TRANSACTION or SET SESSION TRANSACTION.\n\nTransaction Isolation Levels\n\nFor information about transaction isolation levels, see\nhttp://dev.mysql.com/doc/refman/5.7/en/innodb-transaction-isolation-lev\nels.html.\n\nTransaction Access Mode\n\nThe transaction access mode may be specified with SET TRANSACTION. By\ndefault, a transaction takes place in read/write mode, with both reads\nand writes permitted to tables used in the transaction. This mode may\nbe specified explicitly using an access mode of READ WRITE.\n\nIf the transaction access mode is set to READ ONLY, changes to tables\nare prohibited. This may enable storage engines to make performance\nimprovements that are possible when writes are not permitted.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the\nsame statement.\n\nIn read-only mode, it remains possible to change tables created with\nthe TEMPORARY keyword using DML statements. Changes made with DDL\nstatements are not permitted, just as with permanent tables.\n\nThe READ WRITE and READ ONLY access modes also may be specified for an\nindividual transaction using the START TRANSACTION statement.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/set-transaction.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/set-transaction.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (278,3,'SIN','Syntax:\nSIN(X)\n\nReturns the sine of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT SIN(PI());\n        -> 1.2246063538224e-16\nmysql> SELECT ROUND(SIN(PI()));\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (279,26,'ST_BUFFER','ST_Buffer(g,d[,strategy1[,strategy2[,strategy3]]])\n\nReturns a geometry that represents all points whose distance from the\ngeometry value g is less than or equal to a distance of d, or NULL if\nany argument is NULL. The SRID of the geometry argument must be 0\nbecause ST_Buffer() supports only the cartesian coordinate system. For\nan invalid geometry argument, an ER_GIS_INVALID_DATA error occurs.\n\nIf the geometry argument is empty, ST_Buffer() returns an empty\ngeometry.\n\nIf the distance is 0, ST_Buffer() returns the geometry argument\nunchanged:\n\nmysql> SET @pt = ST_GeomFromText(\'POINT(0 0)\');\nmysql> SELECT ST_AsText(ST_Buffer(@pt, 0));\n+------------------------------+\n| ST_AsText(ST_Buffer(@pt, 0)) |\n+------------------------------+\n| POINT(0 0)                   |\n+------------------------------+\n\nST_Buffer() supports negative distances for Polygon and MultiPolygon\nvalues, and for geometry collections containing Polygon or MultiPolygon\nvalues. The result may be an empty geometry. An ER_WRONG_ARGUMENTS\nerror occurs for ST_Buffer() with a negative distance for Point,\nMultiPoint, LineString, and MultiLineString values, and for geometry\ncollections not containing any Polygon or MultiPolygon values.\n\nAs of MySQL 5.7.7, ST_Buffer() permits up to three optional strategy\narguments following the distance argument. Strategies influence buffer\ncomputation. These arguments are byte string values produced by the\nST_Buffer_Strategy() function, to be used for point, join, and end\nstrategies:\n\no Point strategies apply to Point and MultiPoint geometries. If no\n  point strategy is specified, the default is\n  ST_Buffer_Strategy(\'point_circle\', 32).\n\no Join strategies apply to LineString, MultiLineString, Polygon, and\n  MultiPolygon geometries. If no join strategy is specified, the\n  default is ST_Buffer_Strategy(\'join_round\', 32).\n\no End strategies apply to LineString and MultiLineString geometries. If\n  no end strategy is specified, the default is\n  ST_Buffer_Strategy(\'end_round\', 32).\n\nUp to one strategy of each type may be specified, and they may be given\nin any order. If multiple strategies of a given type are specified, an\nER_WRONG_ARGUMENTS error occurs.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html\n\n','mysql> SET @pt = ST_GeomFromText(\'POINT(0 0)\');\nmysql> SET @pt_strategy = ST_Buffer_Strategy(\'point_square\');\nmysql> SELECT ST_AsText(ST_Buffer(@pt, 2, @pt_strategy));\n+--------------------------------------------+\n| ST_AsText(ST_Buffer(@pt, 2, @pt_strategy)) |\n+--------------------------------------------+\n| POLYGON((-2 -2,2 -2,2 2,-2 2,-2 -2))       |\n+--------------------------------------------+\n\nmysql> SET @ls = ST_GeomFromText(\'LINESTRING(0 0,0 5,5 5)\');\nmysql> SET @end_strategy = ST_Buffer_Strategy(\'end_flat\');\nmysql> SET @join_strategy = ST_Buffer_Strategy(\'join_round\', 10);\nmysql> SELECT ST_AsText(ST_Buffer(@ls, 5, @end_strategy, @join_strategy))\n+---------------------------------------------------------------+\n| ST_AsText(ST_Buffer(@ls, 5, @end_strategy, @join_strategy))   |\n+---------------------------------------------------------------+\n| POLYGON((5 5,5 10,0 10,-3.5355339059327373 8.535533905932738, |\n| -5 5,-5 0,0 0,5 0,5 5))                                       |\n+---------------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (280,26,'BUFFER','Buffer(g,d[,strategy1[,strategy2[,strategy3]]])\n\nST_Buffer() and Buffer() are synonyms. For more information, see the\ndescription of ST_Buffer().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (281,7,'JSON_OBJECT','JSON_OBJECT([key, val[, key, val] ...])\n\nEvaluates a (possibly empty) list of key/value pairs and returns a JSON\nobject containing those pairs. An error occurs if any key name is NULL\nor the number of arguments is odd.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-creation-functions.html\n\n','mysql> SELECT JSON_OBJECT(\'id\', 87, \'name\', \'carrot\');\n+-----------------------------------------+\n| JSON_OBJECT(\'id\', 87, \'name\', \'carrot\') |\n+-----------------------------------------+\n| {"id": 87, "name": "carrot"}            |\n+-----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-creation-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (282,7,'WAIT_FOR_EXECUTED_GTID_SET','Syntax:\nWAIT_FOR_EXECUTED_GTID_SET(gtid_set[, timeout])\n\nIntroduced in MySQL 5.7.5, WAIT_FOR_EXECUTED_GTID_SET() is similar to\nWAIT_UNTIL_SQL_THREAD_AFTER_GTIDS() in that it waits until a server has\nexecuted all of the transactions whose global transaction identifiers\nare contained in gtid_set, or until timeout seconds have elapsed,\nwhichever occurs first. Unlike WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS(),\nWAIT_FOR_EXECUTED_GTID_SET() does not take into account whether the\nslave is running or not, and an error is returned if GTID-based\nreplication is not enabled.\n\nIn addition, WAIT_FOR_EXECUTED_GTID_SET() returns only the state of the\nquery, where 0 represents success, 1 represents timeout, and any other\nfailures return the error message.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gtid-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gtid-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (283,20,'IS','Syntax:\nIS boolean_value\n\nTests a value against a boolean value, where boolean_value can be TRUE,\nFALSE, or UNKNOWN.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 1 IS TRUE, 0 IS FALSE, NULL IS UNKNOWN;\n        -> 1, 1, 1\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (284,32,'GET_FORMAT','Syntax:\nGET_FORMAT({DATE|TIME|DATETIME}, {\'EUR\'|\'USA\'|\'JIS\'|\'ISO\'|\'INTERNAL\'})\n\nReturns a format string. This function is useful in combination with\nthe DATE_FORMAT() and the STR_TO_DATE() functions.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_FORMAT(\'2003-10-03\',GET_FORMAT(DATE,\'EUR\'));\n        -> \'03.10.2003\'\nmysql> SELECT STR_TO_DATE(\'10.31.2003\',GET_FORMAT(DATE,\'USA\'));\n        -> \'2003-10-31\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (285,2,'ST_CENTROID','ST_Centroid(mpoly)\n\nReturns the mathematical centroid for the MultiPolygon value mpoly as a\nPoint. The result is not guaranteed to be on the MultiPolygon.\n\nAs of MySQL 5.7.5, this function processes geometry collections by\ncomputing the centroid point for components of highest dimension in the\ncollection. Such components are extracted and made into a single\nMultiPolygon, MultiLineString, or MultiPoint for centroid computation.\nIf the argument is an empty geometry collection, the return value is\nNULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html\n\n','mysql> SET @poly =\n    -> ST_GeomFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),(5 5,7 5,7 7,5 7,5 5))\');\nmysql> SELECT ST_GeometryType(@poly),ST_AsText(ST_Centroid(@poly));\n+------------------------+--------------------------------------------+\n| ST_GeometryType(@poly) | ST_AsText(ST_Centroid(@poly))              |\n+------------------------+--------------------------------------------+\n| POLYGON                | POINT(4.958333333333333 4.958333333333333) |\n+------------------------+--------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (286,23,'TINYBLOB','TINYBLOB\n\nA BLOB column with a maximum length of 255 (28 − 1) bytes. Each\nTINYBLOB value is stored using a 1-byte length prefix that indicates\nthe number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (287,17,'USER','Syntax:\nUSER()\n\nReturns the current MySQL user name and host name as a string in the\nutf8 character set.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (288,21,'REPAIR TABLE','Syntax:\nREPAIR [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n    tbl_name [, tbl_name] ...\n    [QUICK] [EXTENDED] [USE_FRM]\n\nREPAIR TABLE repairs a possibly corrupted table, for certain storage\nengines only. By default, it has the same effect as myisamchk --recover\ntbl_name. REPAIR TABLE works for MyISAM, ARCHIVE, and CSV tables. See\nhttp://dev.mysql.com/doc/refman/5.7/en/myisam-storage-engine.html\nhttp://dev.mysql.com/doc/refman/5.7/en/archive-storage-engine.html, and\nhttp://dev.mysql.com/doc/refman/5.7/en/csv-storage-engine.html. This\nstatement does not work with views.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nREPAIR TABLE is supported for partitioned tables. However, the USE_FRM\noption cannot be used with this statement on a partitioned table.\n\nIn MySQL 5.7.1, gtid_next must be set to AUTOMATIC before issuing this\nstatement. This restriction does not apply in MySQL 5.7.2 or later.\n(Bug #16062608, Bug #16715809, Bug #69045)\n\nYou can use ALTER TABLE ... REPAIR PARTITION to repair one or more\npartitions; for more information, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/5.7/en/partitioning-maintenance.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/repair-table.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/repair-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (289,18,'MERGE','The MERGE storage engine, also known as the MRG_MyISAM engine, is a\ncollection of identical MyISAM tables that can be used as one.\n"Identical" means that all tables have identical column and index\ninformation. You cannot merge MyISAM tables in which the columns are\nlisted in a different order, do not have exactly the same columns, or\nhave the indexes in different order. However, any or all of the MyISAM\ntables can be compressed with myisampack. See\nhttp://dev.mysql.com/doc/refman/5.7/en/myisampack.html. Differences in\ntable options such as AVG_ROW_LENGTH, MAX_ROWS, or PACK_KEYS do not\nmatter.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/merge-storage-engine.html\n\n','mysql> CREATE TABLE t1 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> CREATE TABLE t2 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> INSERT INTO t1 (message) VALUES (\'Testing\'),(\'table\'),(\'t1\');\nmysql> INSERT INTO t2 (message) VALUES (\'Testing\'),(\'table\'),(\'t2\');\nmysql> CREATE TABLE total (\n    ->    a INT NOT NULL AUTO_INCREMENT,\n    ->    message CHAR(20), INDEX(a))\n    ->    ENGINE=MERGE UNION=(t1,t2) INSERT_METHOD=LAST;\n','http://dev.mysql.com/doc/refman/5.7/en/merge-storage-engine.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (290,27,'SHOW CREATE USER','Syntax:\nSHOW CREATE USER user\n\nThis statement shows the CREATE USER statement that creates the named\nuser. An error occurs if the user does not exist. The statement\nrequires the SELECT privilege for the mysql database, except to see the\nprivileges for the current user.\n\nTo name the account, use the format described in\nhttp://dev.mysql.com/doc/refman/5.7/en/account-names.html. If you\nspecify only the user name part of the account name, a host name part\nof \'%\' is used. It is also possible to specify CURRENT_USER or\nCURRENT_USER() to refer to the account associated with the current\nsession.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-create-user.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-create-user.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (291,31,'ST_DISTANCE','ST_Distance(g1,g2)\n\nReturns the distance between g1 and g2.\n\nAs of MySQL 5.7.5, this function processes geometry collections by\nreturning the shortest distance among all combinations of the\ncomponents of the two geometry arguments. If either argument is an\nempty geometry collection, the return value is NULL.\n\nAs of MySQL 5.7.6, if an intermediate or final result produces NaN or a\nnegative number, this function produces a ER_GIS_INVALID_DATA error.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','mysql> SET @g1 = POINT(1,1), @g2 = POINT(2,2);\nmysql> SELECT ST_Distance(@g1, @g2);\n+-----------------------+\n| ST_Distance(@g1, @g2) |\n+-----------------------+\n|    1.4142135623730951 |\n+-----------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (292,40,'CREATE TABLE','Syntax:\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    (create_definition,...)\n    [table_options]\n    [partition_options]\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    [(create_definition,...)]\n    [table_options]\n    [partition_options]\n    [IGNORE | REPLACE]\n    [AS] query_expression\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    { LIKE old_tbl_name | (LIKE old_tbl_name) }\n\ncreate_definition:\n    col_name column_definition\n  | [CONSTRAINT [symbol]] PRIMARY KEY [index_type] (index_col_name,...)\n      [index_option] ...\n  | {INDEX|KEY} [index_name] [index_type] (index_col_name,...)\n      [index_option] ...\n  | [CONSTRAINT [symbol]] UNIQUE [INDEX|KEY]\n      [index_name] [index_type] (index_col_name,...)\n      [index_option] ...\n  | {FULLTEXT|SPATIAL} [INDEX|KEY] [index_name] (index_col_name,...)\n      [index_option] ...\n  | [CONSTRAINT [symbol]] FOREIGN KEY\n      [index_name] (index_col_name,...) reference_definition\n  | CHECK (expr)\n\ncolumn_definition:\n    data_type [NOT NULL | NULL] [DEFAULT default_value]\n      [AUTO_INCREMENT] [UNIQUE [KEY] | [PRIMARY] KEY]\n      [COMMENT \'string\']\n      [COLUMN_FORMAT {FIXED|DYNAMIC|DEFAULT}]\n      [STORAGE {DISK|MEMORY|DEFAULT}]\n      [reference_definition]\n  | data_type [GENERATED ALWAYS] AS (expression)\n      [VIRTUAL | STORED] [UNIQUE [KEY]] [COMMENT comment]\n      [NOT NULL | NULL] [[PRIMARY] KEY]\n\ndata_type:\n    BIT[(length)]\n  | TINYINT[(length)] [UNSIGNED] [ZEROFILL]\n  | SMALLINT[(length)] [UNSIGNED] [ZEROFILL]\n  | MEDIUMINT[(length)] [UNSIGNED] [ZEROFILL]\n  | INT[(length)] [UNSIGNED] [ZEROFILL]\n  | INTEGER[(length)] [UNSIGNED] [ZEROFILL]\n  | BIGINT[(length)] [UNSIGNED] [ZEROFILL]\n  | REAL[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | DOUBLE[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | FLOAT[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | DECIMAL[(length[,decimals])] [UNSIGNED] [ZEROFILL]\n  | NUMERIC[(length[,decimals])] [UNSIGNED] [ZEROFILL]\n  | DATE\n  | TIME[(fsp)]\n  | TIMESTAMP[(fsp)]\n  | DATETIME[(fsp)]\n  | YEAR\n  | CHAR[(length)] [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | VARCHAR(length) [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | BINARY[(length)]\n  | VARBINARY(length)\n  | TINYBLOB\n  | BLOB\n  | MEDIUMBLOB\n  | LONGBLOB\n  | TINYTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | TEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | MEDIUMTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | LONGTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | ENUM(value1,value2,value3,...)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | SET(value1,value2,value3,...)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | JSON\n  | spatial_type\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n  | COMMENT \'string\'\n\nreference_definition:\n    REFERENCES tbl_name (index_col_name,...)\n      [MATCH FULL | MATCH PARTIAL | MATCH SIMPLE]\n      [ON DELETE reference_option]\n      [ON UPDATE reference_option]\n\nreference_option:\n    RESTRICT | CASCADE | SET NULL | NO ACTION\n\ntable_options:\n    table_option [[,] table_option] ...\n\ntable_option:\n    ENGINE [=] engine_name\n  | AUTO_INCREMENT [=] value\n  | AVG_ROW_LENGTH [=] value\n  | [DEFAULT] CHARACTER SET [=] charset_name\n  | CHECKSUM [=] {0 | 1}\n  | [DEFAULT] COLLATE [=] collation_name\n  | COMMENT [=] \'string\'\n  | COMPRESSION [=] {\'ZLIB\'|\'LZ4\'|\'NONE\'}\n  | CONNECTION [=] \'connect_string\'\n  | DATA DIRECTORY [=] \'absolute path to directory\'\n  | DELAY_KEY_WRITE [=] {0 | 1}\n  | ENCRYPTION [=] {\'Y\' | \'N\'}\n  | INDEX DIRECTORY [=] \'absolute path to directory\'\n  | INSERT_METHOD [=] { NO | FIRST | LAST }\n  | KEY_BLOCK_SIZE [=] value\n  | MAX_ROWS [=] value\n  | MIN_ROWS [=] value\n  | PACK_KEYS [=] {0 | 1 | DEFAULT}\n  | PASSWORD [=] \'string\'\n  | ROW_FORMAT [=] {DEFAULT|DYNAMIC|FIXED|COMPRESSED|REDUNDANT|COMPACT}\n  | STATS_AUTO_RECALC [=] {DEFAULT|0|1}\n  | STATS_PERSISTENT [=] {DEFAULT|0|1}\n  | STATS_SAMPLE_PAGES [=] value\n  | TABLESPACE tablespace_name\n  | UNION [=] (tbl_name[,tbl_name]...)\n\npartition_options:\n    PARTITION BY\n        { [LINEAR] HASH(expr)\n        | [LINEAR] KEY [ALGORITHM={1|2}] (column_list)\n        | RANGE{(expr) | COLUMNS(column_list)}\n        | LIST{(expr) | COLUMNS(column_list)} }\n    [PARTITIONS num]\n    [SUBPARTITION BY\n        { [LINEAR] HASH(expr)\n        | [LINEAR] KEY [ALGORITHM={1|2}] (column_list) }\n      [SUBPARTITIONS num]\n    ]\n    [(partition_definition [, partition_definition] ...)]\n\npartition_definition:\n    PARTITION partition_name\n        [VALUES \n            {LESS THAN {(expr | value_list) | MAXVALUE} \n            | \n            IN (value_list)}]\n        [[STORAGE] ENGINE [=] engine_name]\n        [COMMENT [=] \'comment_text\' ]\n        [DATA DIRECTORY [=] \'data_dir\']\n        [INDEX DIRECTORY [=] \'index_dir\']\n        [MAX_ROWS [=] max_number_of_rows]\n        [MIN_ROWS [=] min_number_of_rows]\n        [TABLESPACE [=] tablespace_name] \n        [(subpartition_definition [, subpartition_definition] ...)]\n\nsubpartition_definition:\n    SUBPARTITION logical_name\n        [[STORAGE] ENGINE [=] engine_name]\n        [COMMENT [=] \'comment_text\' ]\n        [DATA DIRECTORY [=] \'data_dir\']\n        [INDEX DIRECTORY [=] \'index_dir\']\n        [MAX_ROWS [=] max_number_of_rows]\n        [MIN_ROWS [=] min_number_of_rows]\n        [TABLESPACE [=] tablespace_name] \n\nquery_expression:\n    SELECT ...   (Some valid select or union statement)\n\nCREATE TABLE creates a table with the given name. You must have the\nCREATE privilege for the table.\n\nRules for permissible table names are given in\nhttp://dev.mysql.com/doc/refman/5.7/en/identifiers.html. By default,\nthe table is created in the default database, using the InnoDB storage\nengine. An error occurs if the table exists, if there is no default\ndatabase, or if the database does not exist.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-table.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (293,32,'MICROSECOND','Syntax:\nMICROSECOND(expr)\n\nReturns the microseconds from the time or datetime expression expr as a\nnumber in the range from 0 to 999999.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT MICROSECOND(\'12:00:00.123456\');\n        -> 123456\nmysql> SELECT MICROSECOND(\'2009-12-31 23:59:59.000010\');\n        -> 10\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (294,40,'CREATE SERVER','Syntax:\nCREATE SERVER server_name\n    FOREIGN DATA WRAPPER wrapper_name\n    OPTIONS (option [, option] ...)\n\noption:\n  { HOST character-literal\n  | DATABASE character-literal\n  | USER character-literal\n  | PASSWORD character-literal\n  | SOCKET character-literal\n  | OWNER character-literal\n  | PORT numeric-literal }\n\nThis statement creates the definition of a server for use with the\nFEDERATED storage engine. The CREATE SERVER statement creates a new row\nin the servers table in the mysql database. This statement requires the\nSUPER privilege.\n\nThe server_name should be a unique reference to the server. Server\ndefinitions are global within the scope of the server, it is not\npossible to qualify the server definition to a specific database.\nserver_name has a maximum length of 64 characters (names longer than 64\ncharacters are silently truncated), and is case insensitive. You may\nspecify the name as a quoted string.\n\nThe wrapper_name should be mysql, and may be quoted with single\nquotation marks. Other values for wrapper_name are not currently\nsupported.\n\nFor each option you must specify either a character literal or numeric\nliteral. Character literals are UTF-8, support a maximum length of 64\ncharacters and default to a blank (empty) string. String literals are\nsilently truncated to 64 characters. Numeric literals must be a number\nbetween 0 and 9999, default value is 0.\n\n*Note*: The OWNER option is currently not applied, and has no effect on\nthe ownership or operation of the server connection that is created.\n\nThe CREATE SERVER statement creates an entry in the mysql.servers table\nthat can later be used with the CREATE TABLE statement when creating a\nFEDERATED table. The options that you specify will be used to populate\nthe columns in the mysql.servers table. The table columns are\nServer_name, Host, Db, Username, Password, Port and Socket.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-server.html\n\n','CREATE SERVER s\nFOREIGN DATA WRAPPER mysql\nOPTIONS (USER \'Remote\', HOST \'192.168.1.106\', DATABASE \'test\');\n','http://dev.mysql.com/doc/refman/5.7/en/create-server.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (295,7,'ST_DISTANCE_SPHERE','ST_Distance_Sphere(g1, g2 [, radius])\n\nReturns the mimimum spherical distance between two points and/or\nmultipoints on a sphere, in meters, or NULL if any geometry argument is\nNULL or empty.\n\nCalculations use a spherical earth and a configurable radius. The\noptional radius argument should be given in meters. If omitted, the\ndefault radius is 6,370,986 meters. An ER_WRONG_ARGUMENTS error occurs\nif the radius argument is present but not positive.\n\nThe geometry arguments should consist of points that specify\n(longitude, latitude) coordinate values:\n\no Longitude and latitude are the first and second coordinates of the\n  point, respectively.\n\no Both coordinates are in degrees.\n\no Longitude values must be in the range (-180, 180]. Positive values\n  are east of the prime meridian.\n\no Latitude values must be in the range [-90, 90]. Positive values are\n  north of the equator.\n\nSupported argument combinations are (Point, Point), (Point,\nMultiPoint), and (MultiPoint, Point). An ER_GIS_UNSUPPORTED_ARGUMENT\nerror occurs for other combinations.\n\nAn ER_GIS_INVALID_DATA error occurs if any geometry argument is not a\nvalid geometry byte string.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-convenience-functions.html\n\n','mysql> SET @pt1 = ST_GeomFromText(\'POINT(0 0)\');\nmysql> SET @pt2 = ST_GeomFromText(\'POINT(180 0)\');\nmysql> SELECT ST_Distance_Sphere(@pt1, @pt2);\n+--------------------------------+\n| ST_Distance_Sphere(@pt1, @pt2) |\n+--------------------------------+\n|             20015042.813723423 |\n+--------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-convenience-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (296,33,'ST_POLYFROMWKB','ST_PolyFromWKB(wkb[,srid]), ST_PolygonFromWKB(wkb[,srid])\n\nConstructs a Polygon value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (297,32,'MAKETIME','Syntax:\nMAKETIME(hour,minute,second)\n\nReturns a time value calculated from the hour, minute, and second\narguments.\n\nThe second argument can have a fractional part.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT MAKETIME(12,15,30);\n        -> \'12:15:30\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (298,32,'CURDATE','Syntax:\nCURDATE()\n\nReturns the current date as a value in \'YYYY-MM-DD\' or YYYYMMDD format,\ndepending on whether the function is used in a string or numeric\ncontext.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT CURDATE();\n        -> \'2008-06-13\'\nmysql> SELECT CURDATE() + 0;\n        -> 20080613\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (299,10,'SET PASSWORD','Syntax:\nSET PASSWORD syntax for MySQL 5.7.6 and higher:\n\nThe SET PASSWORD statement assigns a password to a MySQL user account,\nspecified as either a cleartext (unencrypted) or encrypted value:\n\no \'auth_string\' represents a cleartext password.\n\no \'hash_string\' represents an encrypted password.\n\n*Note*: SET PASSWORD ... = PASSWORD(\'auth_string\') syntax is deprecated\nas of MySQL 5.7.6 and will be removed in a future MySQL release. SET\nPASSWORD ... = \'auth_string\' syntax is not deprecated, but ALTER USER\nis now the preferred statement for assigning passwords. For example:\nALTER USER user IDENTIFIED BY \'auth_string\';\n\nSET PASSWORD can be used with or without an explicitly named user\naccount:\n\no With a FOR user clause, the statement sets the password for the named\n  account, which must exist:\n\nSET PASSWORD FOR \'jeffrey\'@\'localhost\' = password_option;\n\n  In this case, you must have the UPDATE privilege for the mysql\n  database.\n\no With no FOR user clause, the statement sets the password for the\n  current user:\n\nSET PASSWORD = password_option;\n\n  Any client who connects to the server using a nonanonymous account\n  can change the password for that account. To see which account the\n  server authenticated you as, invoke the CURRENT_USER() function:\n\nSELECT CURRENT_USER();\n\nWhen the read_only system variable is enabled, SET PASSWORD requires\nthe SUPER privilege in addition to any other required privileges.\n\nIf a FOR user clause is given, the account name uses the format\ndescribed in http://dev.mysql.com/doc/refman/5.7/en/account-names.html.\nThe user value should be given as \'user_name\'@\'host_name\', where\n\'user_name\' and \'host_name\' are exactly as listed in the User and Host\ncolumns of the account\'s mysql.user table row. If you specify only a\nuser name, a host name of \'%\' is used. For example, to set the password\nfor an account with User and Host column values of \'bob\' and\n\'%.example.org\', write the statement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.example.org\' = PASSWORD(\'auth_string\');\n\nThe password can be specified in these ways:\n\no Using the PASSWORD() function (deprecated as of MySQL 5.7.6)\n\n  The \'auth_string\' function argument is the cleartext (unencrypted)\n  password. PASSWORD() hashes the password and returns the encrypted\n  password string for storage in the mysql.user account row.\n\n  The PASSWORD() function hashes the password using the hashing method\n  determined by the value of the old_passwords system variable value.\n  If SET PASSWORD rejects the hashed password value returned by\n  PASSWORD() as not being in the correct format, it may be necessary to\n  change old_passwords to change the hashing method. For example, if\n  the account uses the mysql_native_password plugin, the old_passwords\n  value must be 0:\n\nSET old_passwords = 0;\nSET PASSWORD FOR \'jeffrey\'@\'localhost\' = PASSWORD(\'mypass\');\n\n  If the old_passwords value differs from that required by the\n  authentication plugin, the hashed password value returned by\n  PASSWORD() is not acceptable for that plugin, and attempts to set the\n  password produce an error. For example:\n\nmysql> SET old_passwords = 1;\nmysql> SET PASSWORD FOR \'jeffrey\'@\'localhost\' = PASSWORD(\'mypass\');\nERROR 1372 (HY000): Password hash should be a 41-digit hexadecimal number\n\n  Permitted old_passwords values are described later in this section.\n\no Using the OLD_PASSWORD() function (permitted before MySQL 5.7.5\n  only):\n\n  The \'auth_string\' function argument is the cleartext (unencrypted)\n  password. OLD_PASSWORD() hashes the password using pre-4.1 hashing\n  and returns the encrypted password string for storage in the\n  mysql.user account row. This hashing method is appropriate only for\n  accounts that use the mysql_old_password authentication plugin.\n\n  *Note*: Passwords that use the pre-4.1 hashing method are less secure\n  than passwords that use the native password hashing method and should\n  be avoided. Pre-4.1 passwords are deprecated and support for them is\n  removed in MySQL 5.7.5. Consequently, OLD_PASSWORD() is deprecated\n  and is removed in MySQL 5.7.5. For account upgrade instructions, see\n  http://dev.mysql.com/doc/refman/5.7/en/account-upgrades.html.\n\no Using a string without PASSWORD() or OLD_PASSWORD()\n\n  For this syntax, the meaning differs in MySQL 5.7.6 and higher from\n  earlier versions:\n\n  o As of MySQL 5.7.6, SET PASSWORD interprets the string as a\n    cleartext string and hashes it appropriately for the account\n    authentication plugin before storing it in the mysql.user account\n    row.\n\n  o Before MySQL 5.7.6, SET PASSWORD interprets the string as a hashed\n    password value to be stored directly. The string must be hashed in\n    the format required by the account authentication plugin. A string\n    not hashed appropriately causes client connections for the account\n    to fail with an Access denied error.\n\nFor more information about setting passwords, see\nhttp://dev.mysql.com/doc/refman/5.7/en/assigning-passwords.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/set-password.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/set-password.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (300,7,'JSON_QUOTE','JSON_QUOTE(json_val)\n\nQuotes a string as a JSON value by wrapping it with double quote\ncharacters and escaping interior quote and other characters, then\nreturning the result as a utf8mb4 string. Returns NULL if the argument\nis NULL.\n\nThis function is typically used to produce a valid JSON string literal\nfor inclusion within a JSON document.\n\nCertain special characters are escaped with backslashes per the escape\nsequences shown in\nhttp://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html\n#json-unquote-character-escape-sequences.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-creation-functions.html\n\n','mysql> SELECT JSON_QUOTE(\'null\'), JSON_QUOTE(\'"null"\');\n+--------------------+----------------------+\n| JSON_QUOTE(\'null\') | JSON_QUOTE(\'"null"\') |\n+--------------------+----------------------+\n| "null"             | "\\"null\\""           |\n+--------------------+----------------------+\nmysql> SELECT JSON_QUOTE(\'[1, 2, 3]\');\n+-------------------------+\n| JSON_QUOTE(\'[1, 2, 3]\') |\n+-------------------------+\n| "[1, 2, 3]"             |\n+-------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-creation-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (301,17,'DATABASE','Syntax:\nDATABASE()\n\nReturns the default (current) database name as a string in the utf8\ncharacter set. If there is no default database, DATABASE() returns\nNULL. Within a stored routine, the default database is the database\nthat the routine is associated with, which is not necessarily the same\nas the database that is the default in the calling context.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> SELECT DATABASE();\n        -> \'test\'\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (302,6,'IF FUNCTION','Syntax:\nIF(expr1,expr2,expr3)\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns\nexpr2; otherwise it returns expr3. IF() returns a numeric or string\nvalue, depending on the context in which it is used.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/control-flow-functions.html\n\n','mysql> SELECT IF(1>2,2,3);\n        -> 3\nmysql> SELECT IF(1<2,\'yes\',\'no\');\n        -> \'yes\'\nmysql> SELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n        -> \'no\'\n','http://dev.mysql.com/doc/refman/5.7/en/control-flow-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (303,33,'POINTFROMWKB','PointFromWKB(wkb[,srid])\n\nST_PointFromWKB() and PointFromWKB() are synonyms. For more\ninformation, see the description of ST_PointFromWKB().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (304,3,'POWER','Syntax:\nPOWER(X,Y)\n\nThis is a synonym for POW().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (305,3,'ATAN','Syntax:\nATAN(X)\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT ATAN(2);\n        -> 1.1071487177941\nmysql> SELECT ATAN(-2);\n        -> -1.1071487177941\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (306,27,'SHOW PROFILE','Syntax:\nSHOW PROFILE [type [, type] ... ]\n    [FOR QUERY n]\n    [LIMIT row_count [OFFSET offset]]\n\ntype:\n    ALL\n  | BLOCK IO\n  | CONTEXT SWITCHES\n  | CPU\n  | IPC\n  | MEMORY\n  | PAGE FAULTS\n  | SOURCE\n  | SWAPS\n\nThe SHOW PROFILE and SHOW PROFILES statements display profiling\ninformation that indicates resource usage for statements executed\nduring the course of the current session.\n\n*Note*: These statements are deprecated and will be removed in a future\nMySQL release. Use the Performance Schema instead; see\nhttp://dev.mysql.com/doc/refman/5.7/en/performance-schema-query-profili\nng.html.\n\nProfiling is controlled by the profiling session variable, which has a\ndefault value of 0 (OFF). Profiling is enabled by setting profiling to\n1 or ON:\n\nmysql> SET profiling = 1;\n\nSHOW PROFILES displays a list of the most recent statements sent to the\nserver. The size of the list is controlled by the\nprofiling_history_size session variable, which has a default value of\n15. The maximum value is 100. Setting the value to 0 has the practical\neffect of disabling profiling.\n\nAll statements are profiled except SHOW PROFILE and SHOW PROFILES, so\nyou will find neither of those statements in the profile list.\nMalformed statements are profiled. For example, SHOW PROFILING is an\nillegal statement, and a syntax error occurs if you try to execute it,\nbut it will show up in the profiling list.\n\nSHOW PROFILE displays detailed information about a single statement.\nWithout the FOR QUERY n clause, the output pertains to the most\nrecently executed statement. If FOR QUERY n is included, SHOW PROFILE\ndisplays information for statement n. The values of n correspond to the\nQuery_ID values displayed by SHOW PROFILES.\n\nThe LIMIT row_count clause may be given to limit the output to\nrow_count rows. If LIMIT is given, OFFSET offset may be added to begin\nthe output offset rows into the full set of rows.\n\nBy default, SHOW PROFILE displays Status and Duration columns. The\nStatus values are like the State values displayed by SHOW PROCESSLIST,\nalthough there might be some minor differences in interpretion for the\ntwo statements for some status values (see\nhttp://dev.mysql.com/doc/refman/5.7/en/thread-information.html).\n\nOptional type values may be specified to display specific additional\ntypes of information:\n\no ALL displays all information\n\no BLOCK IO displays counts for block input and output operations\n\no CONTEXT SWITCHES displays counts for voluntary and involuntary\n  context switches\n\no CPU displays user and system CPU usage times\n\no IPC displays counts for messages sent and received\n\no MEMORY is not currently implemented\n\no PAGE FAULTS displays counts for major and minor page faults\n\no SOURCE displays the names of functions from the source code, together\n  with the name and line number of the file in which the function\n  occurs\n\no SWAPS displays swap counts\n\nProfiling is enabled per session. When a session ends, its profiling\ninformation is lost.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-profile.html\n\n','mysql> SELECT @@profiling;\n+-------------+\n| @@profiling |\n+-------------+\n|           0 |\n+-------------+\n1 row in set (0.00 sec)\n\nmysql> SET profiling = 1;\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> DROP TABLE IF EXISTS t1;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nmysql> CREATE TABLE T1 (id INT);\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> SHOW PROFILES;\n+----------+----------+--------------------------+\n| Query_ID | Duration | Query                    |\n+----------+----------+--------------------------+\n|        0 | 0.000088 | SET PROFILING = 1        |\n|        1 | 0.000136 | DROP TABLE IF EXISTS t1  |\n|        2 | 0.011947 | CREATE TABLE t1 (id INT) |\n+----------+----------+--------------------------+\n3 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE;\n+----------------------+----------+\n| Status               | Duration |\n+----------------------+----------+\n| checking permissions | 0.000040 |\n| creating table       | 0.000056 |\n| After create         | 0.011363 |\n| query end            | 0.000375 |\n| freeing items        | 0.000089 |\n| logging slow query   | 0.000019 |\n| cleaning up          | 0.000005 |\n+----------------------+----------+\n7 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE FOR QUERY 1;\n+--------------------+----------+\n| Status             | Duration |\n+--------------------+----------+\n| query end          | 0.000107 |\n| freeing items      | 0.000008 |\n| logging slow query | 0.000015 |\n| cleaning up        | 0.000006 |\n+--------------------+----------+\n4 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE CPU FOR QUERY 2;\n+----------------------+----------+----------+------------+\n| Status               | Duration | CPU_user | CPU_system |\n+----------------------+----------+----------+------------+\n| checking permissions | 0.000040 | 0.000038 |   0.000002 |\n| creating table       | 0.000056 | 0.000028 |   0.000028 |\n| After create         | 0.011363 | 0.000217 |   0.001571 |\n| query end            | 0.000375 | 0.000013 |   0.000028 |\n| freeing items        | 0.000089 | 0.000010 |   0.000014 |\n| logging slow query   | 0.000019 | 0.000009 |   0.000010 |\n| cleaning up          | 0.000005 | 0.000003 |   0.000002 |\n+----------------------+----------+----------+------------+\n7 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/show-profile.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (307,3,'LN','Syntax:\nLN(X)\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X.\nIf X is less than or equal to 0.0E0, the function returns NULL and (as\nof MySQL 5.7.4) a warning "Invalid argument for logarithm" is reported.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT LN(2);\n        -> 0.69314718055995\nmysql> SELECT LN(-2);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (308,24,'RETURN','Syntax:\nRETURN expr\n\nThe RETURN statement terminates execution of a stored function and\nreturns the value expr to the function caller. There must be at least\none RETURN statement in a stored function. There may be more than one\nif the function has multiple exit points.\n\nThis statement is not used in stored procedures, triggers, or events.\nThe LEAVE statement can be used to exit a stored program of those\ntypes.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/return.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/return.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (309,8,'SET SQL_LOG_BIN','Syntax:\nSET sql_log_bin = {0|1}\n\nThe sql_log_bin variable controls whether logging to the binary log is\ndone. The default value is 1 (do logging). To change logging for the\ncurrent session, change the session value of this variable. The session\nuser must have the SUPER privilege to set this variable. Set this\nvariable to 0 for a session to temporarily disable binary logging while\nmaking changes to the master which you do not want to replicate to the\nslave.\n\nAs of MySQL 5.5, sql_log_bin can be set as a global or session\nvariable. Setting sql_log_bin globally is only detected when a new\nsession is started. Any sessions previously running are not impacted\nwhen setting sql_log_bin globally.\n\n*Warning*: Incorrect use of sql_log_bin with a global scope means any\nchanges made in an already running session are still being recorded to\nthe binary log and therefore replicated. Exercise extreme caution using\nsql_log_bin with a global scope as the above situation could cause\nunexpected results including replication failure.\n\nIn MySQL 5.7, it is not possible to set @@session.sql_log_bin within a\ntransaction or subquery. (Bug #53437)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/set-sql-log-bin.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/set-sql-log-bin.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (310,12,'AES_DECRYPT','Syntax:\nAES_DECRYPT(crypt_str,key_str[,init_vector])\n\nThis function decrypts data using the official AES (Advanced Encryption\nStandard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nThe optional initialization vector argument, init_vector, is available\nas of MySQL 5.7.4. As of that version, statements that use\nAES_DECRYPT() are unsafe for statement-based replication and cannot be\nstored in the query cache.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (311,17,'COERCIBILITY','Syntax:\nCOERCIBILITY(str)\n\nReturns the collation coercibility value of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> SELECT COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci);\n        -> 0\nmysql> SELECT COERCIBILITY(USER());\n        -> 3\nmysql> SELECT COERCIBILITY(\'abc\');\n        -> 4\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (312,23,'INT','INT[(M)] [UNSIGNED] [ZEROFILL]\n\nA normal-size integer. The signed range is -2147483648 to 2147483647.\nThe unsigned range is 0 to 4294967295.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (313,13,'GLENGTH','GLength(ls)\n\nGLength() is a nonstandard name. It corresponds to the OpenGIS\nST_Length() function. (There is an existing SQL function Length() that\ncalculates the length of string values.)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (314,27,'SHUTDOWN','Syntax:\nSHUTDOWN\n\nThis statement stops the MySQL server. It requires the SHUTDOWN\nprivilege.\n\nSHUTDOWN was added in MySQL 5.7.9. It provides an SQL-level interface\nto the same functionality available using the mysqladmin shutdown\ncommand or the mysql_shutdown() C API function.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/shutdown.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/shutdown.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (315,7,'JSON_REMOVE','JSON_REMOVE(json_doc, path[, path] ...)\n\nRemoves data from a JSON document and returns the result. Returns NULL\nif any argument is NULL. An error occurs if the json_doc argument is\nnot a valid JSON document or any path argument is not a valid path\nexpression or is $ or contains a * or ** wildcard.\n\nThe path arguments are evaluated left to right. The document produced\nby evaluating one path becomes the new value against which the next\npath is evaluated.\n\nIt is not an error if the element to be removed does not exist in the\ndocument; in that case, the path does not affect the document.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html\n\n','mysql> SET @j = \'["a", ["b", "c"], "d"]\';\nmysql> SELECT JSON_REMOVE(@j, \'$[1]\');\n+-------------------------+\n| JSON_REMOVE(@j, \'$[1]\') |\n+-------------------------+\n| ["a", "d"]              |\n+-------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (316,7,'ST_ASGEOJSON','ST_AsGeoJSON(g [, max_dec_digits [, options]])\n\nGenerates a GeoJSON object from the geometry g. The object string has\nthe connection character set and collation.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-geojson-functions.html\n\n','mysql> SELECT ST_AsGeoJSON(ST_GeomFromText(\'POINT(11.11111 12.22222)\'),2);\n+-------------------------------------------------------------+\n| ST_AsGeoJSON(ST_GeomFromText(\'POINT(11.11111 12.22222)\'),2) |\n+-------------------------------------------------------------+\n| {"type": "Point", "coordinates": [11.11, 12.22]}            |\n+-------------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-geojson-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (317,26,'ST_BUFFER_STRATEGY','ST_Buffer_Strategy(strategy[,points_per_circle])\n\nThis function returns a strategy byte string for use with ST_Buffer()\nto influence buffer computation. The result is NULL if any argument is\nNULL. If any argument is invalid, an ER_WRONG_ARGUMENTS error occurs.\n\nInformation about strategies is available at Boost.org\n(http://www.boost.org).\n\nThe first argument must be a string indicating a strategy option:\n\no For point strategies, permitted values are \'point_circle\' and\n  \'point_square\'.\n\no For join strategies, permitted values are \'join_round\' and\n  \'join_miter\'.\n\no For end strategies, permitted values are \'end_round\' and \'end_flat\'.\n\nIf the first argument is \'point_circle\', \'join_round\', \'join_miter\', or\n\'end_round\', the points_per_circle argument must be given as a positive\nnumeric value. The maximum points_per_circle value is the value of the\nmax_points_in_geometry system variable as of MySQL 5.7.8, 65,536 before\nthat. If the first argument is \'point_square\' or \'end_flat\', the\npoints_per_circle argument must not be given or an ER_WRONG_ARGUMENTS\nerror occurs.\n\nFor examples, see the description of ST_Buffer().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (318,38,'MAKE_SET','Syntax:\nMAKE_SET(bits,str1,str2,...)\n\nReturns a set value (a string containing substrings separated by ","\ncharacters) consisting of the strings that have the corresponding bit\nin bits set. str1 corresponds to bit 0, str2 to bit 1, and so on. NULL\nvalues in str1, str2, ... are not appended to the result.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT MAKE_SET(1,\'a\',\'b\',\'c\');\n        -> \'a\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',\'world\');\n        -> \'hello,world\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',NULL,\'world\');\n        -> \'hello\'\nmysql> SELECT MAKE_SET(0,\'a\',\'b\',\'c\');\n        -> \'\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (319,38,'FIND_IN_SET','Syntax:\nFIND_IN_SET(str,strlist)\n\nReturns a value in the range of 1 to N if the string str is in the\nstring list strlist consisting of N substrings. A string list is a\nstring composed of substrings separated by "," characters. If the first\nargument is a constant string and the second is a column of type SET,\nthe FIND_IN_SET() function is optimized to use bit arithmetic. Returns\n0 if str is not in strlist or if strlist is the empty string. Returns\nNULL if either argument is NULL. This function does not work properly\nif the first argument contains a comma (",") character.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT FIND_IN_SET(\'b\',\'a,b,c,d\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (320,16,'MIN','Syntax:\nMIN([DISTINCT] expr)\n\nReturns the minimum value of expr. MIN() may take a string argument; in\nsuch cases, it returns the minimum string value. See\nhttp://dev.mysql.com/doc/refman/5.7/en/mysql-indexes.html. The DISTINCT\nkeyword can be used to find the minimum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nMIN() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (321,28,'REPLACE','Syntax:\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)] \n    [(col_name,...)]\n    {VALUES | VALUE} ({expr | DEFAULT},...),(...),...\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)] \n    SET col_name={expr | DEFAULT}, ...\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)]  \n    [(col_name,...)]\n    SELECT ...\n\nREPLACE works exactly like INSERT, except that if an old row in the\ntable has the same value as a new row for a PRIMARY KEY or a UNIQUE\nindex, the old row is deleted before the new row is inserted. See [HELP\nINSERT].\n\nREPLACE is a MySQL extension to the SQL standard. It either inserts, or\ndeletes and inserts. For another MySQL extension to standard SQL---that\neither inserts or updates---see\nhttp://dev.mysql.com/doc/refman/5.7/en/insert-on-duplicate.html.\n\nDELAYED inserts and replaces were deprecated in MySQL 5.6.6. In MySQL\n5.7, DELAYED is not supported. The server recognizes but ignores the\nDELAYED keyword, handles the replace as a nondelayed replace, and\ngenerates an ER_WARN_LEGACY_SYNTAX_CONVERTED warning. ("REPLACE DELAYED\nis no longer supported. The statement was converted to REPLACE.") The\nDELAYED keyword will be removed in a future release.\n\n*Note*: REPLACE makes sense only if a table has a PRIMARY KEY or UNIQUE\nindex. Otherwise, it becomes equivalent to INSERT, because there is no\nindex to be used to determine whether a new row duplicates another.\n\nValues for all columns are taken from the values specified in the\nREPLACE statement. Any missing columns are set to their default values,\njust as happens for INSERT. You cannot refer to values from the current\nrow and use them in the new row. If you use an assignment such as SET\ncol_name = col_name + 1, the reference to the column name on the right\nhand side is treated as DEFAULT(col_name), so the assignment is\nequivalent to SET col_name = DEFAULT(col_name) + 1.\n\nIf a generated column is replaced explicitly, the only permitted value\nis DEFAULT. For information about generated columns, see\nhttp://dev.mysql.com/doc/refman/5.7/en/create-table-generated-columns.h\ntml.\n\nTo use REPLACE, you must have both the INSERT and DELETE privileges for\nthe table.\n\nREPLACE supports explicit partition selection using the PARTITION\nkeyword with a comma-separated list of names of partitions,\nsubpartitions, or both. As with INSERT, if it is not possible to insert\nthe new row into any of these partitions or subpartitions, the REPLACE\nstatement fails with the error Found a row not matching the given\npartition set. See\nhttp://dev.mysql.com/doc/refman/5.7/en/partitioning-selection.html, for\nmore information.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/replace.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/replace.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (322,32,'CURRENT_TIMESTAMP','Syntax:\nCURRENT_TIMESTAMP, CURRENT_TIMESTAMP([fsp])\n\nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (323,26,'ST_SYMDIFFERENCE','ST_SymDifference(g1, g2)\n\nReturns a geometry that represents the point set symmetric difference\nof the geometry values g1 and g2, which is defined as:\n\ng1 symdifference g2 := (g1 union g2) difference (g1 intersection g2)\n\nOr, in function call notation:\n\nST_SymDifference(g1, g2) = ST_Difference(ST_Union(g1, g2), ST_Intersection(g1, g2))\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html\n\n','mysql> SET @g1 = POINT(1,1), @g2 = POINT(2,2);\nmysql> SELECT ST_AsText(ST_SymDifference(@g1, @g2));\n+-------------------------------------------+\n| ST_AsText(ST_SymDifference(@g1, @g2))     |\n+-------------------------------------------+\n| GEOMETRYCOLLECTION(POINT(1 1),POINT(2 2)) |\n+-------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (324,7,'GTID_SUBSET','Syntax:\nGTID_SUBSET(subset,set)\n\nGiven two sets of global transaction IDs subset and set, returns true\nif all GTIDs in subset are also in set. Returns false otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gtid-functions.html\n\n','mysql> SELECT GTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23\', \n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\')\\G\n*************************** 1. row ***************************\nGTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23\', \n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\'): 1\n1 row in set (0.00 sec)\n\nmysql> SELECT GTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-25\', \n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\')\\G\n*************************** 1. row ***************************\nGTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-25\', \n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\'): 1\n1 row in set (0.00 sec)\n\nmysql> SELECT GTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\', \n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\')\\G\n*************************** 1. row ***************************\nGTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\', \n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\'): 0\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/gtid-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (325,16,'VAR_SAMP','Syntax:\nVAR_SAMP(expr)\n\nReturns the sample variance of expr. That is, the denominator is the\nnumber of rows minus one.\n\nVAR_SAMP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (326,23,'DATETIME','DATETIME[(fsp)]\n\nA date and time combination. The supported range is \'1000-01-01\n00:00:00.000000\' to \'9999-12-31 23:59:59.999999\'. MySQL displays\nDATETIME values in \'YYYY-MM-DD HH:MM:SS[.fraction]\' format, but permits\nassignment of values to DATETIME columns using either strings or\nnumbers.\n\nAn optional fsp value in the range from 0 to 6 may be given to specify\nfractional seconds precision. A value of 0 signifies that there is no\nfractional part. If omitted, the default precision is 0.\n\nAutomatic initialization and updating to the current date and time for\nDATETIME columns can be specified using DEFAULT and ON UPDATE column\ndefinition clauses, as described in\nhttp://dev.mysql.com/doc/refman/5.7/en/timestamp-initialization.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (327,8,'CHANGE REPLICATION FILTER','Syntax:\nCHANGE REPLICATION FILTER filter[, filter][, ...]\n\nfilter:\n    REPLICATE_DO_DB = (db_list)\n  | REPLICATE_IGNORE_DB = (db_list)\n  | REPLICATE_DO_TABLE = (tbl_list)\n  | REPLICATE_IGNORE_TABLE = (tbl_list)\n  | REPLICATE_WILD_DO_TABLE = (wild_tbl_list)\n  | REPLICATE_WILD_IGNORE_TABLE = (wild_tbl_list)\n  | REPLICATE_REWRITE_DB = (db_pair_list)\n\ndb_list:\n    db_name[, db_name][, ...]\n\ntbl_list:\n    db_name.table_name[, db_table_name][, ...]\nwild_tbl_list:\n    \'db_pattern.table_pattern\'[, \'db_pattern.table_pattern\'][, ...]\n\ndb_pair_list:\n    (db_pair)[, (db_pair)][, ...]\n\ndb_pair:\n    from_db, to_db\n\nIn MySQL 5.7.3 and later, CHANGE REPLICATION FILTER sets one or more\nreplication filtering rules on the slave in the same way as starting\nthe slave mysqld with replication filtering options such as\n--replicate-do-db or --replicate-wild-ignore-table. Unlike the case\nwith the server options, this statement does not require restarting the\nserver to take effect, only that the slave SQL thread be stopped using\nSTOP SLAVE SQL_THREAD first (and restarted with START SLAVE SQL_THREAD\nafterwards).\n\nThe following list shows the CHANGE REPLICATION FILTER options and how\nthey relate to --replicate-* server options:\n\no REPLICATE_DO_DB: Include updates based on database name. Equivalent\n  to --replicate-do-db.\n\no REPLICATE_IGNORE_DB: Exclude updates based on database name.\n  Equivalent to --replicate-ignore-db.\n\no REPLICATE_DO_TABLE: Include updates based on table name. Equivalent\n  to --replicate-do-table.\n\no REPLICATE_IGNORE_TABLE: Exclude updates based on table name.\n  Equivalent to --replicate-ignore-table.\n\no REPLICATE_WILD_DO_TABLE: Include updates based on wildcard pattern\n  matching table name. Equivalent to --replicate-wild-do-table.\n\no REPLICATE_WILD_IGNORE_TABLE: Exclude updates based on wildcard\n  pattern matching table name. Equivalent to\n  --replicate-wild-ignore-table.\n\no REPLICATE_REWRITE_DB: Perform updates on slave after substituting new\n  name on slave for specified database on master. Equivalent to\n  --replicate-rewrite-db.\n\nThe precise effects of REPLICATE_DO_DB and REPLICATE_IGNORE_DB filters\nare dependent on whether statement-based or row-based replication is in\neffect. See\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-rules.html, for more\ninformation.\n\nMultiple replication filtering rules can be created in a single CHANGE\nREPLICATION FILTER statement by separating the rules with commas, as\nshown here:\n\nCHANGE REPLICATION FILTER\n    REPLICATE_DO_DB = (d1), REPLICATE_IGNORE_DB = (d2);\n\nIssuing the statement just shown is equivalent to starting the slave\nmysqld with the options --replicate-do-db=d1 --replicate-ignore-db=d2.\n\nIf the same filtering rule is specified multiple times, only the last\nsuch rule is actually used. For example, the two statements shown here\nhave exactly the same effect, because the first REPLICATE_DO_DB rule in\nthe first statement is ignored:\n\nCHANGE REPLICATION FILTER \n    REPLICATE_DO_DB = (db1, db2), REPLICATE_DO_DB = (db3, db4);\n\nCHANGE REPLICATION FILTER \n    REPLICATE_DO_DB = (db3,db4);\n\n*Caution*: This behavior differs from that of the --replicate-* filter\noptions where specifying the same option multiple times causes the\ncreation of multiple filter rules.\n\nNames of tables and database not containing any special characters need\nnot be quoted. Values used with REPLICATION_WILD_TABLE and\nREPLICATION_WILD_IGNORE_TABLE are string expressions, possibly\ncontaining (special) wildcard characters, and so must be quoted. This\nis shown in the following example statements:\n\nCHANGE REPLICATION FILTER \n    REPLICATE_WILD_DO_TABLE = (\'db1.old%\');\n\nCHANGE REPLICATION FILTER \n    REPLICATE_WILD_IGNORE_TABLE = (\'db1.new%\', \'db2.new*\');\n\nValues used with REPLICATE_REWRITE_DB represent pairs of database\nnames; each such value must be enclosed in parentheses. The following\nstatement rewrites statements occurring on database dbA on the master\nto database dbB on the slave:\n\nCHANGE REPLICATION FILTER REPLICATE_REWRITE_DB = ((db1, db2));\n\nThe statement just shown contains two sets of parentheses, one\nenclosing the pair of database names, and the other enclosing the\nentire list. This is perhap more easily seen in the following example,\nwhich creates two rewrite-db rules, one rewriting database dbA to dbB,\nand one rewriting database dbC to dbD:\n\nCHANGE REPLICATION FILTER \n  REPLICATE_REWRITE_DB = ((dbA, dbB), (dbC, dbD));\n\nThis statement leaves any existing replication filtering rules\nunchanged; to unset all filters of a given type, set the filter\'s value\nto an explicitly empty list, as shown in this example, which removes\nall existing REPLICATE_DO_DB and REPLICATE_IGNORE_DB rules:\n\nCHANGE REPLICATION FILTER \n    REPLICATE_DO_DB = (), REPLICATE_IGNORE_DB = ();\n\nSetting a filter to empty in this way removes all existing rules, does\nnot create any new ones, and does not restore any rules set at mysqld\nstartup using --replicate-* options on the command line or in the\nconfiguration file.\n\nValues employed with REPLICATE_WILD_DO_TABLE and\nREPLICATE_WILD_IGNORE_TABLE must be in the format db_name.tbl_name.\nPrior to MySQL 5.7.5, this was not strictly enforced, although using\nnonconforming values with these options could lead to erroneous results\n(Bug #18095449).\n\nFor more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-rules.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/change-replication-filter.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/change-replication-filter.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (328,23,'INTEGER','INTEGER[(M)] [UNSIGNED] [ZEROFILL]\n\nThis type is a synonym for INT.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (329,27,'SHOW COLUMNS','Syntax:\nSHOW [FULL] COLUMNS {FROM | IN} tbl_name [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW COLUMNS displays information about the columns in a given table.\nIt also works for views. The LIKE clause, if present, indicates which\ncolumn names to match. The WHERE clause can be given to select rows\nusing more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nSHOW COLUMNS displays information only for those columns for which you\nhave some privilege.\n\nmysql> SHOW COLUMNS FROM City;\n+------------+----------+------+-----+---------+----------------+\n| Field      | Type     | Null | Key | Default | Extra          |\n+------------+----------+------+-----+---------+----------------+\n| Id         | int(11)  | NO   | PRI | NULL    | auto_increment |\n| Name       | char(35) | NO   |     |         |                |\n| Country    | char(3)  | NO   | UNI |         |                |\n| District   | char(20) | YES  | MUL |         |                |\n| Population | int(11)  | NO   |     | 0       |                |\n+------------+----------+------+-----+---------+----------------+\n5 rows in set (0.00 sec)\n\nIf the data types differ from what you expect them to be based on a\nCREATE TABLE statement, note that MySQL sometimes changes data types\nwhen you create or alter a table. The conditions under which this\noccurs are described in\nhttp://dev.mysql.com/doc/refman/5.7/en/silent-column-changes.html.\n\nThe FULL keyword causes the output to include the column collation and\ncomments, as well as the privileges you have for each column.\n\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM\ndb_name syntax. In other words, these two statements are equivalent:\n\nmysql> SHOW COLUMNS FROM mytable FROM mydb;\nmysql> SHOW COLUMNS FROM mydb.mytable;\n\nSHOW COLUMNS displays the following values for each table column:\n\nField indicates the column name.\n\nType indicates the column data type.\n\nCollation indicates the collation for nonbinary string columns, or NULL\nfor other columns. This value is displayed only if you use the FULL\nkeyword.\n\nThe Null field contains YES if NULL values can be stored in the column,\nNO if not.\n\nThe Key field indicates whether the column is indexed:\n\no If Key is empty, the column either is not indexed or is indexed only\n  as a secondary column in a multiple-column, nonunique index.\n\no If Key is PRI, the column is a PRIMARY KEY or is one of the columns\n  in a multiple-column PRIMARY KEY.\n\no If Key is UNI, the column is the first column of a UNIQUE index. (A\n  UNIQUE index permits multiple NULL values, but you can tell whether\n  the column permits NULL by checking the Null field.)\n\no If Key is MUL, the column is the first column of a nonunique index in\n  which multiple occurrences of a given value are permitted within the\n  column.\n\nIf more than one of the Key values applies to a given column of a\ntable, Key displays the one with the highest priority, in the order\nPRI, UNI, MUL.\n\nA UNIQUE index may be displayed as PRI if it cannot contain NULL values\nand there is no PRIMARY KEY in the table. A UNIQUE index may display as\nMUL if several columns form a composite UNIQUE index; although the\ncombination of the columns is unique, each column can still hold\nmultiple occurrences of a given value.\n\nThe Default field indicates the default value that is assigned to the\ncolumn. This is NULL if the column has an explicit default of NULL, or\nif the column definition has no DEFAULT clause.\n\nThe Extra field contains any additional information that is available\nabout a given column. The value is nonempty in these cases:\n\no auto_increment for columns that have the AUTO_INCREMENT attribute\n\no on update CURRENT_TIMESTAMP for TIMESTAMP or DATETIME columns that\n  have the ON UPDATE CURRENT_TIMESTAMP attribute\n\no VIRTUAL GENERATED or VIRTUAL STORED for generated columns\n\nPrivileges indicates the privileges you have for the column. This value\nis displayed only if you use the FULL keyword.\n\nComment indicates any comment the column has. This value is displayed\nonly if you use the FULL keyword.\n\nSHOW FIELDS is a synonym for SHOW COLUMNS. You can also list a table\'s\ncolumns with the mysqlshow db_name tbl_name command.\n\nThe DESCRIBE statement provides information similar to SHOW COLUMNS.\nSee http://dev.mysql.com/doc/refman/5.7/en/describe.html.\n\nThe SHOW CREATE TABLE, SHOW TABLE STATUS, and SHOW INDEX statements\nalso provide information about tables. See [HELP SHOW].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-columns.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-columns.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (330,23,'TINYINT','TINYINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA very small integer. The signed range is -128 to 127. The unsigned\nrange is 0 to 255.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (331,14,'MASTER_POS_WAIT','Syntax:\nMASTER_POS_WAIT(log_name,log_pos[,timeout][,channel_name])\n\nThis function is useful for control of master/slave synchronization. It\nblocks until the slave has read and applied all updates up to the\nspecified position in the master log. The return value is the number of\nlog events the slave had to wait for to advance to the specified\nposition. The function returns NULL if the slave SQL thread is not\nstarted, the slave\'s master information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the\ntimeout has been exceeded. If the slave SQL thread stops while\nMASTER_POS_WAIT() is waiting, the function returns NULL. If the slave\nis past the specified position, the function returns immediately.\n\nIf a timeout value is specified, MASTER_POS_WAIT() stops waiting when\ntimeout seconds have elapsed. timeout must be greater than 0; a zero or\nnegative timeout means no timeout.\n\nThe optional channel added in MySQL 5.7.6 enables you to choose which\nreplication channel the function applies to. See\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-channels.html for\nmore information.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (332,19,'^','Syntax:\n^\n\nBitwise XOR:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html\n\n','mysql> SELECT 1 ^ 1;\n        -> 0\nmysql> SELECT 1 ^ 0;\n        -> 1\nmysql> SELECT 11 ^ 3;\n        -> 8\n','http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (333,40,'DROP VIEW','Syntax:\nDROP VIEW [IF EXISTS]\n    view_name [, view_name] ...\n    [RESTRICT | CASCADE]\n\nDROP VIEW removes one or more views. You must have the DROP privilege\nfor each view. If any of the views named in the argument list do not\nexist, MySQL returns an error indicating by name which nonexisting\nviews it was unable to drop, but it also drops all of the views in the\nlist that do exist.\n\nThe IF EXISTS clause prevents an error from occurring for views that\ndon\'t exist. When this clause is given, a NOTE is generated for each\nnonexistent view. See [HELP SHOW WARNINGS].\n\nRESTRICT and CASCADE, if given, are parsed and ignored.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-view.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-view.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (334,32,'WEEK','Syntax:\nWEEK(date[,mode])\n\nThis function returns the week number for date. The two-argument form\nof WEEK() enables you to specify whether the week starts on Sunday or\nMonday and whether the return value should be in the range from 0 to 53\nor from 1 to 53. If the mode argument is omitted, the value of the\ndefault_week_format system variable is used. See\nhttp://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT WEEK(\'2008-02-20\');\n        -> 7\nmysql> SELECT WEEK(\'2008-02-20\',0);\n        -> 7\nmysql> SELECT WEEK(\'2008-02-20\',1);\n        -> 8\nmysql> SELECT WEEK(\'2008-12-31\',1);\n        -> 53\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (335,22,'DROP FUNCTION UDF','Syntax:\nDROP FUNCTION function_name\n\nThis statement drops the user-defined function (UDF) named\nfunction_name.\n\nTo drop a function, you must have the DELETE privilege for the mysql\ndatabase. This is because DROP FUNCTION removes a row from the\nmysql.func system table that records the function\'s name, type, and\nshared library name.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-function-udf.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-function-udf.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (336,7,'ST_VALIDATE','ST_Validate(g)\n\nValidates a geometry according to the OGC specification. ST_Validate()\nreturns the geometry if it is a valid geometry byte string and is\ngeometrically valid, NULL if the argument is not a valid geometry byte\nstring or is not geometrically valid or is NULL.\n\nA geometry can be a valid geometry byte string (WKB value plus SRID)\nbut geometrically invalid. For example, this polygon is geometrically\ninvalid: POLYGON((0 0, 0 0, 0 0, 0 0, 0 0))\n\nST_Validate() can be used to filter out invalid geometry data, although\nat a cost. For applications that require more precise results not\ntainted by invalid data, this penalty may be worthwhile.\n\nIf the geometry argument is valid, it is returned as is, except that if\nan input Polygon or MultiPolygon has clockwise rings, those rings are\nreversed before checking for validity. If the geometry is valid, the\nvalue with the reversed rings is returned.\n\nThe only valid empty geometry is represented in the form of an empty\ngeometry collection value. ST_Validate() returns it directly without\nfurther checks in this case.\n\nST_Validate() works only for the cartesian coordinate system and\nrequires a geometry argument with an SRID of 0. An ER_WRONG_ARGUMENTS\nerror occurs otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-convenience-functions.html\n\n','mysql> SET @ls1 = ST_GeomFromText(\'LINESTRING(0 0)\');\nmysql> SET @ls2 = ST_GeomFromText(\'LINESTRING(0 0, 1 1)\');\nmysql> SELECT ST_AsText(ST_Validate(@ls1));\n+------------------------------+\n| ST_AsText(ST_Validate(@ls1)) |\n+------------------------------+\n| NULL                         |\n+------------------------------+\nmysql> SELECT ST_AsText(ST_Validate(@ls2));\n+------------------------------+\n| ST_AsText(ST_Validate(@ls2)) |\n+------------------------------+\n| LINESTRING(0 0,1 1)          |\n+------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-convenience-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (337,38,'UPDATEXML','Syntax:\nUpdateXML(xml_target, xpath_expr, new_xml)\n\nThis function replaces a single portion of a given fragment of XML\nmarkup xml_target with a new XML fragment new_xml, and then returns the\nchanged XML. The portion of xml_target that is replaced matches an\nXPath expression xpath_expr supplied by the user.\n\nIf no expression matching xpath_expr is found, or if multiple matches\nare found, the function returns the original xml_target XML fragment.\nAll three arguments should be strings.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/xml-functions.html\n\n','mysql> SELECT\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/a\', \'<e>fff</e>\') AS val1,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/b\', \'<e>fff</e>\') AS val2,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'//b\', \'<e>fff</e>\') AS val3,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/a/d\', \'<e>fff</e>\') AS val4,\n    ->   UpdateXML(\'<a><d></d><b>ccc</b><d></d></a>\', \'/a/d\', \'<e>fff</e>\') AS val5\n    -> \\G\n\n*************************** 1. row ***************************\nval1: <e>fff</e>\nval2: <a><b>ccc</b><d></d></a>\nval3: <a><e>fff</e><d></d></a>\nval4: <a><b>ccc</b><e>fff</e></a>\nval5: <a><d></d><b>ccc</b><d></d></a>\n','http://dev.mysql.com/doc/refman/5.7/en/xml-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (338,8,'RESET SLAVE','Syntax:\nRESET SLAVE [ALL] [channel_option]\n\nchannel_option: \n    FOR CHANNEL channel\n\nRESET SLAVE makes the slave forget its replication position in the\nmaster\'s binary log. This statement is meant to be used for a clean\nstart: It clears the master info and relay log info repositories,\ndeletes all the relay log files, and starts a new relay log file. It\nalso resets to 0 the replication delay specified with the MASTER_DELAY\noption to CHANGE MASTER TO. To use RESET SLAVE, the slave replication\nthreads must be stopped (use STOP SLAVE if necessary).\n\n*Note*: All relay log files are deleted, even if they have not been\ncompletely executed by the slave SQL thread. (This is a condition\nlikely to exist on a replication slave if you have issued a STOP SLAVE\nstatement or if the slave is highly loaded.)\n\nThe optional FOR CHANNEL channel clause added in MySQL 5.7.6 enables\nyou to choose which replication channel the statement applies to. If no\nclause is set and no extra channels exist, the statement applies to the\ndefault channel and behaves the same as versions of MySQL prior to\n5.7.6. Providing a FOR CHANNEL channel clause applies the RESET SLAVE\nstatement to a specific replication channel. Combining a FOR CHANNEL\nchannel clause with the ALL option deletes the specified channel.\nIssuing a RESET SLAVE ALL statement without a FOR CHANNEL channel\nclause when multiple replication channels exist deletes all replication\nchannels and recreates only the default channel. See\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-channels.html for\nmore information.\n\nRESET SLAVE does not change any replication connection parameters such\nas master host, master port, master user, or master password, which are\nretained in memory. This means that START SLAVE can be issued without\nrequiring a CHANGE MASTER TO statement following RESET SLAVE.\n\nConnection parameters are reset by RESET SLAVE ALL. (RESET SLAVE\nfollowed by a restart of the slave mysqld also does this.)\n\nIn MySQL 5.7 RESET SLAVE causes an implicit commit of an ongoing\ntransaction. See\nhttp://dev.mysql.com/doc/refman/5.7/en/implicit-commit.html.\n\nIf the slave SQL thread was in the middle of replicating temporary\ntables when it was stopped, and RESET SLAVE is issued, these replicated\ntemporary tables are deleted on the slave.\n\nPrior to MySQL 5.7.5, RESET SLAVE also had the effect of resetting both\nthe heartbeat period (Slave_heartbeat_period) and\nSSL_VERIFY_SERVER_CERT. This issue is fixed in MySQL 5.7.5 and later.\n(Bug #18777899, Bug #18778485)\n\nPrior to MySQL 5.7.5, RESET SLAVE ALL did not clear the\nIGNORE_SERVER_IDS list set by CHANGE MASTER TO. In MySQL 5.7.5 and\nlater, the statement clears the list. (Bug #18816897)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/reset-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/reset-slave.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (339,7,'ST_POINTFROMGEOHASH','ST_PointFromGeoHash(geohash_str, srid)\n\nReturns a POINT value containing the decoded geohash value, given a\ngeohash string value. The X and Y coordinates of the point are the\nlongitude in the range [-180, 180] and the latitude in the range [-90,\n90], respectively. The srid value is an unsigned 32-bit integer. The\nresult is NULL if any argument is NULL. An error occurs if any argument\nis invalid.\n\nThe remarks in the description of ST_LatFromGeoHash() regarding the\nmaximum number of characters processed from the geohash_str argument\nalso apply to ST_PointFromGeoHash().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-geohash-functions.html\n\n','mysql> SET @gh = ST_GeoHash(45,-20,10);\nmysql> SELECT ST_AsText(ST_PointFromGeoHash(@gh,0));\n+---------------------------------------+\n| ST_AsText(ST_PointFromGeoHash(@gh,0)) |\n+---------------------------------------+\n| POINT(45 -20)                         |\n+---------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-geohash-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (340,32,'DAY','Syntax:\nDAY(date)\n\nDAY() is a synonym for DAYOFMONTH().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (341,14,'UUID','Syntax:\nUUID()\n\nReturns a Universal Unique Identifier (UUID) generated according to RFC\n4122, "A Universally Unique IDentifier (UUID) URN Namespace"\n(http://www.ietf.org/rfc/rfc4122.txt).\n\nA UUID is designed as a number that is globally unique in space and\ntime. Two calls to UUID() are expected to generate two different\nvalues, even if these calls are performed on two separate devices not\nconnected to each other.\n\n*Warning*: Although UUID() values are intended to be unique, they are\nnot necessarily unguessable or unpredictable. If unpredictability is\nrequired, UUID values should be generated some other way.\n\nUUID() returns a value that conforms to UUID version 1 as described in\nRFC 4122. The value is a 128-bit number represented as a utf8 string of\nfive hexadecimal numbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee\nformat:\n\no The first three numbers are generated from the low, middle, and high\n  parts of a timestamp. The high part also includes the UUID version\n  number.\n\no The fourth number preserves temporal uniqueness in case the timestamp\n  value loses monotonicity (for example, due to daylight saving time).\n\no The fifth number is an IEEE 802 node number that provides spatial\n  uniqueness. A random number is substituted if the latter is not\n  available (for example, because the host device has no Ethernet card,\n  or it is unknown how to find the hardware address of an interface on\n  the host operating system). In this case, spatial uniqueness cannot\n  be guaranteed. Nevertheless, a collision should have very low\n  probability.\n\n  The MAC address of an interface is taken into account only on FreeBSD\n  and Linux. On other operating systems, MySQL uses a randomly\n  generated 48-bit number.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> SELECT UUID();\n        -> \'6ccd780c-baba-1026-9564-0040f4311e29\'\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (342,25,'LINESTRING','LineString(pt1,pt2,...)\n\nConstructs a LineString value from a number of Point or WKB Point\narguments. If the number of arguments is less than two, the return\nvalue is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (343,14,'SLEEP','Syntax:\nSLEEP(duration)\n\nSleeps (pauses) for the number of seconds given by the duration\nargument, then returns 0. The duration may have a fractional part. If\nthe argument is NULL or negative, SLEEP() produces a warning, or an\nerror in strict SQL mode.\n\nWhen sleep returns normally (without interruption), it returns 0:\n\nmysql> SELECT SLEEP(1000);\n+-------------+\n| SLEEP(1000) |\n+-------------+\n|           0 |\n+-------------+\n\nWhen SLEEP() is the only thing invoked by a query that is interrupted,\nit returns 1 and the query itself returns no error. This is true\nwhether the query is killed or times out:\n\no This statement is interrupted using KILL QUERY from another session:\n\nmysql> SELECT SLEEP(1000);\n+-------------+\n| SLEEP(1000) |\n+-------------+\n|           1 |\n+-------------+\n\no This statement is interrupted by timing out:\n\nmysql> SELECT /*+ MAX_EXECUTION_TIME(1) */ SLEEP(1000);\n+-------------+\n| SLEEP(1000) |\n+-------------+\n|           1 |\n+-------------+\n\nWhen SLEEP() is only part of a query that is interrupted, the query\nreturns an error:\n\no This statement is interrupted using KILL QUERY from another session:\n\nmysql> SELECT 1 FROM t1 WHERE SLEEP(1000);\nERROR 1317 (70100): Query execution was interrupted\n\no This statement is interrupted by timing out:\n\nmysql> SELECT /*+ MAX_EXECUTION_TIME(1000) */ 1 FROM t1 WHERE SLEEP(1000);\nERROR 3024 (HY000): Query execution was interrupted, maximum statement\nexecution time exceeded\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (344,40,'CREATE LOGFILE GROUP','Syntax:\nCREATE LOGFILE GROUP logfile_group\n    ADD UNDOFILE \'undo_file\'\n    [INITIAL_SIZE [=] initial_size]\n    [UNDO_BUFFER_SIZE [=] undo_buffer_size]\n    [REDO_BUFFER_SIZE [=] redo_buffer_size]\n    [NODEGROUP [=] nodegroup_id]\n    [WAIT]\n    [COMMENT [=] comment_text]\n    ENGINE [=] engine_name\n\nThis statement creates a new log file group named logfile_group having\na single UNDO file named \'undo_file\'. A CREATE LOGFILE GROUP statement\nhas one and only one ADD UNDOFILE clause. For rules covering the naming\nof log file groups, see\nhttp://dev.mysql.com/doc/refman/5.7/en/identifiers.html.\n\n*Note*: All MySQL Cluster Disk Data objects share the same namespace.\nThis means that each Disk Data object must be uniquely named (and not\nmerely each Disk Data object of a given type). For example, you cannot\nhave a tablespace and a log file group with the same name, or a\ntablespace and a data file with the same name.\n\nThere can be only one log file group per MySQL Cluster instance at any\ngiven time.\n\nThe optional INITIAL_SIZE parameter sets the UNDO file\'s initial size;\nif not specified, it defaults to 128M (128 megabytes). The optional\nUNDO_BUFFER_SIZE parameter sets the size used by the UNDO buffer for\nthe log file group; The default value for UNDO_BUFFER_SIZE is 8M (eight\nmegabytes); this value cannot exceed the amount of system memory\navailable. Both of these parameters are specified in bytes. You may\noptionally follow either or both of these with a one-letter\nabbreviation for an order of magnitude, similar to those used in\nmy.cnf. Generally, this is one of the letters M (for megabytes) or G\n(for gigabytes).\n\nMemory used for UNDO_BUFFER_SIZE comes from the global pool whose size\nis determined by the value of the SharedGlobalMemory data node\nconfiguration parameter. This includes any default value implied for\nthis option by the setting of the InitialLogFileGroup data node\nconfiguration parameter.\n\nThe maximum permitted for UNDO_BUFFER_SIZE is 629145600 (600 MB).\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is\n4294967296 (4 GB). (Bug #29186)\n\nThe minimum allowed value for INITIAL_SIZE is 1048576 (1 MB).\n\nThe ENGINE option determines the storage engine to be used by this log\nfile group, with engine_name being the name of the storage engine. In\nMySQL 5.7, this must be NDB (or NDBCLUSTER). If ENGINE is not set,\nMySQL tries to use the engine specified by the default_storage_engine\nserver system variable (formerly storage_engine). In any case, if the\nengine is not specified as NDB or NDBCLUSTER, the CREATE LOGFILE GROUP\nstatement appears to succeed but actually fails to create the log file\ngroup, as shown here:\n\nmysql> CREATE LOGFILE GROUP lg1 \n    ->     ADD UNDOFILE \'undo.dat\' INITIAL_SIZE = 10M;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nmysql> SHOW WARNINGS;\n+-------+------+------------------------------------------------------------------------------------------------+\n| Level | Code | Message                                                                                        |\n+-------+------+------------------------------------------------------------------------------------------------+\n| Error | 1478 | Table storage engine \'InnoDB\' does not support the create option \'TABLESPACE or LOGFILE GROUP\' |\n+-------+------+------------------------------------------------------------------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> DROP LOGFILE GROUP lg1 ENGINE = NDB;              \nERROR 1529 (HY000): Failed to drop LOGFILE GROUP\n\nmysql> CREATE LOGFILE GROUP lg1 \n    ->     ADD UNDOFILE \'undo.dat\' INITIAL_SIZE = 10M\n    ->     ENGINE = NDB;\nQuery OK, 0 rows affected (2.97 sec)\n\nThe fact that the CREATE LOGFILE GROUP statement does not actually\nreturn an error when a non-NDB storage engine is named, but rather\nappears to succeed, is a known issue which we hope to address in a\nfuture release of MySQL Cluster.\n\nREDO_BUFFER_SIZE, NODEGROUP, WAIT, and COMMENT are parsed but ignored,\nand so have no effect in MySQL 5.7. These options are intended for\nfuture expansion.\n\nWhen used with ENGINE [=] NDB, a log file group and associated UNDO log\nfile are created on each Cluster data node. You can verify that the\nUNDO files were created and obtain information about them by querying\nthe INFORMATION_SCHEMA.FILES table. For example:\n\nmysql> SELECT LOGFILE_GROUP_NAME, LOGFILE_GROUP_NUMBER, EXTRA\n    -> FROM INFORMATION_SCHEMA.FILES\n    -> WHERE FILE_NAME = \'undo_10.dat\';\n+--------------------+----------------------+----------------+\n| LOGFILE_GROUP_NAME | LOGFILE_GROUP_NUMBER | EXTRA          |\n+--------------------+----------------------+----------------+\n| lg_3               |                   11 | CLUSTER_NODE=3 |\n| lg_3               |                   11 | CLUSTER_NODE=4 |\n+--------------------+----------------------+----------------+\n2 rows in set (0.06 sec)\n\nCREATE LOGFILE GROUP is useful only with Disk Data storage for MySQL\nCluster. See\nhttp://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-disk-data.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-logfile-group.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-logfile-group.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (345,6,'NULLIF','Syntax:\nNULLIF(expr1,expr2)\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is\nthe same as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/control-flow-functions.html\n\n','mysql> SELECT NULLIF(1,1);\n        -> NULL\nmysql> SELECT NULLIF(1,2);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/control-flow-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (346,3,'ROUND','Syntax:\nROUND(X), ROUND(X,D)\n\nRounds the argument X to D decimal places. The rounding algorithm\ndepends on the data type of X. D defaults to 0 if not specified. D can\nbe negative to cause D digits left of the decimal point of the value X\nto become zero.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT ROUND(-1.23);\n        -> -1\nmysql> SELECT ROUND(-1.58);\n        -> -2\nmysql> SELECT ROUND(1.58);\n        -> 2\nmysql> SELECT ROUND(1.298, 1);\n        -> 1.3\nmysql> SELECT ROUND(1.298, 0);\n        -> 1\nmysql> SELECT ROUND(23.298, -1);\n        -> 20\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (347,8,'STOP SLAVE','Syntax:\nSTOP SLAVE [thread_types]\n\nthread_types:\n    [thread_type [, thread_type] ... ]\n\nthread_type: IO_THREAD | SQL_THREAD\n\nchannel_option: \n    FOR CHANNEL channel\n\nStops the slave threads. STOP SLAVE requires the SUPER privilege.\nRecommended best practice is to execute STOP SLAVE on the slave before\nstopping the slave server (see\nhttp://dev.mysql.com/doc/refman/5.7/en/server-shutdown.html, for more\ninformation).\n\nWhen using the row-based logging format: You should execute STOP SLAVE\nor STOP SLAVE SQL_THREAD on the slave prior to shutting down the slave\nserver if you are replicating any tables that use a nontransactional\nstorage engine (see the Note later in this section).\n\nLike START SLAVE, this statement may be used with the IO_THREAD and\nSQL_THREAD options to name the thread or threads to be stopped.\n\nIn MySQL 5.7, STOP SLAVE causes an implicit commit of an ongoing\ntransaction. See\nhttp://dev.mysql.com/doc/refman/5.7/en/implicit-commit.html.\n\nBeginning with MySQL 5.7.1, gtid_next must be set to AUTOMATIC before\nissuing this statement (Bug #16062608).\n\nIn MySQL 5.7.2 and later, you can control how long STOP SLAVE waits\nbefore timing out by setting the rpl_stop_slave_timeout system\nvariable. This can be used to avoid deadlocks between STOP SLAVE and\nother slave SQL statements using different client connections to the\nslave. (Bug #16856735)\n\nPrior to MySQL 5.7.4, it was necessary to issue this statement on a\nrunning slave prior to executing CHANGE MASTER TO. In MySQL 5.7.4 and\nlater, this is no longer always the case; some CHANGE MASTER TO\nstatements are now allowed while the slave is running, depending on the\nstates of the slave SQL and I/O threads. However, using STOP SLAVE\nprior to executing CHANGE MASTER TO in such cases is still supported.\nSee [HELP CHANGE MASTER TO], and\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-solutions-switch.htm\nl, for more information.\n\nThe optional FOR CHANNEL channel clause added in MySQL 5.7.6 enables\nyou to choose which replication channel the statement applies to. If no\nclause is set and no extra channels exist, the statement applies to the\ndefault channel and behaves the same as versions of MySQL prior to\n5.7.6. Providing a FOR CHANNEL channel clause applies the STOP SLAVE\nstatement to a specific replication channel. If a STOP SLAVE statement\ndoes not have a channel defined when using multiple channels, this\nstatement stops the specified threads for all channels. Beginning with\nMySQL 5.7.9, this statement cannot be used with the\ngroup_replication_recovery channel. See\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-channels.html for\nmore information.\n\nWhen using statement-based replication: changing the master while it\nhas open temporary tables is potentially unsafe. This is one of the\nreasons why statement-based replication of temporary tables is not\nrecommended. You can find out whether there are any temporary tables on\nthe slave by checking the value of Slave_open_temp_tables; when using\nstatement-based replication, this value should be 0 before executing\nCHANGE MASTER TO. In MySQL 5.7.4 and later, if there are any temporary\ntables open on the slave, issuing a CHANGE MASTER TO statement after\nissuing a STOP SLAVE causes an ER_WARN_OPEN_TEMP_TABLES_MUST_BE_ZERO\nwarning.\n\nWhen using a multi-threaded slave (slave_parallel_workers is a nonzero\nvalue), any gaps in the sequence of transactions executed from the\nrelay log are closed as part of stopping the worker threads. If the\nslave is stopped unexpectedly (for example due to an error in a worker\nthread, or another thread issuing KILL) while a STOP SLAVE statement is\nexecuting, the sequence of executed transactions from the relay log may\nbecome inconsistent. See\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-features-transaction\n-inconsistencies.html, for more information.\n\n*Note*: In MySQL 5.7, STOP SLAVE waits until the current replication\nevent group affecting one or more nontransactional tables has finished\nexecuting (if there is any such replication group), or until you issue\na KILL QUERY or KILL CONNECTION statement. (Bug #319, Bug #38205)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/stop-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/stop-slave.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (348,32,'TIMEDIFF','Syntax:\nTIMEDIFF(expr1,expr2)\n\nTIMEDIFF() returns expr1 − expr2 expressed as a time value. expr1 and\nexpr2 are time or date-and-time expressions, but both must be of the\nsame type.\n\nThe result returned by TIMEDIFF() is limited to the range allowed for\nTIME values. Alternatively, you can use either of the functions\nTIMESTAMPDIFF() and UNIX_TIMESTAMP(), both of which return integers.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT TIMEDIFF(\'2000:01:01 00:00:00\',\n    ->                 \'2000:01:01 00:00:00.000001\');\n        -> \'-00:00:00.000001\'\nmysql> SELECT TIMEDIFF(\'2008-12-31 23:59:59.000001\',\n    ->                 \'2008-12-30 01:01:01.000002\');\n        -> \'46:58:57.999999\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (349,4,'LINEFROMTEXT','LineFromText(wkt[,srid]), LineStringFromText(wkt[,srid])\n\nST_LineFromText(), ST_LineStringFromText(), LineFromText(), and\nLineStringFromText() are synonyms. For more information, see the\ndescription of ST_LineFromText().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (350,32,'ADDTIME','Syntax:\nADDTIME(expr1,expr2)\n\nADDTIME() adds expr2 to expr1 and returns the result. expr1 is a time\nor datetime expression, and expr2 is a time expression.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT ADDTIME(\'2007-12-31 23:59:59.999999\', \'1 1:1:1.000002\');\n        -> \'2008-01-02 01:01:01.000001\'\nmysql> SELECT ADDTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'03:00:01.999997\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (351,38,'UPPER','Syntax:\nUPPER(str)\n\nReturns the string str with all characters changed to uppercase\naccording to the current character set mapping. The default is latin1\n(cp1252 West European).\n\nmysql> SELECT UPPER(\'Hej\');\n        -> \'HEJ\'\n\nSee the description of LOWER() for information that also applies to\nUPPER(). This included information about how to perform lettercase\nconversion of binary strings (BINARY, VARBINARY, BLOB) for which these\nfunctions are ineffective, and information about case folding for\nUnicode character sets.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (352,23,'MEDIUMBLOB','MEDIUMBLOB\n\nA BLOB column with a maximum length of 16,777,215 (224 − 1) bytes.\nEach MEDIUMBLOB value is stored using a 3-byte length prefix that\nindicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (353,32,'FROM_UNIXTIME','Syntax:\nFROM_UNIXTIME(unix_timestamp), FROM_UNIXTIME(unix_timestamp,format)\n\nReturns a representation of the unix_timestamp argument as a value in\n\'YYYY-MM-DD HH:MM:SS\' or YYYYMMDDHHMMSS format, depending on whether\nthe function is used in a string or numeric context. The value is\nexpressed in the current time zone. unix_timestamp is an internal\ntimestamp value such as is produced by the UNIX_TIMESTAMP() function.\n\nIf format is given, the result is formatted according to the format\nstring, which is used the same way as listed in the entry for the\nDATE_FORMAT() function.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT FROM_UNIXTIME(1447430881);\n        -> \'2015-11-13 10:08:01\'\nmysql> SELECT FROM_UNIXTIME(1447430881) + 0;\n        -> 20151113100801\nmysql> SELECT FROM_UNIXTIME(UNIX_TIMESTAMP(),\n    ->                      \'%Y %D %M %h:%i:%s %x\');\n        -> \'2015 13th November 10:08:01 2015\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (354,12,'SHA2','Syntax:\nSHA2(str, hash_length)\n\nCalculates the SHA-2 family of hash functions (SHA-224, SHA-256,\nSHA-384, and SHA-512). The first argument is the cleartext string to be\nhashed. The second argument indicates the desired bit length of the\nresult, which must have a value of 224, 256, 384, 512, or 0 (which is\nequivalent to 256). If either argument is NULL or the hash length is\nnot one of the permitted values, the return value is NULL. Otherwise,\nthe function result is a hash value containing the desired number of\nbits. See the notes at the beginning of this section about storing hash\nvalues efficiently.\n\nThe return value is a nonbinary string in the connection character set.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','mysql> SELECT SHA2(\'abc\', 224);\n        -> \'23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7\'\n','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (355,6,'IFNULL','Syntax:\nIFNULL(expr1,expr2)\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns\nexpr2. IFNULL() returns a numeric or string value, depending on the\ncontext in which it is used.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/control-flow-functions.html\n\n','mysql> SELECT IFNULL(1,0);\n        -> 1\nmysql> SELECT IFNULL(NULL,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,\'yes\');\n        -> \'yes\'\n','http://dev.mysql.com/doc/refman/5.7/en/control-flow-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (356,27,'SHOW FUNCTION CODE','Syntax:\nSHOW FUNCTION CODE func_name\n\nThis statement is similar to SHOW PROCEDURE CODE but for stored\nfunctions. See [HELP SHOW PROCEDURE CODE].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-function-code.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-function-code.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (357,27,'SHOW ERRORS','Syntax:\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW COUNT(*) ERRORS\n\nSHOW ERRORS is a diagnostic statement that is similar to SHOW WARNINGS,\nexcept that it displays information only for errors, rather than for\nerrors, warnings, and notes.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\nhttp://dev.mysql.com/doc/refman/5.7/en/select.html.\n\nThe SHOW COUNT(*) ERRORS statement displays the number of errors. You\ncan also retrieve this number from the error_count variable:\n\nSHOW COUNT(*) ERRORS;\nSELECT @@error_count;\n\nSHOW ERRORS and error_count apply only to errors, not warnings or\nnotes. In other respects, they are similar to SHOW WARNINGS and\nwarning_count. In particular, SHOW ERRORS cannot display information\nfor more than max_error_count messages, and error_count can exceed the\nvalue of max_error_count if the number of errors exceeds\nmax_error_count.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-errors.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-errors.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (358,20,'LEAST','Syntax:\nLEAST(value1,value2,...)\n\nWith two or more arguments, returns the smallest (minimum-valued)\nargument. The arguments are compared using the following rules:\n\no If any argument is NULL, the result is NULL. No comparison is needed.\n\no If the return value is used in an INTEGER context or all arguments\n  are integer-valued, they are compared as integers.\n\no If the return value is used in a REAL context or all arguments are\n  real-valued, they are compared as reals.\n\no If the arguments comprise a mix of numbers and strings, they are\n  compared as numbers.\n\no If any argument is a nonbinary (character) string, the arguments are\n  compared as nonbinary strings.\n\no In all other cases, the arguments are compared as binary strings.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT LEAST(2,0);\n        -> 0\nmysql> SELECT LEAST(34.0,3.0,5.0,767.0);\n        -> 3.0\nmysql> SELECT LEAST(\'B\',\'A\',\'C\');\n        -> \'A\'\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (359,20,'=','=\n\nEqual:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 1 = 0;\n        -> 0\nmysql> SELECT \'0\' = 0;\n        -> 1\nmysql> SELECT \'0.0\' = 0;\n        -> 1\nmysql> SELECT \'0.01\' = 0;\n        -> 0\nmysql> SELECT \'.01\' = 0.01;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (360,4,'ST_GEOMCOLLFROMTEXT','ST_GeomCollFromText(wkt[,srid]),\nST_GeometryCollectionFromText(wkt[,srid]),\nST_GeomCollFromTxt(wkt[,srid])\n\nConstructs a GeometryCollection value using its WKT representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','mysql> SET @g = "MULTILINESTRING((10 10, 11 11), (9 9, 10 10))";\nmysql> SELECT ST_AsText(ST_GeomCollFromText(@g));\n+--------------------------------------------+\n| ST_AsText(ST_GeomCollFromText(@g))         |\n+--------------------------------------------+\n| MULTILINESTRING((10 10,11 11),(9 9,10 10)) |\n+--------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (361,14,'IS_IPV4_MAPPED','Syntax:\nIS_IPV4_MAPPED(expr)\n\nThis function takes an IPv6 address represented in numeric form as a\nbinary string, as returned by INET6_ATON(). It returns 1 if the\nargument is a valid IPv4-mapped IPv6 address, 0 otherwise. IPv4-mapped\naddresses have the form ::ffff:ipv4_address.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV4_MAPPED(INET6_ATON(\'::10.0.5.9\'));\n        -> 0\nmysql> SELECT IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.5.9\'));\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (362,10,'CREATE USER','Syntax:\nCREATE USER syntax for MySQL 5.7.6 and higher:\n\nThe CREATE USER statement creates new MySQL accounts. It enables\naccount authentication properties to be established. As of MySQL 5.7.6,\nit is also possible to establish authentication, SSL/TLS, and\nresource-limit properties, account password expiration, and account\nlocking and unlocking.\n\nTo use CREATE USER, you must have the global CREATE USER privilege or\nthe INSERT privilege for the mysql database. When the read_only system\nvariable is enabled, CREATE USER additionally requires the SUPER\nprivilege.\n\nAn error occurs if you try to create an account that already exists.\n\nAs of MySQL 5.7.8, the IF NOT EXISTS clause can be used, which causes\nthe statement to produce a warning for each named account that already\nexists, rather than an error.\n\nFor each account, CREATE USER creates a new row in the mysql.user\ntable. The row reflects the properties specified in the statement.\nUnspecified properties are set to their default values.\n\nExample 1: Create an account that uses the default authentication\nplugin and the given password. Mark the password expired so that the\nuser must choose a new one at the first connection to the server:\n\nCREATE USER \'jeffrey\'@\'localhost\'\n  IDENTIFIED BY \'new_password\' PASSWORD EXPIRE;\n\nExample 2: Create an account that uses the sha256_password\nauthentication plugin and the given password. Require that a new\npassword be chosen every 180 days:\n\nCREATE USER \'jeffrey\'@\'localhost\'\n  IDENTIFIED WITH sha256_password BY \'new_password\'\n  PASSWORD EXPIRE INTERVAL 180 DAY;\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-user.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-user.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (363,25,'POINT','Point(x,y)\n\nConstructs a Point using its coordinates.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (364,38,'LCASE','Syntax:\nLCASE(str)\n\nLCASE() is a synonym for LOWER().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (365,7,'CREATE_DH_PARAMETERS','CREATE_DH_PARAMETERS(key_len)\n\nCreates a shared secret for generating a DH private/public key pair and\nreturns a binary string that can be passed to\nCREATE_ASYMMETRIC_PRIV_KEY(). If secret generation fails, the result is\nnull.\n\nSupported key_len values: The minimum and maximum key lengths in bits\nare 1024 and 10,000. These lengths are constraints imposed by OpenSSL.\n\nFor an example showing how to use the return value for generating\nsymmetric keys, see the description of ASYMMETRIC_DERIVE().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html\n\n','SET @dhp = CREATE_DH_PARAMETERS(1024);\n','http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (366,20,'IS NOT NULL','Syntax:\nIS NOT NULL\n\nTests whether a value is not NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n        -> 1, 1, 0\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (367,38,'MATCH AGAINST','Syntax:\nMATCH (col1,col2,...) AGAINST (expr [search_modifier])\n\nMySQL has support for full-text indexing and searching:\n\no A full-text index in MySQL is an index of type FULLTEXT.\n\no Full-text indexes can be used only with InnoDB or MyISAM tables, and\n  can be created only for CHAR, VARCHAR, or TEXT columns.\n\no As of MySQL 5.7.6, MySQL provides a built-in full-text ngram parser\n  that supports Chinese, Japanese, and Korean (CJK), and an installable\n  MeCab full-text parser plugin for Japanese. Parsing differences are\n  outlined in\n  http://dev.mysql.com/doc/refman/5.7/en/fulltext-search-ngram.html,\n  and\n  http://dev.mysql.com/doc/refman/5.7/en/fulltext-search-mecab.html.\n\no A FULLTEXT index definition can be given in the CREATE TABLE\n  statement when a table is created, or added later using ALTER TABLE\n  or CREATE INDEX.\n\no For large data sets, it is much faster to load your data into a table\n  that has no FULLTEXT index and then create the index after that, than\n  to load data into a table that has an existing FULLTEXT index.\n\nFull-text searching is performed using MATCH() ... AGAINST syntax.\nMATCH() takes a comma-separated list that names the columns to be\nsearched. AGAINST takes a string to search for, and an optional\nmodifier that indicates what type of search to perform. The search\nstring must be a string value that is constant during query evaluation.\nThis rules out, for example, a table column because that can differ for\neach row.\n\nThere are three types of full-text searches:\n\no A natural language search interprets the search string as a phrase in\n  natural human language (a phrase in free text). There are no special\n  operators. The stopword list applies. For more information about\n  stopword lists, see\n  http://dev.mysql.com/doc/refman/5.7/en/fulltext-stopwords.html.\n\n  Full-text searches are natural language searches if the IN NATURAL\n  LANGUAGE MODE modifier is given or if no modifier is given. For more\n  information, see\n  http://dev.mysql.com/doc/refman/5.7/en/fulltext-natural-language.html\n  .\n\no A boolean search interprets the search string using the rules of a\n  special query language. The string contains the words to search for.\n  It can also contain operators that specify requirements such that a\n  word must be present or absent in matching rows, or that it should be\n  weighted higher or lower than usual. Certain common words (stopwords)\n  are omitted from the search index and do not match if present in the\n  search string. The IN BOOLEAN MODE modifier specifies a boolean\n  search. For more information, see\n  http://dev.mysql.com/doc/refman/5.7/en/fulltext-boolean.html.\n\no A query expansion search is a modification of a natural language\n  search. The search string is used to perform a natural language\n  search. Then words from the most relevant rows returned by the search\n  are added to the search string and the search is done again. The\n  query returns the rows from the second search. The IN NATURAL\n  LANGUAGE MODE WITH QUERY EXPANSION or WITH QUERY EXPANSION modifier\n  specifies a query expansion search. For more information, see\n  http://dev.mysql.com/doc/refman/5.7/en/fulltext-query-expansion.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/fulltext-search.html\n\n','mysql> SELECT id, body, MATCH (title,body) AGAINST\n    (\'Security implications of running MySQL as root\'\n    IN NATURAL LANGUAGE MODE) AS score\n    FROM articles WHERE MATCH (title,body) AGAINST\n    (\'Security implications of running MySQL as root\'\n    IN NATURAL LANGUAGE MODE);\n+----+-------------------------------------+-----------------+\n| id | body                                | score           |\n+----+-------------------------------------+-----------------+\n|  4 | 1. Never run mysqld as root. 2. ... | 1.5219271183014 |\n|  6 | When configured properly, MySQL ... | 1.3114095926285 |\n+----+-------------------------------------+-----------------+\n2 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/fulltext-search.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (368,40,'CREATE EVENT','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    EVENT\n    [IF NOT EXISTS]\n    event_name\n    ON SCHEDULE schedule\n    [ON COMPLETION [NOT] PRESERVE]\n    [ENABLE | DISABLE | DISABLE ON SLAVE]\n    [COMMENT \'comment\']\n    DO event_body;\n\nschedule:\n    AT timestamp [+ INTERVAL interval] ...\n  | EVERY interval\n    [STARTS timestamp [+ INTERVAL interval] ...]\n    [ENDS timestamp [+ INTERVAL interval] ...]\n\ninterval:\n    quantity {YEAR | QUARTER | MONTH | DAY | HOUR | MINUTE |\n              WEEK | SECOND | YEAR_MONTH | DAY_HOUR | DAY_MINUTE |\n              DAY_SECOND | HOUR_MINUTE | HOUR_SECOND | MINUTE_SECOND}\n\nThis statement creates and schedules a new event. The event will not\nrun unless the Event Scheduler is enabled. For information about\nchecking Event Scheduler status and enabling it if necessary, see\nhttp://dev.mysql.com/doc/refman/5.7/en/events-configuration.html.\n\nCREATE EVENT requires the EVENT privilege for the schema in which the\nevent is to be created. It might also require the SUPER privilege,\ndepending on the DEFINER value, as described later in this section.\n\nThe minimum requirements for a valid CREATE EVENT statement are as\nfollows:\n\no The keywords CREATE EVENT plus an event name, which uniquely\n  identifies the event in a database schema.\n\no An ON SCHEDULE clause, which determines when and how often the event\n  executes.\n\no A DO clause, which contains the SQL statement to be executed by an\n  event.\n\nThis is an example of a minimal CREATE EVENT statement:\n\nCREATE EVENT myevent\n    ON SCHEDULE AT CURRENT_TIMESTAMP + INTERVAL 1 HOUR\n    DO\n      UPDATE myschema.mytable SET mycol = mycol + 1;\n\nThe previous statement creates an event named myevent. This event\nexecutes once---one hour following its creation---by running an SQL\nstatement that increments the value of the myschema.mytable table\'s\nmycol column by 1.\n\nThe event_name must be a valid MySQL identifier with a maximum length\nof 64 characters. Event names are not case sensitive, so you cannot\nhave two events named myevent and MyEvent in the same schema. In\ngeneral, the rules governing event names are the same as those for\nnames of stored routines. See\nhttp://dev.mysql.com/doc/refman/5.7/en/identifiers.html.\n\nAn event is associated with a schema. If no schema is indicated as part\nof event_name, the default (current) schema is assumed. To create an\nevent in a specific schema, qualify the event name with a schema using\nschema_name.event_name syntax.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-event.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-event.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (369,7,'MBR DEFINITION','Its MBR (minimum bounding rectangle), or envelope. This is the bounding\ngeometry, formed by the minimum and maximum (X,Y) coordinates:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-class-geometry.html\n\n','((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n','http://dev.mysql.com/doc/refman/5.7/en/gis-class-geometry.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (370,26,'ST_DIFFERENCE','ST_Difference(g1, g2)\n\nReturns a geometry that represents the point set difference of the\ngeometry values g1 and g2.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html\n\n','mysql> SET @g1 = POINT(1,1), @g2 = POINT(2,2);\nmysql> SELECT ST_AsText(ST_Difference(@g1, @g2));\n+------------------------------------+\n| ST_AsText(ST_Difference(@g1, @g2)) |\n+------------------------------------+\n| POINT(1 1)                         |\n+------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (371,25,'GEOMETRYCOLLECTION','GeometryCollection(g1,g2,...)\n\nConstructs a GeometryCollection.\n\nAs of MySQL 5.7.5, GeometryCollection() returns all the proper\ngeometries contained in the argument even if a nonsupported geometry is\npresent. Before 5.7.5, if the argument contains a nonsupported\ngeometry, the return value is NULL.\n\nAs of MySQL 5.7.8, GeometryCollection() with no arguments is permitted\nas a way to create an empty geometry.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (372,3,'*','Syntax:\n*\n\nMultiplication:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html\n\n','mysql> SELECT 3*5;\n        -> 15\nmysql> SELECT 18014398509481984*18014398509481984.0;\n        -> 324518553658426726783156020576256.0\nmysql> SELECT 18014398509481984*18014398509481984;\n        -> out-of-range error\n','http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (373,33,'ST_ASBINARY','ST_AsBinary(g), ST_AsWKB(g)\n\nConverts a value in internal geometry format to its WKB representation\nand returns the binary result.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-format-conversion-functions.html\n\n','SELECT ST_AsBinary(g) FROM geom;\n','http://dev.mysql.com/doc/refman/5.7/en/gis-format-conversion-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (374,38,'TO_BASE64','Syntax:\nTO_BASE64(str)\n\nConverts the string argument to base-64 encoded form and returns the\nresult as a character string with the connection character set and\ncollation. If the argument is not a string, it is converted to a string\nbefore conversion takes place. The result is NULL if the argument is\nNULL. Base-64 encoded strings can be decoded using the FROM_BASE64()\nfunction.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT TO_BASE64(\'abc\'), FROM_BASE64(TO_BASE64(\'abc\'));\n        -> \'JWJj\', \'abc\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (375,12,'DES_DECRYPT','Syntax:\nDES_DECRYPT(crypt_str[,key_str])\n\nDecrypts a string encrypted with DES_ENCRYPT(). If an error occurs,\nthis function returns NULL.\n\nThis function works only if MySQL has been configured with SSL support.\nSee http://dev.mysql.com/doc/refman/5.7/en/secure-connections.html.\n\nIf no key_str argument is given, DES_DECRYPT() examines the first byte\nof the encrypted string to determine the DES key number that was used\nto encrypt the original string, and then reads the key from the DES key\nfile to decrypt the message. For this to work, the user must have the\nSUPER privilege. The key file can be specified with the --des-key-file\nserver option.\n\nIf you pass this function a key_str argument, that string is used as\nthe key for decrypting the message.\n\nIf the crypt_str argument does not appear to be an encrypted string,\nMySQL returns the given crypt_str.\n\n*Note*: The DES_ENCRYPT() and DES_DECRYPT() functions are deprecated as\nof MySQL 5.7.6, will be removed in a future MySQL release, and should\nno longer be used. Consider using AES_ENCRYPT() and AES_DECRYPT()\ninstead.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (376,2,'ST_AREA','ST_Area(poly)\n\nReturns a double-precision number indicating the area of the argument,\nas measured in its spatial reference system. For arguments of dimension\n0 or 1, the result is 0.\n\nAdditionally, as of MySQL 5.7.5: The result is the sum of the area\nvalues of all components for a geometry collection. If a geometry\ncollection is empty, its area is returned as 0.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html\n\n','mysql> SET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\nmysql> SELECT ST_Area(ST_GeomFromText(@poly));\n+---------------------------------+\n| ST_Area(ST_GeomFromText(@poly)) |\n+---------------------------------+\n|                               4 |\n+---------------------------------+\n\nmysql> SET @mpoly =\n    -> \'MultiPolygon(((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1)))\';\nmysql> SELECT ST_Area(ST_GeomFromText(@mpoly));\n+----------------------------------+\n| ST_Area(ST_GeomFromText(@mpoly)) |\n+----------------------------------+\n|                                8 |\n+----------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (377,13,'ENDPOINT','EndPoint(ls)\n\nST_EndPoint() and EndPoint() are synonyms. For more information, see\nthe description of ST_EndPoint().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (378,28,'INSERT','Syntax:\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)] \n    [(col_name,...)]\n    {VALUES | VALUE} ({expr | DEFAULT},...),(...),...\n    [ ON DUPLICATE KEY UPDATE\n      col_name=expr\n        [, col_name=expr] ... ]\n\nOr:\n\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)]\n    SET col_name={expr | DEFAULT}, ...\n    [ ON DUPLICATE KEY UPDATE\n      col_name=expr\n        [, col_name=expr] ... ]\n\nOr:\n\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)] \n    [(col_name,...)]\n    SELECT ...\n    [ ON DUPLICATE KEY UPDATE\n      col_name=expr\n        [, col_name=expr] ... ]\n\nINSERT inserts new rows into an existing table. The INSERT ... VALUES\nand INSERT ... SET forms of the statement insert rows based on\nexplicitly specified values. The INSERT ... SELECT form inserts rows\nselected from another table or tables. INSERT ... SELECT is discussed\nfurther in [HELP INSERT SELECT].\n\nWhen inserting into a partitioned table, you can control which\npartitions and subpartitions accept new rows. The PARTITION option\ntakes a comma-separated list of the names of one or more partitions or\nsubpartitions (or both) of the table. If any of the rows to be inserted\nby a given INSERT statement do not match one of the partitions listed,\nthe INSERT statement fails with the error Found a row not matching the\ngiven partition set. See\nhttp://dev.mysql.com/doc/refman/5.7/en/partitioning-selection.html, for\nmore information and examples.\n\nIn MySQL 5.7, the DELAYED keyword is accepted but ignored by the\nserver. See [HELP INSERT DELAYED], for the reasons for this.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/insert.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/insert.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (379,16,'COUNT','Syntax:\nCOUNT(expr)\n\nReturns a count of the number of non-NULL values of expr in the rows\nretrieved by a SELECT statement. The result is a BIGINT value.\n\nCOUNT() returns 0 if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','mysql> SELECT student.student_name,COUNT(*)\n    ->        FROM student,course\n    ->        WHERE student.student_id=course.student_id\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (380,7,'JSON_ARRAY_APPEND','JSON_ARRAY_APPEND(json_doc, path, val[, path, val] ...)\n\nAppends values to the end of the indicated arrays within a JSON\ndocument and returns the result. Returns NULL if any argument is NULL.\nAn error occurs if the json_doc argument is not a valid JSON document\nor any path argument is not a valid path expression or contains a * or\n** wildcard.\n\nThe path/value pairs are evaluated left to right. The document produced\nby evaluating one pair becomes the new value against which the next\npair is evaluated.\n\nIf a path selects a scalar or object value, that value is autowrapped\nwithin an array and the new value is added to that array. Pairs for\nwhich the path does not identify any value in the JSON document are\nignored.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html\n\n','mysql> SET @j = \'["a", ["b", "c"], "d"]\';\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$[1]\', 1);\n+----------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$[1]\', 1) |\n+----------------------------------+\n| ["a", ["b", "c", 1], "d"]        |\n+----------------------------------+\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$[0]\', 2);\n+----------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$[0]\', 2) |\n+----------------------------------+\n| [["a", 2], ["b", "c"], "d"]      |\n+----------------------------------+\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$[1][0]\', 3);\n+-------------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$[1][0]\', 3) |\n+-------------------------------------+\n| ["a", [["b", 3], "c"], "d"]         |\n+-------------------------------------+\n\nmysql> SET @j = \'{"a": 1, "b": [2, 3], "c": 4}\';\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$.b\', \'x\');\n+------------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$.b\', \'x\')  |\n+------------------------------------+\n| {"a": 1, "b": [2, 3, "x"], "c": 4} |\n+------------------------------------+\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$.c\', \'y\');\n+--------------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$.c\', \'y\')    |\n+--------------------------------------+\n| {"a": 1, "b": [2, 3], "c": [4, "y"]} |\n+--------------------------------------+\n\nmysql> SET @j = \'{"a": 1}\';\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$\', \'z\');\n+---------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$\', \'z\') |\n+---------------------------------+\n| [{"a": 1}, "z"]                 |\n+---------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (381,4,'MLINEFROMTEXT','MLineFromText(wkt[,srid]), MultiLineStringFromText(wkt[,srid])\n\nST_MLineFromText(), ST_MultiLineStringFromText(), MLineFromText(), and\nMultiLineStringFromText() are synonyms. For more information, see the\ndescription of ST_MLineFromText().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (382,33,'GEOMCOLLFROMWKB','GeomCollFromWKB(wkb[,srid]), GeometryCollectionFromWKB(wkb[,srid])\n\nST_GeomCollFromWKB(), ST_GeometryCollectionFromWKB(),\nGeomCollFromWKB(), and GeometryCollectionFromWKB() are synonyms. For\nmore information, see the description of ST_GeomCollFromWKB().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (383,23,'TINYTEXT','TINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 255 (28 − 1) characters. The\neffective maximum length is less if the value contains multibyte\ncharacters. Each TINYTEXT value is stored using a 1-byte length prefix\nthat indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (384,14,'DEFAULT','Syntax:\nDEFAULT(col_name)\n\nReturns the default value for a table column. An error results if the\ncolumn has no default value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> UPDATE t SET i = DEFAULT(i)+1 WHERE id < 100;\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (385,21,'OPTIMIZE TABLE','Syntax:\nOPTIMIZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n    tbl_name [, tbl_name] ...\n\nReorganizes the physical storage of table data and associated index\ndata, to reduce storage space and improve I/O efficiency when accessing\nthe table. The exact changes made to each table depend on the storage\nengine used by that table. This statement does not work with views.\n\nUse OPTIMIZE TABLE in these cases, depending on the type of table:\n\no After doing substantial insert, update, or delete operations on an\n  InnoDB table that has its own .ibd file because it was created with\n  the innodb_file_per_table option enabled. The table and indexes are\n  reorganized, and disk space can be reclaimed for use by the operating\n  system.\n\no After doing substantial insert, update, or delete operations on\n  columns that are part of a FULLTEXT index in an InnoDB table. Set the\n  configuration option innodb_optimize_fulltext_only=1 first. To keep\n  the index maintenance period to a reasonable time, set the\n  innodb_ft_num_word_optimize option to specify how many words to\n  update in the search index, and run a sequence of OPTIMIZE TABLE\n  statements until the search index is fully updated.\n\no After deleting a large part of a MyISAM or ARCHIVE table, or making\n  many changes to a MyISAM or ARCHIVE table with variable-length rows\n  (tables that have VARCHAR, VARBINARY, BLOB, or TEXT columns). Deleted\n  rows are maintained in a linked list and subsequent INSERT operations\n  reuse old row positions. You can use OPTIMIZE TABLE to reclaim the\n  unused space and to defragment the data file. After extensive changes\n  to a table, this statement may also improve performance of statements\n  that use the table, sometimes significantly.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nOPTIMIZE TABLE is also supported for partitioned tables. For\ninformation about using this statement with partitioned tables and\ntable partitions, see\nhttp://dev.mysql.com/doc/refman/5.7/en/partitioning-maintenance.html.\n\nIn MySQL 5.7.1, gtid_next must be set to AUTOMATIC before issuing this\nstatement. This restriction does not apply in MySQL 5.7.2 or later.\n(Bug #16062608, Bug #16715809, Bug #69045)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/optimize-table.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/optimize-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (386,12,'DECODE','Syntax:\nDECODE(crypt_str,pass_str)\n\nDECODE() decrypts the encrypted string crypt_str using pass_str as the\npassword. crypt_str should be a string returned from ENCODE().\n\n*Note*: The ENCODE() and DECODE() functions are deprecated in MySQL\n5.7, will be removed in a future MySQL release, and should no longer be\nused. Consider using AES_ENCRYPT() and AES_DECRYPT() instead.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (387,7,'JSON_ARRAY_INSERT','JSON_ARRAY_INSERT(json_doc, path, val[, path, val] ...)\n\nUpdates a JSON document, inserting into an array within the document\nand returning the modified document. Returns NULL if any argument is\nNULL. An error occurs if the json_doc argument is not a valid JSON\ndocument or any path argument is not a valid path expression or\ncontains a * or ** wildcard or does not end with an array element\nidentifier.\n\nThe path/value pairs are evaluated left to right. The document produced\nby evaluating one pair becomes the new value against which the next\npair is evaluated.\n\nPairs for which the path does not identify any array in the JSON\ndocument are ignored. If a path identifies an array element, the\ncorresponding value is inserted at that element position, shifting any\nfollowing values to the right. If a path identifies an array position\npast the end of an array, the value is inserted at the end of the\narray.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html\n\n','mysql> SET @j = \'["a", {"b": [1, 2]}, [3, 4]]\';\nmysql> SELECT JSON_ARRAY_INSERT(@j, \'$[1]\', \'x\');\n+------------------------------------+\n| JSON_ARRAY_INSERT(@j, \'$[1]\', \'x\') |\n+------------------------------------+\n| ["a", "x", {"b": [1, 2]}, [3, 4]]  |\n+------------------------------------+\nmysql> SELECT JSON_ARRAY_INSERT(@j, \'$[100]\', \'x\');\n+--------------------------------------+\n| JSON_ARRAY_INSERT(@j, \'$[100]\', \'x\') |\n+--------------------------------------+\n| ["a", {"b": [1, 2]}, [3, 4], "x"]    |\n+--------------------------------------+\nmysql> SELECT JSON_ARRAY_INSERT(@j, \'$[1].b[0]\', \'x\');\n+-----------------------------------------+\n| JSON_ARRAY_INSERT(@j, \'$[1].b[0]\', \'x\') |\n+-----------------------------------------+\n| ["a", {"b": ["x", 1, 2]}, [3, 4]]       |\n+-----------------------------------------+\nmysql> SELECT JSON_ARRAY_INSERT(@j, \'$[2][1]\', \'y\');\n+---------------------------------------+\n| JSON_ARRAY_INSERT(@j, \'$[2][1]\', \'y\') |\n+---------------------------------------+\n| ["a", {"b": [1, 2]}, [3, "y", 4]]     |\n+---------------------------------------+\nmysql> SELECT JSON_ARRAY_INSERT(@j, \'$[0]\', \'x\', \'$[2][1]\', \'y\');\n+----------------------------------------------------+\n| JSON_ARRAY_INSERT(@j, \'$[0]\', \'x\', \'$[2][1]\', \'y\') |\n+----------------------------------------------------+\n| ["x", "a", {"b": [1, 2]}, [3, 4]]                  |\n+----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (388,20,'<=>','Syntax:\n<=>\n\nNULL-safe equal. This operator performs an equality comparison like the\n= operator, but returns 1 rather than NULL if both operands are NULL,\nand 0 rather than NULL if one operand is NULL.\n\nThe <=> operator is equivalent to the standard SQL IS NOT DISTINCT FROM\noperator.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\n        -> 1, 1, 0\nmysql> SELECT 1 = 1, NULL = NULL, 1 = NULL;\n        -> 1, NULL, NULL\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (389,27,'RESET','Syntax:\nRESET reset_option [, reset_option] ...\n\nThe RESET statement is used to clear the state of various server\noperations. You must have the RELOAD privilege to execute RESET.\n\nRESET acts as a stronger version of the FLUSH statement. See [HELP\nFLUSH].\n\nThe RESET statement causes an implicit commit. See\nhttp://dev.mysql.com/doc/refman/5.7/en/implicit-commit.html.\n\nIn MySQL 5.7.1, gtid_next must be set to AUTOMATIC before issuing this\nstatement. This restriction does not apply in MySQL 5.7.2 or later.\n(Bug #16062608, Bug #16715809, Bug #69045)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/reset.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/reset.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (390,14,'GET_LOCK','Syntax:\nGET_LOCK(str,timeout)\n\nTries to obtain a lock with a name given by the string str, using a\ntimeout of timeout seconds. A negative timeout value means infinite\ntimeout. The lock is exclusive. While held by one session, other\nsessions cannot obtain a lock of the same name.\n\nReturns 1 if the lock was obtained successfully, 0 if the attempt timed\nout (for example, because another client has previously locked the\nname), or NULL if an error occurred (such as running out of memory or\nthe thread was killed with mysqladmin kill).\n\nA lock obtained with GET_LOCK() is released explicitly by executing\nRELEASE_LOCK() or implicitly when your session terminates (either\nnormally or abnormally). Lock release may also occur with another call\nto GET_LOCK():\n\no Before 5.7.5, only a single simultaneous lock can be acquired and\n  GET_LOCK() releases any existing lock.\n\no In MySQL 5.7.5, GET_LOCK() was reimplemented using the metadata\n  locking (MDL) subsystem and its capabilities were extended. Multiple\n  simultaneous locks can be acquired and GET_LOCK() does not release\n  any existing locks. It is even possible for a given session to\n  acquire multiple locks for the same name. Other sessions cannot\n  acquire a lock with that name until the acquiring session releases\n  all its locks for the name.\n\n  As a result of the MDL reimplementation, locks acquired with\n  GET_LOCK() appear in the Performance Schema metadata_locks table. The\n  OBJECT_TYPE column says USER LEVEL LOCK and the OBJECT_NAME column\n  indicates the lock name. Also, the capability of acquiring multiple\n  locks introduces the possibility of deadlock among clients. When this\n  happens, the server chooses a caller and terminates its\n  lock-acquisition request with an ER_USER_LOCK_DEADLOCK error. This\n  error does not cause transactions to roll back.\n\nThe difference in lock acquisition behavior as of MySQL 5.7.5 can be\nseen by the following example. Suppose that you execute these\nstatements:\n\nSELECT GET_LOCK(\'lock1\',10);\nSELECT GET_LOCK(\'lock2\',10);\nSELECT RELEASE_LOCK(\'lock2\');\nSELECT RELEASE_LOCK(\'lock1\');\n\nIn MySQL 5.7.5 or later, the second GET_LOCK() acquires a second lock\nand both RELEASE_LOCK() calls return 1 (success). Before MySQL 5.7.5,\nthe second GET_LOCK() releases the first lock (\'lock1\') and the second\nRELEASE_LOCK() returns NULL (failure) because there is no \'lock1\' to\nrelease.\n\nMySQL 5.7.5 and later enforces a maximum length on lock names of 64\ncharacters. Previously, no limit was enforced.\n\nLocks obtained with GET_LOCK() are not released when transactions\ncommit or roll back.\n\nGET_LOCK() can be used to implement application locks or to simulate\nrecord locks. Names are locked on a server-wide basis. If a name has\nbeen locked within one session, GET_LOCK() blocks any request by\nanother session for a lock with the same name. This enables clients\nthat agree on a given lock name to use the name to perform cooperative\nadvisory locking. But be aware that it also enables a client that is\nnot among the set of cooperating clients to lock a name, either\ninadvertently or deliberately, and thus prevent any of the cooperating\nclients from locking that name. One way to reduce the likelihood of\nthis is to use lock names that are database-specific or\napplication-specific. For example, use lock names of the form\ndb_name.str or app_name.str.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (391,23,'BIGINT','BIGINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to 18446744073709551615.\n\nSERIAL is an alias for BIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (392,32,'CURTIME','Syntax:\nCURTIME([fsp])\n\nReturns the current time as a value in \'HH:MM:SS\' or HHMMSS format,\ndepending on whether the function is used in a string or numeric\ncontext. The value is expressed in the current time zone.\n\nIf the fsp argument is given to specify a fractional seconds precision\nfrom 0 to 6, the return value includes a fractional seconds part of\nthat many digits.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT CURTIME();\n        -> \'23:50:26\'\nmysql> SELECT CURTIME() + 0;\n        -> 235026.000000\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (393,37,'ST_DIMENSION','ST_Dimension(g)\n\nReturns the inherent dimension of the geometry value g. The result can\nbe −1, 0, 1, or 2. The meaning of these values is given in\nhttp://dev.mysql.com/doc/refman/5.7/en/gis-class-geometry.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','mysql> SELECT ST_Dimension(ST_GeomFromText(\'LineString(1 1,2 2)\'));\n+------------------------------------------------------+\n| ST_Dimension(ST_GeomFromText(\'LineString(1 1,2 2)\')) |\n+------------------------------------------------------+\n|                                                    1 |\n+------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (394,27,'SET','Syntax:\nSET variable_assignment [, variable_assignment] ...\n\nvariable_assignment:\n      user_var_name = expr\n    | [GLOBAL | SESSION] system_var_name = expr\n    | [@@global. | @@session. | @@]system_var_name = expr\n\nThe SET statement assigns values to different types of variables that\naffect the operation of the server or your client.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/set-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/set-statement.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (395,7,'JSON_MERGE','JSON_MERGE(json_doc, json_doc[, json_doc] ...)\n\nMerges two or more JSON documents and returns the merged result.\nReturns NULL if any argument is NULL. An error occurs if any argument\nis not a valid JSON document.\n\nMerging takes place according to the following rules. For additional\ninformation, see\nhttp://dev.mysql.com/doc/refman/5.7/en/json.html#json-normalization.\n\no Adjacent arrays are merged to a single array.\n\no Adjacent objects are merged to a single object.\n\no A scalar value is autowrapped as an array and merged as an array.\n\no An adjacent array and object are merged by autowrapping the object as\n  an array and merging the two arrays.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html\n\n','mysql> SELECT JSON_MERGE(\'[1, 2]\', \'[true, false]\');\n+---------------------------------------+\n| JSON_MERGE(\'[1, 2]\', \'[true, false]\') |\n+---------------------------------------+\n| [1, 2, true, false]                   |\n+---------------------------------------+\nmysql> SELECT JSON_MERGE(\'{"name": "x"}\', \'{"id": 47}\');\n+-------------------------------------------+\n| JSON_MERGE(\'{"name": "x"}\', \'{"id": 47}\') |\n+-------------------------------------------+\n| {"id": 47, "name": "x"}                   |\n+-------------------------------------------+\nmysql> SELECT JSON_MERGE(\'1\', \'true\');\n+-------------------------+\n| JSON_MERGE(\'1\', \'true\') |\n+-------------------------+\n| [1, true]               |\n+-------------------------+\nmysql> SELECT JSON_MERGE(\'[1, 2]\', \'{"id": 47}\');\n+------------------------------------+\n| JSON_MERGE(\'[1, 2]\', \'{"id": 47}\') |\n+------------------------------------+\n| [1, 2, {"id": 47}]                 |\n+------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (396,28,'LOAD XML','Syntax:\nLOAD XML [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE \'file_name\'\n    [REPLACE | IGNORE]\n    INTO TABLE [db_name.]tbl_name\n    [CHARACTER SET charset_name]\n    [ROWS IDENTIFIED BY \'<tagname>\']\n    [IGNORE number {LINES | ROWS}]\n    [(field_name_or_user_var,...)]\n    [SET col_name = expr,...]\n\nThe LOAD XML statement reads data from an XML file into a table. The\nfile_name must be given as a literal string. The tagname in the\noptional ROWS IDENTIFIED BY clause must also be given as a literal\nstring, and must be surrounded by angle brackets (< and >).\n\nLOAD XML acts as the complement of running the mysql client in XML\noutput mode (that is, starting the client with the --xml option). To\nwrite data from a table to an XML file, you can invoke the mysql client\nwith the --xml and -e options from the system shell, as shown here:\n\nshell> mysql --xml -e \'SELECT * FROM mydb.mytable\' > file.xml\n\nTo read the file back into a table, use LOAD XML INFILE. By default,\nthe <row> element is considered to be the equivalent of a database\ntable row; this can be changed using the ROWS IDENTIFIED BY clause.\n\nThis statement supports three different XML formats:\n\no Column names as attributes and column values as attribute values:\n\n<row column1="value1" column2="value2" .../>\n\no Column names as tags and column values as the content of these tags:\n\n<row>\n  <column1>value1</column1>\n  <column2>value2</column2>\n</row>\n\no Column names are the name attributes of <field> tags, and values are\n  the contents of these tags:\n\n<row>\n  <field name=\'column1\'>value1</field>\n  <field name=\'column2\'>value2</field>\n</row>\n\n  This is the format used by other MySQL tools, such as mysqldump.\n\nAll three formats can be used in the same XML file; the import routine\nautomatically detects the format for each row and interprets it\ncorrectly. Tags are matched based on the tag or attribute name and the\ncolumn name.\n\nPrior to MySQL 5.7.9, LOAD XML did not handle empty XML elements in the\nform <element/> correctly. (Bug #67542, Bug #16171518)\n\nThe following clauses work essentially the same way for LOAD XML as\nthey do for LOAD DATA:\n\no LOW_PRIORITY or CONCURRENT\n\no LOCAL\n\no REPLACE or IGNORE\n\no CHARACTER SET\n\no SET\n\nSee [HELP LOAD DATA], for more information about these clauses.\n\n(field_name_or_user_var, ...) is a comma-separated list of one or more\nXML fields or user variables. The name of a user variable used for this\npurpose must match the name of a field from the XML file, prefixed with\n@. You can use field names to select only desired fields. User\nvariables can be employed to store the corresponding field values for\nsubsequent re-use.\n\nThe IGNORE number LINES or IGNORE number ROWS clause causes the first\nnumber rows in the XML file to be skipped. It is analogous to the LOAD\nDATA statement\'s IGNORE ... LINES clause.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/load-xml.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/load-xml.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (397,3,'CONV','Syntax:\nCONV(N,from_base,to_base)\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base\nto_base. Returns NULL if any argument is NULL. The argument N is\ninterpreted as an integer, but may be specified as an integer or a\nstring. The minimum base is 2 and the maximum base is 36. If from_base\nis a negative number, N is regarded as a signed number. Otherwise, N is\ntreated as unsigned. CONV() works with 64-bit precision.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT CONV(\'a\',16,2);\n        -> \'1010\'\nmysql> SELECT CONV(\'6E\',18,8);\n        -> \'172\'\nmysql> SELECT CONV(-17,10,-18);\n        -> \'-H\'\nmysql> SELECT CONV(10+\'10\'+\'10\'+X\'0a\',10,10);\n        -> \'40\'\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (398,4,'ST_MPOINTFROMTEXT','ST_MPointFromText(wkt[,srid]), ST_MultiPointFromText(wkt[,srid])\n\nConstructs a MultiPoint value using its WKT representation and SRID.\n\nAs of MySQL 5.7.9, spatial functions such as ST_MPointFromText() and\nST_GeomFromText() that accept WKT-format representations of MultiPoint\nvalues permit individual points within values to be surrounded by\nparentheses. For example, both of the following function calls are\nvalid, whereas before MySQL 5.7.9 the second one produces an error:\n\nST_MPointFromText(\'MULTIPOINT (1 1, 2 2, 3 3)\')\nST_MPointFromText(\'MULTIPOINT ((1 1), (2 2), (3 3))\')\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (399,15,'ASSIGN-VALUE','Syntax:\n:=\n\nAssignment operator. Causes the user variable on the left hand side of\nthe operator to take on the value to its right. The value on the right\nhand side may be a literal value, another variable storing a value, or\nany legal expression that yields a scalar value, including the result\nof a query (provided that this value is a scalar value). You can\nperform multiple assignments in the same SET statement. You can perform\nmultiple assignments in the same statement-\n\nUnlike =, the := operator is never interpreted as a comparison\noperator. This means you can use := in any valid SQL statement (not\njust in SET statements) to assign a value to a variable.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/assignment-operators.html\n\n','mysql> SELECT @var1, @var2;\n        -> NULL, NULL\nmysql> SELECT @var1 := 1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2 := @var1;\n        -> 1, 1\nmysql> SELECT @var1, @var2;\n        -> 1, 1\n\nmysql> SELECT @var1:=COUNT(*) FROM t1;\n        -> 4\nmysql> SELECT @var1;\n        -> 4\n','http://dev.mysql.com/doc/refman/5.7/en/assignment-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (400,27,'SHOW OPEN TABLES','Syntax:\nSHOW OPEN TABLES [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW OPEN TABLES lists the non-TEMPORARY tables that are currently open\nin the table cache. See\nhttp://dev.mysql.com/doc/refman/5.7/en/table-cache.html. The FROM\nclause, if present, restricts the tables shown to those present in the\ndb_name database. The LIKE clause, if present, indicates which table\nnames to match. The WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-open-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-open-tables.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (401,32,'EXTRACT','Syntax:\nEXTRACT(unit FROM date)\n\nThe EXTRACT() function uses the same kinds of unit specifiers as\nDATE_ADD() or DATE_SUB(), but extracts parts from the date rather than\nperforming date arithmetic.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT EXTRACT(YEAR FROM \'2009-07-02\');\n       -> 2009\nmysql> SELECT EXTRACT(YEAR_MONTH FROM \'2009-07-02 01:02:03\');\n       -> 200907\nmysql> SELECT EXTRACT(DAY_MINUTE FROM \'2009-07-02 01:02:03\');\n       -> 20102\nmysql> SELECT EXTRACT(MICROSECOND\n    ->                FROM \'2003-01-02 10:30:00.000123\');\n        -> 123\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (402,12,'ENCRYPT','Syntax:\nENCRYPT(str[,salt])\n\nEncrypts str using the Unix crypt() system call and returns a binary\nstring. The salt argument must be a string with at least two characters\nor the result will be NULL. If no salt argument is given, a random\nvalue is used.\n\n*Note*: The ENCRYPT() function is deprecated as of MySQL 5.7.6, will be\nremoved in a future MySQL release, and should no longer be used.\nConsider using AES_ENCRYPT() instead.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','mysql> SELECT ENCRYPT(\'hello\');\n        -> \'VxuFAJXVARROc\'\n','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (403,27,'SHOW STATUS','Syntax:\nSHOW [GLOBAL | SESSION] STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\n*Note*: As of MySQL 5.7.6, the value of the show_compatibility_56\nsystem variable affects the information available from and privileges\nrequired for the statement described here. For details, see the\ndescription of that variable in\nhttp://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html.\n\nSHOW STATUS provides server status information (see\nhttp://dev.mysql.com/doc/refman/5.7/en/server-status-variables.html).\nThis statement does not require any privilege. It requires only the\nability to connect to the server.\n\nStatus variable information is also available from these sources:\n\no Performance Schema tables. See\n  http://dev.mysql.com/doc/refman/5.7/en/performance-schema-status-vari\n  able-tables.html.\n\no The GLOBAL_STATUS and SESSION_STATUS tables. See\n  http://dev.mysql.com/doc/refman/5.7/en/status-table.html.\n\no The mysqladmin extended-status command. See\n  http://dev.mysql.com/doc/refman/5.7/en/mysqladmin.html.\n\nFor SHOW STATUS, a LIKE clause, if present, indicates which variable\nnames to match. A WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nSHOW STATUS accepts an optional GLOBAL or SESSION variable scope\nmodifier:\n\no With a GLOBAL modifier, the statement displays the global status\n  values. A global status variable may represent status for some aspect\n  of the server itself (for example, Aborted_connects), or the\n  aggregated status over all connections to MySQL (for example,\n  Bytes_received and Bytes_sent). If a variable has no global value,\n  the session value is displayed.\n\no With a SESSION modifier, the statement displays the status variable\n  values for the current connection. If a variable has no session\n  value, the global value is displayed. LOCAL is a synonym for SESSION.\n\no If no modifier is present, the default is SESSION.\n\nThe scope for each status variable is listed at\nhttp://dev.mysql.com/doc/refman/5.7/en/server-status-variables.html.\n\nEach invocation of the SHOW STATUS statement uses an internal temporary\ntable and increments the global Created_tmp_tables value.\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern:\n\nmysql> SHOW STATUS LIKE \'Key%\';\n+--------------------+----------+\n| Variable_name      | Value    |\n+--------------------+----------+\n| Key_blocks_used    | 14955    |\n| Key_read_requests  | 96854827 |\n| Key_reads          | 162040   |\n| Key_write_requests | 7589728  |\n| Key_writes         | 3813196  |\n+--------------------+----------+\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-status.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (404,2,'ST_NUMINTERIORRINGS','ST_NumInteriorRing(poly), ST_NumInteriorRings(poly)\n\nReturns the number of interior rings in the Polygon value poly.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT ST_NumInteriorRings(ST_GeomFromText(@poly));\n+---------------------------------------------+\n| ST_NumInteriorRings(ST_GeomFromText(@poly)) |\n+---------------------------------------------+\n|                                           1 |\n+---------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (405,7,'JSON_KEYS','JSON_KEYS(json_doc[, path])\n\nReturns the keys from the top-level value of a JSON object as a JSON\narray, or, if a path argument is given, the top-level keys from the\nselected path. Returns NULL if any argument is NULL, the json_doc\nargument is not an object, or path, if given, does not locate an\nobject. An error occurs if the json_doc argument is not a valid JSON\ndocument or the path argument is not a valid path expression or\ncontains a * or ** wildcard.\n\nThe result array is empty if the selected object is empty. If the\ntop-level value has nested subobjects, the return value does not\ninclude keys from those subobjects.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html\n\n','mysql> SELECT JSON_KEYS(\'{"a": 1, "b": {"c": 30}}\');\n+---------------------------------------+\n| JSON_KEYS(\'{"a": 1, "b": {"c": 30}}\') |\n+---------------------------------------+\n| ["a", "b"]                            |\n+---------------------------------------+\nmysql> SELECT JSON_KEYS(\'{"a": 1, "b": {"c": 30}}\', \'$.b\');\n+----------------------------------------------+\n| JSON_KEYS(\'{"a": 1, "b": {"c": 30}}\', \'$.b\') |\n+----------------------------------------------+\n| ["c"]                                        |\n+----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (406,14,'INET6_ATON','Syntax:\nINET6_ATON(expr)\n\nGiven an IPv6 or IPv4 network address as a string, returns a binary\nstring that represents the numeric value of the address in network byte\norder (big endian). Because numeric-format IPv6 addresses require more\nbytes than the largest integer type, the representation returned by\nthis function has the VARBINARY data type: VARBINARY(16) for IPv6\naddresses and VARBINARY(4) for IPv4 addresses. If the argument is not a\nvalid address, INET6_ATON() returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> SELECT HEX(INET6_ATON(\'fdfe::5a55:caff:fefa:9089\'));\n        -> \'FDFE0000000000005A55CAFFFEFA9089\'\nmysql> SELECT HEX(INET6_ATON(\'10.0.5.9\'));\n        -> \'0A000509\'\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (407,27,'SHOW SLAVE HOSTS','Syntax:\nSHOW SLAVE HOSTS\n\nDisplays a list of replication slaves currently registered with the\nmaster.\n\nSHOW SLAVE HOSTS should be executed on a server that acts as a\nreplication master. The statement displays information about servers\nthat are or have been connected as replication slaves, with each row of\nthe result corresponding to one slave server, as shown here:\n\nmysql> SHOW SLAVE HOSTS;\n+-----------+-----------+-------+-----------+--------------------------------------+\n| Server_id | Host      | Port  | Master_id | Slave_UUID                           |\n+-----------+-----------+-------+-----------+--------------------------------------+\n|  192168010 | iconnect2 | 3306 | 192168011 | 14cb6624-7f93-11e0-b2c0-c80aa9429562 |\n| 1921680101 | athena    | 3306 | 192168011 | 07af4990-f41f-11df-a566-7ac56fdaf645 |\n+------------+-----------+------+-----------+--------------------------------------+\n\no Server_id: The unique server ID of the slave server, as configured in\n  the slave server\'s option file, or on the command line with\n  --server-id=value.\n\no Host: The host name of the slave server as specified on the slave\n  with the --report-host option. This can differ from the machine name\n  as configured in the operating system.\n\no User: The slave server user name as, specified on the slave with the\n  --report-user option. Statement output includes this column only if\n  the master server is started with the --show-slave-auth-info option.\n\no Password: The slave server password as, specified on the slave with\n  the --report-password option. Statement output includes this column\n  only if the master server is started with the --show-slave-auth-info\n  option.\n\no Port: The port on the master to which the slave server is listening,\n  as specified on the slave with the --report-port option.\n\n  A zero in this column means that the slave port (--report-port) was\n  not set.\n\no Master_id: The unique server ID of the master server that the slave\n  server is replicating from. This is the server ID of the server on\n  which SHOW SLAVE HOSTS is executed, so this same value is listed for\n  each row in the result.\n\no Slave_UUID: The globally unique ID of this slave, as generated on the\n  slave and found in the slave\'s auto.cnf file.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-slave-hosts.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-slave-hosts.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (408,8,'START TRANSACTION','Syntax:\nSTART TRANSACTION\n    [transaction_characteristic [, transaction_characteristic] ...]\n\ntransaction_characteristic:\n    WITH CONSISTENT SNAPSHOT\n  | READ WRITE\n  | READ ONLY\n\nBEGIN [WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\nThese statements provide control over use of transactions:\n\no START TRANSACTION or BEGIN start a new transaction.\n\no COMMIT commits the current transaction, making its changes permanent.\n\no ROLLBACK rolls back the current transaction, canceling its changes.\n\no SET autocommit disables or enables the default autocommit mode for\n  the current session.\n\nBy default, MySQL runs with autocommit mode enabled. This means that as\nsoon as you execute a statement that updates (modifies) a table, MySQL\nstores the update on disk to make it permanent. The change cannot be\nrolled back.\n\nTo disable autocommit mode implicitly for a single series of\nstatements, use the START TRANSACTION statement:\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nWith START TRANSACTION, autocommit remains disabled until you end the\ntransaction with COMMIT or ROLLBACK. The autocommit mode then reverts\nto its previous state.\n\nSTART TRANSACTION permits several modifiers that control transaction\ncharacteristics. To specify multiple modifiers, separate them by\ncommas.\n\no The WITH CONSISTENT SNAPSHOT modifier starts a consistent read for\n  storage engines that are capable of it. This applies only to InnoDB.\n  The effect is the same as issuing a START TRANSACTION followed by a\n  SELECT from any InnoDB table. See\n  http://dev.mysql.com/doc/refman/5.7/en/innodb-consistent-read.html.\n  The WITH CONSISTENT SNAPSHOT modifier does not change the current\n  transaction isolation level, so it provides a consistent snapshot\n  only if the current isolation level is one that permits a consistent\n  read. The only isolation level that permits a consistent read is\n  REPEATABLE READ. For all other isolation levels, the WITH CONSISTENT\n  SNAPSHOT clause is ignored. As of MySQL 5.7.2, a warning is generated\n  when the WITH CONSISTENT SNAPSHOT clause is ignored.\n\no The READ WRITE and READ ONLY modifiers set the transaction access\n  mode. They permit or prohibit changes to tables used in the\n  transaction. The READ ONLY restriction prevents the transaction from\n  modifying or locking both transactional and nontransactional tables\n  that are visible to other transactions; the transaction can still\n  modify or lock temporary tables.\n\n  MySQL enables extra optimizations for queries on InnoDB tables when\n  the transaction is known to be read-only. Specifying READ ONLY\n  ensures these optimizations are applied in cases where the read-only\n  status cannot be determined automatically. See\n  http://dev.mysql.com/doc/refman/5.7/en/innodb-performance-ro-txn.html\n  for more information.\n\n  If no access mode is specified, the default mode applies. Unless the\n  default has been changed, it is read/write. It is not permitted to\n  specify both READ WRITE and READ ONLY in the same statement.\n\n  In read-only mode, it remains possible to change tables created with\n  the TEMPORARY keyword using DML statements. Changes made with DDL\n  statements are not permitted, just as with permanent tables.\n\n  For additional information about transaction access mode, including\n  ways to change the default mode, see [HELP ISOLATION].\n\n  If the read_only system variable is enabled, explicitly starting a\n  transaction with START TRANSACTION READ WRITE requires the SUPER\n  privilege.\n\n*Important*: Many APIs used for writing MySQL client applications (such\nas JDBC) provide their own methods for starting transactions that can\n(and sometimes should) be used instead of sending a START TRANSACTION\nstatement from the client. See\nhttp://dev.mysql.com/doc/refman/5.7/en/connectors-apis.html, or the\ndocumentation for your API, for more information.\n\nTo disable autocommit mode explicitly, use the following statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to\nzero, changes to transaction-safe tables (such as those for InnoDB or\nNDB) are not made permanent immediately. You must use COMMIT to store\nyour changes to disk or ROLLBACK to ignore the changes.\n\nautocommit is a session variable and must be set for each session. To\ndisable autocommit mode for each new connection, see the description of\nthe autocommit system variable at\nhttp://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html.\n\nBEGIN and BEGIN WORK are supported as aliases of START TRANSACTION for\ninitiating a transaction. START TRANSACTION is standard SQL syntax, is\nthe recommended way to start an ad-hoc transaction, and permits\nmodifiers that BEGIN does not.\n\nThe BEGIN statement differs from the use of the BEGIN keyword that\nstarts a BEGIN ... END compound statement. The latter does not begin a\ntransaction. See [HELP BEGIN END].\n\n*Note*: Within all stored programs (stored procedures and functions,\ntriggers, and events), the parser treats BEGIN [WORK] as the beginning\nof a BEGIN ... END block. Begin a transaction in this context with\nSTART TRANSACTION instead.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are\nthe CHAIN and RELEASE clauses. CHAIN and RELEASE can be used for\nadditional control over transaction completion. The value of the\ncompletion_type system variable determines the default completion\nbehavior. See\nhttp://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the\ncurrent one ends, and the new transaction has the same isolation level\nas the just-terminated transaction. The RELEASE clause causes the\nserver to disconnect the current client session after terminating the\ncurrent transaction. Including the NO keyword suppresses CHAIN or\nRELEASE completion, which can be useful if the completion_type system\nvariable is set to cause chaining or release completion by default.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/commit.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/commit.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (409,32,'TIME_FORMAT','Syntax:\nTIME_FORMAT(time,format)\n\nThis is used like the DATE_FORMAT() function, but the format string may\ncontain format specifiers only for hours, minutes, seconds, and\nmicroseconds. Other specifiers produce a NULL value or 0.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT TIME_FORMAT(\'100:00:00\', \'%H %k %h %I %l\');\n        -> \'100 100 04 04 4\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (410,40,'CREATE DATABASE','Syntax:\nCREATE {DATABASE | SCHEMA} [IF NOT EXISTS] db_name\n    [create_specification] ...\n\ncreate_specification:\n    [DEFAULT] CHARACTER SET [=] charset_name\n  | [DEFAULT] COLLATE [=] collation_name\n\nCREATE DATABASE creates a database with the given name. To use this\nstatement, you need the CREATE privilege for the database. CREATE\nSCHEMA is a synonym for CREATE DATABASE.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-database.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-database.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (411,16,'VAR_POP','Syntax:\nVAR_POP(expr)\n\nReturns the population standard variance of expr. It considers rows as\nthe whole population, not as a sample, so it has the number of rows as\nthe denominator. You can also use VARIANCE(), which is equivalent but\nis not standard SQL.\n\nVAR_POP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (412,38,'CONCAT_WS','Syntax:\nCONCAT_WS(separator,str1,str2,...)\n\nCONCAT_WS() stands for Concatenate With Separator and is a special form\nof CONCAT(). The first argument is the separator for the rest of the\narguments. The separator is added between the strings to be\nconcatenated. The separator can be a string, as can the rest of the\narguments. If the separator is NULL, the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT CONCAT_WS(\',\',\'First name\',\'Second name\',\'Last Name\');\n        -> \'First name,Second name,Last Name\'\nmysql> SELECT CONCAT_WS(\',\',\'First name\',NULL,\'Last Name\');\n        -> \'First name,Last Name\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (413,23,'TEXT','TEXT[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 65,535 (216 − 1) characters.\nThe effective maximum length is less if the value contains multibyte\ncharacters. Each TEXT value is stored using a 2-byte length prefix that\nindicates the number of bytes in the value.\n\nAn optional length M can be given for this type. If this is done, MySQL\ncreates the column as the smallest TEXT type large enough to hold\nvalues M characters long.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (414,19,'~','Syntax:\n~\n\nInvert all bits.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html\n\n','mysql> SELECT 5 & ~1;\n        -> 4\n','http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (415,3,'ASIN','Syntax:\nASIN(X)\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT ASIN(0.2);\n        -> 0.20135792079033\nmysql> SELECT ASIN(\'foo\');\n\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n1 row in set, 1 warning (0.00 sec)\n\nmysql> SHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (416,17,'ROW_COUNT','Syntax:\nROW_COUNT()\n\nROW_COUNT() returns a value as follows:\n\no DDL statements: 0. This applies to statements such as CREATE TABLE or\n  DROP TABLE.\n\no DML statements other than SELECT: The number of affected rows. This\n  applies to statements such as UPDATE, INSERT, or DELETE (as before),\n  but now also to statements such as ALTER TABLE and LOAD DATA INFILE.\n\no SELECT: -1 if the statement returns a result set, or the number of\n  rows "affected" if it does not. For example, for SELECT * FROM t1,\n  ROW_COUNT() returns -1. For SELECT * FROM t1 INTO OUTFILE\n  \'file_name\', ROW_COUNT() returns the number of rows written to the\n  file.\n\no SIGNAL statements: 0.\n\nFor UPDATE statements, the affected-rows value by default is the number\nof rows actually changed. If you specify the CLIENT_FOUND_ROWS flag to\nmysql_real_connect() when connecting to mysqld, the affected-rows value\nis the number of rows "found"; that is, matched by the WHERE clause.\n\nFor REPLACE statements, the affected-rows value is 2 if the new row\nreplaced an old row, because in this case, one row was inserted after\nthe duplicate was deleted.\n\nFor INSERT ... ON DUPLICATE KEY UPDATE statements, the affected-rows\nvalue per row is 1 if the row is inserted as a new row, 2 if an\nexisting row is updated, and 0 if an existing row is set to its current\nvalues. If you specify the CLIENT_FOUND_ROWS flag, the affected-rows\nvalue is 1 (not 0) if an existing row is set to its current values.\n\nThe ROW_COUNT() value is similar to the value from the\nmysql_affected_rows() C API function and the row count that the mysql\nclient displays following statement execution.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> INSERT INTO t VALUES(1),(2),(3);\nQuery OK, 3 rows affected (0.00 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           3 |\n+-------------+\n1 row in set (0.00 sec)\n\nmysql> DELETE FROM t WHERE i IN(1,2);\nQuery OK, 2 rows affected (0.00 sec)\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           2 |\n+-------------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (417,7,'MBRCOVEREDBY','MBRCoveredBy(g1,g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\nis covered by the minimum bounding rectangle of g2. This tests the\nopposite relationship as MBRCovers().\n\nMBRCoveredBy() and MBRCovers() handle their arguments and return a\nvalue as follows:\n\no Return NULL if either argument is NULL or an empty geometry\n\no Return ER_GIS_INVALID_DATA if either argument is not a valid geometry\n  byte string (SRID plus WKB value)\n\no Otherwise, return non-NULL\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html\n\n','mysql> SET @g1 = ST_GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = ST_GeomFromText(\'Point(1 1)\');\nmysql> SELECT MBRCovers(@g1,@g2), MBRCoveredby(@g1,@g2);\n+--------------------+-----------------------+\n| MBRCovers(@g1,@g2) | MBRCoveredby(@g1,@g2) |\n+--------------------+-----------------------+\n|                  1 |                     0 |\n+--------------------+-----------------------+\nmysql> SELECT MBRCovers(@g2,@g1), MBRCoveredby(@g2,@g1);\n+--------------------+-----------------------+\n| MBRCovers(@g2,@g1) | MBRCoveredby(@g2,@g1) |\n+--------------------+-----------------------+\n|                  0 |                     1 |\n+--------------------+-----------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (418,3,'SIGN','Syntax:\nSIGN(X)\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X\nis negative, zero, or positive.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT SIGN(-32);\n        -> -1\nmysql> SELECT SIGN(0);\n        -> 0\nmysql> SELECT SIGN(234);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (419,23,'FLOAT','FLOAT[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA small (single-precision) floating-point number. Permissible values\nare -3.402823466E+38 to -1.175494351E-38, 0, and 1.175494351E-38 to\n3.402823466E+38. These are the theoretical limits, based on the IEEE\nstandard. The actual range might be slightly smaller depending on your\nhardware or operating system.\n\nM is the total number of digits and D is the number of digits following\nthe decimal point. If M and D are omitted, values are stored to the\nlimits permitted by the hardware. A single-precision floating-point\nnumber is accurate to approximately 7 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nUsing FLOAT might give you some unexpected problems because all\ncalculations in MySQL are done with double precision. See\nhttp://dev.mysql.com/doc/refman/5.7/en/no-matching-rows.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (420,17,'CHARSET','Syntax:\nCHARSET(str)\n\nReturns the character set of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> SELECT CHARSET(\'abc\');\n        -> \'latin1\'\nmysql> SELECT CHARSET(CONVERT(\'abc\' USING utf8));\n        -> \'utf8\'\nmysql> SELECT CHARSET(USER());\n        -> \'utf8\'\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (421,7,'ASYMMETRIC_VERIFY','Syntax:\nASYMMETRIC_VERIFY(algorithm, digest_str, sig_str, pub_key_str,\ndigest_type)\n\nVerifies whether the signature string matches the digest string, and\nreturns 1 or 0 to indicate whether verification succeeded or failed.\n\ndigest_str is the digest string. It can be generated by calling\nCREATE_DIGEST(). digest_type indicates the digest algorithm used to\ngenerate the digest string.\n\nsig_str is the signature string. It can be generated by calling\nASYMMETRIC_SIGN().\n\npub_key_str is the public key string of the signer. It corresponds to\nthe private key passed to ASYMMETRIC_SIGN() to generate the signature\nstring and must be a valid key string in PEM format. algorithm\nindicates the encryption algorithm used to create the key.\n\nSupported algorithm values: \'RSA\', \'DSA\'\n\nSupported digest_type values: \'SHA224\', \'SHA256\', \'SHA384\', \'SHA512\'\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html\n\n','-- Set the encryption algorithm and digest type\nSET @algo = \'RSA\';\nSET @dig_type = \'SHA224\';\n\n-- Create private/public key pair\nSET @priv = CREATE_ASYMMETRIC_PRIV_KEY(@algo, 1024);\nSET @pub = CREATE_ASYMMETRIC_PUB_KEY(@algo, @priv);\n\n-- Generate digest from string\nSET @dig = CREATE_DIGEST(@dig_type, \'The quick brown fox\');\n\n-- Generate signature for digest and verify signature against digest\nSET @sig = ASYMMETRIC_SIGN(@algo, @dig, @priv, @dig_type);\nSET @verf = ASYMMETRIC_VERIFY(@algo, @dig, @sig, @pub, @dig_type);\n','http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (422,32,'SUBDATE','Syntax:\nSUBDATE(date,INTERVAL expr unit), SUBDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, SUBDATE()\nis a synonym for DATE_SUB(). For information on the INTERVAL unit\nargument, see the discussion for DATE_ADD().\n\nmysql> SELECT DATE_SUB(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2007-12-02\'\nmysql> SELECT SUBDATE(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2007-12-02\'\n\nThe second form enables the use of an integer value for days. In such\ncases, it is interpreted as the number of days to be subtracted from\nthe date or datetime expression expr.\n\nmysql> SELECT SUBDATE(\'2008-01-02 12:00:00\', 31);\n        -> \'2007-12-02 12:00:00\'\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (423,7,'JSON_CONTAINS','JSON_CONTAINS(json_doc, val[, path])\n\nReturns 0 or 1 to indicate whether a specific value is contained in a\ntarget JSON document, or, if a path argument is given, at a specific\npath within the target document. Returns NULL if any argument is NULL\nor the path argument does not identify a section of the target\ndocument. An error occurs if either document argument is not a valid\nJSON document or the path argument is not a valid path expression or\ncontains a * or ** wildcard.\n\nTo check only whether any data exists at the path, use\nJSON_CONTAINS_PATH() instead.\n\nThe following rules define containment:\n\no A candidate scalar is contained in a target scalar if and only if\n  they are comparable and are equal. Two scalar values are comparable\n  if they have the same JSON_TYPE() types, with the exception that\n  values of types INTEGER and DECIMAL are also comparable to each\n  other.\n\no A candidate array is contained in a target array if and only if every\n  element in the candidate is contained in some element of the target.\n\no A candidate nonarray is contained in a target array if and only if\n  the candidate is contained in some element of the target.\n\no A candidate object is contained in a target object if and only if for\n  each key in the candidate there is a key with the same name in the\n  target and the value associated with the candidate key is contained\n  in the value associated with the target key.\n\nOtherwise, the candidate value is not contained in the target document.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html\n\n','mysql> SET @j = \'{"a": 1, "b": 2, "c": {"d": 4}}\';\nmysql> SET @j2 = \'1\';\nmysql> SELECT JSON_CONTAINS(@j, @j2, \'$.a\');\n+-------------------------------+\n| JSON_CONTAINS(@j, @j2, \'$.a\') |\n+-------------------------------+\n|                             1 |\n+-------------------------------+\nmysql> SELECT JSON_CONTAINS(@j, @j2, \'$.b\');\n+-------------------------------+\n| JSON_CONTAINS(@j, @j2, \'$.b\') |\n+-------------------------------+\n|                             0 |\n+-------------------------------+\n\nmysql> SET @j2 = \'{"d": 4}\';\nmysql> SELECT JSON_CONTAINS(@j, @j2, \'$.a\');\n+-------------------------------+\n| JSON_CONTAINS(@j, @j2, \'$.a\') |\n+-------------------------------+\n|                             0 |\n+-------------------------------+\nmysql> SELECT JSON_CONTAINS(@j, @j2, \'$.c\');\n+-------------------------------+\n| JSON_CONTAINS(@j, @j2, \'$.c\') |\n+-------------------------------+\n|                             1 |\n+-------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (424,32,'DAYOFYEAR','Syntax:\nDAYOFYEAR(date)\n\nReturns the day of the year for date, in the range 1 to 366.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFYEAR(\'2007-02-03\');\n        -> 34\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (425,3,'%','Syntax:\nN % M, N MOD M\n\nModulo operation. Returns the remainder of N divided by M. For more\ninformation, see the description for the MOD() function in\nhttp://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (426,33,'ASTEXT','AsText(g), AsWKT(g)\n\nST_AsText(), ST_AsWKT(), AsText(), and AsWKT() are synonyms. For more\ninformation, see the description of ST_AsText().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-format-conversion-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-format-conversion-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (427,24,'DECLARE CONDITION','Syntax:\nDECLARE condition_name CONDITION FOR condition_value\n\ncondition_value:\n    mysql_error_code\n  | SQLSTATE [VALUE] sqlstate_value\n\nThe DECLARE ... CONDITION statement declares a named error condition,\nassociating a name with a condition that needs specific handling. The\nname can be referred to in a subsequent DECLARE ... HANDLER statement\n(see [HELP DECLARE HANDLER]).\n\nCondition declarations must appear before cursor or handler\ndeclarations.\n\nThe condition_value for DECLARE ... CONDITION indicates the specific\ncondition or class of conditions to associate with the condition name.\nIt can take the following forms:\n\no mysql_error_code: An integer literal indicating a MySQL error code.\n\n  Do not use MySQL error code 0 because that indicates success rather\n  than an error condition. For a list of MySQL error codes, see\n  http://dev.mysql.com/doc/refman/5.7/en/error-messages-server.html.\n\no SQLSTATE [VALUE] sqlstate_value: A 5-character string literal\n  indicating an SQLSTATE value.\n\n  Do not use SQLSTATE values that begin with \'00\' because those\n  indicate success rather than an error condition. For a list of\n  SQLSTATE values, see\n  http://dev.mysql.com/doc/refman/5.7/en/error-messages-server.html.\n\nCondition names referred to in SIGNAL or use RESIGNAL statements must\nbe associated with SQLSTATE values, not MySQL error codes.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/declare-condition.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/declare-condition.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (428,32,'MONTHNAME','Syntax:\nMONTHNAME(date)\n\nReturns the full name of the month for date. The language used for the\nname is controlled by the value of the lc_time_names system variable\n(http://dev.mysql.com/doc/refman/5.7/en/locale-support.html).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT MONTHNAME(\'2008-02-03\');\n        -> \'February\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (429,26,'NUMGEOMETRIES','NumGeometries(gc)\n\nST_NumGeometries() and NumGeometries() are synonyms. For more\ninformation, see the description of ST_NumGeometries().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-geometrycollection-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-geometrycollection-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (430,8,'CHANGE MASTER TO','Syntax:\nCHANGE MASTER TO option [, option] ... [ channel_option ] \n\noption:\n    MASTER_BIND = \'interface_name\'\n  | MASTER_HOST = \'host_name\'\n  | MASTER_USER = \'user_name\'\n  | MASTER_PASSWORD = \'password\'\n  | MASTER_PORT = port_num\n  | MASTER_CONNECT_RETRY = interval\n  | MASTER_RETRY_COUNT = count\n  | MASTER_DELAY = interval\n  | MASTER_HEARTBEAT_PERIOD = interval\n  | MASTER_LOG_FILE = \'master_log_name\'\n  | MASTER_LOG_POS = master_log_pos\n  | MASTER_AUTO_POSITION = {0|1}\n  | RELAY_LOG_FILE = \'relay_log_name\'\n  | RELAY_LOG_POS = relay_log_pos\n  | MASTER_SSL = {0|1}\n  | MASTER_SSL_CA = \'ca_file_name\'\n  | MASTER_SSL_CAPATH = \'ca_directory_name\'\n  | MASTER_SSL_CERT = \'cert_file_name\'\n  | MASTER_SSL_CRL = \'crl_file_name\'\n  | MASTER_SSL_CRLPATH = \'crl_directory_name\'\n  | MASTER_SSL_KEY = \'key_file_name\'\n  | MASTER_SSL_CIPHER = \'cipher_list\'\n  | MASTER_SSL_VERIFY_SERVER_CERT = {0|1}\n  | MASTER_TLS_VERSION = \'protocol_list\'\n  | IGNORE_SERVER_IDS = (server_id_list)\n\nchannel_option: \n    FOR CHANNEL channel\n\nserver_id_list:\n    [server_id [, server_id] ... ]\n\nCHANGE MASTER TO changes the parameters that the slave server uses for\nconnecting to the master server, for reading the master binary log, and\nreading the slave relay log. It also updates the contents of the master\ninfo and relay log info repositories (see\nhttp://dev.mysql.com/doc/refman/5.7/en/slave-logs.html).\n\nPrior to MySQL 5.7.4, the slave replication threads must be stopped,\nusing STOP SLAVE if necessary, before issuing this statement. In MySQL\n5.7.4 and later, you can issue CHANGE MASTER TO statements on a running\nslave without doing this, depending on the states of the slave SQL\nthread and slave I/O thread. The rules governing such use are provided\nlater in this section.\n\nWhen using a multi-threaded slave (in other words\nslave_parallel_workers is greater than 0), stopping the slave can cause\n"gaps" in the sequence of transactions that have been executed from the\nrelay log, regardless of whether the slave was stopped intentionally or\notherwise. When such gaps exist, issuing CHANGE MASTER TO fails. The\nsolution in this situation is to issue START SLAVE UNTIL\nSQL_AFTER_MTS_GAPS which ensures that the gaps are closed.\n\nThe optional FOR CHANNEL channel clause added in MySQL 5.7.6 enables\nyou to choose which replication channel the statement applies to. If no\nclause is set and no extra channels exist, the statement applies to the\ndefault channel and behaves the same as versions of MySQL prior to\n5.7.6. Providing a FOR CHANNEL channel clause applies the CHANGE MASTER\nTO statement to a specific replication channel, and is used to add a\nnew channel or modify an existing channel. For example, to add a new\nchannel called channel2:\n\nCHANGE MASTER TO MASTER_NAME=host1, MASTER_PORT=3002 FOR CHANNEL channel2\n\nWhen using multiple replication channels, if a CHANGE MASTER TO\nstatement does not have a channel defined using a FOR CHANNEL channel\nclause an error is generated. See\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-channels.html for\nmore information.\n\nOptions not specified retain their value, except as indicated in the\nfollowing discussion. Thus, in most cases, there is no need to specify\noptions that do not change. For example, if the password to connect to\nyour MySQL master has changed, issue this statement to tell the slave\nabout the new password:\n\nCHANGE MASTER TO MASTER_PASSWORD=\'new3cret\';\n\nMASTER_HOST, MASTER_USER, MASTER_PASSWORD, and MASTER_PORT provide\ninformation to the slave about how to connect to its master:\n\no MASTER_HOST and MASTER_PORT are the host name (or IP address) of the\n  master host and its TCP/IP port.\n\n  *Note*: Replication cannot use Unix socket files. You must be able to\n  connect to the master MySQL server using TCP/IP.\n\n  If you specify the MASTER_HOST or MASTER_PORT option, the slave\n  assumes that the master server is different from before (even if the\n  option value is the same as its current value.) In this case, the old\n  values for the master binary log file name and position are\n  considered no longer applicable, so if you do not specify\n  MASTER_LOG_FILE and MASTER_LOG_POS in the statement,\n  MASTER_LOG_FILE=\'\' and MASTER_LOG_POS=4 are silently appended to it.\n\n  Setting MASTER_HOST=\'\' (that is, setting its value explicitly to an\n  empty string) is not the same as not setting MASTER_HOST at all.\n  Beginning with MySQL 5.5, trying to set MASTER_HOST to an empty\n  string fails with an error. Previously, setting MASTER_HOST to an\n  empty string caused START SLAVE subsequently to fail. (Bug #28796)\n\n  Values used for MASTER_HOST and other CHANGE MASTER TO options are\n  checked for linefeed (\\n or 0x0A) characters; the presence of such\n  characters in these values causes the statement to fail with\n  ER_MASTER_INFO. (Bug #11758581, Bug #50801)\n\no MASTER_USER and MASTER_PASSWORD are the user name and password of the\n  account to use for connecting to the master.\n\n  MASTER_USER cannot be made empty; setting MASTER_USER = \'\' or leaving\n  it unset when setting a value for MASTER_PASSWORD causes an error\n  (Bug #13427949).\n\n  The password used for a MySQL Replication slave account in a CHANGE\n  MASTER TO statement is limited to 32 characters in length; prior to\n  MySQL 5.7.5, if the password was longer, the statement succeeded, but\n  any excess characters were silently truncated. In MySQL 5.7.5 and\n  later, trying to use a password of more than 32 characters causes\n  CHANGE MASTER TO to fail. (Bug #11752299, Bug #43439)\n\n  The text of a running CHANGE MASTER TO statement, including values\n  for MASTER_USER and MASTER_PASSWORD, can be seen in the output of a\n  concurrent SHOW PROCESSLIST statement. (The complete text of a START\n  SLAVE statement is also visible to SHOW PROCESSLIST.)\n\nThe MASTER_SSL_xxx options provide information about using SSL for the\nconnection. They correspond to the --ssl-xxx options described in\nhttp://dev.mysql.com/doc/refman/5.7/en/secure-connection-options.html,\nand\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-solutions-secure-con\nnections.html. These options can be changed even on slaves that are\ncompiled without SSL support. They are saved to the master info\nrepository, but are ignored if the slave does not have SSL support\nenabled.\n\nAs of MySQL 5.7.3, the MASTER_SSL=1 is prescriptive, not advisory. When\ngiven, the slave connection to the master must use SSL or the\nconnection attempt fails. Before 5.7.3, an SSL connection is permitted\nbut not required. This is analogous to the client-side meaning of the\n--ssl command-line option; see\nhttp://dev.mysql.com/doc/refman/5.7/en/secure-connection-options.html.\n\nThe MASTER_TLS_VERSION option specifies the encryption protocols\npermitted by the master for slave connections. The value is like that\nfor the tls_version system variable: A comma-separated list containing\none or more protocol names. The protocols that can be named for this\noption depend on the SSL library used to compile MySQL. For details,\nsee\nhttp://dev.mysql.com/doc/refman/5.7/en/secure-connection-protocols-ciph\ners.html. This option was added in MySQL 5.7.10.\n\nMASTER_CONNECT_RETRY specifies how many seconds to wait between connect\nretries. The default is 60.\n\nMASTER_RETRY_COUNT limits the number of reconnection attempts and\nupdates the value of the Master_Retry_Count column in the output of\nSHOW SLAVE STATUS. The default value is 24 * 3600 = 86400.\nMASTER_RETRY_COUNT is intended to replace the older\n--master-retry-count server option, and is now the preferred method for\nsetting this limit. You are encouraged not to rely on\n--master-retry-count in new applications and, when upgrading to MySQL\n5.7, to update any existing applications that rely on it, so that they\nuse CHANGE MASTER TO ... MASTER_RETRY_COUNT instead.\n\nMASTER_DELAY specifies how many seconds behind the master the slave\nmust lag. An event received from the master is not executed until at\nleast interval seconds later than its execution on the master. The\ndefault is 0. An error occurs if interval is not a nonnegative integer\nin the range from 0 to 231−1. For more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-delayed.html.\n\nIn MySQL 5.7.4 and later, a CHANGE MASTER TO statement employing the\nMASTER_DELAY option can be executed on a running slave when the slave\nSQL thread is stopped.\n\nMASTER_BIND is for use on replication slaves having multiple network\ninterfaces, and determines which of the slave\'s network interfaces is\nchosen for connecting to the master.\n\nThe address configured with this option, if any, can be seen in the\nMaster_Bind column of the output from SHOW SLAVE STATUS. If you are\nusing slave status log tables (server started with\n--master-info-repository=TABLE), the value can also be seen as the\nMaster_bind column of the mysql.slave_master_info table.\n\nThe ability to bind a replication slave to a specific network interface\nis also supported by MySQL Cluster.\n\nMASTER_HEARTBEAT_PERIOD sets the interval in seconds between\nreplication heartbeats. Whenever the master\'s binary log is updated\nwith an event, the waiting period for the next heartbeat is reset.\ninterval is a decimal value having the range 0 to 4294967 seconds and a\nresolution in milliseconds; the smallest nonzero value is 0.001.\nHeartbeats are sent by the master only if there are no unsent events in\nthe binary log file for a period longer than interval.\n\nPrior to MySQL 5.7.4, not including MASTER_HEARTBEAT_PERIOD caused\nCHANGE MASTER TO to reset the heartbeat period (Slave_heartbeat_period)\nto the default, and Slave_received_heartbeats to 0. (Bug #18185490)\n\nIf you are logging master connection information to tables,\nMASTER_HEARTBEAT_PERIOD can be seen as the value of the Heartbeat\ncolumn of the mysql.slave_master_info table.\n\nSetting interval to 0 disables heartbeats altogether. The default value\nfor interval is equal to the value of slave_net_timeout divided by 2.\n\nSetting @@global.slave_net_timeout to a value less than that of the\ncurrent heartbeat interval results in a warning being issued. The\neffect of issuing RESET SLAVE on the heartbeat interval is to reset it\nto the default value.\n\nMASTER_LOG_FILE and MASTER_LOG_POS are the coordinates at which the\nslave I/O thread should begin reading from the master the next time the\nthread starts. RELAY_LOG_FILE and RELAY_LOG_POS are the coordinates at\nwhich the slave SQL thread should begin reading from the relay log the\nnext time the thread starts. If you specify either of MASTER_LOG_FILE\nor MASTER_LOG_POS, you cannot specify RELAY_LOG_FILE or RELAY_LOG_POS.\nIf you specify either of MASTER_LOG_FILE or MASTER_LOG_POS, you also\ncannot specify MASTER_AUTO_POSITION = 1 (described later in this\nsection). If neither of MASTER_LOG_FILE or MASTER_LOG_POS is specified,\nthe slave uses the last coordinates of the slave SQL thread before\nCHANGE MASTER TO was issued. This ensures that there is no\ndiscontinuity in replication, even if the slave SQL thread was late\ncompared to the slave I/O thread, when you merely want to change, say,\nthe password to use.\n\nIn MySQL 5.7.4 and later, a CHANGE MASTER TO statement employing\nRELAY_LOG_FILE, RELAY_LOG_POS, or both options can be executed on a\nrunning slave when the slave SQL thread is stopped.\n\nIf MASTER_AUTO_POSITION = 1 is used with CHANGE MASTER TO, the slave\nattempts to connect to the master using the GTID-based replication\nprotocol. In MySQL 5.7.4 and later, this option can be employed by\nCHANGE MASTER TO only if both the slave SQL and slave I/O threads are\nstopped.\n\nWhen using GTIDs, the slave tells the master which transactions it has\nalready received, executed, or both. To compute this set, it reads the\nglobal value of gtid_executed and the value of the Retrieved_gtid_set\ncolumn from SHOW SLAVE STATUS. Since the GTID of the last transmitted\ntransaction is included in Retrieved_gtid_set even if the transaction\nwas only partially transmitted, the last received GTID is subtracted\nfrom this set. Thus, the slave computes the following set:\n\nUNION(@@global.gtid_executed, Retrieved_gtid_set - last_received_GTID)\n\nThis set is sent to the master as part of the initial handshake, and\nthe master sends back all transactions that it has executed which are\nnot part of the set. If any of these transactions have been already\npurged from the master\'s binary log, the master sends the error\nER_MASTER_HAS_PURGED_REQUIRED_GTIDS to the slave, and replication does\nnot start.\n\nWhen GTID-based replication is employed, the coordinates represented by\nMASTER_LOG_FILE and MASTER_LOG_POS are not used, and global transaction\nidentifiers are used instead. Thus the use of either or both of these\noptions together with MASTER_AUTO_POSITION causes an error.\n\nBeginning with MySQL 5.7.1, you can see whether replication is running\nwith autopositioning enabled by checking the output of SHOW SLAVE\nSTATUS. (Bug #15992220)\n\ngtid_mode must also be enabled before issuing CHANGE MASTER TO ...\nMASTER_AUTO_POSITION = 1. Otherwise, the statement fails with an error.\n\nTo revert to the older file-based replication protocol after using\nGTIDs, you can issue a new CHANGE MASTER TO statement that specifies\nMASTER_AUTO_POSITION = 0, as well as at least one of MASTER_LOG_FILE or\nMASTER_LOG_POS.\n\nPrior to MySQL 5.7.4, CHANGE MASTER TO deletes all relay log files and\nstarts a new one, unless you specify RELAY_LOG_FILE or RELAY_LOG_POS.\nIn that case, relay log files are kept; the relay_log_purge global\nvariable is set silently to 0. In MySQL 5.7.4 and later, relay logs are\npreserved when neither the slave SQL thread nor the slave I/O thread is\nstopped; if both threads are stopped, all relay log files are deleted\nunless you at least one of RELAY_LOG_FILE or RELAY_LOG_POS is\nspecified.\n\nRELAY_LOG_FILE can use either an absolute or relative path, and uses\nthe same base name as MASTER_LOG_FILE. (Bug #12190)\n\nIGNORE_SERVER_IDS takes a comma-separated list of 0 or more server IDs.\nEvents originating from the corresponding servers are ignored, with the\nexception of log rotation and deletion events, which are still recorded\nin the relay log.\n\nIn circular replication, the originating server normally acts as the\nterminator of its own events, so that they are not applied more than\nonce. Thus, this option is useful in circular replication when one of\nthe servers in the circle is removed. Suppose that you have a circular\nreplication setup with 4 servers, having server IDs 1, 2, 3, and 4, and\nserver 3 fails. When bridging the gap by starting replication from\nserver 2 to server 4, you can include IGNORE_SERVER_IDS = (3) in the\nCHANGE MASTER TO statement that you issue on server 4 to tell it to use\nserver 2 as its master instead of server 3. Doing so causes it to\nignore and not to propagate any statements that originated with the\nserver that is no longer in use.\n\nIf a CHANGE MASTER TO statement is issued without any IGNORE_SERVER_IDS\noption, any existing list is preserved. To clear the list of ignored\nservers, it is necessary to use the option with an empty list:\n\nCHANGE MASTER TO IGNORE_SERVER_IDS = ();\n\nPrior to MySQL 5.7.5, RESET SLAVE ALL has no effect on the server ID\nlist. In MySQL 5.7.5 and later, RESET SLAVE ALL clears\nIGNORE_SERVER_IDS. (Bug #18816897)\n\nIf IGNORE_SERVER_IDS contains the server\'s own ID and the server was\nstarted with the --replicate-same-server-id option enabled, an error\nresults.\n\nIn MySQL 5.7, the master info repository and the output of SHOW SLAVE\nSTATUS provide the list of servers that are currently ignored. For more\ninformation, see\nhttp://dev.mysql.com/doc/refman/5.7/en/slave-logs-status.html, and\n[HELP SHOW SLAVE STATUS].\n\nIn MySQL 5.7, invoking CHANGE MASTER TO causes the previous values for\nMASTER_HOST, MASTER_PORT, MASTER_LOG_FILE, and MASTER_LOG_POS to be\nwritten to the error log, along with other information about the\nslave\'s state prior to execution.\n\nIn MySQL 5.7, CHANGE MASTER TO causes an implicit commit of an ongoing\ntransaction. See\nhttp://dev.mysql.com/doc/refman/5.7/en/implicit-commit.html.\n\nIn MySQL 5.7.4 and later, the strict requirement to execute STOP SLAVE\nprior to issuing any CHANGE MASTER TO statement (and START SLAVE\nafterward) is removed. Instead of depending on whether the slave is\nstopped, the behavior of CHANGE MASTER TO depends (in MySQL 5.7.4 and\nlater) on the states of the slave SQL thread and slave I/O threads;\nwhich of these threads is stopped or running now determines the options\nthat can or cannot be used with a CHANGE MASTER TO statement at a given\npoint in time. The rules for making this determination are listed here:\n\no If the SQL thread is stopped, you can execute CHANGE MASTER TO using\n  any combination that is otherwise allowed of RELAY_LOG_FILE,\n  RELAY_LOG_POS, and MASTER_DELAY options, even if the slave I/O thread\n  is running. No other options may be used with this statement when the\n  I/O thread is running.\n\no If the I/O thread is stopped, you can execute CHANGE MASTER TO using\n  any of the options for this statement (in any allowed combination)\n  except RELAY_LOG_FILE, RELAY_LOG_POS, or MASTER_DELAY, even when the\n  SQL thread is running. These three options may not be used when the\n  I/O thread is running.\n\no Both the SQL thread and the I/O thread must be stopped before issuing\n  a CHANGE MASTER TO statement that employs MASTER_AUTO_POSITION = 1.\n\nYou can check the current state of the slave SQL and I/O threads using\nSHOW SLAVE STATUS.\n\nFor more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-solutions-switch.htm\nl.\n\nIf you are using statement-based replication and temporary tables, it\nis possible for a CHANGE MASTER TO statement following a STOP SLAVE\nstatement to leave behind temporary tables on the slave. In MySQL 5.7.4\nand later, a warning (ER_WARN_OPEN_TEMP_TABLES_MUST_BE_ZERO) is now\nissued whenever this occurs. You can avoid this in such cases by making\nsure that the value of the Slave_open_temp_tables system status\nvariable is equal to 0 prior to executing such a CHANGE MASTER TO\nstatement.\n\nCHANGE MASTER TO is useful for setting up a slave when you have the\nsnapshot of the master and have recorded the master binary log\ncoordinates corresponding to the time of the snapshot. After loading\nthe snapshot into the slave to synchronize it with the master, you can\nrun CHANGE MASTER TO MASTER_LOG_FILE=\'log_name\', MASTER_LOG_POS=log_pos\non the slave to specify the coordinates at which the slave should begin\nreading the master binary log.\n\nThe following example changes the master server the slave uses and\nestablishes the master binary log coordinates from which the slave\nbegins reading. This is used when you want to set up the slave to\nreplicate the master:\n\nCHANGE MASTER TO\n  MASTER_HOST=\'master2.mycompany.com\',\n  MASTER_USER=\'replication\',\n  MASTER_PASSWORD=\'bigs3cret\',\n  MASTER_PORT=3306,\n  MASTER_LOG_FILE=\'master2-bin.001\',\n  MASTER_LOG_POS=4,\n  MASTER_CONNECT_RETRY=10;\n\nThe next example shows an operation that is less frequently employed.\nIt is used when the slave has relay log files that you want it to\nexecute again for some reason. To do this, the master need not be\nreachable. You need only use CHANGE MASTER TO and start the SQL thread\n(START SLAVE SQL_THREAD):\n\nCHANGE MASTER TO\n  RELAY_LOG_FILE=\'slave-relay-bin.006\',\n  RELAY_LOG_POS=4025;\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/change-master-to.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/change-master-to.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (431,32,'TIMESTAMP FUNCTION','Syntax:\nTIMESTAMP(expr), TIMESTAMP(expr1,expr2)\n\nWith a single argument, this function returns the date or datetime\nexpression expr as a datetime value. With two arguments, it adds the\ntime expression expr2 to the date or datetime expression expr1 and\nreturns the result as a datetime value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMP(\'2003-12-31\');\n        -> \'2003-12-31 00:00:00\'\nmysql> SELECT TIMESTAMP(\'2003-12-31 12:00:00\',\'12:00:00\');\n        -> \'2004-01-01 00:00:00\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (432,40,'DROP DATABASE','Syntax:\nDROP {DATABASE | SCHEMA} [IF EXISTS] db_name\n\nDROP DATABASE drops all tables in the database and deletes the\ndatabase. Be very careful with this statement! To use DROP DATABASE,\nyou need the DROP privilege on the database. DROP SCHEMA is a synonym\nfor DROP DATABASE.\n\n*Important*: When a database is dropped, user privileges on the\ndatabase are not automatically dropped. See [HELP GRANT].\n\nIF EXISTS is used to prevent an error from occurring if the database\ndoes not exist.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-database.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-database.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (433,27,'SHOW GRANTS','Syntax:\nSHOW GRANTS [FOR user]\n\nThis statement displays the GRANT statement or statements that must be\nissued to duplicate the privileges that are granted to a MySQL user\naccount. SHOW GRANTS requires the SELECT privilege for the mysql\ndatabase, except to see the privileges for the current user.\n\nFor output that includes an IDENTIFIED BY PASSWORD clause displaying an\naccount password hash value, the SUPER privilege is required to see the\nactual hash value. Otherwise, the value displays as <secret>.\n\nTo name the account, use the same format as for the GRANT statement;\nfor example, \'jeffrey\'@\'localhost\'. If you specify only the user name\npart of the account name, a host name part of \'%\' is used. For\nadditional information about specifying account names, see [HELP\nGRANT].\n\nmysql> SHOW GRANTS FOR \'root\'@\'localhost\';\n+---------------------------------------------------------------------+\n| Grants for root@localhost                                           |\n+---------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION |\n+---------------------------------------------------------------------+\n\nTo display the privileges granted to the account that you are using to\nconnect to the server, you can use any of the following statements:\n\nSHOW GRANTS;\nSHOW GRANTS FOR CURRENT_USER;\nSHOW GRANTS FOR CURRENT_USER();\n\nIf SHOW GRANTS FOR CURRENT_USER (or any of the equivalent syntaxes) is\nused in DEFINER context, such as within a stored procedure that is\ndefined with SQL SECURITY DEFINER), the grants displayed are those of\nthe definer and not the invoker.\n\nSHOW GRANTS displays only the privileges granted explicitly to the\nnamed account. Other privileges that might be available to the account\nare not displayed. For example, if an anonymous account exists, the\nnamed account might be able to use its privileges, but SHOW GRANTS will\nnot display them.\n\nAs of MySQL 5.7.6, SHOW GRANTS output does not include IDENTIFIED BY\nPASSWORD clauses. Use the SHOW CREATE USER statement instead. See [HELP\nSHOW CREATE USER].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-grants.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-grants.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (434,7,'JSON_CONTAINS_PATH','JSON_CONTAINS_PATH(json_doc, one_or_all, path[, path] ...)\n\nReturns 0 or 1 to indicate whether a JSON document contains data at a\ngiven path or paths. Returns NULL if any argument is NULL. An error\noccurs if the json_doc argument is not a valid JSON document, any path\nargument is not a valid path expression, or one_or_all is not \'one\' or\n\'all\'.\n\nTo check for a specific value at a path, use JSON_CONTAINS() instead.\n\nThe return value is 0 if no specified path exists within the document.\nOtherwise, the return value depends on the one_or_all argument:\n\no \'one\': 1 if at least one path exists within the document, 0\n  otherwise.\n\no \'all\': 1 if all paths exist within the document, 0 otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html\n\n','mysql> SET @j = \'{"a": 1, "b": 2, "c": {"d": 4}}\';\nmysql> SELECT JSON_CONTAINS_PATH(@j, \'one\', \'$.a\', \'$.e\');\n+---------------------------------------------+\n| JSON_CONTAINS_PATH(@j, \'one\', \'$.a\', \'$.e\') |\n+---------------------------------------------+\n|                                           1 |\n+---------------------------------------------+\nmysql> SELECT JSON_CONTAINS_PATH(@j, \'all\', \'$.a\', \'$.e\');\n+---------------------------------------------+\n| JSON_CONTAINS_PATH(@j, \'all\', \'$.a\', \'$.e\') |\n+---------------------------------------------+\n|                                           0 |\n+---------------------------------------------+\nmysql> SELECT JSON_CONTAINS_PATH(@j, \'one\', \'$.c.d\');\n+----------------------------------------+\n| JSON_CONTAINS_PATH(@j, \'one\', \'$.c.d\') |\n+----------------------------------------+\n|                                      1 |\n+----------------------------------------+\nmysql> SELECT JSON_CONTAINS_PATH(@j, \'one\', \'$.a.d\');\n+----------------------------------------+\n| JSON_CONTAINS_PATH(@j, \'one\', \'$.a.d\') |\n+----------------------------------------+\n|                                      0 |\n+----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (435,33,'ST_MPOINTFROMWKB','ST_MPointFromWKB(wkb[,srid]), ST_MultiPointFromWKB(wkb[,srid])\n\nConstructs a MultiPoint value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (436,3,'CRC32','Syntax:\nCRC32(expr)\n\nComputes a cyclic redundancy check value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is\nexpected to be a string and (if possible) is treated as one if it is\nnot.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT CRC32(\'MySQL\');\n        -> 3259397556\nmysql> SELECT CRC32(\'mysql\');\n        -> 2501908538\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (437,13,'STARTPOINT','StartPoint(ls)\n\nST_StartPoint() and StartPoint() are synonyms. For more information,\nsee the description of ST_StartPoint().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (438,24,'DECLARE VARIABLE','Syntax:\nDECLARE var_name [, var_name] ... type [DEFAULT value]\n\nThis statement declares local variables within stored programs. To\nprovide a default value for a variable, include a DEFAULT clause. The\nvalue can be specified as an expression; it need not be a constant. If\nthe DEFAULT clause is missing, the initial value is NULL.\n\nLocal variables are treated like stored routine parameters with respect\nto data type and overflow checking. See [HELP CREATE PROCEDURE].\n\nVariable declarations must appear before cursor or handler\ndeclarations.\n\nLocal variable names are not case sensitive. Permissible characters and\nquoting rules are the same as for other identifiers, as described in\nhttp://dev.mysql.com/doc/refman/5.7/en/identifiers.html.\n\nThe scope of a local variable is the BEGIN ... END block within which\nit is declared. The variable can be referred to in blocks nested within\nthe declaring block, except those blocks that declare a variable with\nthe same name.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/declare-local-variable.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/declare-local-variable.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (439,4,'MPOLYFROMTEXT','MPolyFromText(wkt[,srid]), MultiPolygonFromText(wkt[,srid])\n\nST_MPolyFromText(), ST_MultiPolygonFromText(), MPolyFromText(), and\nMultiPolygonFromText() are synonyms. For more information, see the\ndescription of ST_MPolyFromText().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (440,20,'NOT BETWEEN','Syntax:\nexpr NOT BETWEEN min AND max\n\nThis is the same as NOT (expr BETWEEN min AND max).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (441,32,'YEARWEEK','Syntax:\nYEARWEEK(date), YEARWEEK(date,mode)\n\nReturns year and week for a date. The year in the result may be\ndifferent from the year in the date argument for the first and the last\nweek of the year.\n\nThe mode argument works exactly like the mode argument to WEEK(). For\nthe single-argument syntax, a mode value of 0 is used. Unlike WEEK(),\nthe value of default_week_format does not influence YEARWEEK().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT YEARWEEK(\'1987-01-01\');\n        -> 198652\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (442,16,'BIT_OR','Syntax:\nBIT_OR(expr)\n\nReturns the bitwise OR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (443,3,'LOG10','Syntax:\nLOG10(X)\n\nReturns the base-10 logarithm of X. If X is less than or equal to\n0.0E0, the function returns NULL and (as of MySQL 5.7.4) a warning\n"Invalid argument for logarithm" is reported.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT LOG10(2);\n        -> 0.30102999566398\nmysql> SELECT LOG10(100);\n        -> 2\nmysql> SELECT LOG10(-100);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (444,23,'DECIMAL','DECIMAL[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nA packed "exact" fixed-point number. M is the total number of digits\n(the precision) and D is the number of digits after the decimal point\n(the scale). The decimal point and (for negative numbers) the "-" sign\nare not counted in M. If D is 0, values have no decimal point or\nfractional part. The maximum number of digits (M) for DECIMAL is 65.\nThe maximum number of supported decimals (D) is 30. If D is omitted,\nthe default is 0. If M is omitted, the default is 10.\n\nUNSIGNED, if specified, disallows negative values.\n\nAll basic calculations (+, -, *, /) with DECIMAL columns are done with\na precision of 65 digits.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (445,40,'CREATE FUNCTION','The CREATE FUNCTION statement is used to create stored functions and\nuser-defined functions (UDFs):\n\no For information about creating stored functions, see [HELP CREATE\n  PROCEDURE].\n\no For information about creating user-defined functions, see [HELP\n  CREATE FUNCTION UDF].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-function.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-function.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (446,20,'<','Syntax:\n<\n\nLess than:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 2 < 2;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (447,12,'MD5','Syntax:\nMD5(str)\n\nCalculates an MD5 128-bit checksum for the string. The value is\nreturned as a string of 32 hex digits, or NULL if the argument was\nNULL. The return value can, for example, be used as a hash key. See the\nnotes at the beginning of this section about storing hash values\nefficiently.\n\nThe return value is a nonbinary string in the connection character set.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','mysql> SELECT MD5(\'testing\');\n        -> \'ae2b1fca515949e5d54fb22b8ed95575\'\n','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (448,32,'DAYOFMONTH','Syntax:\nDAYOFMONTH(date)\n\nReturns the day of the month for date, in the range 1 to 31, or 0 for\ndates such as \'0000-00-00\' or \'2008-00-00\' that have a zero day part.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFMONTH(\'2007-02-03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (449,32,'UNIX_TIMESTAMP','Syntax:\nUNIX_TIMESTAMP(), UNIX_TIMESTAMP(date)\n\nIf called with no argument, returns a Unix timestamp (seconds since\n\'1970-01-01 00:00:00\' UTC). The return value is an integer if no\nargument is given or the argument does not include a fractional seconds\npart, or DECIMAL if an argument is given that includes a fractional\nseconds part.\n\nIf UNIX_TIMESTAMP() is called with a date argument, it returns the\nvalue of the argument as seconds since \'1970-01-01 00:00:00\' UTC. date\nmay be a DATE string, a DATETIME string, a TIMESTAMP, or a number in\nthe format YYMMDD or YYYYMMDD, optionally including a fractional\nseconds part. The server interprets date as a value in the current time\nzone and converts it to an internal value in UTC. Clients can set their\ntime zone as described in\nhttp://dev.mysql.com/doc/refman/5.7/en/time-zone-support.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT UNIX_TIMESTAMP();\n        -> 1447431666\nmysql> SELECT UNIX_TIMESTAMP(\'2015-11-13 10:20:19\');\n        -> 1447431619\nmysql> SELECT UNIX_TIMESTAMP(\'2015-11-13 10:20:19.012\');\n        -> 1447431619.012\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (450,26,'ST_INTERSECTION','ST_Intersection(g1, g2)\n\nReturns a geometry that represents the point set intersection of the\ngeometry values g1 and g2.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html\n\n','mysql> SET @g1 = ST_GeomFromText(\'LineString(1 1, 3 3)\');\nmysql> SET @g2 = ST_GeomFromText(\'LineString(1 3, 3 1)\');\nmysql> SELECT ST_AsText(ST_Intersection(@g1, @g2));\n+--------------------------------------+\n| ST_AsText(ST_Intersection(@g1, @g2)) |\n+--------------------------------------+\n| POINT(2 2)                           |\n+--------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (451,10,'RENAME USER','Syntax:\nRENAME USER old_user TO new_user\n    [, old_user TO new_user] ...\n\nThe RENAME USER statement renames existing MySQL accounts. An error\noccurs for old accounts that do not exist or new accounts that already\nexist.\n\nTo use RENAME USER, you must have the global CREATE USER privilege or\nthe UPDATE privilege for the mysql database. When the read_only system\nvariable is enabled, RENAME USER additionally requires the SUPER\nprivilege.\n\nEach account name uses the format described in\nhttp://dev.mysql.com/doc/refman/5.7/en/account-names.html. For example:\n\nRENAME USER \'jeffrey\'@\'localhost\' TO \'jeff\'@\'127.0.0.1\';\n\nIf you specify only the user name part of the account name, a host name\npart of \'%\' is used.\n\nRENAME USER causes the privileges held by the old user to be those held\nby the new user. However, RENAME USER does not automatically drop or\ninvalidate databases or objects within them that the old user created.\nThis includes stored programs or views for which the DEFINER attribute\nnames the old user. Attempts to access such objects may produce an\nerror if they execute in definer security context. (For information\nabout security context, see\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-programs-security.html.)\n\nThe privilege changes take effect as indicated in\nhttp://dev.mysql.com/doc/refman/5.7/en/privilege-changes.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/rename-user.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/rename-user.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (452,13,'NUMPOINTS','NumPoints(ls)\n\nST_NumPoints() and NumPoints() are synonyms. For more information, see\nthe description of ST_NumPoints().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (453,40,'ALTER LOGFILE GROUP','Syntax:\nALTER LOGFILE GROUP logfile_group\n    ADD UNDOFILE \'file_name\'\n    [INITIAL_SIZE [=] size]\n    [WAIT]\n    ENGINE [=] engine_name\n\nThis statement adds an UNDO file named \'file_name\' to an existing log\nfile group logfile_group. An ALTER LOGFILE GROUP statement has one and\nonly one ADD UNDOFILE clause. No DROP UNDOFILE clause is currently\nsupported.\n\n*Note*: All MySQL Cluster Disk Data objects share the same namespace.\nThis means that each Disk Data object must be uniquely named (and not\nmerely each Disk Data object of a given type). For example, you cannot\nhave a tablespace and an undo log file with the same name, or an undo\nlog file and a data file with the same name.\n\nThe optional INITIAL_SIZE parameter sets the UNDO file\'s initial size\nin bytes; if not specified, the initial size defaults to 134217728 (128\nMB). You may optionally follow size with a one-letter abbreviation for\nan order of magnitude, similar to those used in my.cnf. Generally, this\nis one of the letters M (megabytes) or G (gigabytes). (Bug #13116514,\nBug #16104705, Bug #62858)\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is\n4294967296 (4 GB). (Bug #29186)\n\nThe minimum allowed value for INITIAL_SIZE is 1048576 (1 MB). (Bug\n#29574)\n\n*Note*: WAIT is parsed but otherwise ignored. This keyword currently\nhas no effect, and is intended for future expansion.\n\nThe ENGINE parameter (required) determines the storage engine which is\nused by this log file group, with engine_name being the name of the\nstorage engine. Currently, the only accepted values for engine_name are\n"NDBCLUSTER" and "NDB". The two values are equivalent.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-logfile-group.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/alter-logfile-group.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (454,32,'LOCALTIMESTAMP','Syntax:\nLOCALTIMESTAMP, LOCALTIMESTAMP([fsp])\n\nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (455,32,'ADDDATE','Syntax:\nADDDATE(date,INTERVAL expr unit), ADDDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, ADDDATE()\nis a synonym for DATE_ADD(). The related function SUBDATE() is a\nsynonym for DATE_SUB(). For information on the INTERVAL unit argument,\nsee the discussion for DATE_ADD().\n\nmysql> SELECT DATE_ADD(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2008-02-02\'\nmysql> SELECT ADDDATE(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2008-02-02\'\n\nWhen invoked with the days form of the second argument, MySQL treats it\nas an integer number of days to be added to expr.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT ADDDATE(\'2008-01-02\', 31);\n        -> \'2008-02-02\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (456,7,'CREATE_DIGEST','Syntax:\nCREATE_DIGEST(digest_type, str)\n\nCreates a digest from the given string using the given digest type, and\nreturns the digest as a binary string. If digest generation fails, the\nresult is NULL.\n\nSupported digest_type values: \'SHA224\', \'SHA256\', \'SHA384\', \'SHA512\'\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html\n\n','SET @dig = CREATE_DIGEST(\'SHA512\', The quick brown fox\');\n','http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (457,7,'->','column->path\n\nIn MySQL 5.7.9 and later, the -> operator serves as an alias for the\nJSON_EXTRACT() function when used with two arguments, a column\nidentifier on the left and a JSON path on the right that is evaluated\nagainst the JSON document (the column value). You can use such\nexpressions in place of column identifiers wherever they occur in SQL\nstatements.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html\n\n','mysql> SELECT c, JSON_EXTRACT(c, "$.id"), g \n     > FROM jemp\n     > WHERE JSON_EXTRACT(c, "$.id") > 1 \n     > ORDER BY JSON_EXTRACT(c, "$.name");\n+-------------------------------+-----------+------+\n| c                             | c->"$.id" | g    |\n+-------------------------------+-----------+------+\n| {"id": "3", "name": "Barney"} | "3"       |    3 |\n| {"id": "4", "name": "Betty"}  | "4"       |    4 |\n| {"id": "2", "name": "Wilma"}  | "2"       |    2 |\n+-------------------------------+-----------+------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT c, c->"$.id", g \n     > FROM jemp\n     > WHERE c->"$.id" > 1 \n     > ORDER BY c->"$.name";\n+-------------------------------+-----------+------+\n| c                             | c->"$.id" | g    |\n+-------------------------------+-----------+------+\n| {"id": "3", "name": "Barney"} | "3"       |    3 |\n| {"id": "4", "name": "Betty"}  | "4"       |    4 |\n| {"id": "2", "name": "Wilma"}  | "2"       |    2 |\n+-------------------------------+-----------+------+\n3 rows in set (0.00 sec)\n\nmysql> ALTER TABLE jemp ADD COLUMN n INT;\nQuery OK, 0 rows affected (0.68 sec)\nRecords: 0  Duplicates: 0  Warnings: 0\n\nmysql> UPDATE jemp SET n=1 WHERE c->"$.id" = "4";\nQuery OK, 1 row affected (0.04 sec)\nRows matched: 1  Changed: 1  Warnings: 0\n\nmysql> SELECT c, c->"$.id", g, n \n     > FROM jemp\n     > WHERE JSON_EXTRACT(c, "$.id") > 1 \n     > ORDER BY c->"$.name";\n+-------------------------------+-----------+------+------+\n| c                             | c->"$.id" | g    | n    |\n+-------------------------------+-----------+------+------+\n| {"id": "3", "name": "Barney"} | "3"       |    3 | NULL |\n| {"id": "4", "name": "Betty"}  | "4"       |    4 |    1 |\n| {"id": "2", "name": "Wilma"}  | "2"       |    2 | NULL |\n+-------------------------------+-----------+------+------+\n3 rows in set (0.00 sec)\n\nmysql> DELETE FROM jemp WHERE c->"$.id" = "4";\nQuery OK, 1 row affected (0.04 sec)\n\nmysql> SELECT c, c->"$.id", g, n \n     > FROM jemp\n     > WHERE JSON_EXTRACT(c, "$.id") > 1 \n     > ORDER BY c->"$.name";\n+-------------------------------+-----------+------+------+\n| c                             | c->"$.id" | g    | n    |\n+-------------------------------+-----------+------+------+\n| {"id": "3", "name": "Barney"} | "3"       |    3 | NULL |\n| {"id": "2", "name": "Wilma"}  | "2"       |    2 | NULL |\n+-------------------------------+-----------+------+------+\n2 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (458,40,'ALTER FUNCTION','Syntax:\nALTER FUNCTION func_name [characteristic ...]\n\ncharacteristic:\n    COMMENT \'string\'\n  | LANGUAGE SQL\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n\nThis statement can be used to change the characteristics of a stored\nfunction. More than one change may be specified in an ALTER FUNCTION\nstatement. However, you cannot change the parameters or body of a\nstored function using this statement; to make such changes, you must\ndrop and re-create the function using DROP FUNCTION and CREATE\nFUNCTION.\n\nYou must have the ALTER ROUTINE privilege for the function. (That\nprivilege is granted automatically to the function creator.) If binary\nlogging is enabled, the ALTER FUNCTION statement might also require the\nSUPER privilege, as described in\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-programs-logging.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-function.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/alter-function.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (459,8,'DEALLOCATE PREPARE','Syntax:\n{DEALLOCATE | DROP} PREPARE stmt_name\n\nTo deallocate a prepared statement produced with PREPARE, use a\nDEALLOCATE PREPARE statement that refers to the prepared statement\nname. Attempting to execute a prepared statement after deallocating it\nresults in an error. If too many prepared statements are created and\nnot deallocated by either the DEALLOCATE PREPARE statement or the end\nof the session, you might encounter the upper limit enforced by the\nmax_prepared_stmt_count system variable.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/deallocate-prepare.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/deallocate-prepare.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (460,14,'IS_FREE_LOCK','Syntax:\nIS_FREE_LOCK(str)\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock\nis in use, and NULL if an error occurs (such as an incorrect argument).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (461,26,'CONVEXHULL','ConvexHull(g)\n\nST_ConvexHull() and ConvexHull() are synonyms. For more information,\nsee the description of ST_ConvexHull().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (462,31,'TOUCHES','Touches(g1,g2)\n\nST_Touches() and Touches() are synonyms. For more information, see the\ndescription of ST_Touches().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (463,23,'AUTO_INCREMENT','The AUTO_INCREMENT attribute can be used to generate a unique identity\nfor new rows:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/example-auto-increment.html\n\n','CREATE TABLE animals (\n     id MEDIUMINT NOT NULL AUTO_INCREMENT,\n     name CHAR(30) NOT NULL,\n     PRIMARY KEY (id)\n);\n\nINSERT INTO animals (name) VALUES\n    (\'dog\'),(\'cat\'),(\'penguin\'),\n    (\'lax\'),(\'whale\'),(\'ostrich\');\n\nSELECT * FROM animals;\n','http://dev.mysql.com/doc/refman/5.7/en/example-auto-increment.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (464,12,'UNCOMPRESS','Syntax:\nUNCOMPRESS(string_to_uncompress)\n\nUncompresses a string compressed by the COMPRESS() function. If the\nargument is not a compressed value, the result is NULL. This function\nrequires MySQL to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','mysql> SELECT UNCOMPRESS(COMPRESS(\'any string\'));\n        -> \'any string\'\nmysql> SELECT UNCOMPRESS(\'any string\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (465,4,'GEOMCOLLFROMTEXT','GeomCollFromText(wkt[,srid]), GeometryCollectionFromText(wkt[,srid])\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(),\nST_GeomCollFromTxt(), GeomCollFromText(), and\nGeometryCollectionFromText() are synonyms. For more information, see\nthe description of ST_GeomCollFromText().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (466,2,'ST_INTERIORRINGN','ST_InteriorRingN(poly,N)\n\nReturns the N-th interior ring for the Polygon value poly as a\nLineString. Rings are numbered beginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT ST_AsText(ST_InteriorRingN(ST_GeomFromText(@poly),1));\n+-------------------------------------------------------+\n| ST_AsText(ST_InteriorRingN(ST_GeomFromText(@poly),1)) |\n+-------------------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)                       |\n+-------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (467,17,'LAST_INSERT_ID','Syntax:\nLAST_INSERT_ID(), LAST_INSERT_ID(expr)\n\nWith no argument, LAST_INSERT_ID() returns a BIGINT UNSIGNED (64-bit)\nvalue representing the first automatically generated value successfully\ninserted for an AUTO_INCREMENT column as a result of the most recently\nexecuted INSERT statement. The value of LAST_INSERT_ID() remains\nunchanged if no rows are successfully inserted.\n\nWith an argument, LAST_INSERT_ID() returns an unsigned integer.\n\nFor example, after inserting a row that generates an AUTO_INCREMENT\nvalue, you can get the value like this:\n\nmysql> SELECT LAST_INSERT_ID();\n        -> 195\n\nThe currently executing statement does not affect the value of\nLAST_INSERT_ID(). Suppose that you generate an AUTO_INCREMENT value\nwith one statement, and then refer to LAST_INSERT_ID() in a\nmultiple-row INSERT statement that inserts rows into a table with its\nown AUTO_INCREMENT column. The value of LAST_INSERT_ID() will remain\nstable in the second statement; its value for the second and later rows\nis not affected by the earlier row insertions. (However, if you mix\nreferences to LAST_INSERT_ID() and LAST_INSERT_ID(expr), the effect is\nundefined.)\n\nIf the previous statement returned an error, the value of\nLAST_INSERT_ID() is undefined. For transactional tables, if the\nstatement is rolled back due to an error, the value of LAST_INSERT_ID()\nis left undefined. For manual ROLLBACK, the value of LAST_INSERT_ID()\nis not restored to that before the transaction; it remains as it was at\nthe point of the ROLLBACK.\n\nPrior to MySQL 5.7.3, this function was not replicated correctly if\nreplication filtering rules were in use. (Bug #17234370, Bug #69861)\n\nWithin the body of a stored routine (procedure or function) or a\ntrigger, the value of LAST_INSERT_ID() changes the same way as for\nstatements executed outside the body of these kinds of objects. The\neffect of a stored routine or trigger upon the value of\nLAST_INSERT_ID() that is seen by following statements depends on the\nkind of routine:\n\no If a stored procedure executes statements that change the value of\n  LAST_INSERT_ID(), the changed value is seen by statements that follow\n  the procedure call.\n\no For stored functions and triggers that change the value, the value is\n  restored when the function or trigger ends, so following statements\n  will not see a changed value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (468,3,'FLOOR','Syntax:\nFLOOR(X)\n\nReturns the largest integer value not greater than X.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT FLOOR(1.23), FLOOR(-1.23);\n        -> 1, -2\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (469,3,'COS','Syntax:\nCOS(X)\n\nReturns the cosine of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT COS(PI());\n        -> -1\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (470,16,'STD','Syntax:\nSTD(expr)\n\nReturns the population standard deviation of expr. This is an extension\nto standard SQL. The standard SQL function STDDEV_POP() can be used\ninstead.\n\nSTD() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (471,32,'DATE FUNCTION','Syntax:\nDATE(expr)\n\nExtracts the date part of the date or datetime expression expr.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT DATE(\'2003-12-31 01:02:03\');\n        -> \'2003-12-31\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (472,3,'TAN','Syntax:\nTAN(X)\n\nReturns the tangent of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT TAN(PI());\n        -> -1.2246063538224e-16\nmysql> SELECT TAN(PI()+1);\n        -> 1.5574077246549\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (473,32,'WEEKOFYEAR','Syntax:\nWEEKOFYEAR(date)\n\nReturns the calendar week of the date as a number in the range from 1\nto 53. WEEKOFYEAR() is a compatibility function that is equivalent to\nWEEK(date,3).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT WEEKOFYEAR(\'2008-02-20\');\n        -> 8\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (474,26,'ST_CONVEXHULL','ST_ConvexHull(g)\n\nReturns a geometry that represents the convex hull of the geometry\nvalue g.\n\nThis function computes a geometry\'s convex hull by first checking\nwhether its vertex points are colinear. The function returns a linear\nhull if so, a polygon hull otherwise. This function processes geometry\ncollections by extracting all vertex points of all components of the\ncollection, creating a MultiPoint value from them, and computing its\nconvex hull. If the argument is an empty geometry collection, the\nreturn value is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html\n\n','mysql> SET @g = \'MULTIPOINT(5 0,25 0,15 10,15 25)\';\nmysql> SELECT ST_AsText(ST_ConvexHull(ST_GeomFromText(@g)));\n+-----------------------------------------------+\n| ST_AsText(ST_ConvexHull(ST_GeomFromText(@g))) |\n+-----------------------------------------------+\n| POLYGON((5 0,25 0,15 25,5 0))                 |\n+-----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (475,32,'SUBTIME','Syntax:\nSUBTIME(expr1,expr2)\n\nSUBTIME() returns expr1 − expr2 expressed as a value in the same\nformat as expr1. expr1 is a time or datetime expression, and expr2 is a\ntime expression.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT SUBTIME(\'2007-12-31 23:59:59.999999\',\'1 1:1:1.000002\');\n        -> \'2007-12-30 22:58:58.999997\'\nmysql> SELECT SUBTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'-00:59:59.999999\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (476,3,'LOG2','Syntax:\nLOG2(X)\n\nReturns the base-2 logarithm of X. If X is less than or equal to 0.0E0,\nthe function returns NULL and (as of MySQL 5.7.4) a warning "Invalid\nargument for logarithm" is reported.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT LOG2(65536);\n        -> 16\nmysql> SELECT LOG2(-100);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (477,12,'UNCOMPRESSED_LENGTH','Syntax:\nUNCOMPRESSED_LENGTH(compressed_string)\n\nReturns the length that the compressed string had before being\ncompressed.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','mysql> SELECT UNCOMPRESSED_LENGTH(COMPRESS(REPEAT(\'a\',30)));\n        -> 30\n','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (478,3,'POW','Syntax:\nPOW(X,Y)\n\nReturns the value of X raised to the power of Y.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT POW(2,2);\n        -> 4\nmysql> SELECT POW(2,-2);\n        -> 0.25\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (479,40,'DROP TABLE','Syntax:\nDROP [TEMPORARY] TABLE [IF EXISTS]\n    tbl_name [, tbl_name] ...\n    [RESTRICT | CASCADE]\n\nDROP TABLE removes one or more tables. You must have the DROP privilege\nfor each table. All table data and the table definition are removed, so\nbe careful with this statement! If any of the tables named in the\nargument list do not exist, MySQL returns an error indicating by name\nwhich nonexisting tables it was unable to drop, but it also drops all\nof the tables in the list that do exist.\n\n*Important*: When a table is dropped, user privileges on the table are\nnot automatically dropped. See [HELP GRANT].\n\nFor a partitioned table, DROP TABLE permanently removes the table\ndefinition, all of its partitions, and all of the data which was stored\nin those partitions. It also removes partition definitions associated\nwith the dropped table.\n\n*Note*: Prior to MySQL 5.7.6, DROP TABLE removes partition definitions\n(.par) files associated with the dropped table. As of MySQL 5.7.6,\npartition definition (.par) files are no longer created. Instead,\npartition definitions are stored in the internal data dictionary.\n\nUse IF EXISTS to prevent an error from occurring for tables that do not\nexist. A NOTE is generated for each nonexistent table when using IF\nEXISTS. See [HELP SHOW WARNINGS].\n\nRESTRICT and CASCADE are permitted to make porting easier. In MySQL\n5.7, they do nothing.\n\n*Note*: DROP TABLE automatically commits the current active\ntransaction, unless you use the TEMPORARY keyword.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-table.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (480,32,'NOW','Syntax:\nNOW([fsp])\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context. The value is expressed in the current time\nzone.\n\nIf the fsp argument is given to specify a fractional seconds precision\nfrom 0 to 6, the return value includes a fractional seconds part of\nthat many digits.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT NOW();\n        -> \'2007-12-15 23:50:26\'\nmysql> SELECT NOW() + 0;\n        -> 20071215235026.000000\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (481,27,'SHOW ENGINES','Syntax:\nSHOW [STORAGE] ENGINES\n\nSHOW ENGINES displays status information about the server\'s storage\nengines. This is particularly useful for checking whether a storage\nengine is supported, or to see what the default engine is. This\ninformation can also be obtained from the INFORMATION_SCHEMA ENGINES\ntable. See http://dev.mysql.com/doc/refman/5.7/en/engines-table.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-engines.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-engines.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (482,4,'ST_POINTFROMTEXT','ST_PointFromText(wkt[,srid])\n\nConstructs a Point value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (483,13,'ST_ENDPOINT','ST_EndPoint(ls)\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_AsText(ST_EndPoint(ST_GeomFromText(@ls)));\n+----------------------------------------------+\n| ST_AsText(ST_EndPoint(ST_GeomFromText(@ls))) |\n+----------------------------------------------+\n| POINT(3 3)                                   |\n+----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (484,14,'IS_IPV6','Syntax:\nIS_IPV6(expr)\n\nReturns 1 if the argument is a valid IPv6 address specified as a\nstring, 0 otherwise. This function does not consider IPv4 addresses to\nbe valid IPv6 addresses.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV6(\'10.0.5.9\'), IS_IPV6(\'::1\');\n        -> 0, 1\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (485,23,'LONGBLOB','LONGBLOB\n\nA BLOB column with a maximum length of 4,294,967,295 or 4GB (232 − 1)\nbytes. The effective maximum length of LONGBLOB columns depends on the\nconfigured maximum packet size in the client/server protocol and\navailable memory. Each LONGBLOB value is stored using a 4-byte length\nprefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (486,31,'ST_OVERLAPS','ST_Overlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially overlaps g2. The term\nspatially overlaps is used if two geometries intersect and their\nintersection results in a geometry of the same dimension but not equal\nto either of the given geometries.\n\nAs of MySQL 5.7.5, this function returns 0 if called with an\ninapplicable geometry argument type combination. For example, it\nreturns 0 if called with geometries of different dimensions or any\nargument is a Point.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (487,23,'YEAR DATA TYPE','YEAR[(4)]\n\nA year in four-digit format. MySQL displays YEAR values in YYYY format,\nbut permits assignment of values to YEAR columns using either strings\nor numbers. Values display as 1901 to 2155, and 0000.\n\n*Note*: The YEAR(2) data type is deprecated and support for it is\nremoved in MySQL 5.7.5. To convert YEAR(2) columns to YEAR(4), see\nhttp://dev.mysql.com/doc/refman/5.7/en/migrating-to-year4.html.\n\nFor additional information about YEAR display format and interpretation\nof input values, see http://dev.mysql.com/doc/refman/5.7/en/year.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (488,16,'SUM','Syntax:\nSUM([DISTINCT] expr)\n\nReturns the sum of expr. If the return set has no rows, SUM() returns\nNULL. The DISTINCT keyword can be used to sum only the distinct values\nof expr.\n\nSUM() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (489,7,'JSON_SET','JSON_SET(json_doc, path, val[, path, val] ...)\n\nInserts or updates data in a JSON document and returns the result.\nReturns NULL if any argument is NULL or path, if given, does not locate\nan object. An error occurs if the json_doc argument is not a valid JSON\ndocument or the path argument is not a valid path expression or\ncontains a * or ** wildcard.\n\nThe path/value pairs are evaluated left to right. The document produced\nby evaluating one pair becomes the new value against which the next\npair is evaluated.\n\nA path/value pair for an existing path in the document overwrites the\nexisting document value with the new value. A path/value pair for a\nnonexisting path in the document adds the value to the document if the\npath identifies one of these types of values:\n\no A member not present in an existing object. The member is added to\n  the object and associated with the new value.\n\no A position past the end of an existing array. The array is extended\n  with the new value. If the existing value is not an array, it is\n  autowrapped as an array, then extended with the new value.\n\nOtherwise, a path/value pair for a nonexisting path in the document is\nignored and has no effect.\n\nThe JSON_SET(), JSON_INSERT(), and JSON_REPLACE() functions are\nrelated:\n\no JSON_SET() replaces existing values and adds nonexisting values.\n\no JSON_INSERT() inserts values without replacing existing values.\n\no JSON_REPLACE() replaces only existing values.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html\n\n','mysql> SET @j = \'{ "a": 1, "b": [2, 3]}\';\nmysql> SELECT JSON_SET(@j, \'$.a\', 10, \'$.c\', \'[true, false]\');\n+-------------------------------------------------+\n| JSON_SET(@j, \'$.a\', 10, \'$.c\', \'[true, false]\') |\n+-------------------------------------------------+\n| {"a": 10, "b": [2, 3], "c": "[true, false]"}    |\n+-------------------------------------------------+\nmysql> SELECT JSON_INSERT(@j, \'$.a\', 10, \'$.c\', \'[true, false]\');\n+----------------------------------------------------+\n| JSON_INSERT(@j, \'$.a\', 10, \'$.c\', \'[true, false]\') |\n+----------------------------------------------------+\n| {"a": 1, "b": [2, 3], "c": "[true, false]"}        |\n+----------------------------------------------------+\nmysql> SELECT JSON_REPLACE(@j, \'$.a\', 10, \'$.c\', \'[true, false]\');\n+-----------------------------------------------------+\n| JSON_REPLACE(@j, \'$.a\', 10, \'$.c\', \'[true, false]\') |\n+-----------------------------------------------------+\n| {"a": 10, "b": [2, 3]}                              |\n+-----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (490,38,'REPEAT FUNCTION','Syntax:\nREPEAT(str,count)\n\nReturns a string consisting of the string str repeated count times. If\ncount is less than 1, returns an empty string. Returns NULL if str or\ncount are NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT REPEAT(\'MySQL\', 3);\n        -> \'MySQLMySQLMySQL\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (491,38,'SOUNDEX','Syntax:\nSOUNDEX(str)\n\nReturns a soundex string from str. Two strings that sound almost the\nsame should have identical soundex strings. A standard soundex string\nis four characters long, but the SOUNDEX() function returns an\narbitrarily long string. You can use SUBSTRING() on the result to get a\nstandard soundex string. All nonalphabetic characters in str are\nignored. All international alphabetic characters outside the A-Z range\nare treated as vowels.\n\n*Important*: When using SOUNDEX(), you should be aware of the following\nlimitations:\n\no This function, as currently implemented, is intended to work well\n  with strings that are in the English language only. Strings in other\n  languages may not produce reliable results.\n\no This function is not guaranteed to provide consistent results with\n  strings that use multibyte character sets, including utf-8.\n\n  We hope to remove these limitations in a future release. See Bug\n  #22638 for more information.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT SOUNDEX(\'Hello\');\n        -> \'H400\'\nmysql> SELECT SOUNDEX(\'Quadratically\');\n        -> \'Q36324\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (492,7,'MBRTOUCHES','MBRTouches(g1,g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\nthe two geometries g1 and g2 touch. Two geometries spatially touch if\nthe interiors of the geometries do not intersect, but the boundary of\none of the geometries intersects either the boundary or the interior of\nthe other.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (493,40,'DROP EVENT','Syntax:\nDROP EVENT [IF EXISTS] event_name\n\nThis statement drops the event named event_name. The event immediately\nceases being active, and is deleted completely from the server.\n\nIf the event does not exist, the error ERROR 1517 (HY000): Unknown\nevent \'event_name\' results. You can override this and cause the\nstatement to generate a warning for nonexistent events instead using IF\nEXISTS.\n\nThis statement requires the EVENT privilege for the schema to which the\nevent to be dropped belongs.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-event.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-event.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (494,23,'VARBINARY','VARBINARY(M)\n\nThe VARBINARY type is similar to the VARCHAR type, but stores binary\nbyte strings rather than nonbinary character strings. M represents the\nmaximum column length in bytes.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (495,27,'LOAD INDEX','Syntax:\nLOAD INDEX INTO CACHE\n  tbl_index_list [, tbl_index_list] ...\n\ntbl_index_list:\n  tbl_name\n    [PARTITION (partition_list | ALL)]\n    [[INDEX|KEY] (index_name[, index_name] ...)]\n    [IGNORE LEAVES]\n\npartition_list:\n    partition_name[, partition_name][, ...]\n\nThe LOAD INDEX INTO CACHE statement preloads a table index into the key\ncache to which it has been assigned by an explicit CACHE INDEX\nstatement, or into the default key cache otherwise.\n\nLOAD INDEX INTO CACHE is used only for MyISAM tables. In MySQL 5.7, it\nis also supported for partitioned MyISAM tables; in addition, indexes\non partitioned tables can be preloaded for one, several, or all\npartitions.\n\nThe IGNORE LEAVES modifier causes only blocks for the nonleaf nodes of\nthe index to be preloaded.\n\nIGNORE LEAVES is also supported for partitioned MyISAM tables.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/load-index.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/load-index.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (496,28,'UNION','Syntax:\nSELECT ...\nUNION [ALL | DISTINCT] SELECT ...\n[UNION [ALL | DISTINCT] SELECT ...]\n\nUNION is used to combine the result from multiple SELECT statements\ninto a single result set.\n\nThe column names from the first SELECT statement are used as the column\nnames for the results returned. Selected columns listed in\ncorresponding positions of each SELECT statement should have the same\ndata type. (For example, the first column selected by the first\nstatement should have the same type as the first column selected by the\nother statements.)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/union.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/union.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (497,32,'TO_DAYS','Syntax:\nTO_DAYS(date)\n\nGiven a date date, returns a day number (the number of days since year\n0).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT TO_DAYS(950501);\n        -> 728779\nmysql> SELECT TO_DAYS(\'2007-10-07\');\n        -> 733321\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (498,27,'SHOW INDEX','Syntax:\nSHOW {INDEX | INDEXES | KEYS}\n    {FROM | IN} tbl_name\n    [{FROM | IN} db_name]\n    [WHERE expr]\n\nSHOW INDEX returns table index information. The format resembles that\nof the SQLStatistics call in ODBC. This statement requires some\nprivilege for any column in the table.\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM\ndb_name syntax. These two statements are equivalent:\n\nSHOW INDEX FROM mytable FROM mydb;\nSHOW INDEX FROM mydb.mytable;\n\nThe WHERE clause can be given to select rows using more general\nconditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nYou can also list a table\'s indexes with the mysqlshow -k db_name\ntbl_name command.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-index.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-index.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (499,27,'SHOW CREATE DATABASE','Syntax:\nSHOW CREATE {DATABASE | SCHEMA} [IF NOT EXISTS] db_name\n\nShows the CREATE DATABASE statement that creates the named database. If\nthe SHOW statement includes an IF NOT EXISTS clause, the output too\nincludes such a clause. SHOW CREATE SCHEMA is a synonym for SHOW CREATE\nDATABASE.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-create-database.html\n\n','mysql> SHOW CREATE DATABASE test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET latin1 */\n\nmysql> SHOW CREATE SCHEMA test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET latin1 */\n','http://dev.mysql.com/doc/refman/5.7/en/show-create-database.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (500,15,'!','Syntax:\nNOT, !\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnonzero, and NOT NULL returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/logical-operators.html\n\n','mysql> SELECT NOT 10;\n        -> 0\nmysql> SELECT NOT 0;\n        -> 1\nmysql> SELECT NOT NULL;\n        -> NULL\nmysql> SELECT ! (1+1);\n        -> 0\nmysql> SELECT ! 1+1;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/logical-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (501,24,'DECLARE HANDLER','Syntax:\nDECLARE handler_action HANDLER\n    FOR condition_value [, condition_value] ...\n    statement\n\nhandler_action:\n    CONTINUE\n  | EXIT\n  | UNDO\n\ncondition_value:\n    mysql_error_code\n  | SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n  | SQLWARNING\n  | NOT FOUND\n  | SQLEXCEPTION\n\nThe DECLARE ... HANDLER statement specifies a handler that deals with\none or more conditions. If one of these conditions occurs, the\nspecified statement executes. statement can be a simple statement such\nas SET var_name = value, or a compound statement written using BEGIN\nand END (see [HELP BEGIN END]).\n\nHandler declarations must appear after variable or condition\ndeclarations.\n\nThe handler_action value indicates what action the handler takes after\nexecution of the handler statement:\n\no CONTINUE: Execution of the current program continues.\n\no EXIT: Execution terminates for the BEGIN ... END compound statement\n  in which the handler is declared. This is true even if the condition\n  occurs in an inner block.\n\no UNDO: Not supported.\n\nThe condition_value for DECLARE ... HANDLER indicates the specific\ncondition or class of conditions that activates the handler. It can\ntake the following forms:\n\no mysql_error_code: An integer literal indicating a MySQL error code,\n  such as 1051 to specify "unknown table":\n\nDECLARE CONTINUE HANDLER FOR 1051\n  BEGIN\n    -- body of handler\n  END;\n\n  Do not use MySQL error code 0 because that indicates success rather\n  than an error condition. For a list of MySQL error codes, see\n  http://dev.mysql.com/doc/refman/5.7/en/error-messages-server.html.\n\no SQLSTATE [VALUE] sqlstate_value: A 5-character string literal\n  indicating an SQLSTATE value, such as \'42S01\' to specify "unknown\n  table":\n\nDECLARE CONTINUE HANDLER FOR SQLSTATE \'42S02\'\n  BEGIN\n    -- body of handler\n  END;\n\n  Do not use SQLSTATE values that begin with \'00\' because those\n  indicate success rather than an error condition. For a list of\n  SQLSTATE values, see\n  http://dev.mysql.com/doc/refman/5.7/en/error-messages-server.html.\n\no condition_name: A condition name previously specified with DECLARE\n  ... CONDITION. A condition name can be associated with a MySQL error\n  code or SQLSTATE value. See [HELP DECLARE CONDITION].\n\no SQLWARNING: Shorthand for the class of SQLSTATE values that begin\n  with \'01\'.\n\nDECLARE CONTINUE HANDLER FOR SQLWARNING\n  BEGIN\n    -- body of handler\n  END;\n\no NOT FOUND: Shorthand for the class of SQLSTATE values that begin with\n  \'02\'. This is relevant within the context of cursors and is used to\n  control what happens when a cursor reaches the end of a data set. If\n  no more rows are available, a No Data condition occurs with SQLSTATE\n  value \'02000\'. To detect this condition, you can set up a handler for\n  it or for a NOT FOUND condition.\n\nDECLARE CONTINUE HANDLER FOR NOT FOUND\n  BEGIN\n    -- body of handler\n  END;\n\n  For another example, see\n  http://dev.mysql.com/doc/refman/5.7/en/cursors.html. The NOT FOUND\n  condition also occurs for SELECT ... INTO var_list statements that\n  retrieve no rows.\n\no SQLEXCEPTION: Shorthand for the class of SQLSTATE values that do not\n  begin with \'00\', \'01\', or \'02\'.\n\nDECLARE CONTINUE HANDLER FOR SQLEXCEPTION\n  BEGIN\n    -- body of handler\n  END;\n\nFor information about how the server chooses handlers when a condition\noccurs, see http://dev.mysql.com/doc/refman/5.7/en/handler-scope.html.\n\nIf a condition occurs for which no handler has been declared, the\naction taken depends on the condition class:\n\no For SQLEXCEPTION conditions, the stored program terminates at the\n  statement that raised the condition, as if there were an EXIT\n  handler. If the program was called by another stored program, the\n  calling program handles the condition using the handler selection\n  rules applied to its own handlers.\n\no For SQLWARNING conditions, the program continues executing, as if\n  there were a CONTINUE handler.\n\no For NOT FOUND conditions, if the condition was raised normally, the\n  action is CONTINUE. If it was raised by SIGNAL or RESIGNAL, the\n  action is EXIT.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/declare-handler.html\n\n','mysql> CREATE TABLE test.t (s1 INT, PRIMARY KEY (s1));\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> delimiter //\n\nmysql> CREATE PROCEDURE handlerdemo ()\n    -> BEGIN\n    ->   DECLARE CONTINUE HANDLER FOR SQLSTATE \'23000\' SET @x2 = 1;\n    ->   SET @x = 1;\n    ->   INSERT INTO test.t VALUES (1);\n    ->   SET @x = 2;\n    ->   INSERT INTO test.t VALUES (1);\n    ->   SET @x = 3;\n    -> END;\n    -> //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CALL handlerdemo()//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @x//\n    +------+\n    | @x   |\n    +------+\n    | 3    |\n    +------+\n    1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/declare-handler.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (502,23,'DOUBLE','DOUBLE[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA normal-size (double-precision) floating-point number. Permissible\nvalues are -1.7976931348623157E+308 to -2.2250738585072014E-308, 0, and\n2.2250738585072014E-308 to 1.7976931348623157E+308. These are the\ntheoretical limits, based on the IEEE standard. The actual range might\nbe slightly smaller depending on your hardware or operating system.\n\nM is the total number of digits and D is the number of digits following\nthe decimal point. If M and D are omitted, values are stored to the\nlimits permitted by the hardware. A double-precision floating-point\nnumber is accurate to approximately 15 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (503,23,'TIME','TIME[(fsp)]\n\nA time. The range is \'-838:59:59.000000\' to \'838:59:59.000000\'. MySQL\ndisplays TIME values in \'HH:MM:SS[.fraction]\' format, but permits\nassignment of values to TIME columns using either strings or numbers.\n\nAn optional fsp value in the range from 0 to 6 may be given to specify\nfractional seconds precision. A value of 0 signifies that there is no\nfractional part. If omitted, the default precision is 0.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (504,17,'SYSTEM_USER','Syntax:\nSYSTEM_USER()\n\nSYSTEM_USER() is a synonym for USER().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (505,40,'TRUNCATE TABLE','Syntax:\nTRUNCATE [TABLE] tbl_name\n\nTRUNCATE TABLE empties a table completely. It requires the DROP\nprivilege.\n\nLogically, TRUNCATE TABLE is similar to a DELETE statement that deletes\nall rows, or a sequence of DROP TABLE and CREATE TABLE statements. To\nachieve high performance, it bypasses the DML method of deleting data.\nThus, it cannot be rolled back, it does not cause ON DELETE triggers to\nfire, and it cannot be performed for InnoDB tables with parent-child\nforeign key relationships.\n\nAlthough TRUNCATE TABLE is similar to DELETE, it is classified as a DDL\nstatement rather than a DML statement. It differs from DELETE in the\nfollowing ways in MySQL 5.7:\n\no Truncate operations drop and re-create the table, which is much\n  faster than deleting rows one by one, particularly for large tables.\n\no Truncate operations cause an implicit commit, and so cannot be rolled\n  back.\n\no Truncation operations cannot be performed if the session holds an\n  active table lock.\n\no TRUNCATE TABLE fails for an InnoDB table or NDB table if there are\n  any FOREIGN KEY constraints from other tables that reference the\n  table. Foreign key constraints between columns of the same table are\n  permitted.\n\no Truncation operations do not return a meaningful value for the number\n  of deleted rows. The usual result is "0 rows affected," which should\n  be interpreted as "no information."\n\no As long as the table format file tbl_name.frm is valid, the table can\n  be re-created as an empty table with TRUNCATE TABLE, even if the data\n  or index files have become corrupted.\n\no Any AUTO_INCREMENT value is reset to its start value. This is true\n  even for MyISAM and InnoDB, which normally do not reuse sequence\n  values.\n\no When used with partitioned tables, TRUNCATE TABLE preserves the\n  partitioning; that is, the data and index files are dropped and\n  re-created, while the partition definitions (.par) file is\n  unaffected.\n\n  *Note*: As of MySQL 5.7.6, partition definition (.par) files are no\n  longer created. Instead, partition definitions are stored in the\n  internal data dictionary.\n\no The TRUNCATE TABLE statement does not invoke ON DELETE triggers.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/truncate-table.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/truncate-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (506,32,'CURRENT_DATE','Syntax:\nCURRENT_DATE, CURRENT_DATE()\n\nCURRENT_DATE and CURRENT_DATE() are synonyms for CURDATE().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (507,8,'START SLAVE','Syntax:\nSTART SLAVE [thread_types] [until_option] [connection_options] [channel_option]\n\nthread_types:\n    [thread_type [, thread_type] ... ]\n\nthread_type: \n    IO_THREAD | SQL_THREAD\n\nuntil_option:\n    UNTIL {   {SQL_BEFORE_GTIDS | SQL_AFTER_GTIDS} = gtid_set\n          |   MASTER_LOG_FILE = \'log_name\', MASTER_LOG_POS = log_pos\n          |   RELAY_LOG_FILE = \'log_name\', RELAY_LOG_POS = log_pos\n          |   SQL_AFTER_MTS_GAPS  }\n\nconnection_options: \n    [USER=\'user_name\'] [PASSWORD=\'user_pass\'] [DEFAULT_AUTH=\'plugin_name\'] [PLUGIN_DIR=\'plugin_dir\']\n\n\nchannel_option: \n    FOR CHANNEL channel\n\ngtid_set:\n    uuid_set [, uuid_set] ...\n    | \'\'\n\nuuid_set:\n    uuid:interval[:interval]...\n\nuuid:\n    hhhhhhhh-hhhh-hhhh-hhhh-hhhhhhhhhhhh\n\nh:\n    [0-9,A-F]\n\ninterval:\n    n[-n]\n\n    (n >= 1) \n\nSTART SLAVE with no thread_type options starts both of the slave\nthreads. The I/O thread reads events from the master server and stores\nthem in the relay log. The SQL thread reads events from the relay log\nand executes them. START SLAVE requires the SUPER privilege.\n\nIf START SLAVE succeeds in starting the slave threads, it returns\nwithout any error. However, even in that case, it might be that the\nslave threads start and then later stop (for example, because they do\nnot manage to connect to the master or read its binary log, or some\nother problem). START SLAVE does not warn you about this. You must\ncheck the slave\'s error log for error messages generated by the slave\nthreads, or check that they are running satisfactorily with SHOW SLAVE\nSTATUS.\n\nIn MySQL 5.7, START SLAVE causes an implicit commit of an ongoing\ntransaction. See\nhttp://dev.mysql.com/doc/refman/5.7/en/implicit-commit.html.\n\nBeginning with MySQL 5.7.1, gtid_next must be set to AUTOMATIC before\nissuing this statement (Bug #16062608).\n\nThe optional FOR CHANNEL channel clause added in MySQL 5.7.6 enables\nyou to choose which replication channel the statement applies to. If no\nclause is set and no extra channels exist, the statement applies to the\ndefault channel and behaves the same as versions of MySQL prior to\n5.7.6. Providing a FOR CHANNEL channel clause applies the START SLAVE\nstatement to a specific replication channel. If a START SLAVE statement\ndoes not have a channel defined when using multiple channels, this\nstatement starts the specified threads for all channels. Beginning with\nMySQL 5.7.9, this statement is disallowed for the\ngroup_replication_recovery channel. See\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-channels.html for\nmore information.\n\nMySQL 5.7 supports pluggable user-password authentication with START\nSLAVE with the USER, PASSWORD, DEFAULT_AUTH and PLUGIN_DIR options, as\ndescribed in the following list:\n\no USER: User name. Cannot be set to an empty or null string, or left\n  unset if PASSWORD is used.\n\no PASSWORD: Password.\n\no DEFAULT_AUTH: Name of plugin; default is MySQL native authentication.\n\no PLUGIN_DIR: Location of plugin.\n\nYou cannot use the SQL_THREAD option when specifying any of USER,\nPASSWORD, DEFAULT_AUTH, or PLUGIN_DIR, unless the IO_THREAD option is\nalso provided.\n\nSee\nhttp://dev.mysql.com/doc/refman/5.7/en/pluggable-authentication.html,\nfor more information.\n\nIf an insecure connection is used with any these options, the server\nissues the warning Sending passwords in plain text without SSL/TLS is\nextremely insecure.\n\nSTART SLAVE ... UNTIL supports two additional options for use with\nglobal transaction identifiers (GTIDs) (see\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-gtids.html). Each of\nthese takes a set of one or more global transaction identifiers\ngtid_set as an argument (see\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-gtids-concepts.html#\nreplication-gtids-concepts-gtid-sets, for more information).\n\nWhen no thread_type is specified, START SLAVE UNTIL SQL_BEFORE_GTIDS\ncauses the slave SQL thread to process transactions until it has\nreached the first transaction whose GTID is listed in the gtid_set.\nSTART SLAVE UNTIL SQL_AFTER_GTIDS causes the slave threads to process\nall transactions until the last transaction in the gtid_set has been\nprocessed by both threads. In other words, START SLAVE UNTIL\nSQL_BEFORE_GTIDS causes the slave SQL thread to process all\ntransactions occurring before the first GTID in the gtid_set is\nreached, and START SLAVE UNTIL SQL_AFTER_GTIDS causes the slave threads\nto handle all transactions, including those whose GTIDs are found in\ngtid_set, until each has encountered a transaction whose GTID is not\npart of the set. SQL_BEFORE_GTIDS and SQL_AFTER_GTIDS each support the\nSQL_THREAD and IO_THREAD options, although using IO_THREAD with them\ncurrently has no effect.\n\nFor example, START SLAVE SQL_THREAD UNTIL SQL_BEFORE_GTIDS =\n3E11FA47-71CA-11E1-9E33-C80AA9429562:11-56 causes the slave SQL thread\nto process all transactions originating from the master whose\nserver_uuid is 3E11FA47-71CA-11E1-9E33-C80AA9429562 until it encounters\nthe transaction having sequence number 11; it then stops without\nprocessing this transaction. In other words, all transactions up to and\nincluding the transaction with sequence number 10 are processed.\nExecuting START SLAVE SQL_THREAD UNTIL SQL_AFTER_GTIDS =\n3E11FA47-71CA-11E1-9E33-C80AA9429562:11-56, on the other hand, would\ncause the slave SQL thread to obtain all transactions just mentioned\nfrom the master, including all of the transactions having the sequence\nnumbers 11 through 56, and then to stop without processing any\nadditional transactions; that is, the transaction having sequence\nnumber 56 would be the last transaction fetched by the slave SQL\nthread.\n\nPrior to MySQL 5.7.3, SQL_AFTER_GTIDS did not stop the slave once the\nindicated transaction was completed, but waited until another GTID\nevent was received (Bug #14767986).\n\nWhen using a multi-threaded slave, there is a chance of gaps in the\nsequence of transactions that have been executed from the relay log in\nthe following cases:\n\no killing the coordinator thread\n\no after an error occurs in the worker threads\n\no mysqld shuts down unexpectedly\n\nUse the START SLAVE UNTIL SQL_AFTER_MTS_GAPS statement to cause a\nmulti-threaded slave\'s worker threads to only run until no more gaps\nare found in the relay log, and then to stop. This statement can take\nan SQL_THREAD option, but the effects of the statement remain\nunchanged. It has no effect on the slave I/O thread (and cannot be used\nwith the IO_THREAD option).\n\nIssuing START SLAVE on a multi-threaded slave with gaps in the sequence\nof transactions executed from the relay log generates a warning. In\nsuch a situation, the solution is to use START SLAVE UNTIL\nSQL_AFTER_MTS_GAPS, then issue RESET SLAVE to remove any remaining\nrelay logs. See\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-features-transaction\n-inconsistencies.html for more information.\n\nTo change a failed multi-threaded slave to single-threaded mode, you\ncan issue the following series of statements, in the order shown:\n\nSTART SLAVE UNTIL SQL_AFTER_MTS_GAPS;\n\nSET @@GLOBAL.slave_parallel_workers = 0;\n\nSTART SLAVE SQL_THREAD;\n\n*Note*: It is possible to view the entire text of a running START SLAVE\n... statement, including any USER or PASSWORD values used, in the\noutput of SHOW PROCESSLIST. This is also true for the text of a running\nCHANGE MASTER TO statement, including any values it employs for\nMASTER_USER or MASTER_PASSWORD.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/start-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/start-slave.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (508,2,'AREA','Area(poly)\n\nST_Area() and Area() are synonyms. For more information, see the\ndescription of ST_Area().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (509,27,'SHOW WARNINGS','Syntax:\nSHOW WARNINGS [LIMIT [offset,] row_count]\nSHOW COUNT(*) WARNINGS\n\nSHOW WARNINGS is a diagnostic statement that displays information about\nthe conditions (errors, warnings, and notes) resulting from executing a\nstatement in the current session. Warnings are generated for DML\nstatements such as INSERT, UPDATE, and LOAD DATA INFILE as well as DDL\nstatements such as CREATE TABLE and ALTER TABLE.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\nhttp://dev.mysql.com/doc/refman/5.7/en/select.html.\n\nSHOW WARNINGS is also used following EXPLAIN EXTENDED, to display the\nextra information generated by EXPLAIN when the EXTENDED keyword is\nused. See http://dev.mysql.com/doc/refman/5.7/en/explain-extended.html.\n\nAs of MySQL 5.7.2, SHOW WARNINGS displays information about the\nconditions resulting from execution of the most recent nondiagnostic\nstatement in the current session. If the most recent statement resulted\nin an error during parsing, SHOW WARNINGS shows the resulting\nconditions, regardless of statement type (diagnostic or nondiagnostic).\n\nBefore MySQL 5.7.2, SHOW WARNINGS displays information about the\nconditions resulting from the most recent statement in the current\nsession that generated messages. It shows nothing if the most recent\nstatement used a table and generated no messages. (That is, statements\nthat use a table but generate no messages clear the message list.)\nStatements that do not use tables and do not generate messages have no\neffect on the message list.\n\nThe SHOW COUNT(*) WARNINGS diagnostic statement displays the total\nnumber of errors, warnings, and notes. You can also retrieve this\nnumber from the warning_count system variable:\n\nSHOW COUNT(*) WARNINGS;\nSELECT @@warning_count;\n\nA difference in these statements is that the first is a diagnostic\nstatement that does not clear the message list. The second, because it\nis a SELECT statement is considered nondiagnostic and, as of MySQL\n5.7.2, does clear the message list.\n\nA related diagnostic statement, SHOW ERRORS, shows only error\nconditions (it excludes warnings and notes), and SHOW COUNT(*) ERRORS\nstatement displays the total number of errors. See [HELP SHOW ERRORS].\nGET DIAGNOSTICS can be used to examine information for individual\nconditions. See [HELP GET DIAGNOSTICS].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-warnings.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-warnings.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (510,4,'ST_LINEFROMTEXT','ST_LineFromText(wkt[,srid]), ST_LineStringFromText(wkt[,srid])\n\nConstructs a LineString value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (511,10,'DROP USER','Syntax:\nDROP USER [IF EXISTS] user [, user] ...\n\nThe DROP USER statement removes one or more MySQL accounts and their\nprivileges. It removes privilege rows for the account from all grant\ntables.\n\nTo use DROP USER, you must have the global CREATE USER privilege or the\nDELETE privilege for the mysql database. When the read_only system\nvariable is enabled, DROP USER additionally requires the SUPER\nprivilege.\n\nAn error occurs if you try to drop an account that does not exist.\n\nAs of MySQL 5.7.8, the IF EXISTS clause can be used, which causes the\nstatement to produce a warning for each named account that does not\nexist, rather than an error.\n\nEach account name uses the format described in\nhttp://dev.mysql.com/doc/refman/5.7/en/account-names.html. For example:\n\nDROP USER \'jeffrey\'@\'localhost\';\n\nIf you specify only the user name part of the account name, a host name\npart of \'%\' is used.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-user.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-user.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (512,38,'SUBSTRING','Syntax:\nSUBSTRING(str,pos), SUBSTRING(str FROM pos), SUBSTRING(str,pos,len),\nSUBSTRING(str FROM pos FOR len)\n\nThe forms without a len argument return a substring from string str\nstarting at position pos. The forms with a len argument return a\nsubstring len characters long from string str, starting at position\npos. The forms that use FROM are standard SQL syntax. It is also\npossible to use a negative value for pos. In this case, the beginning\nof the substring is pos characters from the end of the string, rather\nthan the beginning. A negative value may be used for pos in any of the\nforms of this function.\n\nFor all forms of SUBSTRING(), the position of the first character in\nthe string from which the substring is to be extracted is reckoned as\n1.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT SUBSTRING(\'Quadratically\',5);\n        -> \'ratically\'\nmysql> SELECT SUBSTRING(\'foobarbar\' FROM 4);\n        -> \'barbar\'\nmysql> SELECT SUBSTRING(\'Quadratically\',5,6);\n        -> \'ratica\'\nmysql> SELECT SUBSTRING(\'Sakila\', -3);\n        -> \'ila\'\nmysql> SELECT SUBSTRING(\'Sakila\', -5, 3);\n        -> \'aki\'\nmysql> SELECT SUBSTRING(\'Sakila\' FROM -4 FOR 2);\n        -> \'ki\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (513,37,'ISEMPTY','IsEmpty(g)\n\nST_IsEmpty() and IsEmpty() are synonyms. For more information, see the\ndescription of ST_IsEmpty().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (514,27,'SHOW FUNCTION STATUS','Syntax:\nSHOW FUNCTION STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement is similar to SHOW PROCEDURE STATUS but for stored\nfunctions. See [HELP SHOW PROCEDURE STATUS].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-function-status.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-function-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (515,38,'LTRIM','Syntax:\nLTRIM(str)\n\nReturns the string str with leading space characters removed.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT LTRIM(\'  barbar\');\n        -> \'barbar\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (516,31,'ST_CROSSES','ST_Crosses(g1,g2)\n\nReturns 1 if g1 spatially crosses g2. Returns NULL if g1 is a Polygon\nor a MultiPolygon, or if g2 is a Point or a MultiPoint. Otherwise,\nreturns 0.\n\nAs of MySQL 5.7.5, this function returns 0 if called with an\ninapplicable geometry argument type combination. For example, it\nreturns 0 if the first argument is a Polygon or MultiPolygon and/or the\nsecond argument is a Point or MultiPoint.\n\nThe term spatially crosses denotes a spatial relation between two given\ngeometries that has the following properties:\n\no The two geometries intersect\n\no Their intersection results in a geometry that has a dimension that is\n  one less than the maximum dimension of the two given geometries\n\no Their intersection is not equal to either of the two given geometries\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (517,4,'ST_MPOLYFROMTEXT','ST_MPolyFromText(wkt[,srid]), ST_MultiPolygonFromText(wkt[,srid])\n\nConstructs a MultiPolygon value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (518,28,'CALL','Syntax:\nCALL sp_name([parameter[,...]])\nCALL sp_name[()]\n\nThe CALL statement invokes a stored procedure that was defined\npreviously with CREATE PROCEDURE.\n\nStored procedures that take no arguments can be invoked without\nparentheses. That is, CALL p() and CALL p are equivalent.\n\nCALL can pass back values to its caller using parameters that are\ndeclared as OUT or INOUT parameters. When the procedure returns, a\nclient program can also obtain the number of rows affected for the\nfinal statement executed within the routine: At the SQL level, call the\nROW_COUNT() function; from the C API, call the mysql_affected_rows()\nfunction.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/call.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/call.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (519,7,'MBRDISJOINT','MBRDisjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\nthe two geometries g1 and g2 are disjoint (do not intersect).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mysql-specific.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (520,14,'VALUES','Syntax:\nVALUES(col_name)\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column\nvalues from the INSERT portion of the statement. In other words,\nVALUES(col_name) in the UPDATE clause refers to the value of col_name\nthat would be inserted, had no duplicate-key conflict occurred. This\nfunction is especially useful in multiple-row inserts. The VALUES()\nfunction is meaningful only in the ON DUPLICATE KEY UPDATE clause of\nINSERT statements and returns NULL otherwise. See\nhttp://dev.mysql.com/doc/refman/5.7/en/insert-on-duplicate.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> INSERT INTO table (a,b,c) VALUES (1,2,3),(4,5,6)\n    -> ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (521,12,'ENCODE','Syntax:\nENCODE(str,pass_str)\n\nENCODE() encrypts str using pass_str as the password. The result is a\nbinary string of the same length as str. To decrypt the result, use\nDECODE().\n\n*Note*: The ENCODE() and DECODE() functions are deprecated in MySQL\n5.7, will be removed in a future MySQL release, and should no longer be\nused.\n\nIf you still need to use ENCODE(), a salt value must be used with it to\nreduce risk. For example:\n\nENCODE(\'cleartext\', CONCAT(\'my_random_salt\',\'my_secret_password\'))\n\nA new random salt value must be used whenever a password is updated.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (522,38,'SUBSTRING_INDEX','Syntax:\nSUBSTRING_INDEX(str,delim,count)\n\nReturns the substring from string str before count occurrences of the\ndelimiter delim. If count is positive, everything to the left of the\nfinal delimiter (counting from the left) is returned. If count is\nnegative, everything to the right of the final delimiter (counting from\nthe right) is returned. SUBSTRING_INDEX() performs a case-sensitive\nmatch when searching for delim.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', 2);\n        -> \'www.mysql\'\nmysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', -2);\n        -> \'mysql.com\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (523,11,'ST_X','ST_X(p)\n\nReturns the X-coordinate value for the Point object p as a\ndouble-precision number.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-point-property-functions.html\n\n','mysql> SELECT ST_X(POINT(56.7, 53.34));\n+--------------------------+\n| ST_X(POINT(56.7, 53.34)) |\n+--------------------------+\n|                     56.7 |\n+--------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-point-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (524,32,'TIMESTAMPADD','Syntax:\nTIMESTAMPADD(unit,interval,datetime_expr)\n\nAdds the integer expression interval to the date or datetime expression\ndatetime_expr. The unit for interval is given by the unit argument,\nwhich should be one of the following values: MICROSECOND\n(microseconds), SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, or\nYEAR.\n\nThe unit value may be specified using one of keywords as shown, or with\na prefix of SQL_TSI_. For example, DAY and SQL_TSI_DAY both are legal.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMPADD(MINUTE,1,\'2003-01-02\');\n        -> \'2003-01-02 00:01:00\'\nmysql> SELECT TIMESTAMPADD(WEEK,1,\'2003-01-02\');\n        -> \'2003-01-09\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (525,3,'TRUNCATE','Syntax:\nTRUNCATE(X,D)\n\nReturns the number X, truncated to D decimal places. If D is 0, the\nresult has no decimal point or fractional part. D can be negative to\ncause D digits left of the decimal point of the value X to become zero.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT TRUNCATE(1.223,1);\n        -> 1.2\nmysql> SELECT TRUNCATE(1.999,1);\n        -> 1.9\nmysql> SELECT TRUNCATE(1.999,0);\n        -> 1\nmysql> SELECT TRUNCATE(-1.999,1);\n        -> -1.9\nmysql> SELECT TRUNCATE(122,-2);\n       -> 100\nmysql> SELECT TRUNCATE(10.28*100,0);\n       -> 1028\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (526,27,'SHOW','SHOW has many forms that provide information about databases, tables,\ncolumns, or status information about the server. This section describes\nthose following:\n\nSHOW {BINARY | MASTER} LOGS\nSHOW BINLOG EVENTS [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\nSHOW CHARACTER SET [like_or_where]\nSHOW COLLATION [like_or_where]\nSHOW [FULL] COLUMNS FROM tbl_name [FROM db_name] [like_or_where]\nSHOW CREATE DATABASE db_name\nSHOW CREATE EVENT event_name\nSHOW CREATE FUNCTION func_name\nSHOW CREATE PROCEDURE proc_name\nSHOW CREATE TABLE tbl_name\nSHOW CREATE TRIGGER trigger_name\nSHOW CREATE VIEW view_name\nSHOW DATABASES [like_or_where]\nSHOW ENGINE engine_name {STATUS | MUTEX}\nSHOW [STORAGE] ENGINES\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW EVENTS\nSHOW FUNCTION CODE func_name\nSHOW FUNCTION STATUS [like_or_where]\nSHOW GRANTS FOR user\nSHOW INDEX FROM tbl_name [FROM db_name]\nSHOW MASTER STATUS\nSHOW OPEN TABLES [FROM db_name] [like_or_where]\nSHOW PLUGINS\nSHOW PROCEDURE CODE proc_name\nSHOW PROCEDURE STATUS [like_or_where]\nSHOW PRIVILEGES\nSHOW [FULL] PROCESSLIST\nSHOW PROFILE [types] [FOR QUERY n] [OFFSET n] [LIMIT n]\nSHOW PROFILES\nSHOW RELAYLOG EVENTS [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\nSHOW SLAVE HOSTS\nSHOW SLAVE STATUS [NONBLOCKING]\nSHOW [GLOBAL | SESSION] STATUS [like_or_where]\nSHOW TABLE STATUS [FROM db_name] [like_or_where]\nSHOW [FULL] TABLES [FROM db_name] [like_or_where]\nSHOW TRIGGERS [FROM db_name] [like_or_where]\nSHOW [GLOBAL | SESSION] VARIABLES [like_or_where]\nSHOW WARNINGS [LIMIT [offset,] row_count]\n\nlike_or_where:\n    LIKE \'pattern\'\n  | WHERE expr\n\nIf the syntax for a given SHOW statement includes a LIKE \'pattern\'\npart, \'pattern\' is a string that can contain the SQL "%" and "_"\nwildcard characters. The pattern is useful for restricting statement\noutput to matching values.\n\nSeveral SHOW statements also accept a WHERE clause that provides more\nflexibility in specifying which rows to display. See\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (527,27,'SHOW VARIABLES','Syntax:\nSHOW [GLOBAL | SESSION] VARIABLES\n    [LIKE \'pattern\' | WHERE expr]\n\n*Note*: As of MySQL 5.7.6, the value of the show_compatibility_56\nsystem variable affects the information available from and privileges\nrequired for the statement described here. For details, see the\ndescription of that variable in\nhttp://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html.\n\nSHOW VARIABLES shows the values of MySQL system variables (see\nhttp://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html).\nThis statement does not require any privilege. It requires only the\nability to connect to the server.\n\nSystem variable information is also available from these sources:\n\no Performance Schema tables. See\n  http://dev.mysql.com/doc/refman/5.7/en/performance-schema-system-vari\n  able-tables.html.\n\no The GLOBAL_VARIABLES and SESSION_VARIABLES tables. See\n  http://dev.mysql.com/doc/refman/5.7/en/variables-table.html.\n\no The mysqladmin variables command. See\n  http://dev.mysql.com/doc/refman/5.7/en/mysqladmin.html.\n\nFor SHOW VARIABLES, a LIKE clause, if present, indicates which variable\nnames to match. A WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html.\n\nSHOW VARIABLES accepts an optional GLOBAL or SESSION variable scope\nmodifier:\n\no With a GLOBAL modifier, the statement displays global system variable\n  values. These are the values used to initialize the corresponding\n  session variables for new connections to MySQL. If a variable has no\n  global value, no value is displayed.\n\no With a SESSION modifier, the statement displays the system varaible\n  values that are in effect for the current connection. If a variable\n  has no session value, the global value is displayed. LOCAL is a\n  synonym for SESSION.\n\no If no modifier is present, the default is SESSION.\n\nThe scope for each system variable is listed at\nhttp://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html.\n\nSHOW VARIABLES is subject to a version-dependent display-width limit.\nFor variables with very long values that are not completely displayed,\nuse SELECT as a workaround. For example:\n\nSELECT @@GLOBAL.innodb_data_file_path;\n\nMost system variables can be set at server startup (read-only variables\nsuch as version_comment are exceptions). Many can be changed at runtime\nwith the SET statement. See\nhttp://dev.mysql.com/doc/refman/5.7/en/using-system-variables.html, and\n[HELP SET].\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern. To obtain the row for a\nspecific variable, use a LIKE clause as shown:\n\nSHOW VARIABLES LIKE \'max_join_size\';\nSHOW SESSION VARIABLES LIKE \'max_join_size\';\n\nTo get a list of variables whose name match a pattern, use the "%"\nwildcard character in a LIKE clause:\n\nSHOW VARIABLES LIKE \'%size%\';\nSHOW GLOBAL VARIABLES LIKE \'%size%\';\n\nWildcard characters can be used in any position within the pattern to\nbe matched. Strictly speaking, because "_" is a wildcard that matches\nany single character, you should escape it as "\\_" to match it\nliterally. In practice, this is rarely necessary.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-variables.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-variables.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (528,27,'BINLOG','Syntax:\nBINLOG \'str\'\n\nBINLOG is an internal-use statement. It is generated by the mysqlbinlog\nprogram as the printable representation of certain events in binary log\nfiles. (See http://dev.mysql.com/doc/refman/5.7/en/mysqlbinlog.html.)\nThe \'str\' value is a base 64-encoded string the that server decodes to\ndetermine the data change indicated by the corresponding event. This\nstatement requires the SUPER privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/binlog.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/binlog.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (529,31,'ST_DISJOINT','ST_Disjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially disjoint from (does\nnot intersect) g2.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (530,3,'ATAN2','Syntax:\nATAN(Y,X), ATAN2(Y,X)\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both\narguments are used to determine the quadrant of the result.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT ATAN(-2,2);\n        -> -0.78539816339745\nmysql> SELECT ATAN2(PI(),0);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (531,15,'AND','Syntax:\nAND, &&\n\nLogical AND. Evaluates to 1 if all operands are nonzero and not NULL,\nto 0 if one or more operands are 0, otherwise NULL is returned.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/logical-operators.html\n\n','mysql> SELECT 1 AND 1;\n        -> 1\nmysql> SELECT 1 AND 0;\n        -> 0\nmysql> SELECT 1 AND NULL;\n        -> NULL\nmysql> SELECT 0 AND NULL;\n        -> 0\nmysql> SELECT NULL AND 0;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/logical-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (532,32,'HOUR','Syntax:\nHOUR(time)\n\nReturns the hour for time. The range of the return value is 0 to 23 for\ntime-of-day values. However, the range of TIME values actually is much\nlarger, so HOUR can return values greater than 23.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT HOUR(\'10:05:03\');\n        -> 10\nmysql> SELECT HOUR(\'272:59:59\');\n        -> 272\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (533,28,'SELECT','Syntax:\nSELECT\n    [ALL | DISTINCT | DISTINCTROW ]\n      [HIGH_PRIORITY]\n      [MAX_STATEMENT_TIME = N]\n      [STRAIGHT_JOIN]\n      [SQL_SMALL_RESULT] [SQL_BIG_RESULT] [SQL_BUFFER_RESULT]\n      [SQL_CACHE | SQL_NO_CACHE] [SQL_CALC_FOUND_ROWS]\n    select_expr [, select_expr ...]\n    [FROM table_references\n      [PARTITION partition_list]\n    [WHERE where_condition]\n    [GROUP BY {col_name | expr | position}\n      [ASC | DESC], ... [WITH ROLLUP]]\n    [HAVING where_condition]\n    [ORDER BY {col_name | expr | position}\n      [ASC | DESC], ...]\n    [LIMIT {[offset,] row_count | row_count OFFSET offset}]\n    [PROCEDURE procedure_name(argument_list)]\n    [INTO OUTFILE \'file_name\'\n        [CHARACTER SET charset_name]\n        export_options\n      | INTO DUMPFILE \'file_name\'\n      | INTO var_name [, var_name]]\n    [FOR UPDATE | LOCK IN SHARE MODE]]\n\nSELECT is used to retrieve rows selected from one or more tables, and\ncan include UNION statements and subqueries. See [HELP UNION], and\nhttp://dev.mysql.com/doc/refman/5.7/en/subqueries.html.\n\nThe most commonly used clauses of SELECT statements are these:\n\no Each select_expr indicates a column that you want to retrieve. There\n  must be at least one select_expr.\n\no table_references indicates the table or tables from which to retrieve\n  rows. Its syntax is described in [HELP JOIN].\n\no SELECT supports explicit partition selection using the PARTITION with\n  a list of partitions or subpartitions (or both) following the name of\n  the table in a table_reference (see [HELP JOIN]). In this case, rows\n  are selected only from the partitions listed, and any other\n  partitions of the table are ignored. For more information and\n  examples, see\n  http://dev.mysql.com/doc/refman/5.7/en/partitioning-selection.html.\n\n  SELECT ... PARTITION from tables using storage engines such as MyISAM\n  that perform table-level locks (and thus partition locks) lock only\n  the partitions or subpartitions named by the PARTITION option.\n\n  See\n  http://dev.mysql.com/doc/refman/5.7/en/partitioning-limitations-locki\n  ng.html, for more information.\n\no The WHERE clause, if given, indicates the condition or conditions\n  that rows must satisfy to be selected. where_condition is an\n  expression that evaluates to true for each row to be selected. The\n  statement selects all rows if there is no WHERE clause.\n\n  In the WHERE expression, you can use any of the functions and\n  operators that MySQL supports, except for aggregate (summary)\n  functions. See\n  http://dev.mysql.com/doc/refman/5.7/en/expressions.html, and\n  http://dev.mysql.com/doc/refman/5.7/en/functions.html.\n\nSELECT can also be used to retrieve rows computed without reference to\nany table.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/select.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/select.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (534,16,'GROUP_CONCAT','Syntax:\nGROUP_CONCAT(expr)\n\nThis function returns a string result with the concatenated non-NULL\nvalues from a group. It returns NULL if there are no non-NULL values.\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n             [ORDER BY {unsigned_integer | col_name | expr}\n                 [ASC | DESC] [,col_name ...]]\n             [SEPARATOR str_val])\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','mysql> SELECT student_name,\n    ->     GROUP_CONCAT(test_score)\n    ->     FROM student\n    ->     GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (535,17,'BENCHMARK','Syntax:\nBENCHMARK(count,expr)\n\nThe BENCHMARK() function executes the expression expr repeatedly count\ntimes. It may be used to time how quickly MySQL processes the\nexpression. The result value is always 0. The intended use is from\nwithin the mysql client, which reports query execution times:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> SELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (4.74 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (536,38,'FROM_BASE64','Syntax:\nFROM_BASE64(str)\n\nTakes a string encoded with the base-64 encoded rules used by\nTO_BASE64() and returns the decoded result as a binary string. The\nresult is NULL if the argument is NULL or not a valid base-64 string.\nSee the description of TO_BASE64() for details about the encoding and\ndecoding rules.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT TO_BASE64(\'abc\'), FROM_BASE64(TO_BASE64(\'abc\'));\n        -> \'JWJj\', \'abc\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (537,27,'SHOW ENGINE','Syntax:\nSHOW ENGINE engine_name {STATUS | MUTEX}\n\nSHOW ENGINE displays operational information about a storage engine. It\nrequires the PROCESS privilege. The statement has these variants:\n\nSHOW ENGINE INNODB STATUS\nSHOW ENGINE INNODB MUTEX\nSHOW ENGINE PERFORMANCE_SCHEMA STATUS\n\nSHOW ENGINE INNODB STATUS displays extensive information from the\nstandard InnoDB Monitor about the state of the InnoDB storage engine.\nFor information about the standard monitor and other InnoDB Monitors\nthat provide information about InnoDB processing, see\nhttp://dev.mysql.com/doc/refman/5.7/en/innodb-monitors.html.\n\nSHOW ENGINE INNODB MUTEX displays InnoDB mutex and rw-lock statistics.\n\n*Note*: InnoDB mutexes and rwlocks can also be monitored using\nPerformance Schema tables. See\nhttp://dev.mysql.com/doc/refman/5.7/en/monitor-innodb-mutex-waits-perfo\nrmance-schema.html.\n\nSHOW ENGINE INNODB MUTEX output was removed in MySQL 5.7.2. It was\nrevised and reintroduced in MySQL 5.7.8.\n\nIn MySQL 5.7.8, mutex statistics collection is configured dynamically\nusing the following options:\n\no To enable the collection of mutex statistics, run:\n\nSET GLOBAL innodb_monitor_enable=\'latch\';\n\no To reset mutex statistics, run:\n\nSET GLOBAL innodb_monitor_reset=\'latch\';\n\no To disable the collection of mutex statistics, run:\n\nSET GLOBAL innodb_monitor_disable=\'latch\';\n\nCollection of mutex statistics for SHOW ENGINE INNODB MUTEX can also be\nenabled by setting innodb_monitor_enable=\'all\', or disabled by setting\ninnodb_monitor_disable=\'all\'.\n\nSHOW ENGINE INNODB MUTEX output has the following columns:\n\no Type\n\n  Always InnoDB.\n\no Name\n\n  Prior to MySQL 5.7.8, the Name field reports the source file where\n  the mutex is implemented, and the line number in the file where the\n  mutex is created. The line number is specific to your version of\n  MySQL. As of MySQL 5.7.8, only the mutex name is reported. File name\n  and line number are still reported for rwlocks.\n\no Status\n\n  The mutex status.\n\n  Prior to MySQL 5.7.8, the Status field displays several values if\n  WITH_DEBUG was defined at MySQL compilation time. If WITH_DEBUG was\n  not defined, the statement displays only the os_waits value. In the\n  latter case (without WITH_DEBUG), the information on which the output\n  is based is insufficient to distinguish regular mutexes and mutexes\n  that protect rwlocks (which permit multiple readers or a single\n  writer). Consequently, the output may appear to contain multiple rows\n  for the same mutex. Pre-MySQL 5.7.8 Status field values include:\n\n  o count indicates how many times the mutex was requested.\n\n  o spin_waits indicates how many times the spinlock had to run.\n\n  o spin_rounds indicates the number of spinlock rounds. (spin_rounds\n    divided by spin_waits provides the average round count.)\n\n  o os_waits indicates the number of operating system waits. This\n    occurs when the spinlock did not work (the mutex was not locked\n    during the spinlock and it was necessary to yield to the operating\n    system and wait).\n\n  o os_yields indicates the number of times a thread trying to lock a\n    mutex gave up its timeslice and yielded to the operating system (on\n    the presumption that permitting other threads to run will free the\n    mutex so that it can be locked).\n\n  o os_wait_times indicates the amount of time (in ms) spent in\n    operating system waits. In MySQL 5.7 timing is disabled and this\n    value is always 0.\n\n  As of MySQL 5.7.8, the Status field reports the number of spins,\n  waits, and calls. Statistics for low-level operating system mutexes,\n  which are implemented outside of InnoDB, are not reported.\n\n  o spins indicates the number of spins.\n\n  o waits indicates the number of mutex waits.\n\n  o calls indicates how many times the mutex was requested.\n\nSHOW ENGINE INNODB MUTEX skips the mutexes and rw-locks of buffer pool\nblocks, as the amount of output can be overwhelming on systems with a\nlarge buffer pool. (There is one mutex and one rw-lock in each 16K\nbuffer pool block, and there are 65,536 blocks per gigabyte.) SHOW\nENGINE INNODB MUTEX also does not list any mutexes or rw-locks that\nhave never been waited on (os_waits=0). Thus, SHOW ENGINE INNODB MUTEX\nonly displays information about mutexes and rw-locks outside of the\nbuffer pool that have caused at least one OS-level wait.\n\nUse SHOW ENGINE PERFORMANCE_SCHEMA STATUS to inspect the internal\noperation of the Performance Schema code:\n\nmysql> SHOW ENGINE PERFORMANCE_SCHEMA STATUS\\G\n...\n*************************** 3. row ***************************\n  Type: performance_schema\n  Name: events_waits_history.size\nStatus: 76\n*************************** 4. row ***************************\n  Type: performance_schema\n  Name: events_waits_history.count\nStatus: 10000\n*************************** 5. row ***************************\n  Type: performance_schema\n  Name: events_waits_history.memory\nStatus: 760000\n...\n*************************** 57. row ***************************\n  Type: performance_schema\n  Name: performance_schema.memory\nStatus: 26459600\n...\n\nThis statement is intended to help the DBA understand the effects that\ndifferent Performance Schema options have on memory requirements.\n\nName values consist of two parts, which name an internal buffer and a\nbuffer attribute, respectively. Interpret buffer names as follows:\n\no An internal buffer that is not exposed as a table is named within\n  parentheses. Examples: (pfs_cond_class).size,\n  (pfs_mutex_class).memory.\n\no An internal buffer that is exposed as a table in the\n  performance_schema database is named after the table, without\n  parentheses. Examples: events_waits_history.size,\n  mutex_instances.count.\n\no A value that applies to the Performance Schema as a whole begins with\n  performance_schema. Example: performance_schema.memory.\n\nBuffer attributes have these meanings:\n\no size is the size of the internal record used by the implementation,\n  such as the size of a row in a table. size values cannot be changed.\n\no count is the number of internal records, such as the number of rows\n  in a table. count values can be changed using Performance Schema\n  configuration options.\n\no For a table, tbl_name.memory is the product of size and count. For\n  the Performance Schema as a whole, performance_schema.memory is the\n  sum of all the memory used (the sum of all other memory values).\n\nSome size and count attributes were named row_size and row_count before\nMySQL 5.7.1.\n\nIn some cases, there is a direct relationship between a Performance\nSchema configuration parameter and a SHOW ENGINE value. For example,\nevents_waits_history_long.count corresponds to\nperformance_schema_events_waits_history_long_size. In other cases, the\nrelationship is more complex. For example, events_waits_history.count\ncorresponds to performance_schema_events_waits_history_size (the number\nof rows per thread) multiplied by\nperformance_schema_max_thread_instances ( the number of threads).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-engine.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-engine.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (538,14,'NAME_CONST','Syntax:\nNAME_CONST(name,value)\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments\nshould be constants.\n\nmysql> SELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (539,14,'RELEASE_LOCK','Syntax:\nRELEASE_LOCK(str)\n\nReleases the lock named by the string str that was obtained with\nGET_LOCK(). Returns 1 if the lock was released, 0 if the lock was not\nestablished by this thread (in which case the lock is not released),\nand NULL if the named lock did not exist. The lock does not exist if it\nwas never obtained by a call to GET_LOCK() or if it has previously been\nreleased.\n\nThe DO statement is convenient to use with RELEASE_LOCK(). See [HELP\nDO].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (540,32,'WEEKDAY','Syntax:\nWEEKDAY(date)\n\nReturns the weekday index for date (0 = Monday, 1 = Tuesday, ... 6 =\nSunday).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT WEEKDAY(\'2008-02-03 22:23:00\');\n        -> 6\nmysql> SELECT WEEKDAY(\'2007-11-06\');\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (541,32,'TIME_TO_SEC','Syntax:\nTIME_TO_SEC(time)\n\nReturns the time argument, converted to seconds.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT TIME_TO_SEC(\'22:23:00\');\n        -> 80580\nmysql> SELECT TIME_TO_SEC(\'00:39:38\');\n        -> 2378\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (542,32,'CONVERT_TZ','Syntax:\nCONVERT_TZ(dt,from_tz,to_tz)\n\nCONVERT_TZ() converts a datetime value dt from the time zone given by\nfrom_tz to the time zone given by to_tz and returns the resulting\nvalue. Time zones are specified as described in\nhttp://dev.mysql.com/doc/refman/5.7/en/time-zone-support.html. This\nfunction returns NULL if the arguments are invalid.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT CONVERT_TZ(\'2004-01-01 12:00:00\',\'GMT\',\'MET\');\n        -> \'2004-01-01 13:00:00\'\nmysql> SELECT CONVERT_TZ(\'2004-01-01 12:00:00\',\'+00:00\',\'+10:00\');\n        -> \'2004-01-01 22:00:00\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (543,38,'EXPORT_SET','Syntax:\nEXPORT_SET(bits,on,off[,separator[,number_of_bits]])\n\nReturns a string such that for every bit set in the value bits, you get\nan on string and for every bit not set in the value, you get an off\nstring. Bits in bits are examined from right to left (from low-order to\nhigh-order bits). Strings are added to the result from left to right,\nseparated by the separator string (the default being the comma\ncharacter ","). The number of bits examined is given by number_of_bits,\nwhich has a default of 64 if not specified. number_of_bits is silently\nclipped to 64 if larger than 64. It is treated as an unsigned integer,\nso a value of −1 is effectively the same as 64.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT EXPORT_SET(5,\'Y\',\'N\',\',\',4);\n        -> \'Y,N,Y,N\'\nmysql> SELECT EXPORT_SET(6,\'1\',\'0\',\',\',10);\n        -> \'0,1,1,0,0,0,0,0,0,0\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (544,38,'CAST','Syntax:\nCAST(expr AS type)\n\nThe CAST() function takes an expression of any type and produces a\nresult value of a specified type, similar to CONVERT(). See the\ndescription of CONVERT() for more information.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/cast-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/cast-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (545,38,'SOUNDS LIKE','Syntax:\nexpr1 SOUNDS LIKE expr2\n\nThis is the same as SOUNDEX(expr1) = SOUNDEX(expr2).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (546,32,'PERIOD_DIFF','Syntax:\nPERIOD_DIFF(P1,P2)\n\nReturns the number of months between periods P1 and P2. P1 and P2\nshould be in the format YYMM or YYYYMM. Note that the period arguments\nP1 and P2 are not date values.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT PERIOD_DIFF(200802,200703);\n        -> 11\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (547,16,'AVG','Syntax:\nAVG([DISTINCT] expr)\n\nReturns the average value of expr. The DISTINCT option can be used to\nreturn the average of the distinct values of expr.\n\nAVG() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html\n\n','mysql> SELECT student_name, AVG(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.7/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (548,38,'QUOTE','Syntax:\nQUOTE(str)\n\nQuotes a string to produce a result that can be used as a properly\nescaped data value in an SQL statement. The string is returned enclosed\nby single quotation marks and with each instance of backslash ("\\"),\nsingle quote ("\'"), ASCII NUL, and Control+Z preceded by a backslash.\nIf the argument is NULL, the return value is the word "NULL" without\nenclosing single quotation marks.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT QUOTE(\'Don\\\'t!\');\n        -> \'Don\\\'t!\'\nmysql> SELECT QUOTE(NULL);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (549,20,'IN','Syntax:\nexpr IN (value,...)\n\nReturns 1 if expr is equal to any of the values in the IN list, else\nreturns 0. If all values are constants, they are evaluated according to\nthe type of expr and sorted. The search for the item then is done using\na binary search. This means IN is very quick if the IN value list\nconsists entirely of constants. Otherwise, type conversion takes place\naccording to the rules described in\nhttp://dev.mysql.com/doc/refman/5.7/en/type-conversion.html, but\napplied to all the arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 2 IN (0,3,5,7);\n        -> 0\nmysql> SELECT \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\');\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (550,32,'QUARTER','Syntax:\nQUARTER(date)\n\nReturns the quarter of the year for date, in the range 1 to 4.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT QUARTER(\'2008-04-01\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (551,27,'HELP COMMAND','Syntax:\nmysql> help search_string\n\nIf you provide an argument to the help command, mysql uses it as a\nsearch string to access server-side help from the contents of the MySQL\nReference Manual. The proper operation of this command requires that\nthe help tables in the mysql database be initialized with help topic\ninformation (see\nhttp://dev.mysql.com/doc/refman/5.7/en/server-side-help-support.html).\n\nIf there is no match for the search string, the search fails:\n\nmysql> help me\n\nNothing found\nPlease try to run \'help contents\' for a list of all accessible topics\n\nUse help contents to see a list of the help categories:\n\nmysql> help contents\nYou asked for help about help category: "Contents"\nFor more information, type \'help <item>\', where <item> is one of the\nfollowing categories:\n   Account Management\n   Administration\n   Data Definition\n   Data Manipulation\n   Data Types\n   Functions\n   Functions and Modifiers for Use with GROUP BY\n   Geographic Features\n   Language Structure\n   Plugins\n   Storage Engines\n   Stored Routines\n   Table Maintenance\n   Transactions\n   Triggers\n\nIf the search string matches multiple items, mysql shows a list of\nmatching topics:\n\nmysql> help logs\nMany help items for your request exist.\nTo make a more specific request, please type \'help <item>\',\nwhere <item> is one of the following topics:\n   SHOW\n   SHOW BINARY LOGS\n   SHOW ENGINE\n   SHOW LOGS\n\nUse a topic as the search string to see the help entry for that topic:\n\nmysql> help show binary logs\nName: \'SHOW BINARY LOGS\'\nDescription:\nSyntax:\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [purge-binary-logs], that shows how\nto determine which logs can be purged.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+\n| Log_name      | File_size |\n+---------------+-----------+\n| binlog.000015 |    724935 |\n| binlog.000016 |    733481 |\n+---------------+-----------+\n\nThe search string can contain the wildcard characters "%" and "_".\nThese have the same meaning as for pattern-matching operations\nperformed with the LIKE operator. For example, HELP rep% returns a list\nof topics that begin with rep:\n\nmysql> HELP rep%\nMany help items for your request exist.\nTo make a more specific request, please type \'help <item>\',\nwhere <item> is one of the following\ntopics:\n   REPAIR TABLE\n   REPEAT FUNCTION\n   REPEAT LOOP\n   REPLACE\n   REPLACE FUNCTION\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mysql-server-side-help.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/mysql-server-side-help.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (552,7,'JSON_REPLACE','JSON_REPLACE(json_doc, path, val[, path, val] ...)\n\nReplaces existing values in a JSON document and returns the result.\nReturns NULL if any argument is NULL. An error occurs if the json_doc\nargument is not a valid JSON document or any path argument is not a\nvalid path expression or contains a * or ** wildcard.\n\nThe path/value pairs are evaluated left to right. The document produced\nby evaluating one pair becomes the new value against which the next\npair is evaluated.\n\nA path/value pair for an existing path in the document overwrites the\nexisting document value with the new value. A path/value pair for a\nnonexisting path in the document is ignored and has no effect.\n\nFor a comparison of JSON_INSERT(), JSON_REPLACE(), and JSON_SET(), see\nthe discussion of JSON_SET().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html\n\n','mysql> SET @j = \'{ "a": 1, "b": [2, 3]}\';\nmysql> SELECT JSON_REPLACE(@j, \'$.a\', 10, \'$.c\', \'[true, false]\');\n+-----------------------------------------------------+\n| JSON_REPLACE(@j, \'$.a\', 10, \'$.c\', \'[true, false]\') |\n+-----------------------------------------------------+\n| {"a": 10, "b": [2, 3]}                              |\n+-----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (553,38,'POSITION','Syntax:\nPOSITION(substr IN str)\n\nPOSITION(substr IN str) is a synonym for LOCATE(substr,str).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (554,14,'IS_USED_LOCK','Syntax:\nIS_USED_LOCK(str)\n\nChecks whether the lock named str is in use (that is, locked). If so,\nit returns the connection identifier of the client session that holds\nthe lock. Otherwise, it returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (555,4,'POLYFROMTEXT','PolyFromText(wkt[,srid]), PolygonFromText(wkt[,srid])\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText(), and\nPolygonFromText() are synonyms. For more information, see the\ndescription of ST_PolyFromText().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (556,37,'ST_SRID','ST_SRID(g)\n\nReturns an integer indicating the Spatial Reference System ID for the\ngeometry value g.\n\nIn MySQL, the SRID value is just an integer associated with the\ngeometry value. All calculations are done assuming Euclidean (planar)\ngeometry.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','mysql> SELECT ST_SRID(ST_GeomFromText(\'LineString(1 1,2 2)\',101));\n+-----------------------------------------------------+\n| ST_SRID(ST_GeomFromText(\'LineString(1 1,2 2)\',101)) |\n+-----------------------------------------------------+\n|                                                 101 |\n+-----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (557,10,'ALTER USER','Syntax:\nALTER USER syntax for MySQL 5.7.6 and higher:\n\nThe ALTER USER statement modifies MySQL accounts. It provides control\nover account password expiration. As of MySQL 5.7.6, it also provides\ncontrol over authentication, SSL/TLS, and resource-limit properties,\nand account locking and unlocking.\n\nTo use ALTER USER, you must have the global CREATE USER privilege or\nthe UPDATE privilege for the mysql database. When the read_only system\nvariable is enabled, ALTER USER additionally requires the SUPER\nprivilege.\n\nAn error occurs if you try to modify an account that does not exist.\n\nAs of MySQL 5.7.8, the IF EXISTS clause can be used, which causes the\nstatement to produce a warning for each named account that does not\nexist, rather than an error.\n\nALTER USER modifies the mysql.user table row for each affected account\naccording to the options specified in the statement. Unspecified\nproperties retain their current values.\n\nExample 1: Change an account\'s password and expire it. As a result, the\nuser must connect with the named password and choose a new one at the\nnext connection:\n\nALTER USER \'jeffrey\'@\'localhost\'\n  IDENTIFIED BY \'new_password\' PASSWORD EXPIRE;\n\nExample 2: Modify an account to use the sha256_password authentication\nplugin and the given password. Require that a new password be chosen\nevery 180 days:\n\nALTER USER \'jeffrey\'@\'localhost\'\n  IDENTIFIED WITH sha256_password BY \'new_password\'\n  PASSWORD EXPIRE INTERVAL 180 DAY;\n\nExample 3: Lock or unlock an account:\n\nALTER USER \'jeffrey\'@\'localhost\' ACCOUNT LOCK;\nALTER USER \'jeffrey\'@\'localhost\' ACCOUNT UNLOCK;\n\nExample 4: Require an account to connect using SSL and establish a\nlimit of 20 connections per hour:\n\nALTER USER \'jeffrey\'@\'localhost\'\n  REQUIRE SSL WITH MAX_CONNECTIONS_PER_HOUR 20;\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-user.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/alter-user.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (558,12,'DES_ENCRYPT','Syntax:\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nEncrypts the string with the given key using the Triple-DES algorithm.\n\nThis function works only if MySQL has been configured with SSL support.\nSee http://dev.mysql.com/doc/refman/5.7/en/secure-connections.html.\n\nThe encryption key to use is chosen based on the second argument to\nDES_ENCRYPT(), if one was given. With no argument, the first key from\nthe DES key file is used. With a key_num argument, the given key number\n(0 to 9) from the DES key file is used. With a key_str argument, the\ngiven key string is used to encrypt str.\n\nThe key file can be specified with the --des-key-file server option.\n\nThe return string is a binary string where the first character is\nCHAR(128 | key_num). If an error occurs, DES_ENCRYPT() returns NULL.\n\nThe 128 is added to make it easier to recognize an encrypted key. If\nyou use a string key, key_num is 127.\n\nThe string length for the result is given by this formula:\n\nnew_len = orig_len + (8 - (orig_len % 8)) + 1\n\nEach line in the DES key file has the following format:\n\nkey_num des_key_str\n\nEach key_num value must be a number in the range from 0 to 9. Lines in\nthe file may be in any order. des_key_str is the string that is used to\nencrypt the message. There should be at least one space between the\nnumber and the key. The first key is the default key that is used if\nyou do not specify any key argument to DES_ENCRYPT().\n\nYou can tell MySQL to read new key values from the key file with the\nFLUSH DES_KEY_FILE statement. This requires the RELOAD privilege.\n\nOne benefit of having a set of default keys is that it gives\napplications a way to check for the existence of encrypted column\nvalues, without giving the end user the right to decrypt those values.\n\n*Note*: The DES_ENCRYPT() and DES_DECRYPT() functions are deprecated as\nof MySQL 5.7.6, will be removed in a future MySQL release, and should\nno longer be used. Consider using AES_ENCRYPT() and AES_DECRYPT()\ninstead.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','mysql> SELECT customer_address FROM customer_table \n     > WHERE crypted_credit_card = DES_ENCRYPT(\'credit_card_number\');\n','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (559,3,'CEIL','Syntax:\nCEIL(X)\n\nCEIL() is a synonym for CEILING().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (560,7,'WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS','Syntax:\nWAIT_UNTIL_SQL_THREAD_AFTER_GTIDS(gtid_set[, timeout][,channel])\n\nWait until the slave SQL thread has executed all of the transactions\nwhose global transaction identifiers are contained in gtid_set (see\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-gtids-concepts.html,\nfor a definition of "GTID sets"), or until timeout seconds have\nelapsed, whichever occurs first. timeout is optional; the default\ntimeout is 0 seconds, in which case the function waits until all of the\ntransactions in the GTID set have been executed.\n\nFor more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-gtids.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gtid-functions.html\n\n','mysql> SELECT WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:1-5\');\n        -> 5\n','http://dev.mysql.com/doc/refman/5.7/en/gtid-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (561,38,'LENGTH','Syntax:\nLENGTH(str)\n\nReturns the length of the string str, measured in bytes. A multibyte\ncharacter counts as multiple bytes. This means that for a string\ncontaining five 2-byte characters, LENGTH() returns 10, whereas\nCHAR_LENGTH() returns 5.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT LENGTH(\'text\');\n        -> 4\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (562,38,'WEIGHT_STRING','Syntax:\nWEIGHT_STRING(str [AS {CHAR|BINARY}(N)] [LEVEL levels] [flags])\n\nlevels: N [ASC|DESC|REVERSE] [, N [ASC|DESC|REVERSE]] ...\n\nThis function returns the weight string for the input string. The\nreturn value is a binary string that represents the sorting and\ncomparison value of the string. It has these properties:\n\no If WEIGHT_STRING(str1) = WEIGHT_STRING(str2), then str1 = str2 (str1\n  and str2 are considered equal)\n\no If WEIGHT_STRING(str1) < WEIGHT_STRING(str2), then str1 < str2 (str1\n  sorts before str2)\n\nWEIGHT_STRING() can be used for testing and debugging of collations,\nespecially if you are adding a new collation. See\nhttp://dev.mysql.com/doc/refman/5.7/en/adding-collation.html.\n\nThe input string, str, is a string expression. If the input is a\nnonbinary (character) string such as a CHAR, VARCHAR, or TEXT value,\nthe return value contains the collation weights for the string. If the\ninput is a binary (byte) string such as a BINARY, VARBINARY, or BLOB\nvalue, the return value is the same as the input (the weight for each\nbyte in a binary string is the byte value). If the input is NULL,\nWEIGHT_STRING() returns NULL.\n\nExamples:\n\nmysql> SET @s = _latin1 \'AB\' COLLATE latin1_swedish_ci;\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| AB   | 4142    | 4142                   |\n+------+---------+------------------------+\n\nmysql> SET @s = _latin1 \'ab\' COLLATE latin1_swedish_ci;\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| ab   | 6162    | 4142                   |\n+------+---------+------------------------+\n\nmysql> SET @s = CAST(\'AB\' AS BINARY);\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| AB   | 4142    | 4142                   |\n+------+---------+------------------------+\n\nmysql> SET @s = CAST(\'ab\' AS BINARY);\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| ab   | 6162    | 6162                   |\n+------+---------+------------------------+\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (563,31,'ST_EQUALS','ST_Equals(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially equal to g2.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html\n\n','mysql> SET @g1 = POINT(1,1), @g2 = POINT(2,2);\nmysql> SELECT ST_Equals(@g1, @g1), ST_Equals(@g1, @g2);\n+---------------------+---------------------+\n| ST_Equals(@g1, @g1) | ST_Equals(@g1, @g2) |\n+---------------------+---------------------+\n|                   1 |                   0 |\n+---------------------+---------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (564,40,'ALTER EVENT','Syntax:\nALTER\n    [DEFINER = { user | CURRENT_USER }]\n    EVENT event_name\n    [ON SCHEDULE schedule]\n    [ON COMPLETION [NOT] PRESERVE]\n    [RENAME TO new_event_name]\n    [ENABLE | DISABLE | DISABLE ON SLAVE]\n    [COMMENT \'comment\']\n    [DO event_body]\n\nThe ALTER EVENT statement changes one or more of the characteristics of\nan existing event without the need to drop and recreate it. The syntax\nfor each of the DEFINER, ON SCHEDULE, ON COMPLETION, COMMENT, ENABLE /\nDISABLE, and DO clauses is exactly the same as when used with CREATE\nEVENT. (See [HELP CREATE EVENT].)\n\nAny user can alter an event defined on a database for which that user\nhas the EVENT privilege. When a user executes a successful ALTER EVENT\nstatement, that user becomes the definer for the affected event.\n\nALTER EVENT works only with an existing event:\n\nmysql> ALTER EVENT no_such_event \n     >     ON SCHEDULE \n     >       EVERY \'2:3\' DAY_HOUR;\nERROR 1517 (HY000): Unknown event \'no_such_event\'\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-event.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/alter-event.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (565,32,'DATE_SUB','Syntax:\nDATE_SUB(date,INTERVAL expr unit)\n\nSee the description for DATE_ADD().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (566,19,'|','Syntax:\n|\n\nBitwise OR:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html\n\n','mysql> SELECT 29 | 15;\n        -> 31\n','http://dev.mysql.com/doc/refman/5.7/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (567,7,'ASYMMETRIC_SIGN','Syntax:\nASYMMETRIC_SIGN(algorithm, digest_str, priv_key_str, digest_type)\n\nSigns a digest string using a private key string, and returns the\nsignature as a binary string. If signing fails, the result is NULL.\n\ndigest_str is the digest string. It can be generated by calling\nCREATE_DIGEST(). digest_type indicates the digest algorithm used to\ngenerate the digest string.\n\npriv_key_str is the private key string to use for signing the digest\nstring. It must be a valid key string in PEM format. algorithm\nindicates the encryption algorithm used to create the key.\n\nSupported algorithm values: \'RSA\', \'DSA\'\n\nSupported digest_type values: \'SHA224\', \'SHA256\', \'SHA384\', \'SHA512\'\n\nFor a usage example, see the description of ASYMMETRIC_VERIFY().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (568,4,'GEOMFROMTEXT','GeomFromText(wkt[,srid]), GeometryFromText(wkt[,srid])\n\nST_GeomFromText(), ST_GeometryFromText(), GeomFromText(), and\nGeometryFromText() are synonyms. For more information, see the\ndescription of ST_GeomFromText().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (569,14,'UUID_SHORT','Syntax:\nUUID_SHORT()\n\nReturns a "short" universal identifier as a 64-bit unsigned integer.\nValues returned by UUID_SHORT() differ from the string-format 128-bit\nidentifiers returned by the UUID() function and have different\nuniqueness properties. The value of UUID_SHORT() is guaranteed to be\nunique if the following conditions hold:\n\no The server_id value of the current server is between 0 and 255 and is\n  unique among your set of master and slave servers\n\no You do not set back the system time for your server host between\n  mysqld restarts\n\no You invoke UUID_SHORT() on average fewer than 16 million times per\n  second between mysqld restarts\n\nThe UUID_SHORT() return value is constructed this way:\n\n  (server_id & 255) << 56\n+ (server_startup_time_in_seconds << 24)\n+ incremented_variable++;\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> SELECT UUID_SHORT();\n        -> 92395783831158784\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (570,32,'DATEDIFF','Syntax:\nDATEDIFF(expr1,expr2)\n\nDATEDIFF() returns expr1 − expr2 expressed as a value in days from\none date to the other. expr1 and expr2 are date or date-and-time\nexpressions. Only the date parts of the values are used in the\ncalculation.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT DATEDIFF(\'2007-12-31 23:59:59\',\'2007-12-30\');\n        -> 1\nmysql> SELECT DATEDIFF(\'2010-11-30 23:59:59\',\'2010-12-31\');\n        -> -31\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (571,40,'DROP PROCEDURE','Syntax:\nDROP {PROCEDURE | FUNCTION} [IF EXISTS] sp_name\n\nThis statement is used to drop a stored procedure or function. That is,\nthe specified routine is removed from the server. You must have the\nALTER ROUTINE privilege for the routine. (If the\nautomatic_sp_privileges system variable is enabled, that privilege and\nEXECUTE are granted automatically to the routine creator when the\nroutine is created and dropped from the creator when the routine is\ndropped. See\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-routines-privileges.html.\n)\n\nThe IF EXISTS clause is a MySQL extension. It prevents an error from\noccurring if the procedure or function does not exist. A warning is\nproduced that can be viewed with SHOW WARNINGS.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/drop-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/drop-procedure.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (572,7,'ST_LATFROMGEOHASH','ST_LatFromGeoHash(geohash_str)\n\nReturns the latitude from a geohash string value, as a DOUBLE value in\nthe range [−90, 90]. The result is NULL if any argument is NULL. An\nerror occurs if the argument is invalid.\n\nThe ST_LatFromGeoHash() decoding function reads no more than 433\ncharacters from the geohash_str argument. That represents the upper\nlimit on information in the internal representation of coordinate\nvalues. Characters past the 433rd are ignored, even if they are\notherwise illegal and produce an error.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-geohash-functions.html\n\n','mysql> SELECT ST_LatFromGeoHash(ST_GeoHash(45,-20,10));\n+------------------------------------------+\n| ST_LatFromGeoHash(ST_GeoHash(45,-20,10)) |\n+------------------------------------------+\n|                                      -20 |\n+------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-geohash-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (573,7,'ST_GEOMFROMGEOJSON','ST_GeomFromGeoJSON(str [, options [, srid]])\n\nParses a string str representing a GeoJSON object and returns a\ngeometry.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-geojson-functions.html\n\n','mysql> SET @json = \'{ "type": "Point", "coordinates": [102.0, 0.0]}\';\nmysql> SELECT ST_AsText(ST_GeomFromGeoJSON(@json));\n+--------------------------------------+\n| ST_AsText(ST_GeomFromGeoJSON(@json)) |\n+--------------------------------------+\n| POINT(102 0)                         |\n+--------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/spatial-geojson-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (574,5,'INSTALL PLUGIN','Syntax:\nINSTALL PLUGIN plugin_name SONAME \'shared_library_name\'\n\nThis statement installs a server plugin. It requires the INSERT\nprivilege for the mysql.plugin table.\n\nplugin_name is the name of the plugin as defined in the plugin\ndescriptor structure contained in the library file (see\nhttp://dev.mysql.com/doc/refman/5.7/en/plugin-data-structures.html).\nPlugin names are not case sensitive. For maximal compatibility, plugin\nnames should be limited to ASCII letters, digits, and underscore\nbecause they are used in C source files, shell command lines, M4 and\nBourne shell scripts, and SQL environments.\n\nshared_library_name is the name of the shared library that contains the\nplugin code. The name includes the file name extension (for example,\nlibmyplugin.so, libmyplugin.dll, or libmyplugin.dylib).\n\nThe shared library must be located in the plugin directory (the\ndirectory named by the plugin_dir system variable). The library must be\nin the plugin directory itself, not in a subdirectory. By default,\nplugin_dir is the plugin directory under the directory named by the\npkglibdir configuration variable, but it can be changed by setting the\nvalue of plugin_dir at server startup. For example, set its value in a\nmy.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\n\nIf the value of plugin_dir is a relative path name, it is taken to be\nrelative to the MySQL base directory (the value of the basedir system\nvariable).\n\nINSTALL PLUGIN loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its\ninitialization function, which handles any setup that the plugin must\nperform before it can be used. When the server shuts down, it executes\nthe deinitialization function for each plugin that is loaded so that\nthe plugin has a chance to perform any final cleanup.\n\nINSTALL PLUGIN also registers the plugin by adding a line that\nindicates the plugin name and library file name to the mysql.plugin\ntable. At server startup, the server loads and initializes any plugin\nthat is listed in the mysql.plugin table. This means that a plugin is\ninstalled with INSTALL PLUGIN only once, not every time the server\nstarts. Plugin loading at startup does not occur if the server is\nstarted with the --skip-grant-tables option.\n\nA plugin library can contain multiple plugins. For each of them to be\ninstalled, use a separate INSTALL PLUGIN statement. Each statement\nnames a different plugin, but all of them specify the same library\nname.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/install-plugin.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/install-plugin.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (575,24,'DECLARE CURSOR','Syntax:\nDECLARE cursor_name CURSOR FOR select_statement\n\nThis statement declares a cursor and associates it with a SELECT\nstatement that retrieves the rows to be traversed by the cursor. To\nfetch the rows later, use a FETCH statement. The number of columns\nretrieved by the SELECT statement must match the number of output\nvariables specified in the FETCH statement.\n\nThe SELECT statement cannot have an INTO clause.\n\nCursor declarations must appear before handler declarations and after\nvariable and condition declarations.\n\nA stored program may contain multiple cursor declarations, but each\ncursor declared in a given block must have a unique name. For an\nexample, see http://dev.mysql.com/doc/refman/5.7/en/cursors.html.\n\nFor information available through SHOW statements, it is possible in\nmany cases to obtain equivalent information by using a cursor with an\nINFORMATION_SCHEMA table.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/declare-cursor.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/declare-cursor.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (576,28,'LOAD DATA','Syntax:\nLOAD DATA [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE \'file_name\'\n    [REPLACE | IGNORE]\n    INTO TABLE tbl_name\n    [PARTITION (partition_name,...)]\n    [CHARACTER SET charset_name]\n    [{FIELDS | COLUMNS}\n        [TERMINATED BY \'string\']\n        [[OPTIONALLY] ENCLOSED BY \'char\']\n        [ESCAPED BY \'char\']\n    ]\n    [LINES\n        [STARTING BY \'string\']\n        [TERMINATED BY \'string\']\n    ]\n    [IGNORE number {LINES | ROWS}]\n    [(col_name_or_user_var,...)]\n    [SET col_name = expr,...]\n\nThe LOAD DATA INFILE statement reads rows from a text file into a table\nat a very high speed. LOAD DATA INFILE is the complement of SELECT ...\nINTO OUTFILE. (See\nhttp://dev.mysql.com/doc/refman/5.7/en/select-into.html.) To write data\nfrom a table to a file, use SELECT ... INTO OUTFILE. To read the file\nback into a table, use LOAD DATA INFILE. The syntax of the FIELDS and\nLINES clauses is the same for both statements. Both clauses are\noptional, but FIELDS must precede LINES if both are specified.\n\nYou can also load data files by using the mysqlimport utility; it\noperates by sending a LOAD DATA INFILE statement to the server. The\n--local option causes mysqlimport to read data files from the client\nhost. You can specify the --compress option to get better performance\nover slow networks if the client and server support the compressed\nprotocol. See http://dev.mysql.com/doc/refman/5.7/en/mysqlimport.html.\n\nFor more information about the efficiency of INSERT versus LOAD DATA\nINFILE and speeding up LOAD DATA INFILE, see\nhttp://dev.mysql.com/doc/refman/5.7/en/insert-speed.html.\n\nThe file name must be given as a literal string. On Windows, specify\nbackslashes in path names as forward slashes or doubled backslashes.\nThe character_set_filesystem system variable controls the\ninterpretation of the file name.\n\nLOAD DATA supports explicit partition selection using the PARTITION\noption with a comma-separated list of one or more names of partitions,\nsubpartitions, or both. When this option is used, if any rows from the\nfile cannot be inserted into any of the partitions or subpartitions\nnamed in the list, the statement fails with the error Found a row not\nmatching the given partition set. For more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/partitioning-selection.html.\n\nFor partitioned tables using storage engines that employ table locks,\nsuch as MyISAM, LOAD DATA cannot prune any partition locks. This does\nnot apply to tables using storage engines which employ row-level\nlocking, such as InnoDB. For more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/partitioning-limitations-locking\n.html.\n\nThe server uses the character set indicated by the\ncharacter_set_database system variable to interpret the information in\nthe file. SET NAMES and the setting of character_set_client do not\naffect interpretation of input. If the contents of the input file use a\ncharacter set that differs from the default, it is usually preferable\nto specify the character set of the file by using the CHARACTER SET\nclause. A character set of binary specifies "no conversion."\n\nLOAD DATA INFILE interprets all fields in the file as having the same\ncharacter set, regardless of the data types of the columns into which\nfield values are loaded. For proper interpretation of file contents,\nyou must ensure that it was written with the correct character set. For\nexample, if you write a data file with mysqldump -T or by issuing a\nSELECT ... INTO OUTFILE statement in mysql, be sure to use a\n--default-character-set option so that output is written in the\ncharacter set to be used when the file is loaded with LOAD DATA INFILE.\n\n*Note*: It is not possible to load data files that use the ucs2, utf16,\nutf16le, or utf32 character set.\n\nIf you use LOW_PRIORITY, execution of the LOAD DATA statement is\ndelayed until no other clients are reading from the table. This affects\nonly storage engines that use only table-level locking (such as MyISAM,\nMEMORY, and MERGE).\n\nIf you specify CONCURRENT with a MyISAM table that satisfies the\ncondition for concurrent inserts (that is, it contains no free blocks\nin the middle), other threads can retrieve data from the table while\nLOAD DATA is executing. This option affects the performance of LOAD\nDATA a bit, even if no other thread is using the table at the same\ntime.\n\nWith row-based replication, CONCURRENT is replicated regardless of\nMySQL version. With statement-based replication CONCURRENT is not\nreplicated prior to MySQL 5.5.1 (see Bug #34628). For more information,\nsee\nhttp://dev.mysql.com/doc/refman/5.7/en/replication-features-load-data.h\ntml.\n\nThe LOCAL keyword affects expected location of the file and error\nhandling, as described later. LOCAL works only if your server and your\nclient both have been configured to permit it. For example, if mysqld\nwas started with --local-infile=0, LOCAL does not work. See\nhttp://dev.mysql.com/doc/refman/5.7/en/load-data-local.html.\n\nThe LOCAL keyword affects where the file is expected to be found:\n\no If LOCAL is specified, the file is read by the client program on the\n  client host and sent to the server. The file can be given as a full\n  path name to specify its exact location. If given as a relative path\n  name, the name is interpreted relative to the directory in which the\n  client program was started.\n\n  When using LOCAL with LOAD DATA, a copy of the file is created in the\n  server\'s temporary directory. This is not the directory determined by\n  the value of tmpdir or slave_load_tmpdir, but rather the operating\n  system\'s temporary directory, and is not configurable in the MySQL\n  Server. (Typically the system temporary directory is /tmp on Linux\n  systems and C:\\WINDOWS\\TEMP on Windows.) Lack of sufficient space for\n  the copy in this directory can cause the LOAD DATA LOCAL statement to\n  fail.\n\no If LOCAL is not specified, the file must be located on the server\n  host and is read directly by the server. The server uses the\n  following rules to locate the file:\n\n  o If the file name is an absolute path name, the server uses it as\n    given.\n\n  o If the file name is a relative path name with one or more leading\n    components, the server searches for the file relative to the\n    server\'s data directory.\n\n  o If a file name with no leading components is given, the server\n    looks for the file in the database directory of the default\n    database.\n\nIn the non-LOCAL case, these rules mean that a file named as\n./myfile.txt is read from the server\'s data directory, whereas the file\nnamed as myfile.txt is read from the database directory of the default\ndatabase. For example, if db1 is the default database, the following\nLOAD DATA statement reads the file data.txt from the database directory\nfor db1, even though the statement explicitly loads the file into a\ntable in the db2 database:\n\nLOAD DATA INFILE \'data.txt\' INTO TABLE db2.my_table;\n\nFor security reasons, when reading text files located on the server,\nthe files must either reside in the database directory or be readable\nby the user account used to run the server. Also, to use LOAD DATA\nINFILE on server files, you must have the FILE privilege. See\nhttp://dev.mysql.com/doc/refman/5.7/en/privileges-provided.html. For\nnon-LOCAL load operations, if the secure_file_priv system variable is\nset to a nonempty directory name, the file to be loaded must be located\nin that directory.\n\nUsing LOCAL is a bit slower than letting the server access the files\ndirectly, because the contents of the file must be sent over the\nconnection by the client to the server. On the other hand, you do not\nneed the FILE privilege to load local files.\n\nLOCAL also affects error handling:\n\no With LOAD DATA INFILE, data-interpretation and duplicate-key errors\n  terminate the operation.\n\no With LOAD DATA LOCAL INFILE, data-interpretation and duplicate-key\n  errors become warnings and the operation continues because the server\n  has no way to stop transmission of the file in the middle of the\n  operation. For duplicate-key errors, this is the same as if IGNORE is\n  specified. IGNORE is explained further later in this section.\n\nThe REPLACE and IGNORE keywords control handling of input rows that\nduplicate existing rows on unique key values:\n\no If you specify REPLACE, input rows replace existing rows. In other\n  words, rows that have the same value for a primary key or unique\n  index as an existing row. See [HELP REPLACE].\n\no If you specify IGNORE, rows that duplicate an existing row on a\n  unique key value are discarded. For more information, see\n  http://dev.mysql.com/doc/refman/5.7/en/sql-mode.html#ignore-strict-co\n  mparison.\n\no If you do not specify either option, the behavior depends on whether\n  the LOCAL keyword is specified. Without LOCAL, an error occurs when a\n  duplicate key value is found, and the rest of the text file is\n  ignored. With LOCAL, the default behavior is the same as if IGNORE is\n  specified; this is because the server has no way to stop transmission\n  of the file in the middle of the operation.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/load-data.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/load-data.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (577,32,'LOCALTIME','Syntax:\nLOCALTIME, LOCALTIME([fsp])\n\nLOCALTIME and LOCALTIME() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (578,33,'ST_GEOMFROMWKB','ST_GeomFromWKB(wkb[,srid]), ST_GeometryFromWKB(wkb[,srid])\n\nConstructs a geometry value of any type using its WKB representation\nand SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (579,12,'SHA1','Syntax:\nSHA1(str), SHA(str)\n\nCalculates an SHA-1 160-bit checksum for the string, as described in\nRFC 3174 (Secure Hash Algorithm). The value is returned as a string of\n40 hex digits, or NULL if the argument was NULL. One of the possible\nuses for this function is as a hash key. See the notes at the beginning\nof this section about storing hash values efficiently. You can also use\nSHA1() as a cryptographic function for storing passwords. SHA() is\nsynonymous with SHA1().\n\nThe return value is a nonbinary string in the connection character set.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','mysql> SELECT SHA1(\'abc\');\n        -> \'a9993e364706816aba3e25717850c26c9cd0d89d\'\n','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (580,23,'BLOB','BLOB[(M)]\n\nA BLOB column with a maximum length of 65,535 (216 − 1) bytes. Each\nBLOB value is stored using a 2-byte length prefix that indicates the\nnumber of bytes in the value.\n\nAn optional length M can be given for this type. If this is done, MySQL\ncreates the column as the smallest BLOB type large enough to hold\nvalues M bytes long.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (581,12,'PASSWORD','Syntax:\nPASSWORD(str)\n\n*Note*: This function is deprecated as of MySQL 5.7.6 and will be\nremoved in a future MySQL release.\n\nReturns a hashed password string calculated from the cleartext password\nstr. The return value is a nonbinary string in the connection character\nset, or NULL if the argument is NULL. This function is the SQL\ninterface to the algorithm used by the server to encrypt MySQL\npasswords for storage in the mysql.user grant table.\n\nThe old_passwords system variable controls the password hashing method\nused by the PASSWORD() function. It also influences password hashing\nperformed by CREATE USER and GRANT statements that specify a password\nusing an IDENTIFIED BY clause.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','mysql> SET old_passwords = 0;\nmysql> SELECT PASSWORD(\'mypass\'), OLD_PASSWORD(\'mypass\');\n+-------------------------------------------+------------------------+\n| PASSWORD(\'mypass\')                        | OLD_PASSWORD(\'mypass\') |\n+-------------------------------------------+------------------------+\n| *6C8989366EAF75BB670AD8EA7A7FC1176A95CEF4 | 6f8c114b58f2ce9e       |\n+-------------------------------------------+------------------------+\n\nmysql> SET old_passwords = 1;\nmysql> SELECT PASSWORD(\'mypass\'), OLD_PASSWORD(\'mypass\');\n+--------------------+------------------------+\n| PASSWORD(\'mypass\') | OLD_PASSWORD(\'mypass\') |\n+--------------------+------------------------+\n| 6f8c114b58f2ce9e   | 6f8c114b58f2ce9e       |\n+--------------------+------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (582,32,'UTC_DATE','Syntax:\nUTC_DATE, UTC_DATE()\n\nReturns the current UTC date as a value in \'YYYY-MM-DD\' or YYYYMMDD\nformat, depending on whether the function is used in a string or\nnumeric context.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_DATE(), UTC_DATE() + 0;\n        -> \'2003-08-14\', 20030814\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (583,37,'DIMENSION','Dimension(g)\n\nST_Dimension() and Dimension() are synonyms. For more information, see\nthe description of ST_Dimension().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (584,23,'BIT','BIT[(M)]\n\nA bit-field type. M indicates the number of bits per value, from 1 to\n64. The default is 1 if M is omitted.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (585,8,'XA','Syntax:\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [CONVERT XID]\n\nFor XA START, the JOIN and RESUME clauses are not supported.\n\nFor XA END the SUSPEND [FOR MIGRATE] clause is not supported.\n\nEach XA statement begins with the XA keyword, and most of them require\nan xid value. An xid is an XA transaction identifier. It indicates\nwhich transaction the statement applies to. xid values are supplied by\nthe client, or generated by the MySQL server. An xid value has from one\nto three parts:\n\nxid: gtrid [, bqual [, formatID ]]\n\ngtrid is a global transaction identifier, bqual is a branch qualifier,\nand formatID is a number that identifies the format used by the gtrid\nand bqual values. As indicated by the syntax, bqual and formatID are\noptional. The default bqual value is \'\' if not given. The default\nformatID value is 1 if not given.\n\ngtrid and bqual must be string literals, each up to 64 bytes (not\ncharacters) long. gtrid and bqual can be specified in several ways. You\ncan use a quoted string (\'ab\'), hex string (X\'6162\', 0x6162), or bit\nvalue (b\'nnnn\').\n\nformatID is an unsigned integer.\n\nThe gtrid and bqual values are interpreted in bytes by the MySQL\nserver\'s underlying XA support routines. However, while an SQL\nstatement containing an XA statement is being parsed, the server works\nwith some specific character set. To be safe, write gtrid and bqual as\nhex strings.\n\nxid values typically are generated by the Transaction Manager. Values\ngenerated by one TM must be different from values generated by other\nTMs. A given TM must be able to recognize its own xid values in a list\nof values returned by the XA RECOVER statement.\n\nFor XA START xid starts an XA transaction with the given xid value.\nEach XA transaction must have a unique xid value, so the value must not\ncurrently be used by another XA transaction. Uniqueness is assessed\nusing the gtrid and bqual values. All following XA statements for the\nXA transaction must be specified using the same xid value as that given\nin the XA START statement. If you use any of those statements but\nspecify an xid value that does not correspond to some existing XA\ntransaction, an error occurs.\n\nOne or more XA transactions can be part of the same global transaction.\nAll XA transactions within a given global transaction must use the same\ngtrid value in the xid value. For this reason, gtrid values must be\nglobally unique so that there is no ambiguity about which global\ntransaction a given XA transaction is part of. The bqual part of the\nxid value must be different for each XA transaction within a global\ntransaction. (The requirement that bqual values be different is a\nlimitation of the current MySQL XA implementation. It is not part of\nthe XA specification.)\n\nThe XA RECOVER statement returns information for those XA transactions\non the MySQL server that are in the PREPARED state. (See\nhttp://dev.mysql.com/doc/refman/5.7/en/xa-states.html.) The output\nincludes a row for each such XA transaction on the server, regardless\nof which client started it.\n\nXA RECOVER output rows look like this (for an example xid value\nconsisting of the parts \'abc\', \'def\', and 7):\n\nmysql> XA RECOVER;\n+----------+--------------+--------------+--------+\n| formatID | gtrid_length | bqual_length | data   |\n+----------+--------------+--------------+--------+\n|        7 |            3 |            3 | abcdef |\n+----------+--------------+--------------+--------+\n\nThe output columns have the following meanings:\n\no formatID is the formatID part of the transaction xid\n\no gtrid_length is the length in bytes of the gtrid part of the xid\n\no bqual_length is the length in bytes of the bqual part of the xid\n\no data is the concatenation of the gtrid and bqual parts of the xid\n\nXID values may contain nonprintable characters. As of MySQL 5.7.5, XA\nRECOVER permits an optional CONVERT XID clause so that clients can\nrequest XID values in hexadecimal.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/xa-statements.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/xa-statements.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (586,31,'EQUALS','Equals(g1,g2)\n\nMBREquals() and Equals() are synonyms. For more information, see the\ndescription of MBREquals().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (587,2,'CENTROID','Centroid(mpoly)\n\nST_Centroid() and Centroid() are synonyms. For more information, see\nthe description of ST_Centroid().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (588,38,'OCTET_LENGTH','Syntax:\nOCTET_LENGTH(str)\n\nOCTET_LENGTH() is a synonym for LENGTH().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (589,32,'UTC_TIMESTAMP','Syntax:\nUTC_TIMESTAMP, UTC_TIMESTAMP([fsp])\n\nReturns the current UTC date and time as a value in \'YYYY-MM-DD\nHH:MM:SS\' or YYYYMMDDHHMMSS format, depending on whether the function\nis used in a string or numeric context.\n\nIf the fsp argument is given to specify a fractional seconds precision\nfrom 0 to 6, the return value includes a fractional seconds part of\nthat many digits.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_TIMESTAMP(), UTC_TIMESTAMP() + 0;\n        -> \'2003-08-14 18:08:04\', 20030814180804.000000\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (590,12,'AES_ENCRYPT','Syntax:\nAES_ENCRYPT(str,key_str[,init_vector])\n\nAES_ENCRYPT() and AES_DECRYPT() implement encryption and decryption of\ndata using the official AES (Advanced Encryption Standard) algorithm,\npreviously known as "Rijndael." The AES standard permits various key\nlengths. By default these functions implement AES with a 128-bit key\nlength. As of MySQL 5.7.4, key lengths of 196 or 256 bits can be used,\nas described later. The key length is a trade off between performance\nand security.\n\nAES_ENCRYPT() encrypts the string str using the key string key_str and\nreturns a binary string containing the encrypted output. AES_DECRYPT()\ndecrypts the encrypted string crypt_str using the key string key_str\nand returns the original cleartext string. If either function argument\nis NULL, the function returns NULL.\n\nThe str and crypt_str arguments can be any length, and padding is\nautomatically added to str so it is a multiple of a block as required\nby block-based algorithms such as AES. This padding is automatically\nremoved by the AES_DECRYPT() function. The length of crypt_str can be\ncalculated using this formula:\n\n16 * (trunc(string_length / 16) + 1)\n\nFor a key length of 128 bits, the most secure way to pass a key to the\nkey_str argument is to create a truly random 128-bit value and pass it\nas a binary value. For example:\n\nINSERT INTO t\nVALUES (1,AES_ENCRYPT(\'text\',UNHEX(\'F3229A0B371ED2D9441B830D21A390C3\')));\n\nA passphrase can be used to generate an AES key by hashing the\npassphrase. For example:\n\nINSERT INTO t\nVALUES (1,AES_ENCRYPT(\'text\', UNHEX(SHA2(\'My secret passphrase\',512))));\n\nDo not pass a password or passphrase directly to crypt_str, hash it\nfirst. Previous versions of this documentation suggested the former\napproach, but it is no longer recommended as the examples shown here\nare more secure.\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns\nNULL. However, it is possible for AES_DECRYPT() to return a non-NULL\nvalue (possibly garbage) if the input data or the key is invalid.\n\nAs of MySQL 5.7.4, AES_ENCRYPT() and AES_DECRYPT() permit control of\nthe block encryption mode and take an optional init_vector\ninitialization vector argument:\n\no The block_encryption_mode system variable controls the mode for\n  block-based encryption algorithms. Its default value is aes-128-ecb,\n  which signifies encryption using a key length of 128 bits and ECB\n  mode. For a description of the permitted values of this variable, see\n  http://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html.\n\no The optional init_vector argument provides an initialization vector\n  for block encryption modes that require it.\n\nFor modes that require the optional init_vector argument, it must be 16\nbytes or longer (bytes in excess of 16 are ignored). An error occurs if\ninit_vector is missing.\n\nFor modes that do not require init_vector, it is ignored and a warning\nis generated if it is specified.\n\nA random string of bytes to use for the initialization vector can be\nproduced by calling RANDOM_BYTES(16). For encryption modes that require\nan initialization vector, the same vector must be used for encryption\nand decryption.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html\n\n','mysql> SET block_encryption_mode = \'aes-256-cbc\';\nmysql> SET @key_str = SHA2(\'My secret passphrase\',512);\nmysql> SET @init_vector = RANDOM_BYTES(16);\nmysql> SET @crypt_str = AES_ENCRYPT(\'text\',@key_str,@init_vector);\nmysql> SELECT AES_DECRYPT(@crypt_str,@key_str,@init_vector);\n+-----------------------------------------------+\n| AES_DECRYPT(@crypt_str,@key_str,@init_vector) |\n+-----------------------------------------------+\n| text                                          |\n+-----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (591,3,'+','Syntax:\n+\n\nAddition:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html\n\n','mysql> SELECT 3+5;\n        -> 8\n','http://dev.mysql.com/doc/refman/5.7/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (592,7,'GTID_SUBTRACT','Syntax:\nGTID_SUBTRACT(set,subset)\n\nGiven two sets of global transaction IDs subset and set, returns only\nthose GTIDs from set that are not in subset.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gtid-functions.html\n\n','mysql> SELECT GTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\', \n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21\')\\G\n*************************** 1. row ***************************\nGTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\', \n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21\'): 3e11fa47-71ca-11e1-9e33-c80aa9429562:22-57\n1 row in set (0.00 sec)\n\nmysql> SELECT GTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\', \n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\')\\G\n*************************** 1. row ***************************\nGTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\', \n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\'): 3e11fa47-71ca-11e1-9e33-c80aa9429562:26-57\n1 row in set (0.00 sec)\n\nmysql> SELECT GTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\', \n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-24\')\\G\n*************************** 1. row ***************************\nGTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\', \n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-24\'): 3e11fa47-71ca-11e1-9e33-c80aa9429562:21-22:25-57\n1 row in set (0.01 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/gtid-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (593,14,'INET_NTOA','Syntax:\nINET_NTOA(expr)\n\nGiven a numeric IPv4 network address in network byte order, returns the\ndotted-quad string representation of the address as a nonbinary string\nin the connection character set. INET_NTOA() returns NULL if it does\nnot understand its argument.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> SELECT INET_NTOA(167773449);\n        -> \'10.0.5.9\'\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (594,32,'DAYOFWEEK','Syntax:\nDAYOFWEEK(date)\n\nReturns the weekday index for date (1 = Sunday, 2 = Monday, ..., 7 =\nSaturday). These index values correspond to the ODBC standard.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFWEEK(\'2007-02-03\');\n        -> 7\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (595,3,'CEILING','Syntax:\nCEILING(X)\n\nReturns the smallest integer value not less than X.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT CEILING(1.23);\n        -> 2\nmysql> SELECT CEILING(-1.23);\n        -> -1\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (596,27,'SHOW PROCESSLIST','Syntax:\nSHOW [FULL] PROCESSLIST\n\nSHOW PROCESSLIST shows you which threads are running. You can also get\nthis information from the INFORMATION_SCHEMA PROCESSLIST table or the\nmysqladmin processlist command. If you have the PROCESS privilege, you\ncan see all threads. Otherwise, you can see only your own threads (that\nis, threads associated with the MySQL account that you are using). If\nyou do not use the FULL keyword, only the first 100 characters of each\nstatement are shown in the Info field.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-processlist.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-processlist.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (597,33,'LINEFROMWKB','LineFromWKB(wkb[,srid]), LineStringFromWKB(wkb[,srid])\n\nST_LineFromWKB(), ST_LineStringFromWKB(), LineFromWKB(), and\nLineStringFromWKB() are synonyms. For more information, see the\ndescription of ST_LineFromWKB().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (598,37,'GEOMETRYTYPE','GeometryType(g)\n\nST_GeometryType() and GeometryType() are synonyms. For more\ninformation, see the description of ST_GeometryType().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (599,40,'CREATE VIEW','Syntax:\nCREATE\n    [OR REPLACE]\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n    [DEFINER = { user | CURRENT_USER }]\n    [SQL SECURITY { DEFINER | INVOKER }]\n    VIEW view_name [(column_list)]\n    AS select_statement\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nThe CREATE VIEW statement creates a new view, or replaces an existing\nview if the OR REPLACE clause is given. If the view does not exist,\nCREATE OR REPLACE VIEW is the same as CREATE VIEW. If the view does\nexist, CREATE OR REPLACE VIEW is the same as ALTER VIEW.\n\nThe select_statement is a SELECT statement that provides the definition\nof the view. (Selecting from the view selects, in effect, using the\nSELECT statement.) The select_statement can select from base tables or\nother views.\n\nThe view definition is "frozen" at creation time and is not affected by\nsubsequent changes to the definitions of the underlying tables. For\nexample, if a view is defined as SELECT * on a table, new columns added\nto the table later do not become part of the view, and columns dropped\nfrom the table will result in an error when selecting from the view.\n\nThe ALGORITHM clause affects how MySQL processes the view. The DEFINER\nand SQL SECURITY clauses specify the security context to be used when\nchecking access privileges at view invocation time. The WITH CHECK\nOPTION clause can be given to constrain inserts or updates to rows in\ntables referenced by the view. These clauses are described later in\nthis section.\n\nThe CREATE VIEW statement requires the CREATE VIEW privilege for the\nview, and some privilege for each column selected by the SELECT\nstatement. For columns used elsewhere in the SELECT statement, you must\nhave the SELECT privilege. If the OR REPLACE clause is present, you\nmust also have the DROP privilege for the view. CREATE VIEW might also\nrequire the SUPER privilege, depending on the DEFINER value, as\ndescribed later in this section.\n\nWhen a view is referenced, privilege checking occurs as described later\nin this section.\n\nA view belongs to a database. By default, a new view is created in the\ndefault database. To create the view explicitly in a given database,\nuse db_name.view_name syntax to qualify the view name with the database\nname:\n\nmysql> CREATE VIEW test.v AS SELECT * FROM t;\n\nWithin a database, base tables and views share the same namespace, so a\nbase table and a view cannot have the same name.\n\nColumns retrieved by the SELECT statement can be simple references to\ntable columns, or expressions that use functions, constant values,\noperators, and so forth.\n\nA view must have unique column names with no duplicates, just like a\nbase table. By default, the names of the columns retrieved by the\nSELECT statement are used for the view column names. To define explicit\nnames for the view columns, the optional column_list clause can be\ngiven as a list of comma-separated identifiers. The number of names in\ncolumn_list must be the same as the number of columns retrieved by the\nSELECT statement.\n\nUnqualified table or view names in the SELECT statement are interpreted\nwith respect to the default database. A view can refer to tables or\nviews in other databases by qualifying the table or view name with the\nappropriate database name.\n\nA view can be created from many kinds of SELECT statements. It can\nrefer to base tables or other views. It can use joins, UNION, and\nsubqueries. The SELECT need not even refer to any tables.\n\nThe following example defines a view that selects two columns from\nanother table as well as an expression calculated from those columns:\n\nmysql> CREATE TABLE t (qty INT, price INT);\nmysql> INSERT INTO t VALUES(3, 50);\nmysql> CREATE VIEW v AS SELECT qty, price, qty*price AS value FROM t;\nmysql> SELECT * FROM v;\n+------+-------+-------+\n| qty  | price | value |\n+------+-------+-------+\n|    3 |    50 |   150 |\n+------+-------+-------+\n\nA view definition is subject to the following restrictions:\n\no Before MySQL 5.7.7, the SELECT statement cannot contain a subquery in\n  the FROM clause.\n\no The SELECT statement cannot refer to system variables or user-defined\n  variables.\n\no Within a stored program, the SELECT statement cannot refer to program\n  parameters or local variables.\n\no The SELECT statement cannot refer to prepared statement parameters.\n\no Any table or view referred to in the definition must exist. After the\n  view has been created, it is possible to drop a table or view that\n  the definition refers to. In this case, use of the view results in an\n  error. To check a view definition for problems of this kind, use the\n  CHECK TABLE statement.\n\no The definition cannot refer to a TEMPORARY table, and you cannot\n  create a TEMPORARY view.\n\no You cannot associate a trigger with a view.\n\no Aliases for column names in the SELECT statement are checked against\n  the maximum column length of 64 characters (not the maximum alias\n  length of 256 characters).\n\nORDER BY is permitted in a view definition, but it is ignored if you\nselect from a view using a statement that has its own ORDER BY.\n\nFor other options or clauses in the definition, they are added to the\noptions or clauses of the statement that references the view, but the\neffect is undefined. For example, if a view definition includes a LIMIT\nclause, and you select from the view using a statement that has its own\nLIMIT clause, it is undefined which limit applies. This same principle\napplies to options such as ALL, DISTINCT, or SQL_SMALL_RESULT that\nfollow the SELECT keyword, and to clauses such as INTO, FOR UPDATE,\nLOCK IN SHARE MODE, and PROCEDURE.\n\nIf you create a view and then change the query processing environment\nby changing system variables, that may affect the results you get from\nthe view:\n\nmysql> CREATE VIEW v (mycol) AS SELECT \'abc\';\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> SET sql_mode = \'\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT "mycol" FROM v;\n+-------+\n| mycol |\n+-------+\n| mycol |\n+-------+\n1 row in set (0.01 sec)\n\nmysql> SET sql_mode = \'ANSI_QUOTES\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT "mycol" FROM v;\n+-------+\n| mycol |\n+-------+\n| abc   |\n+-------+\n1 row in set (0.00 sec)\n\nThe DEFINER and SQL SECURITY clauses determine which MySQL account to\nuse when checking access privileges for the view when a statement is\nexecuted that references the view. The valid SQL SECURITY\ncharacteristic values are DEFINER (the default) and INVOKER. These\nindicate that the required privileges must be held by the user who\ndefined or invoked the view, respectively.\n\nIf a user value is given for the DEFINER clause, it should be a MySQL\naccount specified as \'user_name\'@\'host_name\' (the same format used in\nthe GRANT statement), CURRENT_USER, or CURRENT_USER(). The default\nDEFINER value is the user who executes the CREATE VIEW statement. This\nis the same as specifying DEFINER = CURRENT_USER explicitly.\n\nIf you specify the DEFINER clause, these rules determine the valid\nDEFINER user values:\n\no If you do not have the SUPER privilege, the only valid user value is\n  your own account, either specified literally or by using\n  CURRENT_USER. You cannot set the definer to some other account.\n\no If you have the SUPER privilege, you can specify any syntactically\n  valid account name. If the account does not exist, a warning is\n  generated.\n\no Although it is possible to create a view with a nonexistent DEFINER\n  account, an error occurs when the view is referenced if the SQL\n  SECURITY value is DEFINER but the definer account does not exist.\n\nFor more information about view security, see\nhttp://dev.mysql.com/doc/refman/5.7/en/stored-programs-security.html.\n\nWithin a view definition, CURRENT_USER returns the view\'s DEFINER value\nby default. For views defined with the SQL SECURITY INVOKER\ncharacteristic, CURRENT_USER returns the account for the view\'s\ninvoker. For information about user auditing within views, see\nhttp://dev.mysql.com/doc/refman/5.7/en/account-activity-auditing.html.\n\nWithin a stored routine that is defined with the SQL SECURITY DEFINER\ncharacteristic, CURRENT_USER returns the routine\'s DEFINER value. This\nalso affects a view defined within such a routine, if the view\ndefinition contains a DEFINER value of CURRENT_USER.\n\nMySQL checks view privileges like this:\n\no At view definition time, the view creator must have the privileges\n  needed to use the top-level objects accessed by the view. For\n  example, if the view definition refers to table columns, the creator\n  must have some privilege for each column in the select list of the\n  definition, and the SELECT privilege for each column used elsewhere\n  in the definition. If the definition refers to a stored function,\n  only the privileges needed to invoke the function can be checked. The\n  privileges required at function invocation time can be checked only\n  as it executes: For different invocations, different execution paths\n  within the function might be taken.\n\no The user who references a view must have appropriate privileges to\n  access it (SELECT to select from it, INSERT to insert into it, and so\n  forth.)\n\no When a view has been referenced, privileges for objects accessed by\n  the view are checked against the privileges held by the view DEFINER\n  account or invoker, depending on whether the SQL SECURITY\n  characteristic is DEFINER or INVOKER, respectively.\n\no If reference to a view causes execution of a stored function,\n  privilege checking for statements executed within the function depend\n  on whether the function SQL SECURITY characteristic is DEFINER or\n  INVOKER. If the security characteristic is DEFINER, the function runs\n  with the privileges of the DEFINER account. If the characteristic is\n  INVOKER, the function runs with the privileges determined by the\n  view\'s SQL SECURITY characteristic.\n\nExample: A view might depend on a stored function, and that function\nmight invoke other stored routines. For example, the following view\ninvokes a stored function f():\n\nCREATE VIEW v AS SELECT * FROM t WHERE t.id = f(t.name);\n\nSuppose that f() contains a statement such as this:\n\nIF name IS NULL then\n  CALL p1();\nELSE\n  CALL p2();\nEND IF;\n\nThe privileges required for executing statements within f() need to be\nchecked when f() executes. This might mean that privileges are needed\nfor p1() or p2(), depending on the execution path within f(). Those\nprivileges must be checked at runtime, and the user who must possess\nthe privileges is determined by the SQL SECURITY values of the view v\nand the function f().\n\nThe DEFINER and SQL SECURITY clauses for views are extensions to\nstandard SQL. In standard SQL, views are handled using the rules for\nSQL SECURITY DEFINER. The standard says that the definer of the view,\nwhich is the same as the owner of the view\'s schema, gets applicable\nprivileges on the view (for example, SELECT) and may grant them. MySQL\nhas no concept of a schema "owner", so MySQL adds a clause to identify\nthe definer. The DEFINER clause is an extension where the intent is to\nhave what the standard has; that is, a permanent record of who defined\nthe view. This is why the default DEFINER value is the account of the\nview creator.\n\nThe optional ALGORITHM clause is a MySQL extension to standard SQL. It\naffects how MySQL processes the view. ALGORITHM takes three values:\nMERGE, TEMPTABLE, or UNDEFINED. For more information, see\nhttp://dev.mysql.com/doc/refman/5.7/en/view-algorithms.html.\n\nSome views are updatable. That is, you can use them in statements such\nas UPDATE, DELETE, or INSERT to update the contents of the underlying\ntable. For a view to be updatable, there must be a one-to-one\nrelationship between the rows in the view and the rows in the\nunderlying table. There are also certain other constructs that make a\nview nonupdatable.\n\nA generated column in a view is considered updatable because it is\npossible to assign to it. However, if such a column is updated\nexplicitly, the only permitted value is DEFAULT. For information about\ngenerated columns, see\nhttp://dev.mysql.com/doc/refman/5.7/en/create-table-generated-columns.h\ntml.\n\nThe WITH CHECK OPTION clause can be given for an updatable view to\nprevent inserts or updates to rows except those for which the WHERE\nclause in the select_statement is true.\n\nIn a WITH CHECK OPTION clause for an updatable view, the LOCAL and\nCASCADED keywords determine the scope of check testing when the view is\ndefined in terms of another view. The LOCAL keyword restricts the CHECK\nOPTION only to the view being defined. CASCADED causes the checks for\nunderlying views to be evaluated as well. When neither keyword is\ngiven, the default is CASCADED.\n\nFor more information about updatable views and the WITH CHECK OPTION\nclause, see\nhttp://dev.mysql.com/doc/refman/5.7/en/view-updatability.html, and\nhttp://dev.mysql.com/doc/refman/5.7/en/view-check-option.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-view.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/create-view.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (600,38,'TRIM','Syntax:\nTRIM([{BOTH | LEADING | TRAILING} [remstr] FROM] str), TRIM([remstr\nFROM] str)\n\nReturns the string str with all remstr prefixes or suffixes removed. If\nnone of the specifiers BOTH, LEADING, or TRAILING is given, BOTH is\nassumed. remstr is optional and, if not specified, spaces are removed.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT TRIM(\'  bar   \');\n        -> \'bar\'\nmysql> SELECT TRIM(LEADING \'x\' FROM \'xxxbarxxx\');\n        -> \'barxxx\'\nmysql> SELECT TRIM(BOTH \'x\' FROM \'xxxbarxxx\');\n        -> \'bar\'\nmysql> SELECT TRIM(TRAILING \'xyz\' FROM \'barxxyz\');\n        -> \'barx\'\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (601,14,'INET6_NTOA','Syntax:\nINET6_NTOA(expr)\n\nGiven an IPv6 or IPv4 network address represented in numeric form as a\nbinary string, returns the string representation of the address as a\nnonbinary string in the connection character set. If the argument is\nnot a valid address, INET6_NTOA() returns NULL.\n\nINET6_NTOA() has these properties:\n\no It does not use operating system functions to perform conversions,\n  thus the output string is platform independent.\n\no The return string has a maximum length of 39 (4 x 8 + 7). Given this\n  statement:\n\nCREATE TABLE t AS SELECT INET6_NTOA(expr) AS c1;\n\n  The resulting table would have this definition:\n\nCREATE TABLE t (c1 VARCHAR(39) CHARACTER SET utf8 DEFAULT NULL);\n\no The return string uses lowercase letters for IPv6 addresses.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html\n\n','mysql> SELECT INET6_NTOA(INET6_ATON(\'fdfe::5a55:caff:fefa:9089\'));\n        -> \'fdfe::5a55:caff:fefa:9089\'\nmysql> SELECT INET6_NTOA(INET6_ATON(\'10.0.5.9\'));\n        -> \'10.0.5.9\'\n\nmysql> SELECT INET6_NTOA(UNHEX(\'FDFE0000000000005A55CAFFFEFA9089\'));\n        -> \'fdfe::5a55:caff:fefa:9089\'\nmysql> SELECT INET6_NTOA(UNHEX(\'0A000509\'));\n        -> \'10.0.5.9\'\n','http://dev.mysql.com/doc/refman/5.7/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (602,24,'SIGNAL','Syntax:\nSIGNAL condition_value\n    [SET signal_information_item\n    [, signal_information_item] ...]\n\ncondition_value:\n    SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n\nsignal_information_item:\n    condition_information_item_name = simple_value_specification\n\ncondition_information_item_name:\n    CLASS_ORIGIN\n  | SUBCLASS_ORIGIN\n  | MESSAGE_TEXT\n  | MYSQL_ERRNO\n  | CONSTRAINT_CATALOG\n  | CONSTRAINT_SCHEMA\n  | CONSTRAINT_NAME\n  | CATALOG_NAME\n  | SCHEMA_NAME\n  | TABLE_NAME\n  | COLUMN_NAME\n  | CURSOR_NAME\n\ncondition_name, simple_value_specification:\n    (see following discussion)\n\nSIGNAL is the way to "return" an error. SIGNAL provides error\ninformation to a handler, to an outer portion of the application, or to\nthe client. Also, it provides control over the error\'s characteristics\n(error number, SQLSTATE value, message). Without SIGNAL, it is\nnecessary to resort to workarounds such as deliberately referring to a\nnonexistent table to cause a routine to return an error.\n\nNo special privileges are required to execute the SIGNAL statement.\n\nTo retrieve information from the diagnostics area, use the GET\nDIAGNOSTICS statement (see [HELP GET DIAGNOSTICS]). For information\nabout the diagnostics area, see\nhttp://dev.mysql.com/doc/refman/5.7/en/diagnostics-area.html.\n\nThe condition_value in a SIGNAL statement indicates the error value to\nbe returned. It can be an SQLSTATE value (a 5-character string literal)\nor a condition_name that refers to a named condition previously defined\nwith DECLARE ... CONDITION (see [HELP DECLARE CONDITION]).\n\nAn SQLSTATE value can indicate errors, warnings, or "not found." The\nfirst two characters of the value indicate its error class, as\ndiscussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/signal.html#signal-condition-inf\normation-items. Some signal values cause statement termination; see\nhttp://dev.mysql.com/doc/refman/5.7/en/signal.html#signal-effects.\n\nThe SQLSTATE value for a SIGNAL statement should not start with \'00\'\nbecause such values indicate success and are not valid for signaling an\nerror. This is true whether the SQLSTATE value is specified directly in\nthe SIGNAL statement or in a named condition referred to in the\nstatement. If the value is invalid, a Bad SQLSTATE error occurs.\n\nTo signal a generic SQLSTATE value, use \'45000\', which means "unhandled\nuser-defined exception."\n\nThe SIGNAL statement optionally includes a SET clause that contains\nmultiple signal items, in a comma-separated list of\ncondition_information_item_name = simple_value_specification\nassignments.\n\nEach condition_information_item_name may be specified only once in the\nSET clause. Otherwise, a Duplicate condition information item error\noccurs.\n\nValid simple_value_specification designators can be specified using\nstored procedure or function parameters, stored program local variables\ndeclared with DECLARE, user-defined variables, system variables, or\nliterals. A character literal may include a _charset introducer.\n\nFor information about permissible condition_information_item_name\nvalues, see\nhttp://dev.mysql.com/doc/refman/5.7/en/signal.html#signal-condition-inf\normation-items.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/signal.html\n\n','CREATE PROCEDURE p (pval INT)\nBEGIN\n  DECLARE specialty CONDITION FOR SQLSTATE \'45000\';\n  IF pval = 0 THEN\n    SIGNAL SQLSTATE \'01000\';\n  ELSEIF pval = 1 THEN\n    SIGNAL SQLSTATE \'45000\'\n      SET MESSAGE_TEXT = \'An error occurred\';\n  ELSEIF pval = 2 THEN\n    SIGNAL specialty\n      SET MESSAGE_TEXT = \'An error occurred\';\n  ELSE\n    SIGNAL SQLSTATE \'01000\'\n      SET MESSAGE_TEXT = \'A warning occurred\', MYSQL_ERRNO = 1000;\n    SIGNAL SQLSTATE \'45000\'\n      SET MESSAGE_TEXT = \'An error occurred\', MYSQL_ERRNO = 1001;\n  END IF;\nEND;\n','http://dev.mysql.com/doc/refman/5.7/en/signal.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (603,8,'SAVEPOINT','Syntax:\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT,\nRELEASE SAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/savepoint.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/savepoint.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (604,26,'ST_NUMGEOMETRIES','ST_NumGeometries(gc)\n\nReturns the number of geometries in the GeometryCollection value gc.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-geometrycollection-property-functions.html\n\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT ST_NumGeometries(ST_GeomFromText(@gc));\n+----------------------------------------+\n| ST_NumGeometries(ST_GeomFromText(@gc)) |\n+----------------------------------------+\n|                                      2 |\n+----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-geometrycollection-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (605,7,'JSON_DEPTH','JSON_DEPTH(json_doc)\n\nReturns the maximum depth of a JSON document. Returns NULL if the\nargument is NULL. An error occurs if the argument is not a valid JSON\ndocument.\n\nAn empty array, empty object, or scalar value has depth 1. A nonempty\narray containing only elements of depth 1 or nonempty object containing\nonly member values of depth 1 has depth 2. Otherwise, a JSON document\nhas depth greater than 2.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-attribute-functions.html\n\n','mysql> SELECT JSON_DEPTH(\'{}\'), JSON_DEPTH(\'[]\'), JSON_DEPTH(\'true\');\n+------------------+------------------+--------------------+\n| JSON_DEPTH(\'{}\') | JSON_DEPTH(\'[]\') | JSON_DEPTH(\'true\') |\n+------------------+------------------+--------------------+\n|                1 |                1 |                  1 |\n+------------------+------------------+--------------------+\nmysql> SELECT JSON_DEPTH(\'[10, 20]\'), JSON_DEPTH(\'[[], {}]\');\n+------------------------+------------------------+\n| JSON_DEPTH(\'[10, 20]\') | JSON_DEPTH(\'[[], {}]\') |\n+------------------------+------------------------+\n|                      2 |                      2 |\n+------------------------+------------------------+\nmysql> SELECT JSON_DEPTH(\'[10, {"a": 20}]\');\n+-------------------------------+\n| JSON_DEPTH(\'[10, {"a": 20}]\') |\n+-------------------------------+\n|                             3 |\n+-------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-attribute-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (606,24,'LABELS','Syntax:\n[begin_label:] BEGIN\n    [statement_list]\nEND [end_label]\n\n[begin_label:] LOOP\n    statement_list\nEND LOOP [end_label]\n\n[begin_label:] REPEAT\n    statement_list\nUNTIL search_condition\nEND REPEAT [end_label]\n\n[begin_label:] WHILE search_condition DO\n    statement_list\nEND WHILE [end_label]\n\nLabels are permitted for BEGIN ... END blocks and for the LOOP, REPEAT,\nand WHILE statements. Label use for those statements follows these\nrules:\n\no begin_label must be followed by a colon.\n\no begin_label can be given without end_label. If end_label is present,\n  it must be the same as begin_label.\n\no end_label cannot be given without begin_label.\n\no Labels at the same nesting level must be distinct.\n\no Labels can be up to 16 characters long.\n\nTo refer to a label within the labeled construct, use an ITERATE or\nLEAVE statement. The following example uses those statements to\ncontinue iterating or terminate the loop:\n\nCREATE PROCEDURE doiterate(p1 INT)\nBEGIN\n  label1: LOOP\n    SET p1 = p1 + 1;\n    IF p1 < 10 THEN ITERATE label1; END IF;\n    LEAVE label1;\n  END LOOP label1;\nEND;\n\nThe scope of a block label does not include the code for handlers\ndeclared within the block. For details, see [HELP DECLARE HANDLER].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/statement-labels.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/statement-labels.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (607,33,'MPOINTFROMWKB','MPointFromWKB(wkb[,srid]), MultiPointFromWKB(wkb[,srid])\n\nST_MPointFromWKB(), ST_MultiPointFromWKB(), MPointFromWKB(), and\nMultiPointFromWKB() are synonyms. For more information, see the\ndescription of ST_MPointFromWKB().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (608,40,'ALTER TABLE','Syntax:\nALTER [IGNORE] TABLE tbl_name\n    [alter_specification [, alter_specification] ...]\n    [partition_options]\n\nalter_specification:\n    table_options\n  | ADD [COLUMN] col_name column_definition\n        [FIRST | AFTER col_name ]\n  | ADD [COLUMN] (col_name column_definition,...)\n  | ADD {INDEX|KEY} [index_name]\n        [index_type] (index_col_name,...) [index_option] ...\n  | ADD [CONSTRAINT [symbol]] PRIMARY KEY\n        [index_type] (index_col_name,...) [index_option] ...\n  | ADD [CONSTRAINT [symbol]]\n        UNIQUE [INDEX|KEY] [index_name]\n        [index_type] (index_col_name,...) [index_option] ...\n  | ADD FULLTEXT [INDEX|KEY] [index_name]\n        (index_col_name,...) [index_option] ...\n  | ADD SPATIAL [INDEX|KEY] [index_name]\n        (index_col_name,...) [index_option] ...\n  | ADD [CONSTRAINT [symbol]]\n        FOREIGN KEY [index_name] (index_col_name,...)\n        reference_definition\n  | ALGORITHM [=] {DEFAULT|INPLACE|COPY}\n  | ALTER [COLUMN] col_name {SET DEFAULT literal | DROP DEFAULT}\n  | CHANGE [COLUMN] old_col_name new_col_name column_definition\n        [FIRST|AFTER col_name]\n  | LOCK [=] {DEFAULT|NONE|SHARED|EXCLUSIVE}\n  | MODIFY [COLUMN] col_name column_definition\n        [FIRST | AFTER col_name]\n  | DROP [COLUMN] col_name\n  | DROP PRIMARY KEY\n  | DROP {INDEX|KEY} index_name\n  | DROP FOREIGN KEY fk_symbol\n  | DISABLE KEYS\n  | ENABLE KEYS\n  | RENAME [TO|AS] new_tbl_name\n  | RENAME {INDEX|KEY} old_index_name TO new_index_name\n  | ORDER BY col_name [, col_name] ...\n  | CONVERT TO CHARACTER SET charset_name [COLLATE collation_name]\n  | [DEFAULT] CHARACTER SET [=] charset_name [COLLATE [=] collation_name]\n  | DISCARD TABLESPACE\n  | IMPORT TABLESPACE\n  | FORCE\n  | {WITHOUT|WITH} VALIDATION\n  | ADD PARTITION (partition_definition)\n  | DROP PARTITION partition_names\n  | DISCARD PARTITION {partition_names | ALL} TABLESPACE\n  | IMPORT PARTITION {partition_names | ALL} TABLESPACE\n  | TRUNCATE PARTITION {partition_names | ALL}\n  | COALESCE PARTITION number\n  | REORGANIZE PARTITION partition_names INTO (partition_definitions)\n  | EXCHANGE PARTITION partition_name WITH TABLE tbl_name [{WITH|WITHOUT} VALIDATION]\n  | ANALYZE PARTITION {partition_names | ALL}\n  | CHECK PARTITION {partition_names | ALL}\n  | OPTIMIZE PARTITION {partition_names | ALL}\n  | REBUILD PARTITION {partition_names | ALL}\n  | REPAIR PARTITION {partition_names | ALL}\n  | REMOVE PARTITIONING\n  | UPGRADE PARTITIONING\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n  | COMMENT \'string\'\n\ntable_options:\n    table_option [[,] table_option] ...  (see CREATE TABLE options)\n\npartition_options:\n    (see CREATE TABLE options)\n\nALTER TABLE changes the structure of a table. For example, you can add\nor delete columns, create or destroy indexes, change the type of\nexisting columns, or rename columns or the table itself. You can also\nchange characteristics such as the storage engine used for the table or\nthe table comment.\n\nFollowing the table name, specify the alterations to be made. If none\nare given, ALTER TABLE does nothing.\n\nThe syntax for many of the permissible alterations is similar to\nclauses of the CREATE TABLE statement. See [HELP CREATE TABLE], for\nmore information.\n\ntable_options signifies table options of the kind that can be used in\nthe CREATE TABLE statement, such as ENGINE, AUTO_INCREMENT,\nAVG_ROW_LENGTH, MAX_ROWS, or ROW_FORMAT. For a list of all table\noptions and a description of each, see [HELP CREATE TABLE]. However,\nALTER TABLE ignores the DATA DIRECTORY and INDEX DIRECTORY table\noptions.\n\nUse of table options with ALTER TABLE provides a convenient way of\naltering single table characteristics. For example, if t1 is currently\nnot an InnoDB table, this statement changes its storage engine to\nInnoDB:\n\nALTER TABLE t1 ENGINE = InnoDB;\n\nTo change the InnoDB table to use compressed row-storage format:\n\nALTER TABLE t1 ROW_FORMAT = COMPRESSED;\n\nIf the InnoDB tablespace encryption feature is enabled (see\nhttp://dev.mysql.com/doc/refman/5.7/en/innodb-tablespace-encryption.htm\nl), encryption for t1 can be enabled or disabled like this:\n\nALTER TABLE t1 ENCRYPTION=\'Y\';\nALTER TABLE t1 ENCRYPTION=\'N\';\n\nTo disable encryption for an InnoDB table, set ENCRYPTION=\'N\' using\nALTER TABLE.\n\nTo reset the current auto-increment value:\n\nALTER TABLE t1 AUTO_INCREMENT = 13;\n\nTo change the default table character set:\n\nALTER TABLE t1 CHARACTER SET = utf8;\n\nTo add (or change) a table comment:\n\nALTER TABLE t1 COMMENT = \'New table comment\';\n\nNDB_TABLE options in table comments MySQL Cluster NDB 7.5.2 and later\nsupports setting NDB_TABLE options for controlling a table\'s fragment\ncount type, read-from-any-replica capability, full replication, or any\ncombimation of these, as part of the table comment for an ALTER TABLE\nstatement in the same manner as for CREATE TABLE, as shown in this\nexample:\n\nmysql> ALTER TABLE t1 \n     > COMMENT = "NDB_TABLE=READ_BACKUP=0,FRAGMENT_COUNT_TYPE=ONE_PER_NODE_GROUP";\nQuery OK, 0 rows affected (1.73 sec)\nRecords: 0  Duplicates: 0  Warnings: 0\n\nTo verify that the table options were changed as you intend, use SHOW\nCREATE TABLE, or query INFORMATION_SCHEMA.TABLES. Bear in mind that\nALTER TABLE ... COMMENT ... discards any existing comment for the\ntable. See\nhttp://dev.mysql.com/doc/refman/5.7/en/create-table.html#create-table-c\nomment-ndb-table-options, for additional information and examples.\n\npartition_options signifies options that can be used with partitioned\ntables for repartitioning, for adding, dropping, discarding, importing,\nmerging, and splitting partitions, and for performing partitioning\nmaintenance. It is possible for an ALTER TABLE statement to contain a\nPARTITION BY or REMOVE PARTITIONING clause in an addition to other\nalter specifications, but the PARTITION BY or REMOVE PARTITIONING\nclause must be specified last after any other specifications. The ADD\nPARTITION, DROP PARTITION, DISCARD PARTITION, IMPORT PARTITION,\nCOALESCE PARTITION, REORGANIZE PARTITION, EXCHANGE PARTITION, ANALYZE\nPARTITION, CHECK PARTITION, and REPAIR PARTITION options cannot be\ncombined with other alter specifications in a single ALTER TABLE, since\nthe options just listed act on individual partitions. For more\ninformation about partition options, see [HELP CREATE TABLE], and\nhttp://dev.mysql.com/doc/refman/5.7/en/alter-table-partition-operations\n.html. For information about and examples of ALTER TABLE ... EXCHANGE\nPARTITION statements, see\nhttp://dev.mysql.com/doc/refman/5.7/en/partitioning-management-exchange\n.html.\n\nPrior to MySQL 5.7.6, partitioned InnoDB tables used the generic\nha_partition partitioning handler employed by MyISAM and other storage\nengines not supplying their own partitioning handlers; in MySQL 5.7.6\nand later, such tables are created using the InnoDB storage engine\'s\nown (or "native") partitioning handler. Beginning with MySQL 5.7.9, you\ncan upgrade an InnoDB table that was created in MySQL 5.7.6 or earlier\n(that is, created using ha_partition) to the InnoDB native partition\nhandler using ALTER TABLE ... UPGRADE PARTITIONING. (Bug #76734, Bug\n#20727344) This version of ALTER TABLE does not accept any other\noptions and can be used only on a single table at a time.\n\n*Note*: You can also use mysql_upgrade in MySQL 5.7.9 or later to\nupgrade older partitioned InnoDB tables to the native partitioning\nhandler.\n\nSome operations may result in warnings if attempted on a table for\nwhich the storage engine does not support the operation. These warnings\ncan be displayed with SHOW WARNINGS. See [HELP SHOW WARNINGS].\n\nFor information on troubleshooting ALTER TABLE, see\nhttp://dev.mysql.com/doc/refman/5.7/en/alter-table-problems.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-table.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/alter-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (609,23,'CHAR BYTE','The CHAR BYTE data type is an alias for the BINARY data type. This is a\ncompatibility feature.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (610,4,'ST_MLINEFROMTEXT','ST_MLineFromText(wkt[,srid]), ST_MultiLineStringFromText(wkt[,srid])\n\nConstructs a MultiLineString value using its WKT representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (611,20,'>','Syntax:\n>\n\nGreater than:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT 2 > 2;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (612,21,'ANALYZE TABLE','Syntax:\nANALYZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n    tbl_name [, tbl_name] ...\n\nANALYZE TABLE analyzes and stores the key distribution for a table.\nDuring the analysis, the table is locked with a read lock for InnoDB\nand MyISAM. This statement works with InnoDB, NDB, and MyISAM tables.\nFor MyISAM tables, this statement is equivalent to using myisamchk\n--analyze. This statement does not work with views.\n\nFor more information on how the analysis works within InnoDB, see\nhttp://dev.mysql.com/doc/refman/5.7/en/innodb-persistent-stats.html and\nhttp://dev.mysql.com/doc/refman/5.7/en/innodb-analyze-table-complexity.\nhtml. Also see\nhttp://dev.mysql.com/doc/refman/5.7/en/innodb-restrictions.html. In\nparticular, when you enable the innodb_stats_persistent option, you\nmust run ANALYZE TABLE after loading substantial data into an InnoDB\ntable, or creating a new index for one.\n\nMySQL uses the stored key distribution to decide the order in which\ntables should be joined when you perform a join on something other than\na constant. In addition, key distributions can be used when deciding\nwhich indexes to use for a specific table within a query.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nANALYZE TABLE is supported for partitioned tables, and you can use\nALTER TABLE ... ANALYZE PARTITION to analyze one or more partitions;\nfor more information, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/5.7/en/partitioning-maintenance.html.\n\nIn MySQL 5.7.1, gtid_next must be set to AUTOMATIC before issuing this\nstatement. This restriction does not apply in MySQL 5.7.2 or later.\n(Bug #16062608, Bug #16715809, Bug #69045)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/analyze-table.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/analyze-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (613,2,'ST_EXTERIORRING','ST_ExteriorRing(poly)\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT ST_AsText(ST_ExteriorRing(ST_GeomFromText(@poly)));\n+----------------------------------------------------+\n| ST_AsText(ST_ExteriorRing(ST_GeomFromText(@poly))) |\n+----------------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)                    |\n+----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (614,38,'FIELD','Syntax:\nFIELD(str,str1,str2,str3,...)\n\nReturns the index (position) of str in the str1, str2, str3, ... list.\nReturns 0 if str is not found.\n\nIf all arguments to FIELD() are strings, all arguments are compared as\nstrings. If all arguments are numbers, they are compared as numbers.\nOtherwise, the arguments are compared as double.\n\nIf str is NULL, the return value is 0 because NULL fails equality\ncomparison with any value. FIELD() is the complement of ELT().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-functions.html\n\n','mysql> SELECT FIELD(\'ej\', \'Hej\', \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> 2\nmysql> SELECT FIELD(\'fo\', \'Hej\', \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (615,40,'CONSTRAINT','MySQL supports foreign keys, which let you cross-reference related data\nacross tables, and foreign key constraints, which help keep this\nspread-out data consistent. The essential syntax for a foreign key\nconstraint definition in a CREATE TABLE or ALTER TABLE statement looks\nlike this:\n\n[CONSTRAINT [symbol]] FOREIGN KEY\n    [index_name] (index_col_name, ...)\n    REFERENCES tbl_name (index_col_name,...)\n    [ON DELETE reference_option]\n    [ON UPDATE reference_option]\n\nreference_option:\n    RESTRICT | CASCADE | SET NULL | NO ACTION\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/create-table-foreign-keys.html\n\n','CREATE TABLE product (\n    category INT NOT NULL, id INT NOT NULL,\n    price DECIMAL,\n    PRIMARY KEY(category, id)\n)   ENGINE=INNODB;\n\nCREATE TABLE customer (\n    id INT NOT NULL,\n    PRIMARY KEY (id)\n)   ENGINE=INNODB;\n\nCREATE TABLE product_order (\n    no INT NOT NULL AUTO_INCREMENT,\n    product_category INT NOT NULL,\n    product_id INT NOT NULL,\n    customer_id INT NOT NULL,\n\n    PRIMARY KEY(no),\n    INDEX (product_category, product_id),\n    INDEX (customer_id),\n\n    FOREIGN KEY (product_category, product_id)\n      REFERENCES product(category, id)\n      ON UPDATE CASCADE ON DELETE RESTRICT,\n\n    FOREIGN KEY (customer_id)\n      REFERENCES customer(id)\n)   ENGINE=INNODB;\n','http://dev.mysql.com/doc/refman/5.7/en/create-table-foreign-keys.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (616,7,'CREATE_ASYMMETRIC_PRIV_KEY','Syntax:\nCREATE_ASYMMETRIC_PRIV_KEY(algorithm, {key_len|dh_secret})\n\nCreates a private key using the given algorithm and key length or DH\nsecret, and returns the key as a binary string in PEM format. If key\ngeneration fails, the result is NULL.\n\nSupported algorithm values: \'RSA\', \'DSA\', \'DH\'\n\nSupported key_len values: The minimum key length in bits is 1024. The\nmaximum key length depends on the algorithm: 16,384 for RSA and 10,000\nfor DSA. These lengths are constraints imposed by OpenSSL.\n\nFor DH keys, pass a shared DH secret instead of a key length. To create\nthe secret, pass the key length to CREATE_DH_PARAMETERS().\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html\n\n','SET @priv = CREATE_ASYMMETRIC_PRIV_KEY(\'DSA\', 2048);\nSET @pub = CREATE_ASYMMETRIC_PUB_KEY(\'DSA\', @priv);\n','http://dev.mysql.com/doc/refman/5.7/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (617,40,'ALTER TABLESPACE','Syntax:\nALTER TABLESPACE tablespace_name\n    {ADD|DROP} DATAFILE \'file_name\'\n    [INITIAL_SIZE [=] size]\n    [WAIT]\n    ENGINE [=] engine_name\n\nThis statement can be used either to add a new data file, or to drop a\ndata file from a tablespace.\n\nThe ADD DATAFILE variant enables you to specify an initial size using\nan INITIAL_SIZE clause, where size is measured in bytes; the default\nvalue is 134217728 (128 MB). You may optionally follow size with a\none-letter abbreviation for an order of magnitude, similar to those\nused in my.cnf. Generally, this is one of the letters M (megabytes) or\nG (gigabytes).\n\n*Note*: All MySQL Cluster Disk Data objects share the same namespace.\nThis means that each Disk Data object must be uniquely named (and not\nmerely each Disk Data object of a given type). For example, you cannot\nhave a tablespace and an data file with the same name, or an undo log\nfile and a tablespace with the same name.\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is\n4294967296 (4 GB). (Bug #29186)\n\nINITIAL_SIZE is rounded, explicitly, as for CREATE TABLESPACE.\n\nOnce a data file has been created, its size cannot be changed; however,\nyou can add more data files to the tablespace using additional ALTER\nTABLESPACE ... ADD DATAFILE statements.\n\nUsing DROP DATAFILE with ALTER TABLESPACE drops the data file\n\'file_name\' from the tablespace. You cannot drop a data file from a\ntablespace which is in use by any table; in other words, the data file\nmust be empty (no extents used). See\nhttp://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-disk-data-objects.\nhtml. In addition, any data file to be dropped must previously have\nbeen added to the tablespace with CREATE TABLESPACE or ALTER\nTABLESPACE.\n\nBoth ALTER TABLESPACE ... ADD DATAFILE and ALTER TABLESPACE ... DROP\nDATAFILE require an ENGINE clause which specifies the storage engine\nused by the tablespace. Currently, the only accepted values for\nengine_name are NDB and NDBCLUSTER.\n\nWAIT is parsed but otherwise ignored, and so has no effect in MySQL\n5.7. It is intended for future expansion.\n\nWhen ALTER TABLESPACE ... ADD DATAFILE is used with ENGINE = NDB, a\ndata file is created on each Cluster data node. You can verify that the\ndata files were created and obtain information about them by querying\nthe INFORMATION_SCHEMA.FILES table. For example, the following query\nshows all data files belonging to the tablespace named newts:\n\nmysql> SELECT LOGFILE_GROUP_NAME, FILE_NAME, EXTRA\n    -> FROM INFORMATION_SCHEMA.FILES\n    -> WHERE TABLESPACE_NAME = \'newts\' AND FILE_TYPE = \'DATAFILE\';\n+--------------------+--------------+----------------+\n| LOGFILE_GROUP_NAME | FILE_NAME    | EXTRA          |\n+--------------------+--------------+----------------+\n| lg_3               | newdata.dat  | CLUSTER_NODE=3 |\n| lg_3               | newdata.dat  | CLUSTER_NODE=4 |\n| lg_3               | newdata2.dat | CLUSTER_NODE=3 |\n| lg_3               | newdata2.dat | CLUSTER_NODE=4 |\n+--------------------+--------------+----------------+\n2 rows in set (0.03 sec)\n\nSee http://dev.mysql.com/doc/refman/5.7/en/files-table.html.\n\nALTER TABLESPACE is useful only with Disk Data storage for MySQL\nCluster. See\nhttp://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-disk-data.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/alter-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/alter-tablespace.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (618,23,'ENUM','ENUM(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nAn enumeration. A string object that can have only one value, chosen\nfrom the list of values \'value1\', \'value2\', ..., NULL or the special \'\'\nerror value. ENUM values are represented internally as integers.\n\nAn ENUM column can have a maximum of 65,535 distinct elements. (The\npractical limit is less than 3000.) A table can have no more than 255\nunique element list definitions among its ENUM and SET columns\nconsidered as a group. For more information on these limits, see\nhttp://dev.mysql.com/doc/refman/5.7/en/limits-frm-file.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (619,13,'ST_LENGTH','ST_Length(ls)\n\nReturns a double-precision number indicating the length of the\nLineString or MultiLineString value ls in its associated spatial\nreference. The length of a MultiLineString value is equal to the sum of\nthe lengths of its elements.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_Length(ST_GeomFromText(@ls));\n+---------------------------------+\n| ST_Length(ST_GeomFromText(@ls)) |\n+---------------------------------+\n|              2.8284271247461903 |\n+---------------------------------+\n\nmysql> SET @mls = \'MultiLineString((1 1,2 2,3 3),(4 4,5 5))\';\nmysql> SELECT ST_Length(ST_GeomFromText(@mls));\n+----------------------------------+\n| ST_Length(ST_GeomFromText(@mls)) |\n+----------------------------------+\n|                4.242640687119286 |\n+----------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (620,38,'STRCMP','Syntax:\nSTRCMP(expr1,expr2)\n\nSTRCMP() returns 0 if the strings are the same, -1 if the first\nargument is smaller than the second according to the current sort\norder, and 1 otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-comparison-functions.html\n\n','mysql> SELECT STRCMP(\'text\', \'text2\');\n        -> -1\nmysql> SELECT STRCMP(\'text2\', \'text\');\n        -> 1\nmysql> SELECT STRCMP(\'text\', \'text\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.7/en/string-comparison-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (621,28,'INSERT DELAYED','Syntax:\nINSERT DELAYED ...\n\nThe DELAYED option for the INSERT statement is a MySQL extension to\nstandard SQL. In previous versions of MySQL, it can be used for certain\nkinds of tables (such as MyISAM), such that when a client uses INSERT\nDELAYED, it gets an okay from the server at once, and the row is queued\nto be inserted when the table is not in use by any other thread.\n\nDELAYED inserts and replaces were deprecated in MySQL 5.6.6. In MySQL\n5.7, DELAYED is not supported. The server recognizes but ignores the\nDELAYED keyword, handles the insert as a nondelayed insert, and\ngenerates an ER_WARN_LEGACY_SYNTAX_CONVERTED warning ("INSERT DELAYED\nis no longer supported. The statement was converted to INSERT"). The\nDELAYED keyword is scheduled for removal in a future release.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/insert-delayed.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/insert-delayed.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (622,27,'SHOW PROCEDURE CODE','Syntax:\nSHOW PROCEDURE CODE proc_name\n\nThis statement is a MySQL extension that is available only for servers\nthat have been built with debugging support. It displays a\nrepresentation of the internal implementation of the named stored\nprocedure. A similar statement, SHOW FUNCTION CODE, displays\ninformation about stored functions (see [HELP SHOW FUNCTION CODE]).\n\nTo use either statement, you must be the owner of the routine or have\nSELECT access to the mysql.proc table.\n\nIf the named routine is available, each statement produces a result\nset. Each row in the result set corresponds to one "instruction" in the\nroutine. The first column is Pos, which is an ordinal number beginning\nwith 0. The second column is Instruction, which contains an SQL\nstatement (usually changed from the original source), or a directive\nwhich has meaning only to the stored-routine handler.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-procedure-code.html\n\n','mysql> DELIMITER //\nmysql> CREATE PROCEDURE p1 ()\n    -> BEGIN\n    ->   DECLARE fanta INT DEFAULT 55;\n    ->   DROP TABLE t2;\n    ->   LOOP\n    ->     INSERT INTO t3 VALUES (fanta);\n    ->     END LOOP;\n    ->   END//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SHOW PROCEDURE CODE p1//\n+-----+----------------------------------------+\n| Pos | Instruction                            |\n+-----+----------------------------------------+\n|   0 | set fanta@0 55                         |\n|   1 | stmt 9 "DROP TABLE t2"                 |\n|   2 | stmt 5 "INSERT INTO t3 VALUES (fanta)" |\n|   3 | jump 2                                 |\n+-----+----------------------------------------+\n4 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.7/en/show-procedure-code.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (623,23,'MEDIUMTEXT','MEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 16,777,215 (224 − 1)\ncharacters. The effective maximum length is less if the value contains\nmultibyte characters. Each MEDIUMTEXT value is stored using a 3-byte\nlength prefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (624,27,'SHOW COLLATION','Syntax:\nSHOW COLLATION\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement lists collations supported by the server. By default,\nthe output from SHOW COLLATION includes all available collations. The\nLIKE clause, if present, indicates which collation names to match. The\nWHERE clause can be given to select rows using more general conditions,\nas discussed in\nhttp://dev.mysql.com/doc/refman/5.7/en/extended-show.html. For example:\n\nmysql> SHOW COLLATION LIKE \'latin1%\';\n+-------------------+---------+----+---------+----------+---------+\n| Collation         | Charset | Id | Default | Compiled | Sortlen |\n+-------------------+---------+----+---------+----------+---------+\n| latin1_german1_ci | latin1  |  5 |         |          |       0 |\n| latin1_swedish_ci | latin1  |  8 | Yes     | Yes      |       0 |\n| latin1_danish_ci  | latin1  | 15 |         |          |       0 |\n| latin1_german2_ci | latin1  | 31 |         | Yes      |       2 |\n| latin1_bin        | latin1  | 47 |         | Yes      |       0 |\n| latin1_general_ci | latin1  | 48 |         |          |       0 |\n| latin1_general_cs | latin1  | 49 |         |          |       0 |\n| latin1_spanish_ci | latin1  | 94 |         |          |       0 |\n+-------------------+---------+----+---------+----------+---------+\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/show-collation.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/show-collation.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (625,3,'LOG','Syntax:\nLOG(X), LOG(B,X)\n\nIf called with one parameter, this function returns the natural\nlogarithm of X. If X is less than or equal to 0.0E0, the function\nreturns NULL and (as of MySQL 5.7.4) a warning "Invalid argument for\nlogarithm" is reported.\n\nThe inverse of this function (when called with a single argument) is\nthe EXP() function.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT LOG(2);\n        -> 0.69314718055995\nmysql> SELECT LOG(-2);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (626,20,'!=','Syntax:\n<>, !=\n\nNot equal:\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT \'.01\' <> \'0.01\';\n        -> 1\nmysql> SELECT .01 <> \'0.01\';\n        -> 0\nmysql> SELECT \'zapp\' <> \'zappp\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (627,24,'WHILE','Syntax:\n[begin_label:] WHILE search_condition DO\n    statement_list\nEND WHILE [end_label]\n\nThe statement list within a WHILE statement is repeated as long as the\nsearch_condition expression is true. statement_list consists of one or\nmore SQL statements, each terminated by a semicolon (;) statement\ndelimiter.\n\nA WHILE statement can be labeled. For the rules regarding label use,\nsee [HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/while.html\n\n','CREATE PROCEDURE dowhile()\nBEGIN\n  DECLARE v1 INT DEFAULT 5;\n\n  WHILE v1 > 0 DO\n    ...\n    SET v1 = v1 - 1;\n  END WHILE;\nEND;\n','http://dev.mysql.com/doc/refman/5.7/en/while.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (628,7,'JSON_APPEND','JSON_APPEND(json_doc, path, val[, path, val] ...)\n\nAppends values to the end of the indicated arrays within a JSON\ndocument and returns the result. This function was renamed to\nJSON_ARRAY_APPEND() in MySQL 5.7.9.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.7/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (629,7,'JSON_LENGTH','JSON_LENGTH(json_doc[, path])\n\nReturns the length of JSON document, or, if a path argument is given,\nthe length of the value within the document identified by the path.\nReturns NULL if any argument is NULL or the path argument does not\nidentify a value in the document. An error occurs if the json_doc\nargument is not a valid JSON document or the path argument is not a\nvalid path expression or contains a * or ** wildcard.\n\nThe length of a document is determined as follows:\n\no The length of a scalar is 1.\n\no The length of an array is the number of array elements.\n\no The length of an object is the number of object members.\n\no The length does not count the length of nested arrays or objects.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/json-attribute-functions.html\n\n','mysql> SELECT JSON_LENGTH(\'[1, 2, {"a": 3}]\');\n+---------------------------------+\n| JSON_LENGTH(\'[1, 2, {"a": 3}]\') |\n+---------------------------------+\n|                               3 |\n+---------------------------------+\nmysql> SELECT JSON_LENGTH(\'{"a": 1, "b": {"c": 30}}\');\n+-----------------------------------------+\n| JSON_LENGTH(\'{"a": 1, "b": {"c": 30}}\') |\n+-----------------------------------------+\n|                                       2 |\n+-----------------------------------------+\nmysql> SELECT JSON_LENGTH(\'{"a": 1, "b": {"c": 30}}\', \'$.b\');\n+------------------------------------------------+\n| JSON_LENGTH(\'{"a": 1, "b": {"c": 30}}\', \'$.b\') |\n+------------------------------------------------+\n|                                              1 |\n+------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.7/en/json-attribute-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (630,32,'DAYNAME','Syntax:\nDAYNAME(date)\n\nReturns the name of the weekday for date. The language used for the\nname is controlled by the value of the lc_time_names system variable\n(http://dev.mysql.com/doc/refman/5.7/en/locale-support.html).\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html\n\n','mysql> SELECT DAYNAME(\'2007-02-03\');\n        -> \'Saturday\'\n','http://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (631,3,'RADIANS','Syntax:\nRADIANS(X)\n\nReturns the argument X, converted from degrees to radians. (Note that\nπ radians equals 180 degrees.)\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html\n\n','mysql> SELECT RADIANS(90);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.7/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (632,17,'COLLATION','Syntax:\nCOLLATION(str)\n\nReturns the collation of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> SELECT COLLATION(\'abc\');\n        -> \'latin1_swedish_ci\'\nmysql> SELECT COLLATION(_utf8\'abc\');\n        -> \'utf8_general_ci\'\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (633,20,'COALESCE','Syntax:\nCOALESCE(value,...)\n\nReturns the first non-NULL value in the list, or NULL if there are no\nnon-NULL values.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html\n\n','mysql> SELECT COALESCE(NULL,1);\n        -> 1\nmysql> SELECT COALESCE(NULL,NULL,NULL);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.7/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (634,17,'VERSION','Syntax:\nVERSION()\n\nReturns a string that indicates the MySQL server version. The string\nuses the utf8 character set. The value might have a suffix in addition\nto the version number. See the description of the version system\nvariable in\nhttp://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.7/en/information-functions.html\n\n','mysql> SELECT VERSION();\n        -> \'5.7.14-standard\'\n','http://dev.mysql.com/doc/refman/5.7/en/information-functions.html');

INSERT INTO help_keyword (help_keyword_id,name) VALUES (0,'JOIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (1,'HOST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (2,'SERIALIZABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (3,'CONTAINS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (4,'SRID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (5,'AT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (6,'SCHEDULE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (7,'RETURNS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (8,'MASTER_SSL_CA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (9,'NCHAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (10,'ONLY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (11,'ST_GEOMETRYN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (12,'ST_GEOMCOLLFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (13,'WORK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (14,'OPEN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (15,'ST_INTERSECTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (16,'ESCAPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (17,'EVENTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (18,'MONTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (19,'PROFILES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (20,'ISCLOSED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (21,'DUPLICATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (22,'ST_POINTN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (23,'REPLICATION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (24,'UNLOCK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (25,'STATS_PERSISTENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (26,'INNODB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (27,'REPLICATE_REWRITE_DB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (28,'YEAR_MONTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (29,'WITHIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (30,'PREPARE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (31,'LOCK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (32,'NDB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (33,'INT4');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (34,'POLYGON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (35,'MINUTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (36,'SEPARATOR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (37,'DELETE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (38,'JSON_SEARCH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (39,'ON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (40,'CONNECTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (41,'CLOSE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (42,'MASTER_SSL_CRLPATH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (43,'USE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (44,'PRIVILEGES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (45,'SPATIAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (46,'SQL_BUFFER_RESULT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (47,'SECURITY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (48,'AUTOEXTEND_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (49,'ST_STARTPOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (50,'NDBCLUSTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (51,'ST_POLYGONFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (52,'LEVEL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (53,'BINARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (54,'CURRENT_USER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (55,'HOUR_MINUTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (56,'UPDATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (57,'PRESERVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (58,'ST_SIMPLIFY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (59,'INTO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (60,'POLYFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (61,'SQL_AFTER_GTIDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (62,'VARIABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (63,'ROLLBACK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (64,'TIMESTAMP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (65,'IMPORT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (66,'CHECKSUM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (67,'THEN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (68,'ENGINES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (69,'HANDLER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (70,'DAY_SECOND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (71,'HELP_DATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (72,'BOOLEAN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (73,'JSON_EXTRACT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (74,'MOD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (75,'ST_GEOMETRYTYPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (76,'CLASS_ORIGIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (77,'MPOLYFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (78,'ITERATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (79,'DO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (80,'DATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (81,'FULLTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (82,'COMMENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (83,'ST_ASTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (84,'MASTER_CONNECT_RETRY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (85,'JSON_TYPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (86,'MASTER_LOG_FILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (87,'PRECISION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (88,'REQUIRE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (89,'ST_ASWKT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (90,'LONG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (91,'FORMAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (92,'OPTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (93,'REORGANIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (94,'ELSE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (95,'EXTERIORRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (96,'GEOMFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (97,'STATS_AUTO_RECALC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (98,'FROM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (99,'MULTIPOLYGON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (100,'LEFT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (101,'ELSEIF');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (102,'ST_ISCLOSED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (103,'COMPACT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (104,'DEC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (105,'FOR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (106,'WARNINGS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (107,'ST_LONGFROMGEOHASH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (108,'ST_LINESTRINGFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (109,'STRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (110,'CONDITION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (111,'ENCLOSED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (112,'AGGREGATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (113,'NUMBER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (114,'FIELDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (115,'JSON_INSERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (116,'JSON_UNQUOTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (117,'PATH)');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (118,'KILL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (119,'DISJOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (120,'TABLESPACE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (121,'OVERLAPS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (122,'INFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (123,'MBREQUAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (124,'HELP_VERSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (125,'ORDER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (126,'MASTER_SSL_CRL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (127,'ST_GEOMFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (128,'USING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (129,'REPLICATE_WILD_DO_TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (130,'MIDDLEINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (131,'GRANT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (132,'MBRINTERSECTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (133,'ST_MPOLYFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (134,'JSON_ARRAY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (135,'GEOMETRYN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (136,'GEOMETRYFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (137,'DEFAULT_AUTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (138,'FOREIGN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (139,'CACHE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (140,'MYSQL_ERRNO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (141,'SCHEMAS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (142,'LEADING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (143,'CONSTRAINT_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (144,'CONVERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (145,'DYNAMIC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (146,'ST_ISVALID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (147,'POLYGONFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (148,'ENVELOPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (149,'ST_ISEMPTY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (150,'HAVING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (151,'STARTING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (152,'RELOAD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (153,'ISSIMPLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (154,'AUTOCOMMIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (155,'ST_Y');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (156,'REVOKE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (157,'RANDOM_BYTES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (158,'EXPLAIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (159,'CSV');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (160,'OUTFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (161,'LOW_PRIORITY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (162,'FILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (163,'ANY_VALUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (164,'NODEGROUP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (165,'SCHEMA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (166,'ST_TOUCHES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (167,'MLINEFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (168,'ST_POLYGONFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (169,'DUAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (170,'MULTIPOINTFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (171,'MULTIPOINTFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (172,'EXTENDED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (173,'CROSS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (174,'GROUP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (175,'NATIONAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (176,'ST_ISSIMPLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (177,'SHA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (178,'POINTN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (179,'IGNORE_SERVER_IDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (180,'MASTER_AUTO_POSITION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (181,'ASBINARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (182,'ST_MLINEFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (183,'EXTRACTION)');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (184,'MBROVERLAPS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (185,'OWNER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (186,'TRUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (187,'CHARACTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (188,'SCHEMA_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (189,'TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (190,'ST_LINEFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (191,'CASCADE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (192,'RELAY_LOG_POS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (193,'ASWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (194,'LEAVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (195,'ST_GEOHASH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (196,'MODIFY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (197,'MATCH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (198,'MASTER_LOG_POS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (199,'DISTINCTROW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (200,'X');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (201,'CURSOR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (202,'INLINE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (203,'ST_UNION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (204,'CROSSES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (205,'->>');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (206,'GEOMETRYCOLLECTIONFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (207,'CHAIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (208,'FLUSH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (209,'CREATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (210,'DESCRIBE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (211,'PROCESSLIST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (212,'DISCARD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (213,'SOUNDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (214,'PACK_KEYS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (215,'MULTILINESTRINGFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (216,'INTERSECTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (217,'FAST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (218,'GET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (219,'REPLICATE_WILD_IGNORE_TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (220,'LOOP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (221,'VARCHARACTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (222,'BEFORE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (223,'ALL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (224,'REDUNDANT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (225,'USER_RESOURCES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (226,'PARTIAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (227,'END');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (228,'ST_CONTAINS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (229,'SECOND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (230,'FLOAT8');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (231,'PREV');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (232,'MBRCONTAINS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (233,'OR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (234,'IDENTIFIED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (235,'POINTFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (236,'MASTER_SSL_CIPHER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (237,'SQL_SLAVE_SKIP_COUNTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (238,'BOTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (239,'YEAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (240,'UNIQUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (241,'TRIGGERS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (242,'RESIGNAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (243,'ST_NUMPOINTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (244,'MASTER_SSL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (245,'DATE_ADD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (246,'JSON_VALID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (247,'ST_ENVELOPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (248,'LIKE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (249,'PLUGIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (250,'MULTIPOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (251,'FETCH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (252,'MBRWITHIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (253,'COLUMN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (254,'USAGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (255,'MEMORY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (256,'ST_MULTIPOINTFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (257,'QUERY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (258,'DISTANCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (259,'Y');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (260,'LINES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (261,'PLUGIN_DIR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (262,'SQL_THREAD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (263,'INTERIORRINGN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (264,'NUMINTERIORRINGS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (265,'REPLICATE_IGNORE_DB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (266,'MAX_QUERIES_PER_HOUR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (267,'ST_POLYFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (268,'TRANSACTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (269,'STDDEV');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (270,'INT1');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (271,'RIGHT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (272,'MAX_ROWS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (273,'ALTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (274,'NATURAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (275,'MULTILINESTRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (276,'VARIABLES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (277,'ESCAPED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (278,'KEY_BLOCK_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (279,'MPOINTFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (280,'CHAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (281,'UPGRADE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (282,'INTERVAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (283,'NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (284,'ST_POINTFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (285,'REFERENCES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (286,'ST_MAKEENVELOPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (287,'ST_WITHIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (288,'STORAGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (289,'ISOLATION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (290,'EVERY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (291,'INT8');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (292,'ST_BUFFER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (293,'BUFFER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (294,'RESTRICT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (295,'JSON_OBJECT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (296,'UNCOMMITTED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (297,'LINESTRINGFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (298,'IS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (299,'ST_CENTROID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (300,'NOT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (301,'REPLICATE_DO_TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (302,'DATAFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (303,'ANALYSE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (304,'DES_KEY_FILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (305,'COMPRESSED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (306,'START');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (307,'PARTITIONING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (308,'IF');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (309,'ROWS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (310,'PURGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (311,'USER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (312,'EXIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (313,'ST_MULTILINESTRINGFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (314,'MERGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (315,'ST_DISTANCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (316,'SQL_NO_CACHE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (317,'ST_MULTIPOLYGONFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (318,'DELAYED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (319,'ST_DISTANCE_SPHERE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (320,'ST_POLYFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (321,'WRITE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (322,'JSON_QUOTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (323,'NEVER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (324,'DATABASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (325,'NULL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (326,'POWER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (327,'POINTFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (328,'USE_FRM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (329,'TERMINATED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (330,'NVARCHAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (331,'RETURN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (332,'DIRECTORY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (333,'AES_DECRYPT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (334,'GLENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (335,'SHUTDOWN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (336,'JSON_REMOVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (337,'ST_ASGEOJSON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (338,'CATALOG_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (339,'FILE_BLOCK_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (340,'FIXED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (341,'ST_BUFFER_STRATEGY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (342,'MULTIPOLYGONFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (343,'REPEAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (344,'REPLACE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (345,'ST_SYMDIFFERENCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (346,'STARTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (347,'ST_NUMINTERIORRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (348,'COMPLETION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (349,'COLUMNS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (350,'DATETIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (351,'MODE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (352,'INTEGER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (353,'VALUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (354,'ASWKT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (355,'MASTER_SSL_VERIFY_SERVER_CERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (356,'GEOMETRYCOLLECTIONFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (357,'DROP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (358,'SQL_BIG_RESULT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (359,'SUBJECT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (360,'MASTER_RETRY_COUNT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (361,'ST_VALIDATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (362,'CHECK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (363,'FULL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (364,'BY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (365,'ST_POINTFROMGEOHASH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (366,'NO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (367,'DAY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (368,'DATA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (369,'PARTITION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (370,'REAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (371,'SHARE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (372,'LINESTRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (373,'MESSAGE_TEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (374,'MASTER_HEARTBEAT_PERIOD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (375,'COLUMN_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (376,'X509');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (377,'LINEFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (378,'SUBCLASS_ORIGIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (379,'WHERE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (380,'EVENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (381,'SUPER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (382,'IGNORE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (383,'SHA2');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (384,'QUICK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (385,'SIGNED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (386,'ST_GEOMCOLLFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (387,'FALSE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (388,'POLYGONFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (389,'FORCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (390,'CHANGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (391,'TO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (392,'POINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (393,'CREATE_DH_PARAMETERS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (394,'TABLE_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (395,'VARYING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (396,'FEDERATED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (397,'MAX_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (398,'HOUR_SECOND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (399,'ST_DIFFERENCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (400,'TRADITIONAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (401,'GEOMETRYCOLLECTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (402,'ST_GEOMETRYCOLLECTIONFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (403,'ST_ASBINARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (404,'PROCEDURE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (405,'AGAINST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (406,'MAX_STATEMENT_TIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (407,'ST_AREA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (408,'SQL_BEFORE_GTIDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (409,'ENDPOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (410,'LONGBINARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (411,'INSERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (412,'COUNT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (413,'JSON_ARRAY_APPEND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (414,'PORT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (415,'MLINEFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (416,'EXISTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (417,'MUTEX');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (418,'GEOMCOLLFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (419,'RELEASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (420,'DEFAULT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (421,'TYPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (422,'NO_WRITE_TO_BINLOG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (423,'JSON_ARRAY_INSERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (424,'OPTIMIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (425,'SQLSTATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (426,'RESET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (427,'INSTALL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (428,'BIGINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (429,'ST_DIMENSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (430,'SET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (431,'JSON_MERGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (432,'ISSUER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (433,'ST_MPOINTFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (434,'STATUS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (435,'INNER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (436,'RELAYLOG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (437,'STOP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (438,'MRG_MYISAM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (439,'TRAILING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (440,'PARTITIONS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (441,'ST_NUMINTERIORRINGS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (442,'JSON_KEYS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (443,'DEALLOCATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (444,'IO_THREAD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (445,'CASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (446,'CIPHER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (447,'CONTINUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (448,'READ');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (449,'MINUTE_SECOND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (450,'ST_MULTIPOINTFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (451,'MIN_ROWS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (452,'ROW_COUNT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (453,'FUNCTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (454,'ST_GEOMETRYFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (455,'INT3');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (456,'JSON_CONTAINS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (457,'ADD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (458,'AVG_ROW_LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (459,'ARCHIVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (460,'FLOAT4');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (461,'ASTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (462,'NUMGEOMETRIES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (463,'ALGORITHM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (464,'VIEW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (465,'REPEATABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (466,'JSON_CONTAINS_PATH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (467,'ST_MPOINTFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (468,'CONSTRAINT_CATALOG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (469,'STARTPOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (470,'MPOLYFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (471,'UNSIGNED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (472,'DECIMAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (473,'INDEXES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (474,'ST_INTERSECTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (475,'HOSTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (476,'COMMIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (477,'SNAPSHOT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (478,'DECLARE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (479,'NUMPOINTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (480,'INSTANCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (481,'LOAD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (482,'SQL_CACHE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (483,'->');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (484,'COLLATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (485,'ST_GEOMETRYFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (486,'BYTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (487,'GLOBAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (488,'LINESTRINGFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (489,'WHEN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (490,'CONVEXHULL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (491,'TOUCHES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (492,'AS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (493,'ST_LINESTRINGFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (494,'GEOMCOLLFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (495,'ST_INTERIORRINGN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (496,'GRANTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (497,'REPLICATE_DO_DB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (498,'OUTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (499,'CURSOR_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (500,'EXPIRE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (501,'SQL_AFTER_MTS_GAPS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (502,'FLOOR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (503,'WITH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (504,'STD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (505,'AFTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (506,'DISABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (507,'UNINSTALL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (508,'ST_CONVEXHULL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (509,'SONAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (510,'POW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (511,'INDEX');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (512,'DEFINER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (513,'MASTER_BIND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (514,'REMOVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (515,'MULTILINESTRINGFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (516,'ST_POINTFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (517,'ST_ENDPOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (518,'ACCOUNT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (519,'ST_OVERLAPS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (520,'UNDO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (521,'JSON_SET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (522,'ZEROFILL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (523,'CLIENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (524,'MASTER_PASSWORD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (525,'RELAY_LOG_FILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (526,'MASTER_USER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (527,'MBRTOUCHES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (528,'ENGINE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (529,'INSERT_METHOD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (530,'SQL_CALC_FOUND_ROWS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (531,'UNION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (532,'MYISAM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (533,'DESC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (534,'TIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (535,'EXPANSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (536,'NUMERIC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (537,'CODE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (538,'AREA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (539,'LOGFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (540,'EXTENT_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (541,'ST_LINEFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (542,'MAX_UPDATES_PER_HOUR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (543,'INT2');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (544,'ENDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (545,'LOGS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (546,'RECOVER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (547,'ISEMPTY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (548,'HEAP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (549,'RETURNED_SQLSTATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (550,'EXCHANGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (551,'BETWEEN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (552,'ST_CROSSES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (553,'REPAIR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (554,'ST_MPOLYFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (555,'MBRDISJOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (556,'CALL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (557,'VALUES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (558,'ST_X');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (559,'TRUNCATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (560,'SHOW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (561,'BINLOG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (562,'ST_DISJOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (563,'AND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (564,'HOUR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (565,'SELECT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (566,'DATABASES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (567,'WRAPPER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (568,'BOOL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (569,'MASTER_PORT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (570,'CONCURRENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (571,'HELP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (572,'PROCESS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (573,'OPTIONS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (574,'CONSISTENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (575,'MAX_CONNECTIONS_PER_HOUR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (576,'IN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (577,'DIAGNOSTICS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (578,'JSON_REPLACE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (579,'DUMPFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (580,'POLYFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (581,'EXECUTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (582,'ST_SRID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (583,'JSON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (584,'CEIL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (585,'ST_MULTILINESTRINGFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (586,'MASTER_HOST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (587,'ST_EQUALS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (588,'SERVER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (589,'MASTER_SSL_CERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (590,'MULTIPOLYGONFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (591,'DAY_MINUTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (592,'DATE_SUB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (593,'REPLICATE_IGNORE_TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (594,'REBUILD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (595,'GEOMETRYFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (596,'GEOMFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (597,'RENAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (598,'PARSER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (599,'ST_ASWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (600,'SOCKET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (601,'ST_LATFROMGEOHASH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (602,'ST_GEOMFROMGEOJSON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (603,'STRAIGHT_JOIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (604,'ST_GEOMETRYCOLLECTIONFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (605,'ST_GEOMFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (606,'SHA1');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (607,'PASSWORD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (608,'OFFSET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (609,'NEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (610,'ERRORS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (611,'SQL_LOG_BIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (612,'TEMPORARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (613,'COMMITTED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (614,'DIMENSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (615,'SQL_SMALL_RESULT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (616,'ST_MULTIPOLYGONFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (617,'FILTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (618,'XA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (619,'EQUALS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (620,'DELAY_KEY_WRITE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (621,'BEGIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (622,'PROFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (623,'MEDIUM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (624,'CENTROID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (625,'SSL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (626,'DAY_HOUR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (627,'AES_ENCRYPT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (628,'CEILING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (629,'LINEFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (630,'GEOMETRYTYPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (631,'STATS_SAMPLE_PAGES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (632,'SIGNAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (633,'PLUGINS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (634,'SAVEPOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (635,'ST_NUMGEOMETRIES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (636,'PRIMARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (637,'JSON_DEPTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (638,'LAST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (639,'MPOINTFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (640,'KEYS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (641,'LIMIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (642,'KEY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (643,'UNTIL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (644,'ST_MLINEFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (645,'CONSTRAINT_SCHEMA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (646,'ST_EXTERIORRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (647,'ANALYZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (648,'CONSTRAINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (649,'SERIAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (650,'ACTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (651,'INITIAL_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (652,'SESSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (653,'SLAVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (654,'ASC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (655,'ENABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (656,'OPTIONALLY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (657,'MAX_USER_CONNECTIONS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (658,'WHILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (659,'DISTINCT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (660,'LOCAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (661,'MASTER_SSL_KEY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (662,'JSON_APPEND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (663,'JSON_LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (664,'NONE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (665,'TABLES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (666,'<>');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (667,'EXPORT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (668,'RLIKE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (669,'TRIGGER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (670,'COLLATION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (671,'HIGH_PRIORITY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (672,'BTREE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (673,'FIRST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (674,'COALESCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (675,'WAIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (676,'MASTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (677,'ROW_FORMAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (678,'(JSON');

INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,0);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,0);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,1);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,2);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (2,3);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (3,4);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,5);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,6);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,6);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (64,7);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,8);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (266,9);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,10);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,10);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,10);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (6,11);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (7,12);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,13);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (14,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (400,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (69,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (15,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (238,16);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (263,17);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (78,17);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (107,17);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,18);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (52,19);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (21,20);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,21);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (23,22);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,23);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (327,23);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (29,24);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,24);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,24);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,25);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,26);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,26);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (327,27);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,28);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (26,29);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (28,30);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (459,30);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,30);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (29,31);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,31);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,31);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,31);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,31);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,32);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (312,33);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (31,34);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,35);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (534,36);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,37);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,37);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,37);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (36,38);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (111,40);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,40);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,40);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (37,41);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (69,41);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,42);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,43);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (39,43);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,43);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,44);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (156,44);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,44);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (130,45);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,45);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,46);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,47);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,48);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (47,49);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,50);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (296,51);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,52);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (30,53);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (171,53);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,53);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,54);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,54);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,55);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (53,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,57);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,57);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (55,58);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (495,59);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (321,59);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,59);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,59);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (60,60);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,61);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (394,62);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,63);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (603,63);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,63);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (431,64);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (65,64);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,65);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,65);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (249,66);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,66);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (54,67);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (40,67);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (24,67);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,68);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (481,68);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (501,69);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (69,69);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,70);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (70,71);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (367,72);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (330,72);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (73,73);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (74,74);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (425,74);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (75,75);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,76);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,76);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,76);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (79,77);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (80,78);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,79);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,79);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (81,79);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (627,79);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (471,80);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (83,80);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,80);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,80);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,81);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (130,81);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,81);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,82);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,82);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,82);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,82);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (130,82);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (84,83);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,84);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (85,85);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,86);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (502,87);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,88);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,88);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,88);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (84,89);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (485,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,91);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (156,92);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,92);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,93);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (54,94);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (40,94);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (90,95);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (91,96);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,97);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (263,98);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,98);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (600,98);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,98);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (78,98);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,98);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (93,99);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,100);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (24,101);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (95,102);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,103);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (444,104);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,105);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (501,105);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (208,105);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (427,105);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,105);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (575,105);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,105);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,106);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (509,106);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (102,107);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (193,108);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (64,109);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (427,110);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,111);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (64,112);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,113);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,114);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,114);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (108,115);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (109,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (207,117);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (111,118);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (112,119);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,120);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (617,120);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (259,120);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,120);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (114,121);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,122);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,122);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (116,123);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (118,124);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,125);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,125);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (53,125);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,125);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (534,125);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,126);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (122,127);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,128);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (56,128);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,128);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (327,129);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (158,130);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (156,131);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,131);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (126,132);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (129,133);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (132,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (133,135);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (568,136);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,137);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,138);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,138);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,138);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,138);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (495,139);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (67,139);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (96,139);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,140);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,140);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,140);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,141);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (104,141);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (600,142);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,143);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,143);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,143);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,144);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (544,144);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,145);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (144,146);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (555,147);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (148,148);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (149,149);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,150);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,151);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,152);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (151,153);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,154);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (155,155);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (156,156);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (159,157);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,159);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,159);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,160);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (321,161);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (29,161);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,161);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,161);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,161);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (53,161);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,161);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,162);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (169,163);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,164);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,165);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (410,165);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (499,165);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (432,165);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,165);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (173,166);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (176,167);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (255,168);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (178,169);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (607,170);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (264,171);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (288,172);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,172);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,173);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,174);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (344,174);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,174);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,174);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (164,175);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (266,175);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (182,176);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (579,177);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (183,178);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,179);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,180);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (187,181);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (188,182);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (457,183);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (192,184);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,185);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (242,186);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (212,187);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,187);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (410,187);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (266,187);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,187);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,187);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (164,187);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,187);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,187);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,187);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,188);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,188);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,188);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (288,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (71,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (385,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (505,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (612,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (479,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (177,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (249,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (260,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (44,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (135,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,189);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (193,190);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,191);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (333,191);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,191);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (479,191);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,192);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (187,193);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (199,194);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (200,195);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,196);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (367,197);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,198);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,199);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (202,200);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (575,201);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (207,202);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (205,203);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (204,204);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (207,205);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (465,206);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,207);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (208,208);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (96,208);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (599,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (410,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (64,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (196,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (177,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (499,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (445,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (130,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (13,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (344,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (290,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (17,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (245,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (44,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (223,209);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,210);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,211);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (596,211);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,212);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (545,213);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,214);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (381,215);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (213,216);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (260,217);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,218);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (327,219);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (214,220);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (164,221);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (171,222);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (338,223);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (496,223);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (156,223);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,223);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,223);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,224);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (208,225);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,226);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (40,227);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (54,227);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (209,227);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (24,227);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,227);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (214,227);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (143,227);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (627,227);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (217,228);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,229);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (502,230);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (69,231);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (220,232);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (224,233);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,234);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,234);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,234);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,234);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (226,235);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,236);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (115,237);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (600,238);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,239);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,240);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (20,241);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,241);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,242);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (233,243);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,244);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,245);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (236,246);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (237,247);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,248);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (545,248);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,249);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (186,249);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (574,249);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (239,250);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (241,251);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (243,252);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,253);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,254);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,255);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (435,256);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (367,257);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (111,257);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (96,257);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (246,258);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (248,259);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,260);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,260);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,261);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (347,262);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,262);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (251,263);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (250,264);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (327,265);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,266);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,266);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,266);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (255,267);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,268);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,268);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (256,269);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (330,270);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,271);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,272);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (617,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (271,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (216,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (103,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (230,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (44,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (458,273);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,274);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (262,275);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,276);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (527,276);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,277);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,278);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (264,279);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (609,280);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,280);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (260,281);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,281);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,281);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,282);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,282);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,282);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,282);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,283);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (273,284);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,285);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,285);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,285);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (274,286);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (275,287);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (481,288);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,289);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,290);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (391,291);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (279,292);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (280,293);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,294);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (333,294);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (479,294);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (281,295);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,296);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (349,297);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (366,298);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (127,298);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (283,298);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (229,298);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (285,299);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (366,300);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (127,300);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (410,300);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,300);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,300);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (500,300);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (327,301);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,302);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (617,302);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (117,303);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (208,304);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,305);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,306);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,306);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,306);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,307);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (302,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (410,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (493,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (5,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (479,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (24,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (333,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (432,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (511,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,308);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,309);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (171,310);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,311);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (290,311);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (451,311);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,311);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (511,311);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,311);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,311);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (501,312);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (610,313);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,314);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (291,315);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,316);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (517,317);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (321,318);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,318);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (621,318);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (295,319);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (296,320);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,321);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,321);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (29,321);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,321);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (300,322);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,323);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,323);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,324);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,324);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (410,324);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (499,324);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (432,324);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,324);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (366,325);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,325);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (229,325);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (304,326);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (303,327);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (288,328);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,329);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (164,330);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (308,331);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,332);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,332);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (310,333);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (313,334);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (314,335);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,335);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (315,336);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (316,337);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,338);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,338);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,338);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,339);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (444,340);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,340);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (317,341);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,342);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (143,343);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (321,344);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,344);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,344);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (323,345);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,346);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (404,347);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,348);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,348);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,349);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (329,349);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,349);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,349);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,349);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,350);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (367,351);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,351);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (312,352);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (64,352);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,352);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,353);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (321,353);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,353);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,353);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (463,353);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (426,354);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,355);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (382,356);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (617,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (335,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (459,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (493,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (5,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (259,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (479,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (571,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (333,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (57,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (166,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (432,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (254,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (511,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,357);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,358);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,359);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,359);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,359);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,360);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (336,361);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (260,362);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,362);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,362);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,363);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (329,363);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (189,363);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,363);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (596,363);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (53,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (534,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,364);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (339,365);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,366);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,366);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,367);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,368);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,368);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,368);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,368);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,369);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (321,369);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,369);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,369);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,369);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,369);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,369);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,369);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (502,370);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (64,370);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,371);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (342,372);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,373);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,373);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,373);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,374);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,375);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,375);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,375);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,376);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,376);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,376);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (349,377);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,378);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,378);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,378);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,379);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (53,379);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (69,379);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,380);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,380);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (493,380);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (223,380);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,381);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,382);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,382);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,382);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,382);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (53,382);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,382);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,382);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (354,383);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (288,384);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (260,384);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,384);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,385);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (360,386);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (242,387);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (60,388);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,389);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,390);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (327,390);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,390);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (171,391);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (603,391);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,391);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (363,392);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (365,393);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,394);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,394);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,394);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (164,395);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,396);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,397);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,398);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (370,399);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,400);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (371,401);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (360,402);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (373,403);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (13,404);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,404);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (271,404);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (196,404);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (622,404);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (571,404);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,404);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (117,404);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,404);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (367,405);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,406);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (376,407);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,408);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (377,409);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (485,410);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,411);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,411);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (621,411);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (195,411);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (357,412);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (267,412);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (509,412);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (380,413);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,414);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (381,415);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (410,416);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (493,416);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (5,416);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (479,416);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (333,416);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,416);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (432,416);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,416);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (511,416);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,416);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,417);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (537,417);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (382,418);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,419);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (603,419);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,419);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (321,420);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (410,420);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,420);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (438,420);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,420);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,420);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,420);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (463,420);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,420);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,420);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,421);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (288,422);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (208,422);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (385,422);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (612,422);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (387,423);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (385,424);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,424);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,425);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,425);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (338,426);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (389,426);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (167,426);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (96,426);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (574,427);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (137,428);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (393,429);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (212,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (394,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (321,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (410,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (309,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (53,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (115,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (299,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,430);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (395,431);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,432);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,432);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,432);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (398,433);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,434);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (514,434);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (537,434);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (138,434);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (41,434);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,434);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (403,434);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (135,434);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,435);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (263,436);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (347,437);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,438);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (600,439);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,440);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (404,441);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (405,442);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (459,443);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (347,444);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,444);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (54,445);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (40,445);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,446);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,446);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,446);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (501,447);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,448);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,448);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (29,448);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,448);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (69,448);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,449);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (398,450);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,451);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,452);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (356,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (514,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (335,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (64,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (196,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (571,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (245,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (445,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (254,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (458,453);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (578,454);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (158,455);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (423,456);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,457);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (617,457);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (44,457);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,457);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,458);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,458);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,459);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (419,460);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (426,461);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (429,462);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,463);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (599,464);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (333,464);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (103,464);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,465);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (434,466);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (435,467);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,468);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,468);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,468);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (437,469);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,470);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (502,471);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (312,471);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (444,471);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,471);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (330,471);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (419,471);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (391,471);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (100,472);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (64,472);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,472);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,473);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (450,474);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (407,475);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,475);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,476);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,476);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,477);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,477);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (501,478);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (427,478);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (575,478);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (438,478);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (452,479);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (216,480);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (495,481);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,481);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,482);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (457,483);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (410,484);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,484);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (131,484);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (122,485);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (609,486);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (394,487);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,487);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (115,487);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (527,487);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (403,487);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (597,488);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (54,489);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (40,489);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (461,490);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (462,491);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,492);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (29,492);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,492);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,492);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,492);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (510,493);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (465,494);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (466,495);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,496);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (433,496);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (327,497);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,498);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,499);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,499);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,499);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,500);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,500);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,501);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (137,502);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (367,503);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,503);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (130,503);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,503);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,503);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,503);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,503);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (470,504);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,505);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,506);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,506);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,506);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (186,507);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (474,508);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (64,509);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (478,510);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,511);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,511);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,511);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (495,511);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (57,511);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (67,511);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (44,511);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (498,511);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (130,511);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,511);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,512);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,512);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,513);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,514);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (176,515);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (482,516);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (483,517);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,518);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,518);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (486,519);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (501,520);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (489,521);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (502,522);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (312,522);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (444,522);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (330,522);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (419,522);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (391,522);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,523);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,524);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,525);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,526);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (492,527);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,528);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (617,528);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,528);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (537,528);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,528);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (259,528);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,528);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,529);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,530);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (496,531);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,532);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,533);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,533);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (534,533);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (503,534);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (234,534);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,534);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (367,535);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (444,536);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (356,537);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (622,537);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (508,538);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,539);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (344,539);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,539);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,540);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (510,541);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,542);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,542);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,542);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (145,543);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,544);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (30,545);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,545);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (171,545);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,546);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (513,547);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,548);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,549);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,550);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (92,551);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (516,552);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (288,553);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,553);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (517,554);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (519,555);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (518,556);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (321,557);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,557);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (523,558);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (505,559);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,559);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (356,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (212,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (357,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (514,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (400,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (177,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (481,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (403,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (135,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (13,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (329,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (290,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (527,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (52,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (138,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (20,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (407,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (189,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (223,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (263,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (27,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (537,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (104,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (622,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (306,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (30,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (499,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (624,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (498,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (107,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (41,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (245,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (509,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (78,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (433,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (596,560);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (78,561);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (528,561);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (529,562);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (531,563);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (92,563);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,564);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (321,565);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,565);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,565);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (195,565);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,565);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,566);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (104,566);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,567);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (72,568);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (330,568);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,569);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,570);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,570);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (551,571);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (76,571);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,572);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (230,573);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,573);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,574);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,574);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,575);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,575);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,575);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (263,576);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (367,576);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (78,576);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,576);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,577);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (552,578);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,579);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (555,580);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (56,581);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,581);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (556,582);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,583);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,583);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (559,584);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (188,585);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,586);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (563,587);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (230,588);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,588);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (5,588);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,589);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (79,590);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,591);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,592);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (327,593);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,594);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (91,595);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (568,596);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,597);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (71,597);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (451,597);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,597);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,598);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (130,598);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,598);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (373,599);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,600);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (572,601);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (573,602);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (0,603);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,603);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (7,604);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (578,605);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (579,606);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (294,607);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (299,607);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,607);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,607);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,607);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,607);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,608);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (69,609);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (357,610);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,610);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (309,611);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (479,612);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,613);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (583,614);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,615);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (129,616);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (327,617);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,618);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (586,619);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,620);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (408,621);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (209,621);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (585,621);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (306,622);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (260,623);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (587,624);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,625);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,625);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,625);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (235,626);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (590,627);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (595,628);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (597,629);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (598,630);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,631);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,632);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (27,633);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (603,634);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (604,635);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,636);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (605,637);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (69,638);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (607,639);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,640);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (498,640);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,640);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (263,641);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,641);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (78,641);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,641);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (53,641);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (69,641);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,642);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (44,642);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,642);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,642);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,642);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (143,643);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (610,644);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (602,645);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,645);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,645);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (613,646);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (612,647);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,647);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,648);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,648);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,649);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (463,649);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (615,650);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,650);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,651);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (617,651);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (394,652);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (277,652);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (527,652);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (403,652);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (407,653);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (338,653);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,653);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,653);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (138,653);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (347,653);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (507,653);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,654);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (534,654);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (564,655);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (368,655);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,655);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,656);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (557,657);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,657);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (362,657);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (627,658);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (320,659);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (63,659);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (547,659);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (488,659);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (267,659);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (496,659);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,659);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (534,659);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (288,660);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (208,660);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (29,660);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (396,660);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (385,660);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (576,660);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (612,660);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,661);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (628,662);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (629,663);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (125,664);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (400,665);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,665);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (189,665);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (29,665);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (626,666);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (208,667);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (22,668);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,669);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (17,669);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (166,669);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (526,670);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (624,670);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (533,671);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (378,671);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (130,672);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,673);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (69,673);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,673);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (608,674);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,675);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (617,675);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (30,676);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (41,676);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (171,676);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (430,676);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (167,676);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (292,677);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (207,678);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (457,678);


COMMIT;

